/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.annotation;

import io.swagger.annotations.Extension;
import io.swagger.annotations.License;
import io.swagger.annotations.Scope;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Info;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.util.BaseReaderUtils;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.ClassAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;

public class SwaggerDefinitionProcessor
implements ClassAnnotationProcessor<SwaggerDefinition> {
    @Override
    public Type getProcessType() {
        return SwaggerDefinition.class;
    }

    @Override
    public void process(SwaggerGenerator swaggerGenerator, SwaggerDefinition definitionAnnotation) {
        Swagger swagger = swaggerGenerator.getSwagger();
        if (StringUtils.isNotEmpty((CharSequence)definitionAnnotation.basePath())) {
            swaggerGenerator.setBasePath(definitionAnnotation.basePath());
        }
        if (StringUtils.isNotEmpty((CharSequence)definitionAnnotation.host())) {
            swagger.setHost(definitionAnnotation.host());
        }
        SwaggerUtils.setConsumes(swagger, definitionAnnotation.consumes());
        SwaggerUtils.setProduces(swagger, definitionAnnotation.produces());
        swagger.setSchemes(this.convertSchemes(definitionAnnotation.schemes()));
        swagger.setTags(this.convertTags(definitionAnnotation.tags()));
        swagger.setSecurityDefinitions(this.convertSecurityDefinitions(definitionAnnotation.securityDefinition()));
        swagger.setInfo(this.convertInfo(definitionAnnotation.info()));
        swagger.setExternalDocs(this.convertExternalDocs(definitionAnnotation.externalDocs()));
    }

    private Info convertInfo(io.swagger.annotations.Info infoAnnotation) {
        if (infoAnnotation == null) {
            return null;
        }
        Info info = new Info();
        info.setTitle(infoAnnotation.title());
        info.setVersion(infoAnnotation.version());
        if (StringUtils.isNotEmpty((CharSequence)infoAnnotation.description())) {
            info.setDescription(infoAnnotation.description());
        }
        if (StringUtils.isNotEmpty((CharSequence)infoAnnotation.termsOfService())) {
            info.setTermsOfService(infoAnnotation.termsOfService());
        }
        info.setContact(this.convertContact(infoAnnotation.contact()));
        info.setLicense(this.convertLicense(infoAnnotation.license()));
        info.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])infoAnnotation.extensions()));
        return info;
    }

    private io.swagger.models.License convertLicense(License licenseAnnotation) {
        io.swagger.models.License license = new io.swagger.models.License();
        if (StringUtils.isNotEmpty((CharSequence)licenseAnnotation.name())) {
            license.setName(licenseAnnotation.name());
        }
        if (StringUtils.isNotEmpty((CharSequence)licenseAnnotation.url())) {
            license.setUrl(licenseAnnotation.url());
        }
        if (StringUtils.isEmpty((CharSequence)license.getName()) && StringUtils.isEmpty((CharSequence)license.getUrl())) {
            return null;
        }
        return license;
    }

    private Contact convertContact(io.swagger.annotations.Contact contactAnnotation) {
        Contact contact = new Contact();
        if (StringUtils.isNotEmpty((CharSequence)contactAnnotation.name())) {
            contact.setName(contactAnnotation.name());
        }
        if (StringUtils.isNotEmpty((CharSequence)contactAnnotation.url())) {
            contact.setUrl(contactAnnotation.url());
        }
        if (StringUtils.isNotEmpty((CharSequence)contactAnnotation.email())) {
            contact.setEmail(contactAnnotation.email());
        }
        if (StringUtils.isEmpty((CharSequence)contact.getName()) && StringUtils.isEmpty((CharSequence)contact.getUrl()) && StringUtils.isEmpty((CharSequence)contact.getEmail())) {
            return null;
        }
        return contact;
    }

    private List<Tag> convertTags(io.swagger.annotations.Tag[] tagArray) {
        if (tagArray == null) {
            return null;
        }
        List<Tag> tags = Arrays.stream(tagArray).filter(t -> !t.name().isEmpty()).map(this::convertTag).collect(Collectors.toList());
        return tags.isEmpty() ? null : tags;
    }

    private Tag convertTag(io.swagger.annotations.Tag tagAnnotation) {
        Tag tag = new Tag();
        tag.setName(tagAnnotation.name());
        tag.setDescription(tagAnnotation.description());
        tag.setExternalDocs(this.convertExternalDocs(tagAnnotation.externalDocs()));
        tag.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])tagAnnotation.extensions()));
        return tag;
    }

    private ExternalDocs convertExternalDocs(io.swagger.annotations.ExternalDocs annotationExternalDocs) {
        ExternalDocs externalDocs = new ExternalDocs();
        if (StringUtils.isNotEmpty((CharSequence)annotationExternalDocs.url())) {
            externalDocs.setUrl(annotationExternalDocs.url());
        }
        if (StringUtils.isNotEmpty((CharSequence)annotationExternalDocs.value())) {
            externalDocs.setDescription(annotationExternalDocs.value());
        }
        if (StringUtils.isEmpty((CharSequence)externalDocs.getUrl()) && StringUtils.isEmpty((CharSequence)externalDocs.getDescription())) {
            return null;
        }
        return externalDocs;
    }

    private List<Scheme> convertSchemes(SwaggerDefinition.Scheme[] schemeArray) {
        if (schemeArray == null) {
            return null;
        }
        return Arrays.stream(schemeArray).map(this::convertScheme).collect(Collectors.toList());
    }

    private Scheme convertScheme(SwaggerDefinition.Scheme annotationScheme) {
        if (SwaggerDefinition.Scheme.DEFAULT.equals((Object)annotationScheme)) {
            return Scheme.HTTP;
        }
        return Scheme.forValue((String)annotationScheme.name());
    }

    private Map<String, SecuritySchemeDefinition> convertSecurityDefinitions(SecurityDefinition securityDefinition) {
        LinkedHashMap<String, SecuritySchemeDefinition> definitionMap = new LinkedHashMap<String, SecuritySchemeDefinition>();
        Arrays.stream(securityDefinition.oAuth2Definitions()).forEach(annotation -> this.addSecurityDefinition(definitionMap, annotation.key(), (SecuritySchemeDefinition)this.convertOAuth2((io.swagger.annotations.OAuth2Definition)annotation)));
        Arrays.stream(securityDefinition.apiKeyAuthDefinitions()).forEach(annotation -> this.addSecurityDefinition(definitionMap, annotation.key(), this.convertApiKey((io.swagger.annotations.ApiKeyAuthDefinition)annotation)));
        Arrays.stream(securityDefinition.basicAuthDefinitions()).forEach(annotation -> this.addSecurityDefinition(definitionMap, annotation.key(), this.convertBasicAuth((io.swagger.annotations.BasicAuthDefinition)annotation)));
        return definitionMap.isEmpty() ? null : definitionMap;
    }

    private void addSecurityDefinition(Map<String, SecuritySchemeDefinition> definitionMap, String key, SecuritySchemeDefinition definition) {
        if (StringUtils.isEmpty((CharSequence)key) || definition == null) {
            return;
        }
        definitionMap.put(key, definition);
    }

    private String emptyAsNull(@Nonnull String value) {
        return value.isEmpty() ? null : value;
    }

    private OAuth2Definition convertOAuth2(io.swagger.annotations.OAuth2Definition annotation) {
        OAuth2Definition definition = new OAuth2Definition();
        definition.setDescription(this.emptyAsNull(annotation.description()));
        definition.setFlow(this.emptyAsNull(annotation.flow().name()));
        definition.setAuthorizationUrl(this.emptyAsNull(annotation.authorizationUrl()));
        definition.setTokenUrl(this.emptyAsNull(annotation.tokenUrl()));
        for (Scope scope : annotation.scopes()) {
            if (StringUtils.isEmpty((CharSequence)scope.name())) continue;
            definition.addScope(scope.name(), scope.description());
        }
        if (definition.getDescription() == null && definition.getFlow() == null && definition.getAuthorizationUrl() == null && definition.getTokenUrl() == null && definition.getScopes() == null) {
            return null;
        }
        return definition;
    }

    private SecuritySchemeDefinition convertApiKey(io.swagger.annotations.ApiKeyAuthDefinition annotation) {
        if (StringUtils.isEmpty((CharSequence)annotation.name())) {
            return null;
        }
        ApiKeyAuthDefinition definition = new ApiKeyAuthDefinition();
        definition.setDescription(this.emptyAsNull(annotation.description()));
        definition.setIn(In.forValue((String)annotation.in().name()));
        definition.setName(annotation.name());
        return definition;
    }

    private SecuritySchemeDefinition convertBasicAuth(io.swagger.annotations.BasicAuthDefinition annotation) {
        if (annotation.description().isEmpty()) {
            return null;
        }
        BasicAuthDefinition definition = new BasicAuthDefinition();
        definition.setDescription(annotation.description());
        return definition;
    }
}

