/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.discovery;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.shenyu.admin.discovery.DiscoveryMode;
import org.apache.shenyu.admin.discovery.DiscoveryProcessor;

public class DiscoveryProcessorHolder {
    private final DiscoveryProcessor defaultDiscoveryProcessor;
    private final DiscoveryProcessor localDiscoveryProcessor;
    private final DiscoveryProcessor apDiscoveryProcessor;

    public DiscoveryProcessorHolder(DiscoveryProcessor defaultDiscoveryProcessor, DiscoveryProcessor localDiscoveryProcessor, DiscoveryProcessor apDiscoveryProcessor) {
        this.defaultDiscoveryProcessor = defaultDiscoveryProcessor;
        this.localDiscoveryProcessor = localDiscoveryProcessor;
        this.apDiscoveryProcessor = apDiscoveryProcessor;
    }

    public DiscoveryProcessor chooseProcessor(String mode) {
        if (DiscoveryMode.LOCAL.name().equalsIgnoreCase(mode)) {
            return this.localDiscoveryProcessor;
        }
        if (DiscoveryMode.ZOOKEEPER.name().equalsIgnoreCase(mode)) {
            return this.defaultDiscoveryProcessor;
        }
        if (DiscoveryMode.ETCD.name().equalsIgnoreCase(mode)) {
            return this.defaultDiscoveryProcessor;
        }
        if (DiscoveryMode.NACOS.name().equalsIgnoreCase(mode)) {
            return this.defaultDiscoveryProcessor;
        }
        if (DiscoveryMode.EUREKA.name().equalsIgnoreCase(mode)) {
            return this.apDiscoveryProcessor;
        }
        throw new NotImplementedException("shenyu discovery mode current didn't support " + mode);
    }
}

