/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.io.grpc.netty;

import java.net.InetSocketAddress;
import shade.polaris.io.grpc.Internal;
import shade.polaris.io.grpc.ServerCredentials;
import shade.polaris.io.grpc.ServerProvider;
import shade.polaris.io.grpc.netty.NettyServerBuilder;
import shade.polaris.io.grpc.netty.ProtocolNegotiators;

@Internal
public final class NettyServerProvider
extends ServerProvider {
    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 5;
    }

    protected NettyServerBuilder builderForPort(int port) {
        return NettyServerBuilder.forPort(port);
    }

    @Override
    protected ServerProvider.NewServerBuilderResult newServerBuilderForPort(int port, ServerCredentials creds) {
        ProtocolNegotiators.FromServerCredentialsResult result = ProtocolNegotiators.from(creds);
        if (result.error != null) {
            return ServerProvider.NewServerBuilderResult.error(result.error);
        }
        return ServerProvider.NewServerBuilderResult.serverBuilder(new NettyServerBuilder(new InetSocketAddress(port), result.negotiator));
    }
}

