/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractFieldAdaptorSerializer;
import com.caucho.hessian.io.AbstractHessianOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.logging.Level;

public class AbstractStringBuilderSerializer
extends AbstractFieldAdaptorSerializer {
    private static final boolean ENABLE = AbstractStringBuilderSerializer.judgeAvailability();

    public static boolean isEnable() {
        return ENABLE;
    }

    public AbstractStringBuilderSerializer(Class cl) {
        super(cl);
        for (Field field : this._fields) {
            try {
                field.setAccessible(true);
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "unable to set field {} accessible", field.getName());
            }
        }
    }

    @Override
    protected void serializeField(AbstractHessianOutput out, Object obj, Field field) throws IOException {
        if ("value".equals(field.getName())) {
            this.serializeValueArray(out, obj);
        } else {
            this.serializeNormalField(out, obj, field);
        }
    }

    protected void serializeValueArray(AbstractHessianOutput out, Object obj) throws IOException {
        if (obj instanceof StringBuilder) {
            StringBuilder sb = (StringBuilder)obj;
            char[] dst = new char[sb.capacity()];
            sb.getChars(0, sb.length(), dst, 0);
            out.writeString(dst, 0, dst.length);
        } else if (obj instanceof StringBuffer) {
            StringBuffer sb = (StringBuffer)obj;
            char[] dst = new char[sb.capacity()];
            sb.getChars(0, sb.length(), dst, 0);
            out.writeString(dst, 0, dst.length);
        } else {
            throw new UnsupportedOperationException("only support AbstractStringBuilder but got " + obj.getClass());
        }
    }

    private void serializeNormalField(AbstractHessianOutput out, Object obj, Field field) throws IOException {
        Object value = null;
        try {
            value = field.get(obj);
        }
        catch (IllegalAccessException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        out.writeObject(value);
    }

    private static boolean judgeAvailability() {
        Field field = null;
        try {
            field = String.class.getDeclaredField("value");
        }
        catch (Throwable t) {
            return false;
        }
        return byte[].class.equals(field.getType());
    }
}

