/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.asyncprofiler;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.agent.core.asyncprofiler.AsyncProfilerTaskExecutionService;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.DefaultNamedThreadFactory;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.commands.CommandService;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelListener;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelManager;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelStatus;
import org.apache.skywalking.apm.dependencies.io.grpc.Channel;
import org.apache.skywalking.apm.dependencies.io.grpc.Status;
import org.apache.skywalking.apm.dependencies.io.grpc.StatusRuntimeException;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.language.asyncprofiler.v10.AsyncProfilerTaskCommandQuery;
import org.apache.skywalking.apm.network.language.asyncprofiler.v10.AsyncProfilerTaskGrpc;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;

@DefaultImplementor
public class AsyncProfilerTaskChannelService
implements BootService,
Runnable,
GRPCChannelListener {
    private static final ILog LOGGER = LogManager.getLogger(AsyncProfilerTaskChannelService.class);
    private volatile GRPCChannelStatus status = GRPCChannelStatus.DISCONNECT;
    private volatile AsyncProfilerTaskGrpc.AsyncProfilerTaskBlockingStub asyncProfilerTaskBlockingStub;
    private volatile ScheduledFuture<?> getTaskFuture;

    @Override
    public void run() {
        block4: {
            if (this.status == GRPCChannelStatus.CONNECTED) {
                try {
                    long lastCommandCreateTime = ServiceManager.INSTANCE.findService(AsyncProfilerTaskExecutionService.class).getLastCommandCreateTime();
                    AsyncProfilerTaskCommandQuery query = AsyncProfilerTaskCommandQuery.newBuilder().setServiceInstance(Config.Agent.INSTANCE_NAME).setService(Config.Agent.SERVICE_NAME).setLastCommandTime(lastCommandCreateTime).build();
                    Commands commands = ((AsyncProfilerTaskGrpc.AsyncProfilerTaskBlockingStub)this.asyncProfilerTaskBlockingStub.withDeadlineAfter(Config.Collector.GRPC_UPSTREAM_TIMEOUT, TimeUnit.SECONDS)).getAsyncProfilerTaskCommands(query);
                    ServiceManager.INSTANCE.findService(CommandService.class).receiveCommand(commands);
                }
                catch (Throwable t) {
                    if (!(t instanceof StatusRuntimeException)) {
                        LOGGER.error(t, "fail to query async-profiler task from backend", new Object[0]);
                        return;
                    }
                    StatusRuntimeException statusRuntimeException = (StatusRuntimeException)t;
                    if (!Status.Code.UNIMPLEMENTED.equals((Object)statusRuntimeException.getStatus().getCode())) break block4;
                    LOGGER.warn("Backend doesn't support async-profiler, async-profiler will be disabled", new Object[0]);
                    if (this.getTaskFuture == null) break block4;
                    this.getTaskFuture.cancel(true);
                }
            }
        }
    }

    @Override
    public void statusChanged(GRPCChannelStatus status) {
        if (GRPCChannelStatus.CONNECTED.equals((Object)status)) {
            Channel channel = ServiceManager.INSTANCE.findService(GRPCChannelManager.class).getChannel();
            this.asyncProfilerTaskBlockingStub = AsyncProfilerTaskGrpc.newBlockingStub(channel);
        } else {
            this.asyncProfilerTaskBlockingStub = null;
        }
        this.status = status;
    }

    @Override
    public void prepare() throws Throwable {
        ServiceManager.INSTANCE.findService(GRPCChannelManager.class).addChannelListener(this);
    }

    @Override
    public void boot() throws Throwable {
        if (Config.AsyncProfiler.ACTIVE) {
            this.getTaskFuture = Executors.newSingleThreadScheduledExecutor(new DefaultNamedThreadFactory("AsyncProfilerGetTaskService")).scheduleWithFixedDelay(new RunnableWithExceptionProtection(this, t -> LOGGER.error("Query async profiler task list failure.", t)), 0L, Config.Collector.GET_PROFILE_TASK_INTERVAL, TimeUnit.SECONDS);
        }
    }

    @Override
    public void onComplete() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
        if (this.getTaskFuture != null) {
            this.getTaskFuture.cancel(true);
        }
    }
}

