/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.mvc.v6;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.RuntimeContext;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.InstanceMethodsAroundInterceptorV2;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.MethodInvocationContext;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class InvokeInterceptor
implements InstanceMethodsAroundInterceptorV2 {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInvocationContext context) throws Throwable {
        ServerWebExchange exchange = (ServerWebExchange)allArguments[0];
        ServerHttpResponse response = exchange.getResponse();
        AbstractSpan[] ref = new AbstractSpan[1];
        RuntimeContext runtimeContext = ContextManager.getRuntimeContext();
        runtimeContext.put((Object)"SW_REACTIVE_RESPONSE_ASYNC_SPAN", (Object)ref);
        runtimeContext.put((Object)"SW_RESPONSE", (Object)response);
        runtimeContext.put((Object)"SW_REQUEST", (Object)exchange.getRequest());
        context.setContext((Object)ref);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret, MethodInvocationContext context) throws Throwable {
        ServerWebExchange exchange = (ServerWebExchange)allArguments[0];
        return ((Mono)ret).doFinally(s -> {
            Object ctx = context.getContext();
            if (ctx == null) {
                return;
            }
            AbstractSpan span = ((AbstractSpan[])ctx)[0];
            if (span == null) {
                return;
            }
            HttpStatusCode httpStatus = exchange.getResponse().getStatusCode();
            if (httpStatus != null) {
                Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(httpStatus.value()));
                if (httpStatus.isError()) {
                    span.errorOccurred();
                }
            }
            span.asyncFinish();
        });
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t, MethodInvocationContext context) {
    }
}

