/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.console;

import jakarta.servlet.Filter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import org.apache.sling.engine.impl.filter.FilterHandle;
import org.apache.sling.engine.impl.filter.ServletFilterManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.service.http.runtime.dto.ServletContextDTO;

@Component(service={WebConsoleConfigPrinter.class}, property={"felix.webconsole.label=slingfilter", "felix.webconsole.title=Sling Servlet Filter", "felix.webconsole.configprinter.modes=always"})
public class WebConsoleConfigPrinter {
    private final BundleContext bundleContext;
    private final ServletFilterManager filterManager;
    private final HttpServiceRuntime httpServiceRuntime;

    @Activate
    public WebConsoleConfigPrinter(BundleContext bundleContext, @Reference ServletFilterManager filterManager, @Reference HttpServiceRuntime httpServiceRuntime) {
        this.bundleContext = bundleContext;
        this.filterManager = filterManager;
        this.httpServiceRuntime = httpServiceRuntime;
    }

    private static boolean isRelevantContext(ServletContextDTO ctx) {
        return "org.apache.sling".equals(ctx.name);
    }

    private String getServiceRanking(long serviceId) {
        ServiceReference ref = null;
        try {
            Collection refs = this.bundleContext.getServiceReferences(Filter.class, "(service.id=" + serviceId + ")");
            if (refs.isEmpty()) {
                Collection javaxRefs = this.bundleContext.getServiceReferences(javax.servlet.Filter.class, "(service.id=" + serviceId + ")");
                if (!javaxRefs.isEmpty()) {
                    ref = (ServiceReference)javaxRefs.iterator().next();
                }
            } else {
                ref = (ServiceReference)refs.iterator().next();
            }
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Invalid syntax given to lookup service", e);
        }
        if (ref != null) {
            Object ranking = ref.getProperty("service.ranking");
            return ranking != null ? ranking.toString() : "0";
        }
        return "?";
    }

    private void printOsgiHttpWhiteboardFilters(PrintWriter pw, ServletContextDTO ctx) {
        pw.println();
        pw.printf("OSGi Http Whiteboard Filters for Context %s:%n", ctx.name);
        Arrays.stream(ctx.filterDTOs).forEach(filter -> pw.printf("%s : %s (id: %d)%n", this.getServiceRanking(filter.serviceId), filter.name, filter.serviceId));
    }

    private void printOsgiHttpWhiteboardFilters(PrintWriter pw) {
        Arrays.stream(this.httpServiceRuntime.getRuntimeDTO().servletContextDTOs).filter(ctx -> WebConsoleConfigPrinter.isRelevantContext(ctx)).forEach(ctx -> this.printOsgiHttpWhiteboardFilters(pw, (ServletContextDTO)ctx));
    }

    private void printFilterChain(PrintWriter pw, FilterHandle[] entries) {
        for (FilterHandle entry : entries) {
            pw.printf("%d : %s (id: %d, property: %s); called: %d; time: %dms; time/call: %d\u00b5s%n", entry.getOrder(), entry.getWrappedJavaxFilter().map(f -> "Jakarta wrapper for " + String.valueOf(f.getClass())).orElse(entry.getFilter().getClass().toString()), entry.getFilterId(), entry.getOrderSource(), entry.getCalls(), entry.getTime(), entry.getTimePerCall());
        }
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println("Current Apache Sling Servlet Filter Configuration");
        this.printOsgiHttpWhiteboardFilters(pw);
        for (ServletFilterManager.FilterChainType type : ServletFilterManager.FilterChainType.values()) {
            pw.println();
            pw.println("Sling " + String.valueOf((Object)type) + " Filters:");
            this.printFilterChain(pw, this.filterManager.getFilterChain(type).getFilters());
        }
    }
}

