/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.valuegenerator;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.valuegenerator.AbstractRDBMSGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public final class SequenceGenerator
extends AbstractRDBMSGenerator<Long> {
    protected String sequenceName = null;

    public SequenceGenerator(String name, Properties props) {
        super(name, props);
        this.allocationSize = 1;
        if (this.properties != null) {
            if (this.properties.get("key-increment-by") != null) {
                try {
                    this.allocationSize = Integer.parseInt((String)this.properties.get("key-increment-by"));
                }
                catch (Exception e) {
                    throw new ValueGenerationException(Localiser.msg((String)"040006", (Object[])new Object[]{this.properties.get("key-increment-by")}));
                }
            }
            if (this.properties.get("key-cache-size") != null) {
                try {
                    this.allocationSize = Integer.parseInt((String)this.properties.get("key-cache-size"));
                }
                catch (Exception e) {
                    throw new ValueGenerationException(Localiser.msg((String)"040006", (Object[])new Object[]{this.properties.get("key-cache-size")}));
                }
            }
            if (this.properties.get("sequence-name") == null) {
                throw new ValueGenerationException(Localiser.msg((String)"040007", (Object[])new Object[]{this.properties.get("sequence-name")}));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized ValueGenerationBlock<Long> reserveBlock(long size) {
        ValueGenerationBlock valueGenerationBlock;
        if (size < 1L) {
            return null;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<Long> oid = new ArrayList<Long>();
        RDBMSStoreManager srm = (RDBMSStoreManager)this.storeMgr;
        SQLController sqlControl = srm.getSQLController();
        try {
            DatastoreAdapter dba = srm.getDatastoreAdapter();
            String stmt = dba.getSequenceNextStmt(this.getSequenceName());
            ps = sqlControl.getStatementForQuery(this.connection, stmt);
            rs = sqlControl.executeStatementQuery(null, this.connection, stmt, ps);
            Long nextId = 0L;
            if (rs.next()) {
                nextId = rs.getLong(1);
                oid.add(nextId);
            }
            int i = 1;
            while ((long)i < size) {
                nextId = nextId + 1L;
                oid.add(nextId);
                ++i;
            }
            if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
                NucleusLogger.VALUEGENERATION.debug((Object)Localiser.msg((String)"040004", (Object[])new Object[]{"" + size}));
            }
            valueGenerationBlock = new ValueGenerationBlock(oid);
        }
        catch (SQLException e) {
            try {
                throw new ValueGenerationException(Localiser.msg((String)"061001", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps == null) throw throwable;
                    sqlControl.closeStatement(this.connection, ps);
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (ps == null) return valueGenerationBlock;
            sqlControl.closeStatement(this.connection, ps);
            return valueGenerationBlock;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return valueGenerationBlock;
    }

    protected String getSequenceName() {
        if (this.sequenceName == null) {
            String sequenceSchemaName;
            String sequenceCatalogName = this.properties.getProperty("sequence-catalog-name");
            if (sequenceCatalogName == null) {
                sequenceCatalogName = this.properties.getProperty("catalog-name");
            }
            if ((sequenceSchemaName = this.properties.getProperty("sequence-schema-name")) == null) {
                sequenceSchemaName = this.properties.getProperty("schema-name");
            }
            String sequenceName = this.properties.getProperty("sequence-name");
            RDBMSStoreManager srm = (RDBMSStoreManager)this.storeMgr;
            DatastoreAdapter dba = srm.getDatastoreAdapter();
            DatastoreIdentifier identifier = srm.getIdentifierFactory().newSequenceIdentifier(sequenceName);
            if (dba.supportsOption("CatalogInTableDefinition") && sequenceCatalogName != null) {
                identifier.setCatalogName(sequenceCatalogName);
            }
            if (dba.supportsOption("SchemaInTableDefinition") && sequenceSchemaName != null) {
                identifier.setSchemaName(sequenceSchemaName);
            }
            this.sequenceName = identifier.getFullyQualifiedName(true);
        }
        return this.sequenceName;
    }

    protected boolean requiresRepository() {
        return true;
    }

    protected boolean repositoryExists() {
        String sequenceSchemaName;
        String sequenceCatalogName = this.properties.getProperty("sequence-catalog-name");
        if (sequenceCatalogName == null) {
            sequenceCatalogName = this.properties.getProperty("catalog-name");
        }
        if (!StringUtils.isWhitespace((String)sequenceCatalogName)) {
            IdentifierFactory idFactory = ((RDBMSStoreManager)this.storeMgr).getIdentifierFactory();
            sequenceCatalogName = idFactory.getIdentifierInAdapterCase(sequenceCatalogName);
        }
        if ((sequenceSchemaName = this.properties.getProperty("sequence-schema-name")) == null) {
            sequenceSchemaName = this.properties.getProperty("schema-name");
        }
        if (!StringUtils.isWhitespace((String)sequenceSchemaName)) {
            IdentifierFactory idFactory = ((RDBMSStoreManager)this.storeMgr).getIdentifierFactory();
            sequenceSchemaName = idFactory.getIdentifierInAdapterCase(sequenceSchemaName);
        }
        String seqName = this.properties.getProperty("sequence-name");
        IdentifierFactory idFactory = ((RDBMSStoreManager)this.storeMgr).getIdentifierFactory();
        seqName = idFactory.getIdentifierInAdapterCase(seqName);
        return ((RDBMSStoreManager)this.storeMgr).getDatastoreAdapter().sequenceExists((Connection)this.connection.getConnection(), sequenceCatalogName, sequenceSchemaName, seqName);
    }

    protected boolean createRepository() {
        PreparedStatement ps = null;
        RDBMSStoreManager srm = (RDBMSStoreManager)this.storeMgr;
        DatastoreAdapter dba = srm.getDatastoreAdapter();
        SQLController sqlControl = srm.getSQLController();
        if (!srm.getSchemaHandler().isAutoCreateTables()) {
            throw new NucleusUserException(Localiser.msg((String)"040010", (Object[])new Object[]{this.getSequenceName()}));
        }
        Integer min = this.properties.containsKey("key-min-value") ? Integer.valueOf(this.properties.getProperty("key-min-value")) : null;
        Integer max = this.properties.containsKey("key-max-value") ? Integer.valueOf(this.properties.getProperty("key-max-value")) : null;
        Integer start = this.properties.containsKey("key-initial-value") ? Integer.valueOf(this.properties.getProperty("key-initial-value")) : null;
        Integer incr = this.properties.containsKey("key-cache-size") ? Integer.valueOf(this.properties.getProperty("key-cache-size")) : null;
        Integer cacheSize = this.properties.containsKey("key-database-cache-size") ? Integer.valueOf(this.properties.getProperty("key-database-cache-size")) : null;
        String stmt = dba.getSequenceCreateStmt(this.getSequenceName(), min, max, start, incr, cacheSize);
        try {
            ps = sqlControl.getStatementForUpdate(this.connection, stmt, false);
            sqlControl.executeStatementUpdate(null, this.connection, stmt, ps, true);
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            throw new ValueGenerationException(Localiser.msg((String)"061000", (Object[])new Object[]{e.getMessage()}) + stmt);
        }
        finally {
            try {
                if (ps != null) {
                    sqlControl.closeStatement(this.connection, ps);
                }
            }
            catch (SQLException sQLException) {}
        }
        return true;
    }
}

