/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class ExpressionWalker
extends DefaultGraphWalker {
    public ExpressionWalker(Dispatcher disp) {
        super(disp);
    }

    private boolean shouldByPass(Node childNode, Node parentNode) {
        if (parentNode instanceof ASTNode && ((ASTNode)parentNode).getType() == 942) {
            ASTNode parentOp = (ASTNode)parentNode;
            assert (parentOp.getChildCount() == 2 || parentOp.getChildCount() == 3);
            return parentOp.getChildCount() != 3 || (ASTNode)childNode != parentOp.getChild(2);
        }
        return false;
    }

    @Override
    protected void walk(Node nd) throws SemanticException {
        this.opStack.push(nd);
        block0: while (!this.opStack.empty()) {
            Node node = (Node)this.opStack.peek();
            if (node.getChildren() == null || this.getDispatchedList().containsAll(node.getChildren())) {
                if (!this.getDispatchedList().contains(node)) {
                    this.dispatch(node, this.opStack);
                    this.opQueue.add(node);
                }
                this.opStack.pop();
                continue;
            }
            for (Node node2 : node.getChildren()) {
                if (this.getDispatchedList().contains(node2)) continue;
                if (this.shouldByPass(node2, node)) {
                    this.retMap.put(node2, null);
                    continue block0;
                }
                this.opStack.push(node2);
                continue block0;
            }
        }
    }
}

