/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetArrayItem;
import org.apache.spark.sql.catalyst.expressions.GetArrayItem$;
import org.apache.spark.sql.catalyst.expressions.GetArrayStructFields;
import org.apache.spark.sql.catalyst.expressions.GetMapValue;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NonNullLiteral$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ExtractValue$ {
    public static final ExtractValue$ MODULE$ = new ExtractValue$();

    public Expression apply(Expression child, Expression extraction, Function2<String, String, Object> resolver) {
        Either<Expression, Throwable> either = this.extractValue(child, extraction, resolver);
        if (either instanceof Left) {
            Left left = (Left)either;
            Expression expression = (Expression)left.value();
            return expression;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Throwable throwable = (Throwable)right.value();
            throw throwable;
        }
        throw new MatchError(either);
    }

    public Either<Expression, Throwable> extractValue(Expression child, Expression extraction, Function2<String, String, Object> resolver) {
        DataType dataType;
        Tuple2 tuple2 = new Tuple2((Object)child.dataType(), (Object)extraction);
        if (tuple2 != null) {
            DataType dataType2 = (DataType)tuple2._1();
            Expression expression = (Expression)tuple2._2();
            if (dataType2 instanceof StructType) {
                Literal literal;
                Option<Tuple2<Object, DataType>> option;
                StructType structType = (StructType)dataType2;
                StructField[] fields = structType.fields();
                if (expression instanceof Literal && !(option = NonNullLiteral$.MODULE$.unapply(literal = (Literal)expression)).isEmpty()) {
                    Object v = ((Tuple2)option.get())._1();
                    if (((Tuple2)option.get())._2() instanceof StringType) {
                        String fieldName = v.toString();
                        Either<Object, Throwable> either = this.findField(fields, fieldName, resolver);
                        if (either instanceof Left) {
                            Left left = (Left)either;
                            int ordinal = BoxesRunTime.unboxToInt((Object)left.value());
                            return new Left((Object)new GetStructField(child, ordinal, (Option<String>)new Some((Object)fieldName)));
                        }
                        if (either instanceof Right) {
                            Right right = (Right)either;
                            Throwable throwable = (Throwable)right.value();
                            return new Right((Object)throwable);
                        }
                        throw new MatchError(either);
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType3 = (DataType)tuple2._1();
            Expression expression = (Expression)tuple2._2();
            if (dataType3 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType3;
                DataType dataType4 = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                if (dataType4 instanceof StructType) {
                    Literal literal;
                    Option<Tuple2<Object, DataType>> option;
                    StructType structType = (StructType)dataType4;
                    StructField[] fields = structType.fields();
                    if (expression instanceof Literal && !(option = NonNullLiteral$.MODULE$.unapply(literal = (Literal)expression)).isEmpty()) {
                        Object v = ((Tuple2)option.get())._1();
                        if (((Tuple2)option.get())._2() instanceof StringType) {
                            String fieldName = v.toString();
                            Either<Object, Throwable> either = this.findField(fields, fieldName, resolver);
                            if (either instanceof Left) {
                                Left left = (Left)either;
                                int ordinal = BoxesRunTime.unboxToInt((Object)left.value());
                                StructField qual$1 = fields[ordinal];
                                String x$1 = fieldName;
                                DataType x$2 = qual$1.copy$default$2();
                                boolean x$3 = qual$1.copy$default$3();
                                Metadata x$4 = qual$1.copy$default$4();
                                return new Left((Object)new GetArrayStructFields(child, qual$1.copy(x$1, x$2, x$3, x$4), ordinal, fields.length, containsNull || fields[ordinal].nullable()));
                            }
                            if (either instanceof Right) {
                                Right right = (Right)either;
                                Throwable throwable = (Throwable)right.value();
                                return new Right((Object)throwable);
                            }
                            throw new MatchError(either);
                        }
                    }
                }
            }
        }
        if (tuple2 != null && tuple2._1() instanceof ArrayType) {
            return new Left((Object)new GetArrayItem(child, extraction, GetArrayItem$.MODULE$.apply$default$3()));
        }
        if (tuple2 != null && (dataType = (DataType)tuple2._1()) instanceof MapType) {
            return new Left((Object)new GetMapValue(child, extraction));
        }
        if (tuple2 != null) {
            return new Right((Object)QueryCompilationErrors$.MODULE$.dataTypeUnsupportedByExtractValueError(child.dataType(), extraction, child));
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean isExtractable(Attribute attribute, Seq<String> nestedFields, Option<Expression> extractorKey, Function2<String, String, Object> resolver) {
        Option withExtractedNestedFields = (Option)nestedFields.foldLeft((Object)new Some((Object)attribute), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                String field = (String)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Expression expression = (Expression)some.value();
                    Either<Expression, Throwable> either = MODULE$.extractValue(expression, Literal$.MODULE$.apply(field), resolver);
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Expression e = (Expression)left.value();
                        return new Some((Object)e);
                    }
                    if (either instanceof Right) {
                        return None$.MODULE$;
                    }
                    throw new MatchError(either);
                }
            }
            return None$.MODULE$;
        });
        boolean bl = false;
        Some some = null;
        Option option = withExtractedNestedFields;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Expression nestedField = (Expression)some.value();
            if (extractorKey.isDefined()) {
                Either<Expression, Throwable> either = this.extractValue(nestedField, (Expression)extractorKey.get(), resolver);
                if (either instanceof Left) {
                    return true;
                }
                if (either instanceof Right) {
                    return false;
                }
                throw new MatchError(either);
            }
        }
        if (bl) {
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public Option<Expression> isExtractable$default$3() {
        return None$.MODULE$;
    }

    private Either<Object, Throwable> findField(StructField[] fields, String fieldName, Function2<String, String, Object> resolver) {
        int x$2;
        Function1 & Serializable x$1;
        Function1 & Serializable checkField = (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ExtractValue$.$anonfun$findField$1(resolver, fieldName, f));
        Object qual$1 = Predef$.MODULE$.refArrayOps((Object[])fields);
        int ordinal = ArrayOps$.MODULE$.indexWhere$extension(qual$1, (Function1)(x$1 = checkField), x$2 = ArrayOps$.MODULE$.indexWhere$default$2$extension(qual$1));
        if (ordinal == -1) {
            return new Right((Object)QueryCompilationErrors$.MODULE$.noSuchStructFieldInGivenFieldsError(fieldName, fields));
        }
        if (ArrayOps$.MODULE$.indexWhere$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1)checkField, ordinal + 1) != -1) {
            int numberOfAppearance = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1)checkField);
            return new Right((Object)QueryCompilationErrors$.MODULE$.ambiguousReferenceToFieldsError(fieldName, numberOfAppearance));
        }
        return new Left((Object)BoxesRunTime.boxToInteger((int)ordinal));
    }

    public static final /* synthetic */ boolean $anonfun$findField$1(Function2 resolver$2, String fieldName$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$2.apply((Object)f.name(), (Object)fieldName$1));
    }

    private ExtractValue$() {
    }
}

