/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RowOrdering$;
import org.apache.spark.sql.catalyst.expressions.SortArray$;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.types.PhysicalDataType$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(array[, ascendingOrder]) - Sorts the input array in ascending or descending order\n      according to the natural ordering of the array elements. NaN is greater than any non-NaN\n      elements for double/float type. Null elements will be placed at the beginning of the returned\n      array in ascending order or at the end of the returned array in descending order.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'), true);\n       [null,\"a\",\"b\",\"c\",\"d\"]\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'), false);\n       [\"d\",\"c\",\"b\",\"a\",null]\n  ", group="array_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\t\rd\u0001\u0002\u0015*\u0001ZB\u0001B\u0016\u0001\u0003\u0016\u0004%\ta\u0016\u0005\t7\u0002\u0011\t\u0012)A\u00051\"AA\f\u0001BK\u0002\u0013\u0005q\u000b\u0003\u0005^\u0001\tE\t\u0015!\u0003Y\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015q\u0006\u0001\"\u0001i\u0011\u0015Y\u0007\u0001\"\u0011X\u0011\u0015a\u0007\u0001\"\u0011X\u0011\u0015i\u0007\u0001\"\u0011o\u0011\u0015)\b\u0001\"\u0011w\u0011\u0015i\b\u0001\"\u0011\u007f\u0011)\tY\u0001\u0001EC\u0002\u0013%\u0011Q\u0002\u0005\u000b\u0003[\u0001\u0001R1A\u0005\n\u00055\u0001\"CA\u0019\u0001!\u0015\r\u0011\"\u0001o\u0011\u0019\t)\u0004\u0001C\u0005I\"9\u0011q\u0007\u0001\u0005\n\u0005e\u0002bBA\"\u0001\u0011%\u0011Q\t\u0005\b\u0003o\u0002A\u0011IA=\u0011\u001d\ty\b\u0001C!\u0003\u0003Cq!a\"\u0001\t\u0003\nI\tC\u0004\u0002\f\u0002!\t&!$\t\u0013\u0005]\u0005!!A\u0005\u0002\u0005e\u0005\"CAP\u0001E\u0005I\u0011AAQ\u0011%\t9\fAI\u0001\n\u0003\t\t\u000bC\u0005\u0002:\u0002\t\t\u0011\"\u0011\u0002<\"I\u0011q\u0019\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001a\u0005\n\u0003#\u0004\u0011\u0011!C\u0001\u0003'D\u0011\"!7\u0001\u0003\u0003%\t%a7\t\u0013\u0005%\b!!A\u0005\u0002\u0005-\b\"CAx\u0001\u0005\u0005I\u0011IAy\u0011%\t)\u0010AA\u0001\n\u0003\n9pB\u0005\u0003\u001c%\n\t\u0011#\u0001\u0003\u001e\u0019A\u0001&KA\u0001\u0012\u0003\u0011y\u0002\u0003\u0004_E\u0011\u0005!q\u0007\u0005\n\u0005s\u0011\u0013\u0011!C#\u0005wA\u0011B!\u0010#\u0003\u0003%\tIa\u0010\t\u0013\t\u0015#%!A\u0005\u0002\n\u001d\u0003\"\u0003B-E\u0005\u0005I\u0011\u0002B.\u0005%\u0019vN\u001d;BeJ\f\u0017P\u0003\u0002+W\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\taS&\u0001\u0005dCR\fG._:u\u0015\tqs&A\u0002tc2T!\u0001M\u0019\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u001a\u0014AB1qC\u000eDWMC\u00015\u0003\ry'oZ\u0002\u0001'\u0019\u0001qg\u000f E\u0015B\u0011\u0001(O\u0007\u0002S%\u0011!(\u000b\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001\u000f\u001f\n\u0005uJ#!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011)L\u0001\u0007KJ\u0014xN]:\n\u0005\r\u0003%aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\u000fA\u0013x\u000eZ;diB\u00111j\u0015\b\u0003\u0019Fs!!\u0014)\u000e\u00039S!aT\u001b\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0015B\u0001*G\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001V+\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005I3\u0015\u0001\u00022bg\u0016,\u0012\u0001\u0017\t\u0003qeK!AW\u0015\u0003\u0015\u0015C\bO]3tg&|g.A\u0003cCN,\u0007%\u0001\bbg\u000e,g\u000eZ5oO>\u0013H-\u001a:\u0002\u001f\u0005\u001c8-\u001a8eS:<wJ\u001d3fe\u0002\na\u0001P5oSRtDc\u00011bEB\u0011\u0001\b\u0001\u0005\u0006-\u0016\u0001\r\u0001\u0017\u0005\u00069\u0016\u0001\r\u0001W\u0001\u000f]VdG.\u00138u_2,'/\u00198u+\u0005)\u0007CA#g\u0013\t9gIA\u0004C_>dW-\u00198\u0015\u0005\u0001L\u0007\"\u00026\b\u0001\u0004A\u0016!A3\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e^\u0001\tI\u0006$\u0018\rV=qKV\tq\u000e\u0005\u0002qg6\t\u0011O\u0003\u0002s[\u0005)A/\u001f9fg&\u0011A/\u001d\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003]\u00042a\u0013={\u0013\tIXKA\u0002TKF\u0004\"\u0001]>\n\u0005q\f(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005y\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u00151&\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\tI!a\u0001\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f!\u0001\u001c;\u0016\u0005\u0005=\u0001CBA\t\u00037\ty\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0011)H/\u001b7\u000b\u0005\u0005e\u0011\u0001\u00026bm\u0006LA!!\b\u0002\u0014\tQ1i\\7qCJ\fGo\u001c:\u0011\u0007\u0015\u000b\t#C\u0002\u0002$\u0019\u00131!\u00118zQ\ri\u0011q\u0005\t\u0004\u000b\u0006%\u0012bAA\u0016\r\nIAO]1og&,g\u000e^\u0001\u0003ORD3ADA\u0014\u0003-)G.Z7f]R$\u0016\u0010]3)\u0007=\t9#\u0001\u000esKN,H\u000e^!se\u0006LX\t\\3nK:$h*\u001e7mC\ndW-\u0001\u0005t_J$XI^1m)\u0019\ty\"a\u000f\u0002@!9\u0011QH\tA\u0002\u0005}\u0011!B1se\u0006L\bBBA!#\u0001\u0007Q-A\u0005bg\u000e,g\u000eZ5oO\u0006Y1o\u001c:u\u0007>$WmZ3o))\t9%a\u0016\u0002h\u0005E\u00141\u000f\t\u0005\u0003\u0013\n\tF\u0004\u0003\u0002L\u00055\u0003CA'G\u0013\r\tyER\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0013Q\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=c\tC\u0004\u0002ZI\u0001\r!a\u0017\u0002\u0007\r$\b\u0010\u0005\u0003\u0002^\u0005\rTBAA0\u0015\r\t\t'K\u0001\bG>$WmZ3o\u0013\u0011\t)'a\u0018\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011\u0011\u000e\nA\u0002\u0005-\u0014AA3w!\u0011\ti&!\u001c\n\t\u0005=\u0014q\f\u0002\t\u000bb\u0004(oQ8eK\"1aK\u0005a\u0001\u0003\u000fBq!!\u001e\u0013\u0001\u0004\t9%A\u0003pe\u0012,'/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0004\u0002 \u0005m\u0014Q\u0010\u0005\b\u0003{\u0019\u0002\u0019AA\u0010\u0011\u001d\t\te\u0005a\u0001\u0003?\t\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005-\u00141QAC\u0011\u001d\tI\u0006\u0006a\u0001\u00037Bq!!\u001b\u0015\u0001\u0004\tY'\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u0012\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#\u00021\u0002\u0010\u0006M\u0005BBAI-\u0001\u0007\u0001,A\u0004oK^dUM\u001a;\t\r\u0005Ue\u00031\u0001Y\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$R\u0001YAN\u0003;CqAV\f\u0011\u0002\u0003\u0007\u0001\fC\u0004]/A\u0005\t\u0019\u0001-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0015\u0016\u00041\u0006\u00156FAAT!\u0011\tI+a-\u000e\u0005\u0005-&\u0002BAW\u0003_\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Ef)\u0001\u0006b]:|G/\u0019;j_:LA!!.\u0002,\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!0\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003TA!a1\u0002\u0018\u0005!A.\u00198h\u0013\u0011\t\u0019&!1\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005-\u0007cA#\u0002N&\u0019\u0011q\u001a$\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u0011Q\u001b\u0005\n\u0003/d\u0012\u0011!a\u0001\u0003\u0017\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAo!\u0019\ty.!:\u0002 5\u0011\u0011\u0011\u001d\u0006\u0004\u0003G4\u0015AC2pY2,7\r^5p]&!\u0011q]Aq\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\u0015\fi\u000fC\u0005\u0002Xz\t\t\u00111\u0001\u0002 \u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\ti,a=\t\u0013\u0005]w$!AA\u0002\u0005-\u0017AB3rk\u0006d7\u000fF\u0002f\u0003sD\u0011\"a6!\u0003\u0003\u0005\r!a\b)'\u0001\tiPa\u0001\u0003\u0006\t%!1\u0002B\b\u0005#\u0011)Ba\u0006\u0011\u0007a\ny0C\u0002\u0003\u0002%\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003\b\u0005\u00119P\u0003\u0011!A\u0001zf)\u0016(D?\"\n'O]1z72\u0002\u0013m]2f]\u0012LgnZ(sI\u0016\u0014X,\u000b\u0011.AM{'\u000f^:!i\",\u0007%\u001b8qkR\u0004\u0013M\u001d:bs\u0002Jg\u000eI1tG\u0016tG-\u001b8hA=\u0014\b\u0005Z3tG\u0016tG-\u001b8hA=\u0014H-\u001a:\u000bA\u0001\u0002\u0003\u0005\t\u0011bG\u000e|'\u000fZ5oO\u0002\"x\u000e\t;iK\u0002r\u0017\r^;sC2\u0004sN\u001d3fe&tw\rI8gAQDW\rI1se\u0006L\b%\u001a7f[\u0016tGo\u001d\u0018!\u001d\u0006t\u0005%[:!OJ,\u0017\r^3sAQD\u0017M\u001c\u0011b]f\u0004cn\u001c8.\u001d\u0006t%\u0002\t\u0011!A\u0001\u0002S\r\\3nK:$8\u000f\t4pe\u0002\"w.\u001e2mK>2Gn\\1uAQL\b/\u001a\u0018!\u001dVdG\u000eI3mK6,g\u000e^:!o&dG\u000e\t2fAAd\u0017mY3eA\u0005$\b\u0005\u001e5fA\t,w-\u001b8oS:<\u0007e\u001c4!i\",\u0007E]3ukJtW\r\u001a\u0006!A\u0001\u0002\u0003\u0005I1se\u0006L\b%\u001b8!CN\u001cWM\u001c3j]\u001e\u0004sN\u001d3fe\u0002z'\u000fI1uAQDW\rI3oI\u0002zg\r\t;iK\u0002\u0012X\r^;s]\u0016$\u0007%\u0019:sCf\u0004\u0013N\u001c\u0011eKN\u001cWM\u001c3j]\u001e\u0004sN\u001d3fe:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!QB\u0001\u0002\u0016*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\":#m\n\u0017!O\u0011<C\u0006\t8vY2d\u0003eJ2(Y\u0001:\u0013mJ\u0015-AQ\u0014X/Z\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AmsW\u000f\u001c7-E\u0005\u0014CF\t2#Y\t\u001a'\u0005\f\u0012eEuS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfDsEY\u0014-A\u001d\"w\u0005\f\u0011ok2dG\u0006I\u0014dO1\u0002s%Y\u0014*Y\u00012\u0017\r\\:fSmR\u0001\u0005\t\u0011!A\u0001\u00023L\t3#Y\t\u001a'\u0005\f\u0012cE1\u0012\u0013M\t\u0017ok2dWL\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011\u0019\"A\u0006beJ\f\u0017p\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B\r\u0003\u0015\td&\u000e\u00181\u0003%\u0019vN\u001d;BeJ\f\u0017\u0010\u0005\u00029EM)!E!\t\u0003.A9!1\u0005B\u00151b\u0003WB\u0001B\u0013\u0015\r\u00119CR\u0001\beVtG/[7f\u0013\u0011\u0011YC!\n\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u00030\tURB\u0001B\u0019\u0015\u0011\u0011\u0019$a\u0006\u0002\u0005%|\u0017b\u0001+\u00032Q\u0011!QD\u0001\ti>\u001cFO]5oOR\u0011\u0011QX\u0001\u0006CB\u0004H.\u001f\u000b\u0006A\n\u0005#1\t\u0005\u0006-\u0016\u0002\r\u0001\u0017\u0005\u00069\u0016\u0002\r\u0001W\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IE!\u0016\u0011\u000b\u0015\u0013YEa\u0014\n\u0007\t5cI\u0001\u0004PaRLwN\u001c\t\u0006\u000b\nE\u0003\fW\u0005\u0004\u0005'2%A\u0002+va2,'\u0007\u0003\u0005\u0003X\u0019\n\t\u00111\u0001a\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005;\u0002B!a0\u0003`%!!\u0011MAa\u0005\u0019y%M[3di\u0002")
public class SortArray
extends BinaryExpression
implements ExpectsInputTypes,
QueryErrorsBase,
Serializable {
    private transient Comparator<Object> lt;
    private transient Comparator<Object> gt;
    private transient DataType elementType;
    private final Expression base;
    private final Expression ascendingOrder;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(SortArray x$0) {
        return SortArray$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, SortArray> tupled() {
        return SortArray$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, SortArray>> curried() {
        return SortArray$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    public Expression base() {
        return this.base;
    }

    public Expression ascendingOrder() {
        return this.ascendingOrder;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression left() {
        return this.base();
    }

    @Override
    public Expression right() {
        return this.ascendingOrder();
    }

    @Override
    public DataType dataType() {
        return this.base().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)ArrayType$.MODULE$, (List)new .colon.colon((Object)BooleanType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        boolean bl = false;
        ArrayType arrayType = null;
        DataType dataType = this.base().dataType();
        if (dataType instanceof ArrayType) {
            bl = true;
            arrayType = (ArrayType)dataType;
            DataType dt = arrayType.elementType();
            if (RowOrdering$.MODULE$.isOrderable(dt)) {
                if (!this.ascendingOrder().foldable()) {
                    return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)this.toSQLId("ascendingOrder")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.ascendingOrder().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.toSQLExpr(this.ascendingOrder()))}))));
                }
                DataType dataType2 = this.ascendingOrder().dataType();
                BooleanType$ booleanType$ = BooleanType$.MODULE$;
                if (dataType2 == null ? booleanType$ != null : !dataType2.equals(booleanType$)) {
                    return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)BooleanType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.ascendingOrder())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.ascendingOrder().dataType()))}))));
                }
                return TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
        }
        if (bl) {
            return new TypeCheckResult.DataTypeMismatch("INVALID_ORDERING_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)this.base().dataType()))}))));
        }
        return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.base())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.base().dataType()))}))));
    }

    private Comparator<Object> lt$lzycompute() {
        SortArray sortArray = this;
        synchronized (sortArray) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                DataType dataType = this.base().dataType();
                if (!(dataType instanceof ArrayType)) {
                    throw new MatchError((Object)dataType);
                }
                ArrayType arrayType = (ArrayType)dataType;
                DataType n = arrayType.elementType();
                Ordering<Object> ordering = PhysicalDataType$.MODULE$.ordering(n);
                this.lt = (o1, o2) -> {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return ordering.compare(o1, o2);
                };
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.lt;
    }

    private Comparator<Object> lt() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.lt$lzycompute();
        }
        return this.lt;
    }

    private Comparator<Object> gt$lzycompute() {
        SortArray sortArray = this;
        synchronized (sortArray) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                DataType dataType = this.base().dataType();
                if (!(dataType instanceof ArrayType)) {
                    throw new MatchError((Object)dataType);
                }
                ArrayType arrayType = (ArrayType)dataType;
                DataType n = arrayType.elementType();
                Ordering<Object> ordering = PhysicalDataType$.MODULE$.ordering(n);
                this.gt = (o1, o2) -> {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    return ordering.compare(o2, o1);
                };
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.gt;
    }

    private Comparator<Object> gt() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.gt$lzycompute();
        }
        return this.gt;
    }

    private DataType elementType$lzycompute() {
        SortArray sortArray = this;
        synchronized (sortArray) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.elementType = ((ArrayType)this.base().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    private boolean resultArrayElementNullable() {
        return ((ArrayType)this.base().dataType()).containsNull();
    }

    private Object sortEval(Object array, boolean ascending) {
        Object[] data = (Object[])((ArrayData)array).toArray(this.elementType(), ClassTag$.MODULE$.AnyRef());
        DataType dataType = this.elementType();
        NullType$ nullType$ = NullType$.MODULE$;
        if (dataType == null ? nullType$ != null : !dataType.equals(nullType$)) {
            Arrays.parallelSort(data, ascending ? this.lt() : this.gt());
        }
        return new GenericArrayData(data);
    }

    /*
     * Unable to fully structure code
     */
    private String sortCodegen(CodegenContext ctx, ExprCode ev, String base, String order) {
        genericArrayData = GenericArrayData.class.getName();
        unsafeArrayData = UnsafeArrayData.class.getName();
        array = ctx.freshName("array");
        c = ctx.freshName("c");
        v0 = this.elementType();
        var9_9 = NullType$.MODULE$;
        if (!(v0 != null ? v0.equals(var9_9) == false : var9_9 != null)) {
            return ev.value() + " = " + base + ".copy();";
        }
        elementTypeTerm = ctx.addReferenceObj("elementTypeTerm", this.elementType(), ctx.addReferenceObj$default$3());
        sortOrder = ctx.freshName("sortOrder");
        o1 = ctx.freshName("o1");
        o2 = ctx.freshName("o2");
        jt = CodeGenerator$.MODULE$.javaType(this.elementType());
        if (CodeGenerator$.MODULE$.isPrimitiveType(this.elementType())) {
            bt = CodeGenerator$.MODULE$.boxedType(this.elementType());
            v1 = ctx.freshName("v1");
            v2 = ctx.freshName("v2");
            v1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |" + jt + " " + v1 + " = ((" + bt + ") " + o1 + ")." + jt + "Value();\n           |" + jt + " " + v2 + " = ((" + bt + ") " + o2 + ")." + jt + "Value();\n           |int " + c + " = " + ctx.genComp(this.elementType(), v1, v2) + ";\n         "));
        } else {
            v1 = comp = "int " + c + " = " + ctx.genComp(this.elementType(), "((" + jt + ") " + o1 + ")", "((" + jt + ") " + o2 + ")") + ";";
        }
        if (!CodeGenerator$.MODULE$.isPrimitiveType(this.elementType())) ** GOTO lbl-1000
        v2 = this.elementType();
        var20_19 = BooleanType$.MODULE$;
        if ((v2 == null ? var20_19 != null : v2.equals(var20_19) == false) && !this.resultArrayElementNullable()) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = canPerformFastSort = false;
        }
        if (canPerformFastSort) {
            javaType = CodeGenerator$.MODULE$.javaType(this.elementType());
            primitiveTypeName = CodeGenerator$.MODULE$.primitiveTypeName(this.elementType());
            v4 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |if (" + order + ") {\n           |  " + javaType + "[] " + array + " = " + base + ".to" + primitiveTypeName + "Array();\n           |  java.util.Arrays.parallelSort(" + array + ");\n           |  " + ev.value() + " = " + unsafeArrayData + ".fromPrimitiveArray(" + array + ");\n           |} else\n           "));
        } else {
            v4 = "";
        }
        nonNullPrimitiveAscendingSort = v4;
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + nonNullPrimitiveAscendingSort + "\n         |{\n         |  Object[] " + array + " = " + base + ".toObjectArray(" + elementTypeTerm + ");\n         |  final int " + sortOrder + " = " + order + " ? 1 : -1;\n         |  java.util.Arrays.parallelSort(" + array + ", new java.util.Comparator() {\n         |    @Override public int compare(Object " + o1 + ", Object " + o2 + ") {\n         |      if (" + o1 + " == null && " + o2 + " == null) {\n         |        return 0;\n         |      } else if (" + o1 + " == null) {\n         |        return -" + sortOrder + ";\n         |      } else if (" + o2 + " == null) {\n         |        return " + sortOrder + ";\n         |      }\n         |      " + comp + "\n         |      return " + sortOrder + " * " + c + ";\n         |    }\n         |  });\n         |  " + ev.value() + " = new " + genericArrayData + "(" + array + ");\n         |}\n       "));
    }

    @Override
    public Object nullSafeEval(Object array, Object ascending) {
        return this.sortEval(array, BoxesRunTime.unboxToBoolean((Object)ascending));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(b, order) -> this.sortCodegen(ctx, ev, (String)b, (String)order));
    }

    @Override
    public String prettyName() {
        return "sort_array";
    }

    @Override
    public SortArray withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public SortArray copy(Expression base, Expression ascendingOrder) {
        return new SortArray(base, ascendingOrder);
    }

    public Expression copy$default$1() {
        return this.base();
    }

    public Expression copy$default$2() {
        return this.ascendingOrder();
    }

    @Override
    public String productPrefix() {
        return "SortArray";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.base();
            }
            case 1: {
                return this.ascendingOrder();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SortArray;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "base";
            }
            case 1: {
                return "ascendingOrder";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SortArray)) return false;
        boolean bl = true;
        if (!bl) return false;
        SortArray sortArray = (SortArray)x$1;
        Expression expression = this.base();
        Expression expression2 = sortArray.base();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.ascendingOrder();
        Expression expression4 = sortArray.ascendingOrder();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sortArray.canEqual(this)) return false;
        return true;
    }

    public SortArray(Expression base, Expression ascendingOrder) {
        this.base = base;
        this.ascendingOrder = ascendingOrder;
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }

    public SortArray(Expression e) {
        this(e, Literal$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)true)));
    }
}

