/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical.statsEstimation;

import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.DefaultValueInterval;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils$;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.NullValueInterval;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.NumericValueInterval;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.ValueInterval;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;

public final class ValueInterval$ {
    public static final ValueInterval$ MODULE$ = new ValueInterval$();

    public ValueInterval apply(Option<Object> min, Option<Object> max, DataType dataType) {
        DataType dataType2 = dataType;
        if (StringType$.MODULE$.equals(dataType2) ? true : BinaryType$.MODULE$.equals(dataType2)) {
            return new DefaultValueInterval();
        }
        if (min.isEmpty() || max.isEmpty()) {
            return new NullValueInterval();
        }
        return new NumericValueInterval(EstimationUtils$.MODULE$.toDouble(min.get(), dataType), EstimationUtils$.MODULE$.toDouble(max.get(), dataType));
    }

    public boolean isIntersected(ValueInterval r1, ValueInterval r2) {
        Tuple2 tuple2 = new Tuple2((Object)r1, (Object)r2);
        if (tuple2 != null && tuple2._2() instanceof DefaultValueInterval ? true : tuple2 != null && tuple2._1() instanceof DefaultValueInterval) {
            return true;
        }
        if (tuple2 != null && tuple2._2() instanceof NullValueInterval ? true : tuple2 != null && tuple2._1() instanceof NullValueInterval) {
            return false;
        }
        if (tuple2 != null) {
            ValueInterval n1 = (ValueInterval)tuple2._1();
            ValueInterval n2 = (ValueInterval)tuple2._2();
            if (n1 instanceof NumericValueInterval) {
                NumericValueInterval numericValueInterval = (NumericValueInterval)n1;
                if (n2 instanceof NumericValueInterval) {
                    NumericValueInterval numericValueInterval2 = (NumericValueInterval)n2;
                    return Predef$.MODULE$.double2Double(numericValueInterval.min()).compareTo(Predef$.MODULE$.double2Double(numericValueInterval2.max())) <= 0 && Predef$.MODULE$.double2Double(numericValueInterval.max()).compareTo(Predef$.MODULE$.double2Double(numericValueInterval2.min())) >= 0;
                }
            }
        }
        throw QueryExecutionErrors$.MODULE$.pairUnsupportedAtFunctionError(r1, r2, "isIntersected");
    }

    public Tuple2<Option<Object>, Option<Object>> intersect(ValueInterval r1, ValueInterval r2, DataType dt) {
        Tuple2 tuple2 = new Tuple2((Object)r1, (Object)r2);
        if (tuple2 != null && tuple2._2() instanceof DefaultValueInterval ? true : tuple2 != null && tuple2._1() instanceof DefaultValueInterval) {
            return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        if (tuple2 != null) {
            ValueInterval n1 = (ValueInterval)tuple2._1();
            ValueInterval n2 = (ValueInterval)tuple2._2();
            if (n1 instanceof NumericValueInterval) {
                NumericValueInterval numericValueInterval = (NumericValueInterval)n1;
                if (n2 instanceof NumericValueInterval) {
                    NumericValueInterval numericValueInterval2 = (NumericValueInterval)n2;
                    double newMin = numericValueInterval.min() <= numericValueInterval2.min() ? numericValueInterval2.min() : numericValueInterval.min();
                    double newMax = numericValueInterval.max() <= numericValueInterval2.max() ? numericValueInterval.max() : numericValueInterval2.max();
                    return new Tuple2((Object)new Some(EstimationUtils$.MODULE$.fromDouble(newMin, dt)), (Object)new Some(EstimationUtils$.MODULE$.fromDouble(newMax, dt)));
                }
            }
        }
        throw QueryExecutionErrors$.MODULE$.pairUnsupportedAtFunctionError(r1, r2, "intersect");
    }

    private ValueInterval$() {
    }
}

