/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AsOfVersion;
import org.apache.spark.sql.catalyst.analysis.TimeTravelSpec;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.V2TableUtil$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.ExtractV2CatalogAndIdentifier$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

public final class V2TableRefreshUtil$
implements SQLConfHelper,
Logging {
    public static final V2TableRefreshUtil$ MODULE$ = new V2TableRefreshUtil$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        SQLConfHelper.$init$(MODULE$);
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public LogicalPlan pinVersions(LogicalPlan plan2) {
        return (LogicalPlan)plan2.transform(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                DataSourceV2Relation dataSourceV2Relation;
                Option<Tuple2<TableCatalog, Identifier>> option;
                A1 A1 = x1;
                if (A1 instanceof DataSourceV2Relation && !(option = ExtractV2CatalogAndIdentifier$.MODULE$.unapply(dataSourceV2Relation = (DataSourceV2Relation)A1)).isEmpty()) {
                    TableCatalog catalog = (TableCatalog)((Tuple2)option.get())._1();
                    Identifier ident = (Identifier)((Tuple2)option.get())._2();
                    if (dataSourceV2Relation.table().currentVersion() != null && dataSourceV2Relation.timeTravelSpec().isEmpty()) {
                        String tableName = V2TableUtil$.MODULE$.toQualifiedName(catalog, ident);
                        String version = dataSourceV2Relation.table().currentVersion();
                        V2TableRefreshUtil$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Pinning table version for " + tableName + " to " + version);
                        Some x$1 = new Some((Object)new AsOfVersion(version));
                        Table x$2 = dataSourceV2Relation.copy$default$1();
                        Seq<AttributeReference> x$3 = dataSourceV2Relation.copy$default$2();
                        Option<CatalogPlugin> x$4 = dataSourceV2Relation.copy$default$3();
                        Option<Identifier> x$5 = dataSourceV2Relation.copy$default$4();
                        CaseInsensitiveStringMap x$6 = dataSourceV2Relation.copy$default$5();
                        return (B1)dataSourceV2Relation.copy(x$2, x$3, x$4, x$5, x$6, (Option<TimeTravelSpec>)x$1);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                DataSourceV2Relation dataSourceV2Relation;
                Option<Tuple2<TableCatalog, Identifier>> option;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof DataSourceV2Relation && !(option = ExtractV2CatalogAndIdentifier$.MODULE$.unapply(dataSourceV2Relation = (DataSourceV2Relation)logicalPlan)).isEmpty() && dataSourceV2Relation.table().currentVersion() != null && dataSourceV2Relation.timeTravelSpec().isEmpty();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.String java.lang.String )}, serializedLambda);
            }
        });
    }

    public LogicalPlan refreshVersions(LogicalPlan plan2) {
        HashMap cache = HashMap$.MODULE$.empty();
        return (LogicalPlan)plan2.transform(new Serializable(cache){
            private static final long serialVersionUID = 0L;
            private final HashMap cache$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                DataSourceV2Relation dataSourceV2Relation;
                Option<Tuple2<TableCatalog, Identifier>> option;
                A1 A1 = x1;
                if (A1 instanceof DataSourceV2Relation && !(option = ExtractV2CatalogAndIdentifier$.MODULE$.unapply(dataSourceV2Relation = (DataSourceV2Relation)A1)).isEmpty()) {
                    TableCatalog catalog = (TableCatalog)((Tuple2)option.get())._1();
                    Identifier ident = (Identifier)((Tuple2)option.get())._2();
                    if (dataSourceV2Relation.table().currentVersion() != null && dataSourceV2Relation.timeTravelSpec().isEmpty()) {
                        Table currentTable = (Table)this.cache$1.getOrElseUpdate((Object)new Tuple2((Object)catalog, (Object)ident), (Function0 & Serializable)() -> {
                            String tableName = V2TableUtil$.MODULE$.toQualifiedName(catalog, ident);
                            V2TableRefreshUtil$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Refreshing table metadata for " + tableName);
                            return catalog.loadTable(ident);
                        });
                        V2TableRefreshUtil$.MODULE$.org$apache$spark$sql$execution$datasources$v2$V2TableRefreshUtil$$validateTableIdentity(currentTable, dataSourceV2Relation);
                        V2TableRefreshUtil$.MODULE$.org$apache$spark$sql$execution$datasources$v2$V2TableRefreshUtil$$validateDataColumns(currentTable, dataSourceV2Relation);
                        V2TableRefreshUtil$.MODULE$.org$apache$spark$sql$execution$datasources$v2$V2TableRefreshUtil$$validateMetadataColumns(currentTable, dataSourceV2Relation);
                        return (B1)dataSourceV2Relation.copy(currentTable, dataSourceV2Relation.copy$default$2(), dataSourceV2Relation.copy$default$3(), dataSourceV2Relation.copy$default$4(), dataSourceV2Relation.copy$default$5(), dataSourceV2Relation.copy$default$6());
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                DataSourceV2Relation dataSourceV2Relation;
                Option<Tuple2<TableCatalog, Identifier>> option;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof DataSourceV2Relation && !(option = ExtractV2CatalogAndIdentifier$.MODULE$.unapply(dataSourceV2Relation = (DataSourceV2Relation)logicalPlan)).isEmpty() && dataSourceV2Relation.table().currentVersion() != null && dataSourceV2Relation.timeTravelSpec().isEmpty();
            }
            {
                this.cache$1 = cache$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.sql.connector.catalog.TableCatalog org.apache.spark.sql.connector.catalog.Identifier ), $anonfun$applyOrElse$3(java.lang.String )}, serializedLambda);
            }
        });
    }

    public void org$apache$spark$sql$execution$datasources$v2$V2TableRefreshUtil$$validateTableIdentity(Table currentTable, DataSourceV2Relation relation) {
        if (relation.table().id() != null) {
            String string = relation.table().id();
            String string2 = currentTable.id();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw QueryCompilationErrors$.MODULE$.tableIdChangedAfterAnalysis(relation.name(), relation.table().id(), currentTable.id());
            }
        }
    }

    public void org$apache$spark$sql$execution$datasources$v2$V2TableRefreshUtil$$validateDataColumns(Table currentTable, DataSourceV2Relation relation) {
        Seq<String> errors = V2TableUtil$.MODULE$.validateCapturedColumns(currentTable, relation);
        if (errors.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.columnsChangedAfterAnalysis(relation.name(), errors);
        }
    }

    public void org$apache$spark$sql$execution$datasources$v2$V2TableRefreshUtil$$validateMetadataColumns(Table currentTable, DataSourceV2Relation relation) {
        Seq<String> errors = V2TableUtil$.MODULE$.validateCapturedMetadataColumns(currentTable, relation);
        if (errors.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.metadataColumnsChangedAfterAnalysis(relation.name(), errors);
        }
    }

    private V2TableRefreshUtil$() {
    }
}

