/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* Generated By:JJTree: Do not edit this line. AstInteger.java */
package org.apache.el.parser;

import java.math.BigInteger;

import jakarta.el.ELException;

import org.apache.el.lang.EvaluationContext;

public final class AstInteger extends SimpleNode {

    public AstInteger(int id) {
        super(id);
    }


    private volatile Number number;


    protected Number getInteger() {
        // The parser should ensure the format of the string to be parsed
        if (this.number == null) {
            try {
                try {
                    this.number = Long.valueOf(this.image);
                } catch (NumberFormatException ignore) {
                    // Too large for Long. Try BigInteger.
                    this.number = new BigInteger(this.image);
                }
            } catch (ArithmeticException | NumberFormatException e) {
                // Too big for BigInteger.
                // Catch NumberFormatException as well here just in case the
                // parser provides invalid input.
                throw new ELException(e);
            }
        }
        return number;
    }


    @Override
    public Class<?> getType(EvaluationContext ctx) throws ELException {
        return this.getInteger().getClass();
    }


    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        return this.getInteger();
    }
}
