/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.apache.catalina.mbeans.BaseCatalinaMBean;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.NamingResources;
import org.apache.tomcat.util.res.StringManager;

public class ContextResourceMBean
extends BaseCatalinaMBean<ContextResource> {
    private static final StringManager sm = StringManager.getManager(ContextResourceMBean.class);

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("mBean.nullName")), sm.getString("mBean.nullName"));
        }
        ContextResource cr = (ContextResource)this.doGetManagedResource();
        switch (name) {
            case "auth": {
                return cr.getAuth();
            }
            case "description": {
                return cr.getDescription();
            }
            case "name": {
                return cr.getName();
            }
            case "scope": {
                return cr.getScope();
            }
            case "type": {
                return cr.getType();
            }
        }
        String value = (String)cr.getProperty(name);
        if (value == null) {
            throw new AttributeNotFoundException(sm.getString("mBean.attributeNotFound", new Object[]{name}));
        }
        return value;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("mBean.nullAttribute")), sm.getString("mBean.nullAttribute"));
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("mBean.nullName")), sm.getString("mBean.nullName"));
        }
        ContextResource cr = (ContextResource)this.doGetManagedResource();
        switch (name) {
            case "auth": {
                cr.setAuth((String)value);
                break;
            }
            case "description": {
                cr.setDescription((String)value);
                break;
            }
            case "name": {
                cr.setName((String)value);
                break;
            }
            case "scope": {
                cr.setScope((String)value);
                break;
            }
            case "type": {
                cr.setType((String)value);
                break;
            }
            default: {
                cr.setProperty(name, (Object)String.valueOf(value));
            }
        }
        NamingResources nr = cr.getNamingResources();
        nr.removeResource(cr.getName());
        nr.addResource(cr);
    }
}

