/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.impl;

import jakarta.enterprise.concurrent.ManageableThread;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.openejb.threads.impl.ContextServiceImpl;
import org.apache.openejb.threads.impl.ContextServiceImplFactory;
import org.apache.openejb.threads.task.CURunnable;

public class ManagedThreadFactoryImpl
implements ManagedThreadFactory {
    public static final String DEFAULT_PREFIX = "managed-thread-";
    private static final AtomicInteger ID = new AtomicInteger();
    private final ContextServiceImpl contextService;
    private final String prefix;
    private final Integer priority;

    public ManagedThreadFactoryImpl() {
        this(DEFAULT_PREFIX, 5, ContextServiceImplFactory.getOrCreateDefaultSingleton());
    }

    public ManagedThreadFactoryImpl(String prefix, Integer priority, ContextServiceImpl contextService) {
        this.prefix = prefix;
        this.priority = priority;
        this.contextService = contextService;
    }

    public Thread newThread(Runnable r) {
        CURunnable wrapper = new CURunnable(r, this.contextService);
        ManagedThread thread = new ManagedThread(wrapper);
        thread.setDaemon(true);
        thread.setName(this.prefix + ID.incrementAndGet());
        thread.setContextClassLoader(ManagedThreadFactoryImpl.class.getClassLoader());
        if (this.priority != null) {
            thread.setPriority(this.priority);
        }
        return thread;
    }

    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        return new ManagedForkJoinWorkerThread(pool, this.priority, this.contextService);
    }

    public static class ManagedThread
    extends Thread
    implements ManageableThread {
        public ManagedThread(Runnable r) {
            super(r);
        }

        public boolean isShutdown() {
            return this.getState() == Thread.State.TERMINATED;
        }
    }

    public static class ManagedForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        private final ContextServiceImpl contextService;
        private final Integer priority;
        private final ContextServiceImpl.Snapshot snapshot;
        private ContextServiceImpl.State state;
        private Integer initialPriority;

        protected ManagedForkJoinWorkerThread(ForkJoinPool pool, Integer priority, ContextServiceImpl contextService) {
            super(pool);
            this.priority = priority;
            this.contextService = contextService;
            this.snapshot = contextService.snapshot(null);
        }

        @Override
        protected void onStart() {
            super.onStart();
            this.initialPriority = this.getPriority();
            if (this.priority != null) {
                this.setPriority(this.priority);
            }
            this.contextService.enter(this.snapshot);
        }

        @Override
        protected void onTermination(Throwable exception) {
            this.setPriority(this.initialPriority);
            this.contextService.exit(this.state);
            super.onTermination(exception);
        }
    }
}

