/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.instrumentation.jmx;

import javax.management.ObjectName;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.instrumentation.AbstractDataCacheInstrument;
import org.apache.openjpa.instrumentation.jmx.DataCacheJMXInstrumentMBean;
import org.apache.openjpa.instrumentation.jmx.JMXInstrument;
import org.apache.openjpa.instrumentation.jmx.JMXProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.instrumentation.InstrumentationLevel;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.util.UserException;

public class DataCacheJMXInstrument
extends AbstractDataCacheInstrument
implements JMXInstrument,
DataCacheJMXInstrumentMBean {
    private static Localizer _loc = Localizer.forPackage(DataCacheJMXInstrument.class);
    private static final String MBEAN_TYPE = "DataCache";
    private ObjectName _objName = null;

    @Override
    public String getName() {
        return MBEAN_TYPE;
    }

    @Override
    public InstrumentationLevel getLevel() {
        return InstrumentationLevel.FACTORY;
    }

    @Override
    public void initialize() {
        Options opts = new Options();
        if (this.getOptions() != null) {
            opts = Configurations.parseProperties(this.getOptions());
        }
        String cacheName = opts.getProperty("name", null);
        OpenJPAConfiguration conf = (OpenJPAConfiguration)this.getProvider().getConfiguration();
        DataCacheManager dcm = conf.getDataCacheManagerInstance();
        DataCache dc = null;
        dc = cacheName == null || cacheName.trim().length() == 0 ? dcm.getSystemDataCache() : dcm.getDataCache(cacheName);
        if (dc == null) {
            throw new UserException(_loc.get("data-cache-not-found"));
        }
        this.setDataCache(dc);
        this.setDataCacheManager(dcm);
        this.setConfigId(conf.getId());
        this.setContextRef(Integer.toString(System.identityHashCode(this.getContext())));
    }

    @Override
    public ObjectName getObjectName() {
        if (this._objName != null) {
            return this._objName;
        }
        try {
            this._objName = JMXProvider.createObjectName(this, null);
            return this._objName;
        }
        catch (Throwable t) {
            throw new UserException(_loc.get("unable-to-create-object-name", this.getName()), t);
        }
    }

    @Override
    public void start() {
        this.getProvider().startInstrument(this);
    }

    @Override
    public void stop() {
        this.getProvider().stopInstrument(this);
    }
}

