// Copyright 2021 Bloomberg Finance L.P
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include <ctime>
#include <iomanip>
#include <iostream>
#include <sstream>

#include <rumbad_utils.h>

namespace rumbad {

std::string
formatTimestamp(std::chrono::time_point<std::chrono::system_clock> timestamp)
{
    time_t time = std::chrono::system_clock::to_time_t(timestamp);
    std::stringstream stream;
    stream << std::put_time(gmtime(&time), "%F %T+00");
    return stream.str();
}

} // namespace rumbad
