"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ptr16 = exports.NonNullablePtr32 = exports.NullablePtr32 = exports.NonNullablePtr16 = exports.NullablePtr16 = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
function NullablePtr16(r) {
    return {
        read: (view, ...ar) => {
            const p = view.ptr16Nullable();
            if (!p)
                return null;
            else
                return p.next(r, ...ar);
        },
        write: (frag, t, ...aw) => {
            if (t == null)
                frag.ptr16(null);
            else
                frag.ptr16New().push(r, t, ...aw);
        }
    };
}
exports.NullablePtr16 = NullablePtr16;
function NonNullablePtr16(r) {
    return {
        read: (view, ...ar) => {
            const p = view.ptr16();
            return p.next(r, ...ar);
        },
        write: (frag, t, ...aw) => {
            frag.ptr16(bin_util_1.Frag.from(r, t, ...aw));
        }
    };
}
exports.NonNullablePtr16 = NonNullablePtr16;
function NullablePtr32(r) {
    return {
        read: (view, ...ar) => {
            const p = view.ptr32Nullable();
            if (!p)
                return null;
            else
                return p.next(r, ...ar);
        },
        write: (frag, t, ...aw) => {
            if (t == null)
                frag.ptr32(null);
            else
                frag.ptr32New().push(r, t, ...aw);
        }
    };
}
exports.NullablePtr32 = NullablePtr32;
function NonNullablePtr32(r) {
    return {
        read: (view, ...ar) => {
            const p = view.ptr32();
            return p.next(r, ...ar);
        },
        write: (frag, t, ...aw) => {
            frag.ptr32(bin_util_1.Frag.from(r, t, ...aw));
        }
    };
}
exports.NonNullablePtr32 = NonNullablePtr32;
exports.Ptr16 = {
    read: (p) => p.ptr16(),
    write(frag, f) {
        frag.ptr16(f || null);
    }
};
//# sourceMappingURL=ptr.js.map