"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CharStringGlobalOptEmptyImplFactory = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const CffInterp = require("../../../interp/ir");
const operator_1 = require("../../../interp/operator");
const encoder_1 = require("../encoder");
const mir_1 = require("../mir");
class CharStringGlobalOptEmptyImpl {
    constructor(ctx, fdCount) {
        this.charStrings = [];
        this.localSubroutines = [];
        this.globalSubroutines = [];
        this.limits = ctx.getLimits();
        for (let fdId = 0; fdId < fdCount; fdId++) {
            this.localSubroutines[fdId] = [];
        }
    }
    addCharString(gid, fdId, mirSeq) {
        const frag = new bin_util_1.Frag();
        const encoder = new encoder_1.CharStringEncoder(frag);
        const irSeq = mir_1.Mir.toInterpIrSeq(mirSeq);
        for (const ir of irSeq) {
            // Filter out existing EndChar operators -- we will add them at the end if necessary
            if (CffInterp.isOperator(ir) && ir.opCode === operator_1.CharStringOperator.EndChar)
                continue;
            encoder.push(ir);
        }
        if (this.limits.endCharSize)
            encoder.push(CffInterp.operator(operator_1.CharStringOperator.EndChar));
        const buf = bin_util_1.Frag.pack(frag);
        this.charStrings[gid] = buf;
    }
    getResults() {
        return {
            charStrings: this.charStrings,
            localSubroutines: this.localSubroutines,
            globalSubroutines: this.globalSubroutines
        };
    }
}
exports.CharStringGlobalOptEmptyImplFactory = {
    createOptimizer(ctx, fdCount) {
        return new CharStringGlobalOptEmptyImpl(ctx, fdCount);
    }
};
//# sourceMappingURL=empty-impl.js.map