//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/blockchain/armblockchain"
	"net/http"
	"net/url"
	"regexp"
)

// MemberOperationResultsServer is a fake server for instances of the armblockchain.MemberOperationResultsClient type.
type MemberOperationResultsServer struct {
	// Get is the fake for method MemberOperationResultsClient.Get
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Get func(ctx context.Context, locationName string, operationID string, options *armblockchain.MemberOperationResultsClientGetOptions) (resp azfake.Responder[armblockchain.MemberOperationResultsClientGetResponse], errResp azfake.ErrorResponder)
}

// NewMemberOperationResultsServerTransport creates a new instance of MemberOperationResultsServerTransport with the provided implementation.
// The returned MemberOperationResultsServerTransport instance is connected to an instance of armblockchain.MemberOperationResultsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMemberOperationResultsServerTransport(srv *MemberOperationResultsServer) *MemberOperationResultsServerTransport {
	return &MemberOperationResultsServerTransport{srv: srv}
}

// MemberOperationResultsServerTransport connects instances of armblockchain.MemberOperationResultsClient to instances of MemberOperationResultsServer.
// Don't use this type directly, use NewMemberOperationResultsServerTransport instead.
type MemberOperationResultsServerTransport struct {
	srv *MemberOperationResultsServer
}

// Do implements the policy.Transporter interface for MemberOperationResultsServerTransport.
func (m *MemberOperationResultsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MemberOperationResultsClient.Get":
		resp, err = m.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MemberOperationResultsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/blockchainMemberOperationResults/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), locationNameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).OperationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
