//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnewrelicobservability_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/newrelic/armnewrelicobservability"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/TagRules_ListByNewRelicMonitorResource_MaximumSet_Gen.json
func ExampleTagRulesClient_NewListByNewRelicMonitorResourcePager_tagRulesListByNewRelicMonitorResourceMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTagRulesClient().NewListByNewRelicMonitorResourcePager("rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TagRuleListResult = armnewrelicobservability.TagRuleListResult{
		// 	Value: []*armnewrelicobservability.TagRule{
		// 		{
		// 			Name: to.Ptr("ddoieozflu"),
		// 			Type: to.Ptr("roafonrkfwwuv"),
		// 			ID: to.Ptr("ycdsgeiitvxcd"),
		// 			SystemData: &armnewrelicobservability.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-02T00:39:52.964Z"); return t}()),
		// 				CreatedBy: to.Ptr("wqrkemruqrvclsoevdftfeof"),
		// 				CreatedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-02T00:39:52.964Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("usdyoriebtakpdotcfp"),
		// 				LastModifiedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
		// 			},
		// 			Properties: &armnewrelicobservability.MonitoringTagRulesProperties{
		// 				LogRules: &armnewrelicobservability.LogRules{
		// 					FilteringTags: []*armnewrelicobservability.FilteringTag{
		// 						{
		// 							Name: to.Ptr("saokgpjvdlorciqbjmjxazpee"),
		// 							Action: to.Ptr(armnewrelicobservability.TagActionInclude),
		// 							Value: to.Ptr("sarxrqsxouhdjwsrqqicbeirdb"),
		// 					}},
		// 					SendAADLogs: to.Ptr(armnewrelicobservability.SendAADLogsStatusEnabled),
		// 					SendActivityLogs: to.Ptr(armnewrelicobservability.SendActivityLogsStatusEnabled),
		// 					SendSubscriptionLogs: to.Ptr(armnewrelicobservability.SendSubscriptionLogsStatusEnabled),
		// 				},
		// 				MetricRules: &armnewrelicobservability.MetricRules{
		// 					FilteringTags: []*armnewrelicobservability.FilteringTag{
		// 						{
		// 							Name: to.Ptr("saokgpjvdlorciqbjmjxazpee"),
		// 							Action: to.Ptr(armnewrelicobservability.TagActionInclude),
		// 							Value: to.Ptr("sarxrqsxouhdjwsrqqicbeirdb"),
		// 					}},
		// 					UserEmail: to.Ptr("test@testing.com"),
		// 				},
		// 				ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/TagRules_ListByNewRelicMonitorResource_MinimumSet_Gen.json
func ExampleTagRulesClient_NewListByNewRelicMonitorResourcePager_tagRulesListByNewRelicMonitorResourceMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTagRulesClient().NewListByNewRelicMonitorResourcePager("rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TagRuleListResult = armnewrelicobservability.TagRuleListResult{
		// 	Value: []*armnewrelicobservability.TagRule{
		// 		{
		// 			ID: to.Ptr("ycdsgeiitvxcd"),
		// 			Properties: &armnewrelicobservability.MonitoringTagRulesProperties{
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/TagRules_Get_MaximumSet_Gen.json
func ExampleTagRulesClient_Get_tagRulesGetMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTagRulesClient().Get(ctx, "rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", "bxcantgzggsepbhqmedjqyrqeezmfb", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TagRule = armnewrelicobservability.TagRule{
	// 	Name: to.Ptr("ddoieozflu"),
	// 	Type: to.Ptr("roafonrkfwwuv"),
	// 	ID: to.Ptr("ycdsgeiitvxcd"),
	// 	SystemData: &armnewrelicobservability.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-02T00:39:52.964Z"); return t}()),
	// 		CreatedBy: to.Ptr("wqrkemruqrvclsoevdftfeof"),
	// 		CreatedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-02T00:39:52.964Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("usdyoriebtakpdotcfp"),
	// 		LastModifiedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 	},
	// 	Properties: &armnewrelicobservability.MonitoringTagRulesProperties{
	// 		LogRules: &armnewrelicobservability.LogRules{
	// 			FilteringTags: []*armnewrelicobservability.FilteringTag{
	// 				{
	// 					Name: to.Ptr("saokgpjvdlorciqbjmjxazpee"),
	// 					Action: to.Ptr(armnewrelicobservability.TagActionInclude),
	// 					Value: to.Ptr("sarxrqsxouhdjwsrqqicbeirdb"),
	// 			}},
	// 			SendAADLogs: to.Ptr(armnewrelicobservability.SendAADLogsStatusEnabled),
	// 			SendActivityLogs: to.Ptr(armnewrelicobservability.SendActivityLogsStatusEnabled),
	// 			SendSubscriptionLogs: to.Ptr(armnewrelicobservability.SendSubscriptionLogsStatusEnabled),
	// 		},
	// 		MetricRules: &armnewrelicobservability.MetricRules{
	// 			FilteringTags: []*armnewrelicobservability.FilteringTag{
	// 				{
	// 					Name: to.Ptr("saokgpjvdlorciqbjmjxazpee"),
	// 					Action: to.Ptr(armnewrelicobservability.TagActionInclude),
	// 					Value: to.Ptr("sarxrqsxouhdjwsrqqicbeirdb"),
	// 			}},
	// 			UserEmail: to.Ptr("test@testing.com"),
	// 		},
	// 		ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/TagRules_Get_MinimumSet_Gen.json
func ExampleTagRulesClient_Get_tagRulesGetMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTagRulesClient().Get(ctx, "rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", "bxcantgzggsepbhqmedjqyrqeezmfb", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TagRule = armnewrelicobservability.TagRule{
	// 	ID: to.Ptr("ycdsgeiitvxcd"),
	// 	Properties: &armnewrelicobservability.MonitoringTagRulesProperties{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/TagRules_CreateOrUpdate_MaximumSet_Gen.json
func ExampleTagRulesClient_BeginCreateOrUpdate_tagRulesCreateOrUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTagRulesClient().BeginCreateOrUpdate(ctx, "rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", "bxcantgzggsepbhqmedjqyrqeezmfb", armnewrelicobservability.TagRule{
		Properties: &armnewrelicobservability.MonitoringTagRulesProperties{
			LogRules: &armnewrelicobservability.LogRules{
				FilteringTags: []*armnewrelicobservability.FilteringTag{
					{
						Name:   to.Ptr("saokgpjvdlorciqbjmjxazpee"),
						Action: to.Ptr(armnewrelicobservability.TagActionInclude),
						Value:  to.Ptr("sarxrqsxouhdjwsrqqicbeirdb"),
					}},
				SendAADLogs:          to.Ptr(armnewrelicobservability.SendAADLogsStatusEnabled),
				SendActivityLogs:     to.Ptr(armnewrelicobservability.SendActivityLogsStatusEnabled),
				SendSubscriptionLogs: to.Ptr(armnewrelicobservability.SendSubscriptionLogsStatusEnabled),
			},
			MetricRules: &armnewrelicobservability.MetricRules{
				FilteringTags: []*armnewrelicobservability.FilteringTag{
					{
						Name:   to.Ptr("saokgpjvdlorciqbjmjxazpee"),
						Action: to.Ptr(armnewrelicobservability.TagActionInclude),
						Value:  to.Ptr("sarxrqsxouhdjwsrqqicbeirdb"),
					}},
				UserEmail: to.Ptr("test@testing.com"),
			},
			ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateAccepted),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TagRule = armnewrelicobservability.TagRule{
	// 	Name: to.Ptr("ddoieozflu"),
	// 	Type: to.Ptr("roafonrkfwwuv"),
	// 	ID: to.Ptr("ycdsgeiitvxcd"),
	// 	SystemData: &armnewrelicobservability.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-02T00:39:52.964Z"); return t}()),
	// 		CreatedBy: to.Ptr("wqrkemruqrvclsoevdftfeof"),
	// 		CreatedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-02T00:39:52.964Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("usdyoriebtakpdotcfp"),
	// 		LastModifiedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 	},
	// 	Properties: &armnewrelicobservability.MonitoringTagRulesProperties{
	// 		LogRules: &armnewrelicobservability.LogRules{
	// 			FilteringTags: []*armnewrelicobservability.FilteringTag{
	// 				{
	// 					Name: to.Ptr("saokgpjvdlorciqbjmjxazpee"),
	// 					Action: to.Ptr(armnewrelicobservability.TagActionInclude),
	// 					Value: to.Ptr("sarxrqsxouhdjwsrqqicbeirdb"),
	// 			}},
	// 			SendAADLogs: to.Ptr(armnewrelicobservability.SendAADLogsStatusEnabled),
	// 			SendActivityLogs: to.Ptr(armnewrelicobservability.SendActivityLogsStatusEnabled),
	// 			SendSubscriptionLogs: to.Ptr(armnewrelicobservability.SendSubscriptionLogsStatusEnabled),
	// 		},
	// 		MetricRules: &armnewrelicobservability.MetricRules{
	// 			FilteringTags: []*armnewrelicobservability.FilteringTag{
	// 				{
	// 					Name: to.Ptr("saokgpjvdlorciqbjmjxazpee"),
	// 					Action: to.Ptr(armnewrelicobservability.TagActionInclude),
	// 					Value: to.Ptr("sarxrqsxouhdjwsrqqicbeirdb"),
	// 			}},
	// 		},
	// 		ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/TagRules_CreateOrUpdate_MinimumSet_Gen.json
func ExampleTagRulesClient_BeginCreateOrUpdate_tagRulesCreateOrUpdateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTagRulesClient().BeginCreateOrUpdate(ctx, "rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", "bxcantgzggsepbhqmedjqyrqeezmfb", armnewrelicobservability.TagRule{
		Properties: &armnewrelicobservability.MonitoringTagRulesProperties{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TagRule = armnewrelicobservability.TagRule{
	// 	ID: to.Ptr("ycdsgeiitvxcd"),
	// 	Properties: &armnewrelicobservability.MonitoringTagRulesProperties{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/TagRules_Delete_MaximumSet_Gen.json
func ExampleTagRulesClient_BeginDelete_tagRulesDeleteMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTagRulesClient().BeginDelete(ctx, "rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", "bxcantgzggsepbhqmedjqyrqeezmfb", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/TagRules_Delete_MinimumSet_Gen.json
func ExampleTagRulesClient_BeginDelete_tagRulesDeleteMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTagRulesClient().BeginDelete(ctx, "rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", "bxcantgzggsepbhqmedjqyrqeezmfb", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/TagRules_Update_MaximumSet_Gen.json
func ExampleTagRulesClient_Update_tagRulesUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTagRulesClient().Update(ctx, "rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", "bxcantgzggsepbhqmedjqyrqeezmfb", armnewrelicobservability.TagRuleUpdate{
		Properties: &armnewrelicobservability.TagRuleUpdateProperties{
			LogRules: &armnewrelicobservability.LogRules{
				FilteringTags: []*armnewrelicobservability.FilteringTag{
					{
						Name:   to.Ptr("saokgpjvdlorciqbjmjxazpee"),
						Action: to.Ptr(armnewrelicobservability.TagActionInclude),
						Value:  to.Ptr("sarxrqsxouhdjwsrqqicbeirdb"),
					}},
				SendAADLogs:          to.Ptr(armnewrelicobservability.SendAADLogsStatusEnabled),
				SendActivityLogs:     to.Ptr(armnewrelicobservability.SendActivityLogsStatusEnabled),
				SendSubscriptionLogs: to.Ptr(armnewrelicobservability.SendSubscriptionLogsStatusEnabled),
			},
			MetricRules: &armnewrelicobservability.MetricRules{
				FilteringTags: []*armnewrelicobservability.FilteringTag{
					{
						Name:   to.Ptr("saokgpjvdlorciqbjmjxazpee"),
						Action: to.Ptr(armnewrelicobservability.TagActionInclude),
						Value:  to.Ptr("sarxrqsxouhdjwsrqqicbeirdb"),
					}},
				UserEmail: to.Ptr("test@testing.com"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TagRule = armnewrelicobservability.TagRule{
	// 	Name: to.Ptr("ddoieozflu"),
	// 	Type: to.Ptr("roafonrkfwwuv"),
	// 	ID: to.Ptr("ycdsgeiitvxcd"),
	// 	SystemData: &armnewrelicobservability.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-02T00:39:52.964Z"); return t}()),
	// 		CreatedBy: to.Ptr("wqrkemruqrvclsoevdftfeof"),
	// 		CreatedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-09-02T00:39:52.964Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("usdyoriebtakpdotcfp"),
	// 		LastModifiedByType: to.Ptr(armnewrelicobservability.CreatedByTypeUser),
	// 	},
	// 	Properties: &armnewrelicobservability.MonitoringTagRulesProperties{
	// 		LogRules: &armnewrelicobservability.LogRules{
	// 			FilteringTags: []*armnewrelicobservability.FilteringTag{
	// 				{
	// 					Name: to.Ptr("saokgpjvdlorciqbjmjxazpee"),
	// 					Action: to.Ptr(armnewrelicobservability.TagActionInclude),
	// 					Value: to.Ptr("sarxrqsxouhdjwsrqqicbeirdb"),
	// 			}},
	// 			SendAADLogs: to.Ptr(armnewrelicobservability.SendAADLogsStatusEnabled),
	// 			SendActivityLogs: to.Ptr(armnewrelicobservability.SendActivityLogsStatusEnabled),
	// 			SendSubscriptionLogs: to.Ptr(armnewrelicobservability.SendSubscriptionLogsStatusEnabled),
	// 		},
	// 		MetricRules: &armnewrelicobservability.MetricRules{
	// 			FilteringTags: []*armnewrelicobservability.FilteringTag{
	// 				{
	// 					Name: to.Ptr("saokgpjvdlorciqbjmjxazpee"),
	// 					Action: to.Ptr(armnewrelicobservability.TagActionInclude),
	// 					Value: to.Ptr("sarxrqsxouhdjwsrqqicbeirdb"),
	// 			}},
	// 			UserEmail: to.Ptr("test@testing.com"),
	// 		},
	// 		ProvisioningState: to.Ptr(armnewrelicobservability.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/newrelic/resource-manager/NewRelic.Observability/stable/2022-07-01/examples/TagRules_Update_MinimumSet_Gen.json
func ExampleTagRulesClient_Update_tagRulesUpdateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnewrelicobservability.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTagRulesClient().Update(ctx, "rgopenapi", "ipxmlcbonyxtolzejcjshkmlron", "bxcantgzggsepbhqmedjqyrqeezmfb", armnewrelicobservability.TagRuleUpdate{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TagRule = armnewrelicobservability.TagRule{
	// 	ID: to.Ptr("ycdsgeiitvxcd"),
	// 	Properties: &armnewrelicobservability.MonitoringTagRulesProperties{
	// 	},
	// }
}
