# ID Token Zoo

This document contains example ID Tokens from different providers. We truncate the signatures.

## Azure

### ID Token

```json
{
    "payload": {
    "ver": "2.0",
    "iss": "https://login.microsoftonline.com/9188040d-6c67-4c5b-b112-36a304b66dad/v2.0",
    "sub": "AAAAAAAAAAAAAAAAAAAAAJ8PFm0pjpXKQouYRalE11g",
    "aud": "bd345b9c-6902-400d-9e18-45abdf0f698f",
    "exp": 1737500954,
    "iat": 1737414254,
    "nbf": 1737414254,
    "preferred_username": "alice@gmail.com",
    "oid": "00000000-0000-0000-7862-618d09e9fa0e",
    "email": "alice@gmail.com",
    "tid": "9188040d-6c67-4c5b-b112-36a304b66dad",
    "nonce": "pElF-ABr22cAQOTAC0qpxI83OH14Hu7fjRSWzS6ViLY",
    "aio": "DoD*c*IDip3fgOs3T8dIIBWw!JwcIwhQCwMcpNinmjEss4Ifu0PKKMPCiuJOXBAtX8OObt*128kwC7cPM97!AHy8mw1kRA9P5dcw6wlj8doC1j5nn03eNizuiwI9JMgdD1I0rfWBClENOSqDUg4ODsuPds!G1NtVGt6bxfRJrM81"
    },
    "protected": {
    "typ": "JWT",
    "alg": "RS256",
    "kid": "aB0xDdGXk535PvewBP9Hl5pf7wc"
    }
}
```

### Refreshed ID Token

```json
{
"payload": {
    "ver": "2.0",
    "iss": "https://login.microsoftonline.com/9188040d-6c67-4c5b-b112-36a304b66dad/v2.0",
    "sub": "AAAAAAAAAAAAAAAAAAAAAJ8PFm0pjpXKQouYRalE11g",
    "aud": "bd345b9c-6902-400d-9e18-45abdf0f698f",
    "exp": 1737500957,
    "iat": 1737414257,
    "nbf": 1737414257,
    "preferred_username": "alice@gmail.com",
    "oid": "00000000-0000-0000-7862-618d09e9fa0e",
    "email": "alice@gmail.com",
    "tid": "9188040d-6c67-4c5b-b112-36a304b66dad",
    "aio": "DmyH0vHZqJZRcv752O*ph8K!x!EOAIk!e1nSWrtlGxUlMccl2n5qHa9vY4YtAfWma!VI3BqIfsfzYdrrMDW22D5qIRAOYDP9utExgqTitwxNf83p*3nLqtCTnND!GVwhM35BGCaLqsA9MF8gu1dbUfTPgYxD4yTOH3sZq3hDyAbY"
    },
"protected": {
    "typ": "JWT",
    "alg": "RS256",
    "kid": "aB0xDdGXk535PvewBP9Hl5pf7wc"
    }
}
```

## Google

### ID Token

```json
{
"payload": {
    "iss": "https://accounts.google.com",
    "azp": "992028499768-ce9juclb3vvckh23r83fjkmvf1lvjq18.apps.googleusercontent.com",
    "aud": "992028499768-ce9juclb3vvckh23r83fjkmvf1lvjq18.apps.googleusercontent.com",
    "sub": "103030642802723203118",
    "email": "alice@gmail.com",
    "email_verified": true,
    "at_hash": "fTQQ5_pA8i-Zx_Bif9PVrA",
    "nonce": "oZifhxF_UkB0AG6K1hPyEsvDCHuqW3QsyK4O_XIlTzU",
    "name": "Alice Example",
    "picture": "https://lh3.googleusercontent.com/a/ACg8ocJie7Hgt4fitN0_GWXaFHYBuy1UMkr_ufkLXTW7MEpA_UMx1XlU=s96-c",
    "given_name": "Alice",
    "family_name": "Example",
    "iat": 1737415178,
    "exp": 1737418778
    },
"protected": {
    "alg": "RS256",
    "kid": "6337be6364f3824008d0e9003f50bb6b43d5a9c6",
    "typ": "JWT"
    }
}
```

### Refreshed ID Token

```json
{
"payload": {
    "iss": "https://accounts.google.com",
    "azp": "992028499768-ce9juclb3vvckh23r83fjkmvf1lvjq18.apps.googleusercontent.com",
    "aud": "992028499768-ce9juclb3vvckh23r83fjkmvf1lvjq18.apps.googleusercontent.com",
    "sub": "103030642802723203118",
    "email": "alice@gmail.com",
    "email_verified": true,
    "at_hash": "kUOiPWtlZegMkNufB3eDaA",
    "name": "Alice Example",
    "picture": "https://lh3.googleusercontent.com/a/ACg8ocJie7Hgt4fitN0_GWXaFHYBuy1UMkr_ufkLXTW7MEpA_UMx1XlU=s96-c",
    "given_name": "Alice",
    "family_name": "Example",
    "iat": 1737415180,
    "exp": 1737418780
    },
"protected": {
    "alg": "RS256",
    "kid": "6337be6364f3824008d0e9003f50bb6b43d5a9c6",
    "typ": "JWT"
    }
}
```

## Hello.dev

### ID Token

This was generated using <https://playground.hello.dev/> with gitlab claims enabled

```json
{
"payload": {
    "iss": "https://issuer.hello.coop",
    "aud": "app_HelloDeveloperPlayground_Iq2",
    "nonce": "26fe2dc0-b405-40cb-bfdc-e26aee0564ce",
    "jti": "jti_0FmofYWcyShupLOb9X3YwaIl_EVL",
    "sub": "8dfb4b1a-2b9e-4f59-a2dc-33e6806f3fe0",
    "tenant": "personal",
    "email": "alice@gmail.com",
    "email_verified": true,
    "gitlab": {
        "id": "76205622",
        "username": "Alice"
    },
    "iat": 1743381952,
    "exp": 1743382252
},
"protected": {
    "alg": "RS256",
    "typ": "JWT",
    "kid": "2025-01-15T16:56:49.668Z_735-1c5"
    },
}
```

### Key Bound ID Token

```json
{
  "payload": {
    "iss": "https://issuer.hello.coop",
    "aud": "app_xejobTKEsDNSRd5vofKB2iay_2rN",
    "nonce": "UIjSuNcpCiJ6Vn1SqCaE4ILexfFsolukHmqlgKbC1p0",
    "jti": "jti_U82eEJjPL9pRfLXNcfEMe5SJ_M3w",
    "sub": "sub_NdETpSN2LthxgTKdrBcLK2au_TDg",
    "tenant": "personal",
    "name": "Anonymous Author",
    "picture": "https://lh3.googleusercontent.com/a/ACg8ocIdbWtaAGFsizjWVh7Q6C-XDBuSoUOpf7d7nGqgNQ-9yHmenNA=s96-c",
    "email": "anon.author.aardvark@gmail.com",
    "email_verified": true,
    "iat": 1761943045,
    "exp": 1761943345,
    "cnf": {
        "jwk": {
            "alg": "ES256",
            "crv": "P-256",
            "kty": "EC",
            "x": "6hgrwR47GqR6wpeTUAusxBYbwnO5I_B5nTaO0YH75Uk",
            "y": "H0ZtI1Bbytlvfn3ej3eW0qVkXpyuFSRVmuLtwRq3UyM"
        }
    }
  },
  "signatures": [
    {
      "protected": {
        "alg": "RS256",
        "typ": "id_token+cnf",
        "kid": "2025-09-05T11:09:18.267Z_ab4-956-RS256"
      },
      "signature": "CqXs..."
    }
  ]
}
```

## AWS Cognito

### ID Token (with token revocation enabled)

```json
{
    "payload": {
        "at_hash": "-9rmUKO5T6OZrkWR_dnZzQ",
        "sub": "f4f8b4a8-b061-7039-6671-844b2e140c9d",
        "email_verified": true,
        "iss": "https:\/\/cognito-idp.us-east-1.amazonaws.com\/us-east-1_FqOCYEQAc",
        "cognito:username": "f4f8b4a8-b061-7039-6671-844b2e140c9d",
        "nonce": "Ze_mXtKziFWWMbt_7B0IBYIylXg1qVbtyUnwVBkkA1I",
        "origin_jti": "d1c87520-e3a5-489b-90c5-3c86e5bc20d6",
        "aud": "7mutue6chhphanddiel1r4u0qv",
        "token_use": "id",
        "auth_time": 1764973015,
        "exp": 1764976615,
        "iat": 1764973015,
        "jti": "2178848f-99ae-4389-a4e2-155d6c60594a",
        "email": "alice@example.com"
    },
    "signatures": [
        {
            "protected": {
                "kid": "UGIevE1I5DkrQL0VFF7nRif5Z5G5PXaHEArHtBu\/HM0=",
                "alg": "RS256"
            },
            "signature": "Q7kGG..."
        }
    ]
}
```

### ID Token (without token revocation enabled)

```json
{
    "payload": {
        "at_hash": "aeOHnzHGgPHiyI2Kvw4tcQ",
        "sub": "f4f8b4a8-b061-7039-6671-844b2e140c9d",
        "email_verified": true,
        "iss": "https:\/\/cognito-idp.us-east-1.amazonaws.com\/us-east-1_FqOCYEQAc",
        "cognito:username": "f4f8b4a8-b061-7039-6671-844b2e140c9d",
        "nonce": "uhPcEjVMklIg5qrC10ToRfD_KiE6GCsXQYNs8Gi4hao",
        "aud": "1gf0blnk3kkj5njus0fgqj4qd4",
        "event_id": "01007bb1-7b8b-412b-b095-846501c77b2c",
        "token_use": "id",
        "auth_time": 1764972249,
        "exp": 1764975849,
        "iat": 1764972249,
        "email": "alice@example.com"
    },
    "signatures": [
        {
            "protected": {
                "kid": "UGIevE1I5DkrQL0VFF7nRif5Z5G5PXaHEArHtBu\/HM0=",
                "alg": "RS256"
            },
            "signature": "Q7kGG..."
        }
    ]
}
```
