// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/sensitiveaction/logging/v1/sensitive_action_payload.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	v1 "google.golang.org/genproto/googleapis/cloud/securitycenter/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Payload proto for sensitiveaction.googleapis.com/action
// Platform Log event that describes a sensitive action
type SensitiveAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of action (eg. "change_organization_policy").
	ActionType string `protobuf:"bytes,1,opt,name=action_type,json=actionType,proto3" json:"action_type,omitempty"`
	// The time this action was detected.
	ActionTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=action_time,json=actionTime,proto3" json:"action_time,omitempty"`
	// GCP resources that are involved in the action.
	AffectedResources []string `protobuf:"bytes,3,rep,name=affected_resources,json=affectedResources,proto3" json:"affected_resources,omitempty"`
	// Cloud Logging entries that were used to identify the action.
	SourceLogIds []*SensitiveAction_SourceLogId `protobuf:"bytes,4,rep,name=source_log_ids,json=sourceLogIds,proto3" json:"source_log_ids,omitempty"`
	// Link to documentation where you can learn more about sensitive actions.
	LearnMoreUri string `protobuf:"bytes,5,opt,name=learn_more_uri,json=learnMoreUri,proto3" json:"learn_more_uri,omitempty"`
	// Access details associated to the sensitive action.
	Access *v1.Access `protobuf:"bytes,6,opt,name=access,proto3" json:"access,omitempty"`
}

func (x *SensitiveAction) Reset() {
	*x = SensitiveAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SensitiveAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SensitiveAction) ProtoMessage() {}

func (x *SensitiveAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SensitiveAction.ProtoReflect.Descriptor instead.
func (*SensitiveAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_rawDescGZIP(), []int{0}
}

func (x *SensitiveAction) GetActionType() string {
	if x != nil {
		return x.ActionType
	}
	return ""
}

func (x *SensitiveAction) GetActionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ActionTime
	}
	return nil
}

func (x *SensitiveAction) GetAffectedResources() []string {
	if x != nil {
		return x.AffectedResources
	}
	return nil
}

func (x *SensitiveAction) GetSourceLogIds() []*SensitiveAction_SourceLogId {
	if x != nil {
		return x.SourceLogIds
	}
	return nil
}

func (x *SensitiveAction) GetLearnMoreUri() string {
	if x != nil {
		return x.LearnMoreUri
	}
	return ""
}

func (x *SensitiveAction) GetAccess() *v1.Access {
	if x != nil {
		return x.Access
	}
	return nil
}

// Used to reference a specific Cloud Logging LogEntry.
type SensitiveAction_SourceLogId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The GCP resource (organization, folder, or project) that the LogEntry
	// came from.
	ResourceContainer string `protobuf:"bytes,1,opt,name=resource_container,json=resourceContainer,proto3" json:"resource_container,omitempty"`
	// The timestamp of the LogEntry.
	LogTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=log_time,json=logTime,proto3" json:"log_time,omitempty"`
	// The insert_id of the LogEntry.
	InsertId string `protobuf:"bytes,3,opt,name=insert_id,json=insertId,proto3" json:"insert_id,omitempty"`
	// A link to the Cloud Logging dashboard with a query for the LogEntry.
	QueryUri string `protobuf:"bytes,4,opt,name=query_uri,json=queryUri,proto3" json:"query_uri,omitempty"`
}

func (x *SensitiveAction_SourceLogId) Reset() {
	*x = SensitiveAction_SourceLogId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SensitiveAction_SourceLogId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SensitiveAction_SourceLogId) ProtoMessage() {}

func (x *SensitiveAction_SourceLogId) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SensitiveAction_SourceLogId.ProtoReflect.Descriptor instead.
func (*SensitiveAction_SourceLogId) Descriptor() ([]byte, []int) {
	return file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_rawDescGZIP(), []int{0, 0}
}

func (x *SensitiveAction_SourceLogId) GetResourceContainer() string {
	if x != nil {
		return x.ResourceContainer
	}
	return ""
}

func (x *SensitiveAction_SourceLogId) GetLogTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LogTime
	}
	return nil
}

func (x *SensitiveAction_SourceLogId) GetInsertId() string {
	if x != nil {
		return x.InsertId
	}
	return ""
}

func (x *SensitiveAction_SourceLogId) GetQueryUri() string {
	if x != nil {
		return x.QueryUri
	}
	return ""
}

var File_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto protoreflect.FileDescriptor

var file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_rawDesc = []byte{
	0x0a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76,
	0x31, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xa0, 0x04, 0x0a, 0x0f, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x2d, 0x0a, 0x12, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x61,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0x6a, 0x0a, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x67, 0x49, 0x64, 0x52, 0x0c,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x67, 0x49, 0x64, 0x73, 0x12, 0x24, 0x0a, 0x0e,
	0x6c, 0x65, 0x61, 0x72, 0x6e, 0x5f, 0x6d, 0x6f, 0x72, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x4d, 0x6f, 0x72, 0x65, 0x55,
	0x72, 0x69, 0x12, 0x3e, 0x0a, 0x06, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x06, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x1a, 0xad, 0x01, 0x0a, 0x0b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x67,
	0x49, 0x64, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x12, 0x35, 0x0a, 0x08, 0x6c, 0x6f, 0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x07, 0x6c, 0x6f, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73,
	0x65, 0x72, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x71, 0x75, 0x65, 0x72, 0x79, 0x55,
	0x72, 0x69, 0x42, 0x9e, 0x02, 0x0a, 0x2b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x42, 0x1b, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x4e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0xaa, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x27, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65, 0x6e, 0x73, 0x69,
	0x74, 0x69, 0x76, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5c, 0x4c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x3a, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_rawDescOnce sync.Once
	file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_rawDescData = file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_rawDesc
)

func file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_rawDescGZIP() []byte {
	file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_rawDescOnce.Do(func() {
		file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_rawDescData)
	})
	return file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_rawDescData
}

var file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_goTypes = []interface{}{
	(*SensitiveAction)(nil),             // 0: google.cloud.sensitiveaction.logging.v1.SensitiveAction
	(*SensitiveAction_SourceLogId)(nil), // 1: google.cloud.sensitiveaction.logging.v1.SensitiveAction.SourceLogId
	(*timestamppb.Timestamp)(nil),       // 2: google.protobuf.Timestamp
	(*v1.Access)(nil),                   // 3: google.cloud.securitycenter.v1.Access
}
var file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_depIdxs = []int32{
	2, // 0: google.cloud.sensitiveaction.logging.v1.SensitiveAction.action_time:type_name -> google.protobuf.Timestamp
	1, // 1: google.cloud.sensitiveaction.logging.v1.SensitiveAction.source_log_ids:type_name -> google.cloud.sensitiveaction.logging.v1.SensitiveAction.SourceLogId
	3, // 2: google.cloud.sensitiveaction.logging.v1.SensitiveAction.access:type_name -> google.cloud.securitycenter.v1.Access
	2, // 3: google.cloud.sensitiveaction.logging.v1.SensitiveAction.SourceLogId.log_time:type_name -> google.protobuf.Timestamp
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_init() }
func file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_init() {
	if File_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SensitiveAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SensitiveAction_SourceLogId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_goTypes,
		DependencyIndexes: file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_depIdxs,
		MessageInfos:      file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_msgTypes,
	}.Build()
	File_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto = out.File
	file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_rawDesc = nil
	file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_goTypes = nil
	file_google_cloud_sensitiveaction_logging_v1_sensitive_action_payload_proto_depIdxs = nil
}
