/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * mac80211 drop reason list
 *
 * Copyright (C) 2023-2024 Intel Corporation
 */

#ifndef MAC80211_DROP_H
#define MAC80211_DROP_H
#include <net/dropreason.h>

typedef unsigned int __bitwise ieee80211_rx_result;

#define MAC80211_DROP_REASONS_MONITOR(R)	\
	R(RX_DROP_M_UNEXPECTED_4ADDR_FRAME)	\
	R(RX_DROP_M_BAD_BCN_KEYIDX)		\
	R(RX_DROP_M_BAD_MGMT_KEYIDX)		\
/* this line for the trailing \ - add before this */

#define MAC80211_DROP_REASONS_UNUSABLE(R)	\
	/* 0x00 == ___RX_DROP_UNUSABLE */	\
	R(RX_DROP_U_MIC_FAIL)			\
	R(RX_DROP_U_REPLAY)			\
	R(RX_DROP_U_BAD_MMIE)			\
	R(RX_DROP_U_DUP)			\
	R(RX_DROP_U_SPURIOUS)			\
	R(RX_DROP_U_DECRYPT_FAIL)		\
	R(RX_DROP_U_NO_KEY_ID)			\
	R(RX_DROP_U_BAD_CIPHER)			\
	R(RX_DROP_U_OOM)			\
	R(RX_DROP_U_NONSEQ_PN)			\
	R(RX_DROP_U_BAD_KEY_COLOR)		\
	R(RX_DROP_U_BAD_4ADDR)			\
	R(RX_DROP_U_BAD_AMSDU)			\
	R(RX_DROP_U_BAD_AMSDU_CIPHER)		\
	R(RX_DROP_U_INVALID_8023)		\
	/* 0x10 */				\
	R(RX_DROP_U_RUNT_ACTION)		\
	R(RX_DROP_U_UNPROT_A