/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _ASM_LOONGARCH_PARAVIRT_H
#define _ASM_LOONGARCH_PARAVIRT_H

#ifdef CONFIG_PARAVIRT

#include <linux/static_call_types.h>
struct static_key;
extern struct static_key paravirt_steal_enabled;
extern struct static_key paravirt_steal_rq_enabled;

u64 dummy_steal_clock(int cpu);
DECLARE_STATIC_CALL(pv_steal_clock, dummy_steal_clock);

static inline u64 paravirt_steal_clock(int cpu)
{
	return static_call(pv_steal_clock)(cpu);
}

int __init pv_ipi_init(void);
int __init pv_time_init(void);
int __init pv_spinlock_init(void);

#else

static inline int pv_ipi_init(void)
{
	return 0;
}

static inline int pv_time_init(void)
{
	return 0;
}

static inline int pv_spinlock_init(void)
{
	return 0;
}

#endif // CONFIG_PARAVIRT
#endif
