/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 * Copyright (C) 2003 - 2009 NetXen, Inc.
 * Copyright (C) 2009 - QLogic Corporation.
 * All rights reserved.
 */

#ifndef __NETXEN_NIC_HDR_H_
#define __NETXEN_NIC_HDR_H_

#include <linux/kernel.h>
#include <linux/types.h>

/*
 * The basic unit of access when reading/writing control registers.
 */

typedef __le32 netxen_crbword_t;	/* single word in CRB space */

enum {
	NETXEN_HW_H0_CH_HUB_ADR = 0x05,
	NETXEN_HW_H1_CH_HUB_ADR = 0x0E,
	NETXEN_HW_H2_CH_HUB_ADR = 0x03,
	NETXEN_HW_H3_CH_HUB_ADR = 0x01,
	NETXEN_HW_H4_CH_HUB_ADR = 0x06,
	NETXEN_HW_H5_CH_HUB_ADR = 0x07,
	NETXEN_HW_H6_CH_HUB_ADR = 0x08
};

/*  Hub 0 */
enum {
	NETXEN_HW_MN_CRB_AGT_ADR = 0x15,
	NETXEN_HW_MS_CRB_AGT_ADR = 0x25
};

/*  Hub 1 */
enum {
	NETXEN_HW_PS_CRB_AGT_ADR = 0x73,
	NETXEN_HW_SS_CRB_AGT_ADR = 0x20,
	NETXEN_HW_RPMX3_CRB_AGT_ADR = 0x0b,
	NETXEN_HW_QMS_CRB_AGT_ADR = 0x00,
	NETXEN_HW_SQGS0_CRB_AGT_ADR = 0x01,
	NETXEN_HW_SQGS1_CRB_AGT_ADR = 0x02,
	NETXEN_HW_SQGS2_CRB_AGT_ADR = 0x03,
	NETXEN_HW_SQGS3_CRB_AGT_ADR = 0x04,
	NETXEN_HW_C2C0_CRB_AGT_ADR = 0x58,
	NETXEN_HW_C2C1_CRB_AGT_ADR = 0x59,
	NETXEN_HW_C2C2_CRB_AGT_ADR = 0x5a,
	NETXEN_HW_RPMX2_CRB_AGT_ADR = 0x0a,
	NETXEN_HW_RPMX4_CRB_AGT_ADR = 0x0c,
	NETXEN_HW_RPMX7_CRB_AGT_ADR = 0x0f,
	NETXEN_HW_RPMX9_CRB_AGT_ADR = 0x12,
	NETXEN_HW_SMB_CRB_AGT_ADR = 0x18
};

/*  Hub 2 */
enum {
	NETXEN_HW_NIU_CRB_AGT_ADR = 0x31,
	NETXEN_HW_I2C0_CRB_AGT_ADR = 0x19,
	NETXEN_HW_I2C1_CRB_AGT_ADR = 0x29,

	NETXEN_HW_SN_CRB_AGT_ADR = 0x10,
	NETXEN_HW_I2Q_CRB_AGT_ADR = 0x20,
	NETXEN_HW_LPC_CRB_AGT_ADR = 0x22,
	NETXEN_HW_ROMUSB_CRB_AGT_ADR = 0x21,
	NETXEN_HW_QM_CRB_AGT_ADR = 0x66,
	NETXEN_HW_SQG0_CRB_AGT_ADR = 0x60,
	NETXEN_HW_SQG1_CRB_AGT_ADR = 0x61,
	NETXEN_HW_SQG2_CRB_AGT_ADR = 0x62,
	NETXEN_HW_SQG3_CRB_AGT_ADR = 0x63,
	NETXEN_HW_RPMX1_CRB_AGT_ADR = 0x09,
	NETXEN_HW_RPMX5_CRB_AGT_ADR = 0x0d,
	NETXEN_HW_RPMX6_CRB_AGT_ADR = 0x0e,
	NETXEN_HW_RPMX8_CRB_AGT_ADR = 0x11
};

/*  Hub 3 */
enum {
	NETXEN_HW_PH_CRB_AGT_ADR = 0x1A,
	NETXEN_HW_SRE_CRB_AGT_ADR = 0x50,
	NETXEN_HW_EG_CRB_AGT_ADR = 0x51,
	NETXEN_HW_RPMX0_CRB_AGT_ADR = 0x08
};

/*  Hub 4 */
enum {
	NETXEN_HW_PEGN0_CRB_AGT_ADR = 0x40,
	NETXEN_HW_PEGN1_CRB_AGT_ADR,
	NETXEN_HW_PEGN2_CRB_AGT_ADR,
	NETXEN_HW_PEGN3_CRB_AGT_ADR,
	NETXEN_HW_PEGNI_CRB_AGT_ADR,
	NETXEN_HW_PEGND_CRB_AGT_ADR,
	NETXEN_HW_PEGNC_CRB_AGT_ADR,
	NETXEN_HW_PEGR0_CRB_AGT_ADR,
	NETXEN_HW_PEGR1_CRB_AGT_ADR,
	NETXEN_HW_PEGR2_CRB_AGT_ADR,
	NETXEN_HW_PEGR3_CRB_AGT_ADR,
	NETXEN_HW_PEGN4_CRB_AGT_ADR
};

/*  Hub 5 */
enum {
	NETXEN_HW_PEGS0_CRB_AGT_ADR = 0x40,
	NETXEN_HW_PEGS1_CRB_AGT_ADR,
	NETXEN_HW_PEGS2_CRB_AGT_ADR,
	NETXEN_HW_PEGS3_CRB_AGT_ADR,
	NETXEN_HW_PEGSI_CRB_AGT_ADR,
	NETXEN_HW_PEGSD_CRB_AGT_ADR,
	NETXEN_HW_PEGSC_CRB_AGT_ADR
};

/*  Hub 6 */
enum {
	NETXEN_HW_CAS0_CRB_AGT_ADR = 0x46,
	NETXEN_HW_CAS1_CRB_AGT_ADR = 0x47,
	NETXEN_HW_CAS2_CRB_AGT_ADR = 0x48,
	NETXEN_HW_CAS3_CRB_AGT_ADR = 0x49,
	NETXEN_HW_NCM_CRB_AGT_ADR = 0x16,
	NETXEN_HW_TMR_CRB_AGT_ADR = 0x17,
	NETXEN_HW_XDMA_CRB_AGT_ADR = 0x05,
	NETXEN_HW_OCM0_CRB_AGT_ADR = 0x06,
	NETXEN_HW_OCM1_CRB_AGT_