/*############################################################################*/
/*#                                                                          #*/
/*#  MIT HRTF C Library                                                      #*/
/*#  Filter table for normal set at 88200Hz                                  #*/
/*#  Copyright © 2007 Aristotel Digenis                                      #*/
/*#                                                                          #*/
/*#  Filename:  mit_hrtf_normal_88200.h                                      #*/
/*#  Version:   0.1                                                          #*/
/*#  Date:      04/05/2007                                                   #*/
/*#  Author(s): Aristotel Digenis                                            #*/
/*#  Credit:    Bill Gardner and Keith Martin                                #*/
/*#  Licence:   MIT                                                          #*/
/*#                                                                          #*/
/*############################################################################*/


#include "../mit_hrtf_filter.h"

const mit_hrtf_filter_set_88 normal_88 =
{
    {    // elev-10
        {    // H-10e000a.wav
            {8,-5,-11,9,23,-5,-33,-4,37,4,-57,-22,67,39,-85,-78,82,104,-89,-133,99,134,7,1151,4588,8007,6731,-646,-8759,-10201,-4087,2431,2448,-2631,-5277,-1072,6627,11312,10260,5929,2468,2648,6956,13061,16043,11595,747,-9494,-11933,-6001,1721,3797,-1531,-9540,-13710,-11118,-4324,1135,1348,-2963,-7487,-8342,-5196,-757,2166,2729,1746,394,-415,-61,1521,3504,4591,4122,2713,1693,1889,2941,3658,3066,1257,-655,-1480,-958,93,573,-18,-1376,-2808,-3694,-3753,-3175,-2562,-2510,-3074,-3669,-3623,-2837,-1857,-1314,-1321,-1412,-1031,-81,999,1668,1771,1599,1521,1651,1855,1972,1946,1798,1567,1296,1016,742,503,346,264,139,-154,-575,-919,-1031,-968,-923,-1028,-1250,-1455,-1519,-1409,-1202,-1030,-967,-968,-927,-782,-549,-289,-74,40,60,84,214,446,665,770,764,711,652,589,531,490,450,370,223,25,-180,-335,-400,-387,-370,-430,-569,-694,-706,-602,-471,-412,-449,-525,-557,-505,-392,-264,-156,-80,-38,-16,22,104,209,270,242,162,111,134,203,262,278,246,176,89,15,-26,-52,-106,-204,-316,-396,-430,-438,-440,-434,-416,-392,-369,-340,-291,-220,-143,-79,-39,-15,8,41,76,97,90,60,29,14,14,16,14,5,-11,-27,-37,-46,-67,-106,-145,-167,-172,-172,-170,-160,-144,-129,-110,-85,-61,-56,-68,-68,-40,-6,4,-2,9,41,58,36},
            {8,-5,-11,9,23,-5,-33,-4,37,4,-57,-22,67,39,-85,-78,82,104,-89,-133,99,134,7,1151,4588,8007,6731,-646,-8759,-10201,-4087,2431,2448,-2631,-5277,-1072,6627,11312,10260,5929,2468,2648,6956,13061,16043,11595,747,-9494,-11933,-6001,1721,3797,-1531,-9540,-13710,-11118,-4324,1135,1348,-2963,-7487,-8342,-5196,-757,2166,2729,1746,394,-415,-61,1521,3504,4591,4122,2713,1693,1889,2941,3658,3066,1257,-655,-1480,-958,93,573,-18,-1376,-2808,-3694,-3753,-3175,-2562,-2510,-3074,-3669,-3623,-2837,-1857,-1314,-1321,-1412,-1031,-81,999,1668,1771,1599,1521,1651,1855,1972,1946,1798,1567,1296,1016,742,503,346,264,139,-154,-575,-919,-1031,-968,-923,-1028,-1250,-1455,-1519,-1409,-1202,-1030,-967,-968,-927,-782,-549,-289,-74,40,60,84,214,446,665,770,764,711,652,589,531,490,450,370,223,25,-180,-335,-400,-387,-370,-430,-569,-694,-706,-602,-471,-412,-449,-525,-557,-505,-392,-264,-156,-80,-38,-16,22,104,209,270,242,162,111,134,203,262,278,246,176,89,15,-26,-52,-106,-204,-316,-396,-430,-438,-440,-434,-416,-392,-369,-340,-291,-220,-143,-79,-39,-15,8,41,76,97,90,60,29,14,14,16,14,5,-11,-27,-37,-46,-67,-106,-145,-167,-172,-172,-170,-160,-144,-129,-110,-85,-61,-56,-68,-68,-40,-6,4,-2,9,41,58,36}
        },
        {    // H-10e005a.wav
            {-2,5,6,-5,-8,10,17,-8,-25,4,30,-6,-48,-6,61,19,-79,-48,83,68,-92,-85,109,90,74,1378,4556,7174,5316,-1446,-7916,-8183,-2567,2364,1461,-3032,-4572,-235,6396,9923,8671,5073,2499,3002,6816,11885,14047,9867,556,-7843,-9551,-4520,1583,2792,-1979,-8613,-11788,-9345,-3663,614,462,-3213,-6748,-7154,-4442,-886,1408,1913,1251,250,-368,-15,1394,3105,3981,3521,2362,1678,2073,3048,3480,2647,890,-680,-1164,-610,154,318,-333,-1468,-2557,-3149,-3052,-2497,-2057,-2199,-2817,-3296,-3094,-2258,-1351,-925,-1052,-1310,-1176,-488,440,1129,1364,1304,1226,1252,1334,1408,1464,1492,1446,1292,1049,781,561,425,323,141,-179,-545,-782,-817,-759,-780,-957,-1216,-1410,-1431,-1285,-1081,-942,-901,-888,-815,-655,-436,-207,-25,60,59,67,178,379,565,651,638,574,498,437,412,418,409,339,198,14,-174,-317,-368,-335,-298,-344,-479,-606,-630,-551,-450,-401,-413,-446,-454,-418,-345,-261,-189,-145,-126,-107,-55,43,151,209,189,129,99,130,197,251,262,228,163,90,32,-4,-40,-104,-196,-284,-337,-351,-346,-339,-333,-326,-318,-307,-289,-260,-220,-169,-115,-73,-47,-28,-2,25,36,22,-5,-30,-47,-56,-52,-37,-23,-23,-32,-38,-39,-45,-61,-79,-92,-99,-105,-108,-106,-99,-89,-78,-69,-69,-76,-81,-76,-63,-46,-24,-1,12,10},
            {-9,4,24,7,-33,-21,35,28,-51,-58,49,81,-53,-128,29,157,-15,-192,8,211,-8,464,3459,7966,9008,2758,-7317,-12376,-7898,553,3634,-712,-5311,-2994,5080,11714,12072,7632,3091,2095,5780,12471,17400,14996,4215,-8595,-14317,-9600,-179,4709,816,-8080,-14433,-13504,-6663,381,2383,-1385,-6962,-9429,-7058,-2098,1971,3391,2614,960,-398,-569,847,3215,4982,4906,3250,1585,1353,2609,4040,4122,2421,-26,-1593,-1456,-227,728,494,-835,-2521,-3798,-4226,-3834,-3152,-2906,-3400,-4171,-4390,-3674,-2444,-1483,-1196,-1299,-1155,-386,782,1758,2144,2048,1884,1932,2151,2342,2372,2225,1938,1568,1174,803,493,289,189,80,-186,-611,-997,-1140,-1053,-948,-1009,-1235,-1479,-1584,-1485,-1253,-1045,-976,-1019,-1042,-941,-716,-432,-165,13,72,83,173,395,653,810,822,755,684,632,597,575,544,462,309,104,-111,-291,-391,-396,-363,-397,-543,-717,-782,-696,-552,-475,-499,-559,-577,-522,-411,-275,-151,-71,-46,-48,-17,87,236,342,340,253,169,151,195,255,290,277,207,99,2,-45,-56,-93,-189,-313,-409,-463,-494,-514,-515,-496,-469,-440,-395,-325,-237,-149,-73,-16,15,27,42,76,116,134,117,83,57,48,50,49,39,21,4,-6,-16,-40,-81,-132,-183,-221,-237,-234,-225,-217,-200,-163,-114,-75,-57,-52,-43,-22,9,35,41,27,22,52,97,105,59}
        },
        {    // H-10e010a.wav
            {-3,-4,0,6,2,-8,-4,11,10,-13,-17,12,22,-16,-37,9,48,-6,-70,-15,76,25,-89,-27,111,37,192,1729,4627,6309,3760,-2354,-7099,-6251,-1331,1951,406,-3062,-3318,913,6122,8405,7139,4431,2691,3406,6772,10945,12267,8080,-20,-6694,-7536,-3196,1404,1742,-2523,-7808,-9972,-7637,-3023,104,-414,-3492,-6095,-6072,-3717,-874,941,1395,920,135,-305,136,1442,2867,3485,3020,2098,1660,2108,2949,3222,2353,705,-712,-1127,-641,-10,84,-494,-1425,-2262,-2667,-2539,-2101,-1803,-1964,-2451,-2770,-2523,-1782,-1014,-671,-814,-1096,-1078,-608,87,647,902,944,950,1008,1105,1204,1280,1299,1224,1043,791,544,378,305,240,69,-225,-526,-697,-715,-682,-717,-865,-1073,-1231,-1243,-1104,-914,-789,-753,-736,-663,-522,-338,-141,27,117,128,131,204,340,462,509,488,437,384,341,317,307,285,225,118,-28,-185,-305,-349,-329,-317,-374,-481,-558,-551,-481,-413,-390,-405,-420,-404,-350,-273,-197,-143,-126,-132,-127,-77,25,136,196,186,143,121,140,180,212,216,185,123,52,-1,-36,-77,-143,-218,-271,-289,-287,-284,-282,-277,-273,-275,-275,-260,-229,-191,-157,-128,-103,-83,-66,-46,-26,-18,-29,-53,-74,-80,-71,-55,-41,-34,-31,-25,-16,-9,-9,-16,-33,-58,-80,-85,-73,-63,-67,-75,-73,-66,-75,-98,-112,-101,-76,-55,-38,-18},
            {17,18,-22,-37,18,49,-24,-81,9,108,10,-148,-58,163,96,-181,-120,212,110,47,2170,7033,10419,6557,-4123,-12986,-11898,-3004,3409,1217,-4503,-4455,3330,11843,13888,9368,3636,1620,4899,11888,18132,17701,7869,-6502,-15470,-12956,-2899,4508,2552,-6438,-14381,-15033,-8637,-733,2699,-220,-6206,-9904,-8458,-3449,1322,3417,3023,1548,125,-476,370,2530,4628,5028,3541,1752,1440,2840,4524,4804,3161,570,-1341,-1562,-426,754,806,-449,-2295,-3818,-4477,-4284,-3733,-3515,-3998,-4818,-5106,-4295,-2720,-1350,-895,-1186,-1393,-833,422,1700,2403,2496,2364,2326,2399,2465,2469,2411,2253,1950,1533,1088,684,365,150,-25,-294,-717,-1145,-1339,-1239,-1049,-1020,-1212,-1479,-1625,-1560,-1342,-1126,-1037,-1065,-1083,-981,-751,-457,-167,49,145,150,186,350,599,795,858,825,765,698,623,556,516,469,357,161,-76,-277,-382,-384,-347,-371,-507,-699,-825,-805,-675,-550,-511,-542,-559,-504,-388,-262,-163,-93,-47,-25,-6,57,184,322,382,335,248,212,250,312,337,305,227,121,10,-73,-112,-138,-201,-310,-421,-488,-513,-532,-556,-566,-546,-503,-449,-379,-287,-185,-94,-24,22,49,70,106,151,180,170,132,96,81,79,74,60,40,20,8,2,-10,-46,-104,-163,-204,-226,-238,-247,-252,-248,-223,-175,-123,-91,-78,-57,-11,42,75,84,80,70,60,66,97,125,111,55}
        },
        {    // H-10e015a.wav
            {-3,-3,-3,-3,0,4,0,-7,-2,10,6,-12,-12,11,14,-17,-26,13,33,-16,-54,0,58,2,-69,3,81,7,302,1872,4368,5409,2750,-2504,-6082,-4943,-875,1483,46,-2526,-2344,1203,5273,7041,6154,4130,2765,3390,6309,9876,10839,7033,64,-5471,-6061,-2479,1158,1251,-2354,-6697,-8434,-6510,-2805,-402,-955,-3457,-5446,-5306,-3373,-1081,466,1002,747,111,-306,68,1258,2572,3163,2805,2058,1694,1994,2544,2639,1911,653,-428,-805,-532,-110,-34,-460,-1205,-1923,-2297,-2205,-1826,-1539,-1622,-2000,-2294,-2166,-1624,-1017,-717,-791,-964,-904,-530,-43,320,509,636,788,938,1015,1002,933,843,746,640,522,399,293,218,140,-1,-218,-436,-555,-558,-527,-565,-704,-883,-1004,-1005,-906,-781,-692,-643,-601,-539,-443,-303,-128,33,123,142,155,215,304,366,381,367,340,297,242,196,167,140,92,15,-89,-206,-301,-338,-325,-316,-362,-450,-511,-499,-432,-367,-344,-358,-377,-370,-323,-248,-170,-111,-78,-66,-57,-28,28,92,129,128,111,111,138,173,188,169,118,52,-8,-48,-73,-100,-144,-199,-247,-274,-281,-276,-268,-263,-258,-251,-242,-231,-215,-190,-159,-130,-109,-95,-84,-73,-64,-60,-60,-63,-68,-72,-70,-59,-44,-32,-28,-25,-15,-3,-2,-17,-40,-56,-61,-62,-62,-57,-50,-50,-61,-74,-85,-104,-134,-151,-124,-59},
            {4,-42,-16,48,19,-76,-49,88,80,-110,-145,90,184,-87,-228,96,244,-70,925,5181,10408,10137,1032,-10904,-15096,-8354,942,2790,-2474,-5366,405,10478,15695,12483,5352,1097,3139,10398,18300,20392,12362,-2883,-15414,-16399,-6778,3327,4381,-3949,-13685,-16648,-11189,-2355,2989,1451,-4783,-10115,-10207,-5313,610,3813,3585,1687,49,-449,307,1997,3734,4391,3624,2390,2082,3148,4665,5189,3952,1462,-850,-1665,-815,589,1115,172,-1716,-3568,-4697,-4958,-4667,-4390,-4564,-5066,-5217,-4428,-2878,-1452,-934,-1281,-1671,-1252,106,1726,2764,2934,2627,2385,2394,2505,2560,2538,2436,2200,1820,1370,931,536,213,-30,-276,-649,-1119,-1454,-1468,-1266,-1142,-1264,-1530,-1718,-1697,-1495,-1244,-1086,-1071,-1108,-1036,-780,-410,-67,145,202,167,172,330,621,887,986,919,796,697,622,555,499,442,338,158,-72,-285,-419,-450,-414,-402,-496,-680,-832,-833,-695,-543,-491,-536,-584,-552,-432,-275,-138,-46,-5,-2,-3,39,152,299,393,374,284,226,259,339,383,353,265,146,17,-93,-156,-184,-230,-326,-437,-505,-519,-524,-549,-577,-577,-542,-489,-423,-338,-238,-145,-79,-42,-17,20,82,158,216,227,191,138,102,97,109,107,77,34,3,-6,-12,-40,-94,-152,-193,-217,-232,-242,-245,-241,-230,-206,-169,-132,-110,-97,-64,3,82,131,139,130,129,131,116,90,74,74,66,35}
        },
        {    // H-10e020a.wav
            {0,-2,-3,-3,-4,-4,0,3,-1,-5,0,9,3,-12,-9,10,10,-14,-19,11,22,-17,-40,5,44,-3,-48,10,51,6,374,1848,3953,4621,2144,-2311,-5150,-4048,-659,1234,58,-1989,-1825,1028,4380,6003,5480,3865,2648,3138,5709,8872,9727,6427,426,-4337,-4913,-1965,1059,1132,-1915,-5627,-7198,-5731,-2771,-834,-1255,-3241,-4866,-4838,-3315,-1331,183,814,602,-40,-426,9,1213,2477,3013,2625,1834,1381,1590,2123,2317,1781,749,-159,-496,-312,-5,43,-316,-980,-1665,-2031,-1915,-1508,-1233,-1375,-1816,-2157,-2085,-1624,-1081,-767,-749,-819,-713,-363,54,323,402,409,447,511,555,576,593,594,542,434,312,225,190,186,162,70,-93,-268,-379,-405,-399,-440,-564,-732,-855,-862,-761,-628,-539,-511,-505,-476,-396,-257,-86,56,115,107,103,157,246,309,315,282,235,184,134,95,70,43,-9,-94,-196,-283,-325,-309,-263,-243,-286,-371,-441,-451,-406,-345,-307,-300,-303,-293,-258,-203,-140,-84,-47,-33,-27,-6,40,90,114,101,76,75,104,140,153,134,89,25,-45,-103,-136,-153,-174,-205,-236,-256,-267,-273,-272,-261,-245,-231,-216,-193,-161,-127,-99,-84,-85,-97,-105,-96,-75,-56,-47,-45,-48,-58,-68,-64,-48,-37,-34,-28,-17,-15,-29,-46,-52,-49,-46,-37,-20,-12,-27,-48,-56,-67,-107,-156,-153,-82},
            {-40,37,52,-49,-94,32,122,-23,-178,-30,196,58,-233,-84,267,56,108,2922,8646,12062,6957,-5414,-15171,-13912,-4571,2001,167,-4257,-2246,6884,15078,15358,8946,2651,2025,7849,16495,21550,17115,3086,-12399,-18572,-12014,-386,4924,-436,-10745,-16790,-14197,-5939,1331,2665,-1988,-8254,-10901,-7931,-1804,3202,4661,3159,704,-1048,-1216,375,2921,4791,4779,3337,2172,2541,4104,5365,5012,2903,150,-1641,-1552,-100,1180,1012,-693,-3036,-4967,-5887,-5793,-5167,-4666,-4606,-4673,-4285,-3288,-2177,-1575,-1572,-1636,-1125,126,1649,2729,2995,2687,2349,2308,2481,2630,2648,2558,2365,2040,1595,1098,625,244,-8,-194,-462,-884,-1323,-1546,-1487,-1333,-1323,-1515,-1766,-1880,-1768,-1501,-1244,-1108,-1053,-945,-710,-404,-128,67,188,262,335,470,684,900,1009,976,863,743,641,554,486,431,347,186,-56,-317,-506,-560,-497,-422,-455,-623,-816,-885,-782,-602,-479,-467,-511,-526,-468,-351,-215,-95,-11,33,55,92,177,299,400,417,342,242,204,251,330,364,316,199,51,-82,-168,-211,-254,-337,-448,-532,-555,-539,-526,-528,-531,-524,-502,-459,-386,-293,-204,-133,-83,-50,-26,12,80,159,206,196,151,113,104,118,133,127,95,54,20,-7,-41,-91,-143,-180,-200,-210,-217,-228,-245,-259,-246,-202,-156,-137,-130,-97,-25,58,124,163,179,177,167,162,149,112,64,39,46,53,33}
        },
        {    // H-10e025a.wav
            {-4,-1,1,-1,-4,-5,-4,-2,0,1,-3,-6,0,7,1,-10,-6,10,9,-12,-16,8,16,-15,-30,7,33,-6,-38,8,33,14,392,1703,3475,3960,1803,-1951,-4307,-3367,-514,1112,160,-1607,-1607,700,3605,5195,4925,3553,2407,2777,5073,7968,8863,6101,914,-3295,-3941,-1520,1061,1180,-1402,-4680,-6253,-5235,-2803,-1081,-1333,-3030,-4536,-4612,-3269,-1410,40,639,446,-105,-390,44,1107,2177,2599,2239,1573,1239,1483,1974,2133,1655,770,16,-226,-12,284,288,-129,-821,-1475,-1803,-1723,-1428,-1253,-1407,-1792,-2079,-1985,-1520,-975,-658,-619,-647,-526,-262,-28,62,58,71,134,215,290,360,411,417,378,321,260,198,160,175,215,194,59,-141,-302,-375,-398,-436,-510,-592,-639,-629,-572,-499,-443,-420,-417,-405,-352,-244,-106,10,61,59,54,86,148,205,234,227,183,110,31,-24,-49,-64,-92,-140,-203,-268,-305,-291,-242,-211,-243,-320,-383,-387,-340,-282,-248,-243,-246,-232,-192,-140,-93,-63,-48,-43,-38,-15,34,88,109,87,51,37,52,76,89,81,43,-24,-102,-161,-189,-198,-208,-224,-237,-242,-241,-239,-236,-227,-210,-186,-161,-136,-110,-84,-68,-68,-78,-84,-80,-75,-71,-65,-57,-55,-60,-62,-57,-53,-56,-60,-60,-60,-62,-60,-49,-35,-26,-19,-9,-4,-12,-24,-28,-39,-77,-122,-124,-68},
            {48,-16,-90,-22,110,62,-131,-125,119,166,-124,-208,151,229,-136,1054,5764,11462,11393,2019,-10832,-16565,-11366,-2473,810,-1864,-2711,3336,12180,15927,12081,5478,2665,6366,14344,20963,19972,8970,-6913,-17396,-15764,-5568,2623,1441,-6964,-14422,-14959,-9163,-2150,1126,-879,-5815,-9372,-8543,-3875,1339,4091,3750,1583,-762,-1925,-1003,1775,4651,5583,4292,2572,2334,3673,5088,5151,3616,1267,-728,-1420,-654,665,1127,-70,-2516,-5015,-6475,-6498,-5471,-4282,-3731,-3929,-4251,-4009,-3159,-2250,-1727,-1437,-864,239,1547,2466,2694,2461,2242,2284,2475,2612,2653,2641,2527,2206,1695,1146,690,354,110,-82,-317,-689,-1142,-1469,-1531,-1429,-1388,-1518,-1743,-1912,-1913,-1725,-1429,-1175,-1054,-991,-830,-517,-156,124,287,378,453,563,736,931,1041,997,853,725,657,604,525,433,337,195,-28,-285,-475,-534,-492,-440,-468,-605,-788,-897,-845,-669,-501,-444,-479,-506,-459,-353,-242,-151,-71,5,67,120,197,317,439,483,408,273,186,200,274,325,308,226,102,-34,-143,-199,-229,-295,-417,-540,-594,-577,-541,-521,-510,-495,-476,-454,-408,-325,-220,-127,-66,-37,-30,-25,7,72,137,158,131,93,78,91,111,117,101,72,49,43,35,-3,-71,-135,-166,-170,-177,-202,-236,-262,-271,-256,-219,-174,-134,-97,-45,24,94,146,180,203,216,216,204,180,139,85,43,34,47,50,28}
        },
        {    // H-10e030a.wav
            {-1,-2,-2,-2,-1,-1,-1,-3,-4,-3,1,2,-1,-2,2,5,0,-7,-1,11,7,-10,-12,8,15,-9,-22,5,26,-2,-25,8,25,22,362,1476,2974,3419,1664,-1474,-3518,-2816,-429,1011,245,-1348,-1525,354,2942,4508,4400,3194,2122,2418,4480,7140,8118,5926,1523,-2232,-3046,-1157,1060,1277,-916,-3902,-5519,-4818,-2741,-1208,-1430,-2962,-4307,-4324,-3041,-1313,-4,490,251,-294,-555,-116,922,1961,2384,2072,1466,1154,1363,1803,1968,1598,897,324,175,357,523,378,-138,-854,-1489,-1802,-1732,-1453,-1262,-1347,-1624,-1814,-1689,-1274,-827,-613,-675,-810,-778,-525,-206,-1,46,19,11,51,126,218,306,359,355,304,237,191,185,205,209,150,23,-130,-248,-303,-314,-329,-381,-456,-505,-490,-426,-369,-357,-381,-405,-402,-357,-265,-144,-39,9,10,11,43,93,130,139,121,80,22,-34,-68,-78,-80,-94,-130,-188,-254,-297,-293,-254,-225,-238,-276,-297,-279,-237,-200,-180,-174,-173,-169,-152,-118,-80,-59,-63,-77,-76,-49,0,46,69,63,37,12,7,20,27,4,-47,-105,-147,-169,-179,-186,-195,-202,-204,-199,-191,-184,-179,-176,-172,-159,-132,-97,-69,-56,-55,-58,-66,-78,-87,-84,-72,-61,-56,-54,-55,-61,-72,-80,-82,-84,-85,-76,-54,-29,-14,-7,-3,-5,-14,-20,-17,-24,-59,-101,-104,-56},
            {-43,-69,36,101,-34,-160,-12,184,32,-233,-56,283,17,-26,2706,8625,12844,8942,-2958,-14215,-16124,-9337,-2327,-811,-1693,1308,8670,14438,13745,8312,4139,5604,12323,19785,21816,14375,-352,-13774,-17309,-10383,-1189,1378,-4025,-11300,-13966,-10760,-5135,-1340,-1494,-4818,-8296,-8639,-4937,347,3582,3250,827,-1217,-1530,-182,2032,3997,4685,3966,2934,2877,3911,4945,4917,3690,1849,131,-816,-668,181,635,-277,-2490,-4909,-6296,-6142,-4912,-3656,-3278,-3861,-4610,-4586,-3600,-2324,-1523,-1273,-994,-165,1102,2188,2597,2402,2095,2059,2275,2510,2638,2662,2543,2198,1675,1173,827,582,322,25,-279,-611,-978,-1285,-1422,-1423,-1442,-1571,-1755,-1885,-1895,-1766,-1521,-1255,-1090,-1037,-958,-711,-314,84,353,486,558,645,774,911,984,949,839,728,649,581,505,427,354,251,79,-147,-360,-493,-529,-506,-501,-572,-708,-819,-813,-690,-550,-487,-503,-522,-480,-383,-273,-179,-100,-28,39,106,186,285,381,430,400,309,222,199,239,289,297,244,145,25,-82,-150,-192,-253,-363,-490,-573,-593,-585,-583,-580,-557,-516,-469,-408,-321,-216,-122,-55,-16,0,-1,2,31,75,98,78,37,12,18,39,52,51,42,41,54,68,59,19,-35,-82,-116,-146,-177,-210,-244,-270,-271,-246,-208,-174,-143,-95,-25,50,105,138,165,198,231,249,241,206,153,95,49,27,30,40,38,20}
        },
        {    // H-10e035a.wav
            {-1,-1,-1,-1,-2,-3,-2,-1,-1,-4,-6,-4,0,2,-1,-3,0,3,0,-5,-2,6,4,-9,-11,4,11,-6,-18,1,18,-1,-19,5,19,20,294,1204,2477,2956,1632,-943,-2763,-2345,-413,856,264,-1155,-1455,68,2346,3825,3832,2830,1906,2141,3915,6312,7427,5866,2215,-1191,-2241,-871,1006,1285,-563,-3216,-4763,-4326,-2686,-1465,-1645,-2823,-3792,-3716,-2703,-1424,-459,-27,-67,-323,-397,25,880,1713,2053,1820,1367,1145,1336,1738,1968,1775,1235,661,327,250,230,51,-354,-886,-1365,-1616,-1570,-1326,-1115,-1126,-1344,-1562,-1576,-1372,-1109,-947,-895,-837,-680,-448,-234,-96,-26,8,25,43,85,160,243,301,318,293,230,154,110,125,161,142,38,-95,-181,-200,-198,-227,-296,-379,-438,-450,-414,-359,-330,-350,-397,-421,-379,-273,-146,-50,-12,-19,-31,-21,9,37,44,29,-1,-34,-57,-63,-60,-66,-93,-140,-199,-256,-286,-270,-219,-179,-184,-224,-250,-230,-175,-121,-99,-113,-144,-166,-165,-145,-122,-105,-98,-98,-97,-81,-44,-2,18,4,-26,-42,-36,-25,-27,-45,-76,-115,-147,-157,-147,-134,-134,-147,-159,-160,-153,-147,-148,-151,-148,-137,-122,-106,-88,-71,-63,-68,-78,-82,-79,-75,-72,-65,-58,-61,-77,-92,-93,-83,-74,-68,-59,-47,-34,-20,-7,-2,-9,-20,-25,-36,-65,-97,-95,-50},
            {-45,96,73,-120,-140,102,178,-110,-236,128,277,-198,465,4645,10883,12932,5906,-6903,-15976,-15332,-8426,-2899,-1282,450,5699,11906,13856,10404,5889,5483,10551,17969,22248,18645,6764,-7590,-15764,-13645,-5732,-646,-2614,-8314,-11767,-10585,-6896,-3914,-3248,-4768,-7136,-8189,-6278,-2105,1499,2328,935,-429,-402,664,1934,3044,3795,3898,3493,3319,3847,4575,4621,3767,2502,1263,154,-670,-951,-848,-1087,-2235,-3953,-5230,-5338,-4454,-3443,-3141,-3728,-4596,-4830,-3999,-2536,-1321,-842,-808,-550,269,1371,2195,2440,2282,2106,2121,2260,2378,2419,2367,2159,1764,1295,920,682,473,197,-135,-478,-814,-1114,-1316,-1404,-1460,-1579,-1754,-1884,-1876,-1710,-1439,-1184,-1065,-1090,-1099,-896,-456,40,383,516,534,568,680,845,971,967,834,673,581,560,540,480,399,309,177,-25,-253,-427,-507,-521,-527,-563,-635,-711,-737,-676,-556,-460,-445,-484,-500,-445,-341,-235,-151,-80,-7,73,155,232,301,348,352,301,223,179,201,260,294,269,200,117,32,-52,-124,-193,-286,-411,-529,-591,-599,-594,-605,-614,-594,-538,-456,-356,-243,-133,-46,8,27,21,10,20,55,88,86,50,6,-25,-39,-42,-38,-28,-9,29,81,118,105,44,-29,-82,-114,-139,-165,-192,-219,-240,-245,-226,-192,-158,-126,-82,-23,40,92,131,167,204,237,253,243,209,163,119,81,51,33,30,33,28,13}
        },
        {    // H-10e040a.wav
            {0,-1,-1,-1,-1,-2,-2,-2,-1,-1,-3,-4,-4,-2,1,1,-1,-1,2,4,1,-4,-2,5,4,-6,-7,5,10,-6,-18,0,21,8,-15,-3,15,22,222,928,1995,2538,1656,-380,-2019,-1923,-469,621,227,-955,-1314,-141,1765,3096,3238,2531,1827,1992,3409,5482,6712,5789,2910,-133,-1442,-669,785,1138,-235,-2424,-3910,-3861,-2721,-1691,-1647,-2471,-3327,-3481,-2827,-1760,-755,-119,54,-98,-233,-5,636,1372,1797,1771,1509,1357,1490,1786,1937,1702,1107,431,-16,-132,-63,-49,-236,-599,-993,-1256,-1308,-1213,-1139,-1226,-1459,-1667,-1669,-1435,-1108,-868,-777,-747,-658,-480,-278,-119,-16,49,82,83,79,105,165,226,253,240,200,153,119,115,129,121,63,-29,-109,-149,-167,-199,-266,-357,-435,-466,-440,-385,-342,-334,-347,-350,-317,-246,-159,-90,-64,-74,-92,-89,-63,-29,-7,-8,-30,-59,-77,-72,-53,-40,-49,-86,-143,-200,-232,-226,-196,-175,-181,-202,-210,-190,-154,-124,-113,-122,-145,-167,-174,-160,-137,-122,-120,-123,-119,-106,-85,-64,-53,-56,-66,-70,-60,-44,-37,-45,-62,-79,-88,-91,-88,-84,-89,-104,-120,-127,-130,-138,-152,-162,-161,-149,-131,-112,-98,-92,-88,-82,-75,-75,-79,-78,-68,-58,-58,-65,-72,-75,-73,-63,-49,-38,-33,-29,-21,-16,-18,-24,-30,-45,-76,-103,-94,-48},
            {92,-27,-158,-40,185,98,-215,-154,264,168,-303,1186,6406,12378,12393,3239,-9727,-17097,-15006,-8157,-2970,-282,3328,8851,12708,11662,7504,5432,8741,15930,22019,21796,13156,-602,-11884,-14429,-9054,-2934,-2294,-6529,-10235,-9886,-6915,-4693,-4596,-5759,-7035,-7719,-7068,-4724,-1697,234,448,94,477,1580,2573,3092,3346,3440,3351,3400,3987,4794,4929,4024,2697,1650,828,-181,-1295,-2043,-2347,-2672,-3320,-3969,-4115,-3729,-3297,-3304,-3814,-4428,-4574,-3913,-2650,-1438,-837,-810,-779,-227,791,1736,2158,2117,2009,2084,2239,2278,2193,2088,1958,1708,1355,1045,834,610,291,-50,-320,-563,-866,-1190,-1418,-1530,-1614,-1712,-1764,-1715,-1586,-1415,-1226,-1071,-1018,-1029,-942,-628,-155,264,476,501,477,527,677,845,919,861,736,636,583,536,470,401,339,249,94,-114,-316,-459,-526,-538,-537,-562,-614,-651,-623,-531,-434,-393,-416,-451,-442,-379,-300,-235,-171,-88,10,95,156,211,271,309,290,225,167,160,197,237,250,237,197,128,41,-36,-99,-181,-308,-452,-549,-579,-584,-609,-638,-631,-576,-499,-414,-313,-196,-92,-26,3,11,7,3,17,58,100,106,67,6,-40,-63,-75,-85,-82,-48,20,90,120,92,31,-28,-73,-112,-149,-179,-197,-205,-206,-201,-191,-176,-153,-114,-64,-15,27,67,110,156,199,232,248,237,202,160,127,103,76,45,25,24,32,31,17}
        },
        {    // H-10e045a.wav
            {1,1,0,0,0,0,-1,-2,-2,-1,-1,-2,-3,-4,-3,-1,0,-1,-2,-2,1,3,1,-3,-3,1,1,-4,-4,2,2,-8,-11,6,19,2,-17,0,23,19,138,658,1545,2147,1676,163,-1284,-1511,-579,299,145,-703,-1077,-317,1126,2312,2695,2382,1900,1917,2900,4610,5941,5656,3563,892,-701,-564,484,1009,227,-1456,-2947,-3422,-2930,-2206,-1962,-2320,-2844,-3010,-2610,-1787,-858,-152,125,13,-174,-56,505,1278,1857,1981,1711,1347,1179,1256,1360,1223,792,285,-19,-35,90,140,-14,-374,-841,-1256,-1471,-1458,-1338,-1282,-1351,-1455,-1456,-1302,-1061,-847,-720,-655,-582,-456,-287,-121,2,64,73,54,43,63,112,168,212,231,217,173,126,107,114,106,51,-38,-117,-163,-189,-224,-281,-353,-421,-461,-455,-404,-336,-286,-272,-282,-290,-270,-217,-154,-113,-108,-120,-121,-102,-71,-38,-9,1,-16,-46,-58,-42,-20,-22,-55,-107,-162,-208,-230,-222,-197,-186,-202,-221,-210,-170,-132,-121,-134,-150,-155,-152,-149,-148,-146,-144,-147,-152,-147,-124,-94,-78,-81,-85,-77,-60,-44,-29,-13,-3,-10,-29,-47,-58,-70,-88,-103,-110,-115,-130,-152,-171,-179,-178,-170,-154,-133,-115,-104,-97,-90,-81,-72,-64,-57,-48,-37,-30,-34,-46,-54,-53,-49,-45,-36,-21,-14,-24,-42,-53,-64,-87,-111,-101,-52},
            {-17,-147,-23,183,56,-235,-97,300,74,-305,1741,7531,13244,12031,1638,-11562,-18246,-15409,-8086,-2202,1583,5753,10224,11808,9173,5752,6483,12608,20366,23964,19518,7739,-5722,-13476,-12208,-5897,-2014,-3972,-8321,-9780,-7452,-4754,-4435,-5849,-7113,-7732,-8008,-7381,-5083,-1934,82,213,-215,366,1961,3490,4257,4300,3849,3260,3206,4109,5317,5518,4196,2173,518,-575,-1499,-2298,-2646,-2601,-2741,-3366,-3991,-3944,-3284,-2785,-3051,-3865,-4432,-4134,-3014,-1685,-833,-699,-893,-747,56,1158,1917,2068,1918,1890,2042,2139,2064,1941,1868,1745,1461,1107,854,703,493,139,-261,-580,-804,-992,-1176,-1357,-1534,-1683,-1746,-1690,-1550,-1382,-1204,-1032,-923,-913,-910,-757,-400,24,315,404,392,423,555,737,871,886,787,647,547,508,489,446,375,294,183,5,-224,-414,-489,-475,-466,-513,-575,-590,-545,-474,-405,-358,-353,-392,-432,-415,-333,-242,-188,-155,-101,-17,66,130,187,245,281,260,194,138,136,179,218,219,186,139,87,30,-29,-91,-175,-294,-424,-520,-567,-588,-607,-617,-595,-534,-446,-353,-265,-188,-123,-72,-38,-27,-27,-11,36,91,112,86,41,9,-10,-32,-61,-79,-71,-34,17,59,70,44,-2,-46,-78,-109,-147,-188,-214,-212,-188,-164,-152,-145,-126,-93,-58,-28,3,44,92,143,192,229,244,233,205,175,148,121,88,53,26,16,22,32,31,16}
        },
        {    // H-10e050a.wav
            {1,1,1,1,0,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-3,-4,-4,-2,-1,-1,0,2,3,0,-6,-7,0,5,1,-6,-7,-3,-1,0,6,10,1,-8,5,20,10,75,434,1133,1758,1664,668,-574,-1120,-716,-52,50,-448,-829,-473,536,1615,2249,2303,2008,1869,2422,3748,5126,5423,4095,1828,47,-307,446,1100,654,-886,-2611,-3519,-3291,-2434,-1762,-1719,-2132,-2489,-2395,-1806,-971,-235,159,201,123,230,648,1207,1572,1520,1134,733,619,829,1124,1206,973,572,229,54,-5,-76,-262,-585,-974,-1290,-1414,-1343,-1199,-1128,-1180,-1280,-1301,-1171,-933,-711,-602,-590,-569,-457,-274,-109,-25,-9,-10,6,43,92,139,173,190,193,182,154,117,86,65,40,-5,-66,-127,-179,-225,-270,-314,-359,-400,-425,-417,-378,-330,-295,-282,-285,-285,-264,-214,-154,-112,-103,-111,-111,-88,-50,-13,6,0,-24,-48,-59,-58,-54,-53,-64,-98,-155,-213,-242,-233,-210,-200,-203,-204,-193,-177,-163,-150,-139,-137,-148,-161,-161,-149,-140,-144,-155,-161,-156,-137,-110,-82,-63,-60,-65,-59,-34,-2,16,16,4,-14,-35,-55,-69,-80,-95,-118,-144,-167,-183,-192,-193,-185,-173,-159,-144,-127,-107,-86,-67,-52,-40,-29,-20,-18,-26,-38,-45,-50,-57,-63,-55,-35,-23,-32,-48,-54,-60,-83,-109,-101,-52},
            {-138,38,191,6,-259,-66,313,29,-320,1900,7925,13758,12358,1388,-12584,-19741,-16589,-8139,-899,3606,7305,10294,10306,7180,4957,8000,15954,23475,24531,16852,3551,-8566,-13392,-10225,-4420,-2258,-4869,-8062,-8004,-5504,-3992,-4895,-6730,-7969,-8646,-8878,-7723,-4735,-1497,-130,-649,-1019,199,2341,3935,4445,4273,3890,3687,4138,5235,6012,5375,3420,1307,-190,-1323,-2424,-3099,-2907,-2336,-2379,-3230,-4036,-4022,-3401,-2950,-3046,-3404,-3542,-3216,-2486,-1638,-1041,-849,-792,-401,453,1374,1871,1881,1756,1787,1916,1943,1848,1770,1742,1620,1322,980,765,632,379,-65,-539,-852,-987,-1053,-1143,-1277,-1448,-1617,-1700,-1637,-1464,-1265,-1080,-917,-813,-803,-806,-657,-301,104,344,380,361,433,600,764,837,798,681,553,476,460,456,417,337,228,87,-93,-274,-392,-424,-421,-453,-525,-579,-563,-484,-392,-330,-314,-339,-382,-406,-379,-307,-231,-182,-149,-98,-21,65,137,191,232,251,226,165,113,113,156,192,183,136,80,29,-22,-73,-123,-185,-277,-391,-487,-535,-549,-559,-567,-550,-496,-421,-344,-270,-201,-144,-109,-96,-90,-70,-26,34,86,107,93,56,16,-16,-37,-48,-53,-46,-17,32,70,59,0,-65,-103,-120,-144,-180,-210,-219,-209,-188,-162,-134,-111,-94,-78,-60,-41,-19,13,62,124,185,228,243,232,206,175,146,117,88,59,36,23,20,22,21,15,6}
        },
        {    // H-10e055a.wav
            {1,1,1,1,1,1,1,0,0,0,-1,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,0,2,3,1,-3,-5,-2,3,4,-2,-7,-4,3,5,4,6,8,2,-2,11,24,8,22,241,773,1395,1604,1074,72,-709,-803,-406,-106,-230,-535,-523,53,995,1846,2221,2076,1806,2016,3008,4361,5123,4573,2886,1040,17,33,447,370,-571,-1948,-2920,-2959,-2262,-1521,-1299,-1612,-2030,-2099,-1656,-866,-70,412,458,219,12,73,387,732,898,856,757,776,949,1140,1155,903,465,23,-274,-393,-404,-415,-516,-730,-992,-1190,-1238,-1147,-1015,-948,-975,-1028,-1010,-880,-695,-550,-489,-474,-435,-342,-218,-104,-23,26,52,65,77,99,130,157,161,134,87,46,25,20,9,-27,-91,-171,-246,-294,-309,-309,-323,-358,-394,-401,-372,-323,-275,-241,-224,-217,-206,-175,-125,-79,-64,-80,-104,-108,-86,-54,-33,-34,-52,-71,-81,-83,-82,-85,-95,-117,-149,-180,-199,-203,-201,-203,-210,-216,-215,-202,-175,-143,-121,-120,-134,-146,-145,-136,-130,-133,-140,-142,-136,-119,-94,-70,-59,-61,-65,-57,-32,0,22,21,1,-25,-50,-74,-96,-110,-118,-129,-151,-175,-188,-186,-179,-169,-152,-127,-102,-85,-72,-57,-42,-33,-33,-40,-50,-59,-61,-56,-51,-48,-44,-38,-35,-36,-35,-30,-34,-58,-85,-82,-43},
            {-48,167,84,-211,-130,265,103,-330,1521,7423,13922,13569,2785,-12486,-21384,-18638,-8746,390,5495,8183,9666,8844,5894,4647,9068,18052,25305,24615,14949,1108,-9733,-12837,-9058,-3847,-2284,-4573,-6829,-6209,-4089,-3646,-5651,-8064,-9131,-9087,-8616,-7313,-4737,-1948,-642,-969,-1304,-265,1825,3655,4386,4135,3611,3678,4780,6293,6775,5378,2849,664,-613,-1553,-2552,-3125,-2821,-2205,-2279,-3170,-3988,-3992,-3403,-2936,-2914,-3086,-3078,-2746,-2178,-1600,-1245,-1128,-933,-311,674,1532,1863,1758,1612,1639,1729,1738,1705,1724,1725,1551,1203,873,705,612,396,-14,-506,-919,-1170,-1264,-1266,-1270,-1342,-1458,-1524,-1488,-1382,-1253,-1104,-947,-844,-824,-781,-554,-133,279,464,416,323,361,531,711,799,772,662,523,411,362,369,383,353,253,86,-117,-295,-388,-390,-367,-400,-495,-577,-573,-486,-381,-315,-298,-316,-346,-358,-328,-265,-206,-179,-166,-119,-21,98,193,248,268,252,197,120,67,69,111,146,142,107,61,12,-41,-96,-152,-219,-307,-400,-466,-489,-489,-489,-492,-480,-444,-389,-326,-267,-220,-187,-163,-141,-116,-86,-43,14,71,103,95,61,28,10,-3,-22,-41,-40,-6,43,75,64,13,-55,-118,-165,-200,-226,-241,-241,-224,-195,-161,-125,-92,-65,-48,-38,-30,-17,8,48,102,160,208,234,234,214,183,149,113,77,48,32,30,35,37,32,21,10,3}
        },
        {    // H-10e060a.wav
            {1,1,1,2,2,2,2,2,1,0,0,1,1,0,-1,-1,0,1,1,1,1,1,0,0,2,4,4,1,-2,-3,0,3,3,0,-1,2,6,7,5,4,8,12,12,11,7,-9,-5,127,504,1065,1478,1345,600,-325,-830,-694,-267,-74,-265,-483,-259,504,1433,2020,2063,1851,1953,2731,3939,4785,4514,3067,1213,-22,-167,355,642,94,-1114,-2239,-2620,-2187,-1429,-923,-902,-1181,-1402,-1317,-924,-429,-107,-103,-317,-466,-316,128,640,963,1001,847,680,620,646,634,469,160,-165,-364,-393,-328,-291,-370,-571,-821,-1005,-1040,-940,-810,-757,-797,-850,-833,-739,-626,-545,-498,-456,-393,-304,-198,-98,-29,-1,2,11,35,57,60,51,50,56,49,19,-17,-42,-63,-103,-166,-231,-272,-286,-285,-282,-284,-292,-305,-312,-297,-257,-210,-180,-174,-176,-166,-141,-114,-100,-102,-117,-137,-147,-136,-106,-77,-65,-71,-82,-92,-100,-105,-103,-97,-101,-125,-163,-198,-216,-217,-211,-207,-203,-194,-175,-148,-121,-103,-101,-112,-126,-131,-123,-110,-101,-102,-113,-126,-129,-115,-86,-58,-47,-51,-56,-48,-32,-21,-24,-39,-61,-88,-110,-116,-108,-103,-110,-125,-137,-143,-142,-135,-120,-102,-87,-77,-72,-74,-82,-92,-97,-94,-83,-66,-50,-39,-32,-27,-24,-26,-30,-26,-14,-8,-22,-45,-50,-28},
            {97,87,-139,-160,191,202,-314,744,5911,13253,15350,6280,-10259,-22537,-21931,-10985,783,7148,8911,8941,7690,5183,4407,9175,18614,26136,25043,14599,488,-9879,-12499,-8804,-3812,-1859,-3221,-4842,-4457,-3282,-3985,-6847,-9393,-9734,-8699,-7938,-7289,-5432,-2542,-616,-825,-1808,-1348,940,3389,4376,3891,3158,3340,4671,6298,6831,5495,2959,716,-475,-1146,-1991,-2761,-2785,-2232,-2089,-2831,-3763,-3945,-3363,-2784,-2714,-2928,-2941,-2597,-2096,-1701,-1519,-1429,-1134,-414,586,1414,1741,1672,1548,1553,1604,1601,1582,1609,1614,1473,1187,915,779,717,540,132,-419,-902,-1167,-1241,-1262,-1333,-1430,-1471,-1422,-1334,-1271,-1228,-1151,-1031,-925,-865,-769,-506,-70,351,537,457,307,298,459,659,762,736,626,489,374,322,340,385,387,305,141,-67,-261,-376,-393,-369,-393,-487,-576,-577,-493,-394,-334,-311,-305,-311,-318,-301,-250,-189,-148,-125,-90,-15,93,201,277,304,283,227,150,74,31,38,74,91,65,19,-10,-26,-59,-126,-215,-313,-411,-489,-521,-499,-454,-424,-413,-392,-344,-281,-232,-210,-206,-204,-193,-171,-133,-70,16,94,123,97,50,18,6,-3,-13,-12,7,33,54,61,45,3,-59,-118,-160,-196,-237,-272,-279,-254,-215,-175,-132,-84,-44,-25,-23,-21,-6,24,63,106,147,182,203,205,189,163,137,114,89,63,44,39,42,43,37,30,25,20,11}
        },
        {    // H-10e065a.wav
            {1,2,2,2,2,2,2,1,1,2,2,1,0,0,1,1,1,1,1,1,1,0,0,0,1,2,3,3,1,-1,-1,0,1,1,2,4,4,1,-1,3,11,15,13,7,2,-1,-3,-7,-4,67,317,787,1290,1435,950,30,-728,-845,-428,-34,-64,-353,-386,147,1073,1930,2352,2306,2083,2113,2635,3419,3842,3390,2173,902,274,357,583,321,-534,-1495,-1935,-1619,-874,-301,-304,-831,-1481,-1833,-1716,-1246,-686,-266,-76,-49,-35,80,287,470,506,382,206,114,156,260,306,223,38,-165,-304,-343,-310,-288,-358,-533,-728,-827,-784,-665,-580,-588,-664,-730,-720,-620,-473,-353,-307,-316,-320,-275,-194,-123,-87,-75,-67,-60,-60,-64,-57,-35,-15,-21,-55,-95,-121,-135,-152,-177,-200,-210,-209,-202,-191,-178,-179,-203,-239,-256,-237,-198,-167,-155,-158,-166,-174,-176,-166,-149,-140,-147,-158,-155,-134,-107,-91,-92,-103,-113,-116,-113,-110,-114,-129,-151,-175,-193,-198,-189,-170,-153,-146,-146,-143,-129,-110,-95,-88,-86,-87,-94,-106,-115,-116,-114,-120,-130,-129,-112,-92,-84,-88,-92,-91,-91,-92,-85,-68,-53,-58,-78,-94,-91,-76,-64,-62,-67,-78,-95,-113,-122,-118,-111,-113,-124,-132,-130,-121,-109,-94,-72,-49,-37,-36,-33,-19,-5,-2,-5,0,10,11,-2,-14,-11},
            {171,-85,-262,57,346,-134,-80,3619,11218,16488,11192,-5046,-21493,-25695,-15720,-1024,8291,10233,8739,6715,4605,4050,8364,17677,26069,26078,15944,1386,-9513,-12495,-9074,-4014,-1267,-1437,-2442,-2574,-2613,-4407,-7814,-10342,-10210,-8546,-7546,-7318,-6061,-3207,-733,-597,-1992,-2298,-302,2566,4184,3980,3060,2818,3802,5419,6335,5516,3265,1030,-138,-601,-1257,-2082,-2275,-1740,-1499,-2312,-3537,-3950,-3329,-2587,-2485,-2807,-2908,-2576,-2108,-1830,-1794,-1808,-1558,-826,242,1167,1572,1542,1433,1421,1411,1335,1323,1483,1682,1665,1365,984,767,734,670,360,-172,-687,-982,-1085,-1168,-1325,-1486,-1541,-1470,-1349,-1249,-1186,-1123,-1027,-912,-831,-776,-630,-287,171,497,533,386,296,377,543,659,681,632,534,414,327,321,381,428,386,229,-8,-236,-362,-369,-343,-389,-513,-618,-614,-514,-397,-322,-293,-292,-307,-318,-296,-234,-163,-123,-114,-94,-26,87,206,296,334,319,259,175,95,46,35,40,33,3,-30,-44,-42,-51,-93,-170,-273,-388,-484,-530,-521,-483,-443,-407,-361,-302,-245,-205,-190,-198,-217,-223,-196,-142,-80,-13,59,116,123,76,15,-19,-25,-22,-15,10,53,89,92,58,-1,-70,-136,-186,-218,-239,-249,-246,-234,-220,-200,-158,-95,-37,-10,-13,-23,-21,1,42,96,148,179,186,177,160,136,110,91,81,74,67,65,71,74,64,43,27,22,19,11}
        },
        {    // H-10e070a.wav
            {1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,-1,-1,1,2,1,0,-1,-1,0,2,3,2,-1,-3,-1,2,3,1,0,1,1,1,5,11,13,7,-1,-2,3,7,8,4,-6,19,187,587,1110,1397,1098,267,-567,-844,-510,-47,80,-80,-83,363,1079,1638,1790,1627,1450,1574,2168,3089,3833,3816,2880,1524,527,294,564,738,437,-230,-857,-1115,-1004,-822,-900,-1317,-1816,-2005,-1681,-990,-300,62,9,-303,-606,-689,-514,-212,23,84,23,-16,63,219,322,278,109,-81,-196,-209,-163,-132,-177,-306,-465,-579,-607,-570,-521,-497,-504,-520,-515,-473,-407,-356,-347,-369,-381,-358,-309,-256,-216,-192,-186,-192,-196,-184,-155,-118,-88,-77,-91,-120,-142,-138,-113,-87,-78,-83,-92,-101,-114,-134,-161,-191,-217,-229,-222,-205,-191,-188,-194,-200,-199,-186,-164,-147,-148,-167,-186,-189,-175,-154,-136,-123,-118,-123,-134,-142,-143,-139,-136,-137,-138,-136,-130,-120,-110,-105,-107,-115,-121,-117,-100,-79,-66,-71,-90,-112,-127,-135,-139,-143,-147,-152,-158,-160,-152,-136,-119,-111,-112,-112,-101,-79,-56,-42,-41,-49,-57,-58,-52,-45,-46,-61,-86,-111,-129,-140,-147,-150,-147,-136,-119,-100,-83,-69,-60,-57,-57,-50,-30,-5,15,26,32,35,31,18,5,-1},
            {148,-243,-237,278,260,-388,1100,7432,15443,16054,3484,-15952,-27664,-22867,-6984,7134,12124,10177,6594,3907,3142,6556,15211,24802,27480,19260,4420,-8259,-12922,-10169,-4685,-737,392,-84,-741,-1688,-4005,-7618,-10548,-10950,-9353,-7864,-7289,-6300,-3859,-1262,-644,-1994,-2926,-1547,1409,3674,3985,3021,2322,2857,4386,5686,5478,3606,1288,-113,-475,-686,-1185,-1459,-1138,-865,-1467,-2680,-3396,-3117,-2517,-2425,-2791,-2957,-2608,-2067,-1792,-1893,-2116,-2067,-1473,-414,656,1272,1365,1233,1133,1069,1007,1063,1352,1730,1866,1603,1137,808,753,789,626,170,-389,-780,-918,-955,-1085,-1336,-1560,-1604,-1452,-1229,-1071,-1012,-986,-942,-905,-892,-803,-504,-34,361,470,346,231,280,440,585,655,653,581,460,358,344,408,470,448,310,78,-174,-346,-385,-347,-350,-451,-580,-625,-561,-450,-362,-313,-290,-283,-287,-280,-238,-170,-118,-109,-114,-72,42,191,312,369,363,310,224,123,37,-5,-3,11,4,-23,-44,-47,-51,-82,-148,-244,-354,-457,-522,-530,-494,-449,-415,-383,-333,-267,-208,-181,-190,-216,-226,-198,-138,-68,-4,52,94,105,76,25,-17,-41,-47,-37,-9,29,61,72,58,18,-44,-112,-167,-203,-229,-248,-249,-227,-198,-175,-148,-102,-44,-6,-5,-30,-53,-56,-31,19,81,137,175,189,178,147,109,79,65,60,60,69,87,106,111,97,72,47,26,11,3}
        },
        {    // H-10e075a.wav
            {0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,-1,-1,0,1,1,1,1,1,-1,-1,1,2,0,-2,1,5,5,2,2,5,3,-1,3,14,17,6,-6,-6,-2,21,147,466,914,1206,1032,385,-327,-589,-247,329,589,319,-177,-379,-12,763,1528,1942,1967,1878,2047,2618,3318,3619,3195,2254,1385,1040,1144,1210,802,-88,-1063,-1657,-1684,-1333,-978,-875,-1009,-1182,-1218,-1091,-910,-811,-861,-1010,-1121,-1057,-791,-430,-137,-11,-21,-50,6,155,312,377,312,165,22,-54,-53,-23,-33,-127,-280,-417,-470,-434,-359,-308,-317,-383,-465,-507,-483,-427,-400,-424,-466,-478,-450,-408,-370,-335,-303,-281,-269,-250,-209,-154,-108,-86,-81,-79,-69,-47,-14,15,21,-4,-48,-86,-108,-123,-148,-185,-220,-236,-230,-212,-192,-175,-167,-175,-192,-204,-203,-197,-200,-211,-217,-210,-196,-183,-171,-159,-148,-139,-132,-124,-115,-107,-97,-83,-70,-68,-77,-88,-89,-82,-76,-79,-89,-100,-106,-103,-96,-95,-111,-143,-175,-194,-197,-192,-186,-180,-175,-169,-159,-140,-114,-93,-84,-85,-83,-70,-50,-38,-42,-56,-68,-69,-63,-56,-56,-68,-91,-118,-138,-143,-134,-118,-99,-81,-67,-60,-59,-62,-65,-63,-50,-23,11,42,61,61,44,20,2,-3},
            {63,-326,-107,413,37,-383,2813,10948,17710,13155,-4534,-23707,-29211,-17501,636,12111,13207,8798,4269,1962,3599,10850,21512,28194,24144,10330,-4860,-13067,-12288,-6493,-870,1911,2086,1072,-359,-2577,-5973,-9606,-11579,-11013,-9045,-7338,-6119,-4502,-2470,-1352,-1926,-2959,-2458,-55,2584,3669,3043,2010,1942,3180,4847,5506,4348,2001,-11,-786,-758,-761,-872,-662,-276,-483,-1527,-2585,-2759,-2213,-1876,-2215,-2772,-2895,-2505,-2027,-1837,-1949,-2093,-1926,-1271,-300,550,956,964,834,734,687,749,1030,1489,1842,1801,1396,964,802,875,881,580,31,-492,-777,-842,-869,-1011,-1255,-1452,-1466,-1299,-1085,-951,-914,-916,-934,-978,-986,-812,-398,84,358,329,166,112,245,459,617,661,605,491,381,341,395,491,529,430,197,-84,-297,-373,-344,-317,-375,-502,-602,-596,-497,-384,-320,-306,-309,-309,-294,-253,-185,-119,-96,-111,-106,-27,117,263,353,373,337,262,163,60,-18,-52,-47,-27,-10,-1,1,-11,-51,-125,-224,-334,-439,-518,-547,-524,-473,-425,-391,-358,-312,-257,-214,-200,-215,-233,-220,-166,-92,-21,43,99,129,110,47,-22,-66,-82,-82,-69,-41,-6,21,31,23,-7,-58,-116,-164,-197,-220,-233,-227,-204,-176,-146,-106,-55,-13,-7,-43,-95,-128,-123,-81,-19,49,112,159,176,161,129,98,74,54,45,55,86,121,136,127,107,85,59,30,8,-1}
        },
        {    // H-10e080a.wav
            {-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,2,1,0,1,2,1,-1,-1,0,0,-1,-1,0,1,1,0,0,0,0,0,-1,-2,-1,2,4,3,1,1,1,-1,-3,1,9,13,8,4,6,10,9,7,4,-2,15,129,393,736,972,962,745,482,268,63,-193,-452,-575,-452,-73,493,1127,1674,1976,1985,1851,1881,2318,3103,3829,3993,3382,2255,1137,409,58,-187,-523,-877,-1031,-886,-594,-436,-593,-1030,-1552,-1931,-2020,-1819,-1474,-1189,-1077,-1081,-1049,-887,-628,-364,-158,-15,92,196,316,433,490,446,323,186,88,39,23,22,7,-54,-161,-269,-327,-329,-316,-333,-392,-468,-523,-535,-514,-499,-519,-566,-598,-584,-528,-459,-396,-347,-312,-289,-266,-225,-162,-95,-46,-19,-3,16,34,42,36,23,3,-28,-72,-116,-142,-151,-159,-175,-191,-194,-187,-185,-192,-201,-209,-222,-242,-258,-257,-243,-233,-234,-232,-214,-185,-160,-144,-130,-112,-94,-82,-74,-62,-48,-42,-47,-57,-61,-58,-55,-59,-70,-84,-101,-123,-143,-152,-149,-149,-165,-191,-211,-213,-202,-190,-180,-171,-162,-154,-143,-122,-94,-75,-77,-92,-100,-93,-78,-68,-64,-61,-56,-51,-51,-56,-63,-72,-80,-84,-82,-73,-63,-58,-58,-58,-57,-57,-58,-56,-47,-33,-17,5,31,46,33,0,-22,-17},
            {-29,-352,32,468,-175,-218,4358,13406,18456,9859,-10623,-28078,-28411,-12551,5726,14521,13066,7464,2653,1026,4875,14797,25701,28657,19208,2556,-10933,-14737,-10114,-2734,2594,4245,3135,1035,-1025,-3407,-6804,-10528,-12532,-11555,-8649,-5952,-4392,-3400,-2567,-2396,-3033,-3265,-1722,1194,3435,3489,1962,821,1438,3466,5294,5389,3502,856,-923,-1230,-772,-478,-474,-390,-256,-531,-1276,-1895,-1908,-1608,-1611,-2019,-2378,-2354,-2122,-2036,-2176,-2311,-2168,-1631,-823,-65,339,358,245,253,396,558,729,1008,1381,1641,1590,1286,991,896,931,853,513,5,-435,-658,-714,-763,-908,-1103,-1222,-1193,-1065,-949,-901,-897,-906,-940,-995,-976,-761,-363,24,193,134,30,66,259,486,616,611,511,388,311,325,427,542,555,404,133,-135,-293,-324,-297,-302,-385,-510,-588,-552,-429,-313,-273,-296,-328,-333,-302,-235,-148,-85,-76,-92,-64,45,192,304,345,324,264,184,98,21,-31,-51,-45,-24,-2,17,30,21,-30,-128,-251,-375,-481,-549,-564,-528,-467,-412,-367,-318,-263,-219,-204,-220,-248,-255,-217,-138,-49,28,91,143,162,125,38,-57,-119,-136,-124,-96,-58,-19,11,23,12,-21,-64,-103,-133,-159,-177,-177,-162,-149,-147,-139,-106,-60,-35,-51,-93,-134,-153,-138,-92,-24,47,102,134,146,143,127,105,84,70,69,86,118,151,167,159,136,109,81,51,23,5}
        },
        {    // H-10e085a.wav
            {0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,0,0,1,2,2,1,-2,-2,1,4,5,4,3,0,-4,-4,2,9,11,9,6,4,2,6,19,25,7,-22,-26,10,82,228,532,982,1345,1286,704,-98,-639,-675,-349,20,243,342,437,625,944,1367,1809,2173,2438,2687,3017,3390,3581,3306,2454,1242,146,-392,-267,219,587,530,86,-490,-974,-1320,-1599,-1864,-2087,-2193,-2123,-1880,-1549,-1264,-1128,-1121,-1110,-957,-644,-272,33,213,294,337,393,469,524,505,404,272,178,149,159,162,123,25,-119,-266,-358,-375,-351,-347,-393,-474,-555,-608,-629,-627,-619,-612,-603,-581,-539,-481,-417,-364,-328,-299,-260,-201,-129,-58,3,45,55,35,13,18,46,63,43,-3,-47,-78,-102,-125,-141,-150,-164,-190,-215,-222,-217,-221,-247,-282,-300,-291,-265,-235,-208,-188,-177,-173,-166,-147,-118,-89,-69,-56,-46,-41,-42,-47,-47,-41,-38,-48,-68,-84,-89,-91,-102,-124,-151,-173,-183,-184,-183,-182,-183,-186,-188,-185,-176,-169,-167,-168,-164,-151,-131,-106,-85,-78,-86,-97,-97,-83,-64,-49,-39,-32,-28,-24,-18,-13,-13,-16,-17,-18,-24,-36,-44,-45,-46,-52,-55,-50,-44,-44,-44,-34,-20,-21,-36,-43,-26},
            {-77,-364,106,500,-280,-144,5093,14512,18596,7974,-13689,-29937,-27493,-9717,8259,15468,12772,6753,1945,767,5814,16980,27523,27892,15281,-2584,-14440,-15115,-7864,635,5666,6115,3528,406,-1780,-3710,-6878,-10950,-13349,-12070,-8172,-4610,-3063,-2912,-3066,-3407,-3910,-3547,-1309,1970,3952,3291,1167,-3,1011,3353,5154,5079,3144,553,-1206,-1477,-819,-231,-121,-238,-389,-720,-1222,-1487,-1253,-911,-1063,-1699,-2192,-2114,-1738,-1631,-1966,-2386,-2406,-1827,-856,35,424,240,-184,-413,-258,167,652,1066,1340,1418,1292,1071,928,943,1004,894,506,-25,-423,-535,-474,-484,-677,-933,-1061,-1007,-880,-801,-792,-818,-871,-960,-1030,-964,-700,-332,-49,21,-70,-143,-46,214,487,613,555,400,267,227,290,423,549,565,414,147,-107,-248,-272,-246,-259,-353,-490,-567,-514,-372,-258,-243,-289,-325,-325,-291,-220,-124,-56,-59,-93,-63,65,223,319,325,273,201,123,49,-8,-41,-49,-41,-27,-7,22,52,54,-4,-115,-244,-365,-474,-557,-580,-533,-453,-392,-356,-312,-248,-198,-195,-230,-263,-257,-206,-124,-34,50,116,150,134,70,-14,-85,-126,-137,-124,-89,-44,-8,10,14,5,-22,-61,-91,-101,-105,-117,-132,-140,-143,-153,-160,-144,-104,-72,-79,-121,-161,-164,-125,-66,-9,39,81,114,128,124,113,104,94,82,77,98,143,186,201,187,164,141,111,70,30,5}
        },
        {    // H-10e090a.wav
            {0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,2,2,1,0,0,2,2,0,-3,-3,0,5,8,6,0,-5,-3,2,6,9,14,15,4,-8,-1,19,22,-2,-19,-5,10,16,102,377,768,986,802,324,-78,-148,40,243,336,368,395,395,349,330,452,779,1312,2008,2727,3207,3207,2736,2104,1665,1512,1451,1260,941,702,722,954,1139,990,396,-494,-1361,-1921,-2093,-2016,-1901,-1871,-1906,-1916,-1834,-1657,-1430,-1205,-1006,-816,-604,-363,-120,89,243,338,389,420,455,489,493,451,379,309,248,181,102,17,-70,-165,-263,-336,-367,-373,-396,-458,-547,-625,-661,-648,-608,-574,-563,-565,-557,-531,-494,-449,-393,-330,-272,-225,-176,-117,-58,-17,9,36,70,93,93,78,64,46,10,-42,-85,-104,-111,-128,-160,-195,-222,-243,-263,-274,-268,-250,-239,-243,-246,-231,-202,-180,-175,-171,-153,-126,-106,-93,-79,-62,-54,-60,-70,-73,-71,-73,-77,-76,-70,-73,-91,-112,-119,-117,-125,-151,-180,-193,-185,-171,-168,-177,-189,-199,-210,-218,-213,-190,-162,-143,-131,-114,-91,-76,-80,-91,-91,-73,-47,-23,-5,10,22,30,34,34,31,25,14,-2,-17,-29,-39,-53,-68,-78,-81,-83,-88,-91,-86,-81,-86,-91,-75,-37},
            {-54,-406,62,547,-229,-319,4664,14194,18767,8504,-13345,-30085,-27826,-9742,8601,15805,12834,6646,1896,818,5887,17022,27401,27250,13800,-4678,-16244,-15588,-6578,3176,8341,7855,3915,-142,-2401,-3821,-6613,-10867,-13704,-12488,-8084,-3929,-2290,-2606,-3355,-4032,-4568,-4044,-1516,2082,4186,3314,824,-544,541,3026,4861,4753,2844,364,-1236,-1320,-504,77,-23,-356,-494,-622,-1000,-1334,-1172,-705,-612,-1134,-1737,-1855,-1590,-1466,-1711,-2060,-2129,-1763,-1073,-336,117,107,-226,-533,-556,-286,156,659,1104,1332,1249,967,749,763,905,902,584,67,-341,-441,-323,-256,-398,-657,-835,-847,-769,-706,-689,-709,-777,-899,-1004,-965,-718,-357,-83,-44,-199,-342,-270,32,383,570,528,355,197,141,209,371,533,571,425,164,-73,-195,-205,-175,-187,-291,-452,-551,-498,-339,-213,-203,-263,-308,-311,-283,-216,-116,-46,-61,-116,-100,33,202,301,303,248,172,88,8,-47,-71,-75,-67,-48,-15,28,68,74,19,-91,-219,-336,-437,-517,-552,-522,-453,-391,-352,-315,-264,-217,-203,-221,-245,-244,-207,-144,-74,-6,57,100,101,47,-39,-106,-128,-118,-96,-65,-24,15,34,32,17,-8,-43,-81,-109,-124,-134,-145,-157,-167,-173,-169,-149,-121,-105,-114,-144,-171,-168,-121,-46,23,61,76,86,99,106,101,91,84,79,78,97,144,199,226,214,184,158,133,94,47,12}
        },
        {    // H-10e095a.wav
            {1,0,0,1,2,2,1,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,2,3,2,1,2,3,2,1,1,1,0,1,4,6,4,0,-3,-4,-1,8,18,19,8,1,7,11,-1,-16,-12,1,1,36,214,555,864,857,440,-158,-566,-561,-184,354,819,1037,960,697,450,359,438,660,1051,1611,2185,2525,2524,2317,2076,1772,1257,583,111,195,801,1508,1889,1828,1487,1051,582,58,-528,-1125,-1631,-1927,-1960,-1805,-1635,-1591,-1672,-1759,-1730,-1545,-1248,-926,-663,-494,-390,-286,-140,35,190,295,358,408,453,475,457,406,348,290,213,105,-12,-99,-149,-190,-248,-317,-377,-422,-459,-494,-524,-549,-569,-577,-565,-540,-519,-515,-521,-520,-501,-464,-416,-362,-300,-231,-162,-97,-33,30,82,103,90,67,58,59,51,28,3,-20,-54,-107,-162,-193,-199,-198,-203,-209,-207,-203,-206,-217,-224,-222,-213,-202,-188,-169,-149,-133,-124,-118,-115,-115,-117,-118,-115,-110,-104,-98,-89,-76,-64,-63,-76,-94,-105,-107,-106,-111,-125,-147,-171,-191,-207,-218,-223,-223,-223,-221,-209,-185,-158,-139,-131,-127,-120,-108,-90,-68,-46,-30,-18,-3,16,35,51,63,70,67,56,42,26,5,-20,-43,-60,-76,-92,-103,-106,-111,-123,-132,-126,-115,-115,-120,-100,-50},
            {43,-452,-99,585,16,-624,3124,12271,18675,11405,-9254,-28141,-29425,-12999,6502,15707,13592,7206,2229,915,5105,15124,25523,26906,15029,-3446,-16344,-16635,-7065,4195,10464,9945,5098,3,-2786,-4036,-6322,-10353,-13504,-12747,-8421,-3968,-2104,-2494,-3385,-4083,-4739,-4644,-2534,1207,4017,3750,1195,-753,-169,2258,4386,4650,2972,481,-1292,-1443,-408,496,458,-136,-524,-627,-846,-1157,-1106,-670,-475,-915,-1522,-1609,-1223,-1032,-1399,-1958,-2115,-1674,-907,-240,14,-192,-599,-822,-681,-325,11,284,580,876,1009,912,741,704,798,805,544,96,-258,-321,-175,-82,-198,-434,-597,-613,-564,-552,-594,-659,-734,-823,-892,-869,-698,-416,-165,-101,-253,-454,-460,-185,204,456,465,322,171,98,135,283,478,572,461,195,-58,-169,-147,-89,-92,-199,-373,-501,-479,-323,-170,-135,-203,-277,-298,-271,-214,-138,-80,-80,-115,-102,6,155,254,262,210,139,65,-3,-54,-85,-100,-100,-78,-35,21,72,96,66,-26,-156,-289,-402,-480,-506,-476,-415,-365,-337,-311,-270,-231,-224,-251,-284,-291,-258,-192,-112,-35,27,67,72,32,-42,-110,-135,-110,-60,-11,30,62,81,79,52,5,-51,-105,-149,-179,-193,-190,-176,-164,-165,-168,-154,-122,-96,-102,-136,-169,-171,-129,-53,28,84,102,94,82,80,83,84,80,74,78,98,139,190,226,230,206,171,134,95,54,19}
        },
        {    // H-10e100a.wav
            {1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,1,1,0,-1,0,2,2,1,0,1,2,3,2,1,0,1,2,2,0,-1,2,3,-1,-6,-1,11,14,6,4,17,23,3,-24,-30,-21,-3,97,385,803,1047,799,89,-645,-919,-618,-41,425,628,683,765,905,986,924,835,958,1391,1936,2258,2198,1867,1483,1192,1055,1058,1054,793,184,-459,-592,35,1075,1875,2034,1642,1044,492,40,-356,-732,-1086,-1377,-1535,-1529,-1426,-1350,-1364,-1419,-1423,-1339,-1185,-985,-760,-559,-444,-412,-373,-236,-14,186,283,291,282,298,324,335,321,280,207,103,-15,-117,-184,-213,-215,-218,-247,-305,-369,-415,-443,-468,-492,-500,-484,-463,-466,-499,-541,-568,-568,-543,-491,-412,-316,-224,-154,-106,-69,-36,-4,25,50,65,64,51,37,26,5,-33,-77,-104,-107,-100,-101,-114,-132,-151,-174,-198,-212,-207,-190,-179,-184,-197,-203,-195,-180,-170,-168,-171,-175,-177,-173,-160,-140,-121,-112,-107,-97,-82,-70,-65,-65,-70,-84,-107,-130,-144,-151,-164,-190,-221,-239,-235,-217,-203,-198,-194,-183,-169,-156,-138,-111,-87,-80,-84,-76,-47,-10,15,27,37,49,61,68,70,64,46,18,-11,-34,-50,-63,-80,-102,-123,-134,-136,-137,-142,-145,-142,-140,-146,-144,-111,-51},
            {196,-422,-337,490,394,-693,1059,8683,17131,15214,-1618,-22630,-30488,-18978,1103,14251,14957,8747,2902,791,3654,11895,22064,26134,18042,993,-14006,-17602,-9481,2951,11439,12344,7475,1360,-2571,-4313,-6249,-9675,-12786,-12693,-9050,-4673,-2429,-2506,-3271,-3831,-4485,-4976,-3907,-679,2894,4088,2314,-175,-750,1010,3350,4310,3282,1090,-811,-1363,-633,349,669,365,20,-208,-628,-1189,-1305,-756,-231,-496,-1319,-1755,-1399,-849,-862,-1440,-1943,-1843,-1146,-285,222,87,-524,-1083,-1153,-744,-193,233,503,652,657,540,455,559,791,888,639,126,-319,-415,-189,57,55,-180,-418,-487,-419,-363,-400,-509,-638,-757,-843,-841,-699,-436,-176,-86,-233,-479,-575,-381,-5,302,382,277,129,46,67,193,380,514,475,258,-6,-160,-154,-66,-19,-90,-258,-412,-434,-305,-136,-63,-116,-212,-267,-263,-220,-155,-98,-87,-122,-134,-58,82,198,228,183,105,24,-41,-79,-94,-102,-106,-91,-46,17,74,110,107,45,-77,-226,-353,-429,-449,-420,-359,-302,-276,-279,-289,-296,-311,-339,-363,-358,-307,-217,-114,-30,18,37,37,16,-32,-85,-104,-75,-22,25,59,87,101,87,47,-5,-58,-108,-157,-196,-217,-220,-207,-186,-165,-150,-134,-109,-83,-77,-102,-144,-167,-145,-78,6,76,115,125,115,95,75,65,67,72,78,96,134,184,220,226,204,168,126,83,43,14}
        },
        {    // H-10e105a.wav
            {1,2,1,0,0,1,2,2,1,1,1,1,1,1,0,-1,-1,0,1,1,0,-1,0,2,2,1,0,1,2,2,0,-2,0,4,4,0,-2,2,4,-2,-7,0,11,8,-1,4,20,19,-1,-11,-6,-17,-7,176,620,1106,1179,592,-358,-1044,-1065,-544,93,534,730,761,696,602,598,806,1253,1824,2320,2554,2442,2036,1498,1009,685,549,553,609,599,410,11,-481,-833,-832,-429,229,893,1345,1479,1312,946,514,115,-223,-518,-776,-960,-1038,-1030,-1000,-998,-1026,-1061,-1083,-1081,-1046,-967,-848,-705,-556,-415,-292,-189,-100,-22,40,86,125,166,202,211,181,123,58,-7,-75,-131,-150,-126,-96,-108,-175,-259,-317,-338,-342,-355,-385,-430,-480,-522,-544,-544,-532,-515,-491,-455,-405,-351,-301,-257,-214,-167,-115,-60,-10,26,38,25,1,-13,-6,15,35,41,29,1,-34,-66,-89,-105,-119,-138,-159,-174,-180,-179,-180,-190,-211,-238,-262,-270,-256,-225,-194,-178,-177,-179,-173,-158,-138,-121,-107,-93,-78,-66,-61,-70,-94,-131,-170,-195,-196,-179,-161,-155,-163,-177,-190,-199,-202,-197,-179,-153,-125,-99,-74,-54,-43,-42,-45,-44,-33,-9,23,51,65,65,56,38,12,-16,-37,-52,-68,-82,-88,-90,-103,-129,-151,-157,-155,-157,-157,-146,-130,-124,-122,-98,-48},
            {307,-219,-485,165,647,-258,-466,4242,13220,17463,7807,-12632,-28223,-25844,-8330,9408,15913,11856,4848,741,1613,7855,17517,24444,21488,7750,-8752,-17264,-13204,-1080,10231,14394,11064,4407,-1120,-4149,-6315,-9241,-12099,-12550,-9776,-5730,-3099,-2660,-3204,-3631,-4084,-4803,-4824,-2841,729,3520,3549,1391,-451,-169,1754,3402,3369,1796,-54,-950,-625,179,584,452,254,196,-74,-728,-1238,-1025,-382,-203,-806,-1534,-1648,-1225,-912,-1064,-1423,-1533,-1188,-535,49,193,-186,-769,-1113,-1042,-698,-269,182,579,746,576,245,104,311,654,749,426,-103,-445,-397,-110,96,54,-136,-274,-280,-228,-226,-313,-456,-612,-746,-816,-760,-549,-257,-55,-89,-330,-565,-568,-301,54,266,256,124,17,7,92,242,401,470,363,117,-111,-179,-96,6,8,-110,-269,-356,-307,-160,-37,-30,-117,-208,-246,-240,-203,-146,-104,-115,-155,-141,-29,117,197,180,105,18,-58,-109,-123,-107,-84,-59,-24,22,67,103,120,94,7,-125,-256,-351,-395,-387,-337,-285,-272,-303,-341,-357,-362,-374,-386,-378,-341,-272,-177,-72,14,59,71,61,27,-30,-79,-82,-41,10,39,51,61,67,54,18,-32,-86,-140,-190,-224,-230,-207,-172,-150,-146,-140,-114,-76,-51,-59,-95,-133,-145,-112,-38,50,116,142,138,121,98,73,57,56,69,90,119,159,198,218,207,168,115,65,31,11}
        },
        {    // H-10e110a.wav
            {1,2,2,2,1,1,1,2,3,2,1,1,2,2,0,-1,1,2,1,-1,0,2,3,2,0,-1,1,4,4,1,-2,1,7,6,0,-2,4,6,0,-4,2,7,2,0,12,23,12,-4,0,2,-12,64,406,977,1371,1106,158,-895,-1355,-1021,-276,356,651,703,678,655,659,744,998,1479,2131,2746,3026,2770,2045,1178,535,286,344,481,499,324,5,-343,-619,-789,-885,-944,-939,-786,-422,116,694,1154,1395,1391,1178,834,451,107,-161,-349,-462,-518,-556,-620,-725,-852,-975,-1084,-1160,-1154,-1026,-811,-612,-512,-503,-502,-439,-314,-180,-89,-52,-43,-29,2,42,75,91,86,60,22,-13,-29,-27,-24,-38,-76,-133,-202,-272,-333,-379,-414,-442,-457,-457,-449,-450,-464,-481,-487,-480,-458,-417,-353,-276,-206,-155,-117,-82,-44,-6,28,53,65,69,71,75,75,67,50,29,4,-28,-64,-96,-119,-132,-145,-166,-199,-236,-262,-273,-275,-278,-280,-270,-246,-214,-186,-167,-157,-156,-157,-151,-130,-103,-87,-93,-114,-136,-150,-159,-165,-165,-158,-147,-136,-129,-125,-126,-136,-152,-163,-158,-136,-106,-78,-55,-38,-27,-23,-23,-21,-18,-16,-13,-5,8,15,9,-4,-19,-36,-58,-80,-93,-95,-93,-94,-99,-109,-126,-144,-155,-155,-149,-133,-109,-89,-82,-80,-65,-32},
            {224,123,-315,-272,404,385,-613,583,7102,15241,14944,788,-18922,-28210,-19480,-919,12895,14936,8961,2353,-157,3096,11437,20586,23366,15247,-282,-13365,-15694,-6964,5758,14142,14429,8773,2014,-2718,-5711,-8626,-11548,-12668,-10715,-6865,-3723,-2748,-3248,-3820,-4072,-4468,-4903,-4259,-1786,1507,3468,2951,1014,-212,348,1879,2761,2185,739,-348,-396,227,679,593,309,200,110,-281,-786,-859,-418,-91,-432,-1190,-1654,-1532,-1193,-1093,-1245,-1328,-1091,-575,-59,136,-106,-569,-889,-896,-723,-536,-304,78,502,681,483,136,-3,175,428,444,158,-206,-377,-287,-91,8,-44,-145,-173,-120,-82,-141,-283,-446,-591,-704,-743,-639,-388,-114,9,-101,-351,-539,-505,-259,28,173,137,28,-31,-2,95,236,367,388,237,-7,-173,-166,-47,47,25,-102,-244,-290,-197,-43,34,-17,-129,-213,-247,-247,-210,-146,-112,-144,-191,-160,-38,91,145,123,61,-12,-83,-128,-131,-104,-67,-27,17,68,119,155,151,86,-28,-152,-261,-352,-415,-423,-376,-319,-300,-315,-331,-340,-361,-399,-426,-410,-344,-240,-113,11,102,142,130,77,-5,-89,-139,-133,-77,-8,41,58,53,38,17,-14,-56,-101,-141,-176,-202,-207,-186,-157,-143,-144,-132,-92,-44,-23,-45,-93,-131,-129,-77,5,85,136,153,145,120,86,55,36,34,50,84,132,179,206,205,172,117,60,20,3}
        },
        {    // H-10e115a.wav
            {0,0,1,1,1,1,2,2,1,0,1,2,1,0,0,1,1,1,1,1,1,1,2,1,-1,0,3,4,1,-2,1,4,3,0,2,5,3,-1,2,8,3,-6,0,17,17,1,3,20,3,-11,188,755,1437,1601,831,-525,-1552,-1590,-789,157,699,788,669,553,522,629,951,1533,2293,2992,3307,3025,2239,1324,668,395,351,335,276,185,35,-238,-613,-949,-1114,-1116,-1073,-1066,-1064,-988,-802,-515,-130,352,877,1326,1579,1594,1419,1145,854,582,327,80,-144,-319,-460,-618,-818,-1003,-1094,-1082,-1040,-1027,-1019,-964,-861,-763,-699,-641,-557,-454,-363,-298,-247,-192,-121,-25,85,173,206,186,148,119,98,74,50,32,10,-34,-105,-182,-244,-286,-321,-359,-396,-424,-444,-470,-508,-546,-561,-546,-510,-467,-416,-346,-257,-164,-90,-46,-25,-9,15,45,70,85,94,105,115,113,90,51,12,-18,-42,-69,-103,-143,-187,-227,-256,-270,-275,-280,-288,-293,-289,-274,-249,-217,-187,-167,-161,-165,-173,-179,-179,-174,-167,-161,-154,-144,-137,-137,-141,-140,-131,-119,-111,-103,-93,-83,-81,-85,-86,-73,-56,-47,-47,-43,-31,-20,-17,-19,-22,-27,-38,-53,-67,-78,-88,-96,-101,-101,-98,-98,-105,-114,-119,-118,-118,-124,-128,-123,-110,-100,-95,-87,-74,-63,-62,-65,-54,-26},
            {-48,306,125,-385,-217,474,212,-644,1506,8651,15382,12125,-3487,-20954,-25965,-14789,2665,13633,13660,7159,857,-722,4086,13485,21518,21094,10241,-4851,-14267,-12329,-1582,10067,15626,13404,6766,303,-3971,-7058,-10220,-12624,-12280,-8876,-4709,-2491,-2783,-4019,-4672,-4675,-4678,-4591,-3513,-1069,1687,3088,2518,1018,192,644,1593,1885,1199,235,-128,273,839,953,615,255,78,-128,-495,-713,-442,67,131,-531,-1409,-1800,-1585,-1226,-1130,-1238,-1214,-856,-291,137,133,-279,-747,-912,-750,-515,-367,-202,99,406,474,276,56,41,190,279,161,-105,-326,-349,-190,-24,-18,-162,-276,-226,-76,2,-72,-233,-391,-528,-631,-637,-484,-223,-9,19,-143,-371,-495,-421,-204,2,74,22,-53,-73,-24,79,211,303,269,96,-104,-187,-116,20,94,45,-92,-212,-217,-108,7,21,-64,-166,-224,-243,-240,-213,-176,-171,-210,-231,-170,-45,67,113,101,55,-13,-86,-136,-143,-112,-59,8,83,148,187,187,137,31,-117,-267,-384,-451,-460,-413,-337,-280,-275,-309,-349,-381,-410,-430,-418,-356,-252,-128,-15,65,100,88,40,-26,-93,-141,-152,-119,-60,-5,22,21,7,-4,-9,-15,-34,-72,-124,-177,-215,-223,-200,-164,-134,-115,-96,-63,-26,-14,-45,-100,-134,-116,-52,27,94,136,146,124,82,42,16,6,11,38,88,144,189,207,188,133,61,7,-10}
        },
        {    // H-10e120a.wav
            {1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,-1,-2,0,2,0,-1,0,1,0,0,2,3,1,1,4,3,-2,-1,6,7,-1,-3,8,12,-2,-11,7,24,8,-12,10,33,2,50,463,1263,1889,1583,218,-1375,-2096,-1565,-372,610,970,863,625,462,469,740,1365,2304,3290,3889,3741,2850,1633,631,120,12,82,188,254,153,-230,-807,-1284,-1425,-1287,-1132,-1128,-1204,-1200,-1072,-898,-729,-528,-250,82,414,741,1094,1459,1752,1879,1801,1546,1177,769,378,23,-295,-545,-680,-705,-713,-812,-1012,-1216,-1322,-1301,-1194,-1062,-953,-887,-847,-791,-697,-580,-465,-352,-227,-92,38,152,240,277,251,193,163,184,217,209,155,89,30,-33,-105,-168,-209,-247,-308,-390,-467,-520,-553,-579,-596,-592,-558,-498,-419,-333,-255,-198,-167,-152,-131,-88,-25,40,88,114,124,123,114,101,89,76,53,15,-28,-62,-84,-103,-132,-177,-228,-270,-293,-299,-297,-292,-281,-266,-253,-245,-238,-227,-220,-224,-234,-236,-220,-193,-166,-144,-128,-122,-127,-136,-134,-117,-94,-75,-62,-50,-38,-29,-24,-22,-22,-25,-30,-31,-28,-23,-22,-28,-39,-53,-69,-86,-102,-116,-127,-137,-148,-158,-161,-154,-141,-132,-131,-134,-134,-123,-102,-78,-62,-55,-54,-55,-55,-50,-39,-28,-26,-31,-30,-16},
            {-191,80,307,3,-414,-108,495,82,-593,1927,8881,14578,10406,-4704,-20306,-23700,-12559,3527,13222,12830,6331,-24,-1441,4021,13899,21269,19280,7568,-6396,-13248,-9171,1919,12272,16020,12456,5264,-1145,-5087,-7804,-10597,-12539,-11630,-7770,-3560,-1817,-2866,-4722,-5540,-5228,-4676,-4127,-2919,-720,1590,2666,2151,1039,550,918,1402,1273,574,-39,1,639,1276,1348,842,209,-200,-431,-604,-570,-162,327,295,-451,-1385,-1829,-1661,-1305,-1149,-1175,-1107,-762,-243,130,88,-324,-745,-853,-661,-416,-243,-60,187,361,318,125,2,62,205,238,67,-228,-447,-427,-203,2,-14,-216,-378,-340,-164,-30,-31,-130,-263,-402,-510,-510,-355,-114,54,30,-163,-379,-462,-354,-144,17,39,-42,-124,-138,-79,31,161,244,207,50,-114,-158,-62,76,137,77,-64,-186,-203,-117,-21,-9,-82,-168,-219,-246,-262,-254,-224,-210,-221,-212,-138,-22,69,101,88,51,-3,-59,-90,-88,-62,-16,50,119,157,145,92,13,-89,-200,-301,-373,-412,-414,-378,-323,-291,-303,-335,-353,-350,-340,-331,-312,-274,-218,-148,-73,-14,16,19,5,-23,-68,-114,-132,-109,-63,-20,8,21,23,17,4,-16,-47,-89,-137,-180,-205,-204,-175,-132,-95,-74,-57,-32,-8,-7,-42,-93,-124,-107,-45,33,95,122,117,92,59,29,12,12,28,59,101,150,189,199,167,106,44,7}
        },
        {    // H-10e125a.wav
            {3,3,2,1,2,2,2,1,1,1,0,0,1,0,-1,-1,1,2,1,0,1,1,1,2,3,2,1,3,4,0,-2,4,11,5,-5,-1,13,10,-7,-5,19,21,-6,-6,33,30,0,222,962,1921,2206,1156,-796,-2327,-2405,-1190,273,1089,1129,794,481,373,574,1200,2259,3481,4349,4387,3518,2155,914,178,-78,-93,-49,-19,-82,-341,-800,-1300,-1637,-1735,-1667,-1531,-1366,-1183,-1025,-936,-888,-778,-535,-207,80,244,320,425,667,1067,1534,1902,2035,1919,1645,1299,898,457,55,-212,-341,-432,-574,-767,-968,-1156,-1320,-1422,-1424,-1338,-1222,-1123,-1050,-998,-950,-864,-692,-444,-203,-58,-16,-2,57,169,288,368,395,379,331,260,186,134,113,94,41,-49,-138,-201,-257,-344,-456,-545,-574,-553,-516,-481,-449,-425,-418,-418,-399,-347,-272,-193,-118,-53,-9,11,23,49,89,121,125,102,70,44,25,8,-7,-15,-21,-38,-77,-134,-192,-238,-271,-296,-310,-308,-292,-278,-278,-291,-304,-308,-298,-274,-239,-205,-182,-173,-167,-155,-137,-117,-97,-79,-63,-52,-46,-39,-28,-14,0,12,20,23,21,13,2,-11,-24,-36,-50,-70,-92,-112,-129,-147,-168,-184,-188,-182,-177,-179,-185,-187,-181,-165,-142,-117,-92,-69,-48,-31,-20,-15,-12,-11,-10,-8,-3,1,-3,-11,-15,-9},
            {-8,-181,-13,256,67,-335,-133,420,112,-507,1683,7996,13436,10071,-3465,-18014,-21895,-12355,2476,12151,12450,6274,-460,-2408,2878,12846,20298,18483,7373,-5577,-11514,-7164,3496,13097,16140,11979,4241,-2480,-6138,-7938,-9738,-11320,-10812,-7577,-3659,-1863,-2882,-4921,-5952,-5626,-4805,-3937,-2600,-572,1383,2202,1760,987,802,1211,1519,1194,378,-286,-216,602,1538,1822,1247,300,-414,-718,-743,-519,-23,464,429,-283,-1197,-1693,-1636,-1376,-1235,-1196,-1055,-716,-292,-16,-63,-379,-686,-731,-526,-286,-135,1,195,350,323,143,5,48,197,248,75,-256,-525,-540,-312,-59,-7,-171,-364,-406,-293,-147,-69,-79,-154,-268,-371,-387,-269,-67,86,73,-112,-338,-437,-337,-126,35,49,-47,-155,-202,-162,-36,132,249,228,78,-80,-123,-33,104,170,104,-64,-223,-263,-174,-58,-23,-84,-173,-236,-264,-265,-239,-203,-191,-204,-193,-119,-4,92,134,128,92,40,-7,-33,-42,-50,-55,-39,2,52,86,87,46,-39,-158,-283,-384,-439,-436,-383,-307,-247,-226,-240,-267,-295,-320,-342,-352,-335,-278,-183,-74,11,48,42,10,-35,-86,-122,-119,-72,-10,34,47,38,18,-6,-30,-50,-68,-90,-117,-141,-150,-136,-111,-90,-77,-66,-45,-13,12,6,-39,-101,-136,-116,-46,38,100,123,114,89,64,51,49,52,56,70,102,145,181,193,169,113,46}
        },
        {    // H-10e130a.wav
            {1,1,2,2,1,0,0,1,0,-1,-1,-1,-1,-1,1,1,-1,-2,0,0,-2,-1,3,4,0,-1,3,3,-2,-2,7,7,-5,-9,7,14,-5,-18,7,31,8,-21,12,51,9,63,619,1720,2582,2122,152,-2132,-3126,-2274,-455,997,1437,1122,627,332,410,999,2160,3651,4862,5129,4232,2622,1102,215,-64,-94,-126,-168,-203,-372,-833,-1510,-2087,-2286,-2104,-1776,-1534,-1432,-1378,-1267,-1066,-795,-490,-191,48,189,249,299,416,627,886,1110,1247,1327,1425,1548,1585,1423,1100,783,579,410,135,-259,-639,-883,-996,-1065,-1151,-1262,-1370,-1442,-1454,-1406,-1317,-1191,-1023,-832,-666,-540,-415,-257,-96,22,106,209,334,420,414,344,278,249,239,225,200,154,73,-34,-137,-211,-261,-299,-327,-345,-364,-399,-445,-480,-493,-493,-493,-484,-442,-358,-256,-174,-133,-114,-89,-48,-5,26,45,51,43,25,17,31,57,73,67,43,8,-34,-81,-126,-168,-213,-263,-304,-323,-324,-325,-336,-348,-347,-331,-311,-290,-265,-236,-210,-192,-179,-162,-138,-111,-85,-58,-32,-12,-4,-7,-12,-9,5,23,37,43,40,33,23,10,-11,-43,-83,-122,-154,-179,-198,-213,-220,-220,-216,-215,-217,-216,-209,-196,-178,-154,-126,-97,-73,-55,-43,-35,-28,-19,-5,13,27,30,23,11,-2,-12,-16,-12,-5},
            {108,-31,-171,-16,235,94,-283,-173,339,191,-446,1024,6331,11900,10539,-476,-14362,-20209,-13499,-19,10364,12135,6738,-324,-3290,923,10437,18581,18491,9187,-2983,-9471,-6315,3469,12913,16179,12000,3771,-3480,-6980,-7717,-8250,-9416,-9722,-7808,-4635,-2620,-3006,-4730,-5913,-5808,-4973,-3976,-2670,-839,985,1881,1607,933,784,1282,1758,1553,669,-252,-474,228,1329,1958,1645,684,-269,-808,-907,-638,-94,426,473,-106,-929,-1448,-1493,-1326,-1241,-1254,-1186,-909,-491,-166,-148,-417,-695,-704,-441,-144,14,87,199,334,363,246,102,72,157,212,87,-214,-515,-604,-434,-173,-43,-120,-292,-392,-356,-243,-149,-124,-166,-244,-316,-329,-241,-66,99,129,-18,-248,-396,-364,-197,-30,29,-24,-118,-174,-150,-42,109,222,220,104,-34,-84,-19,86,126,43,-132,-295,-339,-244,-104,-42,-95,-194,-257,-266,-246,-211,-175,-156,-159,-146,-74,43,140,168,134,75,13,-46,-100,-141,-154,-126,-54,39,113,136,102,18,-100,-222,-317,-370,-386,-368,-316,-248,-206,-222,-284,-350,-392,-402,-385,-343,-283,-216,-149,-82,-27,2,2,-14,-34,-54,-69,-67,-41,-4,24,28,14,-7,-26,-39,-48,-61,-80,-100,-111,-110,-98,-83,-75,-81,-89,-78,-47,-21,-32,-78,-128,-146,-115,-42,45,111,131,113,87,73,69,63,59,65,81,101,127,155,163,128,60}
        },
        {    // H-10e135a.wav
            {3,4,2,0,1,2,0,-2,-1,2,1,-1,0,1,0,-2,-1,0,0,-1,2,5,2,-2,2,5,-1,-6,5,16,5,-13,-5,17,10,-18,-12,26,28,-14,-11,51,46,1,324,1371,2666,2934,1317,-1462,-3495,-3405,-1540,552,1615,1523,906,390,304,831,2067,3793,5335,5862,4999,3187,1375,285,-64,-124,-233,-358,-373,-399,-731,-1450,-2253,-2714,-2676,-2338,-1991,-1750,-1551,-1345,-1177,-1066,-897,-530,-8,424,558,445,351,496,851,1183,1276,1115,882,776,833,942,1002,1026,1053,1037,882,576,220,-100,-390,-677,-921,-1055,-1090,-1116,-1201,-1338,-1469,-1533,-1478,-1286,-1013,-764,-609,-522,-428,-287,-114,46,167,238,262,255,250,268,304,325,299,218,114,35,7,7,-9,-60,-125,-179,-220,-263,-313,-363,-404,-435,-460,-476,-476,-449,-393,-321,-258,-219,-198,-175,-137,-94,-62,-49,-48,-44,-25,13,63,108,132,125,90,40,-11,-52,-87,-132,-193,-258,-303,-319,-319,-320,-327,-335,-340,-338,-323,-296,-267,-245,-228,-206,-176,-146,-121,-100,-81,-65,-49,-24,10,38,46,38,31,33,40,46,48,44,30,3,-33,-72,-112,-154,-195,-229,-254,-269,-273,-264,-246,-225,-207,-194,-182,-168,-150,-130,-109,-87,-65,-45,-31,-23,-19,-16,-13,-6,6,21,30,31,27,20,7,-8,-16,-10},
            {-49,96,68,-119,-112,131,159,-158,-240,174,279,-293,276,4196,9780,10948,3333,-9458,-17777,-14973,-3611,7524,11415,7511,475,-3726,-1299,7040,15864,18420,12083,1053,-6762,-6010,2208,11678,15881,12409,4087,-3722,-7419,-7477,-6846,-7411,-8362,-7897,-5789,-3713,-3285,-4406,-5673,-5976,-5305,-4181,-2836,-1221,429,1479,1527,961,660,1087,1810,1989,1269,166,-420,-38,937,1687,1672,984,104,-554,-828,-705,-275,198,339,-29,-681,-1183,-1308,-1200,-1146,-1252,-1360,-1242,-851,-406,-217,-380,-666,-741,-504,-145,109,228,316,406,424,323,187,135,179,207,102,-143,-406,-535,-462,-269,-125,-141,-274,-386,-381,-282,-183,-148,-188,-277,-371,-409,-332,-145,60,153,72,-131,-323,-381,-281,-111,9,21,-36,-83,-69,10,122,211,212,102,-53,-147,-120,-16,59,21,-128,-302,-389,-338,-209,-120,-131,-200,-248,-243,-199,-140,-86,-64,-82,-104,-75,9,90,103,45,-35,-93,-116,-113,-96,-74,-49,-16,21,48,53,31,-19,-93,-174,-243,-294,-333,-359,-358,-329,-301,-306,-338,-366,-372,-362,-349,-330,-299,-250,-186,-114,-46,2,20,10,-15,-41,-59,-61,-43,-12,18,32,24,1,-22,-36,-45,-58,-76,-91,-99,-102,-100,-96,-96,-108,-124,-127,-112,-92,-84,-94,-113,-121,-95,-29,53,112,130,122,110,95,76,62,62,67,68,73,96,118,105,53}
        },
        {    // H-10e140a.wav
            {5,2,0,1,1,-1,-1,1,0,-3,-2,2,3,0,-1,0,-1,-2,2,7,3,-4,-1,7,4,-8,-5,13,15,-6,-13,9,18,-9,-24,11,38,-1,-31,29,77,10,128,981,2496,3469,2491,-415,-3403,-4364,-2844,-274,1541,1894,1277,535,237,679,1993,3965,5845,6633,5789,3741,1612,342,10,10,-185,-538,-721,-688,-798,-1369,-2248,-2940,-3087,-2772,-2341,-2039,-1858,-1692,-1508,-1319,-1066,-651,-111,335,492,414,367,566,970,1341,1463,1312,1042,830,721,631,493,378,413,598,764,746,553,320,142,-1,-168,-375,-596,-805,-989,-1151,-1291,-1387,-1389,-1284,-1123,-984,-882,-767,-611,-455,-346,-261,-145,0,116,165,171,176,192,206,211,208,195,178,167,153,107,18,-81,-139,-146,-138,-150,-184,-221,-263,-323,-395,-441,-430,-373,-314,-292,-305,-323,-317,-283,-236,-191,-151,-118,-94,-75,-49,-5,51,100,124,120,92,48,0,-42,-82,-134,-199,-255,-281,-283,-283,-296,-312,-320,-319,-312,-297,-270,-237,-212,-202,-199,-189,-166,-137,-110,-86,-61,-33,-9,6,17,33,53,68,72,68,62,53,32,-3,-46,-89,-133,-177,-216,-244,-261,-271,-274,-265,-245,-224,-207,-192,-176,-161,-148,-135,-115,-90,-65,-44,-29,-22,-23,-29,-32,-30,-22,-9,7,21,27,25,18,7,-8,-20,-21,-11},
            {-44,-57,35,76,-43,-119,30,160,-21,-226,-8,275,-50,-178,2091,7007,10406,6905,-3551,-13789,-15603,-7669,3453,9717,8151,1890,-3315,-3069,3261,12026,17237,14773,5997,-2797,-5187,320,9262,14833,13031,5330,-3010,-7419,-7370,-5802,-5595,-6881,-7705,-6736,-4761,-3601,-4076,-5370,-6130,-5769,-4618,-3173,-1602,-20,1146,1421,926,469,762,1637,2207,1834,806,17,70,770,1423,1499,994,272,-307,-583,-550,-280,56,198,-43,-584,-1090,-1267,-1142,-1010,-1111,-1369,-1472,-1211,-723,-375,-399,-656,-787,-580,-162,184,322,344,391,471,493,420,318,262,238,165,-3,-219,-374,-389,-286,-185,-200,-324,-437,-431,-321,-206,-158,-178,-247,-350,-444,-450,-322,-121,24,24,-99,-241,-297,-224,-69,66,104,57,1,-2,52,127,182,177,85,-63,-180,-191,-101,-2,5,-112,-290,-417,-410,-288,-156,-106,-138,-184,-186,-145,-87,-40,-29,-67,-129,-155,-109,-15,59,71,34,-13,-48,-73,-91,-100,-93,-64,-15,39,76,74,22,-71,-178,-268,-326,-355,-363,-348,-313,-282,-283,-323,-374,-403,-399,-373,-335,-285,-224,-159,-98,-44,1,27,26,4,-19,-30,-29,-18,8,43,66,56,19,-18,-37,-44,-53,-67,-82,-98,-116,-128,-126,-116,-115,-129,-146,-146,-124,-94,-78,-86,-97,-79,-17,66,133,167,168,140,97,65,57,62,60,57,71,94,91,49}
        },
        {    // H-10e145a.wav
            {0,1,2,-1,-4,-2,0,-2,-4,-1,2,0,-3,-2,-2,-6,-5,3,6,-2,-6,1,4,-7,-12,4,15,-2,-19,-2,20,1,-29,-7,37,15,-40,-6,80,46,31,643,2182,3715,3507,820,-2887,-5015,-4192,-1401,1183,2170,1703,753,187,505,1913,4179,6438,7483,6606,4256,1776,342,84,222,6,-573,-1011,-1050,-1028,-1447,-2345,-3214,-3514,-3175,-2587,-2161,-1993,-1916,-1787,-1602,-1370,-994,-402,256,661,648,415,356,686,1251,1676,1700,1378,989,758,678,599,446,296,230,208,142,41,-7,28,64,26,-72,-176,-285,-442,-661,-905,-1105,-1189,-1116,-929,-753,-693,-734,-770,-723,-602,-451,-294,-145,-36,0,-21,-40,-6,85,194,266,264,200,124,77,52,17,-36,-80,-94,-86,-83,-102,-142,-190,-232,-257,-266,-268,-270,-273,-286,-316,-357,-379,-357,-295,-226,-180,-164,-161,-152,-128,-87,-33,25,66,68,32,-18,-51,-53,-47,-67,-123,-191,-238,-257,-260,-261,-266,-275,-283,-280,-260,-231,-212,-213,-223,-225,-212,-186,-150,-109,-75,-59,-57,-51,-30,-2,20,34,47,61,66,56,34,6,-28,-71,-120,-170,-213,-246,-265,-272,-269,-257,-239,-216,-193,-172,-157,-151,-152,-153,-148,-133,-111,-85,-58,-37,-28,-32,-40,-45,-45,-44,-42,-34,-16,5,16,9,-7,-22,-33,-42,-45,-37,-18},
            {43,-15,-73,-18,76,34,-93,-65,104,95,-131,-150,148,164,-210,549,3986,8424,8931,2338,-7986,-14097,-11008,-1572,6532,7955,3478,-2001,-3763,-22,7463,14277,15817,10690,2424,-2790,-1021,6077,12587,13161,7173,-1202,-6761,-7455,-5379,-4079,-5079,-6959,-7451,-6009,-4180,-3732,-4819,-6073,-6201,-5135,-3622,-2147,-680,680,1382,1085,355,235,1071,2099,2315,1573,643,333,744,1338,1515,1091,347,-266,-485,-369,-139,44,104,-55,-492,-1055,-1400,-1327,-1033,-932,-1186,-1518,-1531,-1146,-673,-470,-582,-740,-661,-320,79,335,422,450,497,540,532,489,466,470,426,257,-12,-255,-353,-307,-231,-242,-349,-457,-469,-382,-274,-222,-241,-300,-369,-426,-441,-387,-279,-177,-140,-177,-236,-242,-153,4,142,181,120,33,-4,25,85,136,152,113,11,-118,-204,-202,-139,-97,-134,-237,-331,-345,-269,-164,-104,-116,-162,-192,-187,-155,-114,-81,-78,-104,-121,-83,3,78,90,40,-30,-83,-107,-104,-82,-54,-34,-22,-10,0,-8,-43,-100,-160,-210,-249,-282,-314,-338,-344,-335,-332,-350,-380,-399,-392,-363,-319,-267,-208,-153,-108,-66,-20,22,43,41,27,12,3,3,18,43,60,52,19,-20,-45,-55,-62,-77,-101,-123,-136,-138,-133,-125,-121,-130,-150,-163,-153,-121,-91,-77,-71,-49,1,69,130,162,154,118,80,62,61,65,67,70,72,59,29}
        },
        {    // H-10e150a.wav
            {1,-1,-4,-3,-1,-2,-4,-3,1,0,-4,-3,-1,-4,-5,0,5,0,-5,0,6,-3,-13,-3,14,5,-18,-12,16,10,-27,-21,32,35,-32,-39,57,78,9,394,1808,3707,4280,2110,-1985,-5252,-5435,-2776,483,2275,2178,1103,205,288,1730,4331,7078,8471,7555,4798,1846,211,105,515,372,-443,-1234,-1453,-1335,-1550,-2400,-3462,-4023,-3766,-3006,-2317,-2007,-1970,-1951,-1830,-1605,-1225,-612,125,646,691,414,283,617,1262,1764,1807,1466,1066,849,797,739,585,405,296,230,98,-128,-340,-426,-405,-382,-417,-466,-456,-385,-339,-401,-561,-711,-742,-651,-542,-505,-524,-530,-506,-490,-488,-444,-326,-188,-113,-112,-115,-57,59,168,203,142,32,-46,-43,11,40,8,-57,-108,-130,-141,-147,-139,-119,-113,-148,-213,-264,-265,-224,-191,-203,-251,-291,-289,-251,-205,-171,-155,-155,-164,-167,-146,-98,-47,-22,-35,-66,-94,-107,-104,-98,-110,-150,-201,-228,-218,-192,-184,-199,-217,-223,-219,-214,-209,-204,-208,-224,-238,-225,-177,-116,-72,-54,-51,-43,-26,-6,6,9,9,9,8,4,-2,-12,-34,-76,-129,-175,-203,-221,-238,-256,-266,-265,-252,-228,-194,-159,-133,-118,-111,-108,-110,-114,-116,-113,-102,-82,-56,-36,-33,-46,-62,-70,-70,-65,-56,-44,-29,-13,-3,-5,-22,-46,-64,-73,-77,-73,-55,-25},
            {-22,31,39,-33,-69,10,74,-9,-101,-12,118,19,-165,-52,194,25,-116,1478,5355,8566,6601,-1292,-9790,-12013,-6395,1866,6179,4472,-157,-3162,-1959,3211,9847,14233,13451,7864,1606,-393,3328,9282,11974,8619,1328,-5033,-7099,-5458,-3364,-3394,-5359,-7137,-7105,-5600,-4249,-4215,-5196,-5968,-5659,-4382,-2770,-1251,46,896,977,414,-2,474,1650,2513,2320,1369,606,626,1196,1638,1489,809,21,-445,-450,-179,68,109,-85,-472,-958,-1352,-1446,-1240,-1018,-1087,-1424,-1678,-1538,-1074,-652,-545,-671,-720,-493,-72,307,500,545,550,571,598,622,653,684,663,532,286,-3,-225,-305,-272,-239,-298,-427,-512,-476,-366,-290,-300,-365,-438,-496,-522,-478,-348,-183,-76,-84,-179,-276,-293,-200,-41,96,148,130,102,98,103,94,77,56,12,-65,-140,-159,-121,-85,-111,-199,-293,-330,-288,-197,-123,-114,-161,-205,-200,-151,-93,-56,-50,-72,-103,-109,-72,-13,23,13,-24,-53,-59,-53,-55,-72,-93,-95,-70,-38,-26,-43,-84,-134,-182,-222,-251,-277,-310,-348,-370,-364,-346,-340,-349,-351,-331,-295,-257,-219,-173,-120,-68,-23,16,48,66,65,48,28,16,17,26,35,33,14,-19,-49,-63,-66,-72,-88,-108,-122,-130,-138,-143,-143,-140,-143,-152,-152,-132,-98,-67,-50,-36,-5,47,100,131,133,118,101,86,73,67,67,64,48,21}
        },
        {    // H-10e155a.wav
            {-2,-2,0,0,-3,-2,2,3,0,-2,-1,-2,-4,0,6,3,-4,0,9,2,-12,-6,14,11,-15,-17,14,20,-20,-33,20,51,-8,-50,28,89,22,250,1484,3545,4758,3247,-882,-5052,-6370,-4209,-537,2096,2592,1572,368,130,1505,4388,7658,9514,8665,5487,1910,-92,-72,756,883,-78,-1295,-1850,-1742,-1746,-2450,-3613,-4442,-4380,-3573,-2641,-2096,-1991,-2054,-2035,-1846,-1441,-768,78,752,900,561,222,375,1035,1743,2015,1757,1259,866,703,666,615,511,391,273,130,-45,-221,-377,-534,-706,-841,-863,-764,-631,-571,-628,-744,-791,-661,-370,-74,51,-30,-199,-317,-343,-316,-264,-188,-94,-12,36,46,25,-13,-43,-49,-47,-67,-99,-100,-58,-25,-61,-153,-228,-236,-193,-148,-130,-137,-164,-210,-262,-287,-260,-189,-119,-93,-119,-165,-184,-154,-90,-34,-23,-65,-129,-179,-189,-158,-107,-63,-49,-77,-136,-194,-217,-202,-181,-188,-222,-250,-242,-202,-162,-147,-157,-175,-187,-188,-182,-176,-178,-194,-212,-209,-169,-100,-30,17,36,38,34,28,19,9,0,-12,-30,-56,-85,-110,-129,-145,-158,-170,-186,-213,-246,-268,-269,-252,-229,-206,-180,-152,-125,-105,-90,-78,-70,-67,-66,-62,-53,-45,-43,-46,-51,-57,-64,-69,-70,-71,-75,-76,-65,-44,-25,-17,-23,-41,-66,-87,-96,-96,-92,-83,-60,-26},
            {8,-25,-13,34,24,-44,-49,36,59,-44,-90,34,111,-39,-157,31,186,-65,124,2300,6073,7927,4383,-3391,-9561,-9203,-3313,2532,3973,1422,-1625,-2244,324,5172,10297,13046,11625,7034,2934,2647,5975,9225,8616,3725,-2289,-5693,-5382,-3369,-2480,-3750,-5916,-7084,-6611,-5413,-4742,-4924,-5290,-5109,-4321,-3324,-2308,-1148,67,785,618,33,22,987,2222,2692,2135,1222,749,913,1348,1587,1404,864,224,-243,-420,-364,-216,-126,-246,-652,-1197,-1543,-1484,-1207,-1118,-1379,-1724,-1768,-1428,-977,-720,-699,-708,-539,-176,227,506,624,652,664,682,706,748,808,832,734,491,183,-60,-158,-140,-115,-182,-347,-515,-579,-525,-432,-386,-401,-437,-468,-492,-489,-424,-295,-167,-116,-159,-243,-293,-271,-191,-99,-35,-2,32,92,155,180,152,93,24,-52,-121,-144,-101,-36,-24,-102,-228,-321,-324,-240,-127,-56,-55,-98,-137,-149,-141,-129,-121,-128,-151,-167,-143,-78,-15,2,-24,-55,-67,-62,-51,-43,-50,-77,-108,-118,-104,-89,-95,-121,-154,-184,-215,-249,-277,-293,-301,-307,-314,-320,-326,-328,-320,-299,-264,-220,-172,-125,-80,-36,6,35,45,43,41,42,38,27,20,23,25,10,-20,-46,-58,-63,-75,-92,-104,-111,-121,-137,-146,-142,-136,-141,-154,-159,-142,-109,-73,-44,-22,-1,27,58,88,109,114,103,85,74,72,68,51,24}
        },
        {    // H-10e160a.wav
            {-3,-3,-4,-3,0,1,-2,-2,-1,-3,-6,-2,5,3,-5,-3,7,4,-11,-10,8,12,-11,-21,5,21,-12,-37,3,46,6,-46,9,82,28,171,1252,3345,4988,4095,196,-4520,-6869,-5471,-1768,1548,2784,2071,687,89,1292,4382,8151,10494,9793,6298,2124,-365,-410,761,1290,412,-1115,-2089,-2163,-2041,-2556,-3736,-4800,-4969,-4179,-3046,-2254,-2028,-2137,-2242,-2140,-1733,-976,8,837,1107,800,385,407,971,1671,2003,1807,1332,934,769,736,668,516,343,192,22,-194,-384,-447,-403,-403,-556,-800,-974,-1003,-969,-998,-1103,-1154,-1005,-651,-240,53,167,158,99,23,-35,-1,168,397,523,443,210,-25,-141,-126,-51,-6,-37,-126,-214,-258,-264,-268,-287,-306,-306,-290,-278,-279,-282,-284,-298,-324,-332,-286,-188,-91,-54,-81,-114,-92,-13,71,110,90,29,-49,-119,-149,-125,-72,-40,-65,-135,-209,-251,-256,-240,-229,-240,-271,-295,-283,-237,-193,-184,-210,-235,-229,-196,-163,-151,-161,-181,-192,-177,-127,-48,32,81,87,69,59,66,71,50,3,-53,-102,-141,-168,-177,-170,-162,-171,-196,-222,-239,-249,-259,-267,-263,-243,-212,-178,-146,-120,-105,-102,-103,-97,-80,-57,-38,-24,-11,0,2,-12,-37,-61,-79,-89,-94,-92,-86,-77,-68,-57,-48,-49,-62,-85,-108,-126,-133,-129,-118,-103,-84,-56,-23},
            {3,18,-2,-26,0,38,7,-53,-29,51,37,-68,-67,67,87,-83,-126,95,148,-111,401,2887,6250,6981,2779,-4073,-8294,-6918,-2150,1442,1655,-92,-1279,-650,1796,5589,9619,11957,11140,7921,5015,4578,6041,6749,4713,573,-3126,-4404,-3518,-2389,-2655,-4329,-6129,-6847,-6363,-5502,-5074,-5105,-4975,-4244,-3180,-2356,-1884,-1340,-490,275,482,340,547,1366,2238,2454,1968,1349,1085,1174,1334,1363,1231,975,623,196,-261,-637,-785,-680,-535,-637,-1028,-1430,-1570,-1493,-1479,-1661,-1851,-1776,-1410,-989,-736,-638,-510,-232,126,407,549,621,705,801,863,878,869,852,799,675,470,216,-17,-150,-158,-121,-155,-295,-456,-541,-543,-519,-497,-453,-384,-346,-376,-435,-449,-401,-345,-333,-361,-378,-341,-245,-127,-38,-7,-17,-25,-6,31,68,100,119,98,24,-68,-117,-101,-52,-21,-33,-75,-116,-129,-112,-94,-109,-161,-211,-222,-197,-164,-144,-141,-156,-184,-204,-188,-137,-81,-50,-44,-44,-41,-39,-50,-78,-117,-149,-159,-145,-120,-97,-84,-87,-114,-158,-199,-225,-242,-259,-271,-275,-282,-305,-332,-335,-305,-258,-213,-174,-134,-96,-66,-45,-26,-6,16,37,52,56,49,35,20,6,-9,-27,-48,-67,-78,-82,-88,-98,-110,-119,-126,-135,-143,-145,-143,-145,-152,-149,-124,-84,-49,-30,-18,-3,19,44,66,78,80,79,84,85,67,31}
        },
        {    // H-10e165a.wav
            {-5,-4,0,3,0,-3,-3,-4,-6,-3,3,2,-5,-5,5,5,-8,-11,6,12,-9,-23,0,19,-8,-37,-7,38,11,-40,1,73,27,129,1106,3178,5072,4660,1093,-3840,-6940,-6341,-2942,710,2602,2394,1098,249,1189,4322,8503,11366,10903,7178,2469,-497,-689,666,1494,770,-872,-2135,-2440,-2334,-2716,-3833,-5046,-5478,-4827,-3580,-2517,-2073,-2143,-2355,-2393,-2072,-1303,-200,827,1282,1050,580,498,1006,1727,2115,1955,1460,985,736,691,699,600,330,-33,-320,-405,-316,-211,-237,-424,-690,-921,-1036,-1028,-972,-992,-1142,-1318,-1315,-1037,-615,-293,-184,-183,-109,111,411,674,822,830,725,570,432,343,291,253,202,109,-41,-217,-347,-390,-380,-390,-448,-516,-540,-511,-467,-435,-415,-399,-390,-392,-389,-354,-275,-173,-88,-43,-26,-1,55,126,174,169,115,42,-17,-43,-37,-13,4,-13,-73,-158,-232,-268,-267,-258,-268,-298,-325,-324,-294,-260,-252,-276,-309,-320,-294,-240,-179,-131,-104,-93,-86,-68,-32,14,56,82,93,97,95,78,38,-20,-80,-124,-147,-154,-153,-153,-164,-190,-223,-249,-262,-267,-270,-269,-257,-237,-215,-192,-167,-141,-121,-111,-109,-106,-97,-83,-64,-42,-19,2,14,14,2,-19,-41,-56,-63,-66,-72,-81,-87,-87,-86,-89,-94,-99,-108,-126,-146,-159,-163,-161,-148,-112,-58,-13,4},
            {-4,-8,9,15,-10,-24,10,36,-6,-52,-10,54,12,-75,-35,84,51,-108,-82,132,96,-112,658,3218,6079,6104,1943,-3823,-6940,-5756,-2445,-112,297,-105,-168,470,2098,5104,8954,11783,11848,9347,6313,4600,4225,3762,2109,-369,-2347,-2947,-2552,-2331,-3103,-4661,-6088,-6635,-6298,-5631,-5102,-4697,-4156,-3439,-2789,-2328,-1839,-1106,-322,112,175,335,954,1794,2289,2189,1763,1415,1310,1370,1448,1418,1214,875,509,171,-163,-494,-741,-863,-943,-1079,-1240,-1329,-1367,-1492,-1752,-1994,-2011,-1744,-1322,-916,-614,-401,-213,0,231,431,560,636,711,818,942,1034,1048,959,780,551,322,140,27,-28,-67,-141,-260,-374,-423,-399,-350,-325,-336,-368,-415,-476,-542,-587,-591,-558,-510,-467,-440,-421,-381,-300,-189,-84,-10,37,70,82,59,17,-7,8,42,67,84,108,134,132,84,4,-76,-133,-160,-162,-159,-168,-191,-213,-222,-219,-210,-201,-196,-200,-211,-215,-200,-165,-123,-86,-64,-57,-62,-74,-94,-120,-139,-137,-113,-84,-68,-65,-65,-70,-91,-127,-164,-191,-214,-243,-273,-291,-293,-291,-290,-281,-253,-214,-179,-155,-135,-110,-82,-56,-29,4,39,63,66,51,32,18,7,-10,-32,-53,-69,-81,-90,-93,-89,-85,-90,-111,-133,-142,-138,-134,-136,-135,-128,-117,-105,-85,-56,-32,-21,-14,5,36,64,81,95,102,85,42}
        },
        {    // H-10e170a.wav
            {-2,0,0,0,-1,-4,-7,-3,3,1,-4,-3,5,3,-9,-10,7,12,-9,-22,-1,16,-8,-34,-5,34,5,-43,1,73,23,102,1028,3079,5094,4976,1706,-3215,-6723,-6754,-3809,-163,2115,2387,1373,511,1281,4350,8748,12028,11882,8101,2976,-471,-892,562,1628,1029,-704,-2180,-2652,-2567,-2864,-3927,-5226,-5863,-5389,-4144,-2899,-2225,-2177,-2429,-2586,-2352,-1588,-414,732,1314,1158,682,555,1061,1846,2304,2170,1681,1222,934,708,446,210,90,49,-38,-205,-358,-415,-430,-534,-772,-1044,-1204,-1191,-1078,-1007,-1065,-1203,-1274,-1174,-938,-681,-457,-232,13,219,328,387,511,737,970,1078,1021,863,694,555,439,321,185,28,-140,-305,-451,-570,-657,-709,-723,-705,-666,-622,-582,-554,-541,-539,-529,-477,-363,-211,-82,-22,-19,-17,30,117,199,234,210,141,57,-8,-22,23,94,131,89,-18,-132,-203,-228,-242,-274,-322,-365,-380,-363,-327,-303,-313,-351,-379,-360,-291,-204,-140,-111,-101,-86,-53,-4,52,97,111,86,43,7,-9,-17,-35,-63,-83,-89,-93,-109,-133,-157,-179,-205,-232,-251,-260,-264,-269,-269,-257,-233,-205,-182,-165,-150,-134,-122,-116,-109,-93,-69,-47,-32,-19,-4,3,-5,-20,-28,-25,-22,-26,-36,-50,-68,-88,-101,-105,-107,-115,-128,-139,-150,-164,-175,-177,-171,-155,-119,-57,9,41,29},
            {5,5,-6,-5,13,12,-14,-18,17,29,-15,-42,6,45,-10,-69,-6,82,15,-108,-32,142,42,-78,864,3338,5760,5495,1729,-3230,-6081,-5633,-3335,-1178,72,612,703,759,1786,4688,8908,12290,12764,10175,6329,3339,2010,1642,1106,-29,-1308,-2102,-2356,-2625,-3436,-4725,-5911,-6449,-6257,-5635,-4882,-4097,-3332,-2766,-2555,-2527,-2210,-1321,-161,644,811,687,820,1358,1953,2191,2002,1652,1438,1430,1476,1390,1125,762,378,-10,-363,-579,-617,-618,-800,-1202,-1605,-1757,-1645,-1490,-1505,-1686,-1834,-1749,-1397,-922,-504,-217,-19,144,273,361,456,622,843,1022,1077,1017,907,791,672,533,370,200,65,-1,-13,-33,-105,-209,-289,-322,-335,-360,-399,-440,-498,-591,-699,-767,-756,-680,-592,-535,-512,-487,-425,-316,-183,-61,32,94,128,135,121,109,121,151,174,174,158,140,125,104,64,-4,-98,-193,-255,-261,-225,-180,-155,-160,-193,-244,-288,-303,-286,-258,-234,-213,-186,-152,-119,-97,-88,-89,-92,-88,-75,-64,-63,-68,-69,-64,-60,-59,-59,-65,-85,-117,-150,-176,-200,-225,-251,-273,-288,-294,-285,-260,-225,-190,-160,-135,-118,-105,-89,-64,-32,0,28,50,58,48,26,3,-18,-41,-65,-79,-79,-74,-74,-77,-80,-83,-92,-105,-118,-129,-137,-141,-140,-135,-127,-113,-93,-74,-62,-51,-34,-11,16,50,92,119,103,50}
        },
        {    // H-10e175a.wav
            {-1,-1,0,-3,-7,-4,3,2,-5,-3,6,3,-10,-9,8,10,-13,-22,2,16,-14,-36,0,37,-1,-49,5,77,12,78,1007,3071,5123,5114,2026,-2764,-6381,-6796,-4299,-876,1515,2104,1385,668,1449,4502,8983,12498,12643,9003,3718,-126,-931,384,1580,1190,-481,-2112,-2826,-2872,-3111,-4037,-5302,-6084,-5832,-4706,-3381,-2491,-2242,-2435,-2685,-2602,-1921,-695,608,1363,1303,799,546,947,1784,2468,2558,2063,1335,762,523,542,598,487,160,-253,-551,-623,-532,-453,-537,-804,-1136,-1361,-1383,-1261,-1170,-1241,-1416,-1478,-1258,-804,-346,-85,-43,-91,-85,35,250,507,750,934,1028,1025,956,879,829,783,678,485,241,17,-154,-289,-419,-554,-680,-769,-808,-802,-774,-753,-749,-748,-726,-673,-588,-473,-338,-212,-130,-92,-57,16,120,207,237,213,166,122,94,91,116,155,177,154,88,5,-68,-126,-183,-252,-326,-384,-408,-395,-356,-317,-301,-315,-340,-343,-311,-259,-214,-186,-163,-128,-79,-26,20,50,61,52,33,16,6,-4,-26,-61,-95,-110,-105,-93,-90,-104,-130,-162,-192,-216,-233,-246,-259,-271,-272,-256,-227,-199,-177,-161,-147,-138,-131,-120,-100,-77,-57,-40,-20,1,13,7,-10,-27,-35,-35,-33,-33,-38,-45,-56,-73,-95,-111,-118,-123,-133,-146,-156,-165,-174,-177,-164,-135,-97,-51,1,43,53,30},
            {-8,-3,7,4,-8,-4,12,7,-16,-13,18,21,-17,-32,9,31,-19,-54,6,62,-7,-87,2,120,3,-17,992,3297,5442,5195,1849,-2766,-5860,-6055,-4058,-1473,482,1290,1062,673,1561,4642,9141,12726,13177,10166,5527,1800,347,630,1081,611,-645,-1856,-2520,-2887,-3511,-4571,-5695,-6329,-6197,-5433,-4394,-3425,-2765,-2522,-2599,-2650,-2257,-1295,-93,830,1205,1186,1119,1222,1486,1776,1956,1957,1802,1573,1340,1118,886,617,284,-115,-501,-731,-736,-636,-659,-924,-1336,-1688,-1841,-1799,-1660,-1525,-1431,-1337,-1172,-915,-615,-335,-94,121,311,460,572,671,774,870,932,931,858,733,607,518,460,396,312,230,164,87,-35,-196,-353,-469,-539,-575,-591,-604,-636,-697,-769,-814,-805,-742,-652,-565,-491,-421,-338,-230,-103,24,125,181,194,186,185,204,237,262,266,241,184,104,26,-31,-75,-132,-203,-255,-261,-231,-203,-204,-229,-264,-295,-308,-291,-250,-216,-219,-250,-269,-244,-182,-114,-67,-42,-31,-28,-32,-38,-40,-38,-41,-57,-77,-82,-68,-55,-64,-91,-117,-135,-157,-192,-231,-257,-270,-279,-284,-272,-241,-202,-171,-148,-128,-111,-99,-91,-76,-48,-15,9,20,24,25,20,-1,-30,-51,-59,-66,-75,-78,-70,-61,-64,-79,-93,-102,-114,-131,-146,-150,-143,-135,-131,-128,-114,-84,-47,-21,-9,9,47,85,87,46}
        },
        {    // H-10e180a.wav
            {2,-2,-8,-4,5,3,-6,-2,9,4,-12,-8,14,13,-17,-25,8,22,-17,-42,5,46,-7,-63,8,91,-1,46,1027,3175,5226,5126,2018,-2620,-6057,-6522,-4350,-1278,1000,1723,1214,655,1537,4659,9183,12762,13070,9673,4541,586,-574,358,1368,1052,-416,-1922,-2712,-2980,-3401,-4327,-5462,-6173,-6033,-5114,-3890,-2899,-2437,-2466,-2688,-2690,-2142,-1030,252,1125,1291,1005,845,1161,1763,2169,2115,1773,1480,1356,1251,1019,692,373,77,-238,-526,-666,-637,-588,-682,-924,-1183,-1357,-1451,-1527,-1613,-1673,-1620,-1383,-989,-586,-328,-237,-196,-90,88,279,451,610,750,839,863,848,825,805,780,742,677,573,434,280,124,-44,-230,-412,-554,-641,-689,-718,-735,-745,-759,-790,-826,-833,-779,-663,-520,-391,-298,-235,-178,-103,-2,107,191,229,226,205,187,189,209,232,234,198,127,47,-16,-62,-113,-187,-276,-347,-370,-344,-295,-258,-249,-266,-293,-314,-314,-286,-243,-212,-206,-208,-189,-139,-74,-20,11,23,22,13,-3,-20,-36,-52,-70,-87,-91,-82,-76,-84,-107,-132,-153,-175,-205,-238,-261,-271,-272,-266,-246,-214,-182,-162,-149,-136,-123,-114,-105,-89,-63,-34,-9,10,19,16,2,-17,-33,-43,-49,-53,-56,-59,-60,-61,-69,-86,-106,-121,-129,-136,-144,-149,-152,-157,-160,-147,-111,-66,-29,-2,26,51,54,30},
            {2,-2,-8,-4,5,3,-6,-2,9,4,-12,-8,14,13,-17,-25,8,22,-17,-42,5,46,-7,-63,8,91,-1,46,1027,3175,5226,5126,2018,-2620,-6057,-6522,-4350,-1278,1000,1723,1214,655,1537,4659,9183,12762,13070,9673,4541,586,-574,358,1368,1052,-416,-1922,-2712,-2980,-3401,-4327,-5462,-6173,-6033,-5114,-3890,-2899,-2437,-2466,-2688,-2690,-2142,-1030,252,1125,1291,1005,845,1161,1763,2169,2115,1773,1480,1356,1251,1019,692,373,77,-238,-526,-666,-637,-588,-682,-924,-1183,-1357,-1451,-1527,-1613,-1673,-1620,-1383,-989,-586,-328,-237,-196,-90,88,279,451,610,750,839,863,848,825,805,780,742,677,573,434,280,124,-44,-230,-412,-554,-641,-689,-718,-735,-745,-759,-790,-826,-833,-779,-663,-520,-391,-298,-235,-178,-103,-2,107,191,229,226,205,187,189,209,232,234,198,127,47,-16,-62,-113,-187,-276,-347,-370,-344,-295,-258,-249,-266,-293,-314,-314,-286,-243,-212,-206,-208,-189,-139,-74,-20,11,23,22,13,-3,-20,-36,-52,-70,-87,-91,-82,-76,-84,-107,-132,-153,-175,-205,-238,-261,-271,-272,-266,-246,-214,-182,-162,-149,-136,-123,-114,-105,-89,-63,-34,-9,10,19,16,2,-17,-33,-43,-49,-53,-56,-59,-60,-61,-69,-86,-106,-121,-129,-136,-144,-149,-152,-157,-160,-147,-111,-66,-29,-2,26,51,54,30}
        }
    },
    {    // elev-20
        {    // H-20e000a.wav
            {5,-4,-8,7,19,1,-22,-5,27,6,-46,-30,46,48,-51,-79,36,89,-44,-118,45,121,13,810,3688,7207,7158,1063,-7481,-11244,-7205,-358,1978,-1317,-4401,-2002,4622,10057,10998,8421,4979,2788,3542,7968,13674,15351,9487,-1090,-8975,-9142,-3591,1095,146,-5529,-10859,-11269,-6418,-325,2108,-682,-5742,-8598,-7290,-3440,88,1770,1781,910,-61,-309,739,2721,4374,4603,3487,2119,1544,1896,2412,2140,768,-1067,-2286,-2314,-1590,-1104,-1468,-2469,-3445,-3909,-3778,-3193,-2358,-1556,-1130,-1224,-1543,-1502,-769,355,1178,1287,931,707,937,1430,1781,1784,1529,1226,1019,931,902,856,745,547,241,-161,-551,-763,-733,-610,-634,-884,-1193,-1314,-1165,-893,-731,-791,-970,-1049,-899,-590,-304,-153,-106,-81,-35,47,185,368,519,551,471,381,361,391,398,343,240,121,3,-100,-181,-244,-301,-357,-416,-480,-537,-550,-486,-374,-296,-306,-375,-420,-380,-273,-169,-126,-149,-190,-189,-125,-29,53,99,119,125,123,121,131,141,124,69,2,-53,-94,-131,-153,-141,-109,-95,-113,-135,-129,-96,-57,-28,-25,-55,-102,-126,-102,-52,-25,-43,-90,-129,-125,-70,-3,12,-53,-150,-212,-223,-219,-224,-229,-216,-187,-142,-80,-17,9,-17,-65,-96,-99,-78,-42,-6,9,-2,-23,-54,-111,-187,-242,-253,-246,-254,-269,-275,-285,-307,-302,-252,-232,-318,-440,-423,-223},
            {5,-4,-8,7,19,1,-22,-5,27,6,-46,-30,46,48,-51,-79,36,89,-44,-118,45,121,13,810,3688,7207,7158,1063,-7481,-11244,-7205,-358,1978,-1317,-4401,-2002,4622,10057,10998,8421,4979,2788,3542,7968,13674,15351,9487,-1090,-8975,-9142,-3591,1095,146,-5529,-10859,-11269,-6418,-325,2108,-682,-5742,-8598,-7290,-3440,88,1770,1781,910,-61,-309,739,2721,4374,4603,3487,2119,1544,1896,2412,2140,768,-1067,-2286,-2314,-1590,-1104,-1468,-2469,-3445,-3909,-3778,-3193,-2358,-1556,-1130,-1224,-1543,-1502,-769,355,1178,1287,931,707,937,1430,1781,1784,1529,1226,1019,931,902,856,745,547,241,-161,-551,-763,-733,-610,-634,-884,-1193,-1314,-1165,-893,-731,-791,-970,-1049,-899,-590,-304,-153,-106,-81,-35,47,185,368,519,551,471,381,361,391,398,343,240,121,3,-100,-181,-244,-301,-357,-416,-480,-537,-550,-486,-374,-296,-306,-375,-420,-380,-273,-169,-126,-149,-190,-189,-125,-29,53,99,119,125,123,121,131,141,124,69,2,-53,-94,-131,-153,-141,-109,-95,-113,-135,-129,-96,-57,-28,-25,-55,-102,-126,-102,-52,-25,-43,-90,-129,-125,-70,-3,12,-53,-150,-212,-223,-219,-224,-229,-216,-187,-142,-80,-17,9,-17,-65,-96,-99,-78,-42,-6,9,-2,-23,-54,-111,-187,-242,-253,-246,-254,-269,-275,-285,-307,-302,-252,-232,-318,-440,-423,-223}
        },
        {    // H-20e005a.wav
            {-6,0,7,2,-8,-2,15,11,-12,-14,14,18,-23,-40,12,50,-6,-69,-16,70,18,-89,-25,104,33,254,1957,5074,6825,3918,-3054,-8800,-8512,-3442,389,-719,-3988,-3975,842,6842,9885,9214,6716,4390,3681,5700,9990,13302,11651,4603,-3376,-6868,-4688,-693,283,-3127,-8048,-10265,-7880,-2811,903,573,-2932,-6276,-6846,-4745,-1908,62,846,802,300,-188,6,1199,2810,3728,3360,2194,1296,1308,1926,2263,1678,331,-995,-1589,-1387,-936,-862,-1378,-2204,-2871,-3078,-2852,-2444,-2103,-1927,-1852,-1730,-1407,-827,-124,419,599,506,442,617,968,1279,1422,1420,1340,1211,1035,834,657,547,502,439,246,-95,-436,-588,-531,-445,-516,-746,-975,-1060,-982,-832,-727,-732,-805,-822,-694,-466,-271,-190,-192,-190,-121,23,202,335,357,284,213,221,291,343,328,259,175,101,40,-19,-94,-184,-261,-309,-350,-407,-455,-447,-381,-319,-311,-348,-378,-371,-333,-279,-228,-196,-184,-168,-124,-57,5,48,76,98,119,138,152,150,118,60,-1,-49,-86,-115,-131,-123,-96,-68,-59,-72,-90,-93,-71,-35,-13,-25,-65,-106,-118,-91,-48,-27,-45,-86,-119,-130,-130,-145,-189,-250,-290,-279,-223,-160,-118,-89,-55,-22,-8,-11,-19,-34,-58,-67,-37,15,44,31,-3,-46,-110,-196,-271,-311,-327,-329,-307,-276,-287,-345,-376,-334,-295,-357,-460,-432,-225},
            {-9,0,20,14,-18,-23,16,28,-26,-56,13,75,0,-102,-35,103,44,-127,-63,137,52,229,2303,6376,8819,5073,-4246,-11948,-11300,-3905,1861,678,-3772,-4003,2094,9533,12688,10729,6532,3096,2507,6117,12756,17302,14090,3187,-8173,-12011,-7261,-328,1547,-3199,-9963,-12712,-9126,-2218,2388,1230,-4135,-8803,-9091,-5432,-1040,1490,1856,1112,255,-63,648,2375,4233,5014,4303,2888,1987,2138,2789,2835,1583,-598,-2509,-3110,-2433,-1511,-1403,-2310,-3592,-4459,-4527,-3867,-2793,-1726,-1095,-1104,-1500,-1662,-1098,74,1179,1602,1358,1015,1083,1541,1976,2050,1771,1376,1081,950,921,893,808,654,413,53,-384,-735,-845,-772,-765,-992,-1339,-1528,-1409,-1087,-806,-741,-885,-1062,-1063,-821,-466,-192,-69,-26,27,119,244,398,551,634,612,537,494,504,515,466,337,151,-42,-185,-261,-301,-345,-396,-447,-515,-608,-670,-624,-476,-338,-309,-366,-407,-366,-262,-156,-95,-96,-136,-163,-132,-43,57,123,147,144,131,116,102,88,69,41,10,-22,-60,-102,-137,-151,-148,-144,-155,-175,-182,-154,-93,-27,5,-16,-70,-111,-106,-64,-26,-27,-65,-107,-114,-69,8,64,53,-28,-125,-177,-180,-181,-213,-256,-268,-237,-180,-114,-55,-28,-43,-76,-88,-74,-59,-57,-52,-36,-22,-26,-51,-97,-161,-221,-245,-232,-220,-232,-247,-243,-234,-235,-236,-241,-303,-437,-537,-461,-223}
        },
        {    // H-20e010a.wav
            {-4,-5,-3,3,5,-2,-5,5,13,1,-15,-6,16,5,-29,-24,25,33,-28,-55,12,55,-17,-67,26,77,18,563,2576,5238,5678,1812,-4408,-8021,-6242,-1770,295,-1583,-3878,-2588,2155,6824,8655,7744,5693,3968,3832,6140,9913,11922,9298,2834,-3209,-5083,-3015,-548,-893,-4157,-7657,-8457,-5834,-1842,411,-588,-3546,-5755,-5597,-3612,-1398,-2,498,420,90,-70,380,1457,2557,2935,2407,1503,962,1092,1567,1752,1257,255,-684,-1088,-956,-690,-712,-1128,-1707,-2125,-2226,-2094,-1924,-1840,-1836,-1821,-1680,-1318,-750,-159,196,217,77,60,286,646,957,1123,1144,1054,901,743,621,547,523,530,494,326,35,-232,-333,-294,-282,-412,-633,-805,-838,-755,-650,-619,-685,-767,-750,-605,-425,-322,-313,-327,-291,-185,-34,114,200,193,131,100,149,242,304,295,237,172,122,81,31,-40,-124,-201,-259,-301,-336,-361,-365,-353,-345,-356,-375,-383,-372,-341,-301,-265,-238,-211,-163,-89,-10,46,75,94,111,123,132,147,156,131,65,-9,-57,-85,-115,-144,-144,-114,-88,-93,-113,-120,-106,-80,-51,-28,-27,-50,-76,-78,-58,-39,-42,-73,-121,-168,-194,-201,-217,-256,-288,-273,-211,-140,-87,-51,-27,-22,-34,-42,-39,-37,-42,-36,-6,33,52,41,0,-70,-153,-221,-264,-302,-345,-365,-348,-334,-354,-373,-344,-301,-315,-361,-326,-170},
            {8,21,-1,-28,-3,37,7,-60,-34,65,59,-71,-97,57,116,-62,-145,68,144,2,1068,4734,8994,8556,639,-9919,-14208,-8982,-726,1873,-1913,-4749,-792,7599,13522,13338,8934,4170,1967,4185,10776,17649,17996,8681,-5024,-13322,-11257,-3307,1632,-1061,-8266,-13084,-11263,-4419,1804,2572,-2206,-8101,-10305,-7704,-3019,486,1746,1614,1088,632,690,1756,3592,5007,4926,3587,2338,2259,3108,3611,2667,326,-2247,-3725,-3649,-2692,-1979,-2158,-3035,-3949,-4372,-4163,-3465,-2536,-1701,-1271,-1310,-1454,-1127,-109,1129,1801,1609,1055,902,1391,2086,2416,2214,1724,1254,947,800,755,737,668,484,160,-263,-652,-846,-814,-739,-865,-1234,-1604,-1681,-1409,-1022,-817,-887,-1060,-1081,-850,-488,-196,-66,-35,3,102,260,457,641,732,689,578,514,536,570,523,381,197,26,-108,-200,-261,-318,-391,-481,-580,-682,-754,-738,-607,-428,-319,-339,-422,-447,-358,-201,-71,-31,-70,-121,-114,-36,68,147,188,200,187,153,116,91,68,29,-18,-52,-68,-90,-128,-154,-151,-140,-153,-186,-204,-187,-142,-88,-45,-36,-69,-119,-137,-100,-37,-3,-24,-79,-114,-85,3,96,134,100,30,-30,-66,-94,-138,-202,-266,-298,-278,-217,-151,-109,-91,-82,-73,-62,-55,-60,-79,-95,-87,-53,-24,-31,-75,-134,-188,-222,-229,-217,-204,-199,-192,-177,-170,-191,-238,-310,-418,-542,-587,-462,-212}
        },
        {    // H-20e015a.wav
            {-4,-4,-3,-4,-2,3,3,-4,-5,6,10,-3,-13,0,13,-5,-29,-10,27,13,-39,-36,27,36,-32,-39,44,37,60,871,2929,4969,4435,316,-4818,-6832,-4481,-917,-41,-2008,-3383,-1459,2809,6387,7476,6516,4832,3615,3947,6325,9476,10563,7679,2095,-2626,-3927,-2418,-870,-1476,-4084,-6601,-6884,-4574,-1479,-59,-1240,-3667,-5139,-4653,-2924,-1230,-222,152,126,-66,-50,526,1550,2377,2390,1608,694,357,760,1434,1706,1253,332,-482,-778,-602,-341,-358,-719,-1208,-1546,-1618,-1515,-1414,-1429,-1557,-1704,-1725,-1490,-998,-441,-93,-69,-220,-285,-130,178,490,707,805,807,759,706,675,670,678,659,551,328,67,-98,-109,-62,-109,-303,-549,-707,-715,-618,-521,-509,-587,-679,-698,-623,-513,-432,-394,-368,-319,-231,-107,19,93,90,47,33,81,163,233,264,252,203,134,66,7,-52,-112,-158,-189,-225,-277,-321,-329,-315,-325,-375,-429,-440,-394,-322,-257,-212,-183,-158,-125,-78,-19,42,93,120,123,121,129,131,103,46,-9,-44,-76,-120,-160,-170,-152,-131,-122,-111,-93,-80,-71,-49,-7,28,22,-23,-70,-88,-80,-74,-92,-137,-191,-237,-264,-274,-272,-262,-243,-207,-147,-75,-17,2,-14,-40,-55,-60,-55,-34,0,32,52,58,42,-10,-94,-180,-243,-289,-329,-356,-364,-366,-376,-375,-342,-304,-300,-308,-256,-127},
            {19,-22,-26,24,35,-35,-69,19,89,-6,-121,-32,125,41,-156,-60,174,40,231,2700,7532,10438,6096,-4813,-14060,-13899,-5931,667,42,-3862,-3101,4267,12493,15358,12171,6579,2499,2592,7939,16081,20322,14621,627,-12071,-14663,-7707,-14,550,-5818,-12372,-12888,-6956,422,3417,52,-6532,-11032,-10442,-5961,-1001,2018,2815,2213,1104,418,1026,2920,4824,5250,4030,2503,2134,3093,4176,3905,1746,-1474,-4151,-5070,-4249,-2780,-1860,-1957,-2757,-3661,-4212,-4193,-3599,-2648,-1736,-1194,-996,-749,-84,890,1604,1608,1105,785,1115,1882,2483,2537,2130,1568,1075,736,567,538,555,492,257,-151,-601,-875,-852,-673,-657,-978,-1467,-1771,-1688,-1326,-970,-838,-924,-1031,-948,-648,-300,-84,-10,42,158,325,498,651,745,729,615,502,477,514,514,425,279,125,-19,-145,-243,-315,-378,-449,-536,-643,-746,-783,-701,-535,-401,-389,-465,-512,-444,-281,-115,-30,-43,-100,-117,-52,64,164,208,212,207,203,192,170,132,70,-15,-97,-144,-153,-150,-146,-133,-112,-111,-149,-205,-233,-207,-148,-95,-77,-104,-157,-190,-165,-95,-36,-30,-66,-95,-75,1,104,176,173,111,55,44,48,11,-79,-184,-261,-291,-272,-218,-167,-156,-169,-158,-106,-52,-38,-63,-100,-124,-121,-89,-50,-41,-73,-119,-154,-185,-216,-224,-194,-157,-150,-160,-155,-151,-197,-303,-426,-532,-604,-596,-451,-206}
        },
        {    // H-20e020a.wav
            {-1,-1,-1,-2,-5,-5,0,5,1,-6,-3,7,6,-6,-9,5,9,-11,-23,0,24,1,-36,-17,32,21,-32,-16,40,10,142,1115,3040,4473,3328,-622,-4674,-5597,-3174,-497,-375,-2159,-2810,-624,3057,5741,6332,5446,4167,3419,4060,6345,8963,9481,6559,1588,-2365,-3323,-1990,-757,-1405,-3677,-5700,-5712,-3643,-1223,-428,-1689,-3639,-4574,-3966,-2537,-1219,-406,-57,-33,-121,11,570,1334,1774,1548,857,286,315,918,1582,1718,1151,260,-366,-427,-108,170,116,-263,-758,-1141,-1303,-1282,-1210,-1214,-1339,-1523,-1630,-1536,-1234,-875,-654,-628,-664,-581,-325,11,309,522,665,762,813,812,767,717,686,647,540,351,155,46,31,15,-90,-277,-459,-555,-542,-464,-406,-439,-556,-667,-686,-615,-526,-467,-430,-388,-335,-269,-182,-87,-21,-4,-4,32,110,186,217,202,169,135,98,50,-4,-51,-83,-107,-144,-202,-266,-312,-328,-327,-326,-333,-340,-336,-310,-261,-199,-152,-134,-129,-108,-63,-10,28,50,67,82,84,65,34,2,-29,-61,-91,-112,-125,-133,-132,-112,-79,-53,-46,-48,-40,-12,22,40,27,-13,-61,-95,-106,-106,-116,-153,-213,-276,-315,-312,-280,-247,-223,-186,-121,-47,-1,4,-13,-35,-55,-61,-41,1,37,53,57,56,34,-24,-104,-182,-248,-302,-336,-346,-348,-359,-365,-345,-314,-302,-292,-230,-110},
            {-32,5,41,-3,-73,-35,73,58,-87,-110,61,121,-78,-164,82,162,-58,978,4949,9934,10182,2122,-9782,-16014,-12103,-3729,153,-2115,-3880,679,9441,15511,15059,10001,4627,2410,5385,12999,20163,19370,7919,-7457,-15793,-12549,-3818,538,-3226,-10297,-13300,-9354,-1835,3166,1843,-4561,-10941,-12546,-8691,-2662,1769,3298,2901,1888,999,836,1893,3751,4984,4540,3023,2128,2786,4169,4523,2793,-549,-3937,-5794,-5473,-3581,-1539,-655,-1325,-2920,-4377,-4928,-4451,-3320,-2077,-1161,-711,-490,-91,628,1313,1468,1072,695,907,1662,2392,2619,2324,1772,1189,701,408,354,445,488,338,-16,-460,-807,-900,-760,-637,-803,-1258,-1693,-1774,-1455,-996,-723,-760,-958,-1046,-867,-504,-172,1,68,156,317,508,663,730,686,564,463,469,557,605,526,341,135,-30,-146,-232,-301,-359,-412,-477,-576,-702,-795,-775,-633,-464,-388,-430,-507,-517,-422,-265,-126,-64,-73,-89,-48,51,146,185,181,177,195,221,233,214,151,44,-74,-160,-195,-198,-187,-161,-119,-90,-107,-165,-218,-228,-196,-155,-135,-149,-192,-242,-259,-219,-140,-77,-66,-84,-76,-6,104,192,213,176,129,113,122,111,46,-63,-170,-238,-257,-241,-217,-210,-221,-221,-180,-107,-51,-49,-90,-136,-160,-159,-136,-100,-73,-72,-95,-127,-165,-213,-244,-223,-166,-129,-133,-138,-119,-129,-239,-431,-602,-673,-640,-526,-348,-147}
        },
        {    // H-20e025a.wav
            {-1,1,2,1,-1,-3,-4,-3,1,2,-1,-4,1,7,3,-6,-4,7,5,-12,-14,9,20,-7,-30,-3,33,11,-28,-5,27,1,225,1253,2952,3893,2459,-1085,-4199,-4465,-2266,-362,-668,-2135,-2248,-58,2986,4952,5273,4602,3743,3368,4170,6270,8385,8418,5478,1075,-2097,-2593,-1331,-442,-1255,-3285,-4861,-4674,-2933,-1163,-818,-1996,-3502,-4087,-3483,-2287,-1175,-442,-115,-130,-290,-275,106,691,1090,1062,747,535,708,1186,1575,1507,968,327,13,148,477,617,369,-162,-706,-1048,-1152,-1119,-1072,-1093,-1221,-1442,-1660,-1735,-1605,-1352,-1114,-940,-764,-513,-200,107,356,531,629,663,668,675,687,687,666,618,521,368,202,97,70,52,-39,-202,-352,-410,-378,-331,-348,-451,-587,-677,-674,-597,-502,-437,-413,-408,-390,-330,-228,-120,-50,-28,-19,16,80,139,165,151,109,59,19,-2,-14,-36,-72,-111,-150,-196,-244,-272,-269,-251,-244,-251,-253,-238,-215,-195,-181,-170,-157,-138,-108,-70,-38,-19,-10,-8,-13,-22,-26,-25,-32,-52,-73,-84,-87,-88,-82,-58,-24,2,9,4,-1,-2,1,8,11,-5,-45,-93,-129,-147,-159,-183,-226,-277,-319,-329,-306,-262,-209,-153,-96,-47,-13,0,-10,-35,-53,-46,-14,23,53,73,80,62,16,-45,-111,-184,-259,-309,-319,-308,-307,-318,-326,-333,-348,-341,-262,-122},
            {19,27,-34,-64,21,90,-5,-126,-39,129,50,-165,-74,196,49,53,2307,7411,11402,8359,-2409,-13480,-16185,-10033,-2889,-1310,-3203,-1739,5384,13338,16271,13261,7767,3836,4260,9945,18045,21609,14755,-286,-13369,-15775,-8815,-1788,-1913,-7729,-12196,-10482,-4046,1601,1912,-3251,-9773,-12664,-10059,-4378,425,2469,2627,2360,2061,1667,1678,2611,3897,4295,3497,2611,2782,3751,4115,2794,-12,-3091,-5093,-5264,-3798,-1754,-458,-673,-2135,-3846,-4834,-4725,-3765,-2484,-1377,-721,-470,-272,229,968,1444,1289,797,673,1240,2077,2524,2364,1868,1334,839,414,181,206,347,372,170,-205,-609,-876,-901,-772,-757,-1035,-1460,-1672,-1473,-1027,-676,-630,-818,-991,-934,-629,-248,5,81,93,172,337,521,654,696,639,537,489,543,626,608,450,232,50,-76,-184,-292,-384,-442,-478,-528,-614,-710,-747,-674,-528,-414,-410,-482,-526,-476,-350,-212,-117,-80,-71,-39,42,137,185,172,149,169,225,265,251,183,77,-42,-137,-179,-173,-155,-144,-128,-102,-92,-125,-183,-217,-203,-162,-132,-140,-188,-255,-305,-305,-253,-183,-133,-109,-84,-23,81,198,270,261,194,141,148,185,179,97,-28,-142,-213,-240,-234,-221,-226,-242,-231,-167,-79,-27,-41,-98,-154,-182,-178,-152,-118,-90,-71,-64,-86,-148,-226,-266,-239,-177,-133,-113,-86,-48,-57,-176,-391,-610,-730,-704,-556,-353,-167,-47}
        },
        {    // H-20e030a.wav
            {-1,-2,-1,0,0,-1,-2,-3,-4,-2,1,2,-2,-4,1,5,0,-7,-2,8,3,-12,-11,9,13,-11,-22,6,28,1,-26,1,17,2,277,1280,2738,3338,1860,-1184,-3569,-3532,-1722,-427,-885,-1966,-1734,244,2658,4128,4419,4057,3558,3412,4207,5977,7542,7212,4503,885,-1485,-1705,-732,-249,-1121,-2814,-4026,-3849,-2543,-1296,-1157,-2116,-3219,-3545,-2969,-2014,-1206,-726,-536,-556,-643,-569,-184,402,887,1049,948,856,982,1277,1490,1407,1056,677,496,533,610,521,195,-264,-676,-916,-993,-1013,-1076,-1214,-1406,-1606,-1748,-1756,-1604,-1348,-1075,-820,-563,-294,-53,122,237,323,398,461,508,539,556,574,602,615,555,401,215,90,55,49,2,-99,-213,-295,-330,-341,-372,-448,-548,-614,-606,-543,-475,-431,-409,-395,-375,-331,-257,-174,-112,-78,-53,-21,15,43,63,74,71,48,10,-28,-57,-72,-77,-81,-96,-130,-172,-205,-223,-230,-233,-235,-235,-226,-205,-175,-147,-133,-134,-144,-150,-140,-113,-81,-59,-54,-61,-64,-62,-59,-58,-60,-65,-69,-66,-50,-21,14,45,60,53,27,-5,-32,-46,-47,-40,-41,-60,-99,-142,-180,-220,-266,-309,-334,-337,-318,-270,-195,-119,-72,-54,-46,-41,-45,-51,-38,-3,32,54,69,79,66,25,-24,-71,-131,-208,-267,-280,-269,-270,-278,-277,-296,-365,-427,-369,-183},
            {15,-70,-54,66,80,-71,-130,40,144,-50,-196,45,218,-85,436,3903,9471,11774,5812,-6263,-15610,-15582,-8766,-3212,-2578,-2734,1561,9435,15213,15212,10929,6368,4781,7870,14957,21322,19967,8318,-7162,-15847,-13429,-5942,-2528,-5762,-10441,-10665,-5990,-733,828,-2203,-7395,-11066,-10769,-6888,-2082,1154,2355,2530,2434,2108,1791,2160,3304,4208,3925,2876,2350,2809,3266,2483,368,-2020,-3562,-3876,-3251,-2230,-1382,-1187,-1803,-2894,-3812,-4066,-3625,-2802,-1939,-1250,-809,-517,-122,517,1161,1372,1075,763,967,1617,2143,2163,1820,1431,1076,675,286,91,129,220,166,-85,-454,-795,-948,-868,-728,-794,-1122,-1456,-1490,-1190,-806,-604,-641,-775,-807,-636,-329,-62,42,22,29,160,377,566,642,600,504,448,486,581,626,549,373,184,40,-66,-175,-309,-444,-534,-570,-594,-649,-704,-678,-546,-403,-368,-453,-548,-550,-453,-318,-193,-99,-46,-23,10,81,158,188,169,157,191,240,251,202,110,-1,-108,-180,-203,-191,-173,-154,-121,-77,-54,-76,-128,-172,-186,-176,-168,-187,-233,-283,-309,-301,-269,-228,-186,-140,-79,10,126,236,290,275,230,208,221,231,189,86,-42,-146,-196,-203,-200,-215,-247,-264,-237,-165,-84,-40,-51,-94,-133,-155,-164,-161,-139,-103,-74,-67,-90,-145,-217,-265,-250,-190,-142,-123,-80,2,31,-96,-356,-607,-739,-738,-626,-414,-156,28,62}
        },
        {    // H-20e035a.wav
            {-1,-1,-2,-3,-2,-1,-1,-2,-3,-4,-5,-3,0,0,-4,-6,-1,3,0,-5,-3,3,-1,-11,-8,7,8,-12,-18,5,20,-3,-22,-2,3,6,302,1223,2454,2865,1524,-1024,-2934,-2879,-1485,-553,-941,-1694,-1367,276,2214,3459,3859,3754,3474,3407,4041,5385,6497,6108,3934,1135,-703,-966,-370,-126,-874,-2260,-3325,-3330,-2394,-1400,-1204,-1888,-2792,-3215,-2972,-2324,-1591,-975,-613,-564,-692,-693,-341,290,890,1194,1196,1115,1173,1388,1563,1481,1128,708,457,430,478,403,128,-264,-630,-890,-1057,-1175,-1260,-1314,-1365,-1442,-1509,-1471,-1275,-987,-737,-590,-509,-422,-296,-142,17,157,261,331,384,433,475,507,534,540,486,357,202,99,75,77,35,-60,-160,-221,-249,-282,-342,-416,-474,-498,-494,-477,-458,-442,-433,-425,-402,-352,-278,-205,-154,-128,-108,-82,-49,-13,25,58,68,46,12,-14,-27,-43,-66,-86,-99,-121,-164,-211,-237,-241,-237,-227,-203,-167,-134,-117,-114,-122,-137,-154,-161,-154,-140,-124,-104,-84,-73,-71,-72,-73,-76,-77,-63,-34,-5,15,35,62,77,63,28,-5,-27,-44,-51,-41,-24,-27,-63,-123,-191,-254,-300,-323,-328,-323,-303,-252,-180,-119,-84,-68,-60,-59,-54,-32,4,30,42,57,78,76,37,-15,-60,-109,-170,-211,-214,-210,-233,-253,-238,-238,-319,-425,-402,-211},
            {-67,5,89,22,-123,-88,106,109,-131,-160,149,162,-163,1004,5422,10924,11476,3381,-9099,-16802,-15090,-8331,-3789,-2922,-1116,4832,12063,15367,13259,8793,5941,7035,12392,19478,22491,16115,1769,-11605,-15525,-10474,-4694,-4687,-8888,-11156,-8396,-3159,72,-820,-4739,-8944,-10790,-9138,-5078,-1017,1413,2355,2643,2514,1974,1711,2544,4027,4628,3622,2097,1549,1987,2077,949,-827,-2125,-2535,-2444,-2272,-2079,-1884,-1915,-2339,-2936,-3261,-3106,-2642,-2134,-1678,-1266,-908,-562,-79,568,1092,1168,921,870,1280,1796,1930,1677,1411,1279,1049,577,110,-41,80,168,31,-286,-659,-967,-1081,-959,-766,-764,-1011,-1273,-1291,-1055,-770,-613,-598,-612,-539,-351,-133,-6,-1,-23,46,228,439,572,571,462,344,332,445,574,589,473,312,176,54,-84,-226,-339,-416,-482,-554,-632,-697,-711,-637,-494,-373,-364,-451,-523,-499,-395,-280,-192,-125,-66,-9,54,125,181,192,170,161,186,214,203,145,57,-48,-151,-219,-238,-227,-210,-182,-125,-60,-32,-51,-82,-101,-118,-150,-192,-238,-286,-323,-324,-286,-242,-220,-208,-172,-97,10,135,246,298,282,247,244,262,249,183,86,-14,-104,-173,-206,-219,-244,-276,-275,-226,-162,-120,-101,-92,-92,-102,-113,-122,-132,-135,-115,-79,-68,-105,-163,-210,-236,-238,-210,-167,-132,-88,2,83,10,-269,-598,-769,-753,-663,-528,-278,49,244,183}
        },
        {    // H-20e040a.wav
            {1,0,0,0,0,-1,-1,-1,0,0,-1,-3,-4,-2,1,2,-1,-2,1,4,1,-3,-1,3,0,-7,-3,9,7,-9,-11,10,20,-3,-19,-2,2,15,294,1109,2175,2533,1402,-766,-2434,-2482,-1389,-614,-879,-1446,-1156,207,1858,3011,3507,3554,3367,3248,3630,4606,5507,5332,3752,1555,-35,-428,-70,85,-562,-1788,-2784,-2880,-2166,-1420,-1380,-2077,-2891,-3192,-2843,-2127,-1393,-860,-632,-694,-846,-776,-300,461,1162,1511,1476,1275,1157,1195,1260,1183,934,651,485,446,410,252,-50,-422,-765,-1009,-1122,-1111,-1031,-964,-976,-1061,-1140,-1123,-995,-831,-725,-703,-705,-648,-493,-270,-52,94,156,181,224,294,365,420,460,468,407,282,164,120,135,136,76,-16,-88,-125,-153,-196,-262,-346,-429,-481,-488,-468,-455,-460,-464,-446,-402,-342,-280,-229,-197,-176,-152,-115,-67,-18,19,35,33,26,18,3,-27,-68,-104,-131,-157,-182,-198,-199,-192,-180,-162,-142,-130,-128,-127,-121,-119,-131,-152,-165,-166,-161,-156,-147,-133,-116,-99,-83,-70,-61,-55,-50,-41,-23,5,33,48,49,40,30,17,0,-12,-13,-11,-18,-35,-61,-107,-178,-255,-308,-328,-329,-318,-289,-237,-175,-121,-85,-69,-74,-81,-66,-32,1,24,46,61,51,16,-18,-44,-82,-138,-175,-174,-170,-194,-218,-208,-210,-284,-380,-360,-189},
            {2,81,4,-125,-52,132,70,-174,-112,210,90,-178,1557,6628,11891,11049,1530,-11067,-17686,-15073,-8368,-3995,-2305,916,7289,13192,14432,11186,7311,6462,9991,16742,22687,21978,11711,-3461,-13885,-14023,-7991,-4486,-7056,-11280,-11203,-6249,-912,592,-2168,-6678,-9983,-10303,-7651,-3669,-378,1348,1979,2180,2121,2012,2447,3561,4372,3782,2131,1002,1298,2128,1964,474,-1262,-2147,-2144,-1910,-1858,-1911,-1966,-2149,-2528,-2851,-2806,-2427,-2037,-1823,-1657,-1355,-913,-400,154,638,816,658,551,905,1568,1944,1744,1321,1127,1122,965,581,226,73,22,-66,-204,-387,-658,-962,-1115,-1043,-924,-956,-1093,-1128,-986,-789,-666,-621,-592,-522,-373,-153,40,89,2,-66,21,245,464,551,480,337,259,322,468,555,504,362,220,111,15,-85,-190,-299,-403,-481,-532,-591,-666,-698,-628,-496,-404,-402,-432,-420,-360,-293,-243,-202,-153,-91,-7,93,175,200,164,116,104,139,186,193,133,23,-97,-188,-237,-250,-239,-212,-172,-130,-94,-70,-56,-47,-49,-70,-109,-159,-214,-273,-320,-329,-298,-258,-234,-212,-159,-69,33,131,214,266,269,246,243,262,254,189,100,28,-28,-97,-177,-245,-293,-317,-302,-245,-184,-161,-166,-154,-116,-82,-68,-67,-77,-102,-118,-96,-63,-77,-142,-197,-209,-207,-215,-204,-147,-66,14,77,55,-153,-506,-780,-805,-666,-542,-413,-129,255,445,290}
        },
        {    // H-20e045a.wav
            {1,1,0,-1,-1,-1,-1,-2,-2,-1,-1,-2,-3,-4,-4,-2,1,1,-2,-3,1,3,0,-4,-2,3,1,-7,-5,6,7,-6,-10,7,16,-3,-21,-9,-2,16,261,973,1929,2305,1379,-525,-2091,-2267,-1360,-616,-753,-1228,-1026,133,1627,2739,3257,3322,3116,2902,3089,3857,4729,4829,3732,1958,532,63,284,395,-206,-1425,-2569,-2948,-2478,-1753,-1477,-1835,-2417,-2693,-2475,-1938,-1361,-942,-767,-784,-781,-501,128,878,1385,1447,1174,864,755,865,1027,1060,913,675,462,305,147,-68,-318,-525,-631,-647,-625,-612,-629,-687,-791,-927,-1044,-1080,-1016,-898,-803,-768,-761,-715,-586,-394,-203,-64,22,84,143,197,247,308,376,408,364,265,180,156,174,182,151,87,9,-68,-133,-185,-240,-317,-410,-482,-501,-474,-437,-420,-421,-423,-412,-385,-340,-278,-217,-178,-164,-152,-116,-56,3,32,23,-12,-49,-76,-91,-101,-109,-117,-128,-144,-155,-148,-122,-99,-98,-114,-128,-132,-135,-143,-154,-165,-179,-191,-189,-170,-143,-126,-119,-114,-106,-95,-80,-62,-45,-33,-25,-17,-11,-3,13,32,43,41,36,35,31,16,-7,-28,-58,-116,-193,-260,-300,-314,-308,-280,-237,-198,-172,-150,-127,-111,-106,-98,-77,-45,-12,17,31,20,-8,-27,-34,-53,-93,-125,-132,-141,-176,-206,-198,-190,-242,-318,-302,-159},
            {78,-55,-143,-2,164,34,-205,-72,248,36,-194,1870,7309,12491,10990,697,-12224,-18657,-15708,-8663,-3697,-1103,2733,8680,13162,12973,9364,6520,7608,12972,20199,24440,20549,7958,-6626,-14152,-12104,-6848,-5949,-9709,-12125,-9100,-3108,486,-599,-4441,-8059,-9791,-9205,-6599,-3135,-375,981,1475,1837,2156,2344,2690,3305,3521,2677,1350,938,1837,2739,2171,277,-1479,-2102,-1929,-1760,-1794,-1762,-1675,-1863,-2363,-2743,-2660,-2293,-2016,-1880,-1660,-1253,-765,-268,236,589,561,268,239,796,1563,1869,1574,1164,1044,1068,905,571,339,287,212,-27,-335,-581,-768,-929,-1018,-1012,-1010,-1109,-1226,-1183,-939,-648,-482,-468,-500,-466,-321,-107,66,106,29,-35,32,223,409,467,387,275,259,375,529,580,472,278,114,23,-31,-95,-180,-270,-360,-456,-556,-640,-674,-638,-549,-464,-429,-433,-421,-359,-269,-195,-157,-145,-136,-102,-23,81,153,154,109,79,93,127,143,124,68,-23,-122,-190,-211,-211,-215,-216,-188,-138,-99,-85,-81,-68,-51,-50,-71,-106,-150,-205,-267,-319,-336,-310,-257,-194,-125,-40,56,133,173,187,202,234,268,282,257,193,111,44,0,-44,-114,-203,-280,-319,-314,-277,-238,-224,-235,-228,-171,-91,-41,-36,-49,-59,-68,-76,-70,-66,-94,-147,-183,-187,-187,-195,-172,-89,21,90,67,-91,-386,-699,-837,-738,-551,-422,-276,37,417,553,329}
        },
        {    // H-20e050a.wav
            {1,1,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-2,-1,1,1,-1,-2,1,3,0,-4,-1,6,4,-5,-6,3,6,-4,-7,9,17,-5,-26,-11,7,23,218,837,1731,2159,1395,-354,-1887,-2145,-1314,-548,-603,-1040,-897,147,1528,2542,2972,2971,2725,2471,2589,3293,4205,4523,3785,2379,1170,663,598,320,-550,-1766,-2678,-2782,-2154,-1393,-1112,-1438,-1991,-2314,-2235,-1871,-1412,-988,-676,-494,-354,-112,281,696,936,919,737,573,567,725,917,967,797,495,235,109,74,38,-28,-92,-132,-176,-268,-421,-613,-803,-955,-1042,-1057,-1012,-939,-878,-853,-851,-831,-760,-634,-477,-319,-180,-68,20,94,156,205,246,290,326,330,292,242,224,243,258,223,134,22,-77,-145,-187,-224,-281,-357,-425,-459,-463,-460,-461,-459,-448,-429,-402,-358,-300,-244,-204,-176,-147,-111,-77,-54,-45,-44,-48,-57,-64,-65,-57,-47,-48,-66,-89,-102,-102,-97,-93,-92,-102,-130,-167,-192,-194,-183,-175,-172,-169,-162,-155,-147,-134,-117,-104,-96,-89,-77,-60,-42,-27,-21,-20,-14,2,25,49,70,85,83,61,28,-5,-39,-84,-139,-193,-235,-259,-264,-250,-226,-207,-199,-192,-182,-173,-160,-132,-94,-62,-42,-23,-7,-7,-22,-31,-26,-29,-53,-81,-96,-117,-160,-195,-192,-181,-214,-267,-249,-131},
            {-3,-129,-45,142,66,-189,-110,235,84,-252,1541,6941,12663,11971,1894,-11891,-19697,-17448,-9827,-3582,-116,3615,8802,12512,11912,8369,6193,8515,15063,22428,25398,19790,6569,-7116,-13477,-11571,-7717,-7733,-10527,-10811,-6592,-1466,225,-1954,-5442,-8145,-9435,-8970,-6563,-3161,-476,753,1238,1727,2059,1991,1961,2313,2481,1867,1128,1513,2916,3624,2397,54,-1588,-1843,-1515,-1440,-1537,-1443,-1360,-1726,-2406,-2782,-2598,-2256,-2168,-2195,-1949,-1373,-738,-212,219,472,377,79,87,664,1403,1678,1420,1114,1080,1107,905,581,425,438,364,96,-216,-463,-705,-961,-1094,-1039,-966,-1061,-1242,-1261,-1038,-741,-549,-468,-412,-338,-243,-125,-12,27,-26,-61,47,272,438,419,276,183,245,420,578,616,517,338,156,15,-85,-162,-229,-297,-374,-463,-554,-630,-668,-645,-563,-460,-393,-380,-380,-343,-263,-181,-126,-95,-69,-39,1,50,85,81,52,46,87,137,141,91,13,-70,-149,-203,-217,-208,-204,-206,-186,-139,-100,-87,-81,-62,-45,-53,-78,-102,-129,-173,-226,-267,-287,-290,-273,-221,-139,-48,36,107,154,170,174,195,235,262,248,197,136,82,34,-19,-91,-179,-257,-294,-288,-269,-263,-274,-286,-275,-226,-147,-72,-39,-44,-54,-54,-55,-62,-64,-65,-87,-129,-162,-173,-176,-169,-116,-4,100,98,-55,-323,-612,-804,-806,-640,-435,-271,-72,234,521,553,298}
        },
        {    // H-20e055a.wav
            {1,2,1,0,0,1,2,1,0,-1,0,0,0,-1,-1,0,0,-1,-2,-1,2,3,1,0,2,4,2,-1,1,6,4,-4,-6,3,9,3,-2,6,9,-9,-20,0,16,17,175,736,1583,2028,1361,-269,-1749,-2039,-1248,-449,-415,-807,-722,194,1433,2307,2599,2512,2288,2125,2295,2982,3918,4415,3946,2679,1332,511,221,-5,-581,-1459,-2171,-2259,-1717,-1031,-767,-1090,-1679,-2073,-2042,-1663,-1160,-736,-503,-446,-437,-323,-49,301,574,659,556,387,321,443,664,799,750,591,466,431,431,393,299,162,-12,-216,-429,-620,-773,-880,-942,-972,-988,-993,-968,-908,-848,-828,-838,-816,-707,-524,-332,-188,-102,-46,7,66,131,207,293,362,380,346,300,283,289,276,213,113,10,-70,-125,-163,-203,-263,-350,-442,-506,-526,-514,-495,-476,-454,-423,-386,-342,-293,-247,-215,-199,-187,-163,-121,-69,-23,0,-4,-22,-35,-37,-30,-23,-17,-16,-28,-58,-93,-118,-130,-141,-153,-161,-161,-160,-165,-176,-189,-204,-214,-208,-183,-147,-112,-86,-71,-68,-70,-69,-59,-43,-28,-10,14,37,52,62,73,77,62,31,-2,-28,-52,-82,-118,-156,-193,-221,-233,-230,-220,-206,-190,-180,-183,-187,-170,-129,-89,-67,-56,-45,-40,-43,-41,-25,-12,-24,-53,-81,-114,-157,-188,-184,-171,-193,-231,-212,-111},
            {-112,-36,131,80,-174,-150,209,161,-293,976,6018,12425,13307,4164,-10613,-20627,-19669,-11283,-3317,956,4102,8360,11714,11164,7637,5660,8768,16276,23827,26020,19626,6438,-6825,-13388,-12340,-8851,-7924,-9132,-8600,-4905,-958,-157,-2644,-6085,-8584,-9587,-8911,-6535,-3321,-720,615,1194,1549,1548,1142,916,1270,1642,1397,1071,1777,3374,4199,3032,642,-1180,-1639,-1351,-1077,-883,-683,-821,-1606,-2629,-3099,-2800,-2291,-2120,-2204,-2122,-1712,-1131,-525,29,346,252,-59,-71,465,1168,1482,1337,1121,1080,1050,844,594,522,571,503,260,-3,-206,-436,-722,-925,-958,-947,-1047,-1203,-1232,-1073,-851,-693,-606,-541,-459,-331,-152,6,35,-63,-134,-33,204,391,397,274,183,231,395,565,638,586,446,271,97,-57,-177,-260,-322,-387,-465,-550,-621,-655,-633,-560,-467,-390,-348,-330,-310,-269,-207,-139,-83,-46,-13,33,82,98,65,10,-12,25,92,135,118,44,-61,-166,-241,-266,-250,-221,-196,-167,-126,-88,-68,-54,-31,-9,-15,-53,-101,-144,-186,-224,-244,-243,-237,-232,-211,-159,-85,-6,65,124,157,166,179,212,239,225,173,124,100,83,45,-24,-118,-216,-284,-298,-275,-260,-276,-304,-305,-263,-190,-112,-59,-46,-58,-68,-69,-73,-79,-70,-53,-56,-86,-117,-131,-137,-126,-63,45,106,18,-216,-496,-709,-792,-726,-543,-319,-109,105,340,506,467,235}
        },
        {    // H-20e060a.wav
            {3,2,0,0,1,1,1,1,1,1,0,0,1,1,0,-1,-1,0,1,0,-1,0,2,3,1,0,3,5,2,-1,2,7,4,-4,-4,6,10,0,-6,5,12,-2,-14,2,17,20,165,672,1441,1851,1250,-246,-1622,-1896,-1133,-322,-222,-565,-521,256,1309,2006,2181,2091,2004,2055,2352,2928,3539,3729,3239,2296,1400,855,563,213,-386,-1134,-1700,-1766,-1315,-711,-435,-679,-1209,-1632,-1747,-1613,-1378,-1124,-878,-660,-478,-303,-106,90,213,208,107,41,158,495,910,1179,1183,991,763,588,440,268,78,-81,-186,-275,-405,-592,-787,-919,-964,-961,-962,-975,-965,-917,-859,-824,-803,-756,-664,-542,-417,-299,-187,-80,23,121,211,284,335,363,367,347,315,289,277,259,206,107,-15,-118,-177,-206,-243,-316,-411,-489,-527,-535,-526,-501,-458,-415,-389,-374,-349,-306,-259,-221,-191,-160,-124,-83,-41,-9,2,-9,-21,-16,1,13,11,-1,-21,-49,-80,-102,-113,-120,-131,-149,-170,-191,-212,-230,-240,-240,-231,-215,-192,-160,-119,-79,-53,-44,-47,-50,-47,-34,-14,12,33,41,40,39,37,29,14,-4,-19,-32,-46,-66,-100,-145,-186,-208,-211,-202,-188,-170,-156,-156,-163,-162,-147,-128,-113,-97,-80,-70,-66,-56,-37,-27,-41,-67,-89,-114,-150,-176,-174,-166,-189,-222,-198,-101},
            {-119,104,171,-100,-244,94,282,-202,245,4332,11271,14642,7891,-7304,-20557,-22538,-14070,-3807,1949,4381,7269,10485,10811,7705,5302,8099,16042,24284,26848,20634,7614,-5928,-13509,-13422,-9659,-7260,-7179,-6627,-3827,-655,-131,-2762,-6451,-9103,-10030,-9226,-6797,-3505,-800,419,610,701,889,849,646,665,843,798,752,1496,3075,4206,3624,1648,-205,-963,-920,-706,-457,-170,-247,-1073,-2301,-3100,-3108,-2725,-2447,-2309,-2113,-1828,-1513,-1089,-508,-21,59,-156,-159,318,957,1271,1194,1043,1012,980,817,636,602,663,633,466,278,118,-106,-425,-697,-791,-791,-873,-1051,-1166,-1115,-976,-871,-814,-742,-629,-490,-328,-162,-65,-83,-134,-69,135,322,335,206,116,190,390,584,675,643,515,337,158,17,-85,-174,-267,-358,-439,-515,-591,-643,-639,-572,-477,-400,-359,-343,-331,-306,-255,-178,-99,-43,-7,32,76,93,61,7,-18,11,70,114,111,55,-44,-157,-246,-281,-265,-229,-200,-176,-143,-101,-65,-40,-13,17,30,1,-61,-125,-177,-223,-262,-276,-258,-227,-199,-165,-109,-33,45,103,131,135,136,156,190,204,178,133,104,96,78,27,-52,-142,-223,-273,-282,-274,-282,-308,-320,-290,-224,-151,-93,-63,-62,-78,-96,-107,-111,-100,-70,-39,-34,-54,-76,-87,-96,-86,-27,49,33,-142,-410,-634,-736,-721,-605,-401,-158,54,219,357,438,382,191}
        },
        {    // H-20e065a.wav
            {1,2,2,1,1,1,1,1,1,1,1,0,0,1,1,1,1,2,2,1,0,-1,0,1,3,4,3,2,2,2,1,2,5,6,2,-4,-3,4,7,3,3,10,8,-7,-12,9,25,38,186,644,1298,1614,1055,-257,-1453,-1689,-1002,-222,-29,-261,-256,305,1120,1734,2014,2069,1966,1750,1650,1963,2662,3276,3315,2738,1933,1273,805,337,-265,-893,-1260,-1130,-574,-11,75,-462,-1314,-1997,-2231,-2045,-1621,-1134,-723,-494,-472,-557,-594,-492,-278,-33,198,440,735,1063,1315,1368,1185,854,514,265,125,60,24,-24,-112,-254,-445,-656,-835,-939,-969,-967,-971,-969,-928,-851,-786,-768,-778,-764,-691,-565,-412,-252,-100,30,125,186,225,261,301,335,346,332,307,282,253,203,121,11,-105,-197,-246,-263,-285,-343,-429,-501,-526,-510,-479,-449,-416,-381,-355,-340,-320,-281,-231,-190,-162,-135,-98,-60,-30,-13,-3,4,6,5,9,17,19,9,-10,-32,-59,-95,-133,-165,-190,-212,-235,-252,-255,-242,-221,-205,-196,-182,-153,-114,-79,-54,-38,-28,-24,-23,-16,-1,12,11,4,3,7,6,0,-5,-7,-14,-28,-46,-70,-104,-142,-170,-178,-167,-146,-125,-116,-123,-137,-143,-139,-137,-139,-136,-121,-105,-94,-81,-65,-62,-80,-100,-106,-112,-135,-159,-162,-162,-192,-231,-209,-108},
            {-45,167,65,-223,-101,284,47,-256,2202,8782,14888,12353,-1379,-17988,-25128,-18711,-6220,2510,5184,6204,8530,10071,8365,5638,6984,14284,23442,27604,22585,9908,-4214,-13080,-14159,-10439,-6903,-5622,-4838,-2626,-43,240,-2544,-6445,-9215,-10200,-9677,-7703,-4542,-1425,244,355,0,14,290,496,645,708,441,56,453,2069,3858,4200,2767,828,-332,-591,-441,-63,492,688,-103,-1648,-2917,-3233,-2917,-2634,-2548,-2405,-2106,-1784,-1462,-1036,-590,-384,-431,-370,76,698,1060,1036,886,842,849,771,663,674,790,836,720,538,390,223,-53,-375,-583,-636,-664,-779,-935,-1020,-1016,-987,-961,-906,-809,-693,-565,-423,-304,-260,-251,-154,68,278,304,154,22,70,278,512,665,704,627,452,240,73,-13,-56,-114,-210,-329,-448,-550,-612,-611,-556,-483,-429,-405,-398,-388,-361,-307,-228,-143,-74,-23,20,55,66,39,-8,-37,-15,52,120,134,70,-48,-165,-242,-270,-259,-222,-177,-148,-139,-129,-96,-44,4,31,38,28,-2,-55,-126,-205,-276,-317,-316,-283,-233,-175,-109,-44,12,59,96,114,110,107,128,162,167,131,96,93,99,68,-6,-88,-152,-195,-221,-239,-264,-308,-350,-350,-293,-206,-127,-77,-62,-76,-102,-119,-123,-122,-110,-78,-40,-25,-39,-59,-67,-67,-57,-23,-3,-85,-297,-548,-705,-722,-633,-469,-243,-4,174,274,336,366,309,155}
        },
        {    // H-20e070a.wav
            {0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,-1,0,2,2,1,0,1,1,1,2,3,3,2,1,1,2,3,4,3,0,-2,0,5,7,6,5,2,-4,-7,4,20,28,67,250,651,1123,1275,771,-268,-1212,-1423,-861,-117,209,121,123,557,1197,1547,1418,1080,912,1070,1507,2142,2855,3389,3446,2953,2158,1417,898,525,171,-160,-354,-340,-218,-220,-537,-1144,-1795,-2196,-2207,-1900,-1470,-1107,-913,-888,-945,-941,-755,-364,124,542,784,877,937,1034,1113,1058,829,519,269,144,104,80,35,-40,-158,-330,-542,-750,-905,-982,-986,-947,-898,-859,-828,-798,-771,-751,-730,-688,-598,-454,-281,-124,-13,56,107,156,201,238,273,306,318,291,234,179,138,89,8,-98,-193,-255,-289,-315,-345,-377,-405,-423,-430,-425,-411,-391,-372,-359,-347,-327,-292,-248,-203,-161,-125,-100,-81,-60,-30,1,17,15,10,14,19,14,-2,-20,-40,-68,-106,-150,-192,-227,-251,-260,-252,-228,-197,-174,-167,-171,-174,-168,-150,-121,-86,-49,-24,-15,-16,-17,-17,-19,-21,-17,-11,-8,-8,-7,-5,-7,-13,-24,-43,-73,-107,-132,-142,-140,-126,-101,-78,-77,-101,-131,-152,-164,-168,-160,-139,-120,-114,-116,-117,-120,-126,-127,-118,-118,-139,-160,-162,-166,-203,-245,-219,-111},
            {65,139,-99,-228,130,304,-254,321,5044,12725,15762,6939,-10884,-24951,-24702,-12321,736,6423,6488,6634,8257,8506,6580,6315,11573,20768,27301,25187,14062,-555,-11408,-14606,-11761,-7501,-4872,-3364,-1297,954,1168,-1686,-5927,-9070,-10224,-9946,-8588,-6039,-2898,-634,-75,-467,-537,8,546,636,378,-38,-403,-161,1183,3101,4145,3453,1720,301,-243,-237,62,689,1307,1119,-185,-1865,-2908,-3083,-2892,-2731,-2564,-2296,-2023,-1806,-1540,-1194,-935,-844,-709,-293,295,712,802,733,706,721,694,663,730,876,956,893,766,664,548,326,23,-227,-364,-466,-617,-780,-866,-872,-870,-889,-891,-866,-845,-823,-746,-615,-514,-471,-377,-134,162,288,165,-36,-82,90,359,583,696,689,571,382,204,100,63,33,-38,-153,-286,-409,-499,-540,-528,-484,-444,-425,-425,-431,-426,-389,-308,-199,-107,-60,-38,-9,24,27,-12,-55,-49,14,92,131,98,2,-116,-209,-247,-232,-186,-137,-108,-106,-110,-95,-51,6,48,62,49,14,-33,-86,-151,-235,-317,-356,-328,-255,-179,-122,-75,-32,7,39,67,89,109,133,159,165,131,75,41,47,64,55,16,-36,-85,-128,-166,-213,-278,-350,-383,-347,-261,-172,-106,-67,-59,-81,-113,-128,-124,-115,-100,-71,-36,-21,-30,-47,-61,-72,-67,-44,-57,-181,-408,-622,-710,-666,-543,-358,-111,132,278,317,324,332,282,145}
        },
        {    // H-20e075a.wav
            {0,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,2,3,3,1,0,1,3,4,5,5,4,1,-2,0,5,8,5,0,0,6,12,20,52,149,346,621,855,857,478,-213,-870,-1049,-578,232,795,753,286,-97,-52,346,793,1094,1283,1502,1853,2349,2897,3298,3336,2963,2372,1845,1492,1180,719,97,-480,-788,-807,-751,-882,-1285,-1804,-2182,-2263,-2071,-1741,-1406,-1131,-911,-702,-451,-133,222,536,729,779,743,716,747,796,772,628,409,208,92,55,44,-4,-124,-311,-521,-701,-820,-876,-882,-857,-826,-806,-797,-780,-741,-691,-647,-606,-543,-441,-314,-193,-98,-25,39,96,142,177,206,232,246,232,187,122,55,-3,-57,-116,-184,-248,-289,-298,-286,-277,-290,-324,-359,-378,-377,-367,-357,-344,-323,-299,-277,-253,-215,-165,-117,-83,-59,-36,-18,-13,-23,-32,-27,-13,-1,0,-11,-35,-70,-109,-141,-164,-179,-191,-201,-208,-207,-196,-181,-171,-168,-170,-173,-176,-173,-155,-121,-81,-47,-21,-4,1,-5,-14,-18,-16,-11,-5,4,11,11,3,-6,-20,-45,-76,-98,-107,-109,-104,-88,-69,-66,-91,-131,-166,-186,-188,-173,-146,-124,-118,-123,-133,-145,-156,-155,-142,-138,-151,-163,-158,-158,-191,-227,-201,-101},
            {159,68,-231,-149,328,198,-439,1296,7805,15307,14608,894,-18229,-28135,-21725,-6246,5504,8313,6721,6316,7194,6881,6212,9080,16802,24990,26911,19437,5707,-7356,-14076,-13590,-9340,-5293,-2662,-361,2005,2784,355,-4389,-8631,-10461,-10210,-9026,-7256,-4817,-2354,-946,-777,-901,-502,209,564,333,-233,-781,-831,177,2172,3966,4164,2664,768,-279,-347,85,785,1600,1926,1128,-541,-2023,-2605,-2556,-2505,-2607,-2602,-2364,-2039,-1760,-1545,-1427,-1419,-1348,-962,-280,346,600,534,431,467,596,716,809,889,930,896,827,806,833,787,560,205,-108,-280,-375,-498,-654,-767,-797,-770,-733,-724,-771,-864,-931,-912,-837,-764,-664,-445,-125,118,131,-33,-167,-118,104,391,626,727,665,494,318,214,181,172,143,69,-59,-215,-349,-424,-445,-447,-451,-447,-425,-400,-396,-405,-389,-320,-220,-140,-95,-63,-26,-8,-35,-85,-99,-48,39,104,107,44,-59,-155,-206,-200,-154,-100,-61,-50,-63,-68,-37,27,83,97,71,28,-23,-83,-151,-220,-281,-320,-319,-273,-204,-143,-105,-79,-47,-3,43,77,92,105,126,145,129,74,18,4,28,55,67,66,50,8,-60,-136,-212,-295,-365,-374,-304,-199,-120,-86,-80,-88,-109,-128,-127,-109,-92,-81,-61,-35,-23,-35,-59,-81,-92,-81,-64,-101,-248,-466,-635,-675,-605,-469,-264,0,231,330,319,307,326,291,155}
        },
        {    // H-20e080a.wav
            {0,0,0,0,1,2,1,0,0,1,2,1,0,1,2,1,0,1,2,2,0,-1,1,2,1,-1,-1,0,1,1,0,0,0,-1,-2,1,6,8,5,-1,-3,-2,-2,-1,3,9,10,5,1,3,14,42,109,228,378,506,554,486,310,90,-68,-87,-5,26,-121,-390,-541,-356,159,780,1261,1516,1626,1728,1938,2326,2870,3405,3674,3490,2884,2071,1284,633,106,-337,-690,-914,-1010,-1075,-1258,-1636,-2116,-2470,-2490,-2134,-1540,-932,-480,-225,-99,7,155,327,455,497,479,468,518,616,688,650,487,264,75,-29,-69,-99,-167,-288,-442,-586,-681,-727,-753,-781,-799,-785,-745,-702,-664,-615,-554,-500,-464,-422,-346,-245,-152,-85,-32,23,77,120,147,157,148,117,70,18,-30,-69,-103,-137,-172,-201,-219,-231,-244,-256,-263,-269,-281,-299,-313,-314,-306,-297,-287,-270,-244,-213,-183,-155,-126,-95,-69,-58,-60,-65,-65,-59,-54,-53,-49,-41,-42,-61,-89,-111,-122,-130,-142,-158,-173,-183,-189,-194,-197,-199,-198,-196,-191,-182,-166,-145,-121,-93,-59,-24,1,12,14,14,13,11,11,14,18,16,6,-6,-17,-32,-51,-66,-75,-81,-85,-86,-89,-105,-136,-170,-195,-206,-196,-166,-130,-110,-111,-121,-131,-146,-167,-177,-168,-157,-160,-162,-147,-136,-158,-191,-173,-89},
            {216,-13,-335,-73,463,95,-507,2167,9778,16646,12958,-3801,-22806,-29054,-18609,-1925,8258,9134,6648,5732,5876,5601,6830,12394,20911,26567,24152,13576,-203,-10823,-14546,-12092,-7205,-3134,-358,2157,4102,3428,-878,-6731,-10649,-11141,-9540,-7714,-6111,-4353,-2660,-1700,-1421,-1025,-183,475,290,-526,-1228,-1300,-554,1025,2981,4215,3815,2090,342,-461,-346,269,1177,2074,2242,1182,-612,-2025,-2473,-2315,-2150,-2144,-2150,-2108,-2064,-1996,-1872,-1756,-1688,-1529,-1111,-507,12,268,323,335,392,509,674,845,946,933,846,790,830,917,910,715,389,90,-99,-232,-387,-553,-663,-697,-682,-649,-636,-696,-835,-969,-1012,-979,-927,-818,-572,-240,-33,-78,-249,-302,-137,151,421,599,660,597,448,306,247,264,289,257,153,2,-154,-278,-356,-388,-390,-379,-372,-375,-387,-405,-419,-408,-354,-271,-195,-147,-112,-79,-70,-109,-161,-158,-73,41,106,88,10,-88,-167,-198,-171,-104,-38,-5,-9,-20,-7,38,90,113,94,43,-23,-85,-136,-180,-234,-298,-339,-324,-258,-187,-142,-113,-76,-27,18,47,61,60,51,46,46,41,22,8,22,56,81,85,74,55,22,-30,-99,-179,-261,-317,-317,-265,-198,-148,-122,-115,-127,-145,-146,-123,-101,-99,-98,-76,-47,-39,-55,-73,-85,-98,-105,-112,-168,-318,-517,-648,-641,-532,-378,-179,59,254,320,292,282,313,289,156}
        },
        {    // H-20e085a.wav
            {0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,3,2,1,0,0,1,1,1,1,1,1,2,2,1,0,-1,-1,0,1,2,4,7,7,2,-2,0,3,1,-2,2,11,11,3,2,12,14,11,55,179,322,387,396,504,769,947,661,-155,-1050,-1405,-1018,-270,285,449,458,629,1020,1442,1711,1832,1973,2312,2879,3490,3820,3603,2841,1832,970,478,280,114,-235,-770,-1311,-1683,-1863,-1966,-2084,-2171,-2087,-1743,-1197,-615,-163,72,113,58,9,13,62,142,258,406,534,582,540,450,344,210,41,-116,-194,-188,-167,-206,-319,-464,-594,-684,-732,-741,-721,-685,-645,-603,-559,-513,-472,-439,-411,-377,-329,-268,-201,-134,-69,-13,25,41,39,27,11,-8,-26,-41,-59,-91,-139,-183,-200,-191,-184,-198,-223,-235,-226,-212,-208,-215,-222,-225,-225,-223,-219,-214,-211,-212,-209,-191,-156,-121,-101,-97,-96,-92,-90,-92,-87,-72,-56,-56,-75,-94,-101,-104,-115,-131,-144,-153,-169,-194,-219,-232,-230,-217,-201,-184,-163,-140,-119,-105,-92,-72,-47,-26,-9,12,38,58,59,45,27,9,-12,-31,-37,-31,-27,-35,-49,-59,-66,-82,-106,-134,-165,-196,-220,-230,-222,-194,-151,-111,-93,-97,-109,-122,-143,-171,-187,-178,-160,-150,-140,-120,-108,-130,-164,-153,-80},
            {258,-40,-391,-47,540,64,-572,2466,10563,17169,12147,-5947,-24771,-29208,-16905,193,9536,9524,6597,5218,4791,4727,7479,14749,23242,26629,21321,9363,-3610,-12226,-14101,-10576,-5290,-1180,1470,3717,5144,3624,-1657,-8114,-11851,-11480,-8917,-6628,-5260,-4203,-3241,-2621,-2107,-1126,127,627,-144,-1431,-2080,-1649,-334,1569,3521,4488,3705,1708,-11,-503,-41,717,1523,2201,2182,1058,-649,-1880,-2183,-2010,-1910,-1906,-1805,-1672,-1715,-1928,-2122,-2177,-2070,-1754,-1218,-632,-240,-104,-62,66,301,557,752,857,881,851,807,796,856,956,972,799,496,247,139,56,-141,-414,-607,-656,-627,-598,-593,-635,-755,-918,-1034,-1060,-1015,-899,-679,-406,-242,-283,-415,-416,-194,144,426,567,582,519,427,350,320,338,362,334,220,49,-109,-207,-255,-286,-308,-306,-289,-294,-342,-412,-462,-457,-394,-301,-215,-160,-134,-129,-151,-195,-227,-198,-99,21,95,87,9,-93,-167,-183,-144,-79,-15,30,48,48,52,80,118,131,98,34,-34,-90,-137,-189,-252,-315,-348,-325,-257,-180,-119,-73,-34,-6,6,4,-7,-21,-28,-16,6,12,-2,-5,27,78,110,116,112,102,70,9,-66,-143,-216,-268,-273,-235,-188,-161,-153,-155,-163,-172,-164,-135,-111,-111,-114,-93,-58,-39,-43,-56,-70,-88,-106,-129,-201,-357,-544,-649,-613,-482,-317,-120,102,266,299,252,245,292,283,156}
        },
        {    // H-20e090a.wav
            {0,0,0,0,1,2,2,2,1,0,0,1,2,2,1,0,1,2,2,2,2,3,2,0,-1,1,3,2,0,-1,1,2,-1,-3,-1,5,8,4,-1,-1,3,4,2,3,9,9,-1,-7,2,15,12,-5,-10,9,53,159,395,741,1003,929,466,-146,-589,-755,-762,-714,-539,-127,439,893,1040,959,930,1181,1717,2343,2807,2964,2852,2644,2489,2375,2163,1755,1213,703,342,93,-204,-706,-1425,-2158,-2582,-2488,-1969,-1351,-924,-725,-598,-407,-165,23,82,20,-100,-190,-171,-17,213,407,481,432,316,194,99,33,-20,-79,-150,-216,-256,-277,-321,-419,-551,-657,-692,-665,-615,-565,-513,-460,-424,-417,-419,-398,-348,-297,-267,-249,-216,-160,-98,-52,-32,-36,-55,-76,-90,-94,-95,-101,-119,-149,-184,-210,-221,-218,-207,-191,-173,-160,-151,-140,-124,-112,-119,-147,-178,-195,-195,-191,-192,-197,-200,-196,-187,-172,-148,-116,-86,-73,-76,-86,-91,-93,-103,-120,-128,-121,-112,-117,-138,-162,-181,-196,-209,-216,-215,-205,-189,-170,-150,-128,-104,-81,-64,-50,-37,-24,-14,-6,9,32,51,55,45,29,10,-15,-42,-59,-62,-59,-56,-55,-56,-67,-92,-125,-159,-194,-227,-249,-249,-230,-196,-151,-106,-79,-75,-82,-94,-117,-148,-167,-162,-145,-130,-111,-80,-63,-88,-134,-137,-75},
            {269,-3,-402,-104,553,154,-658,2007,10018,17148,12855,-5073,-24483,-29603,-17388,170,9928,9910,6649,4861,4140,4115,7383,15338,23955,26500,19918,7301,-5214,-12705,-13536,-9357,-3707,501,2864,4542,5478,3737,-1699,-8452,-12416,-11833,-8679,-5953,-4699,-4158,-3686,-3300,-2782,-1616,-80,586,-326,-1942,-2741,-2092,-395,1749,3737,4659,3805,1696,-98,-498,201,1140,1927,2438,2236,973,-808,-1991,-2100,-1693,-1481,-1545,-1594,-1563,-1613,-1781,-1960,-2094,-2166,-2045,-1613,-995,-498,-287,-252,-179,36,358,679,886,926,845,750,727,806,937,997,876,605,364,272,241,99,-173,-433,-572,-604,-594,-579,-600,-700,-859,-997,-1059,-1050,-963,-770,-531,-404,-465,-580,-533,-264,91,370,517,549,494,394,319,321,380,422,386,268,111,-33,-130,-182,-209,-226,-235,-241,-256,-301,-378,-455,-482,-433,-333,-240,-184,-161,-162,-195,-253,-285,-243,-131,-11,56,51,-12,-94,-152,-155,-112,-57,-13,14,32,46,70,115,165,182,139,52,-40,-109,-156,-198,-248,-295,-311,-282,-225,-172,-136,-108,-83,-68,-60,-49,-37,-39,-50,-48,-34,-34,-54,-52,6,93,155,180,189,185,140,48,-56,-140,-204,-247,-250,-212,-169,-162,-192,-223,-234,-221,-187,-145,-118,-119,-126,-110,-73,-38,-20,-18,-33,-62,-93,-132,-222,-388,-571,-661,-609,-467,-293,-93,120,264,275,216,206,257,257,144}
        },
        {    // H-20e095a.wav
            {0,0,0,0,0,0,1,2,1,0,0,1,2,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,2,1,-2,-2,2,6,3,-3,-2,4,5,-1,-1,10,18,9,-5,-4,4,0,-12,-8,8,12,56,277,721,1147,1131,481,-485,-1151,-1138,-597,4,308,289,149,123,347,785,1252,1560,1718,1926,2319,2735,2830,2438,1775,1258,1145,1368,1639,1670,1341,752,145,-290,-586,-957,-1540,-2179,-2514,-2283,-1550,-660,5,248,127,-127,-282,-255,-126,-33,-35,-84,-98,-40,67,175,239,228,143,23,-71,-105,-106,-131,-211,-321,-410,-444,-437,-432,-467,-537,-599,-604,-544,-452,-370,-319,-301,-309,-327,-328,-296,-246,-209,-194,-179,-143,-99,-76,-86,-113,-139,-160,-179,-188,-184,-182,-198,-228,-249,-249,-239,-225,-198,-150,-98,-72,-78,-97,-108,-109,-112,-120,-129,-137,-148,-166,-185,-197,-197,-186,-167,-139,-107,-86,-84,-100,-119,-130,-133,-140,-154,-170,-182,-191,-197,-197,-193,-190,-193,-196,-193,-182,-165,-146,-126,-105,-83,-58,-33,-15,-4,4,13,19,19,13,8,4,1,-4,-10,-19,-34,-51,-65,-76,-87,-99,-105,-104,-103,-109,-124,-152,-193,-235,-259,-258,-237,-203,-158,-109,-74,-60,-61,-69,-88,-115,-132,-126,-111,-101,-90,-67,-51,-70,-110,-116,-65},
            {230,99,-341,-240,459,356,-640,946,8077,16235,14766,-1103,-21532,-29945,-20150,-2256,9376,10445,6889,4564,3834,3814,6571,14028,22967,26465,20504,7721,-5239,-12814,-13313,-8677,-2634,1771,3934,5042,5529,3910,-1083,-7777,-12272,-12218,-9015,-5851,-4376,-4035,-3887,-3729,-3428,-2474,-893,179,-315,-1908,-3030,-2650,-930,1435,3676,4815,4080,1922,-13,-431,438,1542,2309,2699,2452,1206,-650,-2008,-2212,-1707,-1308,-1258,-1312,-1357,-1514,-1783,-1987,-2044,-2020,-1921,-1669,-1286,-932,-706,-539,-333,-75,195,454,676,817,856,823,777,780,853,925,877,682,477,393,378,262,6,-257,-409,-473,-519,-564,-608,-686,-812,-937,-1009,-1028,-989,-858,-658,-522,-551,-652,-612,-344,24,308,441,465,429,360,301,307,379,447,434,323,166,28,-64,-117,-151,-174,-189,-204,-230,-277,-346,-415,-445,-411,-332,-258,-214,-191,-182,-207,-266,-313,-286,-183,-63,12,15,-38,-112,-159,-151,-101,-47,-13,4,15,31,66,128,193,214,169,76,-22,-96,-137,-155,-181,-228,-273,-277,-236,-193,-177,-177,-164,-137,-108,-80,-54,-41,-48,-61,-67,-74,-83,-65,4,105,188,231,248,243,198,108,1,-99,-185,-247,-261,-229,-195,-199,-233,-265,-274,-258,-214,-155,-114,-113,-126,-112,-66,-17,14,26,16,-21,-74,-135,-231,-392,-572,-665,-612,-462,-286,-101,89,222,242,194,185,230,231,131}
        },
        {    // H-20e100a.wav
            {0,0,0,0,0,0,1,1,1,1,1,1,0,-1,0,1,2,2,1,0,0,-1,-1,0,1,1,-1,-3,-1,2,2,-2,-4,-1,3,2,-2,-1,3,2,-5,-5,5,12,8,3,7,9,-4,-19,-19,-14,-1,110,429,885,1147,874,90,-760,-1185,-1054,-606,-142,214,475,652,720,688,640,715,1057,1713,2500,3022,2940,2298,1523,1048,944,969,908,790,760,839,891,773,460,13,-498,-999,-1403,-1638,-1692,-1594,-1344,-908,-312,289,665,673,369,-27,-280,-283,-104,79,123,20,-117,-170,-119,-31,24,20,-37,-138,-264,-376,-443,-468,-482,-497,-499,-477,-454,-458,-489,-513,-494,-427,-334,-248,-195,-186,-208,-230,-221,-180,-133,-108,-111,-125,-136,-142,-147,-149,-152,-167,-205,-255,-293,-307,-306,-301,-287,-258,-221,-194,-182,-176,-165,-147,-127,-108,-92,-81,-75,-75,-82,-95,-114,-131,-138,-128,-109,-96,-97,-112,-130,-142,-144,-141,-139,-145,-163,-194,-229,-257,-271,-273,-263,-240,-210,-184,-169,-160,-150,-138,-124,-106,-82,-54,-29,-7,12,25,29,25,20,19,20,16,2,-21,-46,-64,-73,-78,-84,-91,-97,-103,-110,-117,-123,-129,-139,-151,-161,-174,-196,-222,-235,-228,-210,-190,-166,-134,-99,-72,-55,-47,-51,-66,-80,-82,-79,-82,-85,-76,-70,-89,-120,-116,-62},
            {125,253,-148,-390,185,549,-342,-195,4984,13729,16584,5368,-15051,-28715,-24524,-7676,7057,11082,7777,4396,3420,3624,5531,11387,20120,25773,22617,10918,-3111,-12406,-13801,-9001,-2303,2646,4871,5546,5607,4194,-42,-6319,-11390,-12439,-9831,-6406,-4393,-3817,-3727,-3751,-3866,-3558,-2333,-821,-381,-1425,-2803,-3055,-1741,588,3039,4608,4444,2643,559,-308,311,1539,2551,3089,2938,1772,-157,-1795,-2262,-1781,-1248,-1145,-1263,-1325,-1386,-1586,-1871,-2084,-2137,-1985,-1631,-1214,-957,-921,-925,-759,-408,-4,337,571,696,734,738,754,800,870,921,872,692,491,417,461,436,219,-88,-301,-376,-403,-455,-530,-624,-755,-902,-1008,-1039,-999,-890,-732,-599,-578,-645,-644,-448,-104,215,384,407,361,309,278,285,338,409,439,377,236,78,-32,-80,-101,-128,-168,-202,-220,-240,-288,-357,-397,-369,-293,-230,-206,-201,-196,-211,-266,-324,-324,-246,-135,-49,-21,-59,-139,-208,-210,-142,-51,14,39,36,26,38,93,174,226,208,133,42,-33,-83,-114,-147,-202,-268,-299,-273,-218,-184,-180,-183,-178,-167,-145,-112,-78,-60,-54,-45,-38,-44,-46,-7,73,157,218,260,286,273,202,90,-37,-163,-268,-317,-300,-257,-240,-255,-273,-277,-266,-231,-172,-116,-98,-107,-96,-47,11,45,50,32,-4,-51,-108,-202,-362,-546,-652,-619,-485,-319,-141,38,162,184,149,157,216,226,128}
        },
        {    // H-20e105a.wav
            {3,4,3,2,3,5,5,4,3,3,4,4,4,3,3,3,4,4,4,4,5,5,5,6,6,5,3,3,6,7,4,3,5,7,4,1,4,10,9,2,0,5,9,9,12,18,15,3,1,5,-10,0,193,662,1186,1274,619,-500,-1376,-1496,-949,-233,252,449,501,533,597,726,940,1241,1628,2093,2552,2822,2729,2260,1573,885,378,170,272,520,641,478,142,-108,-135,-41,-24,-197,-540,-954,-1283,-1362,-1131,-724,-367,-154,28,320,684,917,862,559,191,-65,-133,-60,27,6,-136,-285,-316,-224,-125,-124,-230,-386,-547,-681,-742,-698,-584,-488,-470,-505,-529,-512,-466,-408,-341,-267,-198,-140,-85,-33,-3,-10,-41,-67,-77,-81,-87,-90,-89,-97,-128,-172,-212,-244,-282,-329,-365,-368,-337,-296,-269,-260,-262,-265,-262,-248,-217,-172,-126,-93,-75,-65,-60,-56,-46,-25,1,12,-3,-32,-58,-77,-95,-115,-130,-140,-152,-175,-206,-238,-266,-289,-303,-304,-290,-268,-242,-212,-178,-143,-111,-86,-68,-52,-35,-19,-7,2,14,29,40,41,37,36,37,32,18,-5,-34,-67,-98,-120,-131,-130,-121,-109,-105,-113,-126,-134,-138,-147,-162,-176,-184,-187,-188,-183,-173,-165,-163,-157,-138,-107,-72,-40,-15,-6,-14,-26,-33,-43,-64,-83,-87,-90,-112,-138,-126,-65},
            {-63,326,140,-400,-214,515,216,-684,1669,9267,16151,12138,-4891,-23266,-27886,-15823,1333,10567,9586,5080,2774,2969,4519,8525,15877,23241,24395,16161,2081,-10129,-14535,-10809,-3301,2985,5853,6243,5799,4549,1233,-4295,-9760,-12184,-10767,-7501,-4901,-3769,-3446,-3440,-3839,-4345,-4042,-2617,-1131,-914,-1959,-2920,-2551,-711,1812,3893,4543,3495,1604,282,277,1203,2289,3113,3402,2718,959,-1064,-2172,-2012,-1320,-961,-1090,-1351,-1510,-1613,-1748,-1917,-2068,-2098,-1882,-1447,-1035,-863,-892,-902,-756,-472,-108,290,623,776,745,658,657,772,919,965,830,579,391,376,437,383,161,-97,-258,-323,-369,-436,-528,-653,-810,-959,-1046,-1045,-951,-784,-616,-554,-620,-683,-570,-251,116,351,402,341,260,205,196,244,335,411,406,301,143,9,-63,-86,-103,-139,-181,-205,-208,-219,-259,-309,-320,-277,-219,-191,-192,-197,-207,-250,-319,-357,-323,-231,-135,-81,-87,-145,-214,-236,-191,-109,-37,8,35,48,56,87,155,224,240,186,97,12,-53,-102,-145,-193,-250,-291,-286,-240,-196,-183,-195,-209,-210,-191,-152,-105,-70,-46,-20,0,-5,-26,-18,41,120,182,228,272,295,260,165,38,-101,-238,-342,-375,-345,-303,-285,-283,-275,-255,-223,-175,-123,-90,-81,-73,-44,1,44,65,56,18,-31,-81,-159,-306,-496,-630,-631,-523,-372,-210,-45,78,117,109,134,195,203,114}
        },
        {    // H-20e110a.wav
            {-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,-1,-2,-3,-3,-2,-1,-1,-2,-3,-2,-1,-2,-3,-2,0,0,-3,-4,-1,0,-4,-7,-3,2,2,-2,-3,-3,-5,-4,5,9,-3,-11,5,14,-8,44,372,982,1465,1256,217,-1104,-1895,-1764,-975,-81,536,802,819,728,660,703,899,1293,1930,2722,3348,3410,2771,1719,750,200,77,172,257,207,27,-181,-315,-376,-455,-605,-752,-764,-611,-417,-351,-470,-669,-771,-649,-317,83,383,530,622,792,1039,1195,1085,706,239,-108,-255,-258,-219,-207,-244,-317,-400,-478,-558,-651,-743,-803,-819,-807,-780,-729,-651,-575,-540,-545,-538,-473,-348,-201,-69,33,98,120,102,61,22,3,3,11,17,13,-10,-58,-129,-204,-260,-289,-299,-307,-325,-357,-395,-425,-435,-422,-396,-365,-331,-295,-262,-240,-223,-195,-145,-79,-19,21,41,51,57,55,44,23,-5,-41,-81,-118,-148,-174,-203,-237,-268,-291,-304,-317,-327,-325,-305,-271,-234,-200,-167,-131,-93,-59,-34,-15,-2,-2,-15,-28,-23,-2,17,22,21,26,31,20,-12,-54,-95,-128,-149,-157,-153,-143,-134,-130,-134,-147,-163,-172,-171,-164,-157,-156,-164,-180,-191,-188,-177,-170,-170,-160,-133,-98,-68,-44,-23,-11,-14,-22,-26,-38,-69,-108,-134,-149,-170,-184,-153,-75},
            {-213,195,339,-152,-467,114,579,-240,-399,3955,12058,15612,6521,-12045,-25964,-23848,-8704,6099,10963,7528,3093,1768,3007,5985,11464,18813,23721,21027,9961,-4088,-13358,-13551,-6598,1695,6604,7472,6433,5004,2562,-1902,-7407,-11205,-11415,-8846,-5907,-4154,-3429,-3130,-3336,-4238,-5107,-4769,-3115,-1464,-1116,-1931,-2596,-1974,12,2477,4158,4185,2766,1130,480,986,1978,2863,3421,3350,2243,298,-1449,-2047,-1589,-963,-808,-1073,-1425,-1695,-1869,-1959,-2005,-2041,-1990,-1742,-1363,-1072,-966,-916,-792,-622,-456,-223,148,547,776,781,695,678,765,875,889,753,539,394,378,393,309,118,-78,-206,-280,-348,-433,-547,-688,-835,-955,-1028,-1027,-913,-711,-543,-533,-635,-652,-442,-79,238,379,360,264,158,89,104,209,344,412,358,214,62,-40,-87,-104,-113,-122,-132,-146,-167,-200,-244,-275,-265,-217,-171,-163,-188,-226,-273,-333,-382,-382,-322,-233,-155,-121,-147,-217,-275,-263,-183,-91,-26,21,64,95,112,138,185,219,195,118,34,-21,-54,-91,-152,-233,-304,-327,-294,-235,-189,-171,-173,-188,-201,-190,-146,-95,-63,-44,-17,6,4,-6,15,79,148,191,214,233,235,196,112,-9,-154,-296,-395,-424,-396,-343,-288,-246,-221,-203,-172,-129,-96,-88,-90,-75,-34,20,65,78,45,-13,-65,-119,-230,-413,-587,-652,-589,-456,-301,-140,-4,63,73,89,133,145,84}
        },
        {    // H-20e115a.wav
            {3,3,2,1,2,3,4,3,2,2,3,4,3,2,2,2,1,2,3,3,2,2,3,4,3,3,5,6,4,4,5,4,1,1,4,5,3,5,9,5,-4,1,18,17,-7,-12,16,20,-2,144,680,1438,1769,1092,-419,-1853,-2345,-1787,-748,159,706,961,1027,971,888,908,1150,1683,2471,3283,3722,3477,2596,1469,521,-57,-303,-316,-192,-58,-67,-284,-625,-928,-1086,-1096,-1024,-945,-896,-844,-703,-426,-101,83,23,-171,-253,-68,325,746,1058,1232,1299,1289,1218,1077,832,470,64,-245,-363,-339,-314,-390,-558,-744,-885,-959,-965,-917,-854,-823,-843,-885,-894,-834,-716,-576,-447,-337,-237,-134,-20,93,176,206,188,159,153,172,189,184,153,101,29,-48,-103,-124,-139,-187,-274,-363,-422,-455,-479,-492,-482,-458,-442,-441,-437,-410,-363,-308,-247,-178,-108,-50,-9,26,65,101,119,117,106,90,59,1,-74,-138,-174,-190,-202,-219,-238,-258,-280,-296,-296,-278,-249,-221,-193,-160,-125,-97,-77,-58,-39,-22,-11,-6,-5,-7,-8,-2,9,21,29,26,7,-26,-66,-101,-123,-132,-132,-128,-128,-134,-140,-140,-133,-122,-111,-106,-111,-127,-147,-161,-168,-174,-177,-169,-152,-140,-138,-136,-121,-94,-65,-40,-18,0,8,5,-9,-38,-82,-126,-154,-170,-182,-180,-139,-65},
            {-166,-96,214,204,-253,-336,289,433,-463,198,5558,13054,13909,2352,-15491,-25543,-19809,-4325,7984,10277,5896,1698,940,3111,7434,13699,20099,22504,17379,5562,-7163,-13807,-11352,-2896,5244,8795,8103,5929,3663,448,-4363,-9172,-11355,-10101,-7189,-4897,-3851,-3317,-2969,-3388,-4747,-5911,-5520,-3641,-1764,-1157,-1657,-2082,-1410,477,2747,4122,3815,2296,954,786,1606,2624,3364,3667,3213,1743,-235,-1594,-1701,-1038,-547,-638,-1084,-1548,-1890,-2077,-2115,-2087,-2054,-1940,-1659,-1321,-1130,-1097,-1030,-822,-571,-380,-187,106,452,696,770,746,735,779,823,787,661,529,478,483,430,264,55,-99,-176,-223,-289,-393,-542,-712,-856,-944,-979,-953,-836,-651,-514,-522,-611,-592,-359,-10,265,361,312,206,104,48,78,195,324,366,285,141,23,-32,-42,-40,-41,-59,-92,-126,-148,-169,-203,-236,-232,-196,-170,-186,-228,-270,-311,-359,-394,-385,-326,-245,-182,-168,-206,-261,-275,-218,-122,-35,25,65,87,89,93,130,191,223,191,112,29,-30,-68,-105,-165,-250,-323,-336,-279,-194,-133,-114,-128,-155,-175,-171,-143,-107,-73,-36,2,25,26,29,58,106,147,173,193,205,195,148,63,-56,-193,-317,-395,-413,-380,-315,-242,-184,-152,-136,-125,-116,-113,-108,-88,-51,-1,52,88,81,32,-25,-77,-161,-316,-503,-627,-624,-515,-359,-206,-91,-29,3,50,112,132,77}
        },
        {    // H-20e120a.wav
            {0,1,1,1,1,1,1,1,1,1,0,-1,0,1,0,-1,-1,1,1,0,0,0,-1,0,2,3,1,2,5,5,-1,-4,1,4,-2,-6,4,12,1,-12,0,22,12,-16,-6,27,6,5,320,1111,1938,1934,658,-1281,-2654,-2698,-1670,-396,523,988,1141,1112,1014,990,1167,1619,2371,3315,4086,4184,3373,1971,632,-168,-411,-361,-252,-199,-272,-507,-835,-1105,-1236,-1292,-1371,-1455,-1433,-1242,-947,-666,-458,-300,-140,47,230,339,337,298,387,704,1155,1509,1602,1459,1228,1022,864,725,567,346,40,-309,-610,-799,-898,-967,-1026,-1052,-1037,-1019,-1031,-1058,-1061,-1024,-959,-868,-740,-577,-416,-294,-212,-139,-51,53,159,253,323,358,354,321,278,236,199,168,140,101,33,-68,-186,-298,-385,-437,-455,-454,-458,-484,-527,-565,-578,-560,-518,-459,-391,-324,-263,-207,-151,-94,-37,22,83,136,159,138,84,27,-11,-32,-50,-76,-114,-161,-207,-239,-245,-231,-213,-203,-199,-195,-190,-187,-185,-180,-169,-152,-130,-101,-68,-41,-27,-24,-20,-11,-3,-2,-7,-13,-22,-40,-67,-100,-126,-141,-149,-154,-154,-145,-133,-122,-109,-90,-68,-52,-48,-55,-75,-111,-158,-200,-222,-221,-200,-169,-141,-126,-124,-127,-129,-127,-115,-84,-40,-5,5,-6,-31,-69,-117,-157,-173,-172,-172,-166,-129,-61},
            {55,-212,-132,237,209,-269,-296,331,358,-491,561,6126,12904,12442,437,-16067,-23972,-17200,-2503,8251,9517,4834,610,97,3096,8484,14961,20117,20630,14500,3339,-7641,-12590,-9175,-525,7240,10005,8298,5159,2205,-1298,-5872,-9852,-10895,-8837,-5945,-4301,-3856,-3474,-3031,-3485,-5065,-6441,-6144,-4265,-2249,-1288,-1333,-1476,-842,799,2787,3912,3441,1964,910,1108,2130,3120,3710,3829,3158,1491,-526,-1686,-1470,-579,-82,-352,-1030,-1665,-2074,-2237,-2219,-2152,-2108,-1988,-1693,-1343,-1166,-1177,-1154,-949,-647,-385,-155,121,420,632,711,722,745,793,808,739,614,530,541,577,506,292,41,-128,-191,-210,-248,-343,-502,-691,-843,-914,-913,-862,-756,-617,-531,-564,-644,-599,-350,-5,252,330,272,161,58,11,55,182,310,350,277,148,44,-1,-1,10,9,-14,-51,-92,-132,-176,-223,-252,-246,-217,-199,-213,-250,-299,-357,-417,-454,-444,-378,-279,-189,-147,-164,-207,-219,-174,-97,-33,5,31,50,67,98,154,213,226,168,68,-18,-60,-68,-80,-126,-206,-281,-304,-263,-193,-141,-122,-128,-139,-145,-143,-133,-119,-98,-65,-22,15,36,52,79,119,157,178,182,170,137,78,-7,-111,-224,-322,-378,-374,-320,-246,-180,-134,-111,-111,-127,-143,-144,-128,-102,-63,-4,57,83,56,3,-44,-102,-219,-399,-572,-645,-587,-444,-291,-180,-118,-72,-9,60,89,56}
        },
        {    // H-20e125a.wav
            {1,0,1,2,2,1,1,1,1,0,1,2,1,0,0,2,2,1,0,1,2,1,1,4,4,2,3,7,6,0,0,6,5,-4,-3,12,14,-7,-15,11,29,1,-23,14,44,-2,78,662,1717,2433,1820,-179,-2388,-3391,-2779,-1296,71,895,1273,1378,1284,1111,1083,1410,2175,3283,4386,4917,4416,2969,1231,-85,-717,-849,-741,-522,-305,-279,-559,-1031,-1456,-1709,-1832,-1875,-1803,-1592,-1318,-1073,-841,-549,-218,17,77,59,132,357,657,923,1103,1191,1207,1202,1226,1265,1238,1111,948,838,769,626,320,-118,-568,-919,-1118,-1176,-1151,-1122,-1138,-1183,-1206,-1179,-1112,-1024,-920,-806,-698,-603,-501,-368,-213,-72,32,113,201,299,380,421,428,423,414,388,335,260,168,59,-62,-170,-241,-277,-306,-353,-417,-481,-535,-577,-603,-604,-582,-549,-513,-470,-415,-353,-298,-246,-178,-87,3,58,70,60,52,50,45,32,14,-9,-37,-71,-102,-123,-136,-146,-148,-139,-127,-125,-137,-158,-179,-194,-203,-204,-196,-178,-153,-124,-96,-68,-39,-15,-3,-4,-11,-22,-41,-69,-96,-114,-126,-140,-159,-175,-180,-173,-153,-121,-83,-45,-14,9,23,24,11,-17,-61,-118,-179,-227,-251,-249,-225,-187,-149,-125,-119,-123,-132,-140,-136,-110,-70,-40,-36,-48,-62,-79,-104,-126,-129,-122,-126,-135,-115,-58},
            {110,-4,-184,-74,227,165,-254,-251,308,311,-443,573,5718,11999,11688,735,-14557,-22151,-16189,-2609,7592,8885,4232,-196,-737,2762,8774,15184,19379,18869,12754,2878,-6417,-10401,-7125,765,7829,10170,8103,4489,1112,-2432,-6550,-9811,-10239,-7905,-5112,-3847,-3888,-3864,-3464,-3677,-5011,-6430,-6484,-4970,-2991,-1649,-1129,-880,-239,1081,2667,3547,3074,1776,968,1381,2519,3485,3928,3878,3134,1519,-405,-1533,-1343,-450,124,-68,-779,-1577,-2164,-2407,-2354,-2220,-2151,-2057,-1799,-1461,-1257,-1220,-1162,-961,-695,-467,-243,47,361,587,685,718,759,817,837,765,625,521,534,610,596,410,127,-111,-230,-254,-259,-309,-432,-597,-740,-822,-849,-827,-751,-649,-600,-640,-686,-605,-358,-48,187,279,247,147,51,23,89,215,324,352,293,189,97,52,50,57,39,-9,-67,-111,-145,-187,-238,-269,-260,-234,-236,-282,-342,-392,-430,-458,-458,-410,-323,-230,-158,-127,-141,-179,-196,-163,-97,-37,4,32,50,57,71,118,182,207,164,81,14,-15,-28,-54,-107,-181,-249,-280,-258,-202,-152,-128,-127,-134,-139,-137,-131,-124,-107,-69,-14,31,50,62,93,139,173,181,171,148,100,23,-68,-160,-247,-318,-345,-307,-224,-144,-97,-84,-98,-131,-167,-183,-173,-148,-118,-73,-10,48,66,38,-11,-66,-148,-288,-468,-607,-622,-512,-359,-250,-200,-160,-88,-4,42,33}
        },
        {    // H-20e130a.wav
            {0,1,2,0,-1,1,3,1,-1,0,1,0,-2,0,2,1,-1,0,1,-1,-2,1,4,1,-1,3,6,0,-4,4,11,0,-12,0,20,9,-20,-13,26,27,-20,-24,38,41,-11,266,1240,2489,2783,1246,-1495,-3659,-3926,-2521,-683,625,1275,1539,1573,1427,1270,1381,1969,3050,4367,5350,5342,4109,2152,363,-684,-1037,-1033,-890,-691,-578,-712,-1061,-1409,-1622,-1781,-1998,-2201,-2214,-1987,-1626,-1232,-815,-406,-111,9,44,134,296,456,624,902,1284,1568,1555,1282,978,816,801,872,984,1069,1014,772,437,142,-100,-373,-705,-1005,-1177,-1231,-1243,-1248,-1233,-1197,-1162,-1124,-1049,-925,-787,-668,-558,-430,-278,-127,0,96,167,225,287,369,468,547,561,489,358,220,116,53,11,-36,-97,-170,-253,-338,-413,-466,-502,-538,-578,-607,-603,-567,-518,-477,-445,-407,-352,-285,-221,-168,-121,-77,-40,-14,4,21,32,28,8,-16,-31,-37,-36,-31,-25,-29,-49,-80,-108,-127,-140,-153,-166,-175,-182,-192,-201,-199,-180,-153,-127,-102,-74,-45,-25,-25,-42,-63,-83,-104,-131,-158,-179,-191,-193,-184,-164,-138,-114,-90,-61,-25,14,50,76,87,79,51,1,-71,-155,-231,-278,-289,-272,-239,-201,-165,-141,-131,-134,-144,-155,-156,-142,-118,-99,-88,-77,-64,-60,-71,-81,-75,-69,-87,-114,-108,-57},
            {-56,110,74,-146,-140,150,195,-169,-274,196,329,-323,253,4511,10519,11482,2712,-11414,-20038,-16351,-4267,6094,8297,4046,-658,-1491,2054,8138,14314,18151,17668,12273,3656,-4407,-7869,-5109,1593,7585,9465,7385,3813,487,-2759,-6348,-9236,-9697,-7567,-4792,-3437,-3671,-4178,-4160,-4173,-4936,-6045,-6360,-5372,-3694,-2240,-1344,-705,139,1360,2616,3206,2722,1653,1076,1582,2729,3683,4067,3918,3160,1689,-65,-1188,-1166,-430,137,43,-595,-1410,-2089,-2448,-2478,-2350,-2233,-2114,-1903,-1635,-1437,-1316,-1143,-878,-630,-477,-336,-97,204,448,589,687,801,914,958,871,672,477,421,510,595,522,285,15,-171,-255,-293,-339,-419,-529,-642,-731,-789,-808,-778,-715,-674,-694,-724,-656,-433,-127,127,246,235,157,81,61,125,249,369,418,369,251,128,50,28,30,12,-41,-102,-141,-162,-196,-257,-315,-339,-336,-342,-368,-392,-400,-402,-408,-405,-374,-318,-252,-190,-148,-135,-147,-153,-128,-81,-45,-26,-13,2,18,47,106,180,224,201,125,39,-26,-65,-93,-127,-175,-222,-243,-227,-192,-167,-162,-167,-171,-168,-152,-123,-92,-65,-35,-4,16,22,32,71,132,181,195,174,128,58,-30,-120,-202,-271,-314,-306,-243,-154,-81,-50,-65,-115,-180,-230,-239,-213,-176,-138,-89,-27,23,30,-5,-55,-111,-200,-349,-518,-612,-570,-438,-322,-277,-258,-199,-101,-21,6}
        },
        {    // H-20e135a.wav
            {1,2,1,-1,0,1,0,-1,-1,-1,-2,-2,0,2,0,-1,0,0,-2,-1,3,3,-1,0,6,4,-6,-5,11,14,-7,-17,6,23,-3,-28,1,40,13,-35,2,65,10,33,689,2108,3279,2698,20,-3200,-4806,-4011,-1863,86,1159,1600,1775,1761,1594,1533,1931,2945,4369,5636,6014,5064,3072,931,-534,-1134,-1201,-1076,-882,-709,-750,-1113,-1626,-1994,-2116,-2138,-2204,-2276,-2232,-2038,-1750,-1398,-976,-524,-142,101,227,297,376,546,868,1274,1558,1566,1373,1184,1079,958,752,574,572,710,795,694,443,149,-117,-318,-428,-477,-566,-767,-1036,-1260,-1371,-1377,-1300,-1152,-971,-825,-744,-680,-569,-408,-256,-158,-93,-7,123,270,384,437,431,391,342,304,285,279,259,195,80,-55,-163,-224,-252,-279,-323,-387,-457,-514,-544,-552,-549,-534,-497,-438,-384,-360,-363,-363,-335,-277,-205,-134,-79,-50,-47,-55,-58,-47,-23,8,36,50,43,19,-11,-42,-73,-98,-110,-111,-111,-120,-136,-150,-162,-174,-185,-187,-174,-152,-129,-111,-96,-84,-77,-79,-93,-118,-147,-173,-188,-189,-180,-168,-161,-157,-150,-129,-99,-68,-36,1,41,74,96,108,108,85,33,-41,-125,-208,-276,-315,-317,-289,-248,-208,-181,-168,-164,-160,-157,-160,-170,-174,-160,-131,-97,-63,-36,-27,-38,-51,-50,-45,-59,-84,-84,-46},
            {-60,-52,62,74,-88,-142,71,192,-64,-263,53,323,-138,-92,2923,8466,11167,5487,-6986,-17128,-16771,-6908,3685,7399,4130,-645,-1998,1078,6736,12561,16485,16798,12706,5363,-1962,-5473,-3451,2246,7425,8824,6430,2682,-367,-2715,-5286,-7884,-9004,-7722,-5115,-3296,-3252,-4148,-4733,-4831,-5094,-5699,-5969,-5297,-3944,-2663,-1809,-1096,-87,1279,2581,3185,2772,1764,1122,1510,2666,3760,4220,4007,3226,1913,354,-782,-972,-407,170,164,-456,-1328,-2066,-2461,-2530,-2443,-2337,-2197,-1957,-1678,-1493,-1401,-1246,-948,-619,-396,-255,-80,155,373,525,644,774,900,965,920,758,551,425,444,527,517,349,109,-82,-183,-244,-322,-426,-534,-630,-707,-761,-779,-752,-700,-675,-709,-756,-710,-508,-208,61,207,231,200,174,189,257,355,431,430,344,215,100,28,-3,-15,-29,-64,-119,-176,-224,-273,-330,-377,-382,-344,-304,-300,-331,-373,-408,-428,-424,-387,-323,-246,-172,-120,-108,-129,-142,-119,-72,-38,-27,-14,15,46,74,115,172,207,178,92,-1,-58,-78,-86,-105,-139,-176,-201,-204,-189,-172,-163,-164,-168,-162,-134,-92,-59,-45,-37,-18,5,20,36,80,148,201,206,167,110,41,-46,-146,-235,-288,-297,-261,-192,-114,-60,-51,-84,-143,-203,-240,-241,-213,-177,-142,-100,-52,-20,-25,-57,-90,-128,-215,-367,-523,-584,-519,-404,-330,-306,-272,-189,-87,-20}
        },
        {    // H-20e140a.wav
            {2,0,0,2,1,-1,-1,1,0,-3,-2,2,3,1,0,0,-2,-3,2,7,3,-2,2,8,0,-9,1,16,6,-16,-7,23,17,-25,-26,28,41,-21,-34,56,74,-30,243,1478,3225,3798,1832,-1950,-5046,-5462,-3446,-841,879,1585,1841,1961,1928,1848,2087,2965,4415,5905,6631,5973,4011,1590,-290,-1210,-1429,-1357,-1149,-862,-727,-1005,-1618,-2168,-2379,-2376,-2433,-2583,-2617,-2398,-2029,-1660,-1291,-859,-418,-104,45,133,276,510,839,1251,1641,1827,1715,1417,1120,898,730,635,663,738,663,358,-8,-203,-198,-153,-188,-274,-352,-443,-593,-781,-940,-1042,-1100,-1113,-1061,-943,-797,-661,-549,-450,-346,-223,-82,52,147,184,186,193,228,282,326,335,308,259,200,132,53,-24,-85,-132,-179,-234,-291,-342,-385,-419,-442,-453,-450,-429,-400,-383,-394,-421,-429,-398,-336,-270,-215,-177,-159,-161,-168,-154,-109,-49,0,30,46,49,27,-15,-59,-83,-84,-74,-67,-69,-80,-99,-123,-141,-144,-138,-134,-133,-130,-122,-118,-123,-132,-139,-143,-146,-150,-153,-154,-155,-155,-156,-160,-162,-157,-144,-129,-112,-88,-55,-23,2,22,45,70,88,96,97,85,50,-12,-92,-177,-254,-309,-331,-321,-290,-255,-224,-203,-191,-181,-168,-157,-158,-166,-158,-126,-86,-56,-36,-16,-3,-7,-20,-24,-23,-36,-62,-69,-40},
            {51,-42,-89,15,104,-4,-140,-30,167,60,-208,-98,258,84,-256,1370,5958,10104,8010,-1781,-12885,-16405,-9897,285,5807,4250,-177,-2174,22,4872,10161,14254,15736,13468,7750,1067,-2998,-2227,2388,7192,8639,6034,1704,-1548,-3054,-4205,-6074,-7799,-7724,-5708,-3557,-3028,-4012,-5074,-5362,-5294,-5459,-5605,-5099,-3938,-2775,-2047,-1509,-661,640,2055,3012,3072,2327,1509,1469,2368,3519,4123,3959,3260,2214,934,-217,-720,-451,71,172,-365,-1231,-1995,-2440,-2583,-2540,-2409,-2215,-1964,-1712,-1543,-1453,-1315,-1033,-672,-370,-170,6,225,462,653,766,803,792,765,741,696,614,541,539,574,523,319,43,-159,-231,-242,-277,-364,-479,-594,-689,-749,-765,-743,-705,-684,-703,-736,-703,-534,-246,50,245,313,308,290,285,301,337,372,366,295,175,54,-33,-79,-98,-104,-115,-147,-196,-245,-282,-312,-336,-342,-324,-300,-301,-336,-382,-415,-427,-420,-390,-331,-249,-164,-102,-81,-95,-110,-96,-53,-10,17,32,42,43,38,49,87,125,121,68,1,-43,-60,-66,-76,-100,-138,-175,-189,-174,-146,-132,-138,-150,-149,-128,-95,-66,-49,-39,-19,14,50,83,118,159,189,186,145,81,5,-81,-170,-245,-286,-283,-242,-184,-128,-90,-77,-90,-131,-189,-235,-241,-211,-172,-142,-112,-81,-69,-91,-122,-129,-134,-202,-353,-508,-564,-501,-399,-338,-311,-260,-161,-57}
        },
        {    // H-20e145a.wav
            {-1,2,3,-1,-4,-1,1,-2,-4,-2,1,-1,-2,-1,-1,-4,-2,5,6,-2,-2,7,6,-9,-11,11,19,-7,-23,7,32,-2,-40,-4,50,13,-53,4,105,29,12,831,2712,4308,3539,-95,-4449,-6524,-5262,-2222,343,1529,1856,2008,2118,2137,2333,3130,4609,6266,7238,6803,4904,2297,66,-1167,-1554,-1577,-1466,-1201,-917,-979,-1549,-2284,-2673,-2615,-2470,-2552,-2767,-2814,-2583,-2194,-1743,-1207,-615,-135,98,146,178,299,553,985,1554,2014,2084,1757,1329,1064,940,801,625,519,496,425,212,-86,-360,-565,-695,-725,-658,-568,-542,-588,-655,-707,-733,-714,-643,-575,-588,-671,-697,-548,-253,36,185,180,101,42,46,106,190,264,303,288,220,131,59,15,-23,-78,-144,-198,-226,-235,-240,-262,-310,-368,-400,-391,-365,-358,-374,-387,-386,-380,-372,-344,-286,-224,-193,-194,-201,-192,-167,-135,-97,-53,-16,-1,-8,-32,-69,-109,-136,-135,-109,-77,-56,-54,-71,-98,-123,-133,-127,-114,-103,-96,-95,-104,-125,-150,-168,-176,-181,-184,-177,-159,-139,-128,-129,-134,-133,-127,-120,-111,-98,-84,-74,-65,-50,-26,3,30,53,72,81,77,61,35,0,-43,-94,-150,-211,-271,-316,-334,-323,-301,-279,-258,-235,-212,-187,-160,-138,-126,-114,-89,-55,-31,-24,-17,0,13,6,-7,-8,-13,-49,-102,-115,-66},
            {-14,49,25,-66,-56,58,65,-78,-109,72,143,-82,-199,84,229,-144,264,3321,7951,9256,3302,-7236,-14268,-12229,-3835,3125,3911,547,-1914,-820,2941,7433,11450,14020,13821,10204,4569,22,-777,2261,6427,8213,6063,1555,-2210,-3588,-3663,-4455,-6248,-7323,-6334,-4194,-3039,-3720,-5084,-5701,-5499,-5296,-5340,-5043,-4048,-2825,-2007,-1587,-1054,-72,1225,2409,3011,2805,2115,1729,2194,3198,3901,3829,3182,2325,1361,372,-296,-344,-12,74,-428,-1274,-1989,-2349,-2439,-2420,-2366,-2276,-2121,-1895,-1645,-1435,-1262,-1042,-721,-359,-61,145,318,515,712,843,874,834,783,748,694,584,461,413,454,475,354,101,-158,-320,-385,-405,-416,-432,-474,-561,-677,-778,-824,-804,-735,-654,-586,-512,-380,-163,85,268,337,324,291,272,265,261,254,232,181,102,17,-53,-104,-139,-155,-155,-154,-168,-194,-227,-269,-322,-367,-378,-361,-349,-363,-386,-390,-375,-357,-342,-313,-259,-186,-117,-70,-47,-38,-31,-21,-15,-17,-21,-20,-14,-6,10,41,77,90,65,16,-29,-54,-58,-54,-58,-88,-135,-172,-175,-151,-127,-123,-133,-137,-125,-99,-66,-36,-15,4,29,60,89,116,144,165,158,112,32,-58,-145,-223,-278,-292,-263,-213,-165,-130,-107,-100,-116,-154,-197,-224,-222,-196,-163,-138,-123,-120,-135,-166,-186,-170,-144,-181,-315,-478,-546,-485,-385,-336,-320,-252,-119}
        },
        {    // H-20e150a.wav
            {2,0,-3,-2,1,-2,-6,-3,2,1,-4,-3,0,-3,-7,-1,7,2,-5,2,10,-2,-16,-4,18,6,-23,-12,27,19,-35,-33,37,46,-42,-54,77,106,-25,350,1977,4199,4778,2013,-2986,-6843,-7026,-4087,-644,1354,1914,2004,2154,2316,2566,3327,4851,6721,7965,7703,5793,2995,474,-1026,-1583,-1716,-1719,-1531,-1182,-1067,-1547,-2420,-3044,-3037,-2675,-2498,-2672,-2899,-2873,-2597,-2212,-1735,-1115,-444,56,271,293,303,450,825,1394,1918,2104,1905,1573,1338,1154,886,623,582,730,733,369,-182,-581,-737,-816,-935,-1031,-1024,-958,-908,-867,-783,-664,-564,-495,-422,-320,-205,-103,-27,18,35,49,92,169,250,297,303,286,265,235,178,89,-1,-57,-77,-100,-163,-254,-330,-359,-345,-311,-277,-262,-275,-313,-359,-400,-427,-432,-406,-357,-308,-278,-263,-245,-214,-176,-139,-103,-72,-56,-56,-57,-47,-37,-48,-84,-127,-158,-177,-184,-175,-149,-123,-113,-117,-118,-111,-106,-108,-108,-103,-101,-109,-121,-131,-145,-171,-204,-226,-220,-187,-142,-105,-88,-91,-103,-114,-117,-107,-83,-53,-36,-42,-57,-61,-53,-41,-25,-2,23,37,41,44,43,25,-11,-52,-87,-122,-163,-206,-249,-291,-326,-341,-333,-312,-285,-250,-210,-180,-164,-147,-114,-73,-37,-7,19,29,16,0,-2,-1,-15,-32,-33,-44,-104,-184,-195,-108},
            {-13,-27,17,44,-18,-72,-4,80,7,-113,-38,132,61,-170,-103,198,95,-156,1206,5050,8568,6941,-975,-9861,-12621,-7760,-669,2542,1058,-1313,-1240,1337,4831,8339,11494,13207,12051,8078,3549,1332,2511,5473,7235,5850,1943,-1946,-3717,-3565,-3431,-4625,-6319,-6690,-5285,-3637,-3425,-4575,-5645,-5728,-5275,-5038,-4924,-4334,-3205,-2123,-1489,-1053,-367,655,1736,2526,2778,2503,2122,2215,2904,3626,3733,3173,2370,1599,823,95,-294,-237,-102,-366,-1069,-1823,-2284,-2431,-2424,-2365,-2262,-2106,-1906,-1690,-1490,-1299,-1052,-701,-292,53,264,391,526,703,871,960,944,868,801,757,681,539,382,288,247,163,-10,-204,-326,-373,-404,-452,-509,-566,-635,-708,-747,-728,-662,-578,-498,-435,-381,-295,-136,77,251,305,251,177,154,179,209,214,192,142,67,-16,-76,-96,-92,-92,-110,-145,-191,-242,-288,-326,-357,-380,-384,-365,-340,-336,-354,-370,-365,-343,-314,-271,-209,-137,-76,-41,-32,-43,-61,-67,-56,-42,-39,-38,-28,-14,-5,7,36,67,73,42,0,-25,-31,-32,-38,-61,-106,-156,-177,-157,-119,-94,-90,-94,-96,-88,-67,-37,-12,6,31,70,104,116,112,106,89,40,-37,-118,-185,-236,-264,-253,-211,-167,-145,-138,-137,-145,-157,-165,-172,-185,-194,-183,-162,-157,-170,-178,-181,-202,-224,-195,-130,-132,-268,-447,-517,-456,-378,-345,-288,-149}
        },
        {    // H-20e155a.wav
            {-1,-3,0,1,-3,-5,0,3,-1,-3,-1,-2,-6,-3,5,4,-4,-1,11,6,-13,-13,12,17,-14,-26,12,32,-14,-48,8,62,-1,-75,11,124,35,126,1318,3671,5332,3858,-981,-6235,-8276,-6160,-2149,887,1993,2062,2119,2371,2730,3494,5064,7185,8788,8740,6766,3705,877,-861,-1564,-1791,-1896,-1807,-1457,-1196,-1528,-2467,-3382,-3622,-3196,-2700,-2610,-2829,-2959,-2812,-2490,-2086,-1544,-854,-207,181,299,327,452,779,1314,1908,2258,2140,1662,1186,970,978,1046,1077,1019,780,320,-225,-647,-870,-982,-1064,-1106,-1093,-1072,-1095,-1152,-1202,-1204,-1098,-816,-390,15,230,250,214,235,310,384,429,448,444,424,405,391,357,281,176,73,-6,-62,-108,-168,-256,-360,-438,-460,-431,-385,-356,-359,-389,-426,-443,-433,-413,-400,-388,-362,-329,-303,-278,-231,-156,-73,-4,41,65,62,29,-14,-44,-52,-53,-66,-100,-149,-199,-232,-238,-221,-194,-170,-149,-137,-138,-150,-160,-158,-148,-142,-148,-161,-174,-189,-209,-226,-221,-187,-139,-95,-65,-50,-49,-62,-77,-79,-65,-43,-22,-5,0,-11,-32,-46,-43,-31,-20,-11,-1,8,8,0,-15,-36,-61,-86,-104,-126,-164,-213,-260,-298,-327,-341,-335,-312,-283,-249,-206,-165,-138,-118,-84,-35,7,28,40,49,42,16,-8,-16,-27,-60,-94,-108,-127,-187,-253,-239,-125},
            {23,6,-31,-16,41,33,-48,-60,38,70,-49,-109,35,137,-32,-185,22,224,-47,71,2266,6165,8048,4291,-3763,-10074,-9954,-4862,-223,687,-684,-1199,246,2709,5419,8431,11308,12533,10939,7331,4139,3351,4787,6270,5547,2310,-1499,-3535,-3328,-2602,-3228,-5117,-6479,-6052,-4561,-3720,-4215,-5186,-5567,-5309,-5017,-4859,-4409,-3441,-2344,-1580,-1103,-539,292,1245,2075,2579,2645,2422,2339,2692,3229,3404,3030,2418,1850,1249,521,-98,-330,-323,-513,-1059,-1677,-2055,-2196,-2269,-2333,-2326,-2214,-2012,-1737,-1421,-1137,-912,-674,-351,3,268,419,549,725,907,1013,1021,969,897,813,706,569,424,310,228,122,-55,-271,-438,-508,-515,-516,-530,-557,-605,-672,-720,-701,-610,-482,-356,-265,-232,-241,-228,-135,20,152,205,207,215,235,233,198,157,126,94,47,-4,-46,-84,-127,-171,-210,-247,-285,-311,-318,-325,-355,-394,-403,-379,-353,-345,-339,-315,-279,-253,-234,-202,-149,-92,-49,-27,-24,-34,-50,-64,-74,-79,-74,-54,-27,-6,8,26,53,71,66,42,11,-13,-23,-22,-29,-60,-109,-145,-145,-119,-92,-81,-83,-87,-84,-71,-50,-26,0,29,56,74,80,77,66,37,-14,-79,-144,-199,-233,-237,-211,-169,-133,-117,-126,-154,-183,-194,-185,-172,-165,-159,-156,-168,-195,-210,-207,-216,-247,-252,-189,-107,-107,-220,-367,-455,-463,-407,-291,-133}
        },
        {    // H-20e160a.wav
            {-3,-1,-3,-5,-2,2,1,-2,-2,-2,-6,-6,2,6,-1,-5,5,8,-8,-17,3,19,-2,-26,-3,28,1,-46,-19,51,31,-58,-33,92,73,54,876,3044,5309,5086,1056,-4830,-8636,-7997,-4100,-105,1923,2235,2127,2323,2811,3653,5220,7491,9494,9839,7927,4575,1362,-636,-1474,-1829,-2092,-2115,-1743,-1325,-1488,-2420,-3559,-4107,-3821,-3190,-2844,-2917,-3062,-2966,-2648,-2254,-1777,-1140,-440,65,240,229,322,704,1330,1947,2251,2128,1771,1493,1394,1310,1105,879,778,723,486,10,-504,-852,-1031,-1145,-1227,-1255,-1260,-1301,-1370,-1395,-1325,-1162,-922,-624,-327,-105,36,170,358,577,760,871,911,876,760,586,412,296,255,253,231,148,20,-101,-185,-251,-333,-432,-511,-541,-535,-520,-511,-506,-507,-518,-536,-546,-528,-468,-378,-292,-246,-236,-218,-153,-45,66,141,165,144,97,48,19,9,0,-23,-61,-106,-155,-200,-227,-227,-215,-210,-216,-220,-220,-225,-239,-252,-252,-244,-238,-235,-229,-218,-211,-206,-193,-164,-119,-65,-18,6,2,-15,-27,-27,-20,-8,6,17,19,13,5,-5,-19,-34,-42,-39,-31,-29,-34,-49,-74,-99,-111,-105,-93,-89,-104,-142,-200,-263,-312,-339,-349,-341,-309,-256,-203,-167,-145,-126,-102,-70,-26,23,57,64,59,50,28,-9,-42,-63,-93,-147,-194,-203,-200,-234,-281,-255,-132},
            {-14,11,27,-6,-37,-1,46,7,-63,-29,63,35,-87,-69,91,93,-114,-142,128,169,-134,469,3188,6606,6948,2156,-4970,-9109,-7882,-3876,-1092,-690,-950,-287,1232,3097,5511,8620,11380,12148,10414,7472,5280,4792,5275,5034,2933,-459,-3193,-3737,-2595,-1871,-3029,-5302,-6629,-6019,-4534,-3859,-4405,-5223,-5444,-5166,-4846,-4448,-3639,-2503,-1560,-1070,-731,-138,745,1667,2376,2713,2649,2422,2434,2788,3095,2933,2376,1825,1419,945,320,-205,-448,-613,-1001,-1567,-2000,-2147,-2141,-2147,-2170,-2143,-2031,-1818,-1502,-1144,-840,-598,-335,-17,265,426,515,650,855,1037,1099,1035,909,789,695,598,472,338,241,176,79,-91,-294,-463,-578,-658,-700,-687,-636,-602,-609,-624,-605,-547,-466,-382,-318,-288,-266,-200,-71,70,165,207,240,283,310,292,237,170,104,42,-10,-47,-77,-109,-148,-194,-250,-314,-367,-387,-383,-382,-396,-408,-396,-368,-345,-330,-306,-266,-229,-207,-188,-151,-99,-54,-33,-31,-37,-49,-65,-78,-83,-78,-65,-45,-21,4,30,57,77,79,60,37,24,22,20,8,-26,-80,-137,-167,-155,-120,-96,-96,-104,-105,-99,-87,-63,-27,13,46,68,75,61,25,-21,-70,-123,-175,-210,-210,-184,-156,-137,-125,-126,-148,-181,-201,-197,-180,-161,-143,-136,-155,-197,-232,-241,-239,-250,-266,-253,-199,-133,-106,-158,-285,-422,-464,-356,-158}
        },
        {    // H-20e165a.wav
            {-2,-5,-3,2,1,-2,-2,-2,-6,-6,2,7,0,-6,3,11,-2,-15,-2,17,5,-21,-10,24,12,-37,-32,33,42,-32,-41,58,72,33,630,2531,4984,5655,2663,-3072,-8035,-9068,-6068,-1682,1366,2356,2292,2311,2800,3771,5393,7703,9946,10714,9090,5648,2079,-246,-1253,-1735,-2205,-2449,-2141,-1571,-1497,-2320,-3588,-4421,-4358,-3727,-3203,-3121,-3270,-3265,-2965,-2480,-1914,-1270,-586,-22,270,310,295,467,962,1697,2354,2587,2327,1838,1432,1194,1036,915,855,780,516,24,-498,-828,-967,-1087,-1290,-1504,-1609,-1567,-1430,-1276,-1167,-1104,-1023,-855,-612,-372,-176,19,262,535,773,930,1009,1025,984,894,773,639,506,386,282,191,107,28,-56,-165,-307,-458,-576,-632,-625,-581,-549,-565,-624,-685,-707,-687,-637,-557,-442,-318,-226,-177,-139,-83,-20,28,70,126,187,216,193,140,94,63,31,-6,-43,-77,-115,-159,-195,-214,-226,-249,-286,-322,-348,-366,-377,-370,-340,-302,-274,-259,-245,-226,-204,-178,-144,-95,-37,15,48,55,41,24,20,29,39,45,48,48,39,25,17,16,9,-13,-42,-64,-79,-92,-104,-113,-125,-140,-147,-133,-107,-89,-95,-125,-172,-228,-277,-305,-310,-300,-276,-236,-190,-156,-135,-108,-73,-45,-26,2,40,67,68,56,39,5,-51,-108,-146,-180,-223,-252,-246,-236,-264,-300,-262,-132},
            {10,-8,-11,14,20,-14,-26,16,37,-17,-57,4,64,-4,-91,-17,107,30,-143,-59,177,70,-124,927,3810,6531,5833,908,-5101,-8081,-6968,-4078,-1967,-1089,-511,364,1566,3312,5933,9021,11319,11748,10337,8100,6184,5080,4342,3006,612,-2039,-3459,-3052,-1946,-1901,-3441,-5374,-6207,-5697,-4805,-4433,-4607,-4861,-4951,-4907,-4648,-3954,-2854,-1742,-988,-578,-235,264,981,1852,2633,2963,2721,2279,2163,2449,2705,2565,2113,1604,1089,504,-57,-419,-630,-922,-1365,-1773,-1982,-2041,-2073,-2089,-2045,-1950,-1812,-1572,-1203,-812,-530,-341,-133,127,365,535,680,827,927,939,899,866,841,785,685,569,463,376,297,203,58,-148,-372,-547,-640,-662,-649,-634,-638,-660,-680,-684,-670,-638,-578,-495,-417,-361,-295,-169,18,197,299,321,311,299,277,244,215,199,178,129,53,-27,-97,-164,-235,-307,-366,-403,-414,-406,-397,-402,-416,-419,-398,-363,-328,-292,-253,-223,-210,-198,-170,-131,-102,-86,-66,-41,-29,-37,-46,-41,-30,-28,-29,-18,6,33,60,86,101,94,69,40,19,6,-3,-20,-57,-108,-151,-169,-169,-165,-160,-147,-131,-117,-99,-63,-17,20,38,43,37,13,-25,-62,-94,-131,-173,-199,-193,-167,-143,-130,-130,-143,-164,-175,-167,-153,-145,-142,-141,-153,-184,-220,-241,-247,-251,-256,-263,-269,-252,-185,-104,-112,-250,-397,-384,-197}
        },
        {    // H-20e170a.wav
            {-5,0,1,-1,-1,-1,-5,-7,-1,5,0,-5,2,10,0,-15,-6,13,4,-22,-16,17,13,-30,-32,23,34,-29,-39,53,68,1,471,2188,4656,5802,3621,-1582,-6908,-9152,-7399,-3427,172,2029,2452,2469,2828,3819,5552,7930,10266,11283,9990,6701,2987,373,-854,-1475,-2137,-2655,-2546,-1951,-1673,-2319,-3601,-4622,-4759,-4193,-3588,-3393,-3511,-3569,-3351,-2887,-2255,-1470,-615,61,316,189,46,295,1038,1974,2627,2716,2346,1858,1504,1296,1139,1008,924,824,573,127,-401,-863,-1204,-1432,-1542,-1529,-1447,-1375,-1359,-1388,-1421,-1396,-1235,-915,-525,-206,-22,80,175,284,406,564,772,975,1082,1056,950,842,767,701,601,447,265,99,-25,-123,-234,-375,-524,-643,-708,-722,-707,-696,-707,-733,-751,-745,-711,-641,-532,-405,-303,-242,-193,-113,-1,106,179,216,227,214,184,158,154,161,152,116,60,-8,-84,-157,-210,-241,-268,-307,-353,-394,-424,-446,-455,-444,-414,-376,-340,-306,-272,-238,-205,-173,-139,-96,-40,21,71,92,85,64,47,42,49,63,75,76,64,48,38,33,21,-4,-36,-67,-93,-115,-133,-150,-168,-186,-197,-190,-160,-118,-89,-89,-114,-152,-194,-232,-257,-260,-245,-227,-212,-194,-167,-135,-108,-87,-68,-46,-18,15,45,58,47,15,-31,-86,-141,-184,-212,-236,-262,-279,-281,-285,-303,-300,-230,-105},
            {-8,7,7,-9,-6,15,11,-18,-17,20,22,-28,-40,20,45,-30,-73,18,87,-22,-126,12,164,-14,-18,1332,4121,6236,5045,367,-4929,-7607,-6911,-4520,-2337,-986,-114,766,2019,3915,6417,9006,10917,11550,10710,8710,6315,4296,2770,1182,-807,-2575,-3108,-2360,-1612,-2191,-4005,-5658,-5988,-5204,-4426,-4376,-4796,-5032,-4825,-4370,-3842,-3174,-2302,-1379,-635,-134,245,668,1238,1925,2528,2788,2659,2402,2278,2249,2103,1818,1579,1428,1131,514,-248,-826,-1120,-1293,-1487,-1677,-1802,-1875,-1925,-1938,-1895,-1799,-1632,-1346,-955,-569,-280,-77,93,236,336,428,576,775,945,1016,985,892,790,719,682,639,540,383,211,52,-98,-240,-353,-429,-483,-527,-554,-572,-617,-714,-834,-915,-914,-833,-697,-543,-406,-308,-225,-120,13,147,259,346,407,426,398,342,282,228,171,107,37,-43,-136,-232,-311,-364,-394,-403,-395,-384,-387,-406,-423,-424,-409,-381,-342,-294,-251,-229,-224,-220,-204,-172,-127,-73,-18,23,39,34,22,15,13,15,22,36,55,70,76,76,74,67,49,21,-3,-18,-33,-60,-98,-138,-173,-195,-200,-190,-172,-152,-127,-95,-60,-29,-3,15,16,-2,-29,-55,-83,-118,-153,-174,-182,-182,-170,-146,-128,-132,-146,-141,-116,-96,-97,-106,-118,-144,-183,-209,-212,-220,-243,-256,-253,-274,-323,-321,-218,-104,-117,-238,-290,-174}
        },
        {    // H-20e175a.wav
            {1,-1,0,2,-3,-8,-2,5,1,-5,2,12,2,-13,-5,14,4,-23,-16,19,15,-31,-34,23,35,-34,-49,53,79,-21,347,1950,4423,5817,4114,-613,-5840,-8597,-7793,-4648,-1247,1070,2165,2600,3030,3956,5675,8100,10513,11684,10639,7572,3895,1132,-290,-1060,-1876,-2616,-2741,-2265,-1958,-2513,-3750,-4805,-5024,-4531,-3940,-3698,-3772,-3860,-3720,-3286,-2606,-1789,-980,-311,150,407,530,676,1048,1691,2355,2676,2536,2156,1802,1525,1264,1054,969,910,637,69,-584,-1051,-1261,-1321,-1347,-1394,-1495,-1640,-1736,-1693,-1524,-1316,-1097,-820,-494,-225,-92,-35,66,248,445,597,706,797,867,899,892,864,828,784,724,640,532,401,244,59,-149,-356,-534,-665,-742,-769,-761,-751,-764,-790,-800,-779,-737,-687,-625,-542,-443,-336,-222,-97,29,136,208,252,281,301,307,293,264,229,189,141,78,1,-81,-158,-229,-294,-347,-378,-391,-403,-428,-460,-482,-482,-464,-434,-392,-336,-278,-233,-203,-175,-137,-92,-46,4,61,109,128,113,82,56,43,44,58,79,90,82,61,42,32,20,-6,-46,-87,-117,-135,-151,-170,-191,-209,-216,-206,-174,-127,-82,-62,-75,-109,-146,-175,-194,-203,-201,-194,-192,-194,-185,-157,-119,-88,-68,-49,-24,2,20,22,9,-20,-64,-117,-165,-196,-212,-228,-254,-285,-312,-329,-332,-304,-233,-134,-46},
            {-1,-8,-2,7,2,-7,0,14,4,-17,-7,22,13,-28,-26,24,27,-36,-50,28,58,-39,-85,48,121,-47,132,1627,4250,5983,4598,92,-4958,-7653,-7154,-4799,-2377,-701,425,1480,2761,4371,6337,8563,10626,11717,11076,8722,5657,3077,1350,-26,-1441,-2517,-2666,-2092,-1819,-2629,-4205,-5478,-5700,-5061,-4326,-4066,-4282,-4600,-4654,-4289,-3546,-2583,-1604,-782,-195,184,458,778,1266,1888,2405,2589,2487,2364,2354,2283,1944,1426,1016,823,662,331,-155,-655,-1090,-1443,-1673,-1750,-1735,-1730,-1757,-1765,-1721,-1619,-1428,-1108,-713,-379,-187,-87,23,180,359,536,699,833,928,981,987,931,816,682,568,475,387,315,271,219,97,-98,-296,-426,-487,-534,-609,-709,-810,-887,-925,-917,-867,-784,-684,-582,-489,-397,-284,-137,31,189,310,385,423,430,412,372,317,250,176,97,18,-59,-135,-210,-277,-328,-362,-385,-398,-402,-408,-429,-456,-466,-444,-400,-358,-326,-297,-270,-246,-221,-184,-134,-78,-22,29,68,88,94,92,80,54,30,28,47,65,68,62,56,48,37,28,24,7,-35,-86,-124,-149,-174,-195,-201,-192,-181,-167,-140,-102,-67,-43,-30,-28,-39,-56,-69,-82,-107,-143,-173,-189,-193,-184,-160,-134,-124,-125,-112,-78,-45,-32,-36,-56,-102,-167,-210,-211,-201,-216,-242,-254,-272,-323,-367,-331,-224,-142,-136,-142,-87}
        },
        {    // H-20e180a.wav
            {-2,2,-1,-6,-2,6,2,-5,1,11,2,-14,-5,16,6,-25,-19,21,19,-33,-41,24,45,-35,-64,49,96,-34,234,1750,4264,5856,4427,-55,-5154,-7997,-7576,-5048,-2217,-92,1289,2264,3146,4251,5921,8229,10600,11881,11096,8338,4848,2038,381,-647,-1625,-2447,-2654,-2289,-2087,-2719,-4016,-5111,-5324,-4791,-4192,-3991,-4082,-4111,-3942,-3663,-3265,-2563,-1496,-358,413,653,597,638,1012,1657,2292,2635,2611,2375,2114,1871,1595,1294,1029,771,399,-102,-558,-805,-905,-1061,-1363,-1697,-1905,-1935,-1837,-1681,-1508,-1331,-1128,-873,-588,-342,-180,-74,41,198,388,596,801,959,1013,942,793,662,618,653,692,667,575,465,362,238,61,-159,-380,-574,-724,-804,-804,-761,-741,-774,-831,-868,-862,-805,-694,-548,-418,-337,-279,-182,-25,147,282,367,415,424,387,324,273,247,223,174,95,-2,-105,-206,-292,-349,-376,-385,-394,-410,-433,-459,-480,-486,-470,-437,-394,-347,-297,-251,-215,-185,-153,-109,-50,19,80,118,128,118,97,72,51,44,52,63,68,65,61,59,55,43,21,-12,-51,-90,-122,-148,-172,-194,-208,-208,-197,-179,-152,-116,-80,-56,-50,-58,-78,-105,-131,-147,-155,-166,-182,-193,-190,-170,-144,-120,-95,-67,-39,-18,-6,-3,-15,-50,-102,-153,-185,-199,-208,-222,-245,-276,-316,-351,-355,-313,-234,-147,-76,-27},
            {-2,2,-1,-6,-2,6,2,-5,1,11,2,-14,-5,16,6,-25,-19,21,19,-33,-41,24,45,-35,-64,49,96,-34,234,1750,4264,5856,4427,-55,-5154,-7997,-7576,-5048,-2217,-92,1289,2264,3146,4251,5921,8229,10600,11881,11096,8338,4848,2038,381,-647,-1625,-2447,-2654,-2289,-2087,-2719,-4016,-5111,-5324,-4791,-4192,-3991,-4082,-4111,-3942,-3663,-3265,-2563,-1496,-358,413,653,597,638,1012,1657,2292,2635,2611,2375,2114,1871,1595,1294,1029,771,399,-102,-558,-805,-905,-1061,-1363,-1697,-1905,-1935,-1837,-1681,-1508,-1331,-1128,-873,-588,-342,-180,-74,41,198,388,596,801,959,1013,942,793,662,618,653,692,667,575,465,362,238,61,-159,-380,-574,-724,-804,-804,-761,-741,-774,-831,-868,-862,-805,-694,-548,-418,-337,-279,-182,-25,147,282,367,415,424,387,324,273,247,223,174,95,-2,-105,-206,-292,-349,-376,-385,-394,-410,-433,-459,-480,-486,-470,-437,-394,-347,-297,-251,-215,-185,-153,-109,-50,19,80,118,128,118,97,72,51,44,52,63,68,65,61,59,55,43,21,-12,-51,-90,-122,-148,-172,-194,-208,-208,-197,-179,-152,-116,-80,-56,-50,-58,-78,-105,-131,-147,-155,-166,-182,-193,-190,-170,-144,-120,-95,-67,-39,-18,-6,-3,-15,-50,-102,-153,-185,-199,-208,-222,-245,-276,-316,-351,-355,-313,-234,-147,-76,-27}
        }
    },
    {    // elev-30
        {    // H-30e000a.wav
            {-8,-6,6,9,-4,-11,5,18,0,-21,-4,23,3,-41,-28,32,34,-39,-59,23,59,-37,-83,39,82,-10,655,3103,6313,6820,2092,-5568,-10147,-8090,-2458,507,-1372,-4033,-2540,3092,8575,10562,9340,6888,4580,3561,5325,9852,13777,12584,5452,-3132,-7483,-6131,-2715,-1912,-5024,-9223,-10470,-7190,-1679,1873,1055,-2760,-5968,-6144,-3757,-912,859,1348,987,235,-398,-389,339,1190,1381,704,-237,-551,135,1277,1817,1128,-375,-1600,-1768,-1017,-92,356,160,-451,-1099,-1449,-1373,-1018,-682,-567,-652,-748,-649,-291,157,392,254,-84,-274,-138,207,538,734,781,701,537,360,222,126,69,58,52,-43,-259,-477,-545,-474,-422,-494,-626,-689,-628,-478,-309,-195,-189,-268,-326,-272,-126,10,60,32,-11,-14,41,121,161,128,53,-6,-31,-48,-77,-108,-134,-157,-177,-178,-156,-130,-111,-86,-55,-52,-98,-161,-184,-152,-103,-76,-68,-62,-52,-42,-30,-17,-21,-59,-117,-154,-147,-120,-112,-140,-179,-179,-116,-23,17,-72,-281,-505,-626,-624,-568,-517,-443,-276,-8,270,452,497,447,375,321,265,163,-3,-189,-330,-410,-470,-551,-655,-763,-844,-838,-681,-375,-33,206,292,283,262,257,251,226,175,111,59,32,14,-15,-43,-36,11,68,113,144,147,103,27,-37,-78,-134,-213,-261,-250,-239,-281,-330,-324,-313,-388,-497,-467,-245},
            {-8,-6,6,9,-4,-11,5,18,0,-21,-4,23,3,-41,-28,32,34,-39,-59,23,59,-37,-83,39,82,-10,655,3103,6313,6820,2092,-5568,-10147,-8090,-2458,507,-1372,-4033,-2540,3092,8575,10562,9340,6888,4580,3561,5325,9852,13777,12584,5452,-3132,-7483,-6131,-2715,-1912,-5024,-9223,-10470,-7190,-1679,1873,1055,-2760,-5968,-6144,-3757,-912,859,1348,987,235,-398,-389,339,1190,1381,704,-237,-551,135,1277,1817,1128,-375,-1600,-1768,-1017,-92,356,160,-451,-1099,-1449,-1373,-1018,-682,-567,-652,-748,-649,-291,157,392,254,-84,-274,-138,207,538,734,781,701,537,360,222,126,69,58,52,-43,-259,-477,-545,-474,-422,-494,-626,-689,-628,-478,-309,-195,-189,-268,-326,-272,-126,10,60,32,-11,-14,41,121,161,128,53,-6,-31,-48,-77,-108,-134,-157,-177,-178,-156,-130,-111,-86,-55,-52,-98,-161,-184,-152,-103,-76,-68,-62,-52,-42,-30,-17,-21,-59,-117,-154,-147,-120,-112,-140,-179,-179,-116,-23,17,-72,-281,-505,-626,-624,-568,-517,-443,-276,-8,270,452,497,447,375,321,265,163,-3,-189,-330,-410,-470,-551,-655,-763,-844,-838,-681,-375,-33,206,292,283,262,257,251,226,175,111,59,32,14,-15,-43,-36,11,68,113,144,147,103,27,-37,-78,-134,-213,-261,-250,-239,-281,-330,-324,-313,-388,-497,-467,-245}
        },
        {    // H-30e006a.wav
            {-2,-1,-4,-7,-1,8,4,-8,-5,11,11,-9,-13,10,17,-14,-35,-2,33,1,-49,-23,40,18,-56,-26,61,15,156,1410,3968,5936,4474,-860,-6542,-8141,-5131,-1573,-1413,-3935,-4898,-1693,3904,8171,9288,8105,6268,5009,5354,7785,10960,11850,8407,2057,-3238,-4662,-3011,-1538,-2689,-5984,-8653,-8166,-4490,-220,1610,138,-2765,-4471,-3976,-2298,-944,-468,-477,-523,-570,-704,-755,-430,231,718,547,-108,-456,75,1130,1744,1367,403,-324,-420,-126,144,190,-1,-392,-882,-1255,-1303,-1038,-730,-704,-1031,-1404,-1372,-797,-60,282,70,-298,-317,105,629,876,770,518,356,346,364,271,86,-37,-11,62,31,-95,-175,-151,-135,-236,-404,-504,-486,-408,-336,-293,-286,-318,-359,-361,-312,-249,-205,-177,-152,-127,-94,-32,46,83,34,-62,-113,-70,27,91,69,-18,-95,-97,-25,51,66,30,-1,-4,-9,-40,-69,-62,-32,-23,-50,-96,-142,-185,-218,-239,-261,-303,-360,-396,-380,-306,-182,-37,52,-5,-216,-471,-628,-640,-573,-508,-440,-297,-36,291,563,682,649,547,452,372,276,152,14,-124,-268,-412,-540,-660,-800,-957,-1058,-1009,-782,-454,-159,11,59,52,52,72,98,131,178,229,265,283,291,287,257,212,190,205,224,205,142,57,-33,-110,-159,-196,-255,-333,-382,-381,-373,-395,-417,-408,-422,-516,-607,-530,-265},
            {2,10,1,-10,2,21,8,-21,-13,23,17,-36,-44,23,52,-23,-78,0,78,-7,-106,0,111,-8,388,2650,6360,8022,4014,-4482,-11081,-10429,-4318,231,-843,-4166,-3586,2296,9051,12044,10848,7874,5081,3623,4982,9669,14696,14792,7741,-2355,-8576,-7916,-3808,-2064,-5043,-9878,-11727,-8411,-2298,1919,1402,-2527,-6006,-6339,-3939,-1006,885,1569,1423,710,-157,-459,195,1264,1678,901,-482,-1257,-690,753,1748,1315,-237,-1604,-1753,-815,248,627,215,-598,-1332,-1638,-1407,-854,-404,-371,-701,-1034,-1003,-515,160,571,468,43,-247,-131,249,566,659,603,527,478,442,398,331,244,160,75,-63,-274,-463,-508,-432,-401,-527,-734,-850,-798,-633,-455,-337,-314,-355,-365,-258,-59,118,182,140,64,29,73,175,251,221,103,3,-6,27,6,-94,-210,-281,-299,-283,-248,-212,-187,-167,-136,-111,-126,-173,-195,-159,-102,-78,-85,-79,-46,-6,23,43,46,20,-18,-34,-18,-8,-38,-102,-169,-205,-180,-85,22,26,-136,-395,-602,-675,-654,-621,-587,-485,-262,50,339,490,484,402,340,313,263,144,-22,-176,-287,-372,-464,-583,-727,-863,-926,-845,-595,-234,109,315,359,315,273,255,227,168,102,59,41,39,45,52,51,50,71,115,153,159,135,90,21,-68,-152,-213,-261,-305,-330,-327,-331,-356,-360,-320,-305,-387,-493,-455,-235}
        },
        {    // H-30e012a.wav
            {1,-1,-1,-1,-4,-5,1,7,1,-7,-2,11,8,-7,-7,11,11,-16,-26,5,26,-7,-41,-10,36,7,-47,-6,53,6,222,1482,3746,5196,3529,-1225,-5816,-6737,-4057,-1386,-1658,-3770,-4132,-1003,3743,7073,7841,6997,5836,5133,5522,7326,9533,9889,6940,1878,-2261,-3405,-2250,-1309,-2420,-5124,-7195,-6674,-3681,-414,777,-539,-2703,-3769,-3253,-2090,-1282,-991,-874,-781,-849,-1068,-1100,-637,157,701,575,24,-218,297,1210,1719,1437,740,256,207,353,403,277,3,-394,-831,-1118,-1114,-897,-739,-873,-1270,-1617,-1566,-1067,-456,-152,-240,-406,-300,95,497,644,527,336,254,307,374,338,226,175,250,350,336,213,103,62,19,-101,-266,-388,-432,-424,-398,-377,-380,-410,-435,-425,-389,-354,-323,-289,-267,-266,-258,-198,-94,-14,0,-19,-6,54,118,135,97,38,7,22,64,90,81,55,39,42,49,46,29,3,-23,-49,-78,-119,-173,-229,-276,-317,-364,-418,-468,-487,-447,-335,-175,-42,-24,-160,-387,-574,-626,-559,-464,-387,-274,-56,241,509,656,679,624,524,396,263,141,23,-104,-236,-358,-465,-571,-694,-832,-949,-974,-846,-587,-308,-110,-4,60,105,121,114,116,137,151,149,151,173,194,200,206,218,223,214,200,172,107,16,-49,-75,-108,-179,-245,-271,-301,-376,-446,-448,-438,-513,-614,-554,-285},
            {8,-9,-5,19,19,-15,-24,15,29,-23,-57,2,62,6,-82,-35,78,36,-104,-53,116,31,114,1867,5730,8790,6518,-1838,-10646,-12797,-7471,-1203,-267,-3513,-4430,593,8315,13057,12756,9484,5944,3790,4549,9087,15015,16779,10699,-304,-8719,-9700,-5534,-2623,-4796,-10000,-12941,-10313,-3710,1934,2687,-1115,-5571,-6993,-4909,-1552,860,1760,1637,937,8,-495,20,1244,1959,1179,-749,-2311,-2163,-376,1577,2138,1039,-582,-1378,-987,-83,486,377,-246,-1007,-1497,-1437,-894,-316,-190,-611,-1192,-1389,-951,-131,503,541,101,-302,-275,105,467,580,504,410,369,354,334,316,321,347,336,196,-86,-369,-471,-380,-279,-338,-538,-725,-789,-728,-601,-481,-440,-494,-556,-498,-285,-17,170,215,156,91,106,211,318,312,178,28,-20,27,61,2,-131,-264,-345,-366,-345,-310,-285,-270,-250,-222,-202,-194,-174,-124,-69,-51,-74,-89,-52,29,108,145,128,72,11,-17,-1,27,19,-40,-131,-208,-224,-152,-24,54,-30,-278,-556,-714,-718,-652,-595,-539,-418,-194,92,339,459,446,381,345,332,275,143,-16,-140,-227,-323,-459,-629,-809,-955,-993,-848,-521,-123,197,352,366,323,283,245,179,90,22,11,39,67,80,94,118,143,170,206,238,229,165,73,-16,-97,-176,-244,-295,-344,-401,-444,-444,-409,-366,-331,-315,-348,-428,-471,-381,-178}
        },
        {    // H-30e018a.wav
            {-4,-1,1,-1,-2,-2,-4,-5,0,5,0,-7,-2,8,5,-7,-6,9,7,-15,-20,6,19,-11,-34,-3,30,0,-37,3,40,1,259,1449,3392,4459,2832,-1216,-4895,-5505,-3369,-1438,-1816,-3374,-3315,-556,3253,5863,6618,6280,5632,5082,5183,6395,8046,8324,6003,2000,-1293,-2279,-1542,-1016,-2032,-4167,-5744,-5373,-3206,-850,26,-885,-2432,-3251,-2952,-2112,-1410,-1054,-948,-1047,-1346,-1649,-1589,-970,-63,560,561,219,169,718,1493,1853,1584,1055,740,750,869,866,644,196,-411,-983,-1285,-1242,-1031,-936,-1116,-1486,-1775,-1726,-1319,-808,-495,-443,-452,-307,-11,260,363,317,250,269,381,504,557,544,539,571,576,490,348,245,200,132,-21,-213,-347,-385,-368,-356,-382,-445,-520,-567,-563,-527,-505,-515,-536,-532,-482,-384,-246,-99,12,65,83,107,150,187,189,156,113,90,100,130,148,130,90,59,47,35,13,-6,-14,-23,-57,-116,-182,-244,-299,-340,-363,-385,-425,-467,-468,-400,-280,-161,-112,-177,-343,-521,-605,-565,-465,-369,-259,-80,169,413,573,630,605,527,417,289,155,26,-89,-191,-291,-394,-499,-610,-735,-856,-906,-820,-610,-362,-158,-20,68,116,126,110,87,72,68,77,85,80,74,92,134,176,204,224,227,187,110,46,17,-12,-74,-140,-176,-212,-285,-360,-388,-416,-514,-613,-544,-277},
            {-8,17,25,-8,-33,0,35,-3,-62,-28,57,39,-70,-75,54,78,-76,-112,83,103,-43,992,4483,8692,8842,1991,-8248,-13993,-11219,-4273,-723,-2540,-4450,-1076,6560,12848,14118,11371,7527,4683,4456,8171,14490,18166,14057,3088,-7483,-10951,-7703,-4102,-5379,-10531,-14027,-11652,-4467,2336,4068,388,-4876,-7435,-6062,-2714,104,1455,1708,1300,464,-238,-51,1016,1807,1036,-1270,-3482,-3683,-1410,1791,3613,2963,766,-1113,-1576,-897,24,558,525,1,-726,-1194,-1126,-747,-569,-843,-1309,-1484,-1099,-312,386,517,35,-571,-714,-290,281,559,504,358,288,273,259,264,327,429,484,386,104,-226,-372,-247,-37,-21,-265,-578,-747,-729,-610,-486,-434,-493,-609,-640,-494,-243,-49,6,-18,-11,90,262,404,402,228,1,-111,-54,63,93,-9,-176,-319,-386,-378,-335,-303,-293,-274,-233,-203,-211,-221,-176,-86,-28,-38,-66,-45,24,95,137,143,111,51,8,26,82,98,27,-103,-223,-284,-258,-145,-4,45,-93,-378,-652,-775,-745,-658,-590,-518,-369,-113,180,392,460,429,396,392,370,282,144,12,-90,-188,-313,-471,-659,-864,-1034,-1065,-871,-478,-37,272,375,334,263,217,173,101,28,2,26,56,66,78,121,186,243,282,308,317,290,219,117,9,-89,-172,-245,-322,-408,-483,-520,-506,-457,-400,-358,-348,-377,-423,-433,-361,-220,-79}
        },
        {    // H-30e024a.wav
            {-1,-2,-1,1,0,-1,0,0,-3,-3,1,4,-1,-5,1,8,3,-7,-3,9,6,-12,-15,6,15,-8,-24,2,25,0,-25,9,30,-1,246,1284,2932,3835,2512,-824,-3934,-4629,-3087,-1570,-1742,-2817,-2703,-536,2537,4871,5867,5872,5322,4619,4457,5383,6840,7244,5511,2331,-392,-1359,-953,-618,-1424,-3168,-4633,-4649,-3122,-1192,-282,-865,-2144,-2938,-2773,-2061,-1444,-1211,-1305,-1595,-1940,-2092,-1772,-953,6,611,677,509,595,1105,1722,1997,1807,1419,1150,1078,1066,955,662,177,-421,-966,-1294,-1371,-1309,-1273,-1373,-1592,-1775,-1722,-1376,-922,-633,-594,-631,-523,-237,84,302,398,440,496,582,660,691,685,690,717,702,598,444,321,243,147,-6,-170,-277,-316,-332,-365,-430,-523,-628,-712,-751,-749,-721,-672,-608,-544,-480,-393,-261,-104,27,102,139,168,202,237,260,256,222,177,150,145,144,124,90,56,24,-12,-49,-78,-94,-99,-105,-126,-167,-221,-271,-308,-339,-375,-412,-431,-410,-339,-240,-173,-199,-325,-485,-589,-589,-508,-390,-251,-80,125,327,466,515,497,452,390,299,182,60,-48,-153,-261,-360,-439,-517,-613,-708,-750,-697,-550,-348,-154,-18,52,84,103,94,47,-3,-10,15,22,0,-11,18,71,125,180,224,220,160,88,42,7,-39,-77,-93,-122,-190,-251,-265,-292,-408,-539,-502,-260},
            {29,7,-31,-18,32,23,-48,-56,33,69,-32,-101,5,105,-11,-143,2,160,-32,283,2865,7508,10175,6172,-3911,-13017,-14280,-8436,-2715,-2176,-4159,-2516,4333,11768,14765,12880,9047,5927,5088,7839,13801,18753,16904,7110,-4599,-10608,-9480,-6693,-7748,-12106,-14530,-11257,-3822,2724,4364,1041,-3945,-6904,-6460,-3924,-1407,130,978,1470,1409,742,117,205,655,266,-1548,-3703,-4161,-1910,1818,4442,4266,1861,-704,-1797,-1312,-154,802,1149,822,23,-789,-1184,-1151,-1071,-1233,-1517,-1556,-1135,-404,214,314,-149,-751,-941,-568,0,317,306,216,239,328,355,309,284,344,441,446,274,9,-139,-49,146,180,-59,-420,-663,-677,-528,-360,-295,-377,-541,-649,-603,-438,-269,-179,-161,-147,-69,92,263,320,207,18,-86,-43,59,90,6,-142,-272,-338,-337,-295,-250,-222,-198,-167,-146,-161,-190,-182,-121,-56,-38,-55,-53,-6,58,100,107,83,38,-3,-4,41,88,82,8,-102,-206,-267,-248,-137,-7,10,-164,-463,-723,-820,-765,-657,-565,-463,-279,-1,280,446,467,427,422,453,448,360,215,66,-70,-210,-368,-547,-747,-954,-1108,-1101,-854,-408,58,345,390,291,186,121,60,-7,-32,16,87,111,90,92,162,273,368,417,422,397,344,260,148,30,-65,-134,-211,-323,-450,-540,-568,-554,-518,-465,-406,-373,-383,-403,-382,-308,-209,-115,-42}
        },
        {    // H-30e030a.wav
            {0,0,-1,-1,-1,1,1,-1,-1,-1,-2,-3,0,3,1,-3,0,6,4,-3,-2,7,5,-9,-11,6,13,-6,-19,2,23,4,-18,5,21,0,207,1066,2460,3307,2347,-369,-3096,-3962,-2894,-1600,-1546,-2322,-2305,-616,2015,4215,5255,5252,4644,3956,3833,4651,5895,6310,5049,2609,422,-477,-301,-141,-887,-2457,-3876,-4102,-2950,-1323,-449,-816,-1846,-2598,-2651,-2277,-1932,-1804,-1821,-1877,-1903,-1791,-1401,-712,68,623,804,795,943,1392,1909,2117,1889,1453,1125,999,946,805,513,99,-370,-802,-1114,-1277,-1346,-1418,-1557,-1731,-1818,-1698,-1375,-1006,-770,-700,-663,-509,-213,121,374,511,577,637,704,741,717,662,638,660,669,605,482,355,245,128,-12,-148,-251,-327,-399,-474,-549,-625,-700,-757,-775,-754,-717,-675,-621,-547,-461,-366,-249,-108,25,106,130,140,178,237,279,280,252,221,198,171,129,76,32,2,-22,-51,-78,-83,-67,-56,-77,-125,-179,-230,-276,-310,-328,-342,-369,-394,-377,-309,-237,-234,-319,-444,-536,-550,-490,-387,-266,-125,42,209,331,385,387,365,324,257,169,77,-19,-124,-227,-307,-363,-417,-483,-546,-574,-540,-435,-283,-137,-43,1,25,43,36,-2,-46,-72,-81,-78,-58,-25,1,18,48,98,137,134,100,60,21,-15,-30,-26,-43,-105,-165,-176,-184,-266,-378,-372,-200},
            {-8,-27,6,32,-17,-68,-15,69,24,-92,-65,82,72,-113,-112,122,92,-79,1217,5250,9829,9713,2036,-9061,-15367,-13003,-6428,-2795,-3527,-3565,1359,9208,14426,14298,10760,7145,5617,7488,12964,19037,19871,12114,-420,-9664,-11476,-9358,-9314,-12547,-14730,-11747,-4434,2484,4883,2253,-2677,-6383,-6986,-5135,-2813,-1251,-177,993,1877,1614,303,-839,-966,-673,-1138,-2418,-3113,-1867,999,3598,4179,2644,413,-983,-1037,-224,719,1268,1176,508,-334,-893,-1086,-1235,-1593,-1985,-1997,-1438,-548,164,269,-265,-975,-1238,-835,-161,230,202,58,69,198,278,272,259,306,414,523,523,345,84,-44,49,195,161,-75,-334,-466,-468,-407,-341,-330,-422,-574,-655,-579,-404,-269,-246,-278,-253,-117,70,174,114,-43,-138,-83,48,117,63,-65,-193,-279,-311,-291,-240,-185,-131,-76,-48,-82,-166,-217,-173,-70,1,0,-30,-33,-3,28,38,30,11,-14,-25,-4,34,49,12,-67,-157,-232,-267,-225,-103,22,24,-163,-474,-747,-855,-800,-674,-549,-406,-186,105,363,479,453,393,392,443,467,413,290,135,-32,-210,-399,-603,-824,-1050,-1203,-1162,-851,-345,139,395,385,238,99,6,-71,-121,-94,5,96,117,106,147,262,395,484,516,508,470,398,290,159,38,-46,-103,-184,-321,-476,-578,-602,-586,-565,-533,-482,-436,-418,-405,-349,-249,-157,-108,-79,-40}
        },
        {    // H-30e036a.wav
            {-1,-2,-2,-1,-2,-3,-2,-1,-1,-2,-2,-2,-4,-5,-2,0,-2,-5,-3,2,1,-4,-5,2,2,-9,-13,0,8,-6,-17,0,20,5,-19,-4,13,-2,151,846,2055,2916,2292,47,-2453,-3502,-2783,-1617,-1379,-1942,-1975,-594,1691,3649,4543,4488,3971,3465,3405,4033,5019,5475,4698,2923,1171,304,264,233,-532,-1993,-3331,-3633,-2713,-1331,-557,-849,-1757,-2499,-2702,-2545,-2335,-2162,-1960,-1722,-1511,-1309,-985,-448,211,765,1050,1117,1173,1357,1590,1674,1531,1281,1092,1001,908,718,419,48,-350,-723,-1008,-1178,-1274,-1384,-1561,-1760,-1853,-1722,-1374,-962,-661,-516,-425,-269,-40,181,329,412,477,549,615,640,605,540,507,536,583,566,457,303,160,38,-83,-205,-303,-365,-408,-456,-520,-586,-640,-681,-708,-715,-688,-629,-564,-519,-483,-412,-285,-140,-33,21,53,92,141,190,232,257,250,208,154,119,105,88,54,16,-7,-16,-24,-42,-65,-88,-115,-158,-212,-261,-294,-318,-344,-371,-386,-376,-345,-313,-304,-333,-394,-451,-465,-429,-365,-289,-192,-61,87,211,281,295,273,235,187,127,50,-37,-123,-197,-259,-306,-335,-355,-383,-415,-415,-353,-251,-158,-101,-69,-46,-33,-36,-54,-84,-121,-151,-152,-125,-95,-79,-64,-33,9,48,75,79,51,6,-16,-5,-4,-47,-99,-114,-119,-174,-254,-255,-139},
            {-20,35,24,-54,-64,32,73,-33,-111,-1,111,-7,-157,-13,172,-44,115,2561,7481,11028,7982,-2102,-12694,-16153,-11644,-5468,-3221,-3591,-1315,5282,12141,14632,12455,8727,6404,7127,11652,18442,22284,17665,5159,-7496,-12800,-11152,-9266,-11461,-14840,-13721,-6867,1212,5190,3580,-1158,-5488,-7237,-6327,-4154,-2225,-993,21,1035,1408,544,-994,-1896,-1618,-971,-955,-1387,-1129,400,2355,3295,2665,1211,66,-252,83,685,1202,1277,721,-183,-850,-1020,-1035,-1359,-1964,-2356,-2117,-1283,-300,257,46,-723,-1347,-1247,-550,85,229,72,16,134,212,149,84,164,371,586,695,622,377,114,20,113,212,149,-53,-247,-335,-333,-306,-319,-412,-567,-695,-700,-580,-431,-357,-367,-363,-245,-26,148,132,-54,-227,-224,-63,97,135,61,-44,-127,-185,-227,-253,-246,-192,-99,-18,-14,-100,-201,-225,-152,-49,7,4,-11,-6,11,18,8,-7,-14,-9,8,24,15,-32,-99,-154,-189,-219,-238,-207,-104,14,30,-138,-438,-711,-821,-758,-624,-500,-365,-149,140,385,479,438,376,377,425,450,407,296,140,-36,-216,-400,-600,-826,-1055,-1208,-1165,-850,-332,166,418,378,189,13,-99,-170,-199,-155,-53,38,81,124,233,402,556,628,616,563,502,428,317,176,53,-11,-51,-146,-324,-510,-611,-616,-594,-592,-592,-559,-497,-431,-364,-284,-196,-129,-98,-81,-55,-22}
        },
        {    // H-30e042a.wav
            {1,1,1,-1,-2,0,0,-2,-3,-1,0,-1,-2,-2,-3,-3,-1,2,0,-4,-2,4,4,-4,-6,2,5,-5,-11,0,11,2,-10,0,17,7,-13,-2,15,-5,96,657,1719,2585,2215,344,-1939,-3083,-2621,-1575,-1200,-1551,-1576,-477,1385,2996,3749,3768,3453,3115,3031,3444,4233,4780,4445,3231,1821,923,632,430,-260,-1508,-2757,-3245,-2672,-1533,-733,-811,-1542,-2298,-2669,-2671,-2468,-2131,-1698,-1295,-1045,-891,-625,-125,482,923,1033,895,774,874,1164,1425,1476,1325,1111,935,790,615,373,60,-302,-659,-939,-1109,-1208,-1313,-1456,-1587,-1601,-1424,-1080,-699,-431,-329,-313,-261,-124,51,191,269,310,353,409,461,484,477,465,464,451,390,281,165,79,15,-55,-138,-219,-287,-347,-405,-458,-506,-554,-600,-630,-634,-618,-597,-574,-539,-478,-385,-268,-150,-56,0,30,61,104,148,175,183,181,176,167,150,122,88,61,52,56,50,18,-35,-89,-131,-166,-202,-238,-269,-289,-306,-325,-347,-363,-359,-333,-310,-319,-357,-387,-377,-336,-289,-243,-180,-87,21,117,179,200,188,156,118,78,30,-32,-107,-181,-235,-257,-251,-238,-244,-267,-282,-269,-231,-186,-149,-122,-101,-80,-62,-61,-87,-131,-173,-196,-198,-180,-143,-98,-58,-23,19,63,82,65,37,27,24,3,-27,-42,-52,-90,-145,-153,-86},
            {32,-17,-70,-24,68,43,-83,-91,60,101,-78,-147,83,152,-144,531,4004,9270,11377,5791,-5691,-15197,-16346,-10668,-4991,-3138,-2385,1510,8144,13088,13388,10350,7318,6879,10282,16903,22777,21883,11810,-2192,-11366,-12319,-9894,-10383,-13786,-14665,-9583,-1360,4252,4272,193,-4497,-7144,-6988,-4965,-2795,-1626,-1236,-768,-86,108,-512,-1258,-1326,-882,-709,-949,-794,401,2116,3109,2741,1555,548,209,385,795,1244,1417,941,-116,-1084,-1358,-1111,-1053,-1538,-2184,-2387,-1937,-1092,-315,-39,-408,-1046,-1281,-829,-133,181,48,-81,62,272,279,150,117,235,398,541,646,643,482,268,163,169,134,-17,-191,-266,-241,-198,-206,-312,-527,-773,-894,-803,-585,-426,-413,-459,-409,-207,43,162,74,-112,-200,-107,64,150,101,-5,-76,-95,-102,-127,-172,-209,-205,-155,-103,-101,-147,-184,-173,-137,-120,-121,-103,-49,17,63,77,61,22,-15,-20,11,36,2,-80,-151,-175,-177,-194,-215,-188,-89,22,34,-128,-420,-691,-800,-732,-596,-481,-357,-139,163,411,488,422,343,342,395,420,365,241,88,-66,-223,-402,-612,-839,-1044,-1158,-1085,-765,-271,180,384,311,105,-78,-193,-261,-277,-219,-113,-22,37,121,285,503,681,746,706,620,537,452,337,196,76,9,-42,-146,-326,-513,-622,-643,-631,-630,-629,-593,-517,-420,-322,-233,-163,-121,-101,-81,-50,-17,0}
        },
        {    // H-30e048a.wav
            {3,1,0,0,1,0,0,0,0,-1,-1,0,1,1,1,0,-1,-1,1,2,0,-2,1,7,6,-1,-3,4,9,0,-8,1,13,7,-7,-1,15,10,-8,-2,12,-7,64,523,1447,2274,2079,533,-1512,-2686,-2437,-1518,-1027,-1166,-1173,-374,1034,2319,3019,3198,3087,2850,2700,2928,3568,4172,4158,3398,2344,1535,1067,583,-290,-1523,-2637,-3037,-2504,-1440,-613,-557,-1193,-2009,-2542,-2645,-2388,-1882,-1267,-745,-474,-423,-385,-179,183,526,687,667,623,721,978,1249,1372,1302,1112,889,673,458,220,-71,-405,-708,-883,-915,-895,-930,-1040,-1153,-1182,-1079,-865,-625,-457,-402,-403,-366,-256,-117,-4,76,154,240,313,343,328,295,279,290,298,263,186,110,68,44,-1,-78,-162,-232,-287,-337,-387,-437,-487,-530,-555,-561,-557,-548,-529,-488,-421,-331,-230,-135,-65,-27,-10,2,20,46,78,109,133,148,156,155,138,100,56,28,21,16,-3,-33,-65,-99,-142,-191,-233,-257,-270,-288,-317,-344,-354,-346,-334,-330,-332,-326,-303,-264,-219,-174,-124,-60,13,72,97,88,65,49,42,32,7,-42,-110,-181,-230,-240,-216,-182,-162,-167,-190,-216,-228,-222,-201,-171,-132,-89,-61,-65,-99,-147,-193,-227,-237,-211,-158,-105,-71,-43,-4,40,68,74,66,50,28,8,-1,-11,-42,-81,-88,-49},
            {-12,-69,-18,72,31,-96,-77,83,89,-112,-135,128,127,-189,809,4859,10288,11572,4579,-7720,-16790,-16863,-10498,-4643,-2386,-768,3581,9385,12611,11642,8700,7025,8522,13500,20150,23844,19656,7689,-5355,-12139,-11982,-10427,-11693,-13762,-11916,-5337,1657,4350,1952,-2735,-6416,-7483,-6262,-4222,-2795,-2331,-2077,-1339,-409,-85,-506,-984,-980,-741,-722,-729,-85,1375,2858,3369,2733,1649,845,491,451,688,1103,1240,635,-509,-1398,-1572,-1419,-1578,-2084,-2404,-2164,-1511,-843,-475,-556,-962,-1248,-987,-290,248,249,-17,-71,147,328,314,260,312,414,486,559,642,631,467,263,168,162,111,-43,-230,-362,-403,-361,-298,-326,-509,-756,-893,-839,-686,-580,-552,-505,-335,-67,150,173,19,-136,-131,22,172,201,127,33,-29,-59,-80,-114,-168,-217,-214,-157,-111,-139,-217,-263,-238,-182,-145,-131,-113,-85,-59,-30,14,61,82,77,73,83,73,10,-84,-149,-155,-130,-120,-131,-123,-56,39,56,-104,-418,-718,-832,-748,-600,-487,-361,-122,199,443,493,400,306,296,343,373,337,237,96,-62,-234,-431,-652,-870,-1036,-1088,-962,-630,-172,220,364,239,-12,-223,-328,-349,-313,-226,-111,-17,42,121,284,520,732,824,785,686,594,509,390,232,86,-6,-72,-173,-327,-482,-581,-622,-639,-651,-645,-599,-511,-396,-277,-179,-122,-105,-100,-78,-40,-10,0,-1}
        },
        {    // H-30e054a.wav
            {1,2,1,0,0,0,0,0,0,0,0,0,0,0,1,0,-1,0,0,-2,-2,1,3,2,2,4,4,0,0,5,5,-3,-7,3,10,0,-11,-1,16,10,-9,-4,10,-1,63,453,1235,1945,1817,558,-1168,-2244,-2152,-1407,-880,-839,-814,-293,692,1706,2413,2754,2781,2574,2362,2494,3100,3837,4113,3620,2589,1524,735,136,-540,-1380,-2127,-2360,-1891,-1017,-356,-368,-1008,-1824,-2335,-2329,-1890,-1271,-750,-500,-509,-604,-587,-375,-30,309,520,584,597,689,893,1107,1197,1119,923,669,382,94,-136,-259,-285,-267,-261,-307,-430,-623,-831,-981,-1025,-965,-835,-687,-572,-511,-484,-448,-377,-274,-157,-42,55,123,156,159,139,113,105,126,156,161,135,106,93,80,38,-35,-115,-180,-231,-272,-306,-339,-382,-432,-471,-486,-482,-469,-449,-413,-358,-293,-230,-177,-139,-118,-104,-83,-47,-4,31,54,70,87,102,103,82,46,19,19,37,47,34,5,-25,-59,-104,-158,-207,-247,-288,-331,-362,-367,-352,-332,-316,-295,-264,-226,-190,-158,-125,-87,-47,-13,8,13,3,-14,-29,-36,-42,-58,-93,-142,-187,-210,-203,-175,-143,-123,-130,-164,-208,-237,-239,-221,-191,-154,-116,-93,-97,-125,-161,-189,-199,-192,-175,-154,-131,-103,-66,-24,17,48,62,54,33,18,15,10,-16,-50,-60,-35},
            {-59,3,75,21,-104,-82,84,99,-110,-152,121,151,-194,730,4847,10581,12125,4912,-8094,-17805,-17917,-11001,-4391,-1503,422,4523,9463,11672,10289,7855,7204,9602,14994,21438,24274,18903,6194,-6635,-12686,-12185,-10795,-11810,-12579,-9209,-2431,2994,3603,171,-4207,-7155,-7914,-6815,-4899,-3426,-2843,-2408,-1330,0,477,-187,-1093,-1373,-1146,-924,-579,475,2201,3635,3858,2944,1717,845,462,507,915,1362,1252,319,-934,-1718,-1837,-1805,-2084,-2522,-2643,-2243,-1522,-835,-503,-684,-1163,-1371,-908,-53,493,419,92,8,208,411,486,533,597,599,529,508,578,611,501,321,196,122,8,-172,-350,-473,-538,-544,-503,-486,-572,-739,-850,-811,-683,-600,-586,-525,-314,-14,185,169,13,-96,-48,101,218,227,152,60,3,-14,-26,-73,-155,-218,-211,-159,-142,-199,-283,-322,-300,-255,-214,-169,-120,-94,-103,-115,-90,-29,37,90,141,186,189,123,15,-76,-114,-110,-96,-88,-65,1,89,103,-66,-406,-742,-880,-795,-635,-520,-402,-167,166,426,484,385,276,247,274,297,282,227,137,8,-171,-403,-660,-885,-1017,-1017,-859,-539,-124,225,339,181,-115,-366,-479,-470,-386,-253,-106,4,62,130,289,532,753,849,814,724,639,551,425,269,126,17,-84,-213,-363,-493,-575,-611,-623,-623,-609,-569,-494,-383,-257,-153,-99,-92,-92,-69,-29,4,14,8,1}
        },
        {    // H-30e060a.wav
            {0,0,1,1,1,1,1,1,1,0,0,1,2,2,0,-1,-1,0,1,1,0,0,2,3,3,3,4,5,4,1,1,3,2,-2,-2,4,7,2,-3,2,9,5,-2,3,6,5,99,459,1082,1589,1433,443,-883,-1742,-1747,-1219,-763,-631,-577,-244,432,1227,1894,2328,2529,2546,2496,2549,2799,3127,3252,2957,2264,1412,657,92,-366,-827,-1251,-1442,-1241,-745,-299,-247,-659,-1294,-1798,-1936,-1696,-1245,-814,-575,-554,-632,-637,-458,-119,240,464,509,477,522,686,854,868,693,439,246,175,198,256,295,278,191,45,-143,-359,-586,-788,-920,-960,-921,-833,-725,-625,-555,-521,-504,-469,-390,-273,-158,-87,-70,-74,-67,-46,-22,8,55,108,136,131,123,131,131,89,12,-57,-96,-125,-171,-228,-276,-312,-349,-386,-404,-395,-376,-369,-374,-369,-338,-292,-252,-226,-200,-161,-116,-83,-62,-37,-2,28,39,37,43,61,78,85,87,90,85,60,18,-23,-58,-99,-158,-225,-280,-317,-341,-355,-348,-314,-266,-224,-194,-165,-132,-105,-97,-102,-98,-77,-54,-47,-55,-63,-66,-73,-91,-113,-132,-152,-176,-192,-183,-148,-110,-95,-113,-153,-201,-247,-279,-280,-242,-177,-116,-83,-82,-100,-122,-143,-158,-163,-158,-145,-126,-101,-71,-39,-7,17,26,19,10,10,10,-4,-27,-36,-21},
            {-41,71,70,-78,-122,52,144,-62,-203,60,226,-148,344,4073,10265,13104,6795,-6878,-18418,-19783,-12404,-4312,-508,1094,4340,8831,11106,9812,7267,6635,9531,15728,22682,25292,19131,5689,-7372,-13264,-12549,-10864,-11157,-10814,-6704,-333,3722,3033,-869,-5127,-8038,-8988,-7883,-5551,-3611,-2911,-2594,-1470,140,812,26,-1179,-1660,-1408,-967,-319,928,2546,3649,3699,3022,2186,1373,645,376,856,1608,1647,576,-939,-1981,-2350,-2490,-2712,-2866,-2713,-2251,-1619,-978,-581,-673,-1120,-1349,-936,-139,405,434,271,288,463,582,617,683,770,760,658,601,622,586,417,238,187,196,82,-195,-491,-662,-700,-666,-609,-579,-642,-798,-923,-887,-716,-564,-510,-454,-266,8,175,128,-32,-116,-46,105,226,265,230,149,65,17,8,-8,-67,-133,-149,-123,-131,-218,-336,-399,-381,-328,-285,-247,-202,-167,-163,-169,-141,-71,12,83,148,210,242,214,135,50,-3,-21,-28,-41,-40,12,114,173,52,-279,-662,-873,-843,-705,-600,-499,-277,66,361,448,357,245,215,236,240,215,187,157,84,-73,-315,-594,-829,-950,-926,-762,-480,-128,184,313,184,-129,-447,-628,-639,-520,-328,-131,5,67,132,289,534,756,855,831,756,680,594,478,340,203,71,-74,-241,-403,-521,-577,-591,-593,-592,-570,-517,-439,-347,-248,-156,-98,-81,-79,-58,-14,26,45,45,35,18}
        },
        {    // H-30e066a.wav
            {0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,2,2,1,1,2,2,2,2,2,2,2,2,3,3,2,0,-1,0,1,4,6,4,-2,-5,-1,6,9,7,0,-3,33,186,515,935,1176,953,241,-625,-1187,-1245,-980,-720,-608,-513,-223,342,1084,1816,2343,2524,2353,2015,1797,1886,2226,2565,2638,2328,1707,977,345,-89,-358,-524,-568,-425,-148,25,-155,-702,-1345,-1750,-1771,-1501,-1136,-836,-675,-643,-660,-613,-440,-182,52,181,210,200,213,273,377,503,617,683,686,640,572,502,429,345,237,87,-122,-380,-635,-821,-905,-901,-844,-762,-678,-615,-592,-602,-613,-593,-531,-444,-358,-289,-240,-201,-164,-122,-70,-2,74,137,169,174,172,173,165,131,72,6,-53,-101,-138,-167,-194,-230,-275,-314,-338,-355,-380,-410,-426,-414,-381,-341,-300,-257,-215,-185,-166,-142,-101,-49,-5,22,41,63,85,97,96,93,97,102,92,61,15,-42,-107,-173,-225,-255,-269,-281,-290,-285,-257,-214,-175,-149,-136,-129,-128,-132,-136,-132,-117,-98,-84,-79,-82,-90,-102,-118,-135,-151,-167,-181,-185,-172,-143,-116,-112,-140,-189,-238,-271,-283,-272,-236,-182,-121,-71,-47,-54,-78,-104,-123,-137,-145,-141,-128,-113,-96,-70,-34,-5,5,-1,-7,-11,-20,-33,-36,-21},
            {10,77,-10,-128,-30,151,46,-209,-86,251,29,-128,2379,8501,13631,10419,-2600,-17043,-22113,-15659,-5475,386,1692,3288,7157,10323,9864,7034,5727,8646,15479,22980,25982,20398,7389,-6183,-13412,-13539,-11196,-9944,-8667,-4904,481,3835,2992,-840,-5180,-8491,-10032,-9268,-6612,-3850,-2587,-2495,-2037,-726,315,120,-794,-1326,-1215,-878,-338,782,2315,3403,3510,2987,2377,1718,956,555,1009,1887,2038,919,-761,-1953,-2418,-2651,-2990,-3249,-3136,-2623,-1863,-1070,-577,-676,-1211,-1549,-1195,-352,342,541,441,375,433,548,706,916,1074,1057,908,790,746,645,398,129,26,87,118,-40,-345,-638,-809,-850,-814,-774,-803,-907,-992,-943,-769,-603,-527,-459,-272,2,180,144,-22,-136,-102,38,192,291,306,240,143,77,60,53,23,-14,-33,-52,-121,-249,-384,-462,-467,-427,-375,-325,-282,-258,-250,-235,-190,-114,-24,70,163,243,281,262,199,126,72,46,38,25,4,14,97,206,189,-71,-486,-808,-875,-764,-655,-588,-436,-130,198,349,293,184,159,201,214,178,154,169,161,41,-207,-514,-771,-891,-846,-665,-402,-107,157,287,188,-122,-488,-730,-770,-643,-431,-215,-64,7,68,220,471,713,834,832,783,731,653,531,393,275,163,14,-186,-391,-536,-595,-592,-572,-558,-537,-487,-408,-315,-225,-149,-101,-86,-83,-60,-10,38,59,58,54,45,24}
        },
        {    // H-30e072a.wav
            {1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,3,3,5,6,5,4,4,5,5,3,3,5,5,3,3,6,8,5,1,4,10,10,2,-4,0,8,12,13,12,5,10,83,278,561,784,778,491,42,-379,-652,-783,-826,-781,-586,-204,298,773,1112,1312,1441,1544,1614,1639,1665,1780,2030,2350,2561,2462,1975,1240,570,243,298,510,581,364,-70,-547,-934,-1189,-1327,-1374,-1352,-1272,-1139,-974,-821,-724,-681,-644,-572,-471,-376,-294,-189,-19,218,486,731,907,980,946,835,695,564,456,368,286,179,9,-233,-497,-701,-790,-778,-725,-686,-685,-715,-758,-792,-794,-755,-684,-602,-522,-443,-366,-298,-239,-175,-89,14,102,151,165,171,184,196,194,173,138,93,40,-11,-51,-84,-124,-178,-234,-277,-308,-344,-391,-435,-454,-442,-408,-365,-321,-281,-248,-223,-196,-160,-114,-69,-33,-3,27,57,82,98,109,119,123,113,88,52,6,-50,-111,-166,-201,-216,-221,-222,-219,-205,-183,-165,-160,-166,-169,-160,-144,-131,-123,-117,-111,-109,-113,-120,-125,-124,-122,-124,-135,-153,-177,-204,-224,-225,-205,-176,-154,-149,-165,-193,-220,-235,-234,-213,-170,-111,-57,-26,-23,-39,-67,-103,-138,-156,-153,-137,-118,-94,-62,-32,-16,-17,-27,-39,-53,-62,-53,-27},
            {64,42,-102,-119,93,170,-105,-247,111,280,-206,520,5150,12087,13994,4864,-11410,-22762,-20954,-9881,-115,2980,2878,4678,8162,9568,7693,5677,7360,13535,21341,25851,22757,11698,-2334,-12284,-14839,-12457,-9373,-6881,-3627,641,3699,3412,125,-4181,-7936,-10295,-10456,-8176,-4857,-2755,-2623,-2960,-2113,-400,545,26,-1028,-1459,-1073,-249,815,1985,2851,3084,2891,2621,2163,1295,478,577,1618,2426,1896,241,-1415,-2362,-2765,-2999,-3115,-3022,-2759,-2366,-1800,-1174,-850,-1022,-1362,-1324,-765,-60,379,478,412,347,387,607,978,1306,1387,1228,1030,931,843,605,235,-46,-78,41,61,-149,-488,-770,-903,-914,-884,-898,-999,-1128,-1141,-967,-709,-531,-448,-331,-114,87,124,5,-118,-125,-11,161,318,393,354,238,141,119,134,121,69,21,-8,-58,-170,-329,-470,-539,-530,-471,-394,-330,-305,-314,-320,-279,-185,-70,36,134,229,300,316,272,197,133,102,100,97,69,38,70,182,265,153,-195,-604,-835,-823,-712,-640,-564,-360,-44,198,230,130,79,134,194,177,136,158,216,182,-27,-357,-668,-839,-828,-663,-405,-111,165,341,308,25,-403,-767,-911,-826,-602,-349,-155,-55,-4,105,329,597,778,821,786,746,698,605,477,361,267,148,-43,-281,-483,-581,-581,-547,-531,-523,-483,-396,-290,-195,-127,-90,-85,-88,-67,-16,27,33,21,26,48,54,29}
        },
        {    // H-30e078a.wav
            {0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,3,3,2,1,1,2,2,1,0,0,0,0,-1,0,2,3,3,2,2,1,0,2,6,8,3,-2,0,6,7,4,6,8,5,33,156,377,568,566,354,90,-68,-133,-218,-338,-379,-277,-141,-112,-159,-92,208,658,1093,1437,1712,1917,2008,2002,2019,2166,2392,2505,2342,1910,1372,919,640,479,286,-54,-515,-948,-1204,-1249,-1172,-1094,-1087,-1147,-1213,-1211,-1113,-969,-869,-857,-875,-812,-590,-224,201,582,846,971,987,949,898,838,748,618,465,322,206,101,-21,-175,-344,-496,-608,-674,-708,-733,-773,-833,-894,-923,-902,-842,-764,-679,-589,-498,-413,-336,-258,-173,-85,-2,72,129,160,166,163,170,183,187,171,143,110,70,14,-56,-131,-201,-264,-317,-355,-377,-385,-387,-386,-383,-374,-360,-340,-313,-276,-232,-189,-156,-133,-110,-79,-43,-9,21,55,96,134,153,145,114,68,15,-36,-76,-103,-126,-154,-186,-208,-211,-198,-180,-163,-151,-147,-153,-163,-166,-154,-132,-116,-114,-124,-136,-147,-157,-166,-171,-170,-171,-183,-207,-236,-262,-278,-277,-250,-199,-142,-106,-105,-131,-162,-179,-178,-158,-123,-83,-53,-44,-54,-75,-100,-127,-143,-141,-128,-112,-98,-85,-74,-68,-66,-67,-74,-85,-88,-69,-32},
            {101,-5,-172,-81,188,138,-232,-219,270,223,-336,1313,7344,14020,12828,-79,-17017,-24855,-18459,-5471,3120,4356,3396,4771,7350,7960,6671,6716,10576,17459,23729,24843,18070,5150,-7873,-14961,-14814,-10807,-6583,-2962,648,3569,4071,1629,-2404,-6358,-9341,-10702,-9743,-6813,-3868,-2804,-3344,-3493,-2108,-202,570,-62,-1015,-1320,-845,172,1474,2612,3090,2919,2588,2285,1671,715,214,866,2095,2497,1437,-322,-1680,-2340,-2667,-2898,-2955,-2794,-2515,-2156,-1712,-1343,-1274,-1438,-1456,-1068,-432,93,322,320,244,239,418,796,1221,1467,1437,1251,1104,1050,961,688,277,-48,-126,-48,-56,-273,-601,-856,-952,-934,-909,-972,-1133,-1279,-1256,-1036,-754,-542,-387,-210,-24,69,22,-85,-140,-87,67,278,457,506,415,277,197,183,171,123,56,-5,-64,-140,-238,-347,-451,-528,-549,-505,-422,-353,-338,-360,-360,-294,-170,-32,87,183,252,280,267,232,205,195,194,185,152,97,67,125,246,282,83,-315,-688,-833,-777,-692,-651,-550,-297,1,141,82,-6,33,151,202,162,146,216,265,143,-165,-525,-775,-831,-702,-455,-168,103,309,373,214,-163,-604,-899,-938,-772,-532,-324,-190,-108,-7,178,436,672,794,798,747,689,621,532,440,363,276,129,-92,-333,-509,-573,-555,-520,-503,-480,-415,-306,-188,-98,-60,-74,-107,-109,-59,8,35,14,-10,0,28,36,19}
        },
        {    // H-30e084a.wav
            {0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,3,3,2,1,1,1,1,0,-1,-1,-1,-1,1,3,3,0,-3,-2,3,6,4,2,4,10,11,4,-4,-6,-2,4,9,13,29,91,223,381,440,313,98,35,245,522,491,9,-647,-1049,-1027,-748,-423,-68,412,995,1518,1857,2033,2125,2175,2220,2345,2602,2870,2883,2457,1672,826,214,-51,-67,-43,-165,-482,-885,-1190,-1287,-1216,-1115,-1097,-1180,-1307,-1406,-1426,-1339,-1146,-879,-579,-264,77,444,782,1009,1079,1026,924,827,739,643,531,403,265,131,16,-76,-168,-283,-421,-556,-671,-766,-843,-890,-900,-888,-878,-874,-853,-794,-703,-598,-493,-389,-291,-207,-139,-78,-19,34,71,93,115,148,187,218,229,215,178,119,45,-34,-109,-177,-239,-294,-336,-358,-362,-354,-342,-329,-317,-311,-313,-317,-313,-294,-263,-226,-185,-141,-97,-61,-33,-9,18,50,85,119,146,155,137,92,31,-30,-80,-116,-142,-162,-177,-184,-185,-183,-179,-171,-162,-153,-145,-136,-125,-118,-121,-133,-147,-160,-173,-186,-200,-214,-228,-239,-247,-253,-264,-281,-295,-291,-261,-208,-147,-95,-63,-51,-54,-64,-78,-91,-99,-101,-100,-100,-103,-110,-121,-132,-134,-123,-108,-99,-97,-98,-101,-109,-115,-111,-101,-97,-93,-73,-34},
            {126,-39,-214,-45,253,110,-313,-189,379,184,-418,1762,8507,14863,11872,-2904,-19807,-25498,-16712,-2871,5083,5344,3603,4131,5918,6611,6673,8484,13169,19332,23767,22783,14446,1108,-10970,-16189,-14074,-8587,-3485,381,3419,4942,3726,14,-4408,-7950,-10040,-10390,-8753,-5871,-3629,-3283,-3946,-3671,-1909,-79,344,-492,-1336,-1350,-565,665,1966,2868,3074,2831,2578,2227,1375,280,-21,983,2349,2585,1293,-586,-1979,-2609,-2738,-2600,-2345,-2168,-2132,-2048,-1765,-1470,-1442,-1605,-1579,-1150,-505,22,265,263,163,144,357,792,1242,1469,1413,1231,1117,1101,1031,774,395,102,5,-12,-137,-405,-689,-868,-925,-915,-920,-1018,-1211,-1367,-1327,-1085,-793,-570,-385,-175,12,69,-18,-143,-189,-104,97,345,530,566,470,342,261,220,170,92,1,-77,-136,-188,-251,-335,-426,-493,-512,-482,-420,-361,-337,-346,-345,-288,-175,-46,67,160,234,274,271,243,218,209,212,210,179,124,101,171,294,304,59,-371,-739,-863,-800,-723,-677,-546,-275,-6,74,-21,-92,-14,122,176,157,184,282,313,139,-212,-571,-776,-766,-579,-306,-33,193,337,331,108,-305,-731,-959,-917,-709,-490,-341,-251,-167,-37,168,421,644,764,773,717,646,577,509,441,369,271,120,-82,-290,-443,-515,-530,-520,-491,-427,-332,-229,-139,-78,-64,-101,-149,-151,-92,-27,-13,-41,-55,-28,11,25,14}
        },
        {    // H-30e090a.wav
            {0,0,0,0,0,0,0,1,1,1,1,1,2,3,3,3,3,2,2,2,3,3,2,0,0,1,1,0,-1,-1,1,3,3,1,-1,-1,2,5,5,3,3,5,7,8,9,9,2,-8,-10,3,15,9,3,38,132,264,407,556,678,676,452,32,-427,-776,-976,-1044,-946,-628,-145,341,725,1057,1438,1851,2194,2438,2671,2931,3085,2943,2483,1891,1373,981,636,280,-43,-250,-314,-301,-333,-503,-808,-1135,-1341,-1367,-1285,-1234,-1296,-1438,-1537,-1465,-1158,-661,-111,333,593,714,806,931,1056,1094,998,799,579,404,290,214,144,60,-42,-163,-298,-435,-559,-658,-734,-794,-843,-880,-896,-881,-835,-777,-727,-683,-621,-521,-400,-295,-227,-182,-135,-82,-32,12,59,107,143,157,161,171,181,168,122,58,-6,-73,-152,-235,-299,-333,-343,-342,-331,-309,-286,-277,-285,-299,-308,-309,-304,-286,-246,-189,-134,-97,-73,-48,-15,21,52,78,101,119,128,126,113,85,41,-12,-61,-99,-128,-156,-186,-215,-234,-235,-216,-179,-138,-109,-102,-112,-127,-140,-155,-175,-198,-217,-234,-246,-255,-260,-264,-271,-286,-303,-309,-295,-264,-225,-181,-130,-75,-25,14,38,42,23,-15,-58,-96,-128,-153,-169,-173,-164,-147,-131,-122,-121,-122,-118,-113,-116,-127,-130,-117,-97,-87,-83,-66,-32},
            {139,-36,-234,-60,272,135,-332,-225,404,243,-497,1456,8182,14869,12280,-2464,-19776,-25879,-17008,-2572,5961,6189,3677,3191,4478,5615,6783,9552,14337,19696,23002,21220,12659,-446,-11960,-16290,-13075,-6661,-1212,2375,4807,5656,3715,-750,-5649,-9013,-10327,-9885,-8031,-5549,-3855,-3752,-4287,-3768,-1896,-146,109,-850,-1719,-1671,-761,660,2187,3235,3377,2888,2421,2088,1436,483,108,926,2212,2543,1368,-532,-2066,-2796,-2880,-2579,-2134,-1791,-1648,-1569,-1451,-1424,-1616,-1835,-1724,-1194,-546,-126,-13,-52,-48,109,430,831,1168,1322,1279,1145,1062,1069,1049,857,518,232,129,111,-25,-330,-668,-888,-952,-918,-885,-962,-1173,-1385,-1402,-1175,-848,-573,-363,-163,1,42,-60,-204,-257,-150,93,369,554,584,499,393,314,246,164,66,-28,-107,-167,-216,-269,-337,-408,-453,-457,-421,-365,-321,-318,-347,-358,-300,-180,-44,74,167,231,254,241,220,208,204,203,203,191,154,127,176,281,288,51,-371,-729,-840,-769,-701,-676,-565,-307,-56,-1,-109,-167,-57,109,181,184,241,353,361,142,-231,-566,-722,-673,-475,-213,31,208,295,246,8,-391,-781,-960,-875,-652,-456,-345,-275,-190,-60,123,348,568,714,751,706,637,584,540,477,379,252,110,-41,-194,-334,-441,-505,-521,-485,-398,-284,-179,-105,-70,-78,-126,-183,-196,-152,-97,-84,-102,-95,-43,19,43,25}
        },
        {    // H-30e096a.wav
            {0,0,1,1,1,1,1,1,1,1,2,2,2,3,4,5,4,4,4,4,3,2,2,3,3,2,0,-1,0,1,3,4,2,0,1,5,6,3,1,3,6,7,6,8,11,10,8,9,6,-7,-16,-6,7,1,38,256,691,1102,1106,549,-286,-921,-1112,-978,-755,-537,-296,-23,250,524,817,1091,1303,1543,1991,2656,3232,3336,2905,2250,1719,1374,1060,688,345,141,58,-14,-152,-341,-517,-621,-646,-662,-773,-1013,-1282,-1435,-1425,-1336,-1262,-1193,-1032,-708,-246,254,677,942,1035,1013,960,924,883,788,622,422,243,113,19,-68,-168,-277,-379,-471,-565,-669,-766,-824,-831,-810,-798,-800,-788,-736,-648,-557,-488,-441,-397,-337,-260,-178,-107,-58,-26,2,35,69,89,92,92,108,136,147,115,43,-46,-131,-200,-245,-267,-277,-291,-316,-342,-352,-344,-326,-306,-287,-265,-241,-218,-201,-186,-167,-137,-95,-44,6,45,66,73,75,78,80,78,78,85,93,86,54,3,-54,-109,-160,-208,-249,-274,-279,-261,-221,-166,-114,-88,-94,-123,-159,-190,-215,-236,-253,-260,-261,-265,-274,-281,-281,-279,-281,-279,-262,-232,-198,-161,-112,-49,18,71,99,99,71,22,-37,-96,-146,-181,-197,-196,-185,-170,-156,-147,-148,-151,-145,-129,-115,-108,-97,-73,-53,-58,-79,-78,-42},
            {124,24,-203,-134,219,224,-248,-334,289,411,-441,471,6184,13700,13958,1604,-16400,-25822,-19676,-5074,5500,7013,3990,2373,3272,4781,6346,9192,13865,19052,22257,20752,12938,532,-10944,-15724,-12659,-5797,82,3466,5327,5922,4123,-347,-5631,-9334,-10563,-9875,-8055,-5815,-4164,-3864,-4349,-4085,-2421,-516,50,-863,-1995,-2197,-1300,278,2013,3288,3618,3167,2613,2256,1710,800,238,811,2103,2703,1743,-238,-2036,-2942,-3004,-2588,-2068,-1718,-1580,-1455,-1223,-1080,-1274,-1672,-1827,-1493,-881,-386,-196,-218,-245,-108,246,726,1138,1316,1235,1027,881,891,966,918,680,394,236,193,92,-168,-503,-762,-877,-877,-847,-895,-1078,-1303,-1380,-1217,-922,-657,-456,-258,-68,12,-70,-230,-308,-210,38,325,528,578,503,389,304,248,185,91,-19,-113,-175,-219,-269,-330,-379,-399,-397,-383,-355,-317,-296,-307,-313,-261,-143,-8,97,166,202,205,177,145,136,151,175,189,169,114,72,119,246,302,126,-257,-623,-771,-729,-668,-657,-592,-392,-164,-87,-162,-204,-89,95,197,218,277,386,392,167,-214,-546,-682,-615,-423,-190,18,164,231,183,-32,-398,-766,-941,-862,-646,-456,-350,-281,-193,-71,87,280,483,636,696,675,630,605,589,534,413,251,102,-9,-107,-229,-368,-478,-516,-477,-388,-281,-184,-114,-85,-102,-157,-220,-246,-216,-163,-136,-141,-130,-71,8,48,34}
        },
        {    // H-30e102a.wav
            {0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,-1,-1,0,2,1,0,1,4,3,0,2,8,8,1,1,13,18,5,-7,-4,-10,-21,71,396,876,1158,905,164,-637,-1084,-1122,-962,-763,-502,-121,322,704,946,1050,1084,1187,1519,2087,2647,2876,2674,2241,1826,1489,1163,850,630,502,339,64,-221,-363,-362,-365,-478,-650,-773,-804,-768,-690,-609,-618,-801,-1102,-1311,-1238,-886,-426,-19,304,596,881,1107,1200,1129,930,693,516,442,420,347,162,-94,-322,-453,-502,-528,-570,-632,-704,-776,-833,-850,-814,-746,-688,-660,-646,-613,-542,-443,-336,-241,-169,-125,-103,-90,-76,-54,-24,12,51,83,100,97,73,33,-14,-53,-77,-94,-123,-174,-238,-301,-355,-393,-407,-396,-373,-352,-335,-311,-277,-238,-202,-164,-120,-74,-36,-12,4,22,44,64,74,73,68,61,53,46,46,53,59,55,38,8,-38,-103,-182,-254,-299,-313,-304,-280,-247,-212,-182,-159,-143,-142,-165,-210,-260,-297,-312,-304,-282,-257,-238,-227,-224,-228,-236,-238,-225,-195,-155,-108,-58,-9,29,54,66,64,39,-10,-72,-129,-172,-198,-206,-201,-197,-201,-206,-200,-185,-166,-146,-122,-99,-80,-60,-37,-27,-48,-83,-88,-49},
            {59,116,-86,-215,50,286,-29,-391,-2,505,-74,-399,3143,10642,14943,7837,-9105,-23292,-23278,-10619,2725,7545,5061,2015,2025,3812,5574,7840,11879,17222,21382,21252,14901,3456,-8298,-14504,-12776,-6068,483,4169,5608,5894,4549,799,-4384,-8684,-10593,-10311,-8742,-6588,-4615,-3744,-4104,-4483,-3559,-1580,-161,-366,-1592,-2437,-2095,-670,1288,3039,3866,3612,2905,2413,2050,1377,646,725,1799,2765,2357,550,-1520,-2802,-3094,-2765,-2237,-1805,-1588,-1481,-1311,-1120,-1132,-1389,-1598,-1470,-1072,-704,-535,-484,-402,-215,86,477,877,1155,1212,1068,865,768,808,851,747,517,326,266,232,61,-255,-567,-736,-754,-717,-751,-921,-1169,-1328,-1271,-1039,-783,-583,-405,-214,-76,-79,-198,-297,-249,-37,244,465,542,482,365,269,216,175,114,33,-48,-115,-178,-247,-319,-373,-393,-380,-341,-283,-228,-209,-234,-264,-238,-143,-15,96,167,190,165,111,62,37,33,44,71,97,88,62,103,246,366,268,-87,-496,-715,-712,-646,-627,-584,-420,-206,-117,-190,-257,-161,46,204,263,318,406,405,182,-205,-546,-680,-605,-414,-195,-6,122,177,140,-30,-342,-692,-898,-860,-656,-447,-322,-254,-186,-91,42,221,421,579,646,637,609,605,613,579,461,280,112,10,-53,-147,-291,-426,-485,-459,-388,-308,-230,-167,-138,-151,-192,-238,-262,-247,-203,-164,-152,-142,-95,-20,33,31}
        },
        {    // H-30e108a.wav
            {-1,0,0,0,1,2,2,1,1,2,3,2,1,1,1,2,3,4,4,3,2,2,2,2,1,0,0,2,3,2,-1,-1,2,2,-1,-2,1,3,1,0,6,8,0,-6,5,18,10,-6,5,25,5,7,230,756,1279,1260,474,-658,-1426,-1497,-1124,-732,-451,-143,274,689,967,1105,1191,1319,1583,2050,2632,3045,2991,2419,1573,804,348,247,369,485,423,205,6,-72,-143,-376,-742,-1006,-1005,-827,-677,-629,-590,-468,-296,-168,-147,-253,-467,-698,-777,-567,-101,435,849,1069,1123,1068,951,817,695,579,443,283,121,-35,-207,-412,-614,-746,-777,-747,-723,-732,-757,-780,-802,-821,-806,-728,-602,-481,-404,-361,-317,-254,-177,-99,-28,22,40,37,36,50,60,45,8,-23,-31,-26,-32,-56,-90,-132,-187,-257,-325,-371,-391,-401,-414,-424,-421,-405,-383,-353,-302,-228,-147,-84,-44,-12,28,71,101,114,117,116,107,87,63,43,24,2,-13,-5,28,59,59,27,-21,-74,-137,-213,-286,-333,-349,-344,-326,-293,-245,-201,-180,-187,-214,-250,-287,-313,-316,-291,-248,-206,-178,-164,-156,-152,-156,-166,-165,-144,-111,-82,-60,-39,-20,-13,-20,-27,-30,-40,-71,-119,-161,-184,-192,-199,-209,-217,-214,-200,-181,-163,-143,-117,-90,-72,-61,-41,-12,0,-26,-67,-77,-43},
            {-58,143,90,-188,-181,178,235,-214,-337,248,402,-410,337,5598,12738,13268,1892,-15141,-24332,-18599,-4406,5941,6952,3033,851,2150,4549,6501,9103,13635,18932,21565,18279,8735,-3330,-11948,-13101,-7754,-598,4265,6056,6062,4920,2110,-2334,-6898,-9806,-10539,-9699,-7958,-5828,-4135,-3711,-4309,-4526,-3336,-1384,-263,-693,-1866,-2450,-1763,12,2141,3689,4044,3441,2714,2321,1937,1288,914,1499,2639,2967,1686,-517,-2284,-2935,-2761,-2342,-2011,-1831,-1732,-1585,-1361,-1235,-1359,-1583,-1566,-1206,-776,-576,-610,-655,-538,-234,198,662,1020,1153,1054,850,717,741,842,838,641,377,253,301,326,140,-221,-547,-688,-672,-641,-723,-937,-1180,-1294,-1205,-986,-759,-571,-391,-223,-136,-167,-249,-257,-123,113,342,462,443,341,243,197,178,138,63,-22,-92,-146,-192,-233,-265,-290,-313,-317,-277,-198,-133,-133,-186,-220,-183,-89,12,89,127,111,46,-27,-66,-69,-55,-27,20,58,65,88,198,354,376,135,-267,-578,-668,-630,-604,-583,-467,-267,-131,-152,-233,-203,-32,155,259,314,372,367,180,-180,-530,-683,-612,-422,-226,-74,34,98,99,-5,-238,-543,-776,-815,-669,-463,-308,-224,-173,-116,-17,148,357,532,608,591,557,565,602,601,504,323,137,24,-22,-79,-203,-355,-451,-456,-408,-352,-299,-245,-202,-191,-214,-250,-272,-260,-221,-181,-161,-146,-107,-43,9,18}
        },
        {    // H-30e114a.wav
            {-1,-1,0,0,0,0,1,2,1,0,1,2,1,0,0,2,2,1,1,1,1,0,0,0,-1,-1,1,2,0,-2,0,4,2,-3,-4,-1,-2,-6,-1,8,5,-10,-11,9,17,-2,-9,19,27,-2,108,586,1310,1672,1099,-270,-1591,-2100,-1777,-1158,-642,-198,326,863,1223,1357,1377,1403,1534,1909,2598,3361,3681,3193,2065,878,128,-131,-176,-268,-433,-521,-421,-203,-81,-213,-546,-868,-1029,-1069,-1104,-1126,-995,-636,-185,125,192,123,90,151,225,214,118,38,87,297,598,867,1008,995,875,726,610,529,429,248,-21,-313,-543,-671,-724,-758,-809,-872,-916,-917,-877,-816,-752,-690,-626,-562,-502,-440,-364,-267,-164,-84,-37,-1,55,132,195,200,139,47,-23,-44,-28,-14,-33,-91,-169,-243,-293,-315,-320,-328,-355,-401,-451,-489,-503,-490,-453,-398,-330,-257,-187,-124,-70,-20,31,85,136,174,188,179,157,130,99,61,24,4,3,8,4,-6,-11,-6,-3,-16,-52,-109,-182,-262,-333,-378,-393,-388,-373,-349,-312,-270,-241,-240,-263,-293,-312,-310,-282,-231,-166,-107,-69,-56,-58,-66,-76,-86,-89,-79,-60,-50,-62,-92,-121,-139,-143,-137,-131,-133,-147,-170,-197,-222,-232,-223,-200,-176,-155,-136,-121,-114,-109,-95,-70,-45,-28,-16,-5,-4,-22,-46,-51,-29},
            {-109,20,147,4,-220,-97,228,147,-283,-231,341,249,-484,977,6749,12964,11376,-1253,-16971,-23098,-15205,-1436,6716,5818,1457,2,2288,5299,7348,9762,14067,18920,20396,15333,4670,-6395,-12007,-10075,-3471,2962,6334,6777,5560,3217,-287,-4396,-7855,-9731,-10045,-9267,-7708,-5735,-4187,-3843,-4404,-4552,-3397,-1572,-530,-911,-1934,-2298,-1322,695,2804,4010,3954,3192,2589,2358,2039,1494,1380,2193,3213,3050,1257,-1113,-2652,-2908,-2430,-1936,-1754,-1838,-1961,-1917,-1713,-1577,-1642,-1725,-1556,-1146,-775,-630,-636,-625,-512,-259,163,685,1101,1218,1038,766,630,705,863,888,696,436,319,364,368,163,-190,-484,-602,-607,-637,-777,-1001,-1196,-1247,-1137,-952,-778,-616,-433,-261,-182,-216,-268,-222,-48,182,361,423,370,259,160,112,102,88,48,-9,-59,-90,-109,-129,-155,-192,-236,-262,-238,-171,-115,-123,-185,-234,-222,-157,-73,2,44,33,-24,-85,-117,-121,-103,-58,1,40,63,141,303,425,323,-18,-392,-586,-597,-565,-552,-487,-327,-168,-129,-190,-209,-104,65,201,281,334,330,183,-130,-483,-689,-663,-477,-269,-128,-56,-11,21,2,-126,-365,-613,-730,-657,-470,-293,-194,-157,-133,-73,61,261,455,556,545,495,491,543,581,532,383,197,58,-4,-42,-132,-282,-417,-467,-439,-395,-363,-325,-268,-223,-227,-270,-304,-295,-249,-196,-154,-121,-85,-46,-16,-3}
        },
        {    // H-30e120a.wav
            {0,1,1,1,1,1,1,2,3,3,1,0,0,1,2,1,1,1,2,2,2,2,2,1,2,5,4,0,0,4,5,-1,-3,3,5,-5,-10,4,15,1,-17,-5,19,8,-20,-4,37,19,28,376,1192,1971,1834,449,-1437,-2615,-2549,-1726,-918,-375,139,770,1344,1650,1706,1681,1737,2039,2714,3609,4180,3874,2677,1198,132,-304,-383,-445,-590,-741,-837,-895,-947,-998,-1036,-1054,-1057,-1072,-1122,-1173,-1128,-917,-591,-283,-69,102,307,530,679,713,701,735,819,870,814,658,474,349,354,505,728,871,798,505,127,-171,-329,-410,-514,-682,-875,-1025,-1086,-1058,-970,-865,-773,-699,-630,-556,-488,-438,-398,-337,-235,-104,24,121,171,167,121,69,56,99,168,205,171,67,-74,-211,-310,-351,-341,-312,-304,-336,-397,-457,-492,-499,-487,-462,-428,-389,-348,-307,-260,-204,-140,-70,6,85,156,198,199,168,128,103,100,109,115,107,83,51,21,1,-10,-16,-25,-43,-70,-104,-143,-186,-234,-289,-350,-406,-442,-441,-404,-352,-313,-301,-308,-317,-315,-296,-260,-207,-147,-91,-46,-14,7,16,14,10,12,19,19,-1,-43,-99,-160,-214,-251,-264,-257,-240,-223,-212,-208,-214,-229,-244,-242,-214,-164,-110,-67,-39,-23,-19,-24,-30,-26,-13,1,12,20,21,10,-8,-18,-12},
            {-8,-104,-15,127,25,-185,-89,204,129,-261,-199,322,208,-439,1071,6581,12290,10520,-1488,-16098,-21531,-13870,-915,6465,5047,379,-979,2011,5948,8308,10066,13291,17369,18530,13450,3232,-6595,-10456,-7212,-448,5188,7467,6862,4631,1488,-2141,-5540,-7927,-9073,-9304,-8904,-7842,-6233,-4764,-4203,-4453,-4480,-3463,-1816,-776,-1021,-1937,-2242,-1145,1056,3237,4294,3994,3108,2558,2461,2276,1858,1834,2628,3509,3194,1336,-1031,-2578,-2866,-2391,-1860,-1662,-1806,-2053,-2152,-2076,-2012,-2052,-2016,-1712,-1250,-909,-783,-722,-595,-416,-196,150,639,1094,1281,1150,882,716,756,901,959,830,610,471,445,388,166,-170,-450,-576,-602,-657,-817,-1042,-1212,-1225,-1095,-925,-793,-673,-517,-357,-275,-283,-284,-181,19,223,347,365,303,206,131,113,142,166,145,84,22,-19,-47,-75,-104,-133,-168,-207,-228,-221,-216,-246,-295,-309,-253,-153,-59,-4,1,-36,-90,-129,-140,-131,-99,-40,21,55,95,210,378,431,220,-171,-488,-577,-524,-478,-449,-355,-206,-118,-148,-207,-176,-44,114,244,340,371,258,-35,-414,-695,-745,-580,-337,-155,-82,-74,-66,-50,-82,-216,-424,-591,-610,-477,-292,-162,-115,-112,-96,-17,140,333,475,503,451,421,466,536,538,437,281,142,57,4,-73,-206,-362,-465,-479,-437,-397,-369,-324,-261,-225,-250,-307,-334,-302,-231,-154,-91,-45,-16,-2,1}
        },
        {    // H-30e126a.wav
            {0,0,0,1,1,1,1,2,2,1,-1,0,2,2,0,-1,0,2,2,1,0,0,1,4,5,3,1,4,7,2,-4,1,9,3,-11,-7,13,14,-10,-16,12,23,-13,-30,17,39,-2,170,922,2037,2510,1439,-855,-2901,-3450,-2585,-1339,-468,93,689,1322,1739,1862,1861,1932,2224,2890,3910,4811,4846,3668,1771,97,-763,-909,-782,-696,-724,-844,-1013,-1168,-1277,-1400,-1609,-1844,-1930,-1778,-1485,-1207,-972,-705,-385,-105,52,121,209,380,622,893,1157,1368,1469,1431,1271,1029,745,475,291,239,297,388,439,412,288,59,-248,-556,-774,-865,-872,-870,-897,-937,-957,-942,-894,-809,-687,-546,-414,-300,-188,-67,34,72,40,-14,-28,26,129,233,290,274,192,77,-31,-109,-160,-197,-235,-280,-336,-401,-463,-508,-531,-534,-518,-483,-432,-378,-332,-300,-275,-248,-213,-165,-106,-43,11,48,66,74,81,95,115,133,139,131,115,101,91,81,68,49,24,-9,-50,-96,-140,-180,-218,-256,-294,-325,-349,-367,-378,-374,-354,-332,-330,-354,-388,-404,-386,-332,-252,-159,-67,5,46,57,49,37,31,39,60,84,91,63,-3,-96,-196,-285,-347,-377,-382,-367,-336,-298,-268,-256,-262,-272,-267,-230,-164,-91,-33,6,37,62,72,65,55,54,57,50,36,27,23,11,-10,-24,-18},
            {66,-17,-106,-21,122,47,-158,-108,166,153,-202,-225,243,259,-359,609,5256,10936,10718,875,-12970,-19864,-14480,-2557,5447,4883,38,-2091,870,5844,9116,10408,12020,14843,16278,12751,4186,-4751,-8449,-5318,1267,6541,8174,6761,3817,283,-3289,-6196,-7842,-8319,-8280,-8180,-7865,-7026,-5865,-5014,-4737,-4503,-3596,-2084,-896,-828,-1626,-2141,-1360,708,3013,4317,4213,3399,2843,2763,2649,2260,2117,2700,3490,3333,1773,-401,-1990,-2488,-2251,-1909,-1851,-2089,-2369,-2432,-2293,-2208,-2292,-2322,-2048,-1574,-1219,-1078,-949,-675,-334,-35,270,663,1057,1262,1212,1034,913,936,1048,1102,996,776,590,506,421,198,-144,-445,-584,-608,-656,-815,-1044,-1217,-1235,-1110,-948,-839,-768,-666,-520,-401,-355,-329,-225,-16,226,400,453,400,292,189,141,159,207,231,201,130,49,-26,-93,-154,-206,-248,-275,-273,-246,-225,-245,-298,-330,-297,-208,-108,-42,-29,-57,-93,-112,-112,-104,-84,-42,5,41,102,239,394,390,121,-279,-550,-582,-494,-424,-367,-256,-120,-62,-99,-140,-108,-15,103,239,364,376,176,-208,-596,-791,-719,-467,-211,-87,-105,-167,-175,-134,-135,-247,-424,-541,-514,-372,-214,-114,-77,-66,-34,58,212,369,438,394,322,335,442,536,516,389,242,137,68,-9,-126,-281,-432,-519,-512,-446,-383,-345,-309,-266,-249,-286,-347,-366,-311,-206,-101,-26,12,20,12}
        },
        {    // H-30e132a.wav
            {1,1,2,3,2,2,2,2,1,1,2,2,0,-1,1,3,2,1,1,0,-1,1,6,5,0,0,7,7,-2,-4,8,11,-5,-13,6,21,-1,-26,-2,35,14,-33,-8,50,12,29,597,1872,2982,2539,154,-2808,-4370,-3815,-2125,-664,149,731,1382,1917,2106,2045,2012,2243,2928,4123,5414,5909,4920,2718,406,-1027,-1426,-1284,-1095,-1026,-1056,-1145,-1254,-1357,-1507,-1785,-2131,-2334,-2263,-2032,-1832,-1650,-1293,-700,-103,211,224,182,293,537,779,969,1162,1395,1613,1718,1639,1370,991,654,500,531,590,492,188,-205,-515,-646,-621,-534,-484,-524,-641,-778,-878,-923,-930,-913,-859,-741,-560,-363,-210,-120,-71,-37,-8,18,50,103,176,243,270,237,152,53,-13,-31,-31,-64,-146,-244,-317,-362,-403,-457,-515,-562,-587,-581,-540,-472,-398,-334,-277,-216,-149,-91,-59,-58,-73,-83,-73,-44,-8,21,37,46,61,89,119,135,129,112,95,78,54,23,-9,-39,-76,-129,-194,-256,-301,-325,-329,-321,-312,-307,-299,-281,-258,-250,-274,-331,-400,-448,-447,-390,-292,-178,-65,32,100,126,113,82,59,61,86,113,118,83,4,-106,-225,-327,-394,-423,-428,-422,-406,-380,-354,-342,-338,-320,-272,-203,-133,-72,-21,20,52,82,116,148,171,183,184,162,115,61,24,-2,-37,-76,-84,-47},
            {-22,60,40,-74,-73,71,95,-87,-149,75,192,-77,-260,78,317,-167,9,3253,8765,10926,4568,-7946,-17186,-15718,-5795,3256,4760,523,-2711,-837,4438,8904,10689,11319,12664,13891,12111,6054,-1512,-5704,-3962,1714,6892,8574,6830,3406,-283,-3648,-6298,-7760,-7958,-7528,-7277,-7383,-7358,-6818,-6016,-5416,-4951,-4072,-2590,-1139,-571,-997,-1586,-1307,177,2231,3756,4106,3610,3137,3115,3181,2916,2587,2769,3341,3375,2195,227,-1429,-2080,-1907,-1565,-1582,-2056,-2677,-3017,-2924,-2648,-2487,-2409,-2178,-1776,-1453,-1343,-1262,-972,-487,14,442,815,1110,1249,1223,1137,1101,1151,1237,1265,1153,917,684,556,477,297,-25,-359,-559,-623,-668,-797,-999,-1177,-1236,-1162,-1038,-956,-920,-851,-698,-508,-365,-274,-165,12,225,396,473,460,398,335,301,296,288,243,156,56,-30,-91,-130,-154,-174,-202,-240,-268,-272,-266,-276,-305,-320,-287,-210,-119,-51,-26,-45,-83,-108,-108,-93,-69,-35,3,37,96,216,340,311,45,-327,-566,-570,-451,-349,-273,-166,-46,13,-5,-38,-37,0,83,231,384,389,142,-279,-651,-780,-636,-352,-117,-54,-146,-263,-290,-238,-219,-303,-434,-495,-432,-296,-173,-100,-58,-17,46,150,288,401,411,322,245,292,439,555,540,417,273,154,49,-63,-188,-321,-439,-499,-477,-409,-359,-342,-324,-294,-288,-330,-381,-375,-290,-163,-45,30,51,29}
        },
        {    // H-30e138a.wav
            {1,2,1,0,1,1,0,0,2,3,0,-2,-2,1,2,0,0,0,-2,-3,2,7,3,-1,4,10,2,-7,2,15,5,-15,-5,24,17,-24,-24,26,36,-23,-33,48,56,-24,305,1556,3193,3555,1447,-2241,-5042,-5231,-3329,-1152,170,854,1489,2116,2427,2373,2246,2375,3004,4247,5792,6719,6068,3799,998,-1035,-1823,-1786,-1530,-1337,-1244,-1272,-1424,-1620,-1797,-2006,-2295,-2550,-2601,-2443,-2222,-1989,-1616,-1038,-448,-105,-12,79,332,641,842,959,1140,1410,1622,1646,1510,1327,1164,1046,997,1004,959,724,287,-208,-592,-807,-899,-919,-880,-794,-699,-636,-622,-647,-687,-696,-625,-470,-303,-222,-253,-314,-293,-159,20,162,241,279,288,262,208,155,126,107,72,12,-61,-138,-222,-307,-377,-421,-447,-469,-493,-516,-539,-563,-575,-554,-487,-386,-276,-181,-113,-78,-72,-77,-71,-41,5,43,50,27,-2,-8,15,48,69,73,73,74,69,45,2,-45,-83,-107,-123,-142,-168,-201,-240,-277,-304,-313,-303,-280,-253,-222,-184,-150,-148,-197,-287,-384,-451,-467,-423,-329,-207,-84,19,91,125,123,102,87,96,123,144,132,75,-23,-144,-264,-361,-423,-452,-457,-448,-426,-396,-366,-355,-364,-360,-306,-207,-106,-41,-9,13,43,85,142,208,263,287,278,240,177,103,47,22,-1,-57,-123,-136,-76},
            {-12,-31,21,53,-20,-82,0,97,5,-138,-43,160,72,-203,-117,244,99,-256,1277,5772,9932,7982,-1588,-12477,-15924,-9728,-456,3767,1378,-2400,-2199,2235,7222,9894,10646,11350,12300,11640,7767,1846,-2529,-2410,1756,6518,8459,6773,3125,-484,-3291,-5493,-7133,-7829,-7508,-6853,-6660,-6959,-7129,-6800,-6222,-5640,-4781,-3316,-1612,-569,-625,-1202,-1241,-175,1640,3275,3966,3698,3153,2996,3214,3319,3140,3064,3337,3465,2684,956,-860,-1848,-1856,-1453,-1302,-1662,-2330,-2905,-3143,-3123,-3053,-2950,-2633,-2066,-1504,-1217,-1168,-1088,-798,-331,203,720,1137,1365,1395,1309,1213,1170,1200,1263,1253,1091,841,650,558,434,156,-213,-503,-638,-700,-808,-994,-1187,-1290,-1254,-1118,-981,-903,-853,-761,-617,-478,-373,-253,-56,203,437,559,549,451,335,257,232,232,219,178,118,45,-37,-116,-175,-207,-231,-260,-280,-275,-255,-250,-274,-303,-302,-253,-170,-84,-31,-30,-69,-114,-139,-137,-112,-74,-39,-10,46,160,274,247,6,-330,-543,-538,-413,-300,-221,-130,-29,32,41,30,24,32,92,240,405,410,145,-292,-653,-750,-582,-298,-84,-59,-206,-385,-456,-413,-373,-418,-490,-478,-361,-230,-162,-136,-92,-12,83,189,307,399,403,326,267,319,451,539,505,382,248,135,28,-87,-205,-320,-419,-478,-478,-438,-401,-387,-378,-359,-349,-373,-412,-410,-328,-186,-51,20,24}
        },
        {    // H-30e144a.wav
            {4,1,-1,1,2,0,-1,1,1,-1,-2,1,2,0,-1,0,-2,-3,1,6,3,-4,1,11,5,-11,-8,13,13,-14,-19,16,30,-11,-37,10,49,-4,-54,24,97,-6,93,1161,3130,4349,2878,-1193,-5278,-6628,-4898,-2044,12,993,1640,2320,2757,2744,2537,2572,3177,4490,6242,7508,7142,4830,1593,-1015,-2201,-2289,-1998,-1712,-1482,-1366,-1455,-1705,-1979,-2254,-2602,-2956,-3088,-2891,-2532,-2204,-1857,-1319,-643,-129,30,-18,23,270,626,981,1311,1594,1770,1814,1756,1601,1308,926,650,647,832,916,693,216,-311,-733,-1004,-1132,-1146,-1103,-1063,-1030,-942,-753,-499,-278,-161,-143,-162,-166,-139,-84,-5,85,163,202,203,195,207,244,285,302,275,199,94,-6,-88,-175,-293,-426,-521,-545,-519,-494,-501,-534,-565,-571,-545,-494,-434,-384,-351,-324,-283,-218,-141,-72,-17,33,82,123,143,135,108,76,52,44,50,56,48,21,-20,-71,-128,-182,-214,-215,-191,-162,-149,-164,-202,-245,-271,-274,-260,-238,-212,-184,-149,-105,-69,-76,-155,-286,-410,-473,-463,-399,-306,-197,-90,-5,51,80,84,76,78,107,151,178,162,91,-36,-197,-347,-443,-481,-486,-476,-446,-395,-349,-334,-351,-371,-362,-304,-204,-96,-17,22,44,70,105,150,209,272,303,283,232,182,136,84,42,23,-4,-80,-172,-191,-107},
            {26,8,-33,-17,45,34,-55,-62,49,80,-57,-122,43,155,-41,-209,33,252,-84,49,2626,7197,9305,4551,-5466,-13218,-12609,-5398,1010,1689,-1364,-2769,-29,4725,8184,9439,9921,10809,11334,9728,5576,995,-837,1383,5609,8159,7004,3250,-537,-2980,-4547,-6035,-7234,-7452,-6790,-6216,-6381,-6909,-7065,-6707,-6172,-5495,-4307,-2573,-986,-320,-573,-951,-631,589,2229,3527,3985,3745,3394,3317,3334,3123,2819,2845,3158,3067,2021,353,-1019,-1540,-1455,-1383,-1689,-2268,-2777,-2969,-2890,-2788,-2809,-2822,-2598,-2133,-1661,-1352,-1125,-801,-335,173,622,970,1196,1289,1280,1231,1197,1211,1272,1316,1246,1039,793,612,465,234,-103,-425,-609,-667,-714,-835,-1014,-1168,-1223,-1168,-1063,-981,-925,-834,-674,-494,-365,-282,-168,24,249,416,473,437,364,307,288,290,279,232,155,70,-10,-83,-143,-184,-209,-232,-257,-276,-274,-261,-256,-269,-284,-272,-220,-144,-79,-53,-67,-105,-146,-171,-170,-140,-97,-52,18,136,255,252,51,-265,-501,-535,-423,-296,-209,-127,-25,67,109,101,68,49,101,254,426,443,195,-226,-586,-704,-570,-317,-123,-110,-276,-484,-582,-544,-483,-493,-530,-487,-351,-222,-177,-175,-128,-13,129,262,374,441,430,357,305,342,440,506,483,390,275,154,22,-109,-219,-308,-390,-458,-484,-466,-439,-434,-436,-419,-398,-412,-452,-454,-367,-219,-85,-15}
        },
        {    // H-30e150a.wav
            {1,3,4,0,-2,1,3,0,-3,0,3,1,-2,0,0,-3,-2,6,7,-2,-3,8,10,-7,-13,9,20,-7,-27,5,37,2,-47,-10,61,26,-66,-20,114,57,-7,801,2890,4853,4215,137,-5053,-7772,-6599,-3274,-412,1036,1794,2562,3166,3225,2913,2811,3390,4788,6697,8204,8097,5855,2347,-767,-2420,-2773,-2574,-2277,-1938,-1632,-1555,-1752,-2057,-2361,-2737,-3188,-3484,-3401,-3021,-2596,-2170,-1571,-784,-117,135,53,-22,118,419,783,1204,1658,2010,2140,2057,1819,1432,948,586,565,802,923,647,74,-473,-801,-964,-1089,-1202,-1250,-1204,-1086,-940,-817,-753,-725,-645,-433,-105,225,433,476,415,353,356,414,465,456,384,294,242,250,289,292,211,58,-112,-258,-386,-508,-605,-645,-628,-588,-557,-545,-549,-567,-590,-594,-561,-494,-408,-317,-237,-186,-165,-149,-107,-25,81,179,244,261,233,185,146,123,100,60,3,-55,-103,-138,-166,-195,-225,-245,-245,-227,-206,-201,-214,-232,-245,-248,-240,-221,-194,-163,-124,-71,-15,10,-35,-158,-314,-438,-490,-470,-396,-287,-157,-35,43,65,49,22,9,29,91,172,222,199,93,-72,-256,-411,-499,-517,-495,-467,-430,-372,-314,-295,-322,-351,-335,-269,-176,-84,-7,48,90,132,175,210,235,258,265,232,167,119,117,124,94,41,1,-42,-131,-232,-243,-134},
            {-15,10,30,-3,-39,-4,49,11,-68,-37,69,48,-92,-89,93,119,-112,-172,123,198,-158,448,3544,7618,8079,2122,-6940,-12084,-9808,-3647,201,-410,-2321,-1691,1831,5713,7915,8650,9256,10213,10513,8841,5344,2147,1669,4095,6820,6881,3854,-30,-2549,-3635,-4641,-6154,-7323,-7263,-6368,-5804,-6082,-6651,-6803,-6448,-5841,-4984,-3696,-2149,-912,-388,-382,-317,250,1337,2567,3421,3624,3414,3296,3448,3541,3258,2797,2575,2544,2170,1161,-80,-898,-1116,-1126,-1379,-1948,-2568,-2940,-2963,-2785,-2647,-2621,-2540,-2227,-1761,-1390,-1211,-1054,-711,-178,382,825,1106,1240,1262,1224,1182,1168,1186,1212,1190,1066,860,666,538,405,159,-185,-490,-646,-688,-731,-842,-990,-1097,-1114,-1060,-998,-967,-933,-832,-654,-459,-309,-192,-53,122,279,360,360,324,301,311,335,334,285,198,105,29,-31,-89,-145,-191,-224,-251,-275,-285,-273,-252,-245,-256,-262,-239,-191,-143,-115,-108,-116,-132,-147,-146,-128,-113,-101,-52,75,233,288,135,-173,-452,-548,-468,-328,-218,-134,-36,74,152,161,109,53,70,196,366,427,261,-87,-433,-599,-543,-363,-209,-198,-342,-538,-647,-621,-548,-534,-566,-541,-411,-255,-175,-165,-126,2,181,336,428,457,431,374,332,344,406,466,472,412,303,165,16,-119,-220,-295,-363,-427,-470,-479,-470,-468,-479,-488,-488,-486,-482,-450,-359,-217,-80}
        },
        {    // H-30e156a.wav
            {5,1,-3,0,4,1,-5,-3,3,3,-2,-3,-1,-4,-5,2,7,0,-4,6,12,-3,-17,-1,19,1,-28,-8,34,15,-46,-33,50,48,-55,-55,92,101,-16,578,2618,5069,5240,1476,-4447,-8497,-8188,-4707,-1106,904,1827,2694,3559,3864,3544,3250,3702,5137,7153,8762,8767,6616,3051,-334,-2359,-3011,-2980,-2777,-2489,-2154,-1963,-2018,-2200,-2410,-2751,-3291,-3780,-3856,-3484,-2967,-2488,-1888,-1025,-164,247,137,-83,1,413,920,1368,1747,2030,2145,2078,1876,1562,1161,807,679,772,833,604,87,-497,-950,-1215,-1317,-1291,-1196,-1120,-1114,-1149,-1156,-1088,-939,-724,-472,-226,-20,146,306,499,722,918,1012,972,838,686,572,504,451,379,264,111,-43,-160,-245,-343,-476,-604,-668,-663,-640,-649,-695,-752,-788,-782,-721,-617,-502,-410,-343,-280,-205,-129,-68,-23,25,86,155,216,256,263,232,176,119,76,39,-2,-40,-65,-85,-117,-166,-216,-250,-259,-245,-220,-201,-205,-229,-254,-265,-263,-248,-217,-174,-132,-88,-29,32,40,-50,-215,-377,-472,-488,-443,-357,-244,-121,-14,54,72,44,3,-13,12,72,145,195,176,61,-122,-303,-422,-472,-481,-479,-470,-441,-385,-321,-287,-295,-311,-289,-223,-147,-81,-10,73,143,182,208,240,266,265,237,193,139,94,86,109,107,48,-25,-60,-95,-197,-322,-331,-181},
            {11,-7,-14,13,26,-9,-33,10,47,-4,-64,-11,72,17,-98,-46,113,71,-142,-111,169,121,-156,822,4033,7400,6811,782,-6863,-10395,-8089,-3565,-1227,-1657,-2125,-476,2737,5630,7248,8077,8940,9880,10042,8605,5970,3890,3883,5404,6094,4243,684,-2225,-3285,-3510,-4444,-6131,-7244,-6940,-5895,-5375,-5761,-6375,-6491,-6041,-5306,-4357,-3121,-1786,-790,-361,-258,-9,685,1760,2838,3448,3416,3074,2939,3127,3258,3032,2661,2492,2394,1873,779,-399,-1082,-1230,-1265,-1532,-1999,-2424,-2636,-2651,-2611,-2627,-2630,-2418,-1915,-1316,-908,-750,-634,-363,39,417,681,858,998,1112,1180,1190,1164,1143,1136,1089,939,711,510,387,270,61,-224,-470,-599,-653,-727,-858,-1004,-1094,-1092,-1018,-923,-841,-756,-639,-500,-384,-307,-226,-87,96,253,327,329,308,301,307,304,273,209,128,53,-5,-55,-113,-178,-229,-255,-264,-267,-257,-227,-192,-182,-196,-208,-200,-181,-164,-151,-136,-123,-119,-117,-109,-102,-96,-61,41,185,262,167,-91,-375,-534,-520,-404,-284,-193,-97,31,155,203,147,45,9,104,280,397,331,83,-222,-432,-475,-387,-278,-261,-383,-574,-697,-676,-581,-541,-581,-596,-489,-304,-163,-111,-74,35,211,374,458,456,401,333,290,298,355,424,454,414,311,173,31,-88,-170,-221,-271,-345,-428,-481,-497,-512,-549,-576,-559,-521,-495,-453,-334,-150}
        },
        {    // H-30e162a.wav
            {-3,-2,1,0,-4,-4,0,0,-4,-4,-3,-6,-8,-1,5,-2,-8,2,11,-3,-21,-7,18,4,-31,-18,29,22,-43,-48,35,57,-40,-72,61,110,4,486,2429,5109,5877,2581,-3627,-8709,-9416,-6172,-2044,596,1772,2657,3690,4367,4337,4060,4367,5681,7627,9161,9118,7022,3565,172,-2059,-3012,-3215,-3124,-2892,-2626,-2513,-2598,-2703,-2707,-2796,-3205,-3800,-4136,-3954,-3434,-2863,-2238,-1391,-412,300,465,251,86,253,729,1325,1845,2168,2287,2270,2137,1806,1260,726,528,706,904,733,167,-485,-942,-1176,-1310,-1433,-1546,-1607,-1573,-1425,-1199,-970,-795,-674,-572,-450,-278,-45,215,442,617,780,968,1147,1239,1196,1043,844,662,525,414,284,122,-37,-160,-273,-422,-598,-734,-786,-786,-788,-815,-849,-871,-875,-855,-800,-711,-591,-445,-285,-142,-43,12,48,85,129,173,208,218,190,138,93,75,77,77,61,28,-14,-56,-94,-127,-161,-197,-228,-243,-239,-225,-215,-221,-237,-251,-253,-242,-224,-200,-172,-140,-96,-29,37,35,-81,-280,-460,-543,-527,-452,-338,-191,-37,76,113,76,3,-57,-63,-8,79,155,182,132,-3,-188,-348,-428,-445,-453,-476,-481,-439,-367,-308,-292,-311,-329,-302,-222,-123,-40,32,111,182,211,208,218,251,259,212,151,126,127,123,114,107,69,-16,-98,-135,-186,-329,-488,-477,-253},
            {-10,5,11,-6,-11,12,21,-10,-25,13,35,-15,-55,2,63,-1,-91,-22,106,36,-141,-69,169,70,-122,977,4024,6929,6151,709,-5969,-9206,-7733,-4371,-2351,-2060,-1653,186,2953,5372,6848,7759,8705,9687,9983,8931,6924,5333,5059,5310,4366,1662,-1416,-3116,-3332,-3519,-4734,-6354,-6977,-6193,-5018,-4661,-5259,-6005,-6181,-5741,-4966,-3966,-2731,-1454,-514,-95,10,205,767,1667,2593,3153,3207,3026,2987,3099,3027,2619,2175,2022,1995,1624,778,-157,-782,-1124,-1472,-1941,-2374,-2584,-2553,-2409,-2298,-2269,-2215,-1972,-1524,-1066,-795,-666,-461,-70,383,707,851,897,929,965,982,970,953,964,991,963,820,598,403,274,135,-88,-349,-534,-603,-622,-672,-765,-861,-913,-901,-842,-781,-750,-726,-655,-526,-387,-273,-170,-41,102,207,245,244,246,261,267,241,184,113,48,-3,-48,-99,-155,-201,-224,-224,-215,-200,-176,-146,-127,-134,-161,-184,-187,-169,-142,-112,-87,-76,-76,-79,-86,-99,-101,-49,71,184,168,-26,-307,-523,-591,-536,-433,-316,-177,-8,155,244,211,91,-1,38,196,352,371,219,-31,-265,-394,-395,-331,-310,-403,-568,-688,-688,-614,-576,-611,-634,-539,-329,-122,-21,4,64,204,355,426,405,341,275,226,217,269,353,404,383,308,210,102,-3,-80,-131,-194,-288,-377,-429,-473,-546,-622,-650,-633,-611,-563,-421,-194}
        },
        {    // H-30e168a.wav
            {1,-1,-4,-3,1,2,-1,-2,-2,-4,-5,1,5,-1,-5,5,13,0,-17,-5,17,4,-28,-18,26,22,-35,-43,26,47,-34,-59,52,90,12,522,2448,5143,6100,3120,-2975,-8448,-9908,-7243,-3119,-43,1558,2621,3733,4614,4911,4912,5336,6597,8330,9536,9215,7089,3848,662,-1621,-2858,-3340,-3365,-3152,-2952,-2980,-3183,-3286,-3168,-3077,-3326,-3855,-4260,-4250,-3889,-3340,-2574,-1519,-396,351,498,272,96,229,686,1342,1989,2402,2499,2397,2225,1934,1439,897,641,772,976,847,307,-393,-986,-1395,-1654,-1790,-1812,-1752,-1646,-1516,-1370,-1211,-1018,-771,-493,-250,-83,40,179,355,548,729,880,980,1015,997,962,941,932,904,814,642,415,191,4,-173,-385,-616,-783,-826,-777,-733,-765,-863,-964,-1013,-988,-897,-766,-624,-487,-357,-235,-131,-49,12,63,112,157,194,218,222,201,161,118,86,65,49,36,22,-2,-39,-78,-110,-138,-168,-192,-202,-206,-216,-229,-232,-224,-219,-224,-226,-215,-201,-190,-160,-84,22,91,46,-130,-371,-562,-624,-561,-429,-273,-103,59,160,157,72,-24,-72,-52,26,127,198,186,76,-96,-269,-390,-440,-443,-448,-472,-476,-422,-341,-303,-326,-355,-330,-253,-159,-68,21,101,157,188,197,191,189,208,231,225,193,177,192,194,153,102,71,25,-78,-198,-278,-349,-473,-586,-526,-268},
            {1,-7,-7,5,7,-7,-7,13,16,-11,-20,13,27,-16,-44,6,48,-10,-75,-10,85,15,-119,-39,145,38,-66,1031,3808,6406,5788,1064,-4985,-8405,-7839,-5243,-3175,-2219,-1228,715,3244,5372,6623,7363,8217,9289,9942,9461,7950,6322,5239,4276,2513,-116,-2503,-3597,-3636,-3807,-4772,-5919,-6189,-5389,-4403,-4177,-4752,-5419,-5588,-5248,-4636,-3790,-2635,-1341,-321,158,244,339,757,1511,2318,2814,2880,2769,2815,3004,2994,2605,2088,1768,1581,1186,476,-278,-800,-1128,-1458,-1848,-2178,-2353,-2397,-2382,-2344,-2261,-2061,-1680,-1164,-690,-405,-270,-117,145,446,672,803,896,988,1045,1020,917,795,717,679,619,493,344,244,191,100,-83,-303,-454,-497,-483,-488,-544,-640,-744,-826,-865,-860,-818,-741,-626,-491,-368,-274,-189,-84,35,131,180,197,209,219,206,164,103,44,1,-25,-45,-74,-121,-172,-204,-206,-190,-165,-126,-78,-48,-58,-95,-123,-126,-110,-83,-48,-23,-28,-64,-112,-163,-204,-195,-97,48,111,-7,-265,-515,-634,-608,-501,-371,-232,-71,104,239,266,177,62,40,143,285,348,275,93,-122,-291,-367,-366,-362,-425,-557,-680,-707,-637,-557,-544,-568,-521,-352,-140,-3,42,82,178,295,358,346,289,220,169,162,205,266,311,326,309,254,169,89,33,-25,-112,-214,-307,-403,-513,-604,-641,-653,-685,-683,-536,-252}
        },
        {    // H-30e174a.wav
            {-5,-2,2,0,-3,-2,-1,-6,-8,0,6,-1,-6,4,12,-1,-15,-2,16,-1,-29,-13,26,12,-40,-32,34,32,-50,-47,70,69,-7,612,2651,5292,6075,3065,-2795,-8047,-9689,-7596,-3981,-956,992,2455,3813,4849,5337,5582,6217,7544,9121,9979,9323,7124,4103,1171,-1121,-2644,-3440,-3597,-3372,-3202,-3386,-3764,-3899,-3645,-3383,-3571,-4141,-4551,-4425,-3926,-3399,-2851,-2023,-922,34,455,416,330,509,963,1525,2020,2334,2450,2440,2354,2133,1735,1312,1105,1125,1075,674,-23,-717,-1195,-1478,-1670,-1806,-1876,-1898,-1892,-1837,-1689,-1431,-1085,-710,-384,-168,-42,76,243,433,588,700,801,900,961,949,875,791,747,751,757,707,581,414,236,35,-207,-459,-649,-740,-761,-768,-794,-841,-891,-912,-885,-821,-749,-677,-587,-470,-356,-275,-214,-142,-52,38,117,188,240,252,224,180,151,137,120,90,48,4,-34,-62,-83,-98,-104,-104,-105,-118,-142,-167,-186,-199,-203,-197,-195,-209,-238,-262,-264,-241,-180,-71,55,110,16,-216,-471,-627,-638,-541,-393,-220,-30,143,234,204,87,-20,-42,23,121,193,197,114,-41,-213,-343,-410,-442,-473,-512,-535,-510,-432,-348,-319,-349,-365,-302,-179,-63,16,82,142,172,165,156,166,179,182,192,220,243,248,250,249,212,128,47,-3,-73,-206,-343,-406,-439,-536,-642,-575,-294},
            {-4,0,0,-6,-7,2,6,-5,-7,9,13,-9,-18,9,22,-14,-40,0,40,-3,-62,-17,64,16,-93,-35,118,42,-38,911,3412,5971,5826,1795,-4025,-8013,-8358,-6228,-3852,-2176,-637,1396,3647,5363,6254,6777,7585,8803,9833,9895,8776,6975,5056,3070,803,-1526,-3189,-3741,-3648,-3830,-4601,-5333,-5261,-4450,-3750,-3856,-4593,-5222,-5258,-4797,-4130,-3314,-2275,-1147,-278,119,189,276,632,1268,1985,2522,2768,2845,2925,2958,2721,2183,1657,1444,1424,1198,578,-219,-887,-1347,-1690,-1953,-2095,-2115,-2084,-2056,-2031,-1975,-1832,-1539,-1107,-657,-320,-97,121,381,608,722,754,795,875,947,958,904,813,711,603,475,321,173,83,58,37,-36,-143,-224,-263,-312,-419,-571,-721,-830,-882,-882,-850,-809,-757,-672,-550,-420,-311,-214,-107,4,94,145,171,184,177,144,96,54,32,27,23,-1,-49,-103,-137,-144,-137,-127,-107,-69,-27,-10,-29,-65,-91,-91,-74,-54,-51,-76,-126,-188,-248,-288,-283,-210,-78,32,17,-162,-422,-616,-658,-574,-439,-289,-115,80,236,285,218,103,40,84,201,294,281,157,-23,-196,-325,-394,-419,-456,-550,-663,-698,-615,-493,-440,-462,-462,-367,-205,-52,48,104,147,197,246,265,238,185,147,141,157,191,247,300,304,255,200,163,114,30,-63,-151,-269,-429,-559,-600,-612,-678,-734,-613,-300}
        },
        {    // H-30e180a.wav
            {2,0,-2,-1,-1,-5,-5,3,5,-3,-4,9,14,-4,-15,4,19,-6,-31,-4,33,5,-49,-23,49,26,-67,-37,95,55,-19,765,3022,5611,5955,2512,-3256,-7905,-9055,-7126,-4184,-1700,257,2133,3914,5180,5777,6133,6880,8214,9597,10121,9237,7150,4532,1927,-428,-2343,-3517,-3816,-3587,-3472,-3815,-4345,-4528,-4200,-3767,-3741,-4183,-4671,-4785,-4464,-3868,-3065,-2037,-929,-89,249,222,216,521,1131,1808,2295,2514,2606,2731,2827,2647,2100,1445,1039,936,857,543,11,-561,-1062,-1483,-1821,-2047,-2152,-2156,-2074,-1918,-1713,-1464,-1148,-774,-436,-232,-147,-57,132,400,662,865,995,1047,1014,911,780,667,596,557,514,444,366,315,281,205,38,-193,-407,-543,-606,-638,-676,-732,-795,-846,-864,-847,-805,-740,-646,-529,-411,-311,-222,-127,-30,43,81,102,130,160,170,158,143,132,113,76,31,-12,-54,-92,-112,-106,-81,-57,-40,-31,-38,-70,-112,-138,-138,-127,-123,-135,-165,-213,-264,-297,-293,-233,-117,13,61,-52,-293,-526,-633,-603,-498,-359,-190,0,168,257,241,144,45,27,105,206,241,180,52,-107,-262,-373,-422,-446,-507,-597,-636,-574,-454,-367,-352,-371,-353,-263,-124,2,78,118,156,189,188,160,143,149,154,154,182,244,290,287,261,237,191,103,12,-56,-148,-299,-441,-492,-509,-600,-708,-632,-323},
            {2,0,-2,-1,-1,-5,-5,3,5,-3,-4,9,14,-4,-15,4,19,-6,-31,-4,33,5,-49,-23,49,26,-67,-37,95,55,-19,765,3022,5611,5955,2512,-3256,-7905,-9055,-7126,-4184,-1700,257,2133,3914,5180,5777,6133,6880,8214,9597,10121,9237,7150,4532,1927,-428,-2343,-3517,-3816,-3587,-3472,-3815,-4345,-4528,-4200,-3767,-3741,-4183,-4671,-4785,-4464,-3868,-3065,-2037,-929,-89,249,222,216,521,1131,1808,2295,2514,2606,2731,2827,2647,2100,1445,1039,936,857,543,11,-561,-1062,-1483,-1821,-2047,-2152,-2156,-2074,-1918,-1713,-1464,-1148,-774,-436,-232,-147,-57,132,400,662,865,995,1047,1014,911,780,667,596,557,514,444,366,315,281,205,38,-193,-407,-543,-606,-638,-676,-732,-795,-846,-864,-847,-805,-740,-646,-529,-411,-311,-222,-127,-30,43,81,102,130,160,170,158,143,132,113,76,31,-12,-54,-92,-112,-106,-81,-57,-40,-31,-38,-70,-112,-138,-138,-127,-123,-135,-165,-213,-264,-297,-293,-233,-117,13,61,-52,-293,-526,-633,-603,-498,-359,-190,0,168,257,241,144,45,27,105,206,241,180,52,-107,-262,-373,-422,-446,-507,-597,-636,-574,-454,-367,-352,-371,-353,-263,-124,2,78,118,156,189,188,160,143,149,154,154,182,244,290,287,261,237,191,103,12,-56,-148,-299,-441,-492,-509,-600,-708,-632,-323}
        }
    },
    {    // elev-40
        {    // H-40e000a.wav
            {-10,-1,10,3,-8,0,16,8,-14,-7,20,12,-29,-30,22,38,-22,-53,11,58,-18,-78,21,86,-40,291,2139,5144,6622,3810,-2554,-7889,-8072,-3821,182,569,-1298,-1568,1449,5858,8829,9299,7885,5543,3327,2748,4823,8399,10354,8298,2975,-2354,-4886,-4536,-3540,-4121,-6390,-8240,-7410,-3927,-431,242,-2190,-5347,-6704,-5786,-3866,-2232,-1267,-823,-717,-702,-436,217,1001,1521,1575,1249,882,955,1712,2716,3055,2272,943,76,45,383,536,445,299,96,-298,-802,-1131,-1146,-1017,-1004,-1170,-1349,-1322,-1036,-679,-536,-706,-971,-998,-673,-196,144,227,151,90,146,290,427,512,584,660,649,451,141,-68,-80,-49,-183,-458,-630,-515,-183,134,270,240,174,175,238,281,254,179,96,-9,-174,-370,-510,-562,-616,-781,-1038,-1232,-1220,-1005,-714,-475,-316,-176,-4,176,297,348,392,473,540,512,396,293,267,267,196,33,-160,-321,-444,-547,-620,-635,-582,-472,-334,-203,-103,-30,30,75,81,49,21,31,59,52,-6,-76,-114,-118,-107,-90,-68,-59,-84,-145,-212,-252,-248,-208,-155,-118,-106,-103,-96,-96,-128,-191,-252,-281,-275,-246,-211,-184,-176,-178,-165,-119,-54,2,33,45,50,58,74,94,106,103,86,57,16,-30,-66,-82,-91,-109,-134,-152,-166,-187,-214,-226,-218,-214,-235,-266,-275,-249,-202,-149,-94,-44,-11},
            {-10,-1,10,3,-8,0,16,8,-14,-7,20,12,-29,-30,22,38,-22,-53,11,58,-18,-78,21,86,-40,291,2139,5144,6622,3810,-2554,-7889,-8072,-3821,182,569,-1298,-1568,1449,5858,8829,9299,7885,5543,3327,2748,4823,8399,10354,8298,2975,-2354,-4886,-4536,-3540,-4121,-6390,-8240,-7410,-3927,-431,242,-2190,-5347,-6704,-5786,-3866,-2232,-1267,-823,-717,-702,-436,217,1001,1521,1575,1249,882,955,1712,2716,3055,2272,943,76,45,383,536,445,299,96,-298,-802,-1131,-1146,-1017,-1004,-1170,-1349,-1322,-1036,-679,-536,-706,-971,-998,-673,-196,144,227,151,90,146,290,427,512,584,660,649,451,141,-68,-80,-49,-183,-458,-630,-515,-183,134,270,240,174,175,238,281,254,179,96,-9,-174,-370,-510,-562,-616,-781,-1038,-1232,-1220,-1005,-714,-475,-316,-176,-4,176,297,348,392,473,540,512,396,293,267,267,196,33,-160,-321,-444,-547,-620,-635,-582,-472,-334,-203,-103,-30,30,75,81,49,21,31,59,52,-6,-76,-114,-118,-107,-90,-68,-59,-84,-145,-212,-252,-248,-208,-155,-118,-106,-103,-96,-96,-128,-191,-252,-281,-275,-246,-211,-184,-176,-178,-165,-119,-54,2,33,45,50,58,74,94,106,103,86,57,16,-30,-66,-82,-91,-109,-134,-152,-166,-187,-214,-226,-218,-214,-235,-266,-275,-249,-202,-149,-94,-44,-11}
        },
        {    // H-40e006a.wav
            {0,-1,-5,-3,6,8,-2,-4,9,15,0,-11,3,18,-1,-26,-8,27,12,-33,-23,34,28,-42,-34,56,28,7,772,2868,5187,5202,1510,-3968,-7264,-6314,-3095,-1243,-1909,-2770,-1129,2911,6840,8591,8153,6681,5113,4080,4290,5986,8063,8519,6267,2329,-1039,-2413,-2358,-2638,-4347,-6724,-7787,-6277,-3070,-530,-365,-2198,-4266,-5218,-4979,-4150,-3156,-2152,-1308,-790,-513,-196,305,836,1129,1055,756,612,989,1854,2652,2753,2074,1155,597,528,669,727,594,288,-121,-512,-774,-904,-996,-1132,-1306,-1445,-1460,-1299,-1018,-784,-733,-822,-873,-772,-562,-346,-163,2,161,309,434,498,462,359,291,294,262,102,-86,-82,186,523,672,580,410,336,375,415,354,190,-5,-161,-259,-313,-330,-325,-358,-504,-760,-1009,-1119,-1070,-957,-869,-803,-690,-484,-222,3,122,150,174,266,402,499,519,500,477,415,271,74,-94,-204,-307,-451,-601,-676,-638,-517,-373,-250,-165,-114,-78,-42,-3,39,91,144,162,115,25,-47,-69,-67,-78,-97,-94,-66,-50,-79,-154,-248,-326,-359,-339,-287,-238,-214,-209,-205,-193,-172,-150,-135,-128,-116,-88,-51,-27,-28,-42,-52,-58,-66,-74,-72,-56,-28,8,47,68,53,14,-23,-44,-55,-69,-87,-106,-118,-115,-91,-59,-44,-59,-85,-92,-73,-57,-82,-153,-231,-267,-250,-215,-197,-186,-145,-68},
            {3,6,-3,-4,12,16,-7,-18,8,26,-10,-46,-10,44,15,-56,-35,54,35,-80,-57,91,39,-18,1077,4006,6966,6358,702,-6590,-9833,-6936,-1652,761,-663,-2199,-348,4335,8624,10351,9655,7492,4714,2754,3505,7208,11025,11052,6148,-762,-5437,-6123,-4625,-4057,-5769,-8196,-8487,-5460,-1098,1093,-576,-4406,-7158,-7126,-5122,-2927,-1556,-1045,-1088,-1310,-1237,-569,482,1372,1741,1618,1293,1189,1684,2682,3417,3098,1841,636,263,518,698,519,237,43,-217,-689,-1203,-1484,-1491,-1417,-1424,-1493,-1473,-1241,-850,-549,-568,-840,-1014,-806,-291,201,426,394,275,222,283,397,485,536,591,624,509,199,-138,-274,-207,-181,-369,-636,-696,-437,-34,251,307,224,161,183,228,211,133,61,14,-76,-253,-449,-572,-647,-791,-1043,-1276,-1317,-1109,-759,-424,-196,-62,48,179,304,375,405,460,558,621,576,455,357,306,225,45,-189,-384,-507,-594,-672,-716,-686,-580,-438,-306,-207,-136,-75,-16,22,23,7,18,65,100,79,19,-23,-21,6,31,47,54,36,-21,-102,-174,-210,-207,-178,-148,-138,-145,-152,-156,-180,-243,-320,-368,-369,-340,-300,-255,-214,-192,-181,-155,-100,-40,-5,6,14,33,61,92,117,126,115,97,81,60,29,0,-14,-30,-73,-130,-168,-186,-218,-277,-324,-330,-319,-325,-331,-301,-241,-191,-153,-92,-5,54,45}
        },
        {    // H-40e013a.wav
            {-2,-2,-1,-3,-6,-2,5,3,-4,-1,10,8,-5,-6,10,10,-14,-23,4,24,-4,-33,-4,36,6,-43,-3,53,-7,139,1234,3358,4979,3915,-188,-4765,-6510,-4758,-2072,-1200,-2010,-2041,294,3920,6581,7264,6614,5582,4600,4055,4570,6189,7670,7332,4761,1337,-1083,-1856,-1915,-2640,-4447,-6353,-6840,-5287,-2683,-868,-965,-2546,-4252,-5040,-4739,-3724,-2446,-1301,-601,-394,-391,-220,231,763,1104,1149,1044,1084,1460,2006,2271,1960,1268,706,587,771,902,764,386,-86,-511,-800,-948,-1021,-1095,-1190,-1279,-1326,-1294,-1159,-961,-800,-740,-733,-684,-558,-392,-218,-33,153,304,395,420,380,300,259,308,374,325,163,72,213,505,701,666,504,393,383,381,291,114,-84,-244,-349,-412,-442,-441,-436,-493,-657,-880,-1035,-1041,-936,-821,-739,-644,-478,-254,-45,84,139,174,232,303,346,342,323,317,302,230,97,-43,-147,-234,-346,-481,-581,-591,-506,-373,-246,-156,-101,-65,-30,5,42,87,133,146,98,10,-63,-89,-93,-117,-160,-183,-165,-133,-135,-187,-264,-330,-360,-345,-294,-234,-196,-186,-185,-172,-148,-131,-133,-141,-132,-94,-41,1,13,-5,-35,-53,-53,-42,-31,-19,-2,19,38,46,35,3,-41,-78,-99,-117,-145,-176,-188,-173,-139,-99,-66,-52,-61,-73,-64,-42,-50,-103,-163,-183,-169,-162,-165,-140,-71},
            {4,-7,2,20,8,-20,-11,25,17,-36,-40,27,49,-28,-70,17,78,-26,-113,19,118,-48,312,2542,6218,7987,4413,-3515,-10035,-10101,-4799,-10,305,-1879,-1816,2198,7502,10742,11051,9380,6621,3772,2858,5545,10372,12858,9588,1941,-5036,-7457,-5925,-4193,-5086,-7872,-9301,-7040,-2212,1414,911,-3071,-7105,-8304,-6569,-3828,-1848,-1174,-1504,-2217,-2518,-1774,-77,1721,2722,2652,1893,1167,1181,2148,3411,3842,2971,1557,750,815,1039,784,178,-312,-572,-817,-1137,-1398,-1533,-1655,-1852,-2020,-1974,-1631,-1098,-634,-493,-695,-940,-850,-349,263,625,640,478,350,343,415,494,559,634,705,663,404,-4,-321,-384,-303,-332,-554,-765,-697,-326,100,308,249,101,46,92,116,56,-14,-20,-15,-109,-303,-483,-592,-714,-953,-1245,-1394,-1263,-905,-490,-160,48,179,288,388,455,478,491,532,582,583,523,455,411,340,169,-94,-353,-535,-648,-740,-816,-831,-744,-568,-365,-212,-144,-130,-114,-69,-24,-2,23,86,162,188,142,70,32,44,80,117,145,152,122,53,-39,-124,-173,-177,-152,-130,-130,-140,-156,-196,-275,-372,-440,-455,-433,-397,-350,-291,-231,-187,-152,-108,-52,-4,19,19,20,40,75,109,133,144,144,130,102,71,50,42,34,6,-49,-113,-164,-199,-242,-307,-374,-407,-399,-377,-355,-308,-226,-146,-103,-68,9,111,151,92}
        },
        {    // H-40e019a.wav
            {0,0,-1,-1,-1,-3,-4,0,4,2,-2,2,10,7,-5,-6,9,11,-10,-20,3,20,-3,-27,-1,33,8,-33,1,44,-3,154,1146,2998,4361,3391,-152,-4057,-5565,-4158,-1943,-1104,-1518,-1325,556,3238,5161,5795,5653,5200,4535,4004,4313,5594,6782,6469,4366,1610,-393,-1220,-1566,-2388,-3962,-5579,-6076,-4877,-2690,-1066,-1093,-2504,-4079,-4779,-4394,-3306,-2011,-927,-345,-276,-397,-307,121,689,1124,1318,1366,1447,1656,1886,1896,1563,1062,716,666,750,711,442,17,-433,-806,-1042,-1126,-1101,-1042,-1022,-1080,-1195,-1269,-1195,-965,-701,-533,-476,-448,-379,-259,-106,67,239,374,447,454,415,375,389,452,473,373,221,187,332,514,551,434,312,286,304,265,142,-22,-191,-351,-477,-536,-528,-503,-533,-660,-860,-1042,-1105,-1015,-837,-665,-532,-393,-206,3,162,236,259,282,316,326,293,240,206,190,153,68,-44,-146,-234,-335,-465,-580,-616,-548,-413,-268,-150,-71,-32,-19,-15,1,38,81,102,84,30,-32,-74,-92,-110,-147,-190,-206,-187,-165,-174,-218,-274,-315,-322,-291,-236,-189,-175,-185,-189,-172,-148,-136,-135,-127,-98,-51,-6,16,7,-20,-43,-49,-37,-15,8,26,36,39,32,11,-25,-61,-85,-101,-125,-163,-199,-219,-217,-192,-148,-103,-80,-80,-72,-36,5,15,-8,-36,-60,-93,-127,-122,-65},
            {-3,21,18,-16,-24,18,34,-20,-57,1,62,6,-77,-25,82,26,-115,-49,127,15,26,1649,5392,8572,6869,-700,-9238,-12116,-7897,-1775,478,-1212,-2130,1008,6570,10754,11840,10633,8203,5262,3466,4982,9520,13053,11240,4149,-3521,-7196,-6672,-5367,-6122,-8396,-9316,-6905,-2229,1336,1022,-2837,-7115,-8757,-7284,-4562,-2610,-2088,-2546,-3242,-3411,-2390,-139,2418,3983,3920,2664,1301,853,1688,3210,4204,3866,2573,1427,1031,1019,778,225,-333,-767,-1181,-1556,-1717,-1663,-1661,-1907,-2262,-2402,-2131,-1528,-897,-579,-687,-946,-901,-375,347,822,870,653,441,383,475,628,756,833,872,832,618,227,-166,-361,-370,-406,-618,-894,-969,-713,-267,91,189,90,-12,-6,46,37,-30,-76,-86,-137,-263,-398,-493,-617,-865,-1187,-1390,-1323,-1006,-582,-186,121,333,472,560,597,573,515,476,478,487,470,445,437,406,268,7,-290,-517,-655,-753,-840,-884,-838,-695,-503,-329,-222,-185,-171,-131,-62,8,70,149,247,311,290,202,118,87,100,129,160,184,184,150,86,7,-69,-124,-146,-148,-149,-152,-152,-175,-259,-392,-500,-527,-498,-469,-449,-404,-326,-244,-169,-84,10,75,83,54,31,32,53,82,110,126,130,131,128,111,82,63,58,43,-5,-71,-124,-161,-207,-278,-363,-436,-470,-450,-389,-317,-252,-184,-107,-41,-1,44,126,207,206,109}
        },
        {    // H-40e026a.wav
            {-4,-3,1,1,-1,-2,-2,-3,-3,2,5,2,-2,3,10,5,-5,-1,10,4,-13,-10,13,15,-13,-19,16,31,-9,-29,20,35,-3,304,1463,3152,3902,2328,-1131,-4176,-4775,-3167,-1378,-857,-1085,-630,992,2966,4361,5009,5145,4837,4195,3792,4263,5411,6127,5438,3479,1292,-205,-932,-1507,-2566,-4122,-5404,-5419,-3924,-1890,-803,-1362,-2933,-4251,-4520,-3779,-2534,-1309,-482,-199,-288,-370,-167,294,799,1175,1386,1489,1579,1709,1804,1699,1332,867,553,470,471,368,96,-288,-682,-982,-1112,-1073,-957,-892,-952,-1111,-1257,-1251,-1036,-704,-431,-320,-323,-326,-263,-137,27,209,375,492,551,573,577,570,540,460,313,146,68,146,307,394,339,225,165,166,155,89,-15,-135,-273,-417,-525,-573,-591,-637,-744,-895,-1034,-1087,-1007,-817,-600,-419,-266,-98,91,253,346,377,382,384,371,328,259,183,109,30,-64,-167,-256,-324,-391,-478,-573,-626,-597,-487,-331,-172,-46,24,36,8,-23,-28,1,42,66,56,15,-36,-78,-111,-143,-172,-185,-176,-157,-151,-172,-213,-253,-268,-251,-216,-188,-187,-210,-229,-220,-185,-148,-128,-116,-94,-59,-27,-12,-12,-18,-21,-20,-13,-2,9,17,21,23,15,-10,-44,-73,-97,-123,-151,-173,-192,-215,-230,-213,-163,-112,-81,-58,-19,28,59,64,51,18,-40,-98,-109,-61},
            {26,5,-27,-11,34,20,-44,-44,38,59,-36,-81,25,92,-36,-132,28,134,-76,338,2933,7199,9254,5124,-4103,-11863,-12314,-6484,-863,68,-1655,-1010,3585,9015,11830,11673,10018,7631,4989,3966,6551,11419,13715,9799,1527,-5476,-7694,-6758,-6546,-8392,-9957,-8379,-3717,856,1910,-1236,-6043,-9056,-8743,-6269,-3877,-2870,-3095,-3697,-3832,-2893,-761,1898,3897,4397,3525,2190,1408,1726,2899,4003,4129,3213,2056,1397,1171,854,281,-252,-580,-917,-1436,-1935,-2135,-2089,-2082,-2231,-2357,-2228,-1793,-1231,-843,-832,-1064,-1123,-698,62,696,899,761,572,524,625,791,926,980,971,935,836,592,211,-159,-373,-464,-595,-850,-1102,-1129,-840,-392,-54,35,-21,-33,47,112,79,-1,-53,-104,-213,-346,-425,-481,-649,-970,-1282,-1370,-1175,-809,-415,-68,219,440,588,660,655,588,506,451,420,384,350,352,381,354,201,-54,-316,-518,-673,-804,-895,-904,-810,-636,-435,-271,-189,-182,-191,-161,-88,-1,91,201,311,369,342,259,180,140,132,138,151,168,176,164,128,70,1,-62,-104,-129,-144,-154,-175,-238,-355,-487,-565,-564,-524,-493,-467,-415,-329,-231,-130,-24,75,134,137,106,77,64,61,58,55,59,79,109,124,104,63,37,36,28,-14,-75,-119,-146,-191,-273,-369,-444,-479,-469,-414,-326,-236,-162,-96,-24,47,103,148,187,200,158,73}
        },
        {    // H-40e032a.wav
            {1,0,-2,-1,1,1,-1,-1,0,-1,-2,1,4,1,-1,4,9,3,-5,0,10,5,-9,-6,12,12,-10,-13,16,26,-7,-20,21,26,-7,273,1288,2745,3392,2059,-892,-3531,-4102,-2721,-1069,-491,-741,-644,431,2074,3542,4453,4758,4488,3882,3514,3883,4784,5344,4829,3326,1579,258,-564,-1321,-2445,-3854,-4850,-4657,-3233,-1544,-828,-1517,-2918,-3938,-3980,-3168,-1982,-893,-234,-105,-290,-396,-175,310,830,1217,1420,1459,1405,1363,1372,1346,1177,886,605,419,278,89,-176,-464,-700,-833,-856,-817,-795,-854,-992,-1140,-1189,-1062,-778,-464,-268,-239,-302,-342,-291,-135,113,401,637,739,711,630,560,503,420,292,145,34,6,52,105,108,69,40,36,20,-37,-114,-186,-266,-371,-474,-531,-542,-562,-634,-745,-849,-904,-883,-773,-596,-398,-217,-55,103,250,360,420,441,435,398,321,216,111,26,-45,-120,-211,-310,-405,-487,-556,-607,-624,-589,-493,-349,-189,-51,31,42,-4,-66,-94,-68,-10,38,53,36,1,-41,-80,-110,-133,-154,-171,-173,-160,-148,-154,-175,-194,-200,-193,-184,-187,-212,-245,-256,-226,-172,-126,-101,-86,-72,-61,-55,-45,-26,-5,2,-7,-23,-36,-37,-25,-8,-3,-20,-52,-85,-112,-134,-156,-180,-209,-233,-232,-193,-125,-58,-11,14,28,43,64,81,68,15,-49,-73,-44},
            {-11,-23,11,31,-19,-60,-4,66,14,-83,-41,82,41,-122,-79,125,33,-66,1412,5370,9356,8534,875,-9190,-14134,-10929,-4053,-103,-517,-1105,1879,7323,11434,12346,10947,8409,5371,3561,5551,11174,15642,13627,5273,-3588,-7720,-7591,-7394,-9244,-10959,-9388,-4462,591,2311,-202,-4962,-8859,-9896,-8306,-5847,-4095,-3398,-3223,-2978,-2297,-957,965,2857,3894,3753,2931,2330,2547,3453,4297,4303,3370,2166,1399,1089,757,205,-274,-472,-659,-1179,-1926,-2498,-2706,-2679,-2563,-2363,-2068,-1715,-1338,-1010,-895,-1052,-1204,-935,-205,538,864,807,702,730,812,858,899,974,1044,1061,1005,831,493,57,-308,-504,-630,-852,-1171,-1387,-1289,-877,-376,-50,23,-19,-7,81,148,139,83,8,-112,-269,-391,-450,-551,-799,-1121,-1299,-1203,-905,-555,-232,59,299,451,518,543,548,525,472,409,353,316,314,352,382,326,152,-87,-323,-540,-746,-913,-979,-915,-754,-553,-363,-225,-163,-153,-140,-90,-21,46,122,222,316,348,302,220,155,129,138,162,179,177,169,172,174,145,80,6,-50,-86,-115,-151,-218,-336,-484,-596,-630,-609,-582,-553,-484,-366,-237,-133,-44,51,136,174,157,116,86,69,51,28,14,22,45,59,45,13,-6,2,20,17,-12,-55,-96,-141,-204,-286,-371,-437,-470,-462,-407,-311,-207,-127,-72,-16,54,116,142,145,155,167,143,71}
        },
        {    // H-40e039a.wav
            {-1,1,2,1,-1,0,1,0,-1,-1,0,-1,0,2,3,1,1,6,7,2,0,7,10,0,-9,1,15,8,-10,-4,18,11,-16,-6,30,9,23,456,1544,2734,2819,1101,-1588,-3404,-3227,-1729,-528,-447,-852,-633,558,2166,3487,4204,4311,3944,3449,3326,3801,4483,4655,3940,2615,1270,256,-532,-1432,-2611,-3775,-4285,-3710,-2374,-1250,-1148,-1999,-2993,-3365,-2957,-2097,-1192,-521,-228,-266,-381,-290,77,562,968,1202,1252,1148,991,925,996,1088,1053,875,652,448,228,-47,-335,-550,-645,-645,-617,-630,-722,-875,-1022,-1090,-1042,-887,-671,-463,-325,-269,-251,-206,-88,110,356,584,722,737,653,527,398,275,153,39,-48,-89,-85,-63,-53,-62,-74,-81,-98,-138,-185,-219,-250,-303,-374,-422,-429,-430,-471,-557,-647,-703,-707,-656,-548,-397,-233,-78,65,191,286,339,358,355,322,247,140,35,-45,-101,-153,-215,-292,-380,-465,-529,-562,-560,-516,-425,-296,-160,-56,-9,-18,-62,-108,-123,-98,-52,-13,2,-3,-16,-29,-45,-73,-115,-161,-190,-189,-167,-146,-138,-141,-147,-152,-156,-159,-166,-184,-209,-221,-200,-153,-108,-86,-82,-78,-71,-69,-73,-75,-67,-56,-53,-60,-67,-62,-43,-22,-15,-30,-62,-98,-126,-146,-162,-180,-198,-205,-189,-147,-87,-26,17,32,32,43,71,89,70,24,-11,-15},
            {-23,33,35,-39,-63,23,76,-14,-100,-11,103,6,-149,-34,157,-29,5,2025,6474,10112,8004,-897,-11060,-14995,-10788,-3742,-65,-280,-35,3648,8986,12288,12115,9588,6278,3745,4222,8996,15392,17553,12101,2232,-5474,-7988,-8010,-9266,-11546,-11528,-7444,-1459,2439,1932,-2207,-7180,-10239,-10316,-8319,-5941,-4177,-2992,-2107,-1518,-1134,-473,819,2349,3285,3287,2903,2974,3775,4740,4980,4124,2681,1526,1027,829,482,14,-312,-532,-937,-1601,-2276,-2752,-3037,-3133,-2931,-2430,-1841,-1367,-1042,-887,-964,-1150,-1068,-497,274,746,796,722,773,881,901,861,862,913,964,1005,1004,854,497,42,-335,-588,-815,-1090,-1357,-1470,-1309,-889,-394,-67,0,-52,-28,108,242,276,212,79,-106,-291,-412,-488,-621,-853,-1076,-1145,-1027,-797,-522,-228,50,253,355,393,415,435,445,436,395,327,281,318,422,482,397,188,-43,-249,-467,-717,-930,-1010,-939,-775,-578,-385,-232,-154,-136,-118,-65,0,48,98,182,281,330,296,211,137,117,147,192,212,203,195,210,225,199,127,48,-7,-40,-70,-115,-203,-349,-518,-635,-665,-644,-618,-575,-479,-341,-210,-108,-12,90,171,200,182,141,93,50,18,-4,-21,-23,0,30,32,2,-24,-16,12,22,3,-33,-79,-138,-206,-272,-336,-401,-453,-464,-418,-325,-209,-104,-35,7,56,122,165,150,113,117,157,160,89}
        },
        {    // H-40e045a.wav
            {1,1,1,1,0,-1,0,1,1,0,0,0,-1,0,2,3,2,1,4,8,8,3,3,9,8,-2,-5,7,13,-1,-11,4,19,5,-11,9,23,-8,102,691,1744,2519,2037,164,-1956,-2857,-2181,-964,-430,-725,-973,-394,931,2356,3367,3830,3804,3451,3105,3133,3565,3979,3889,3199,2213,1252,366,-598,-1736,-2890,-3659,-3647,-2839,-1758,-1133,-1304,-1958,-2477,-2489,-2050,-1424,-835,-419,-232,-207,-174,-7,269,546,749,846,819,708,648,761,995,1153,1094,865,602,365,123,-136,-361,-494,-532,-519,-511,-557,-685,-880,-1071,-1164,-1089,-849,-524,-236,-72,-32,-42,-19,75,224,378,475,482,423,356,306,242,127,-22,-146,-206,-211,-187,-150,-108,-78,-78,-108,-147,-172,-183,-199,-238,-290,-323,-320,-305,-321,-386,-477,-552,-586,-569,-502,-392,-260,-130,-16,80,154,201,223,223,194,128,34,-53,-100,-108,-109,-136,-197,-277,-355,-411,-434,-424,-387,-328,-252,-170,-103,-73,-87,-131,-176,-192,-167,-115,-67,-40,-31,-27,-31,-55,-101,-152,-185,-190,-174,-150,-128,-114,-111,-115,-120,-123,-123,-124,-128,-132,-129,-116,-98,-86,-86,-95,-103,-109,-116,-127,-135,-134,-122,-106,-92,-82,-73,-62,-47,-34,-35,-54,-83,-108,-123,-136,-151,-163,-164,-153,-130,-92,-41,6,33,45,61,86,102,89,53,17},
            {35,4,-55,-32,55,57,-52,-86,34,94,-51,-144,40,147,-118,272,3099,7985,10744,6647,-3785,-13604,-15690,-9945,-2826,271,384,1982,6451,10709,11665,9623,6791,4694,4429,7501,13735,18927,17544,8850,-1538,-7577,-8950,-9690,-11792,-12681,-9349,-2921,2199,2760,-876,-6005,-9941,-11258,-9988,-7323,-4746,-2993,-1887,-1109,-686,-602,-388,456,1759,2802,3178,3271,3728,4592,5175,4818,3637,2358,1506,978,464,-3,-211,-271,-592,-1316,-2130,-2723,-3127,-3439,-3493,-3082,-2331,-1583,-1035,-715,-696,-973,-1189,-864,-7,793,1047,887,752,790,826,773,753,842,942,961,937,896,747,413,-28,-425,-722,-970,-1218,-1429,-1503,-1342,-944,-458,-103,19,3,15,113,231,285,255,155,4,-172,-352,-542,-743,-915,-999,-973,-864,-697,-477,-227,-4,144,220,258,284,310,348,389,403,376,354,390,464,485,396,226,33,-180,-438,-711,-898,-933,-839,-685,-523,-381,-284,-242,-223,-179,-101,-24,30,76,137,199,230,217,177,144,151,205,275,311,296,262,249,250,227,168,99,43,-2,-56,-133,-243,-382,-522,-623,-665,-660,-622,-547,-435,-309,-196,-101,-5,95,172,200,182,140,95,56,18,-26,-66,-80,-54,-10,16,9,-7,-4,21,45,43,3,-75,-173,-257,-306,-335,-376,-429,-452,-410,-311,-197,-100,-25,41,103,157,187,179,142,107,100,109,96,50}
        },
        {    // H-40e051a.wav
            {0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,-1,-2,-2,0,2,1,1,3,4,2,-1,1,4,0,-6,-2,9,9,-4,-9,3,10,-2,-9,5,1,-12,152,720,1558,2013,1434,-66,-1522,-1997,-1488,-820,-671,-889,-820,-109,1006,2066,2810,3188,3217,3001,2802,2876,3200,3462,3361,2862,2122,1261,287,-796,-1874,-2717,-3061,-2771,-2013,-1246,-926,-1144,-1578,-1826,-1729,-1382,-943,-526,-226,-108,-136,-179,-130,13,197,381,531,606,612,636,755,924,1001,896,658,398,182,11,-125,-224,-292,-351,-427,-540,-690,-850,-965,-979,-872,-664,-406,-173,-35,-16,-70,-124,-129,-82,4,108,196,230,206,151,89,18,-64,-137,-178,-192,-203,-214,-200,-146,-74,-26,-25,-59,-102,-137,-161,-181,-201,-221,-246,-286,-346,-413,-466,-492,-489,-460,-403,-321,-228,-140,-65,-7,31,46,42,27,2,-35,-75,-97,-87,-62,-54,-80,-130,-182,-223,-250,-259,-251,-233,-218,-212,-211,-212,-218,-231,-244,-241,-214,-172,-135,-116,-113,-117,-125,-140,-161,-175,-173,-158,-139,-121,-106,-99,-98,-99,-93,-77,-60,-55,-60,-66,-67,-72,-84,-98,-107,-116,-132,-150,-163,-171,-180,-188,-185,-168,-146,-128,-111,-86,-56,-32,-28,-44,-68,-86,-94,-100,-111,-124,-136,-146,-152,-140,-101,-45,1,26,47,77,99,87,43},
            {17,-59,-48,51,68,-47,-100,22,104,-37,-158,17,161,-104,160,2857,7896,11144,7453,-3175,-13791,-16683,-11152,-3559,373,1245,3104,7044,10191,10260,8288,6349,5164,5357,8675,15167,20281,18155,8495,-2326,-8282,-9756,-10901,-12828,-12364,-7384,-589,3202,1939,-2637,-7576,-10828,-11464,-9610,-6569,-4041,-2695,-1928,-1110,-421,-195,-98,458,1403,2125,2440,2890,3898,5007,5309,4512,3260,2350,1884,1391,636,-56,-344,-410,-705,-1347,-2082,-2730,-3316,-3738,-3697,-3107,-2299,-1634,-1154,-808,-730,-957,-1091,-657,227,922,1054,891,837,898,861,740,724,834,918,918,916,908,747,374,-80,-470,-787,-1069,-1291,-1406,-1417,-1321,-1069,-667,-269,-55,-40,-63,15,178,314,345,276,150,-18,-236,-495,-741,-904,-958,-929,-836,-671,-443,-217,-62,16,60,98,131,176,269,401,500,510,464,430,428,413,357,265,131,-84,-383,-681,-861,-876,-772,-616,-458,-342,-305,-333,-353,-298,-182,-73,-10,29,74,123,155,160,140,118,129,193,284,346,356,344,343,338,299,233,170,112,34,-72,-187,-293,-393,-493,-581,-643,-668,-640,-551,-423,-302,-212,-134,-42,59,142,185,185,150,98,50,14,-25,-71,-99,-82,-35,1,7,3,10,27,44,50,22,-59,-178,-282,-332,-343,-362,-402,-426,-394,-311,-214,-134,-70,-2,82,166,216,215,178,135,98,63,27,1,-6}
        },
        {    // H-40e058a.wav
            {3,3,2,1,1,2,2,2,1,0,1,3,4,4,3,1,1,3,4,4,3,4,6,5,3,4,7,7,2,1,7,10,3,-4,0,7,1,-8,-1,5,-6,56,373,970,1498,1430,596,-533,-1245,-1264,-946,-783,-840,-782,-341,407,1209,1901,2427,2733,2797,2739,2755,2899,3011,2908,2575,2112,1555,837,-73,-1058,-1887,-2334,-2283,-1811,-1205,-809,-780,-982,-1145,-1115,-923,-672,-441,-288,-250,-294,-318,-242,-92,52,153,234,309,370,427,516,632,707,675,550,402,274,157,35,-85,-189,-282,-378,-477,-565,-633,-671,-659,-577,-435,-279,-167,-129,-154,-203,-242,-250,-221,-159,-82,-20,10,16,19,19,-2,-55,-121,-175,-209,-232,-237,-202,-119,-18,55,75,52,11,-33,-74,-113,-150,-192,-243,-303,-362,-411,-441,-447,-428,-392,-354,-319,-280,-228,-168,-112,-69,-35,-8,5,-6,-38,-70,-80,-64,-38,-21,-21,-38,-67,-103,-134,-154,-167,-185,-210,-232,-242,-245,-249,-254,-253,-243,-228,-212,-199,-189,-183,-181,-179,-172,-164,-159,-153,-140,-117,-91,-69,-56,-52,-53,-54,-52,-49,-48,-46,-44,-44,-49,-56,-65,-81,-105,-131,-153,-169,-183,-193,-192,-178,-159,-140,-122,-104,-85,-63,-39,-21,-19,-31,-43,-51,-63,-86,-110,-128,-142,-154,-148,-114,-67,-32,-9,21,57,69,41},
            {-41,-41,37,65,-33,-105,-4,106,-3,-162,-32,177,-41,-46,2156,7166,11378,9054,-1204,-13097,-17884,-13164,-4746,584,2071,3472,6610,9348,9547,7978,6415,5389,5531,8827,15581,21162,19295,9359,-2170,-8871,-10759,-11761,-12934,-11399,-5702,870,3618,1296,-3641,-8257,-11035,-11434,-9548,-6517,-4016,-2732,-1979,-1039,-178,97,79,452,1195,1651,1687,2055,3313,4840,5420,4648,3304,2327,1814,1302,668,276,253,146,-474,-1416,-2208,-2758,-3285,-3716,-3662,-3044,-2297,-1801,-1476,-1166,-1012,-1115,-1107,-548,383,1018,1056,865,862,991,993,880,843,896,898,847,862,910,792,424,-50,-474,-838,-1166,-1392,-1448,-1378,-1258,-1077,-788,-454,-231,-194,-232,-167,58,329,480,453,309,117,-122,-413,-685,-834,-851,-821,-788,-694,-489,-246,-87,-40,-33,-12,18,63,174,363,538,596,539,459,418,393,347,275,165,-27,-315,-616,-800,-810,-696,-547,-417,-336,-322,-360,-387,-345,-242,-139,-75,-36,1,42,82,112,124,118,121,164,240,307,343,368,404,427,408,352,288,216,109,-41,-202,-333,-425,-491,-549,-606,-649,-641,-562,-437,-317,-232,-163,-84,5,88,153,185,171,121,69,33,-2,-52,-91,-80,-31,-2,-16,-34,-15,29,57,50,15,-49,-146,-252,-319,-333,-330,-350,-382,-378,-316,-230,-161,-111,-56,25,118,191,220,208,176,135,85,27,-23,-43,-28}
        },
        {    // H-40e064a.wav
            {4,3,1,0,1,2,2,3,3,2,2,2,3,3,3,3,3,2,2,3,3,1,1,4,6,5,3,3,4,3,2,5,8,3,-6,-6,1,3,-1,3,11,0,1,133,487,936,1141,847,173,-462,-746,-739,-715,-788,-801,-554,-50,540,1088,1585,2043,2400,2580,2582,2478,2336,2183,2035,1901,1737,1427,857,36,-850,-1508,-1709,-1448,-955,-527,-314,-264,-261,-270,-331,-446,-541,-551,-488,-411,-350,-305,-278,-278,-279,-234,-130,-10,81,147,226,334,442,506,496,402,240,51,-111,-208,-233,-207,-168,-157,-196,-267,-325,-338,-309,-268,-240,-236,-255,-288,-320,-342,-354,-355,-335,-281,-203,-128,-79,-61,-73,-117,-184,-246,-273,-258,-215,-159,-86,5,95,150,154,118,64,4,-60,-127,-191,-246,-294,-340,-380,-406,-412,-403,-388,-370,-347,-319,-285,-239,-172,-92,-25,7,4,-17,-42,-68,-92,-102,-89,-62,-42,-39,-48,-60,-72,-89,-113,-140,-166,-190,-210,-224,-232,-238,-245,-253,-255,-249,-238,-230,-228,-227,-219,-204,-188,-176,-163,-144,-117,-86,-60,-46,-50,-70,-92,-100,-85,-57,-31,-16,-10,-9,-15,-31,-54,-81,-110,-140,-166,-179,-174,-157,-142,-135,-135,-135,-129,-113,-84,-50,-23,-13,-17,-26,-39,-61,-94,-128,-154,-170,-176,-170,-148,-116,-85,-60,-40,-22,-7},
            {-58,24,79,-2,-111,-53,97,58,-142,-113,152,72,-187,1258,5905,11200,10951,1726,-11568,-19034,-15688,-6291,809,2809,3345,5713,8650,9394,7872,6016,5023,5559,9102,15861,21669,20357,10630,-1645,-9618,-12162,-12573,-12375,-9677,-3681,2338,4157,1091,-4114,-8692,-11482,-11988,-9986,-6483,-3547,-2328,-2012,-1323,-304,163,-3,49,696,1326,1493,1761,2815,4219,4798,4137,3035,2348,1986,1419,710,434,693,829,270,-796,-1848,-2723,-3487,-3913,-3636,-2797,-2034,-1739,-1695,-1612,-1561,-1616,-1441,-683,383,1066,1106,913,916,1057,1086,1015,1010,1051,989,854,812,858,774,441,-12,-426,-800,-1173,-1454,-1527,-1430,-1297,-1161,-927,-584,-302,-252,-373,-414,-208,156,452,558,508,359,98,-267,-610,-776,-754,-684,-664,-641,-519,-318,-155,-97,-104,-110,-87,-17,127,339,541,635,600,495,390,314,263,216,135,-34,-291,-556,-716,-722,-612,-463,-334,-262,-266,-330,-393,-395,-329,-237,-156,-100,-63,-35,-6,31,63,81,104,162,248,319,350,369,403,434,425,383,343,301,211,48,-146,-309,-416,-484,-536,-584,-622,-632,-588,-485,-354,-243,-170,-117,-57,16,88,140,160,151,126,92,42,-22,-71,-73,-37,-15,-34,-63,-52,-1,40,31,-20,-83,-142,-195,-233,-253,-270,-304,-346,-362,-330,-267,-208,-158,-95,-5,91,158,183,174,151,123,87,37,-15,-48,-48,-23}
        },
        {    // H-40e071a.wav
            {3,3,2,1,1,1,2,3,3,3,2,2,3,3,3,3,3,3,2,1,1,1,0,0,2,4,4,3,3,3,1,0,2,5,3,-3,-2,5,7,0,-2,4,1,-5,67,305,652,869,738,300,-163,-413,-472,-518,-628,-687,-545,-179,320,851,1331,1678,1842,1869,1871,1904,1919,1860,1765,1722,1728,1646,1318,710,-42,-687,-979,-830,-389,46,250,219,88,-55,-221,-418,-584,-650,-627,-580,-545,-518,-506,-524,-551,-528,-434,-315,-220,-134,-5,170,332,418,407,310,155,-10,-115,-111,-9,128,228,247,176,39,-110,-219,-272,-291,-308,-335,-365,-392,-416,-438,-452,-450,-430,-391,-339,-281,-231,-199,-190,-203,-229,-253,-260,-244,-209,-158,-91,-4,95,182,229,220,160,70,-28,-117,-190,-246,-286,-315,-340,-363,-381,-389,-384,-370,-351,-324,-282,-220,-145,-75,-30,-19,-35,-62,-88,-113,-135,-147,-143,-125,-107,-97,-93,-85,-70,-52,-42,-51,-79,-120,-160,-189,-205,-212,-217,-225,-236,-247,-257,-263,-264,-259,-248,-233,-217,-201,-186,-170,-150,-127,-105,-93,-93,-101,-109,-103,-80,-48,-14,12,25,23,12,-4,-26,-56,-87,-111,-125,-135,-142,-146,-148,-149,-147,-139,-125,-109,-88,-61,-37,-28,-36,-49,-64,-87,-122,-155,-175,-185,-195,-198,-182,-152,-127,-110,-84,-41},
            {-54,54,84,-45,-132,0,139,-4,-201,-30,219,-56,41,2901,8751,12650,8078,-4951,-17448,-19716,-11490,-1461,3080,3180,4009,7006,9153,8392,6221,4917,5275,7877,13488,20164,22293,15690,3081,-8043,-13049,-13363,-12046,-9281,-4049,1904,4694,2599,-2374,-7286,-10768,-12368,-11428,-8072,-4247,-2165,-1938,-1890,-1065,-220,-175,-410,3,904,1444,1563,2071,3233,4182,4080,3218,2449,1989,1449,812,620,1045,1411,1005,-46,-1122,-2001,-2885,-3670,-3840,-3209,-2304,-1750,-1605,-1597,-1672,-1889,-1952,-1393,-268,748,1117,1003,899,974,1055,1067,1121,1220,1192,984,786,750,752,574,201,-216,-600,-985,-1339,-1529,-1501,-1372,-1258,-1109,-821,-471,-286,-359,-491,-412,-91,262,464,521,500,363,47,-367,-665,-727,-650,-597,-588,-526,-372,-212,-141,-152,-170,-143,-63,79,289,521,674,675,550,391,268,188,124,47,-74,-261,-482,-643,-662,-548,-386,-255,-188,-187,-248,-340,-404,-400,-342,-271,-207,-142,-76,-25,2,18,39,75,138,231,331,403,433,431,413,382,344,316,294,242,128,-33,-192,-318,-413,-486,-538,-576,-603,-605,-553,-446,-320,-217,-145,-84,-18,51,110,149,161,150,126,89,30,-36,-67,-42,0,-4,-56,-88,-53,14,36,-13,-90,-147,-175,-186,-191,-201,-232,-285,-328,-330,-293,-248,-209,-157,-71,38,133,182,183,156,121,78,19,-44,-81,-72,-35,-6}
        },
        {    // H-40e077a.wav
            {0,0,0,1,1,1,1,1,1,2,3,3,2,1,1,2,2,0,-1,-1,-1,-1,-1,-1,0,1,1,0,-1,-1,1,2,0,-1,1,3,3,2,2,2,-2,-6,-3,1,-1,22,132,349,570,619,414,71,-200,-301,-311,-338,-363,-271,-12,323,599,756,817,834,866,987,1238,1560,1815,1917,1909,1887,1870,1770,1490,1041,555,212,120,236,378,363,155,-123,-324,-410,-449,-511,-605,-706,-791,-840,-833,-783,-740,-737,-744,-703,-597,-462,-326,-178,-5,153,231,206,130,82,109,208,343,475,570,600,547,410,214,1,-182,-306,-370,-401,-434,-488,-549,-582,-566,-520,-482,-477,-492,-497,-474,-424,-358,-292,-245,-229,-239,-248,-235,-198,-148,-85,-1,99,188,234,229,184,117,42,-33,-103,-169,-231,-283,-316,-325,-320,-318,-327,-335,-326,-300,-269,-240,-205,-160,-115,-89,-90,-111,-143,-177,-205,-222,-228,-226,-215,-188,-142,-82,-20,32,63,65,35,-17,-73,-120,-155,-184,-209,-231,-250,-264,-275,-285,-292,-292,-285,-275,-266,-253,-233,-208,-186,-169,-156,-143,-130,-117,-100,-76,-45,-11,16,30,33,33,30,21,4,-15,-32,-54,-88,-126,-153,-162,-159,-151,-139,-125,-116,-113,-108,-96,-85,-84,-88,-91,-98,-115,-138,-159,-178,-200,-215,-212,-201,-198,-193,-151,-71},
            {-38,88,74,-102,-136,80,164,-98,-232,103,251,-187,585,4992,11283,12473,3332,-11711,-20980,-17462,-6131,2516,4217,3307,4648,7457,8283,6637,4973,5026,7016,11322,17605,22180,19650,8914,-4362,-13029,-14930,-12699,-8808,-3624,1986,5218,3985,-588,-5661,-9580,-12005,-12274,-9707,-5483,-2361,-1782,-2380,-2128,-970,-313,-612,-831,-197,766,1361,1849,2764,3743,3928,3242,2445,1958,1440,721,383,898,1709,1803,961,-177,-1161,-2149,-3176,-3691,-3255,-2284,-1613,-1526,-1667,-1770,-1930,-2105,-1883,-1035,30,683,791,725,779,896,962,1041,1186,1267,1150,928,790,736,597,301,-25,-283,-554,-931,-1310,-1487,-1425,-1289,-1190,-1051,-786,-521,-456,-568,-590,-336,76,391,512,518,450,246,-96,-417,-547,-497,-425,-430,-464,-438,-350,-268,-239,-243,-231,-167,-32,174,419,619,677,569,369,198,117,97,66,-21,-168,-352,-519,-592,-527,-362,-193,-100,-103,-173,-268,-348,-392,-403,-394,-361,-288,-178,-66,1,17,11,20,65,150,264,377,456,483,458,401,345,319,315,283,184,33,-119,-242,-344,-428,-474,-482,-489,-528,-571,-557,-460,-327,-214,-132,-55,28,98,140,153,149,134,109,71,21,-24,-41,-26,-10,-23,-56,-69,-44,-12,-16,-67,-133,-173,-170,-138,-118,-148,-227,-307,-338,-314,-270,-230,-181,-104,-5,90,157,183,166,119,58,-7,-68,-111,-113,-74,-24,2}
        },
        {    // H-40e084a.wav
            {1,2,1,0,0,2,3,3,2,3,4,4,2,1,1,1,1,1,0,-1,-2,-2,0,1,1,1,1,1,1,1,3,4,3,0,-1,2,6,7,5,4,3,-1,-5,-3,0,-3,2,62,208,392,493,412,174,-79,-195,-127,50,202,222,94,-99,-220,-169,53,351,633,887,1173,1528,1897,2159,2239,2180,2102,2086,2083,1950,1584,1031,475,94,-70,-121,-196,-344,-512,-618,-629,-587,-578,-671,-858,-1048,-1129,-1060,-902,-759,-681,-644,-593,-499,-371,-230,-101,-5,49,83,146,276,468,665,797,824,760,650,528,390,211,-11,-233,-397,-479,-504,-525,-577,-649,-702,-699,-642,-566,-514,-502,-512,-511,-477,-413,-338,-272,-227,-201,-184,-166,-138,-94,-38,22,78,127,161,173,162,139,110,70,7,-78,-166,-237,-280,-297,-296,-288,-283,-284,-285,-281,-272,-263,-256,-246,-225,-195,-168,-160,-180,-220,-265,-301,-314,-294,-239,-160,-75,5,74,127,152,140,91,20,-54,-120,-169,-201,-223,-242,-262,-281,-297,-307,-308,-301,-289,-275,-260,-248,-239,-228,-210,-185,-162,-143,-122,-95,-67,-41,-14,17,41,48,43,40,42,39,22,-7,-42,-78,-112,-135,-145,-146,-143,-137,-128,-120,-119,-122,-124,-125,-122,-112,-100,-98,-110,-126,-139,-159,-190,-212,-207,-193,-199,-209,-173,-84},
            {-33,107,69,-133,-134,126,173,-156,-249,180,275,-262,788,5815,12158,12086,1165,-14311,-21916,-16079,-3769,4193,4803,3336,4396,6751,7246,5862,4907,5683,8330,13168,19237,22250,17371,5028,-8146,-15372,-15354,-11133,-5482,419,5001,5980,2775,-2491,-7246,-10534,-12191,-11495,-8193,-4112,-1930,-2195,-2893,-2315,-1102,-761,-1259,-1262,-257,895,1511,2014,2896,3691,3662,2940,2225,1699,1036,376,403,1247,2005,1795,784,-278,-1146,-2069,-2950,-3217,-2662,-1850,-1428,-1434,-1566,-1761,-2088,-2282,-1882,-886,118,590,573,456,463,568,733,968,1184,1221,1067,900,840,777,553,208,-79,-258,-470,-807,-1145,-1299,-1273,-1219,-1191,-1079,-839,-631,-619,-702,-611,-254,171,440,535,545,459,198,-183,-472,-519,-395,-282,-272,-317,-343,-334,-319,-320,-327,-309,-221,-36,224,479,628,605,435,226,85,49,67,61,-14,-152,-315,-442,-477,-403,-269,-155,-116,-153,-230,-298,-330,-337,-355,-395,-420,-370,-237,-84,15,40,27,22,48,115,223,355,467,510,474,405,362,356,338,259,123,-24,-152,-268,-379,-455,-467,-436,-427,-475,-536,-542,-471,-357,-244,-146,-56,32,110,164,184,170,133,86,40,2,-21,-23,-8,2,-11,-44,-73,-79,-72,-76,-106,-147,-167,-145,-94,-66,-112,-229,-348,-393,-348,-261,-181,-112,-33,55,125,156,150,116,61,-4,-62,-101,-118,-114,-94,-60,-23}
        },
        {    // H-40e090a.wav
            {1,1,1,1,1,2,3,3,3,3,3,3,2,2,2,2,1,0,0,0,-1,-2,-2,-1,1,2,2,2,2,3,4,4,3,2,2,2,3,5,6,5,3,1,-2,-8,-11,-8,-4,0,29,116,249,357,373,324,309,369,408,279,-47,-432,-690,-736,-597,-322,66,528,974,1302,1489,1612,1783,2060,2402,2705,2868,2835,2592,2139,1499,756,74,-382,-550,-515,-434,-430,-537,-711,-868,-936,-907,-852,-866,-973,-1084,-1076,-907,-658,-456,-373,-379,-396,-365,-286,-189,-92,23,189,408,639,819,906,899,826,718,591,448,285,98,-110,-322,-506,-631,-682,-679,-666,-679,-716,-744,-731,-671,-586,-502,-439,-406,-394,-379,-338,-267,-190,-138,-119,-117,-109,-86,-54,-13,38,97,150,188,205,196,150,70,-18,-88,-134,-170,-204,-228,-234,-236,-253,-287,-317,-327,-320,-311,-308,-304,-291,-273,-260,-255,-257,-269,-290,-304,-287,-232,-152,-69,6,75,132,158,144,99,36,-36,-104,-154,-179,-192,-213,-244,-272,-285,-286,-283,-279,-271,-258,-249,-250,-256,-254,-234,-200,-167,-141,-120,-98,-74,-48,-19,12,37,48,51,53,54,42,14,-22,-59,-95,-122,-132,-130,-131,-138,-143,-139,-133,-130,-127,-122,-118,-116,-109,-99,-99,-113,-127,-133,-141,-161,-176,-172,-168,-191,-217,-188,-94},
            {-44,120,85,-143,-149,142,197,-173,-282,205,330,-310,594,5634,12154,12180,1117,-14571,-22133,-15887,-3028,5223,5552,3255,3376,5294,6104,5467,5185,6372,9245,14062,19618,21628,15696,2773,-10257,-16578,-14970,-8906,-2061,3608,6667,5842,1513,-3970,-8324,-10859,-11611,-10245,-6935,-3493,-2058,-2667,-3315,-2657,-1544,-1356,-1870,-1740,-533,856,1688,2229,2878,3346,3218,2707,2252,1783,1044,389,516,1379,2031,1746,764,-294,-1236,-2116,-2660,-2483,-1776,-1233,-1241,-1533,-1738,-1874,-2072,-2138,-1741,-928,-143,256,293,201,148,208,422,745,1013,1090,1016,937,899,796,552,254,46,-86,-292,-634,-966,-1111,-1092,-1072,-1108,-1086,-945,-806,-792,-802,-621,-218,204,456,542,542,446,198,-145,-410,-475,-373,-234,-161,-179,-249,-319,-362,-394,-431,-435,-329,-78,250,520,620,528,316,108,7,26,91,109,38,-94,-231,-323,-340,-286,-204,-153,-165,-228,-296,-328,-321,-308,-328,-379,-413,-373,-254,-115,-31,-21,-38,-25,35,132,253,384,487,516,470,408,390,404,379,273,118,-31,-159,-283,-398,-467,-466,-426,-409,-436,-475,-480,-438,-366,-278,-179,-73,26,105,160,186,175,129,75,40,24,10,-1,6,28,28,-19,-86,-125,-121,-107,-120,-157,-181,-158,-94,-44,-73,-191,-331,-398,-352,-237,-125,-49,9,72,132,165,154,102,26,-51,-110,-141,-145,-127,-94,-53,-18}
        },
        {    // H-40e096a.wav
            {0,0,0,0,0,0,1,2,2,2,2,2,2,1,0,-1,-1,0,0,-1,-2,-3,-3,-3,-2,-1,1,2,1,-1,-1,1,3,4,4,5,3,-1,-3,-1,1,-1,-5,-5,-4,-8,-11,-4,6,7,31,173,490,869,1040,792,186,-475,-897,-1001,-880,-638,-310,74,445,739,956,1147,1349,1571,1833,2170,2578,2960,3145,2988,2477,1762,1069,553,217,-43,-304,-546,-700,-753,-774,-846,-991,-1155,-1254,-1221,-1044,-790,-585,-525,-588,-645,-573,-364,-123,28,38,-59,-179,-234,-165,35,313,587,786,881,882,821,728,609,450,242,9,-198,-347,-455,-559,-671,-762,-800,-783,-740,-701,-676,-658,-630,-579,-499,-402,-316,-265,-247,-240,-223,-195,-165,-142,-122,-101,-72,-26,39,110,157,165,144,116,89,56,15,-24,-50,-66,-84,-111,-149,-195,-249,-308,-364,-403,-414,-399,-370,-342,-326,-321,-321,-316,-299,-276,-254,-232,-205,-167,-121,-77,-38,-4,17,16,-6,-31,-47,-54,-60,-69,-87,-119,-165,-209,-234,-237,-227,-216,-211,-215,-228,-247,-264,-272,-268,-251,-224,-190,-153,-117,-87,-67,-57,-43,-17,13,32,40,42,33,6,-33,-70,-98,-123,-146,-160,-161,-157,-154,-148,-139,-132,-128,-118,-103,-93,-92,-92,-87,-88,-99,-106,-101,-103,-124,-147,-151,-160,-202,-247,-221,-112},
            {-71,114,127,-115,-200,86,251,-85,-336,89,420,-192,-23,4017,10824,13056,4358,-11382,-21648,-18070,-5331,4792,6381,3446,2266,3878,5392,5399,5238,6367,9144,13617,18827,21181,16284,4064,-9351,-16524,-15059,-8305,-910,4538,7042,5970,1656,-3916,-8371,-10678,-11012,-9587,-6719,-3727,-2343,-2813,-3514,-3057,-1983,-1667,-2163,-2188,-1046,510,1524,2041,2585,3119,3204,2820,2338,1860,1229,660,712,1427,2041,1827,879,-233,-1205,-2011,-2455,-2255,-1560,-972,-909,-1246,-1650,-1988,-2234,-2216,-1752,-973,-279,33,3,-125,-147,8,292,592,801,885,904,923,933,865,675,416,193,36,-142,-420,-741,-962,-1036,-1048,-1061,-1031,-931,-858,-900,-942,-764,-320,182,511,624,603,476,220,-112,-371,-448,-366,-238,-169,-194,-281,-366,-413,-436,-456,-442,-325,-78,235,492,595,519,322,116,1,1,58,86,41,-58,-163,-232,-243,-207,-163,-161,-218,-303,-360,-358,-317,-290,-315,-380,-429,-406,-299,-160,-66,-51,-73,-61,22,159,308,434,506,503,445,390,385,407,392,304,167,20,-127,-274,-407,-489,-504,-476,-448,-438,-433,-414,-376,-328,-272,-200,-110,-20,54,111,150,160,135,97,78,73,56,23,4,11,8,-37,-103,-138,-126,-109,-130,-180,-213,-192,-123,-53,-46,-132,-264,-348,-327,-231,-131,-64,-13,50,118,160,151,93,12,-60,-108,-130,-131,-112,-75,-36,-10}
        },
        {    // H-40e103a.wav
            {3,3,2,2,2,2,2,3,4,4,3,3,3,3,3,2,2,2,2,2,1,0,0,0,1,2,2,2,1,2,3,3,3,4,7,7,4,1,2,2,-2,-4,0,2,-3,-6,3,8,2,44,239,597,928,949,548,-94,-656,-936,-940,-761,-459,-72,322,634,833,952,1033,1120,1303,1687,2267,2837,3097,2884,2306,1653,1172,917,773,599,358,107,-100,-294,-548,-869,-1165,-1319,-1300,-1182,-1066,-996,-940,-838,-658,-427,-216,-96,-79,-97,-49,106,291,370,267,44,-146,-177,-28,236,522,750,862,833,686,481,270,70,-121,-293,-420,-494,-537,-579,-631,-685,-729,-750,-736,-685,-613,-545,-495,-452,-397,-326,-254,-204,-184,-189,-200,-196,-159,-89,-8,52,77,76,63,45,29,25,37,55,64,61,51,29,-14,-75,-136,-186,-231,-280,-325,-355,-370,-381,-392,-394,-375,-341,-307,-282,-264,-246,-229,-212,-190,-158,-128,-113,-119,-135,-147,-149,-142,-124,-91,-52,-25,-17,-25,-44,-74,-107,-130,-135,-130,-127,-131,-145,-170,-205,-242,-269,-278,-268,-241,-203,-166,-140,-122,-102,-82,-65,-46,-19,12,34,40,31,9,-27,-70,-108,-137,-160,-175,-177,-170,-164,-160,-151,-135,-119,-104,-83,-59,-46,-48,-51,-47,-48,-62,-71,-65,-66,-94,-128,-139,-148,-195,-251,-233,-121},
            {-101,59,158,-26,-221,-43,249,82,-317,-143,394,124,-428,1800,8025,13067,8943,-5113,-18904,-20778,-10154,2332,7033,4489,1618,2222,4324,5171,5088,5923,8458,12476,17253,20351,17723,7586,-5949,-15207,-15617,-9148,-1163,4555,7032,6304,2584,-2868,-7761,-10405,-10698,-9330,-6890,-4210,-2605,-2738,-3600,-3592,-2541,-1764,-2047,-2501,-1889,-315,1105,1819,2240,2758,3140,3068,2646,2096,1455,872,797,1422,2183,2227,1325,-5,-1185,-1989,-2345,-2157,-1546,-959,-803,-1071,-1483,-1852,-2132,-2225,-1959,-1326,-594,-109,-26,-213,-379,-306,8,382,645,768,824,865,893,885,815,662,439,200,-26,-270,-547,-793,-936,-991,-1015,-1006,-937,-867,-893,-973,-898,-530,11,468,698,724,598,326,-43,-366,-502,-439,-296,-205,-219,-307,-404,-472,-506,-504,-441,-287,-45,232,460,567,521,352,152,24,7,52,75,39,-34,-102,-142,-156,-149,-141,-169,-255,-367,-434,-411,-331,-278,-303,-385,-455,-454,-363,-217,-86,-28,-42,-58,-3,137,311,449,510,492,433,381,367,380,384,345,252,111,-59,-231,-381,-490,-547,-544,-493,-430,-388,-362,-333,-297,-262,-224,-160,-70,16,70,100,120,126,111,92,88,89,72,38,7,-18,-58,-113,-151,-152,-138,-150,-191,-222,-202,-130,-52,-28,-82,-183,-266,-287,-248,-182,-112,-45,22,82,122,128,96,40,-13,-45,-61,-76,-86,-78,-50,-19}
        },
        {    // H-40e109a.wav
            {3,3,2,2,2,2,2,3,4,4,3,2,3,4,3,2,2,3,3,3,2,1,1,3,4,3,0,-1,1,1,0,0,3,4,2,1,6,9,3,-4,0,8,3,-8,-2,12,8,30,225,663,1129,1194,613,-366,-1182,-1441,-1186,-712,-233,209,607,906,1067,1121,1120,1114,1197,1513,2105,2769,3131,2937,2253,1388,648,176,-38,-65,20,145,229,192,-8,-337,-692,-972,-1144,-1231,-1246,-1165,-974,-730,-530,-433,-405,-355,-204,51,333,535,600,565,516,494,453,325,117,-80,-164,-100,79,301,482,547,461,256,18,-176,-296,-361,-402,-441,-488,-540,-586,-616,-626,-619,-603,-583,-557,-515,-450,-372,-307,-275,-267,-247,-192,-115,-55,-34,-35,-23,14,56,75,60,17,-37,-79,-87,-54,0,42,50,23,-31,-101,-171,-224,-257,-278,-296,-309,-313,-312,-319,-333,-338,-321,-288,-262,-248,-237,-218,-194,-178,-173,-173,-176,-187,-208,-229,-236,-224,-200,-169,-132,-95,-66,-46,-33,-27,-28,-32,-31,-25,-25,-40,-69,-103,-140,-178,-214,-242,-261,-267,-254,-219,-174,-134,-107,-94,-90,-87,-72,-42,-9,11,14,5,-18,-56,-101,-141,-173,-200,-217,-215,-201,-190,-181,-159,-119,-79,-51,-30,-11,-3,-12,-24,-25,-24,-30,-36,-36,-46,-79,-116,-132,-149,-201,-256,-235,-121},
            {-72,-57,88,106,-105,-192,70,244,-66,-335,51,414,-149,-137,3505,10064,12631,4707,-10486,-20804,-17482,-4687,5577,6678,2564,425,2105,4430,5150,5389,7040,10442,14785,18534,18814,12687,886,-10737,-15479,-11692,-3589,3412,6806,6735,3855,-1054,-6272,-9704,-10513,-9426,-7450,-5141,-3183,-2521,-3228,-3982,-3526,-2271,-1634,-1999,-2253,-1445,12,1164,1824,2433,3067,3314,3002,2428,1854,1303,947,1164,1922,2491,2122,838,-679,-1821,-2395,-2412,-1948,-1281,-858,-938,-1373,-1815,-2059,-2093,-1929,-1546,-1000,-484,-213,-234,-373,-390,-190,123,400,597,752,872,921,905,867,809,679,459,195,-76,-362,-648,-863,-956,-963,-946,-922,-905,-936,-1004,-973,-698,-215,264,560,660,627,469,173,-178,-420,-451,-335,-228,-229,-324,-440,-528,-581,-590,-518,-333,-60,226,443,542,510,368,183,51,30,88,136,109,23,-67,-128,-161,-176,-187,-214,-282,-383,-461,-463,-397,-327,-313,-358,-416,-438,-394,-282,-136,-25,3,-23,-23,64,221,377,472,491,455,400,360,351,360,354,300,184,21,-153,-311,-443,-540,-575,-538,-461,-400,-371,-345,-302,-263,-244,-213,-133,-30,36,51,61,92,113,101,84,97,118,100,40,-25,-75,-124,-178,-212,-211,-199,-204,-214,-194,-132,-59,-20,-38,-99,-174,-235,-267,-260,-212,-132,-43,34,87,117,119,88,38,-2,-18,-28,-52,-76,-72,-37}
        },
        {    // H-40e116a.wav
            {4,4,3,2,2,3,4,3,2,2,3,4,3,2,3,4,4,3,3,3,3,3,3,4,3,2,1,1,-1,-2,1,4,2,-2,0,8,8,-3,-8,2,10,0,-6,9,16,5,103,496,1128,1544,1219,123,-1143,-1865,-1818,-1301,-684,-81,530,1078,1424,1536,1505,1428,1378,1497,1952,2699,3362,3459,2800,1641,470,-328,-649,-624,-480,-395,-412,-458,-462,-447,-494,-638,-821,-953,-986,-923,-791,-632,-499,-418,-359,-262,-105,72,217,331,461,639,830,953,945,801,573,326,109,-49,-136,-159,-141,-111,-81,-48,-15,-1,-29,-104,-215,-341,-459,-542,-573,-562,-542,-533,-529,-510,-477,-452,-442,-429,-386,-311,-228,-163,-127,-116,-113,-100,-64,-6,57,101,106,70,9,-54,-99,-122,-124,-111,-88,-67,-61,-77,-117,-174,-229,-265,-276,-271,-259,-241,-225,-228,-262,-309,-334,-317,-271,-229,-214,-224,-238,-242,-228,-199,-165,-140,-135,-157,-197,-238,-261,-262,-244,-212,-171,-128,-94,-70,-53,-38,-23,-5,15,26,18,-8,-39,-67,-99,-141,-187,-223,-244,-250,-244,-221,-188,-153,-119,-88,-65,-54,-51,-52,-54,-57,-57,-52,-54,-74,-108,-144,-177,-208,-230,-232,-216,-196,-174,-143,-102,-65,-38,-13,10,19,9,-2,-1,1,-9,-24,-33,-47,-76,-104,-116,-135,-192,-250,-229,-117},
            {23,-101,-55,118,89,-146,-161,139,212,-156,-287,188,344,-305,366,4925,11076,11337,1146,-13583,-20582,-14072,-1060,6786,5527,920,-374,2100,4697,5579,6178,8269,11925,15938,18273,16175,8067,-3530,-12384,-13472,-7412,650,5970,7161,5082,859,-4258,-8457,-10258,-9713,-7999,-6017,-4109,-2822,-2827,-3794,-4284,-3401,-1957,-1342,-1645,-1711,-849,387,1254,1827,2529,3231,3430,3025,2380,1771,1264,1071,1471,2229,2527,1780,270,-1211,-2147,-2503,-2394,-1924,-1348,-1054,-1228,-1669,-2027,-2126,-1997,-1692,-1233,-711,-322,-220,-344,-446,-323,4,346,566,692,799,887,909,878,845,798,659,406,110,-158,-407,-665,-893,-1011,-992,-893,-823,-858,-978,-1048,-903,-509,-14,379,581,623,543,333,24,-260,-386,-340,-239,-215,-303,-437,-546,-608,-631,-590,-434,-154,174,433,556,547,446,294,147,69,84,145,161,91,-29,-131,-183,-206,-237,-289,-351,-405,-436,-436,-405,-361,-334,-339,-365,-381,-359,-286,-172,-56,13,18,-1,25,127,274,405,476,481,443,396,363,346,330,294,220,102,-48,-205,-349,-469,-549,-565,-516,-445,-400,-378,-342,-286,-238,-205,-149,-56,24,44,28,39,87,123,124,121,140,149,103,11,-83,-152,-201,-234,-242,-228,-209,-192,-168,-128,-76,-31,-10,-28,-84,-162,-237,-282,-276,-211,-109,-9,59,96,111,99,64,31,25,31,13,-30,-55,-37}
        },
        {    // H-40e122a.wav
            {3,4,3,3,3,3,3,2,2,2,2,2,3,4,3,2,3,4,4,3,3,5,6,5,4,4,0,-5,-5,2,5,-2,-6,3,10,0,-14,-7,9,2,-16,-2,24,11,51,409,1171,1880,1774,559,-1147,-2312,-2418,-1774,-972,-267,409,1069,1554,1767,1798,1772,1738,1805,2211,3051,3961,4262,3530,2000,367,-760,-1209,-1194,-1037,-953,-976,-1025,-1046,-1085,-1219,-1417,-1526,-1420,-1132,-809,-557,-369,-197,-42,59,100,135,231,401,592,739,824,882,947,1000,990,898,759,606,429,207,-33,-228,-346,-419,-485,-535,-525,-441,-318,-215,-179,-228,-344,-475,-565,-591,-571,-535,-498,-465,-431,-382,-300,-187,-82,-32,-50,-99,-128,-119,-86,-46,-1,55,110,137,112,35,-68,-162,-218,-230,-207,-168,-128,-104,-114,-167,-246,-317,-349,-339,-304,-264,-228,-200,-191,-218,-278,-340,-370,-356,-316,-272,-231,-194,-165,-148,-138,-125,-103,-79,-68,-80,-117,-170,-227,-275,-309,-321,-303,-251,-182,-121,-81,-56,-37,-18,0,12,14,4,-9,-20,-34,-66,-116,-166,-201,-218,-228,-228,-211,-179,-141,-99,-54,-19,-10,-34,-78,-122,-151,-156,-140,-119,-111,-119,-133,-152,-178,-204,-215,-204,-181,-154,-123,-91,-66,-50,-31,-7,10,12,12,20,23,7,-19,-36,-51,-77,-103,-114,-130,-181,-235,-218,-113},
            {62,2,-93,-41,108,79,-131,-150,116,195,-127,-262,154,322,-252,285,4381,10218,10987,2022,-11833,-19212,-13946,-1799,6153,5301,544,-1304,1073,4360,6106,7023,8832,11944,15287,16873,14359,6754,-3445,-10825,-11190,-5252,2251,6805,6975,3769,-1174,-6196,-9615,-10435,-9125,-7049,-5159,-3699,-2927,-3220,-4201,-4596,-3595,-1935,-988,-1022,-1053,-339,746,1520,1981,2521,3109,3323,3031,2528,2051,1622,1387,1606,2136,2279,1482,-10,-1427,-2258,-2516,-2406,-2057,-1638,-1426,-1577,-1940,-2215,-2234,-2016,-1623,-1097,-542,-150,-61,-209,-344,-242,100,489,745,847,870,863,836,822,847,843,689,369,25,-207,-353,-542,-800,-1003,-1033,-938,-879,-948,-1062,-1046,-800,-380,57,386,567,605,493,235,-88,-328,-384,-294,-203,-221,-341,-478,-575,-633,-648,-561,-314,50,382,558,572,506,420,316,197,107,88,114,105,14,-122,-229,-272,-284,-319,-386,-450,-476,-461,-425,-387,-351,-316,-288,-274,-272,-261,-216,-130,-33,25,30,27,76,191,332,438,475,453,402,353,320,297,268,222,152,53,-79,-235,-393,-523,-595,-592,-530,-456,-405,-370,-322,-259,-203,-157,-96,-13,53,66,48,52,93,136,150,146,145,134,83,-15,-127,-215,-263,-276,-264,-235,-196,-158,-128,-102,-71,-34,-10,-23,-80,-164,-239,-273,-253,-190,-111,-38,23,70,89,74,47,43,64,76,53,15,-4}
        },
        {    // H-40e129a.wav
            {3,3,2,1,2,3,2,1,2,3,3,3,3,3,3,3,3,2,2,4,7,6,4,5,6,2,-4,-1,7,4,-7,-5,11,13,-8,-18,2,13,-11,-23,13,29,-1,160,839,1878,2412,1592,-413,-2370,-3108,-2544,-1475,-565,157,888,1555,1929,2000,1966,1945,1965,2209,2960,4124,4996,4752,3220,1081,-704,-1598,-1695,-1433,-1209,-1181,-1288,-1407,-1508,-1658,-1884,-2073,-2075,-1868,-1557,-1219,-831,-390,-5,198,246,302,483,747,973,1097,1143,1168,1211,1269,1282,1164,893,564,333,274,323,347,245,-2,-347,-691,-918,-962,-857,-701,-574,-490,-423,-364,-338,-372,-464,-570,-623,-577,-438,-258,-99,3,47,52,39,18,-4,-19,-20,-8,14,48,96,138,128,33,-124,-268,-334,-310,-234,-157,-111,-105,-130,-171,-219,-272,-326,-364,-371,-345,-302,-262,-247,-276,-354,-453,-516,-500,-409,-292,-196,-136,-96,-61,-30,-6,11,25,34,30,1,-55,-127,-203,-273,-333,-377,-395,-375,-318,-242,-169,-104,-45,3,26,19,-4,-26,-36,-35,-27,-25,-42,-80,-130,-177,-212,-230,-223,-187,-128,-64,-12,17,11,-30,-88,-141,-177,-194,-192,-176,-157,-144,-135,-126,-127,-149,-180,-195,-184,-160,-132,-99,-66,-47,-47,-48,-38,-23,-11,5,27,38,24,0,-17,-38,-81,-125,-142,-146,-176,-218,-202,-106},
            {-13,63,32,-78,-62,82,85,-104,-148,88,187,-96,-252,110,304,-203,183,3822,9372,10678,2969,-9996,-17820,-13984,-2887,5203,5084,576,-1679,392,3996,6311,7415,8943,11648,14630,15853,13179,6069,-2918,-9040,-8944,-3546,2922,6555,6163,2726,-2197,-7039,-10232,-10824,-9221,-6806,-4726,-3384,-2916,-3410,-4390,-4724,-3697,-1938,-732,-501,-487,64,1015,1828,2394,2924,3342,3325,2862,2331,1990,1779,1676,1832,2154,2094,1182,-345,-1732,-2457,-2571,-2378,-2075,-1780,-1661,-1826,-2159,-2401,-2382,-2098,-1622,-1030,-437,-17,102,-30,-181,-117,196,579,836,924,924,901,867,849,876,877,709,343,-48,-279,-385,-548,-817,-1027,-1029,-906,-870,-988,-1099,-1007,-684,-263,108,368,512,527,388,119,-178,-373,-402,-328,-273,-303,-385,-453,-490,-519,-517,-403,-133,206,459,546,521,473,422,335,212,110,70,62,18,-91,-227,-327,-369,-388,-426,-484,-515,-486,-416,-358,-338,-332,-302,-248,-207,-199,-199,-163,-82,6,60,79,102,162,256,354,425,450,424,357,278,217,183,161,134,87,5,-125,-296,-466,-584,-623,-589,-515,-438,-382,-341,-290,-223,-159,-112,-62,9,77,101,82,70,102,153,175,158,128,96,39,-57,-170,-260,-305,-308,-278,-226,-167,-125,-112,-114,-105,-74,-43,-46,-94,-163,-215,-230,-214,-180,-134,-76,-11,44,69,62,46,47,67,79,62,27}
        },
        {    // H-40e135a.wav
            {3,2,2,2,1,-1,0,2,2,1,1,1,1,1,3,3,1,2,6,7,4,3,8,8,-1,-5,4,11,-1,-12,1,20,8,-17,-9,19,6,-35,-18,43,23,5,427,1547,2729,2683,800,-1929,-3694,-3591,-2280,-948,-49,709,1510,2101,2266,2183,2123,2131,2252,2802,4010,5393,5866,4697,2263,-250,-1815,-2209,-1890,-1480,-1349,-1499,-1712,-1821,-1884,-2062,-2359,-2563,-2480,-2150,-1760,-1407,-1039,-623,-239,23,202,421,734,1075,1339,1488,1559,1610,1654,1633,1470,1160,814,569,470,451,433,384,289,104,-198,-563,-880,-1066,-1116,-1069,-973,-870,-786,-719,-646,-556,-459,-363,-262,-161,-87,-50,-18,49,143,211,217,176,127,90,61,35,19,22,39,38,-16,-124,-247,-335,-365,-344,-287,-205,-114,-47,-33,-79,-169,-272,-357,-399,-398,-380,-373,-388,-428,-497,-582,-645,-640,-554,-419,-277,-153,-50,37,106,150,171,172,160,137,100,42,-31,-106,-180,-258,-344,-425,-478,-485,-442,-364,-271,-181,-100,-34,4,7,-15,-34,-34,-18,-3,0,-12,-38,-82,-134,-180,-205,-201,-165,-107,-48,-7,10,2,-31,-85,-141,-177,-188,-186,-183,-182,-183,-184,-181,-170,-158,-152,-150,-144,-137,-135,-134,-120,-92,-64,-48,-37,-22,-7,8,26,40,33,2,-28,-44,-66,-111,-152,-157,-149,-174,-217,-203,-107},
            {-22,-20,37,45,-40,-77,27,98,-26,-145,-9,171,26,-223,-56,275,14,-207,1861,6726,10263,6793,-3826,-13999,-15380,-7623,1508,4693,1997,-1101,-626,2608,5647,7173,8147,9917,12543,14504,13570,8545,916,-5431,-6992,-3553,1749,5215,5200,2306,-2000,-6319,-9414,-10432,-9454,-7498,-5649,-4363,-3657,-3555,-3933,-4181,-3607,-2267,-980,-353,-119,335,1122,1896,2493,3065,3594,3747,3338,2639,2049,1683,1504,1581,1906,2073,1515,159,-1392,-2428,-2729,-2552,-2232,-1958,-1834,-1924,-2183,-2438,-2505,-2302,-1863,-1276,-661,-160,100,105,6,29,271,615,872,984,1027,1052,1029,959,910,880,731,376,-43,-296,-370,-472,-716,-943,-964,-842,-813,-958,-1093,-1010,-707,-338,-20,226,389,421,292,54,-186,-338,-376,-340,-297,-300,-343,-383,-400,-407,-396,-299,-63,251,486,541,471,409,402,381,285,153,64,27,-34,-172,-343,-459,-490,-487,-508,-544,-538,-461,-352,-280,-270,-281,-261,-206,-155,-138,-139,-118,-54,34,113,168,208,247,285,318,345,362,351,297,207,110,35,-3,-7,0,-20,-103,-249,-417,-547,-602,-582,-518,-447,-387,-329,-257,-174,-107,-70,-41,11,80,125,127,118,140,184,205,178,120,59,-7,-92,-196,-285,-326,-314,-265,-199,-137,-107,-118,-147,-155,-130,-99,-92,-112,-137,-154,-167,-180,-186,-171,-123,-44,38,80,67,38,42,76,89,52}
        },
        {    // H-40e141a.wav
            {2,3,1,-2,-1,2,1,-2,-2,2,3,1,0,1,1,1,4,7,5,3,9,13,3,-8,1,16,7,-15,-8,22,20,-18,-23,25,37,-24,-46,35,63,-17,250,1418,3063,3579,1695,-1819,-4550,-4780,-3044,-1129,-7,715,1595,2433,2757,2625,2460,2424,2479,2903,4127,5859,6833,5863,3079,-109,-2237,-2830,-2401,-1779,-1517,-1695,-2038,-2241,-2275,-2365,-2646,-2939,-2963,-2672,-2257,-1851,-1401,-866,-381,-108,-12,110,399,822,1253,1588,1780,1842,1847,1853,1813,1614,1243,857,638,607,636,598,453,201,-141,-500,-758,-850,-842,-873,-1016,-1219,-1360,-1345,-1168,-900,-630,-404,-212,-31,131,245,307,347,387,412,397,338,261,190,124,50,-29,-82,-78,-34,-27,-123,-305,-475,-537,-469,-324,-171,-52,14,23,-20,-99,-195,-291,-376,-446,-505,-551,-578,-584,-587,-616,-672,-711,-675,-543,-354,-166,-12,110,209,278,307,297,266,230,188,128,43,-54,-146,-228,-313,-405,-485,-523,-507,-451,-383,-322,-269,-217,-163,-109,-58,-16,17,42,52,43,20,-4,-23,-43,-70,-96,-108,-102,-87,-72,-67,-76,-91,-99,-93,-82,-77,-83,-101,-133,-178,-223,-247,-245,-227,-201,-169,-139,-127,-136,-157,-178,-192,-187,-153,-95,-37,4,35,63,82,80,61,33,-2,-42,-73,-92,-115,-153,-185,-189,-189,-219,-254,-223,-113},
            {29,-15,-40,13,59,-2,-79,-19,89,32,-120,-77,127,108,-154,-154,190,171,-248,703,4513,8915,8542,831,-9582,-14491,-10492,-2313,2747,2294,-194,-561,1790,4735,6631,7683,8944,10900,12839,13045,9977,4011,-1991,-4623,-2883,1021,3828,3871,1564,-1916,-5603,-8617,-10048,-9548,-7788,-5934,-4713,-4183,-4147,-4351,-4327,-3565,-2107,-684,36,172,358,929,1691,2408,3089,3687,3911,3573,2920,2364,2017,1747,1551,1551,1609,1283,329,-934,-1918,-2333,-2334,-2210,-2120,-2105,-2182,-2337,-2480,-2495,-2317,-1954,-1457,-907,-416,-99,7,12,105,371,706,940,1028,1064,1108,1118,1059,984,910,734,379,-21,-249,-299,-385,-628,-872,-922,-830,-817,-951,-1056,-958,-680,-369,-110,95,235,270,191,48,-100,-223,-304,-335,-337,-346,-373,-392,-385,-367,-338,-241,-21,273,490,527,443,382,400,414,335,188,65,-10,-100,-253,-424,-531,-556,-552,-563,-570,-522,-412,-292,-227,-230,-248,-220,-147,-87,-84,-120,-133,-86,6,108,196,262,299,306,295,283,272,245,186,101,16,-40,-54,-37,-17,-36,-117,-252,-401,-518,-571,-559,-502,-427,-355,-290,-226,-161,-107,-71,-39,15,90,150,163,147,145,171,191,169,108,37,-31,-108,-199,-280,-319,-303,-248,-182,-133,-122,-145,-176,-184,-166,-142,-133,-141,-149,-146,-142,-157,-188,-196,-148,-52,39,81,81,78,84,76,40}
        },
        {    // H-40e148a.wav
            {4,1,-1,0,2,1,-1,0,1,1,1,2,1,-1,2,9,9,3,5,15,14,-2,-5,14,21,-5,-20,10,36,2,-39,-3,58,23,-56,-14,92,32,14,820,2707,4300,3454,-267,-4507,-6212,-4674,-1896,-35,694,1344,2335,3073,3124,2844,2710,2757,3021,3951,5714,7325,7177,4662,933,-2103,-3356,-3076,-2222,-1643,-1679,-2140,-2561,-2655,-2600,-2764,-3168,-3418,-3207,-2687,-2197,-1801,-1315,-705,-204,15,89,271,621,1001,1302,1544,1771,1971,2100,2108,1935,1571,1141,840,744,739,673,509,286,5,-360,-747,-1010,-1065,-977,-882,-864,-922,-1013,-1097,-1129,-1065,-887,-616,-298,14,276,465,583,649,670,638,540,387,224,105,49,29,7,-17,-22,-25,-89,-248,-447,-582,-592,-493,-336,-170,-30,53,57,-18,-151,-304,-435,-516,-547,-550,-541,-531,-538,-587,-676,-753,-746,-620,-411,-184,10,152,247,306,333,334,315,282,236,171,84,-19,-125,-222,-304,-372,-433,-486,-513,-498,-447,-388,-339,-297,-247,-188,-133,-86,-41,9,54,79,78,61,41,23,6,-13,-27,-25,-8,2,-16,-65,-125,-170,-184,-162,-117,-74,-52,-57,-86,-134,-189,-230,-241,-225,-199,-172,-149,-140,-156,-192,-226,-238,-224,-185,-125,-56,7,62,117,162,172,138,81,27,-26,-80,-121,-139,-152,-181,-206,-205,-201,-234,-275,-245,-124},
            {-1,29,13,-32,-19,42,34,-50,-60,46,76,-56,-119,39,148,-37,-200,31,248,-79,-15,2346,6705,8973,4929,-4237,-11794,-12034,-6081,-86,1644,276,-438,1197,3903,5913,6946,7879,9434,11374,12422,10985,6639,1204,-2247,-2017,667,2954,2978,924,-2043,-5071,-7677,-9270,-9349,-8112,-6428,-5093,-4351,-4100,-4182,-4293,-3928,-2814,-1320,-139,442,728,1095,1585,2098,2677,3345,3838,3814,3291,2648,2185,1902,1722,1663,1654,1382,577,-599,-1632,-2134,-2154,-2008,-1942,-2017,-2190,-2396,-2559,-2594,-2449,-2122,-1658,-1128,-626,-260,-88,-48,22,249,591,891,1059,1143,1207,1229,1161,1031,885,683,369,22,-191,-248,-312,-504,-719,-790,-747,-768,-908,-1010,-920,-664,-376,-132,61,184,197,111,0,-89,-168,-253,-325,-362,-378,-395,-409,-407,-394,-367,-277,-68,222,452,511,439,376,392,419,363,230,102,12,-86,-233,-393,-501,-541,-553,-565,-557,-499,-397,-299,-248,-245,-250,-217,-145,-79,-67,-102,-132,-112,-45,39,124,209,284,326,316,265,200,145,102,65,29,-3,-24,-36,-50,-83,-149,-249,-367,-469,-525,-523,-473,-399,-322,-255,-197,-146,-106,-84,-67,-29,38,106,140,141,139,154,172,162,114,44,-28,-95,-159,-216,-253,-259,-234,-194,-165,-164,-185,-206,-208,-191,-172,-164,-165,-161,-149,-144,-163,-192,-191,-138,-54,22,73,106,117,93,43}
        },
        {    // H-40e154a.wav
            {-3,0,2,-2,-5,-2,3,2,-1,-1,-1,-4,-1,8,10,0,-2,11,16,-3,-14,7,25,0,-27,1,44,16,-46,-23,62,50,-55,-44,98,77,-38,620,2668,4884,4617,648,-4762,-7635,-6250,-2621,143,1092,1482,2370,3343,3624,3323,3072,3114,3433,4355,6140,7961,8095,5585,1422,-2262,-4005,-3866,-2851,-1966,-1746,-2174,-2801,-3136,-3117,-3113,-3378,-3686,-3637,-3180,-2600,-2066,-1479,-795,-232,-9,-15,74,429,939,1417,1776,2008,2120,2149,2138,2049,1786,1357,952,768,786,803,647,305,-152,-645,-1069,-1290,-1250,-1053,-887,-860,-927,-975,-941,-836,-704,-579,-471,-363,-221,-22,219,452,625,720,744,706,601,442,275,151,77,27,-1,22,88,99,-47,-332,-607,-724,-658,-486,-296,-143,-61,-70,-155,-274,-385,-467,-513,-523,-515,-514,-524,-532,-538,-563,-614,-649,-599,-437,-209,10,180,305,402,463,468,412,317,215,116,14,-91,-185,-259,-324,-398,-477,-542,-577,-576,-540,-474,-392,-313,-247,-189,-131,-76,-30,8,41,66,78,81,83,84,77,59,39,30,39,55,52,15,-50,-120,-170,-196,-201,-186,-157,-131,-122,-129,-140,-151,-166,-183,-192,-190,-184,-179,-179,-191,-219,-250,-261,-238,-187,-121,-49,24,90,145,187,203,177,114,43,-15,-69,-123,-161,-175,-187,-213,-233,-223,-210,-235,-270,-239,-122},
            {3,-10,6,27,4,-29,-5,42,16,-54,-35,59,51,-72,-88,68,115,-79,-161,90,197,-133,231,2851,6830,8164,3633,-4783,-10924,-10522,-5339,-624,631,-149,-34,1926,4489,6282,7157,7855,9029,10534,11255,9842,6143,1910,-474,-199,1299,1948,933,-1178,-3627,-6083,-8184,-9201,-8642,-6950,-5227,-4284,-4136,-4333,-4449,-4192,-3393,-2161,-924,-90,344,703,1200,1778,2344,2915,3443,3693,3496,3020,2607,2377,2176,1895,1629,1424,1084,387,-575,-1432,-1910,-2055,-2081,-2116,-2166,-2224,-2312,-2409,-2431,-2298,-2000,-1579,-1090,-613,-247,-41,76,238,496,759,919,980,1029,1088,1099,1017,864,660,393,94,-123,-185,-180,-250,-401,-512,-538,-583,-725,-870,-853,-651,-394,-193,-45,75,139,112,24,-65,-146,-247,-362,-444,-464,-447,-430,-423,-415,-398,-345,-209,16,251,385,394,367,394,455,454,356,223,125,48,-61,-207,-335,-413,-466,-528,-584,-593,-543,-465,-401,-363,-328,-268,-180,-100,-70,-91,-120,-117,-79,-25,42,133,234,299,297,238,172,136,130,130,112,73,24,-20,-57,-101,-164,-246,-332,-408,-459,-469,-430,-357,-281,-225,-190,-168,-151,-140,-130,-109,-64,4,75,121,134,127,126,134,129,95,44,-4,-47,-97,-152,-192,-204,-198,-194,-200,-208,-214,-217,-217,-211,-199,-186,-173,-162,-156,-159,-165,-163,-143,-100,-29,58,122,122,63}
        },
        {    // H-40e161a.wav
            {0,-1,-3,-2,2,3,0,-1,-1,-3,-3,5,11,3,-4,6,18,5,-16,-3,26,14,-28,-22,35,41,-31,-56,30,77,-21,-83,51,136,-27,230,1956,4705,5823,2850,-3221,-8111,-8351,-4662,-652,1274,1727,2344,3394,3996,3801,3401,3334,3644,4457,6080,8072,8861,7039,2969,-1344,-3989,-4491,-3646,-2561,-2016,-2248,-2923,-3425,-3467,-3372,-3576,-3978,-4062,-3601,-2915,-2364,-1893,-1282,-608,-163,1,159,530,1024,1449,1772,2060,2293,2394,2357,2210,1916,1455,979,723,728,767,612,267,-124,-496,-875,-1219,-1397,-1355,-1207,-1104,-1076,-1045,-955,-825,-685,-525,-329,-131,10,74,105,163,276,431,597,719,733,621,448,318,266,229,152,74,73,127,104,-95,-410,-677,-778,-717,-566,-392,-240,-145,-127,-177,-267,-372,-474,-548,-577,-567,-542,-516,-494,-491,-529,-593,-614,-523,-319,-73,136,289,409,506,553,524,425,291,150,19,-93,-180,-248,-311,-386,-477,-573,-652,-691,-679,-620,-527,-416,-300,-193,-109,-59,-39,-30,-7,35,79,110,128,143,150,134,97,61,50,63,77,69,30,-36,-112,-176,-212,-222,-223,-221,-214,-201,-185,-167,-151,-145,-154,-170,-179,-182,-189,-209,-237,-265,-279,-263,-210,-138,-72,-19,37,100,152,177,174,149,101,38,-17,-56,-97,-151,-201,-225,-233,-241,-238,-209,-184,-205,-244,-222,-115},
            {4,8,-4,-6,16,21,-10,-25,13,37,-11,-54,-1,64,8,-88,-35,97,48,-130,-83,158,86,-146,853,3980,7311,6948,1242,-6488,-10676,-8971,-4154,-584,219,5,864,3000,5228,6631,7297,7892,8877,9945,10068,8392,5305,2379,951,871,891,94,-1418,-3154,-4955,-6782,-8149,-8321,-7161,-5463,-4271,-3994,-4284,-4566,-4479,-3897,-2853,-1580,-463,236,585,848,1203,1672,2249,2899,3442,3616,3367,2947,2633,2423,2150,1791,1481,1221,792,57,-790,-1405,-1676,-1790,-1957,-2189,-2380,-2475,-2495,-2443,-2274,-1963,-1539,-1063,-611,-271,-99,-45,36,248,549,801,916,917,872,816,749,667,557,399,203,39,-34,-52,-103,-207,-305,-367,-451,-603,-750,-762,-609,-390,-205,-65,49,118,108,29,-74,-181,-297,-412,-494,-527,-528,-517,-491,-451,-415,-380,-299,-134,77,238,304,331,394,486,524,463,347,239,142,23,-113,-227,-313,-406,-530,-647,-701,-684,-634,-579,-515,-432,-335,-234,-144,-91,-90,-118,-128,-94,-33,34,106,187,253,268,229,175,149,158,172,160,115,51,-15,-82,-154,-231,-301,-355,-392,-414,-412,-378,-320,-262,-223,-207,-202,-197,-187,-175,-161,-139,-96,-33,29,63,68,71,90,115,122,100,58,10,-38,-82,-120,-153,-181,-199,-208,-215,-229,-247,-258,-258,-247,-231,-216,-204,-194,-178,-160,-151,-151,-134,-78,-4,39,31}
        },
        {    // H-40e167a.wav
            {-6,-4,1,1,-3,-3,-1,-5,-7,3,12,4,-7,3,18,6,-18,-9,24,18,-27,-29,29,43,-29,-63,21,79,-15,-91,38,142,-16,210,1970,4959,6448,3601,-2913,-8648,-9530,-5828,-1295,1161,1880,2648,3917,4702,4449,3810,3617,4042,5013,6592,8375,9050,7353,3511,-733,-3623,-4621,-4274,-3426,-2774,-2731,-3210,-3662,-3670,-3482,-3665,-4268,-4683,-4406,-3607,-2770,-2045,-1279,-504,-6,128,206,551,1123,1673,2084,2400,2621,2680,2579,2377,2047,1520,912,518,486,609,557,240,-182,-572,-937,-1283,-1503,-1510,-1378,-1266,-1232,-1199,-1087,-907,-715,-532,-348,-169,-18,107,230,358,461,517,548,586,604,539,386,239,197,250,301,297,274,262,192,-36,-406,-757,-920,-848,-621,-356,-142,-23,-4,-62,-165,-291,-416,-505,-538,-533,-529,-544,-563,-572,-583,-609,-620,-556,-384,-142,89,262,384,482,561,596,562,460,307,127,-53,-203,-305,-370,-422,-481,-553,-631,-698,-724,-691,-608,-503,-393,-281,-177,-100,-61,-45,-22,16,57,92,125,159,186,197,192,185,183,180,157,103,26,-53,-117,-163,-196,-222,-242,-256,-265,-265,-252,-222,-180,-140,-117,-124,-156,-192,-217,-232,-248,-265,-269,-251,-211,-154,-88,-22,37,91,142,179,186,162,120,70,14,-46,-98,-139,-177,-212,-230,-225,-217,-218,-214,-192,-178,-201,-232,-203,-102},
            {-9,-8,7,11,-4,-8,13,20,-7,-23,8,30,-8,-45,-3,51,6,-74,-33,77,41,-106,-69,132,77,-99,822,3675,6827,6757,1714,-5610,-10121,-9198,-4891,-1171,183,459,1540,3644,5596,6518,6685,6967,7828,8886,9246,8262,6120,3717,1880,727,-200,-1290,-2547,-3839,-5155,-6422,-7239,-7109,-6041,-4733,-4007,-4076,-4476,-4630,-4325,-3645,-2693,-1567,-491,263,635,843,1143,1613,2190,2773,3217,3355,3160,2828,2575,2392,2119,1733,1389,1145,814,215,-546,-1179,-1544,-1756,-1958,-2139,-2220,-2205,-2166,-2121,-2006,-1764,-1409,-1006,-619,-300,-77,69,196,346,504,624,680,693,703,726,737,683,530,310,104,-24,-80,-112,-147,-174,-198,-266,-408,-570,-638,-559,-381,-196,-55,38,88,90,51,-13,-99,-219,-365,-495,-571,-591,-577,-540,-484,-429,-397,-371,-302,-166,-2,134,238,349,481,585,598,517,388,252,113,-25,-143,-238,-337,-463,-596,-691,-726,-720,-696,-649,-568,-456,-333,-219,-135,-99,-106,-116,-86,-15,65,129,182,234,276,289,275,249,223,193,153,101,41,-25,-97,-178,-261,-330,-364,-359,-329,-295,-264,-235,-209,-192,-188,-193,-200,-204,-206,-209,-212,-197,-152,-86,-28,2,13,36,86,146,181,172,131,83,41,-1,-56,-121,-176,-202,-205,-209,-229,-256,-272,-270,-258,-245,-231,-209,-178,-146,-128,-128,-133,-119,-79,-31}
        },
        {    // H-40e174a.wav
            {-2,0,-1,-1,0,-3,-6,0,10,7,-5,0,17,13,-12,-13,19,25,-17,-35,15,48,-9,-65,-6,74,12,-91,-7,138,31,67,1431,4380,6696,5131,-873,-7610,-10284,-7675,-2897,391,1531,2267,3712,5114,5396,4737,4165,4312,5153,6505,8023,8805,7762,4724,865,-2246,-3869,-4276,-4083,-3761,-3614,-3746,-3948,-3908,-3686,-3732,-4268,-4869,-4911,-4281,-3384,-2539,-1692,-771,9,409,533,711,1098,1583,2043,2454,2764,2851,2698,2443,2179,1830,1344,885,659,618,492,133,-332,-718,-1007,-1277,-1511,-1608,-1551,-1448,-1389,-1348,-1258,-1117,-966,-800,-577,-296,-30,159,288,419,567,686,744,756,729,622,405,155,10,26,112,151,131,113,98,4,-220,-499,-694,-724,-604,-397,-171,7,91,78,12,-71,-173,-299,-420,-497,-534,-568,-615,-648,-649,-639,-645,-638,-551,-358,-111,111,276,405,519,604,629,583,473,311,114,-79,-225,-313,-380,-465,-569,-662,-720,-733,-705,-637,-538,-430,-332,-244,-167,-113,-92,-86,-58,1,64,106,135,170,212,243,253,247,229,196,143,74,-1,-71,-129,-173,-208,-239,-265,-281,-284,-273,-242,-195,-150,-128,-135,-162,-196,-227,-249,-255,-250,-243,-235,-214,-175,-125,-75,-18,53,131,191,216,203,159,101,43,-13,-72,-129,-168,-190,-210,-232,-241,-228,-211,-208,-206,-187,-171,-187,-213,-188,-96},
            {-2,-4,-9,-4,9,8,-6,-3,17,17,-11,-18,14,25,-16,-39,8,46,-9,-70,-12,75,13,-104,-26,138,30,-7,1253,4255,6949,5972,321,-6721,-10293,-8586,-4169,-757,491,1096,2576,4663,6114,6395,6118,6174,6892,7913,8522,8075,6422,4052,1742,-45,-1367,-2477,-3477,-4364,-5185,-5913,-6251,-5860,-4895,-4067,-3984,-4502,-4917,-4734,-4035,-3141,-2189,-1188,-272,366,732,1024,1379,1775,2181,2607,2975,3102,2933,2648,2432,2234,1904,1481,1151,939,631,82,-560,-1039,-1305,-1512,-1760,-1976,-2063,-2043,-1993,-1924,-1780,-1534,-1223,-900,-597,-335,-126,43,209,396,587,736,816,842,842,812,708,507,259,61,-41,-94,-160,-232,-253,-215,-195,-269,-413,-520,-510,-391,-226,-73,38,93,92,60,12,-58,-165,-293,-405,-478,-522,-555,-573,-565,-546,-539,-536,-488,-357,-166,27,190,335,473,578,610,563,462,332,182,27,-101,-194,-285,-416,-575,-706,-771,-779,-754,-696,-599,-476,-357,-260,-188,-146,-135,-129,-88,-1,97,168,209,243,278,302,298,268,226,181,133,76,8,-68,-143,-213,-274,-315,-324,-297,-251,-212,-190,-180,-174,-173,-184,-205,-227,-243,-252,-254,-249,-232,-200,-154,-102,-58,-25,7,57,125,189,214,192,148,112,76,12,-81,-166,-209,-215,-217,-233,-254,-263,-258,-246,-235,-231,-227,-209,-172,-136,-124,-126,-106,-53}
        },
        {    // H-40e180a.wav
            {-2,-3,0,-2,-8,-5,7,10,-2,-3,14,17,-7,-18,10,27,-7,-37,1,47,7,-62,-26,64,32,-84,-42,122,65,-18,991,3746,6580,6169,1020,-6096,-10229,-8974,-4487,-648,953,1639,2996,4832,5919,5807,5229,5081,5642,6690,7787,8290,7515,5285,2232,-631,-2629,-3681,-4061,-4147,-4302,-4666,-4976,-4817,-4204,-3725,-3916,-4608,-5100,-4916,-4165,-3169,-2060,-892,97,624,723,747,986,1442,1973,2471,2836,2954,2824,2604,2410,2148,1695,1164,815,703,593,270,-212,-670,-1048,-1404,-1715,-1854,-1782,-1636,-1571,-1592,-1583,-1457,-1222,-931,-625,-338,-101,77,231,401,586,738,822,855,873,853,718,445,128,-101,-195,-213,-207,-160,-62,8,-62,-279,-517,-634,-581,-404,-179,22,144,165,113,34,-51,-150,-262,-361,-429,-480,-542,-607,-647,-656,-657,-663,-640,-535,-341,-106,113,300,463,596,667,655,564,416,235,52,-97,-195,-265,-353,-481,-624,-736,-794,-793,-735,-630,-500,-377,-279,-207,-154,-121,-104,-83,-39,27,92,145,190,233,264,272,261,242,214,169,106,35,-36,-105,-169,-222,-253,-263,-258,-244,-224,-206,-191,-176,-166,-173,-199,-230,-248,-250,-243,-236,-231,-225,-211,-180,-133,-82,-36,15,83,157,206,214,190,152,103,40,-33,-103,-158,-190,-202,-211,-233,-261,-267,-243,-217,-209,-205,-181,-153,-152,-167,-148,-76},
            {-2,-3,0,-2,-8,-5,7,10,-2,-3,14,17,-7,-18,10,27,-7,-37,1,47,7,-62,-26,64,32,-84,-42,122,65,-18,991,3746,6580,6169,1020,-6096,-10229,-8974,-4487,-648,953,1639,2996,4832,5919,5807,5229,5081,5642,6690,7787,8290,7515,5285,2232,-631,-2629,-3681,-4061,-4147,-4302,-4666,-4976,-4817,-4204,-3725,-3916,-4608,-5100,-4916,-4165,-3169,-2060,-892,97,624,723,747,986,1442,1973,2471,2836,2954,2824,2604,2410,2148,1695,1164,815,703,593,270,-212,-670,-1048,-1404,-1715,-1854,-1782,-1636,-1571,-1592,-1583,-1457,-1222,-931,-625,-338,-101,77,231,401,586,738,822,855,873,853,718,445,128,-101,-195,-213,-207,-160,-62,8,-62,-279,-517,-634,-581,-404,-179,22,144,165,113,34,-51,-150,-262,-361,-429,-480,-542,-607,-647,-656,-657,-663,-640,-535,-341,-106,113,300,463,596,667,655,564,416,235,52,-97,-195,-265,-353,-481,-624,-736,-794,-793,-735,-630,-500,-377,-279,-207,-154,-121,-104,-83,-39,27,92,145,190,233,264,272,261,242,214,169,106,35,-36,-105,-169,-222,-253,-263,-258,-244,-224,-206,-191,-176,-166,-173,-199,-230,-248,-250,-243,-236,-231,-225,-211,-180,-133,-82,-36,15,83,157,206,214,190,152,103,40,-33,-103,-158,-190,-202,-211,-233,-261,-267,-243,-217,-209,-205,-181,-153,-152,-167,-148,-76}
        }
    },
    {    // elev0
        {    // H0e000a.wav
            {10,-6,-11,14,24,-10,-29,13,44,-9,-61,1,79,11,-106,-39,124,70,-141,-92,165,90,26,1603,5325,8205,6062,-913,-6758,-5958,-256,3108,198,-4855,-5132,707,7288,9070,5983,2404,2334,6354,11783,14420,11071,2366,-6538,-9538,-5107,1896,4538,36,-8166,-13924,-13540,-8115,-2025,572,-1366,-5295,-7336,-5526,-1277,2233,3012,1627,80,-138,1084,2892,4213,4326,3285,1955,1360,1769,2466,2495,1544,129,-907,-994,-189,832,1213,592,-585,-1495,-1699,-1408,-1095,-1032,-1237,-1639,-2133,-2545,-2714,-2625,-2419,-2228,-2049,-1774,-1328,-765,-256,40,117,116,191,391,684,1016,1307,1449,1378,1157,926,777,699,639,550,392,154,-97,-247,-256,-222,-284,-477,-698,-816,-792,-702,-664,-733,-856,-924,-871,-733,-602,-544,-564,-603,-578,-449,-251,-71,32,74,105,159,240,350,471,551,534,417,258,114,13,-35,-31,-5,-18,-105,-226,-305,-307,-274,-268,-310,-369,-396,-365,-291,-213,-166,-158,-175,-180,-147,-76,-5,8,-60,-171,-246,-231,-136,-20,59,79,57,27,16,26,36,18,-37,-105,-145,-140,-119,-121,-153,-186,-196,-185,-178,-190,-217,-240,-239,-201,-129,-44,26,66,73,52,13,-26,-45,-40,-32,-48,-96,-157,-201,-209,-186,-161,-157,-175,-193,-189,-161,-121,-84,-61,-50,-41,-28,-17,-20,-37,-53,-61,-58,-47,-38,-41,-56,-68,-58,-28},
            {10,-6,-11,14,24,-10,-29,13,44,-9,-61,1,79,11,-106,-39,124,70,-141,-92,165,90,26,1603,5325,8205,6062,-913,-6758,-5958,-256,3108,198,-4855,-5132,707,7288,9070,5983,2404,2334,6354,11783,14420,11071,2366,-6538,-9538,-5107,1896,4538,36,-8166,-13924,-13540,-8115,-2025,572,-1366,-5295,-7336,-5526,-1277,2233,3012,1627,80,-138,1084,2892,4213,4326,3285,1955,1360,1769,2466,2495,1544,129,-907,-994,-189,832,1213,592,-585,-1495,-1699,-1408,-1095,-1032,-1237,-1639,-2133,-2545,-2714,-2625,-2419,-2228,-2049,-1774,-1328,-765,-256,40,117,116,191,391,684,1016,1307,1449,1378,1157,926,777,699,639,550,392,154,-97,-247,-256,-222,-284,-477,-698,-816,-792,-702,-664,-733,-856,-924,-871,-733,-602,-544,-564,-603,-578,-449,-251,-71,32,74,105,159,240,350,471,551,534,417,258,114,13,-35,-31,-5,-18,-105,-226,-305,-307,-274,-268,-310,-369,-396,-365,-291,-213,-166,-158,-175,-180,-147,-76,-5,8,-60,-171,-246,-231,-136,-20,59,79,57,27,16,26,36,18,-37,-105,-145,-140,-119,-121,-153,-186,-196,-185,-178,-190,-217,-240,-239,-201,-129,-44,26,66,73,52,13,-26,-45,-40,-32,-48,-96,-157,-201,-209,-186,-161,-157,-175,-193,-189,-161,-121,-84,-61,-50,-41,-28,-17,-20,-37,-53,-61,-58,-47,-38,-41,-56,-68,-58,-28}
        },
        {    // H0e005a.wav
            {-5,4,8,-2,-4,12,13,-15,-21,18,35,-16,-52,6,63,-1,-86,-18,104,36,-124,-51,147,58,121,1726,5032,7249,4984,-1121,-5781,-4674,200,2660,-162,-4397,-4330,787,6304,7766,5302,2512,2586,5983,10533,12741,9886,2501,-5045,-7661,-4163,1384,3341,-464,-7204,-11937,-11685,-7290,-2270,-47,-1536,-4683,-6310,-4815,-1339,1572,2340,1386,228,14,891,2283,3388,3595,2860,1805,1253,1508,2101,2277,1666,538,-452,-722,-166,735,1227,871,-109,-1074,-1538,-1475,-1188,-1023,-1191,-1685,-2283,-2667,-2654,-2331,-1953,-1716,-1619,-1511,-1234,-765,-240,157,347,387,375,369,412,552,784,999,1064,949,739,546,426,373,340,262,106,-80,-205,-236,-240,-311,-471,-651,-757,-748,-664,-602,-636,-749,-840,-818,-688,-532,-434,-413,-429,-415,-326,-169,-3,112,165,187,211,252,306,359,382,355,276,164,41,-65,-125,-126,-102,-114,-184,-265,-293,-256,-201,-182,-213,-269,-306,-291,-226,-151,-114,-132,-176,-193,-159,-93,-40,-40,-96,-173,-219,-197,-115,-18,42,43,5,-29,-34,-19,-14,-39,-88,-134,-152,-141,-120,-111,-120,-135,-146,-148,-151,-165,-186,-198,-185,-145,-90,-36,11,48,70,66,38,2,-21,-30,-41,-69,-114,-163,-199,-207,-191,-172,-171,-190,-206,-200,-173,-138,-108,-90,-83,-82,-76,-62,-49,-46,-52,-56,-53,-48,-44,-38,-27,-12},
            {-13,10,32,1,-37,-3,53,15,-71,-40,79,61,-98,-104,100,144,-105,-187,119,207,-79,852,4477,8663,8318,1500,-6511,-8111,-2472,3013,1694,-4136,-6346,-1107,6855,10338,7572,2956,1716,5442,11670,15779,13631,4732,-6062,-11412,-7857,518,5531,2340,-6591,-14349,-15649,-10505,-3320,826,-259,-4607,-7890,-7023,-2621,1902,3603,2352,265,-560,477,2600,4503,5112,4178,2527,1490,1733,2643,2985,2106,433,-1012,-1421,-707,466,1123,713,-434,-1451,-1758,-1480,-1109,-981,-1145,-1532,-2028,-2462,-2697,-2752,-2742,-2710,-2577,-2253,-1739,-1136,-616,-325,-243,-152,155,653,1128,1435,1596,1664,1611,1417,1171,994,905,839,738,577,347,75,-148,-240,-237,-273,-433,-660,-817,-828,-738,-677,-735,-883,-995,-973,-839,-700,-637,-649,-685,-683,-588,-401,-194,-58,-14,6,71,187,322,452,553,589,530,399,255,140,69,46,55,44,-36,-171,-278,-290,-231,-194,-246,-368,-479,-504,-430,-310,-218,-194,-218,-237,-205,-124,-35,5,-39,-148,-245,-251,-147,7,120,144,104,57,40,51,67,60,14,-56,-108,-111,-87,-90,-143,-209,-238,-224,-208,-221,-256,-285,-289,-262,-202,-117,-30,31,56,48,19,-18,-45,-53,-47,-47,-70,-121,-174,-192,-167,-133,-131,-164,-195,-192,-159,-122,-92,-67,-45,-30,-17,3,21,16,-14,-46,-55,-45,-36,-41,-55,-71,-80,-75,-53,-23}
        },
        {    // H0e010a.wav
            {-2,-3,1,8,3,-9,-4,15,13,-14,-17,16,26,-16,-36,15,48,-14,-68,3,85,7,-103,-9,128,28,238,1913,4836,6366,3888,-1450,-4974,-3542,547,2136,-571,-3933,-3427,1084,5607,6709,4719,2584,2829,5792,9635,11351,8665,2210,-4179,-6311,-3420,1015,2431,-830,-6436,-10377,-10182,-6482,-2216,-328,-1613,-4265,-5552,-4182,-1208,1242,1919,1181,216,-47,618,1839,2910,3169,2500,1514,1047,1392,2059,2294,1742,680,-261,-543,-86,667,1061,748,-58,-832,-1214,-1220,-1103,-1113,-1376,-1839,-2286,-2461,-2279,-1906,-1603,-1489,-1467,-1358,-1061,-620,-163,193,409,506,516,463,388,357,405,497,560,547,470,376,302,249,181,63,-87,-201,-226,-191,-189,-295,-490,-676,-757,-711,-606,-548,-589,-682,-728,-668,-524,-365,-254,-220,-234,-231,-160,-37,78,143,171,187,197,196,197,215,230,206,135,44,-40,-109,-159,-180,-178,-190,-238,-293,-296,-231,-146,-107,-136,-199,-246,-251,-217,-165,-121,-105,-121,-147,-148,-113,-72,-69,-114,-174,-201,-172,-101,-24,28,37,7,-35,-60,-59,-50,-60,-96,-137,-156,-147,-127,-120,-130,-145,-151,-147,-139,-136,-142,-154,-157,-138,-94,-36,22,66,86,75,39,-4,-37,-55,-67,-85,-115,-150,-173,-175,-166,-169,-191,-218,-228,-216,-191,-161,-132,-111,-101,-95,-82,-65,-56,-60,-68,-67,-55,-40,-25,-11},
            {31,14,-35,-25,47,48,-51,-70,56,102,-63,-159,41,208,-11,-251,-1,287,-17,263,3349,8439,10251,4569,-5110,-9810,-5413,1862,2916,-2864,-7061,-3052,5973,11404,9299,3730,1279,4677,11553,16866,15881,7215,-4945,-12642,-10586,-1564,5580,4060,-4920,-14067,-16846,-12349,-4788,388,278,-3863,-7844,-7911,-3807,1244,3707,2802,537,-683,42,2103,4290,5440,4951,3309,1907,1826,2754,3363,2704,997,-798,-1799,-1619,-486,776,1191,424,-888,-1769,-1813,-1371,-1017,-1049,-1445,-2013,-2513,-2784,-2860,-2902,-2981,-2994,-2803,-2384,-1811,-1204,-676,-276,66,461,906,1287,1539,1721,1876,1926,1785,1510,1249,1072,938,794,622,411,167,-44,-138,-139,-185,-380,-666,-877,-902,-785,-676,-703,-867,-1034,-1065,-936,-758,-660,-688,-781,-830,-745,-529,-278,-107,-43,-16,45,149,273,405,534,617,609,515,381,247,134,66,48,45,-5,-115,-217,-242,-201,-175,-227,-341,-447,-487,-451,-375,-309,-288,-311,-339,-317,-225,-106,-29,-41,-123,-203,-211,-126,16,145,206,192,145,113,111,118,99,42,-40,-107,-126,-107,-93,-119,-174,-220,-237,-236,-246,-279,-323,-350,-335,-275,-187,-99,-28,17,29,5,-38,-70,-73,-57,-46,-59,-95,-133,-147,-130,-105,-103,-133,-173,-190,-172,-134,-96,-72,-60,-46,-16,20,43,39,11,-24,-47,-49,-39,-41,-65,-89,-85,-62,-56,-75,-82,-49}
        },
        {    // H0e015a.wav
            {-3,-2,-1,-3,0,6,3,-6,-2,11,7,-12,-9,18,18,-21,-31,16,40,-15,-56,5,64,-5,-80,12,106,17,293,1885,4439,5596,3252,-1381,-4255,-2871,613,1818,-604,-3438,-2886,1059,4963,5937,4283,2512,2779,5377,8717,10194,7847,2223,-3384,-5360,-2993,790,2061,-696,-5555,-9047,-8961,-5802,-2126,-496,-1591,-3851,-4953,-3798,-1252,896,1532,883,-24,-278,387,1578,2553,2724,2112,1342,1101,1524,2129,2281,1720,716,-153,-405,0,623,886,551,-123,-684,-907,-904,-917,-1088,-1407,-1764,-2026,-2099,-1990,-1790,-1602,-1463,-1332,-1139,-842,-466,-100,170,319,379,380,334,267,230,246,279,278,240,194,158,120,71,13,-52,-126,-197,-235,-232,-225,-276,-410,-577,-685,-675,-581,-499,-489,-522,-517,-433,-302,-187,-127,-119,-134,-136,-99,-25,54,106,121,111,96,91,105,131,146,126,67,-18,-109,-179,-205,-192,-177,-197,-247,-282,-268,-214,-157,-128,-138,-177,-212,-208,-162,-108,-88,-110,-142,-154,-139,-112,-91,-91,-121,-168,-193,-164,-86,-5,37,32,5,-17,-30,-43,-62,-90,-126,-161,-179,-172,-154,-148,-160,-170,-158,-130,-109,-109,-122,-128,-120,-100,-69,-28,15,44,48,30,0,-30,-55,-71,-79,-85,-95,-115,-139,-157,-166,-176,-199,-228,-241,-223,-186,-153,-134,-124,-114,-104,-94,-80,-64,-55,-61,-69,-59,-29},
            {-5,-31,19,57,-23,-97,4,130,21,-174,-74,196,120,-227,-166,265,164,-103,1899,7120,11339,8385,-1604,-10052,-9059,-1210,3300,-566,-6507,-5299,3490,11372,11421,5611,1359,3467,10579,17348,18200,10635,-2306,-12693,-13413,-4927,4343,5577,-2425,-12870,-17780,-14539,-6722,-254,960,-2765,-7513,-8814,-5264,371,3868,3451,878,-921,-545,1472,3854,5454,5514,4096,2382,1842,2753,3837,3577,1678,-826,-2531,-2574,-1063,918,1914,1221,-465,-1746,-1884,-1310,-896,-1057,-1630,-2267,-2704,-2841,-2798,-2865,-3215,-3661,-3800,-3377,-2475,-1401,-471,139,461,663,887,1150,1428,1739,2067,2274,2207,1889,1509,1215,1012,843,674,476,225,-21,-151,-142,-137,-290,-582,-839,-919,-837,-732,-739,-887,-1066,-1113,-970,-747,-626,-683,-834,-927,-861,-641,-364,-146,-44,-17,18,103,231,384,543,662,685,590,424,256,132,75,82,106,73,-45,-185,-247,-209,-154,-181,-304,-443,-511,-485,-407,-347,-347,-396,-435,-404,-287,-133,-22,-8,-81,-180,-224,-163,-9,164,271,285,244,205,182,159,119,59,-16,-82,-109,-91,-71,-101,-181,-253,-273,-257,-257,-294,-349,-389,-391,-345,-256,-149,-54,8,28,9,-37,-86,-110,-98,-66,-47,-64,-108,-140,-127,-80,-51,-76,-131,-167,-163,-136,-108,-84,-63,-45,-26,3,35,47,25,-14,-44,-54,-52,-51,-58,-73,-83,-76,-58,-50,-60,-70,-57,-24}
        },
        {    // H0e020a.wav
            {2,-2,-5,-4,-1,0,3,5,0,-7,-2,9,6,-9,-6,16,15,-17,-24,16,35,-12,-46,4,52,-4,-61,16,87,15,294,1728,3968,4949,2875,-1155,-3620,-2395,602,1586,-552,-2983,-2449,989,4346,5186,3825,2392,2662,4883,7779,9162,7258,2397,-2616,-4542,-2612,693,1903,-406,-4637,-7787,-7876,-5249,-2070,-601,-1517,-3513,-4535,-3566,-1345,527,1057,482,-251,-368,282,1318,2155,2374,1992,1449,1253,1546,2003,2125,1656,783,-4,-270,35,541,759,489,-62,-523,-704,-697,-718,-902,-1233,-1594,-1858,-1955,-1890,-1718,-1506,-1303,-1126,-951,-738,-483,-244,-86,-5,56,140,233,289,286,230,138,36,-41,-70,-58,-31,-7,1,-24,-89,-171,-228,-241,-235,-257,-327,-418,-477,-477,-440,-415,-420,-421,-377,-292,-204,-145,-117,-114,-129,-140,-119,-59,12,61,79,78,70,63,64,73,72,43,-13,-79,-141,-188,-207,-191,-164,-163,-200,-246,-261,-232,-181,-143,-137,-158,-182,-184,-158,-122,-102,-111,-138,-157,-148,-111,-69,-52,-75,-120,-152,-140,-84,-12,38,42,8,-35,-62,-68,-70,-91,-134,-177,-196,-187,-171,-160,-155,-147,-133,-117,-104,-97,-96,-101,-104,-96,-74,-47,-25,-11,-3,-6,-23,-47,-61,-58,-50,-54,-77,-109,-135,-147,-151,-158,-170,-182,-189,-191,-184,-163,-135,-119,-120,-119,-101,-78,-74,-83,-75,-38},
            {-22,64,40,-78,-63,95,94,-123,-168,111,230,-97,-288,99,321,-116,631,4909,10750,11583,3673,-7428,-11611,-6025,1246,1354,-4208,-6118,319,9328,12252,7825,2615,3040,9379,16748,19359,13930,1884,-10255,-14631,-8819,1042,5404,159,-10060,-17041,-16361,-9860,-2716,660,-1018,-5516,-8566,-7076,-1867,3030,4264,2141,-385,-963,514,2831,4818,5668,5017,3416,2253,2472,3448,3588,2049,-434,-2336,-2617,-1315,619,1904,1737,379,-1084,-1727,-1513,-1084,-1029,-1473,-2171,-2775,-3060,-3094,-3207,-3664,-4331,-4701,-4289,-3014,-1293,173,847,747,415,414,858,1474,2000,2368,2550,2457,2081,1601,1235,1040,931,812,627,360,61,-149,-206,-209,-322,-577,-827,-916,-837,-729,-741,-910,-1120,-1195,-1059,-807,-626,-621,-752,-888,-900,-728,-425,-144,-15,-25,-43,31,191,381,558,683,707,612,449,293,172,81,36,49,72,32,-74,-163,-171,-138,-166,-298,-469,-580,-590,-529,-456,-411,-403,-407,-380,-292,-159,-40,0,-54,-154,-218,-186,-56,122,271,337,325,277,234,201,160,96,16,-55,-91,-89,-80,-105,-172,-246,-286,-290,-290,-318,-378,-444,-473,-434,-330,-199,-80,7,55,53,2,-66,-107,-107,-89,-82,-95,-117,-132,-125,-94,-61,-62,-102,-146,-154,-124,-86,-65,-61,-59,-44,-15,15,25,7,-27,-60,-82,-91,-86,-74,-68,-64,-47,-15,4,-11,-42,-48,-18,13,14}
        },
        {    // H0e025a.wav
            {-5,-1,3,2,-2,-2,-1,-1,0,3,2,-3,0,9,7,-6,-5,13,14,-13,-21,13,32,-7,-40,-1,44,4,-43,19,77,15,247,1475,3437,4374,2691,-763,-2993,-2086,443,1376,-341,-2416,-2079,731,3600,4471,3486,2310,2444,4255,6817,8251,6853,2709,-1798,-3739,-2262,599,1811,-7,-3642,-6548,-6899,-4819,-2101,-762,-1490,-3205,-4127,-3367,-1547,15,531,196,-285,-340,194,1094,1903,2194,1904,1416,1229,1497,1914,2019,1598,827,124,-139,102,555,789,585,86,-387,-641,-713,-749,-850,-1046,-1317,-1587,-1739,-1702,-1524,-1337,-1233,-1187,-1109,-948,-729,-511,-327,-178,-55,43,112,148,149,109,36,-46,-107,-129,-107,-42,46,108,89,-16,-140,-200,-176,-123,-116,-181,-280,-354,-373,-360,-364,-404,-446,-438,-360,-245,-144,-95,-103,-140,-161,-129,-51,29,70,64,33,2,-11,-1,24,38,21,-26,-83,-133,-163,-167,-154,-144,-158,-197,-234,-241,-214,-175,-153,-161,-187,-205,-195,-161,-128,-115,-123,-135,-134,-111,-68,-24,-6,-30,-78,-115,-114,-79,-35,-9,-13,-40,-67,-77,-71,-69,-86,-121,-155,-173,-173,-165,-156,-148,-139,-128,-115,-104,-104,-116,-130,-135,-123,-94,-59,-30,-16,-16,-28,-46,-62,-65,-54,-41,-42,-62,-88,-108,-115,-113,-110,-115,-132,-154,-166,-164,-157,-154,-152,-145,-134,-125,-111,-80,-36},
            {62,-52,-103,35,139,-20,-198,-35,233,88,-263,-121,312,106,-92,2393,8258,12726,9389,-1372,-10730,-10751,-3762,825,-1431,-4892,-2123,5960,11424,9526,4184,2786,8018,15922,20158,16731,6220,-6206,-13339,-11143,-2840,3265,1272,-7053,-14725,-16407,-12257,-6155,-1926,-1307,-3687,-6534,-6853,-3645,909,3463,2805,710,-361,393,2151,3858,4908,4994,4210,3237,2798,2797,2455,1367,4,-939,-1223,-931,-128,937,1590,1239,87,-1016,-1473,-1422,-1338,-1461,-1769,-2234,-2870,-3618,-4332,-4879,-5136,-4930,-4119,-2763,-1216,26,619,613,419,469,886,1479,2027,2441,2676,2631,2273,1751,1302,1039,913,832,730,546,257,-53,-252,-314,-362,-517,-747,-914,-930,-845,-799,-889,-1077,-1209,-1155,-939,-716,-623,-671,-769,-801,-690,-440,-159,9,15,-43,-28,108,311,515,681,763,715,545,328,145,27,-26,-20,23,50,14,-66,-127,-143,-167,-270,-447,-611,-675,-626,-523,-436,-392,-374,-347,-283,-181,-75,-11,-20,-90,-168,-188,-112,46,218,332,363,341,301,253,189,111,34,-31,-76,-94,-96,-112,-164,-232,-278,-290,-297,-336,-411,-489,-527,-495,-394,-258,-128,-24,50,83,63,2,-60,-91,-96,-95,-99,-109,-124,-134,-123,-95,-80,-99,-134,-149,-130,-97,-73,-61,-51,-39,-25,-9,1,-7,-37,-77,-114,-136,-136,-114,-81,-50,-17,23,56,62,44,25,17,9,-9,-22,-16}
        },
        {    // H0e030a.wav
            {0,-2,-3,0,2,0,-2,-2,-1,-2,-1,2,2,-2,-1,5,4,-5,-5,9,11,-9,-17,9,26,-5,-36,-8,35,12,-27,15,60,5,173,1174,2876,3847,2627,-277,-2395,-1898,211,1227,-19,-1843,-1839,340,2843,3833,3192,2193,2170,3610,5875,7380,6522,3140,-875,-2919,-1971,463,1756,461,-2635,-5382,-6051,-4536,-2259,-970,-1399,-2795,-3721,-3328,-1934,-515,203,181,-143,-276,51,776,1544,1945,1839,1481,1285,1438,1754,1867,1560,940,354,126,307,634,745,480,-15,-462,-687,-709,-655,-647,-756,-985,-1267,-1502,-1622,-1630,-1571,-1483,-1376,-1240,-1067,-867,-672,-509,-380,-268,-163,-73,-9,33,66,92,97,76,49,45,82,143,185,167,89,-3,-56,-59,-52,-86,-178,-301,-400,-438,-423,-404,-422,-464,-479,-429,-323,-206,-120,-85,-92,-110,-109,-80,-40,-14,-9,-19,-29,-23,7,48,71,56,8,-54,-115,-163,-184,-174,-154,-154,-183,-218,-231,-214,-185,-169,-177,-202,-223,-223,-198,-162,-130,-113,-108,-101,-77,-37,-1,8,-16,-58,-94,-105,-90,-63,-46,-50,-69,-86,-90,-83,-78,-86,-108,-133,-148,-151,-151,-156,-161,-158,-147,-135,-128,-128,-137,-149,-150,-130,-96,-67,-50,-42,-39,-44,-55,-61,-57,-47,-39,-36,-39,-50,-64,-72,-74,-80,-98,-120,-138,-154,-169,-175,-165,-154,-156,-156,-124,-59},
            {-76,-31,96,67,-128,-146,110,198,-110,-263,117,305,-166,483,4686,10918,12925,6259,-5132,-11897,-9594,-3414,-964,-2704,-2577,2739,8984,10057,6057,3151,6256,13872,19970,19335,11084,-959,-10310,-11885,-6176,536,1508,-4344,-11962,-15565,-13691,-9040,-4950,-3097,-3553,-5255,-6194,-4596,-820,2542,3199,1535,-67,126,1850,3813,5051,5193,4266,2816,1810,1796,2269,2209,1212,-173,-1103,-1116,-285,893,1684,1538,566,-544,-1169,-1251,-1146,-1181,-1495,-2136,-3096,-4229,-5230,-5748,-5546,-4654,-3401,-2229,-1379,-796,-324,100,481,866,1290,1690,1987,2207,2399,2491,2355,2003,1604,1290,1054,848,665,485,256,-13,-219,-291,-306,-403,-616,-850,-990,-999,-937,-918,-1020,-1185,-1248,-1110,-858,-663,-603,-618,-619,-566,-447,-273,-101,-2,27,67,178,342,510,653,743,723,569,346,160,54,2,-28,-42,-48,-72,-120,-159,-165,-174,-245,-388,-544,-629,-610,-520,-423,-369,-357,-346,-297,-203,-96,-21,-7,-56,-135,-183,-142,-2,180,318,369,353,317,278,229,158,67,-31,-112,-151,-143,-122,-137,-198,-263,-293,-299,-324,-393,-482,-543,-537,-457,-328,-185,-58,37,92,100,64,6,-47,-82,-101,-112,-121,-133,-140,-126,-88,-58,-71,-121,-165,-171,-148,-119,-92,-65,-44,-31,-20,-6,-3,-28,-74,-119,-151,-166,-160,-129,-76,-16,41,89,118,115,86,54,36,20,-7,-36,-43,-24}
        },
        {    // H0e035a.wav
            {-4,-2,1,1,-2,-2,1,1,-1,-2,-1,-1,-1,2,3,0,-1,4,4,-4,-6,7,13,-4,-18,0,23,5,-29,-15,29,26,-14,-2,37,11,120,867,2284,3313,2614,282,-1774,-1753,-74,1073,333,-1252,-1611,-74,2067,3181,2897,2103,1941,2989,4912,6478,6214,3663,164,-2020,-1667,278,1611,840,-1674,-4230,-5234,-4321,-2466,-1154,-1244,-2379,-3387,-3325,-2203,-813,39,126,-195,-388,-124,557,1323,1795,1811,1538,1317,1374,1635,1815,1665,1180,602,240,221,404,511,369,31,-305,-481,-494,-463,-518,-718,-1025,-1347,-1593,-1717,-1722,-1645,-1537,-1441,-1367,-1276,-1124,-911,-690,-510,-372,-249,-129,-12,106,230,337,384,354,283,230,223,247,268,255,191,87,-23,-100,-142,-189,-277,-395,-487,-513,-489,-465,-470,-486,-475,-423,-344,-255,-170,-113,-103,-129,-147,-123,-65,-8,24,35,36,31,30,45,71,79,43,-32,-112,-166,-185,-177,-159,-153,-168,-196,-215,-214,-200,-189,-197,-222,-244,-240,-204,-154,-116,-104,-105,-98,-73,-33,9,31,15,-36,-91,-116,-103,-74,-55,-59,-77,-94,-99,-94,-89,-93,-106,-123,-138,-145,-141,-133,-132,-142,-154,-158,-157,-160,-166,-163,-144,-117,-99,-87,-76,-62,-49,-40,-39,-43,-43,-32,-15,-6,-12,-26,-42,-60,-75,-80,-80,-92,-121,-144,-146,-144,-162,-182,-157,-79},
            {-4,108,11,-157,-57,185,95,-231,-143,289,148,-268,1528,6991,12621,11994,3198,-7578,-12131,-9071,-4200,-2355,-1913,1169,6428,9124,6978,3787,5097,11733,18835,20540,14718,4079,-5816,-9974,-7361,-1965,347,-2964,-9078,-13185,-13232,-10796,-8207,-6322,-5103,-4719,-5018,-4780,-2830,225,2357,2406,1296,770,1591,3281,4913,5596,4710,2551,606,407,1867,3224,2894,1042,-841,-1514,-863,414,1467,1714,1081,48,-716,-912,-794,-838,-1339,-2320,-3618,-4919,-5804,-5920,-5217,-4022,-2852,-2081,-1712,-1453,-1032,-415,273,933,1505,1897,2042,2031,2054,2168,2237,2134,1900,1635,1355,1028,681,375,116,-109,-249,-258,-222,-297,-527,-785,-935,-975,-986,-1027,-1108,-1207,-1266,-1205,-1001,-742,-555,-485,-486,-486,-450,-366,-234,-73,88,228,348,459,566,661,713,677,543,361,205,104,37,-31,-104,-174,-233,-268,-254,-195,-147,-183,-319,-482,-577,-567,-487,-399,-338,-305,-283,-252,-195,-116,-49,-30,-62,-112,-137,-110,-26,102,237,333,366,348,308,256,184,84,-31,-133,-190,-193,-171,-172,-212,-262,-286,-286,-296,-339,-408,-481,-528,-516,-426,-278,-119,15,110,157,144,75,-13,-77,-106,-117,-127,-137,-139,-124,-94,-66,-66,-103,-151,-178,-177,-164,-146,-120,-85,-51,-20,1,3,-23,-69,-115,-147,-165,-166,-139,-85,-25,25,69,110,130,118,88,63,43,13,-19,-27,-7,15,15}
        },
        {    // H0e040a.wav
            {1,0,-2,-1,1,1,-1,-1,1,2,0,-1,-1,-2,-2,2,4,1,-1,1,3,-1,-3,4,9,-3,-15,-2,19,8,-23,-17,23,28,-11,-13,32,28,64,557,1704,2796,2606,833,-1159,-1610,-368,897,674,-645,-1357,-485,1267,2512,2618,2057,1758,2393,3952,5569,5906,4217,1266,-1067,-1385,-25,1318,1130,-719,-3051,-4408,-4111,-2659,-1293,-1035,-1911,-3008,-3308,-2534,-1250,-258,61,-108,-308,-178,355,1085,1665,1849,1674,1423,1366,1518,1660,1555,1162,661,296,201,323,474,471,253,-93,-421,-643,-769,-860,-969,-1113,-1288,-1478,-1650,-1760,-1783,-1735,-1649,-1542,-1397,-1192,-938,-680,-462,-292,-148,-1,160,322,460,549,580,558,495,406,322,276,264,241,163,33,-107,-218,-294,-354,-414,-476,-526,-551,-548,-528,-508,-492,-472,-436,-379,-306,-231,-169,-130,-108,-88,-54,-6,43,73,75,56,37,35,51,68,68,40,-13,-80,-141,-176,-178,-160,-151,-170,-208,-242,-252,-238,-217,-209,-218,-228,-221,-195,-159,-124,-100,-89,-86,-75,-47,-13,4,-9,-43,-77,-97,-100,-90,-76,-69,-76,-93,-106,-103,-88,-78,-86,-105,-118,-121,-125,-138,-152,-159,-163,-169,-172,-164,-153,-152,-157,-152,-129,-102,-82,-63,-40,-23,-21,-26,-25,-16,-7,-3,-4,-15,-38,-59,-67,-70,-83,-100,-109,-118,-143,-168,-148,-74},
            {88,-106,-166,74,229,-35,-285,17,358,-64,-148,2790,8964,13542,10701,690,-9288,-12472,-9256,-4955,-2431,186,4523,8076,7500,4163,3598,9059,17340,21724,18196,8432,-2078,-7987,-7377,-2896,199,-1610,-7017,-11536,-12289,-10463,-8916,-8577,-8201,-6909,-5360,-4272,-3169,-1395,481,1298,1050,1047,2278,4251,5615,5442,3794,1610,268,700,2434,3767,3356,1533,-222,-893,-624,-20,569,975,968,510,-34,-266,-284,-582,-1480,-2836,-4245,-5311,-5745,-5445,-4596,-3611,-2848,-2378,-2031,-1602,-1030,-409,149,640,1132,1605,1921,1998,1953,1960,2036,2064,1983,1838,1634,1304,842,374,29,-170,-250,-240,-213,-296,-526,-773,-890,-891,-910,-1018,-1171,-1307,-1381,-1323,-1086,-750,-499,-433,-480,-506,-456,-346,-191,-6,161,275,366,488,639,750,771,706,575,398,213,68,-23,-95,-183,-272,-322,-312,-258,-199,-174,-214,-317,-439,-519,-521,-452,-356,-285,-263,-270,-253,-182,-80,-2,18,-6,-45,-85,-109,-87,4,137,253,315,338,347,331,260,129,-25,-158,-241,-268,-252,-227,-230,-265,-299,-297,-271,-267,-318,-409,-494,-521,-468,-347,-190,-32,101,184,196,141,55,-22,-75,-113,-141,-151,-142,-121,-98,-79,-76,-102,-152,-198,-212,-199,-180,-161,-131,-85,-36,-3,7,-3,-33,-79,-132,-169,-171,-136,-78,-19,25,54,81,106,115,98,66,40,21,-4,-31,-33,6,58,75,44}
        },
        {    // H0e045a.wav
            {3,1,0,0,0,0,0,0,-1,-1,1,2,1,-1,-2,-1,1,3,3,-1,-3,1,7,4,-2,0,7,3,-8,-3,16,15,-11,-17,14,30,3,-11,23,31,26,317,1190,2259,2492,1295,-524,-1370,-605,680,932,-70,-1059,-824,514,1846,2319,2006,1624,1905,3100,4687,5519,4651,2295,-116,-1073,-314,998,1354,162,-1886,-3475,-3692,-2674,-1441,-1058,-1765,-2834,-3262,-2647,-1430,-386,38,-53,-243,-166,298,998,1608,1837,1649,1305,1140,1267,1500,1557,1319,900,516,307,266,276,202,-19,-342,-655,-866,-960,-986,-1017,-1108,-1281,-1511,-1730,-1863,-1871,-1772,-1617,-1445,-1256,-1027,-759,-492,-275,-117,20,174,346,504,621,688,697,643,539,422,330,266,205,120,5,-128,-257,-359,-417,-439,-460,-506,-565,-599,-589,-557,-533,-518,-491,-438,-364,-281,-194,-115,-64,-48,-43,-20,24,62,76,73,68,66,62,57,55,50,31,-6,-55,-104,-146,-175,-192,-205,-222,-242,-257,-253,-231,-205,-189,-189,-199,-203,-187,-154,-122,-105,-103,-105,-100,-82,-56,-34,-29,-45,-71,-91,-92,-74,-50,-39,-49,-69,-83,-85,-79,-72,-71,-80,-103,-131,-149,-153,-152,-155,-160,-160,-159,-166,-177,-176,-159,-139,-124,-107,-79,-49,-27,-15,-5,1,-2,-8,-8,-6,-12,-29,-50,-69,-83,-88,-85,-88,-110,-132,-116,-58},
            {-95,-88,113,162,-119,-246,124,314,-213,108,3842,10313,14030,9729,-1090,-10773,-13300,-9717,-4931,-1234,2523,6431,7788,5292,2639,5244,13558,21503,22160,14200,2603,-5888,-7675,-4145,-84,87,-4176,-9307,-11379,-10088,-8452,-8731,-9882,-9542,-7357,-5045,-3712,-2668,-1147,222,559,473,1446,3693,5625,5661,3893,1771,674,1063,2458,3765,3904,2666,930,-195,-408,-180,59,303,580,669,407,-13,-349,-748,-1609,-3008,-4459,-5323,-5357,-4828,-4163,-3600,-3136,-2699,-2241,-1699,-1006,-218,445,800,922,1049,1296,1573,1775,1908,1997,1997,1895,1774,1680,1506,1126,608,162,-95,-216,-284,-321,-356,-460,-657,-856,-951,-951,-970,-1098,-1314,-1497,-1504,-1275,-899,-557,-379,-360,-405,-421,-349,-176,49,234,336,402,498,624,725,767,751,661,476,229,14,-107,-165,-225,-297,-339,-322,-265,-215,-198,-224,-292,-389,-478,-509,-460,-363,-284,-266,-282,-270,-191,-68,44,102,99,52,-13,-68,-91,-66,4,102,206,296,357,369,313,191,30,-127,-248,-317,-331,-312,-296,-304,-319,-306,-262,-231,-256,-336,-429,-490,-489,-417,-284,-117,47,170,224,202,131,49,-23,-83,-132,-161,-160,-137,-107,-80,-68,-85,-137,-200,-243,-256,-252,-238,-205,-146,-76,-20,9,11,-10,-47,-91,-130,-151,-140,-95,-36,18,59,87,101,98,81,58,31,0,-29,-46,-46,-30,4,53,94,92,47}
        },
        {    // H0e050a.wav
            {1,2,1,0,1,2,1,0,0,1,0,-1,-1,-1,-1,-1,-1,-1,-2,0,2,1,-2,-1,3,3,-3,-4,3,4,-6,-8,7,15,-1,-15,0,23,13,-8,9,27,10,146,746,1710,2261,1631,102,-1017,-743,425,1050,413,-713,-1031,-145,1183,1973,1934,1544,1544,2384,3841,5003,4842,3126,818,-617,-443,739,1557,1028,-702,-2557,-3411,-2946,-1847,-1182,-1486,-2356,-2910,-2605,-1628,-597,1,105,-25,-58,200,717,1260,1560,1529,1332,1234,1353,1565,1629,1380,845,228,-215,-335,-202,-53,-104,-386,-757,-1046,-1181,-1193,-1159,-1154,-1234,-1404,-1600,-1723,-1707,-1568,-1372,-1167,-959,-736,-504,-292,-116,32,175,318,448,552,627,669,662,592,471,335,215,117,32,-52,-145,-253,-367,-457,-494,-489,-488,-525,-586,-627,-618,-571,-514,-462,-412,-357,-292,-215,-131,-61,-29,-36,-53,-44,0,57,100,112,95,62,34,26,35,43,29,-14,-75,-137,-183,-207,-212,-210,-214,-228,-244,-247,-230,-201,-181,-180,-193,-202,-195,-173,-148,-132,-130,-134,-130,-110,-77,-43,-25,-29,-51,-72,-74,-54,-27,-15,-27,-54,-76,-80,-69,-59,-65,-91,-126,-152,-161,-157,-153,-156,-167,-178,-184,-178,-166,-157,-149,-135,-115,-94,-74,-49,-22,-5,-6,-17,-27,-33,-39,-44,-47,-53,-68,-83,-85,-77,-74,-78,-69,-36},
            {-101,151,174,-149,-252,151,296,-258,238,4320,11005,14521,9622,-1921,-12121,-14653,-10358,-4289,554,4379,6965,6534,3453,2330,7590,17345,23887,21044,10146,-1557,-7420,-6148,-1545,1132,-858,-5945,-9977,-10312,-8321,-7427,-8912,-10650,-10113,-7448,-4769,-3282,-2390,-1372,-502,-70,579,2125,3947,4641,3753,2286,1488,1747,2720,3845,4442,3899,2314,688,1,195,446,305,98,198,415,311,-236,-1080,-2165,-3454,-4603,-5090,-4787,-4156,-3759,-3701,-3645,-3272,-2560,-1683,-804,-33,534,845,948,981,1056,1202,1391,1584,1739,1810,1787,1724,1671,1574,1324,904,444,94,-115,-243,-328,-377,-432,-561,-756,-921,-993,-1029,-1136,-1332,-1528,-1605,-1488,-1177,-761,-403,-236,-253,-319,-297,-157,44,239,394,496,548,582,635,709,754,701,527,285,65,-71,-133,-179,-251,-340,-398,-391,-322,-229,-161,-162,-247,-383,-497,-525,-465,-372,-301,-265,-235,-183,-99,8,109,163,146,79,11,-29,-44,-40,0,88,201,298,350,348,281,142,-45,-222,-333,-370,-363,-349,-347,-348,-333,-292,-240,-215,-245,-327,-424,-488,-480,-385,-222,-41,109,203,236,211,139,44,-42,-104,-143,-161,-151,-114,-66,-37,-45,-89,-153,-216,-264,-295,-307,-294,-250,-184,-111,-43,7,28,15,-22,-66,-103,-126,-124,-84,-12,62,109,126,128,120,94,48,-7,-57,-96,-114,-95,-38,35,91,110,93,57,21}
        },
        {    // H0e055a.wav
            {1,1,1,2,2,1,1,1,1,1,1,1,0,-1,-1,0,0,0,-1,0,1,0,0,1,0,-1,1,2,-1,-3,1,5,0,-5,4,14,5,-13,-6,20,22,-2,-2,22,12,45,398,1180,1910,1799,684,-531,-721,168,1000,747,-339,-1063,-641,557,1560,1800,1502,1337,1855,3069,4344,4738,3742,1835,222,-152,597,1427,1291,-10,-1734,-2837,-2801,-1989,-1277,-1291,-1917,-2488,-2419,-1679,-722,-61,104,-51,-166,33,563,1191,1624,1722,1563,1335,1162,1042,898,655,295,-108,-403,-476,-371,-282,-385,-676,-996,-1187,-1211,-1126,-1014,-949,-982,-1116,-1280,-1377,-1353,-1227,-1047,-843,-633,-440,-284,-164,-55,63,190,312,413,485,523,520,475,396,301,198,87,-31,-138,-214,-266,-323,-398,-470,-511,-520,-523,-537,-551,-547,-517,-469,-412,-354,-303,-263,-227,-182,-125,-72,-45,-45,-47,-26,13,48,67,72,68,51,25,4,-2,-3,-19,-57,-101,-136,-161,-180,-193,-197,-202,-219,-245,-261,-249,-218,-193,-186,-194,-203,-202,-187,-164,-142,-128,-120,-111,-94,-69,-45,-34,-37,-45,-49,-44,-31,-15,-7,-18,-44,-64,-68,-65,-73,-92,-111,-124,-136,-150,-160,-164,-168,-175,-178,-171,-157,-146,-140,-134,-125,-112,-98,-86,-76,-67,-57,-50,-50,-53,-52,-45,-40,-41,-44,-46,-48,-56,-63,-54,-26},
            {76,136,-83,-208,103,279,-198,166,4029,10918,15152,10703,-1488,-13100,-16427,-11392,-3660,2260,5688,6862,5254,2221,2432,9373,19759,25086,19854,7231,-4100,-7870,-4658,198,1676,-1432,-6440,-9523,-9192,-7462,-7356,-9339,-10916,-9859,-6862,-4339,-3347,-2853,-1787,-516,144,392,1049,2195,3019,2962,2351,1895,2055,2942,4269,5200,4808,3075,1145,200,295,630,686,609,561,301,-413,-1424,-2444,-3430,-4391,-5032,-4980,-4341,-3723,-3581,-3744,-3676,-3060,-2033,-940,-41,567,900,1031,1059,1072,1109,1176,1277,1421,1583,1683,1657,1537,1416,1322,1165,858,445,73,-161,-274,-336,-397,-487,-622,-784,-928,-1048,-1197,-1410,-1633,-1744,-1654,-1365,-968,-595,-352,-254,-229,-187,-92,42,204,383,541,620,610,571,571,622,671,652,523,294,39,-143,-208,-215,-259,-365,-459,-454,-346,-210,-131,-147,-246,-387,-501,-528,-459,-351,-274,-248,-232,-171,-54,83,186,219,182,105,24,-39,-72,-59,14,131,245,318,340,317,239,92,-102,-281,-392,-428,-421,-400,-377,-350,-311,-260,-213,-201,-245,-335,-431,-485,-461,-357,-196,-19,133,230,254,206,112,15,-56,-104,-140,-158,-141,-94,-43,-18,-28,-70,-135,-208,-272,-316,-339,-342,-315,-253,-168,-82,-17,19,25,2,-42,-89,-119,-112,-61,19,97,147,164,161,144,107,45,-30,-97,-140,-154,-135,-82,-4,73,118,115,78,36,10}
        },
        {    // H0e060a.wav
            {-1,0,0,0,0,1,1,1,1,1,1,1,-1,-1,0,-2,-3,-2,-1,-2,-2,-1,0,-1,-2,0,0,-2,-2,0,-1,-5,-4,3,6,1,0,5,3,-11,-11,13,29,12,-6,4,6,1,172,724,1468,1760,1148,55,-503,-39,778,864,0,-918,-914,36,1112,1592,1459,1249,1525,2476,3749,4565,4211,2691,901,-32,289,1196,1577,831,-695,-2082,-2590,-2179,-1450,-1111,-1407,-1972,-2205,-1817,-1031,-307,74,170,213,381,695,1050,1286,1272,1002,629,365,312,372,343,99,-299,-661,-817,-748,-591,-526,-632,-835,-984,-983,-848,-675,-564,-570,-690,-863,-994,-1007,-895,-716,-544,-418,-333,-264,-192,-109,-12,92,185,251,289,305,301,269,204,114,16,-79,-162,-225,-266,-302,-353,-419,-472,-487,-464,-428,-405,-402,-406,-398,-365,-313,-263,-232,-220,-210,-184,-140,-94,-60,-43,-37,-36,-33,-21,3,28,36,19,-12,-35,-41,-40,-46,-64,-86,-109,-136,-169,-197,-212,-219,-231,-252,-265,-255,-225,-196,-182,-181,-181,-174,-158,-139,-122,-111,-107,-104,-94,-74,-49,-32,-31,-41,-47,-40,-27,-17,-17,-26,-40,-57,-71,-76,-74,-73,-85,-109,-134,-149,-155,-161,-170,-175,-169,-157,-148,-147,-151,-153,-152,-148,-142,-130,-110,-85,-67,-54,-40,-26,-19,-21,-21,-15,-16,-34,-56,-56,-30},
            {167,-68,-258,24,338,-63,-145,2938,9838,15579,12976,855,-12912,-18518,-13603,-4033,3468,6779,6812,4460,1536,2261,9729,20505,25774,19810,6254,-5298,-8303,-4089,1149,2395,-930,-5810,-8709,-8492,-7124,-7352,-9495,-11069,-9855,-6611,-3954,-3101,-2889,-1982,-767,-364,-660,-427,842,2200,2571,2069,1666,2028,3096,4398,5297,5164,3875,2165,1059,879,1092,1144,999,753,176,-965,-2397,-3550,-4207,-4590,-4834,-4783,-4393,-3993,-3899,-3949,-3665,-2801,-1572,-379,498,977,1112,1067,1028,1071,1145,1193,1253,1373,1507,1555,1485,1372,1295,1234,1093,810,429,68,-167,-255,-264,-308,-463,-705,-928,-1057,-1133,-1270,-1507,-1742,-1828,-1701,-1396,-995,-596,-301,-159,-119,-70,43,183,301,402,507,589,604,568,556,609,682,683,561,339,91,-107,-218,-266,-307,-376,-449,-460,-375,-238,-148,-168,-278,-400,-472,-474,-422,-347,-286,-258,-240,-175,-39,124,235,254,200,117,34,-33,-70,-59,9,122,246,342,378,343,238,74,-125,-311,-439,-490,-481,-438,-382,-327,-273,-223,-185,-180,-228,-321,-421,-483,-479,-395,-235,-36,140,241,253,200,114,23,-54,-109,-144,-157,-140,-89,-23,22,17,-35,-111,-190,-261,-319,-361,-377,-354,-291,-203,-116,-49,-9,4,-10,-45,-86,-110,-99,-44,44,131,182,190,173,150,115,57,-18,-89,-137,-155,-142,-95,-24,46,87,89,63,32,11,3}
        },
        {    // H0e065a.wav
            {3,4,3,2,3,4,5,5,4,4,5,5,5,4,4,4,4,3,3,4,5,6,6,6,6,5,5,7,8,5,3,6,9,7,4,8,15,15,7,3,6,9,13,25,33,18,-7,-5,14,13,68,385,1006,1539,1434,660,-91,-116,448,752,262,-580,-880,-307,645,1307,1492,1480,1627,2114,2900,3669,3888,3208,1910,823,610,1134,1588,1249,93,-1256,-2078,-2095,-1605,-1186,-1214,-1573,-1796,-1520,-813,-77,330,350,169,5,-20,112,336,513,510,309,36,-158,-234,-280,-390,-558,-689,-701,-601,-478,-423,-455,-516,-525,-448,-317,-199,-152,-203,-338,-509,-648,-704,-665,-562,-447,-368,-343,-349,-340,-282,-181,-76,3,49,72,79,69,45,14,-23,-72,-136,-206,-263,-290,-292,-287,-290,-301,-308,-304,-294,-285,-281,-280,-275,-258,-228,-198,-183,-188,-197,-189,-158,-114,-78,-63,-68,-80,-83,-68,-42,-19,-8,-10,-18,-28,-38,-46,-53,-60,-73,-96,-127,-160,-188,-208,-220,-225,-224,-216,-202,-182,-159,-138,-127,-126,-129,-127,-119,-111,-103,-93,-81,-71,-65,-59,-48,-36,-31,-34,-36,-28,-16,-9,-11,-19,-27,-35,-42,-49,-56,-68,-88,-114,-138,-152,-158,-163,-172,-179,-180,-175,-170,-166,-161,-154,-146,-133,-112,-85,-60,-39,-22,-8,0,3,3,-2,-17,-34,-37,-20},
            {121,-242,-202,271,204,-317,1372,7527,14956,15712,5366,-10376,-19961,-17205,-6424,3584,7997,7435,4275,1087,1587,8668,19619,25968,21040,7353,-5287,-9098,-4664,1460,3551,684,-4218,-7636,-8163,-7204,-7252,-9069,-10753,-10034,-7075,-4173,-2879,-2520,-1883,-1184,-1379,-2164,-1992,-202,1919,2687,1993,1166,1330,2511,4086,5342,5605,4561,2776,1446,1273,1811,2146,1887,1179,89,-1423,-3023,-4065,-4321,-4259,-4382,-4630,-4672,-4504,-4368,-4238,-3760,-2751,-1464,-289,586,1136,1344,1249,1038,923,964,1092,1252,1425,1547,1530,1392,1261,1228,1237,1145,870,461,60,-190,-242,-185,-186,-362,-693,-1040,-1262,-1328,-1335,-1406,-1573,-1740,-1764,-1567,-1185,-732,-340,-98,-4,23,69,164,284,397,477,509,505,519,599,727,815,778,605,350,94,-88,-161,-167,-208,-337,-488,-539,-443,-275,-154,-146,-238,-375,-489,-522,-460,-352,-270,-245,-239,-187,-60,103,231,275,231,135,36,-31,-56,-43,8,99,211,311,367,362,283,125,-91,-303,-444,-493,-482,-451,-407,-343,-267,-202,-159,-145,-178,-269,-395,-495,-515,-441,-292,-102,84,214,258,218,131,38,-44,-113,-163,-175,-139,-67,5,44,41,2,-67,-159,-256,-331,-369,-374,-352,-301,-222,-136,-70,-32,-18,-24,-55,-100,-129,-111,-41,56,141,184,186,167,146,123,87,33,-35,-103,-149,-148,-93,-14,45,62,51,32,12,-7,-17,-12}
        },
        {    // H0e070a.wav
            {0,0,0,0,0,0,0,1,1,1,2,3,2,1,1,2,2,1,0,-1,-1,0,1,1,0,-1,-1,1,3,3,1,-2,-1,4,6,-1,-6,1,14,13,-1,-7,5,17,13,7,13,14,-4,-16,2,19,27,160,582,1173,1472,1133,412,-25,136,473,368,-189,-565,-255,544,1207,1366,1190,1104,1424,2198,3181,3875,3798,2902,1728,1000,1001,1347,1367,693,-466,-1521,-1952,-1674,-1064,-638,-641,-901,-1072,-980,-740,-566,-548,-618,-659,-597,-421,-193,-39,-81,-324,-620,-782,-730,-537,-345,-259,-285,-352,-368,-290,-153,-31,33,54,76,115,143,115,7,-161,-340,-482,-562,-581,-556,-519,-506,-530,-563,-553,-480,-379,-298,-252,-218,-177,-137,-113,-105,-103,-110,-137,-176,-203,-200,-172,-141,-124,-129,-154,-188,-213,-214,-196,-180,-180,-194,-206,-207,-204,-208,-218,-223,-214,-198,-184,-173,-159,-143,-135,-133,-123,-96,-62,-43,-44,-53,-61,-67,-74,-80,-81,-82,-96,-128,-166,-193,-199,-189,-177,-169,-160,-149,-139,-135,-133,-129,-124,-125,-129,-126,-113,-101,-102,-113,-117,-106,-88,-73,-60,-43,-25,-18,-19,-21,-18,-16,-21,-30,-36,-37,-43,-64,-96,-125,-144,-162,-183,-199,-202,-197,-196,-198,-192,-178,-168,-165,-155,-131,-104,-87,-79,-68,-52,-37,-25,-14,-10,-20,-38,-42,-24},
            {-31,-277,30,353,-142,31,4204,12264,17372,11627,-4110,-18771,-21446,-11822,1081,8723,9216,5391,1067,242,6065,17040,25505,23434,10792,-3540,-10021,-6760,456,4700,3367,-1469,-6043,-7953,-7567,-7148,-8295,-10104,-10268,-7946,-4772,-2782,-2196,-1956,-1742,-2214,-3302,-3525,-1737,1131,2920,2637,1340,730,1522,3236,4909,5641,4984,3360,1922,1560,2060,2505,2343,1662,608,-881,-2606,-3904,-4307,-4124,-4034,-4275,-4561,-4673,-4688,-4604,-4145,-3121,-1766,-520,389,981,1289,1299,1094,876,805,897,1099,1351,1557,1600,1464,1289,1223,1251,1203,951,540,140,-107,-177,-152,-158,-303,-614,-989,-1263,-1359,-1355,-1395,-1532,-1686,-1736,-1610,-1308,-889,-472,-187,-77,-63,-30,70,210,353,466,516,495,464,519,684,864,919,779,488,167,-57,-132,-118,-136,-260,-438,-544,-498,-334,-170,-115,-200,-364,-513,-573,-534,-435,-336,-276,-250,-207,-95,77,233,296,253,151,50,-16,-41,-29,12,76,160,249,317,336,285,156,-37,-247,-410,-483,-478,-436,-387,-332,-270,-211,-168,-149,-170,-244,-364,-485,-549,-516,-379,-173,39,189,241,207,126,33,-50,-115,-158,-177,-161,-105,-24,43,60,25,-43,-127,-218,-305,-368,-394,-379,-328,-251,-164,-87,-34,-13,-24,-62,-109,-143,-143,-98,-12,88,158,173,156,143,137,111,52,-21,-82,-122,-131,-95,-21,50,75,58,29,-1,-44,-89,-96,-53}
        },
        {    // H0e075a.wav
            {0,0,0,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-2,0,3,3,-2,-6,1,15,17,3,-11,-6,11,19,16,13,9,-5,-17,-3,19,13,41,281,800,1330,1417,919,249,-10,260,608,554,124,-237,-172,275,806,1179,1366,1532,1921,2648,3496,3955,3618,2598,1507,950,1019,1270,1166,539,-322,-950,-1081,-836,-599,-701,-1161,-1691,-1951,-1820,-1450,-1105,-952,-981,-1068,-1088,-996,-846,-737,-724,-762,-737,-571,-295,-28,127,155,123,108,152,249,367,464,508,488,416,307,169,7,-160,-309,-431,-535,-626,-692,-723,-730,-739,-753,-748,-702,-623,-536,-456,-380,-310,-253,-212,-178,-140,-102,-73,-54,-39,-24,-11,-5,-7,-21,-49,-85,-117,-132,-130,-125,-133,-160,-195,-223,-239,-249,-262,-276,-284,-279,-261,-234,-205,-180,-165,-158,-151,-137,-115,-92,-76,-71,-76,-83,-87,-87,-87,-88,-90,-91,-96,-107,-121,-128,-125,-120,-121,-130,-137,-135,-127,-121,-122,-127,-133,-139,-144,-148,-146,-136,-120,-100,-78,-55,-36,-25,-23,-24,-25,-25,-26,-27,-28,-36,-51,-71,-91,-105,-117,-133,-155,-174,-185,-193,-201,-204,-196,-182,-173,-167,-154,-133,-117,-115,-119,-113,-98,-84,-70,-52,-33,-28,-36,-39,-23},
            {-201,-169,295,234,-456,1012,7448,15767,17022,5654,-12237,-23148,-19349,-5713,6728,11227,8426,2731,-839,2044,12064,23255,26139,16602,887,-9895,-9907,-2529,4543,6218,2554,-3094,-7142,-8109,-7316,-7273,-8843,-10253,-9313,-6157,-3024,-1616,-1669,-2209,-3045,-4237,-4850,-3515,-373,2512,3208,1947,655,840,2404,4250,5341,5162,3862,2300,1552,1932,2662,2739,1948,750,-506,-1788,-2919,-3497,-3468,-3364,-3706,-4389,-4903,-4971,-4686,-4162,-3372,-2342,-1262,-311,458,1011,1245,1129,827,600,606,841,1196,1518,1651,1547,1333,1213,1262,1335,1210,809,283,-118,-244,-146,-18,-62,-356,-802,-1193,-1373,-1364,-1332,-1414,-1591,-1726,-1695,-1460,-1068,-631,-289,-130,-131,-181,-168,-38,191,429,563,548,465,457,585,781,920,914,732,416,95,-87,-102,-80,-167,-360,-516,-513,-361,-172,-71,-121,-298,-505,-630,-625,-518,-388,-303,-277,-259,-171,7,200,308,293,198,85,-6,-50,-36,14,66,113,182,273,337,320,207,29,-175,-357,-467,-479,-422,-343,-276,-222,-182,-159,-153,-171,-232,-342,-467,-548,-542,-441,-263,-45,143,234,211,122,27,-49,-112,-163,-190,-177,-128,-56,15,57,54,6,-74,-171,-266,-341,-383,-387,-350,-276,-184,-99,-34,9,24,-6,-80,-163,-206,-180,-93,23,126,181,181,152,126,106,72,14,-53,-103,-119,-87,-11,72,110,85,30,-15,-52,-96,-135,-127,-66}
        },
        {    // H0e080a.wav
            {0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,-1,-1,0,1,1,0,0,0,0,-1,-1,0,2,2,1,0,0,0,0,-1,-1,-1,0,1,1,1,0,1,5,11,10,1,-8,-2,17,30,25,9,-5,-14,-17,-11,0,-1,14,160,553,1113,1520,1465,983,446,191,194,185,27,-119,-13,370,824,1138,1278,1387,1675,2274,3090,3756,3838,3211,2251,1575,1515,1836,1957,1457,403,-745,-1510,-1730,-1616,-1531,-1695,-2039,-2315,-2335,-2118,-1833,-1638,-1568,-1552,-1496,-1347,-1114,-850,-623,-464,-336,-165,85,368,585,668,632,559,529,572,660,732,735,644,473,261,55,-118,-258,-385,-517,-653,-777,-874,-936,-963,-963,-944,-910,-852,-763,-653,-547,-459,-380,-288,-182,-83,-12,35,72,101,112,101,85,78,74,53,12,-29,-55,-72,-93,-121,-151,-188,-241,-296,-326,-320,-300,-295,-305,-307,-290,-264,-245,-232,-216,-196,-179,-165,-144,-115,-92,-87,-93,-93,-77,-53,-30,-14,-7,-14,-37,-68,-93,-103,-104,-105,-111,-121,-130,-137,-143,-148,-153,-158,-165,-169,-165,-150,-130,-113,-102,-91,-77,-62,-49,-38,-30,-28,-36,-49,-60,-63,-64,-69,-80,-91,-100,-110,-125,-143,-159,-172,-182,-188,-186,-174,-161,-156,-159,-161,-157,-148,-139,-131,-126,-124,-119,-107,-88,-69,-51,-33,-14},
            {-313,-20,469,39,-586,2153,10036,17625,15335,379,-17543,-24587,-16345,-991,10117,12055,7152,817,-1251,4748,16855,26230,23812,9644,-6135,-12701,-7969,1453,7607,7133,1738,-4497,-8047,-8085,-6793,-6986,-8966,-10243,-8629,-4863,-1634,-658,-1562,-3239,-5023,-6215,-5609,-2621,1323,3586,2922,813,-141,1158,3617,5431,5649,4456,2707,1463,1418,2282,2915,2423,1012,-449,-1455,-2090,-2479,-2569,-2521,-2795,-3580,-4449,-4840,-4680,-4282,-3785,-3043,-1998,-882,4,540,763,749,608,487,492,640,893,1192,1428,1493,1399,1298,1318,1403,1364,1067,567,68,-216,-204,-15,104,-35,-419,-861,-1172,-1300,-1331,-1380,-1495,-1630,-1692,-1595,-1309,-895,-491,-234,-167,-221,-278,-249,-98,149,399,537,526,460,482,640,848,969,908,662,322,46,-64,-54,-74,-215,-408,-509,-441,-255,-75,-23,-148,-388,-607,-693,-631,-491,-355,-277,-254,-225,-121,62,234,301,247,132,22,-48,-63,-27,25,69,120,206,302,340,282,141,-48,-255,-427,-498,-454,-355,-270,-212,-161,-118,-105,-130,-188,-282,-413,-540,-595,-537,-376,-160,51,193,224,158,52,-46,-123,-183,-223,-227,-188,-113,-21,53,73,34,-39,-124,-212,-298,-361,-380,-351,-289,-211,-127,-53,-2,19,5,-48,-129,-201,-221,-171,-66,57,150,182,158,118,95,78,38,-25,-83,-112,-107,-63,17,96,120,72,1,-42,-67,-112,-164,-162,-87}
        },
        {    // H0e085a.wav
            {1,1,0,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,2,2,2,2,2,1,1,1,1,1,0,0,1,1,0,-2,-2,-1,0,0,0,3,5,3,-3,-4,4,14,16,8,2,7,18,23,16,2,-14,-30,-33,-9,30,54,94,293,773,1401,1757,1473,661,-87,-228,212,708,798,511,226,235,514,857,1106,1257,1445,1880,2691,3721,4504,4567,3838,2737,1831,1369,1138,718,-114,-1175,-2028,-2344,-2186,-1953,-2022,-2426,-2869,-3025,-2806,-2371,-1941,-1645,-1483,-1378,-1233,-987,-654,-308,-23,186,360,543,743,922,1022,1009,905,787,727,733,744,692,554,350,114,-126,-338,-495,-596,-678,-786,-923,-1048,-1114,-1112,-1072,-1025,-975,-908,-811,-687,-543,-390,-244,-120,-26,44,101,148,179,191,186,168,140,111,92,82,64,21,-44,-110,-159,-191,-218,-249,-280,-305,-320,-325,-323,-318,-317,-320,-323,-316,-296,-267,-237,-211,-191,-173,-148,-114,-75,-43,-25,-17,-10,4,23,35,30,7,-23,-49,-69,-87,-103,-116,-124,-130,-139,-149,-157,-163,-167,-170,-167,-157,-143,-130,-120,-113,-108,-104,-100,-90,-72,-51,-37,-37,-49,-62,-70,-74,-80,-88,-96,-101,-106,-113,-119,-125,-136,-152,-165,-165,-154,-145,-147,-157,-165,-167,-166,-163,-159,-154,-145,-130,-107,-78,-49,-25,-8},
            {-364,64,551,-68,-624,2779,11292,18298,14085,-2538,-20101,-24872,-14345,1658,11811,12279,6352,-34,-1000,6619,19267,26885,21236,4885,-10229,-13905,-6245,4498,10194,8243,1305,-5705,-8893,-7896,-5890,-6237,-8833,-10400,-8457,-4107,-580,80,-1769,-4624,-7045,-7704,-5631,-1363,2649,3855,2115,-110,-293,1791,4369,5744,5508,4162,2464,1288,1284,2147,2630,1801,80,-1351,-1912,-1933,-1861,-1806,-1913,-2497,-3512,-4321,-4394,-3951,-3574,-3376,-2940,-2007,-844,96,601,696,486,162,-9,148,559,990,1254,1308,1227,1155,1212,1384,1502,1377,959,391,-84,-258,-106,172,273,37,-430,-871,-1115,-1182,-1207,-1307,-1497,-1689,-1747,-1570,-1178,-716,-365,-222,-249,-327,-352,-282,-118,109,329,457,471,450,507,675,872,969,882,620,288,34,-60,-50,-77,-212,-385,-466,-387,-198,-28,-3,-164,-428,-638,-689,-594,-439,-308,-240,-228,-204,-95,96,258,282,176,37,-53,-83,-72,-31,24,80,142,223,302,322,250,100,-90,-280,-422,-468,-420,-332,-253,-183,-110,-55,-44,-85,-168,-295,-454,-585,-615,-520,-331,-107,96,219,222,126,0,-104,-176,-232,-264,-254,-195,-103,-7,58,68,23,-55,-143,-230,-303,-341,-336,-303,-254,-188,-105,-27,18,22,-9,-68,-141,-196,-198,-138,-40,62,141,177,167,131,95,60,9,-62,-124,-146,-122,-60,24,97,116,73,10,-34,-71,-129,-186,-179,-96}
        },
        {    // H0e090a.wav
            {0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,-1,-1,0,1,1,0,-1,-1,0,1,1,0,-1,-1,0,0,-2,-3,-3,-2,-2,-2,0,3,4,1,-3,-3,0,5,11,17,17,8,-1,1,12,14,0,-17,-22,-17,18,142,388,652,734,557,326,356,708,1077,1110,804,506,509,751,932,868,639,441,379,436,581,864,1414,2342,3573,4746,5326,4938,3672,2063,748,64,-99,-146,-453,-1116,-1911,-2507,-2745,-2752,-2775,-2921,-3069,-3023,-2714,-2252,-1804,-1466,-1237,-1059,-863,-596,-252,109,404,596,726,857,1007,1136,1192,1152,1025,848,678,572,534,493,361,115,-178,-429,-598,-703,-774,-831,-892,-976,-1080,-1161,-1175,-1119,-1030,-935,-821,-670,-496,-340,-222,-125,-30,60,127,168,197,218,220,199,167,141,118,81,30,-17,-50,-82,-129,-183,-220,-235,-251,-284,-323,-345,-346,-341,-341,-343,-344,-348,-352,-340,-298,-235,-175,-131,-99,-70,-45,-27,-14,-1,15,30,41,44,37,16,-16,-49,-73,-84,-89,-94,-103,-115,-130,-148,-168,-186,-193,-184,-164,-149,-147,-156,-163,-161,-151,-136,-116,-94,-74,-61,-54,-51,-51,-58,-73,-89,-98,-97,-93,-96,-104,-111,-114,-118,-126,-132,-133,-133,-138,-148,-155,-160,-170,-185,-195,-191,-172,-144,-112,-81,-56,-40,-26,-11},
            {-371,42,567,-34,-702,2533,11051,18285,14239,-2540,-20416,-25216,-14297,2161,12401,12586,6369,-24,-769,6992,19416,26377,19882,2957,-12033,-14787,-5728,6267,12440,9928,1760,-6306,-9665,-7969,-5106,-5191,-8261,-10509,-8787,-4019,64,674,-2046,-5956,-8687,-8630,-5476,-665,3100,3753,1728,-379,-275,2008,4584,5768,5288,3857,2350,1492,1617,2226,2198,939,-850,-1951,-1985,-1572,-1344,-1395,-1697,-2381,-3323,-3950,-3865,-3381,-3065,-2948,-2583,-1770,-813,-81,342,499,378,47,-217,-141,267,761,1100,1197,1118,1020,1061,1246,1398,1305,924,400,-40,-221,-101,174,329,164,-269,-729,-1013,-1107,-1138,-1224,-1401,-1611,-1725,-1604,-1214,-695,-288,-144,-218,-348,-405,-355,-203,27,265,406,418,396,469,656,850,927,829,583,279,45,-43,-35,-63,-196,-367,-447,-372,-183,-3,35,-125,-401,-622,-668,-555,-386,-256,-204,-215,-211,-107,91,258,267,125,-49,-148,-155,-103,-26,42,87,129,202,285,315,245,91,-104,-296,-429,-455,-382,-278,-195,-128,-61,-17,-29,-89,-175,-294,-448,-587,-622,-519,-322,-98,98,214,211,101,-40,-146,-210,-258,-292,-287,-225,-122,-16,57,77,41,-35,-129,-226,-306,-351,-354,-322,-263,-178,-78,6,48,42,0,-68,-147,-207,-212,-148,-37,80,166,197,175,126,74,22,-40,-108,-159,-172,-143,-76,12,86,104,61,-2,-48,-84,-130,-168,-153,-79}
        },
        {    // H0e095a.wav
            {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,-1,-1,-1,-1,-1,0,1,1,0,-1,0,1,1,0,-1,-2,-3,-3,-2,-2,-2,0,2,0,-3,-3,1,4,6,9,11,10,9,12,12,2,-10,-9,-2,0,49,236,554,810,765,387,-72,-292,-138,288,776,1144,1294,1225,1027,843,825,1061,1467,1718,1419,515,-467,-748,26,1463,2826,3675,4048,4126,3905,3265,2227,1044,55,-503,-618,-533,-625,-1143,-1994,-2807,-3244,-3246,-3004,-2739,-2552,-2422,-2270,-2015,-1626,-1160,-746,-484,-351,-226,-7,296,597,829,984,1084,1137,1143,1103,1012,862,671,493,373,290,175,-9,-235,-454,-639,-774,-836,-829,-810,-853,-966,-1084,-1131,-1087,-980,-841,-692,-556,-449,-363,-272,-162,-51,37,99,146,182,197,183,150,114,86,64,47,33,19,-4,-45,-99,-155,-203,-243,-277,-300,-309,-311,-323,-351,-381,-396,-392,-373,-341,-294,-237,-183,-142,-111,-83,-58,-39,-24,-9,7,17,18,13,6,-4,-21,-41,-52,-49,-38,-37,-56,-91,-128,-155,-171,-180,-187,-194,-200,-202,-199,-189,-175,-161,-154,-151,-144,-129,-109,-94,-87,-83,-76,-67,-61,-62,-71,-85,-100,-114,-124,-128,-125,-116,-108,-106,-110,-119,-132,-145,-155,-161,-164,-165,-164,-160,-151,-131,-100,-67,-46,-37,-28,-14},
            {-337,-96,497,158,-726,1526,9309,17437,15664,422,-18314,-25557,-16331,378,11954,13165,7230,607,-824,5905,17682,25168,20018,3882,-11691,-15612,-6824,6293,14055,12306,3592,-5778,-10196,-8598,-4936,-4138,-7132,-10202,-9353,-4646,73,1096,-2017,-6684,-9704,-9313,-5783,-961,2730,3645,2061,53,-221,1635,4138,5539,5267,3911,2417,1564,1684,2293,2235,801,-1296,-2562,-2352,-1429,-871,-995,-1537,-2300,-3135,-3652,-3528,-3009,-2644,-2543,-2286,-1584,-685,-10,295,301,82,-237,-394,-185,280,689,857,843,802,839,985,1189,1305,1187,829,381,23,-132,-58,158,318,219,-152,-590,-869,-956,-993,-1116,-1332,-1552,-1660,-1557,-1213,-730,-316,-133,-171,-295,-387,-395,-292,-72,189,358,381,356,423,599,775,836,751,543,281,66,-25,-20,-39,-162,-335,-436,-384,-200,2,79,-49,-313,-543,-612,-527,-374,-236,-164,-170,-195,-135,36,207,236,110,-58,-170,-206,-179,-99,0,73,116,174,258,305,252,103,-88,-270,-394,-417,-345,-238,-156,-97,-37,5,-7,-75,-174,-297,-444,-569,-597,-500,-319,-115,64,177,185,92,-41,-155,-237,-299,-330,-307,-228,-118,-10,72,100,60,-35,-151,-258,-336,-372,-364,-321,-252,-162,-59,31,76,64,7,-75,-157,-207,-197,-125,-17,90,164,186,156,98,42,-3,-52,-109,-160,-184,-167,-111,-32,38,62,37,-4,-34,-62,-105,-143,-133,-69}
        },
        {    // H0e100a.wav
            {1,1,0,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,1,1,2,3,3,1,0,1,1,-1,-1,1,3,1,-1,-1,1,4,8,10,8,5,7,14,16,11,9,6,-9,-2,128,443,817,965,697,148,-308,-379,-90,298,544,587,533,543,733,1101,1525,1862,2072,2206,2242,1974,1189,24,-933,-1028,-105,1320,2478,2929,2778,2420,2158,2028,1860,1455,760,-37,-620,-819,-793,-904,-1376,-2089,-2710,-2978,-2872,-2560,-2245,-2038,-1912,-1748,-1453,-1055,-682,-440,-324,-237,-81,178,498,790,972,1023,985,923,873,828,760,643,470,267,76,-76,-205,-342,-485,-602,-667,-694,-715,-747,-786,-827,-867,-891,-873,-803,-704,-608,-528,-452,-367,-276,-188,-106,-29,33,66,66,52,48,61,81,93,95,89,74,44,-1,-55,-110,-162,-204,-230,-240,-246,-267,-307,-354,-387,-390,-361,-310,-257,-221,-207,-199,-180,-146,-105,-69,-43,-30,-29,-35,-42,-42,-35,-25,-17,-14,-16,-21,-25,-29,-35,-46,-62,-86,-117,-153,-185,-207,-216,-215,-206,-192,-176,-161,-151,-148,-153,-162,-166,-157,-136,-109,-85,-70,-64,-65,-70,-75,-80,-88,-100,-114,-123,-123,-118,-114,-115,-118,-122,-124,-120,-110,-103,-104,-110,-111,-105,-97,-91,-81,-66,-52,-42,-30,-14},
            {-206,-292,283,419,-516,225,6260,15142,17297,5902,-13085,-24734,-19979,-4161,9798,13815,9120,2040,-1027,3612,14296,23108,21144,7336,-8959,-15865,-9416,4035,14272,15021,7092,-3481,-9988,-9737,-5743,-3527,-5599,-9220,-9771,-5870,-729,1230,-1479,-6492,-10063,-10013,-6709,-2089,1737,3380,2692,936,39,1059,3284,5018,5202,4101,2697,1826,1792,2219,2173,932,-1098,-2573,-2599,-1654,-884,-846,-1307,-1957,-2714,-3363,-3510,-3076,-2486,-2125,-1878,-1413,-711,-61,303,346,113,-274,-546,-433,44,565,834,820,690,617,698,919,1140,1166,909,471,55,-173,-148,73,302,298,-17,-462,-769,-854,-861,-960,-1182,-1430,-1579,-1526,-1220,-742,-307,-107,-147,-280,-372,-379,-293,-110,116,272,300,286,356,528,702,774,710,525,269,47,-46,-23,-4,-87,-251,-389,-400,-258,-37,110,50,-194,-450,-557,-500,-366,-235,-153,-143,-177,-156,-15,166,233,129,-46,-172,-216,-202,-147,-66,9,63,126,218,294,285,171,-8,-196,-337,-384,-332,-234,-147,-80,-13,37,29,-44,-150,-273,-418,-551,-598,-515,-336,-134,42,161,186,103,-43,-175,-256,-296,-310,-290,-221,-115,-5,73,92,47,-47,-162,-268,-339,-361,-336,-287,-232,-169,-90,-3,60,75,41,-22,-93,-149,-164,-126,-47,44,114,146,141,114,75,24,-42,-113,-172,-206,-201,-149,-60,27,66,49,10,-20,-46,-85,-118,-109,-56}
        },
        {    // H0e105a.wav
            {1,0,0,1,2,2,1,0,0,1,2,2,0,-1,0,1,1,0,0,0,0,0,0,0,0,1,2,2,1,0,1,2,1,1,1,1,0,0,1,-1,-2,4,13,11,-1,-5,9,21,14,5,13,16,1,49,296,730,1079,1010,478,-171,-494,-333,97,456,562,464,321,258,323,552,1018,1764,2638,3257,3235,2525,1501,651,194,4,-118,-184,-60,307,773,1117,1232,1186,1123,1135,1205,1228,1073,672,92,-481,-864,-1020,-1083,-1241,-1578,-2003,-2313,-2338,-2070,-1674,-1364,-1227,-1182,-1100,-932,-715,-485,-242,5,218,370,482,586,678,728,726,692,641,562,441,286,119,-46,-197,-316,-388,-420,-438,-469,-516,-568,-608,-630,-635,-632,-627,-624,-621,-610,-577,-512,-426,-344,-290,-262,-240,-206,-159,-105,-48,3,36,52,64,83,96,84,43,-8,-52,-85,-112,-133,-152,-178,-218,-259,-282,-279,-263,-251,-248,-246,-237,-219,-197,-174,-150,-128,-115,-111,-111,-106,-95,-86,-82,-79,-66,-42,-19,-10,-20,-41,-59,-67,-65,-59,-60,-76,-108,-142,-165,-174,-175,-174,-171,-165,-159,-159,-165,-175,-183,-185,-180,-166,-145,-119,-96,-83,-81,-86,-91,-93,-90,-85,-84,-91,-106,-124,-137,-140,-135,-124,-109,-90,-70,-53,-46,-46,-48,-48,-52,-61,-66,-61,-54,-57,-64,-55,-27},
            {28,-426,-94,544,30,-610,2626,10822,17171,12267,-4231,-20420,-23234,-11398,4502,13235,11818,4896,-564,645,9170,19352,22075,12701,-3297,-14257,-12547,-672,11947,16843,11842,1211,-7952,-10716,-7708,-4012,-4052,-7337,-9517,-7433,-2543,728,-531,-5193,-9549,-10653,-8201,-3900,197,2693,3079,1887,582,633,2245,4179,5013,4408,3119,2109,1865,2196,2316,1389,-573,-2418,-2900,-2013,-928,-634,-1081,-1723,-2331,-2928,-3321,-3216,-2686,-2119,-1707,-1282,-701,-109,257,320,145,-162,-431,-454,-166,261,591,735,749,709,678,718,833,922,857,610,262,-63,-233,-162,82,247,111,-276,-642,-801,-822,-883,-1045,-1241,-1384,-1402,-1224,-844,-400,-104,-55,-174,-315,-381,-338,-178,45,216,262,235,262,394,573,700,707,567,310,44,-98,-85,-18,-27,-144,-294,-373,-313,-125,73,119,-52,-326,-511,-518,-402,-266,-169,-134,-150,-150,-61,100,210,168,7,-156,-239,-238,-181,-102,-37,3,56,155,266,306,234,80,-101,-259,-352,-346,-258,-153,-75,-16,35,48,-10,-124,-253,-378,-494,-566,-542,-411,-214,-20,120,173,128,7,-133,-238,-286,-289,-265,-225,-169,-95,-11,53,60,4,-90,-190,-280,-346,-370,-344,-284,-211,-131,-39,51,108,102,38,-53,-136,-183,-177,-114,-11,93,157,164,127,71,7,-62,-128,-177,-198,-189,-147,-73,8,58,58,27,-9,-42,-75,-96,-83,-39}
        },
        {    // H0e110a.wav
            {0,0,0,0,1,2,1,0,1,2,1,0,0,0,0,-1,0,1,0,-1,-1,0,1,1,0,0,0,1,3,3,1,0,1,2,2,2,3,2,-4,-5,4,14,11,0,-2,7,10,6,14,25,10,8,170,595,1106,1294,889,94,-544,-613,-176,361,636,574,335,125,79,266,727,1439,2240,2831,2955,2609,2065,1618,1332,1066,715,357,114,-45,-278,-628,-904,-852,-439,91,458,594,640,741,896,992,923,659,246,-207,-565,-754,-822,-888,-1032,-1231,-1411,-1508,-1497,-1391,-1243,-1123,-1053,-975,-812,-563,-310,-131,-30,41,125,227,333,426,479,462,372,243,127,54,14,-28,-93,-176,-251,-299,-317,-317,-317,-335,-378,-434,-475,-484,-472,-461,-460,-463,-469,-485,-505,-501,-455,-383,-319,-274,-226,-158,-85,-37,-19,-13,-5,3,3,-4,-12,-26,-55,-94,-126,-134,-121,-107,-107,-123,-146,-168,-186,-194,-190,-178,-167,-161,-152,-138,-130,-142,-165,-178,-171,-151,-130,-106,-78,-58,-60,-77,-88,-85,-79,-87,-106,-121,-120,-108,-96,-86,-81,-86,-99,-112,-120,-128,-142,-163,-186,-203,-207,-197,-179,-162,-149,-140,-134,-129,-120,-108,-99,-98,-100,-98,-97,-106,-121,-131,-131,-125,-115,-100,-81,-68,-61,-51,-33,-17,-11,-8,-3,-4,-19,-38,-47,-53,-74,-100,-96,-51},
            {246,-298,-417,288,544,-424,-47,5235,13492,16087,6405,-10824,-22252,-18921,-4672,8894,13490,9300,2187,-1178,3016,12854,20553,18095,5206,-9055,-14038,-6784,6339,15826,16041,7883,-2901,-9818,-10039,-6217,-3635,-4949,-7897,-8358,-5117,-1079,-71,-3087,-7681,-10458,-9768,-6338,-2056,1370,2970,2653,1326,523,1248,3055,4520,4666,3716,2578,1973,2045,2346,2039,563,-1581,-3025,-2868,-1629,-603,-495,-1060,-1828,-2603,-3218,-3356,-2912,-2229,-1701,-1326,-867,-296,157,317,209,-46,-310,-417,-252,108,451,636,684,685,694,736,802,834,763,582,333,63,-166,-249,-133,51,64,-185,-532,-753,-808,-821,-900,-1040,-1182,-1259,-1192,-930,-533,-175,-5,-33,-163,-293,-354,-297,-115,110,253,266,232,271,412,578,668,620,427,150,-86,-170,-105,-19,-37,-163,-297,-328,-220,-33,96,48,-172,-420,-537,-485,-343,-208,-130,-114,-124,-93,19,150,186,81,-89,-217,-255,-217,-132,-38,24,53,98,183,263,263,164,9,-149,-272,-322,-282,-188,-97,-36,6,27,0,-82,-191,-303,-415,-512,-546,-477,-321,-131,41,154,171,91,-41,-164,-248,-299,-321,-304,-242,-144,-31,70,122,98,5,-124,-252,-351,-405,-400,-337,-237,-128,-29,45,81,70,18,-56,-126,-166,-161,-110,-26,64,126,135,96,39,-8,-43,-75,-109,-140,-158,-149,-101,-23,48,76,61,28,-8,-45,-73,-70,-35}
        },
        {    // H0e115a.wav
            {1,1,1,1,1,2,3,3,1,1,2,3,2,0,0,1,1,0,0,0,1,2,1,1,0,-1,0,4,4,1,0,2,3,1,2,7,6,-2,-5,3,10,5,1,8,12,4,4,24,28,2,71,425,1033,1498,1343,523,-433,-864,-555,127,637,706,447,132,-29,74,518,1313,2288,3064,3258,2787,1960,1237,886,856,940,973,873,592,119,-452,-943,-1222,-1296,-1265,-1182,-1004,-673,-227,193,462,582,669,826,1027,1122,964,556,74,-246,-297,-188,-155,-356,-754,-1171,-1440,-1491,-1349,-1104,-879,-769,-770,-781,-704,-538,-355,-216,-125,-60,-8,34,63,68,44,10,4,41,96,122,94,25,-55,-118,-148,-148,-142,-160,-211,-276,-328,-353,-363,-380,-417,-465,-507,-530,-532,-510,-460,-390,-325,-283,-259,-233,-197,-161,-132,-111,-95,-87,-89,-92,-86,-68,-41,-13,10,24,24,7,-26,-70,-112,-136,-135,-116,-97,-94,-112,-139,-161,-172,-173,-171,-171,-170,-165,-157,-145,-131,-119,-117,-129,-149,-166,-174,-172,-158,-135,-110,-92,-82,-73,-61,-49,-44,-51,-73,-105,-141,-173,-195,-203,-196,-179,-164,-157,-151,-140,-129,-125,-128,-128,-124,-121,-123,-127,-131,-135,-136,-128,-108,-85,-67,-53,-41,-35,-35,-34,-24,-9,4,15,24,19,-4,-31,-48,-65,-99,-132,-123,-63},
            {216,71,-326,-212,416,305,-583,767,6896,14161,13969,2291,-13669,-21298,-14968,-796,10446,12755,7592,812,-1298,4276,14140,19663,14305,735,-10724,-11445,-1783,10437,16922,14286,4953,-5129,-10385,-9376,-5550,-3670,-5183,-7385,-7043,-4069,-1362,-1614,-4789,-8477,-10114,-8749,-5192,-1099,1949,3021,2254,897,507,1655,3465,4559,4357,3343,2356,1931,2089,2302,1746,56,-2040,-3208,-2831,-1571,-561,-362,-865,-1786,-2809,-3463,-3360,-2633,-1830,-1320,-996,-624,-207,88,179,101,-85,-280,-320,-105,274,607,761,752,678,641,698,818,881,773,489,127,-180,-326,-275,-110,-17,-149,-465,-765,-890,-857,-800,-824,-937,-1074,-1137,-1029,-726,-331,-24,73,-12,-162,-276,-312,-241,-64,146,269,263,223,271,424,580,634,537,309,31,-166,-188,-80,5,-41,-183,-300,-300,-180,-22,47,-62,-301,-509,-554,-444,-284,-163,-111,-114,-125,-78,44,157,156,31,-124,-215,-218,-156,-60,30,79,94,120,178,225,208,116,-21,-163,-267,-294,-243,-161,-92,-42,-9,-8,-58,-142,-230,-322,-429,-517,-523,-420,-245,-58,94,172,142,11,-151,-266,-308,-302,-273,-220,-136,-35,54,101,91,26,-80,-198,-295,-347,-349,-316,-266,-205,-136,-68,-16,9,8,-17,-59,-105,-135,-132,-95,-31,36,79,85,65,39,14,-16,-53,-93,-127,-142,-121,-56,28,88,100,76,36,-13,-56,-66,-37}
        },
        {    // H0e120a.wav
            {0,1,2,1,0,2,4,3,1,1,2,1,-1,-1,0,-1,-1,0,1,0,0,2,2,-1,-2,1,3,2,0,2,3,0,0,6,9,2,-4,2,10,4,-6,2,17,10,-5,10,40,25,22,259,870,1569,1750,1068,-114,-978,-975,-274,491,818,641,219,-129,-152,313,1276,2483,3438,3671,3093,2096,1257,886,854,829,633,354,150,33,-137,-471,-911,-1274,-1413,-1339,-1192,-1105,-1095,-1065,-907,-584,-149,303,680,927,1040,1071,1090,1131,1150,1055,796,429,85,-153,-320,-517,-782,-1041,-1187,-1184,-1087,-982,-928,-928,-942,-914,-819,-684,-560,-477,-430,-405,-381,-328,-219,-68,71,155,190,210,227,227,198,149,96,48,8,-26,-66,-130,-220,-311,-370,-390,-392,-395,-404,-414,-429,-451,-469,-467,-440,-402,-365,-332,-302,-280,-273,-279,-278,-246,-176,-84,-1,51,70,71,66,59,51,40,24,3,-21,-44,-61,-71,-73,-74,-80,-96,-119,-143,-163,-175,-181,-183,-186,-188,-188,-188,-196,-215,-235,-244,-236,-216,-188,-152,-116,-94,-88,-85,-70,-47,-34,-40,-60,-86,-112,-135,-153,-163,-166,-163,-156,-149,-143,-138,-132,-125,-122,-127,-138,-153,-165,-168,-158,-141,-124,-109,-90,-68,-53,-48,-47,-41,-32,-21,-7,8,15,9,0,-3,-10,-31,-55,-68,-80,-111,-144,-133,-69},
            {-56,263,119,-339,-212,409,223,-555,1164,7318,13684,12277,547,-13804,-19506,-12631,554,10507,12160,6873,139,-1783,3993,13574,18222,12280,-516,-9964,-8847,1155,12140,16832,12959,3422,-6076,-10580,-9168,-5321,-3426,-4652,-6546,-6399,-4256,-2445,-2891,-5392,-8140,-9286,-8013,-4740,-808,2122,2961,1959,604,438,1758,3524,4489,4255,3292,2316,1829,1918,2109,1586,-18,-2000,-3116,-2806,-1664,-692,-425,-850,-1750,-2760,-3352,-3177,-2441,-1682,-1192,-850,-503,-209,-72,-44,-38,-66,-141,-150,36,377,692,842,825,721,640,674,811,909,802,466,38,-302,-447,-385,-216,-126,-265,-594,-901,-1006,-923,-809,-783,-853,-956,-1001,-898,-612,-239,39,103,-2,-144,-232,-241,-159,7,185,264,226,177,238,408,571,614,497,255,-12,-173,-161,-44,21,-53,-212,-329,-324,-211,-82,-49,-171,-386,-550,-558,-430,-268,-159,-126,-141,-144,-78,50,153,145,34,-94,-162,-154,-89,2,78,110,115,136,183,210,174,77,-49,-175,-271,-297,-247,-164,-101,-66,-47,-51,-96,-174,-260,-343,-427,-486,-471,-365,-212,-73,19,54,25,-56,-146,-199,-206,-196,-187,-169,-125,-58,10,55,59,19,-58,-156,-253,-329,-365,-356,-310,-242,-164,-85,-20,11,-2,-49,-110,-163,-190,-171,-102,-6,74,109,99,69,38,10,-17,-46,-75,-98,-101,-68,-2,69,109,105,65,11,-33,-46,-28}
        },
        {    // H0e125a.wav
            {2,1,0,1,3,2,1,0,1,1,0,-1,-1,0,0,-1,-1,-1,-1,-2,-2,-2,-1,0,1,0,-2,-1,1,-1,-4,1,8,5,-6,-6,6,8,-5,-8,10,17,-3,-8,26,40,16,141,674,1517,2053,1650,375,-925,-1359,-776,205,837,826,372,-130,-317,79,1142,2608,3863,4260,3603,2342,1242,783,840,934,740,328,-48,-298,-559,-961,-1413,-1665,-1574,-1263,-1002,-954,-1045,-1099,-1034,-907,-776,-600,-303,95,471,721,858,984,1179,1417,1588,1577,1348,957,512,120,-146,-267,-305,-376,-568,-852,-1104,-1215,-1185,-1099,-1046,-1054,-1090,-1104,-1071,-1001,-916,-818,-683,-500,-291,-100,46,145,209,253,290,329,366,379,344,254,127,4,-83,-129,-159,-197,-245,-287,-312,-328,-347,-373,-401,-426,-448,-465,-469,-459,-444,-440,-454,-468,-449,-378,-269,-158,-76,-28,-3,12,22,33,51,72,82,67,37,12,3,11,23,27,12,-21,-61,-94,-112,-125,-146,-176,-197,-199,-194,-204,-235,-269,-294,-307,-307,-282,-232,-181,-154,-150,-145,-125,-96,-72,-59,-55,-63,-85,-112,-131,-136,-132,-128,-127,-123,-113,-101,-99,-108,-120,-130,-142,-156,-165,-161,-153,-153,-158,-154,-133,-107,-86,-69,-53,-44,-46,-49,-41,-23,-7,1,1,-8,-24,-38,-45,-55,-75,-92,-96,-99,-120,-144,-128,-65},
            {-154,21,239,51,-330,-168,383,188,-504,1072,6656,12530,11511,1085,-12077,-17760,-11965,101,9764,11837,6927,-36,-2726,2272,11660,16984,12348,821,-8047,-7221,1965,12156,16433,12546,3179,-6208,-10736,-9315,-5200,-2800,-3668,-5783,-6453,-5197,-3688,-3636,-5230,-7303,-8374,-7497,-4683,-979,1945,2811,1758,337,194,1627,3502,4512,4283,3318,2298,1691,1654,1856,1544,243,-1552,-2725,-2672,-1820,-1017,-736,-1004,-1685,-2505,-3003,-2865,-2269,-1674,-1286,-964,-594,-295,-183,-175,-135,-72,-47,-4,171,469,751,888,862,749,663,698,833,919,800,455,13,-351,-518,-462,-284,-180,-303,-617,-924,-1054,-1005,-893,-823,-823,-866,-887,-800,-563,-247,-1,78,18,-79,-142,-143,-66,79,223,268,199,118,148,310,504,607,542,320,47,-132,-139,-45,-2,-93,-260,-387,-398,-299,-170,-120,-220,-423,-589,-602,-474,-302,-177,-130,-141,-150,-93,32,147,165,84,-20,-77,-71,-18,54,109,124,119,139,183,198,146,43,-75,-188,-277,-308,-267,-189,-124,-85,-63,-66,-113,-194,-276,-350,-426,-493,-506,-435,-293,-130,9,87,82,7,-91,-165,-202,-214,-208,-177,-116,-31,55,110,104,27,-96,-226,-327,-378,-374,-326,-260,-202,-161,-126,-97,-84,-95,-124,-156,-177,-169,-126,-54,27,88,113,101,68,33,10,-5,-21,-41,-54,-49,-23,19,67,102,99,53,-6,-37,-27}
        },
        {    // H0e130a.wav
            {1,1,2,3,2,1,1,2,0,-2,-1,1,0,-2,-1,1,1,0,-1,-1,-2,-1,1,1,-2,-1,4,4,-3,-5,4,9,1,-6,2,10,0,-9,6,22,6,-14,13,48,25,66,491,1393,2248,2214,998,-678,-1646,-1347,-247,723,980,578,-54,-429,-140,1002,2737,4315,4890,4153,2625,1269,728,876,1082,873,311,-223,-511,-703,-1068,-1635,-2133,-2266,-1996,-1547,-1180,-996,-945,-942,-922,-816,-563,-196,129,258,198,138,282,670,1147,1484,1549,1386,1163,1015,942,841,643,381,134,-63,-222,-362,-497,-657,-868,-1101,-1277,-1343,-1326,-1305,-1333,-1388,-1394,-1281,-1041,-739,-469,-284,-173,-90,6,133,283,416,474,434,341,266,235,215,170,96,14,-64,-130,-181,-215,-244,-288,-348,-400,-420,-413,-402,-411,-449,-506,-554,-558,-498,-392,-282,-207,-174,-165,-157,-139,-107,-60,-6,35,45,26,7,12,43,81,107,115,105,77,33,-18,-66,-103,-127,-144,-155,-160,-160,-167,-192,-235,-282,-311,-316,-305,-285,-256,-220,-186,-164,-151,-139,-123,-107,-96,-93,-98,-111,-130,-149,-159,-151,-127,-98,-75,-61,-53,-52,-64,-90,-120,-143,-158,-167,-167,-155,-136,-121,-112,-101,-86,-76,-74,-73,-65,-53,-43,-36,-30,-28,-31,-37,-44,-56,-73,-86,-91,-98,-110,-116,-105,-94,-105,-124,-111,-57},
            {47,-149,-87,178,136,-225,-218,267,256,-386,571,5155,10876,11372,3214,-8930,-15826,-12357,-1753,8180,11515,7529,316,-3746,-311,8718,15654,13736,4019,-5246,-6371,1090,10904,15895,12907,3982,-5570,-10628,-9582,-5223,-2094,-2511,-5084,-6862,-6433,-4831,-3971,-4736,-6433,-7594,-7078,-4718,-1392,1412,2450,1637,238,-100,1212,3254,4580,4512,3453,2240,1494,1400,1658,1585,653,-896,-2155,-2439,-1914,-1276,-1020,-1204,-1691,-2274,-2644,-2547,-2076,-1599,-1344,-1194,-946,-604,-319,-161,-88,-57,-40,29,221,515,789,932,915,801,699,706,816,899,800,484,57,-316,-502,-461,-282,-165,-271,-578,-891,-1041,-1020,-932,-862,-837,-849,-860,-792,-587,-290,-36,75,58,-7,-60,-70,-9,123,259,299,221,116,104,221,403,545,556,406,159,-47,-108,-57,-30,-122,-298,-445,-479,-394,-259,-180,-237,-410,-581,-630,-531,-359,-212,-146,-149,-155,-92,45,179,224,163,63,-8,-20,22,91,146,158,142,139,161,171,129,39,-71,-182,-273,-310,-271,-184,-105,-64,-60,-90,-161,-263,-361,-428,-463,-472,-443,-362,-235,-97,10,51,20,-54,-128,-171,-174,-146,-100,-53,-18,5,23,35,20,-35,-116,-198,-266,-316,-340,-328,-286,-239,-207,-189,-172,-145,-116,-102,-111,-131,-136,-109,-51,26,98,136,124,81,43,31,33,27,9,-10,-22,-18,15,72,109,87,20,-30,-28}
        },
        {    // H0e135a.wav
            {3,3,0,-1,0,1,-1,-2,-1,0,-1,-2,-1,0,-1,-2,-1,-1,-3,-3,1,3,-1,-4,0,3,-2,-5,2,9,3,-9,-4,9,3,-14,-6,22,18,-15,-8,43,45,35,336,1215,2315,2689,1681,-245,-1769,-1901,-817,466,1055,777,48,-511,-332,885,2887,4795,5561,4748,2931,1275,612,856,1245,1115,437,-324,-772,-954,-1211,-1746,-2379,-2723,-2557,-2030,-1503,-1234,-1220,-1284,-1254,-1041,-634,-111,353,574,522,368,339,517,797,1011,1072,1011,912,838,795,761,725,699,681,626,482,253,4,-198,-339,-463,-626,-854,-1127,-1382,-1555,-1619,-1587,-1483,-1319,-1119,-922,-757,-612,-455,-282,-122,-3,81,157,238,309,350,357,344,325,298,248,166,66,-23,-87,-136,-189,-249,-307,-354,-390,-417,-432,-434,-425,-412,-398,-384,-364,-330,-283,-239,-219,-224,-229,-212,-178,-147,-128,-115,-95,-65,-25,28,86,132,148,131,95,54,17,-15,-47,-83,-120,-145,-148,-132,-118,-126,-160,-207,-250,-279,-288,-277,-250,-220,-202,-199,-201,-195,-176,-154,-140,-140,-151,-161,-167,-172,-172,-164,-148,-126,-99,-68,-41,-31,-40,-64,-95,-126,-148,-154,-146,-132,-120,-110,-99,-84,-66,-51,-46,-54,-69,-81,-85,-82,-74,-62,-55,-62,-82,-101,-111,-119,-130,-136,-130,-120,-117,-114,-101,-89,-94,-108,-97,-50},
            {62,41,-88,-88,106,148,-120,-231,121,292,-207,42,3250,8602,11052,6040,-4607,-13132,-12927,-4493,5628,10673,8281,1322,-4171,-2984,4940,13475,15140,8182,-1394,-5353,-648,8483,14739,13516,5609,-4041,-9951,-9737,-5474,-1670,-1443,-4265,-7132,-7651,-5997,-4225,-4084,-5519,-6974,-6888,-4890,-1874,756,1940,1513,331,-237,666,2632,4341,4732,3806,2395,1376,1122,1403,1573,1037,-213,-1504,-2091,-1870,-1373,-1149,-1321,-1703,-2093,-2336,-2302,-1994,-1615,-1387,-1316,-1216,-954,-593,-288,-122,-72,-56,17,204,487,773,951,966,859,742,713,780,844,781,545,194,-150,-368,-400,-289,-187,-251,-505,-808,-984,-984,-896,-832,-832,-864,-874,-810,-639,-385,-138,8,40,15,-10,-10,31,128,253,325,291,197,150,208,333,442,461,357,162,-22,-95,-56,-19,-94,-277,-460,-539,-487,-357,-254,-267,-405,-573,-644,-568,-401,-240,-151,-133,-134,-84,43,188,261,224,127,47,26,58,117,167,174,142,112,117,135,116,43,-59,-154,-218,-240,-219,-177,-151,-160,-188,-215,-237,-262,-290,-321,-357,-392,-405,-377,-308,-215,-122,-52,-20,-27,-51,-66,-64,-56,-54,-55,-48,-30,-7,8,2,-33,-99,-184,-266,-324,-349,-342,-312,-268,-222,-183,-154,-129,-107,-97,-105,-121,-122,-91,-31,38,98,128,125,100,72,56,52,49,37,12,-16,-28,-11,24,48,43,20,3}
        },
        {    // H0e140a.wav
            {1,0,0,0,-1,-3,-3,-1,0,-2,-2,0,0,-2,-1,1,-1,-4,-2,2,1,-3,-1,4,1,-6,-2,8,6,-7,-6,9,9,-12,-14,14,23,-10,-18,35,59,25,224,1044,2315,3072,2351,300,-1736,-2384,-1448,86,1056,990,204,-567,-545,736,3038,5320,6300,5404,3274,1291,488,817,1380,1329,555,-395,-972,-1145,-1322,-1846,-2608,-3143,-3084,-2498,-1807,-1399,-1345,-1449,-1491,-1355,-1000,-445,175,622,742,633,571,744,1082,1341,1324,1029,629,341,277,384,512,551,496,414,365,369,408,426,346,123,-200,-519,-750,-896,-1026,-1195,-1379,-1485,-1437,-1254,-1037,-876,-780,-711,-647,-581,-487,-332,-133,38,126,157,197,270,336,350,308,236,159,95,50,14,-41,-130,-238,-326,-363,-348,-301,-255,-240,-267,-317,-351,-336,-277,-213,-181,-191,-222,-251,-266,-265,-250,-225,-200,-180,-159,-126,-75,-12,49,90,101,85,57,29,3,-31,-76,-117,-133,-122,-97,-77,-77,-104,-152,-200,-227,-222,-196,-169,-157,-162,-176,-188,-192,-189,-182,-175,-177,-190,-206,-211,-203,-192,-183,-170,-146,-112,-79,-54,-44,-54,-84,-120,-142,-145,-137,-127,-113,-92,-66,-40,-18,-5,-8,-25,-50,-75,-94,-103,-99,-89,-82,-85,-95,-109,-127,-143,-147,-141,-138,-145,-149,-137,-119,-107,-99,-85,-75,-86,-106,-98,-51},
            {-61,39,88,-27,-123,1,149,14,-204,-53,247,22,-240,1438,5817,9800,8401,381,-9075,-12586,-7469,2025,8820,8710,2860,-3545,-4875,870,9922,15151,12155,3582,-3033,-2115,5159,12391,13612,7700,-1468,-8315,-9512,-5994,-1806,-709,-3279,-6902,-8472,-7151,-4739,-3630,-4569,-6249,-6772,-5325,-2593,40,1473,1409,438,-273,257,1994,3841,4598,3981,2676,1571,1104,1182,1386,1200,368,-808,-1653,-1767,-1410,-1144,-1232,-1528,-1816,-2026,-2124,-2032,-1771,-1515,-1393,-1324,-1143,-830,-529,-350,-264,-180,-43,166,440,726,920,948,849,740,718,784,857,835,665,374,51,-197,-306,-286,-225,-246,-420,-690,-905,-955,-866,-756,-710,-732,-779,-802,-746,-574,-324,-108,-14,-21,-41,-18,46,140,254,345,350,269,188,195,285,375,383,280,97,-85,-172,-132,-42,-32,-161,-365,-523,-556,-472,-354,-304,-375,-515,-606,-566,-415,-241,-126,-95,-119,-121,-41,107,235,264,202,122,84,92,119,140,136,102,65,65,103,131,104,19,-91,-193,-263,-281,-250,-199,-161,-152,-164,-189,-229,-282,-337,-387,-430,-456,-442,-375,-266,-146,-47,6,6,-27,-59,-65,-48,-26,-14,-15,-25,-38,-53,-70,-97,-140,-198,-255,-295,-310,-303,-277,-238,-198,-172,-162,-154,-135,-112,-98,-93,-84,-60,-22,23,70,107,120,107,83,64,54,43,22,-8,-36,-50,-39,-9,21,29,16}
        },
        {    // H0e145a.wav
            {-1,-1,-2,-5,-4,-1,-1,-4,-4,-1,0,-2,-3,-1,-1,-4,-4,0,1,-2,-2,3,1,-6,-4,7,7,-9,-12,7,15,-8,-22,5,28,-2,-31,15,64,30,147,889,2274,3379,2985,894,-1602,-2803,-2111,-392,970,1185,403,-575,-746,578,3203,5901,7098,6065,3559,1240,354,840,1606,1595,645,-568,-1295,-1411,-1415,-1842,-2703,-3479,-3619,-3043,-2177,-1555,-1400,-1555,-1715,-1650,-1266,-606,125,621,707,535,475,760,1264,1641,1650,1325,884,537,361,299,253,174,91,52,66,100,133,172,216,228,165,12,-215,-485,-753,-961,-1057,-1034,-935,-823,-752,-743,-783,-832,-842,-783,-662,-513,-375,-264,-175,-95,-20,45,97,136,155,146,113,74,41,5,-52,-126,-185,-195,-155,-102,-78,-104,-165,-231,-272,-273,-238,-184,-138,-119,-134,-173,-218,-250,-261,-254,-238,-223,-212,-204,-194,-171,-132,-83,-39,-11,-2,-8,-23,-42,-61,-81,-102,-117,-117,-99,-79,-74,-91,-122,-153,-169,-164,-141,-114,-99,-105,-126,-147,-157,-155,-146,-143,-154,-181,-211,-228,-226,-214,-203,-192,-173,-147,-120,-104,-105,-117,-135,-153,-167,-172,-164,-146,-117,-76,-28,14,37,41,28,0,-41,-84,-115,-128,-128,-121,-110,-101,-103,-117,-133,-144,-151,-158,-162,-163,-163,-160,-146,-121,-99,-91,-90,-85,-85,-104,-127,-115,-59},
            {12,-55,-37,53,51,-63,-79,64,104,-82,-155,89,182,-150,254,3031,7363,9169,4903,-3738,-10274,-9400,-2069,5638,8089,4351,-1869,-5256,-2473,5344,12844,14329,8772,1147,-1900,1935,8778,12370,9427,1819,-5506,-8441,-6461,-2546,-593,-2307,-6039,-8551,-8038,-5566,-3692,-3890,-5396,-6332,-5577,-3461,-1076,639,1224,761,-23,-40,1252,3177,4381,4128,2895,1689,1095,1068,1280,1335,871,-146,-1213,-1691,-1479,-1083,-987,-1190,-1440,-1645,-1847,-1967,-1873,-1643,-1504,-1499,-1416,-1111,-730,-503,-452,-413,-265,-20,271,576,837,956,904,772,695,733,841,916,863,649,325,2,-211,-272,-237,-227,-343,-575,-796,-875,-800,-677,-612,-625,-675,-719,-718,-631,-459,-276,-165,-126,-94,-28,56,139,224,301,322,261,169,134,186,277,332,300,166,-37,-215,-274,-211,-132,-146,-264,-401,-471,-446,-365,-301,-320,-421,-525,-536,-428,-263,-130,-77,-93,-122,-98,6,145,233,228,168,116,102,114,128,123,91,46,20,33,61,59,12,-55,-109,-138,-146,-137,-126,-135,-174,-227,-273,-309,-342,-371,-390,-402,-410,-402,-360,-284,-191,-104,-39,-5,-3,-19,-31,-31,-28,-36,-53,-73,-90,-105,-118,-129,-143,-166,-194,-216,-227,-230,-228,-220,-206,-192,-181,-165,-136,-99,-68,-52,-46,-40,-25,4,44,79,94,85,64,44,28,16,4,-9,-26,-41,-44,-31,-12,-1}
        },
        {    // H0e150a.wav
            {0,-3,-4,-2,0,-1,-3,-3,-2,-2,-2,-1,-2,-5,-4,1,1,-4,-3,4,5,-5,-7,5,10,-6,-16,1,16,-4,-25,0,34,9,-36,-3,63,36,90,752,2211,3624,3573,1524,-1357,-3120,-2764,-961,771,1336,649,-507,-922,378,3329,6514,7988,6803,3845,1121,134,819,1869,1979,870,-686,-1698,-1841,-1633,-1838,-2694,-3696,-4094,-3590,-2572,-1724,-1446,-1634,-1897,-1898,-1505,-781,41,632,781,606,486,714,1227,1687,1797,1521,1047,622,406,400,463,421,212,-69,-273,-326,-257,-139,-45,-31,-114,-251,-362,-409,-435,-511,-638,-730,-703,-569,-429,-372,-401,-461,-514,-551,-560,-516,-423,-334,-293,-290,-275,-224,-155,-98,-67,-72,-118,-191,-246,-244,-188,-113,-50,-9,10,6,-14,-37,-58,-90,-141,-187,-190,-144,-84,-53,-62,-94,-131,-163,-182,-182,-173,-178,-209,-247,-259,-229,-167,-103,-68,-76,-116,-155,-165,-144,-117,-113,-135,-161,-163,-135,-94,-65,-65,-89,-121,-141,-138,-114,-87,-77,-90,-113,-122,-106,-78,-62,-71,-100,-130,-150,-162,-171,-182,-193,-197,-189,-175,-162,-154,-155,-169,-195,-218,-224,-211,-185,-150,-109,-65,-24,12,42,55,42,4,-46,-93,-130,-151,-150,-132,-110,-94,-87,-89,-102,-124,-144,-158,-166,-170,-167,-156,-141,-125,-109,-96,-93,-102,-111,-110,-108,-115,-119,-96,-46},
            {11,30,-9,-50,-5,60,14,-80,-38,89,51,-121,-86,143,76,-134,948,4278,7869,7629,1847,-5807,-9156,-5595,1424,5991,5059,285,-4051,-4177,889,8462,13527,12464,6464,864,368,4771,9444,9763,4966,-1748,-6180,-6332,-3567,-1204,-1720,-4782,-7776,-8345,-6501,-4307,-3672,-4628,-5690,-5536,-4087,-2148,-496,497,731,405,171,784,2292,3765,4140,3270,1966,1099,916,1135,1338,1161,440,-580,-1330,-1456,-1180,-974,-999,-1083,-1138,-1293,-1582,-1790,-1763,-1645,-1642,-1678,-1507,-1101,-712,-549,-548,-507,-326,-35,301,624,857,937,880,777,728,772,872,940,880,654,320,-4,-209,-261,-228,-237,-373,-592,-755,-773,-689,-606,-575,-583,-609,-637,-621,-512,-334,-186,-132,-131,-101,-26,49,100,140,169,157,103,63,87,159,219,219,149,23,-117,-209,-214,-163,-145,-218,-351,-451,-448,-351,-239,-201,-266,-379,-447,-413,-299,-175,-102,-97,-132,-147,-91,29,146,192,164,118,102,110,113,87,29,-36,-68,-37,44,120,142,106,39,-32,-97,-147,-176,-195,-221,-257,-288,-305,-320,-344,-373,-392,-396,-385,-350,-286,-203,-128,-79,-57,-55,-60,-63,-58,-52,-55,-72,-97,-118,-129,-126,-113,-102,-106,-125,-149,-171,-190,-205,-211,-203,-187,-170,-151,-123,-86,-52,-32,-25,-24,-22,-16,-1,23,43,46,32,16,9,8,4,-7,-30,-57,-71,-59,-28}
        },
        {    // H0e155a.wav
            {-4,-3,-1,-1,-3,-2,0,0,-1,-1,-2,-4,-3,2,4,0,-2,3,5,-3,-7,5,12,-4,-18,-2,19,3,-26,-9,33,20,-31,-13,60,43,52,637,2134,3804,4094,2152,-1032,-3331,-3364,-1561,487,1412,881,-391,-1042,186,3411,7090,8903,7609,4174,983,-137,762,2126,2386,1155,-721,-2058,-2334,-1998,-1939,-2646,-3770,-4467,-4169,-3080,-1958,-1446,-1608,-2013,-2154,-1779,-953,11,704,867,626,431,661,1269,1844,2000,1680,1120,618,360,355,460,481,325,62,-162,-269,-293,-302,-333,-387,-458,-534,-599,-645,-678,-707,-722,-691,-585,-409,-208,-52,11,-15,-82,-140,-164,-162,-156,-168,-210,-266,-300,-286,-243,-222,-261,-360,-476,-550,-532,-418,-263,-150,-120,-143,-151,-104,-25,34,38,-6,-67,-116,-130,-98,-29,36,57,24,-38,-92,-118,-119,-116,-126,-153,-184,-200,-186,-149,-112,-99,-116,-147,-172,-186,-196,-216,-250,-288,-308,-283,-207,-106,-29,-15,-59,-121,-158,-157,-134,-107,-86,-75,-73,-75,-67,-46,-21,-10,-19,-41,-64,-84,-102,-125,-153,-181,-197,-194,-178,-162,-158,-172,-199,-226,-242,-240,-222,-190,-148,-100,-52,-10,17,23,1,-46,-103,-151,-176,-175,-153,-119,-84,-58,-49,-55,-72,-93,-117,-140,-158,-164,-158,-144,-129,-116,-107,-101,-100,-106,-117,-130,-137,-133,-120,-101,-77,-48,-19},
            {-12,-7,25,25,-26,-46,17,58,-16,-82,2,101,4,-137,-21,166,0,-9,1590,5027,7640,5942,-113,-6040,-7011,-2760,2431,4231,1931,-1873,-3861,-2008,3440,9725,12905,10901,5690,1813,2210,5600,8027,6659,2060,-2733,-4937,-4128,-2268,-1839,-3674,-6370,-7771,-7037,-5240,-4084,-4244,-4995,-5197,-4398,-2979,-1549,-450,214,439,439,711,1631,2913,3716,3466,2444,1451,1016,1063,1208,1123,674,-49,-733,-1067,-1045,-949,-975,-1028,-972,-902,-1004,-1252,-1461,-1581,-1724,-1895,-1889,-1572,-1106,-781,-688,-669,-547,-291,36,364,634,791,824,793,778,822,910,985,973,824,553,246,14,-87,-94,-111,-231,-445,-642,-712,-657,-570,-528,-528,-534,-536,-531,-488,-381,-241,-140,-103,-93,-79,-70,-78,-79,-52,-20,-23,-56,-66,-23,50,113,138,111,31,-64,-108,-77,-37,-77,-216,-380,-470,-441,-326,-201,-141,-167,-236,-277,-259,-210,-173,-164,-173,-180,-153,-71,42,121,119,58,4,-6,18,47,68,76,73,71,83,104,109,81,29,-27,-74,-111,-139,-164,-194,-231,-266,-291,-308,-321,-322,-309,-297,-300,-313,-312,-288,-251,-211,-167,-122,-89,-75,-69,-58,-47,-51,-72,-98,-114,-116,-108,-95,-86,-88,-101,-120,-139,-155,-165,-168,-164,-151,-129,-102,-76,-55,-36,-22,-16,-19,-20,-11,1,6,3,-3,-11,-19,-23,-18,-13,-19,-34,-38,-22}
        },
        {    // H0e160a.wav
            {-2,-3,-3,-1,0,-1,-3,-2,-2,-4,-5,0,3,0,-1,5,7,-2,-8,4,14,-1,-19,-5,19,6,-27,-13,34,26,-32,-21,63,56,30,553,2077,3956,4537,2713,-693,-3446,-3864,-2146,126,1395,1085,-231,-1107,3,3465,7653,9851,8471,4533,830,-442,686,2386,2803,1455,-719,-2365,-2806,-2425,-2176,-2708,-3823,-4694,-4611,-3586,-2311,-1558,-1594,-2067,-2360,-2044,-1118,21,829,992,675,405,613,1256,1899,2133,1875,1326,762,389,287,372,436,313,22,-254,-358,-297,-202,-204,-351,-588,-798,-885,-863,-852,-948,-1099,-1139,-947,-562,-140,172,314,310,224,130,94,139,221,258,197,63,-72,-161,-217,-277,-357,-436,-490,-513,-518,-521,-525,-515,-474,-393,-284,-172,-84,-44,-67,-140,-215,-232,-160,-27,102,168,155,92,21,-25,-38,-31,-29,-47,-83,-123,-150,-151,-119,-65,-21,-21,-71,-145,-207,-247,-280,-323,-369,-392,-370,-302,-210,-129,-90,-101,-143,-182,-189,-158,-108,-70,-63,-76,-80,-56,-11,31,54,56,37,1,-44,-85,-119,-149,-170,-170,-146,-114,-97,-101,-120,-150,-190,-229,-252,-248,-222,-184,-142,-100,-65,-47,-54,-82,-127,-179,-223,-243,-231,-190,-132,-73,-30,-11,-11,-23,-45,-76,-109,-133,-142,-140,-128,-110,-91,-83,-88,-102,-118,-134,-149,-156,-153,-141,-122,-93,-53,-12,12,12},
            {15,2,-20,-6,31,19,-37,-37,33,46,-42,-73,35,92,-41,-129,39,159,-56,155,2069,5306,7034,4635,-871,-5204,-5114,-1582,1662,2065,79,-2138,-2587,-229,4578,9685,12064,10260,6022,2880,2866,4827,5914,4399,1003,-2114,-3388,-3038,-2569,-3241,-4942,-6467,-6781,-5956,-4925,-4482,-4611,-4704,-4276,-3386,-2406,-1533,-698,104,668,917,1178,1834,2733,3239,2956,2177,1493,1165,1044,922,710,361,-133,-625,-895,-906,-840,-833,-842,-813,-826,-952,-1111,-1218,-1352,-1628,-1944,-2028,-1760,-1321,-967,-766,-610,-406,-156,97,320,490,600,675,748,830,915,993,1037,989,806,522,241,54,-23,-47,-99,-227,-407,-559,-606,-549,-462,-414,-416,-441,-464,-466,-430,-355,-272,-218,-195,-177,-156,-150,-172,-207,-228,-227,-214,-194,-158,-101,-20,73,147,162,110,38,2,9,8,-50,-164,-286,-361,-360,-292,-205,-159,-168,-193,-187,-153,-131,-145,-187,-239,-279,-276,-204,-83,23,69,69,66,78,90,86,68,48,37,39,51,62,57,33,-1,-36,-71,-104,-128,-148,-173,-204,-225,-234,-238,-246,-256,-267,-288,-324,-361,-376,-360,-321,-273,-218,-160,-106,-66,-38,-21,-20,-41,-77,-108,-122,-118,-105,-91,-79,-70,-65,-66,-77,-100,-127,-145,-148,-138,-119,-94,-63,-34,-13,-1,2,-5,-23,-44,-55,-51,-44,-45,-50,-45,-30,-19,-21,-23,-14}
        },
        {    // H0e165a.wav
            {-4,-1,2,1,-3,-3,-1,-3,-4,0,3,-1,-4,2,7,-2,-9,2,14,0,-22,-11,17,8,-27,-19,30,28,-32,-29,60,64,19,495,2033,4074,4908,3215,-346,-3474,-4252,-2667,-263,1287,1214,-65,-1103,-143,3449,8086,10731,9394,5022,760,-762,544,2602,3225,1787,-682,-2635,-3242,-2836,-2437,-2829,-3932,-4931,-5009,-4038,-2650,-1695,-1590,-2086,-2530,-2344,-1388,-54,982,1240,839,408,530,1222,1979,2282,2014,1424,841,470,357,408,431,271,-53,-359,-480,-410,-286,-247,-341,-529,-744,-936,-1090,-1204,-1268,-1255,-1137,-929,-675,-421,-190,7,162,274,352,408,450,474,464,410,319,215,127,74,53,28,-52,-218,-440,-637,-732,-714,-635,-554,-488,-427,-371,-335,-325,-329,-335,-333,-308,-242,-137,-26,55,95,106,96,71,49,53,77,83,38,-39,-92,-82,-21,47,78,52,-26,-125,-204,-242,-258,-290,-349,-407,-421,-373,-286,-207,-178,-206,-260,-290,-266,-199,-127,-83,-70,-68,-51,-9,42,78,84,62,27,-11,-46,-77,-103,-121,-129,-121,-96,-59,-23,-5,-19,-65,-127,-184,-221,-238,-240,-227,-202,-174,-152,-140,-134,-139,-165,-214,-270,-305,-303,-263,-196,-118,-47,-1,13,4,-13,-34,-59,-86,-104,-105,-93,-78,-68,-66,-73,-88,-108,-128,-144,-157,-164,-161,-145,-116,-78,-38,-3,18,21,11},
            {-7,6,16,-3,-22,1,32,8,-41,-24,38,26,-54,-51,56,70,-67,-101,76,121,-83,323,2342,5236,6387,3930,-770,-4163,-4103,-1720,327,618,-369,-1409,-1381,599,4632,9189,11637,10426,6712,3383,2409,3320,4126,3371,1228,-1068,-2521,-3110,-3486,-4169,-5084,-5769,-5900,-5568,-5111,-4765,-4471,-4028,-3390,-2750,-2255,-1728,-881,209,1067,1384,1432,1698,2226,2595,2515,2150,1789,1462,1060,634,338,156,-85,-440,-757,-888,-845,-726,-605,-556,-664,-921,-1188,-1346,-1432,-1553,-1702,-1762,-1667,-1468,-1233,-953,-603,-232,50,183,216,258,381,569,752,885,975,1033,1029,922,721,493,299,157,54,-29,-112,-214,-324,-400,-413,-378,-335,-310,-315,-366,-463,-559,-586,-519,-410,-327,-288,-274,-279,-305,-328,-312,-259,-214,-210,-227,-215,-147,-32,100,207,246,207,134,85,69,35,-55,-176,-265,-282,-232,-156,-104,-109,-166,-239,-287,-292,-267,-235,-218,-228,-250,-244,-183,-85,3,55,80,94,92,65,23,-16,-45,-61,-53,-18,31,69,84,75,44,-3,-53,-94,-123,-149,-176,-197,-212,-228,-248,-268,-287,-315,-355,-390,-404,-394,-363,-310,-236,-158,-98,-63,-43,-31,-33,-51,-77,-98,-108,-104,-88,-63,-38,-22,-20,-35,-64,-97,-121,-133,-135,-128,-107,-74,-39,-12,3,5,-8,-34,-65,-87,-96,-94,-87,-76,-64,-54,-44,-31,-15}
        },
        {    // H0e170a.wav
            {1,0,-1,-1,-2,-5,-5,1,4,-1,-5,2,7,-1,-8,4,16,0,-23,-12,18,9,-28,-21,30,30,-35,-37,56,67,15,475,2041,4199,5197,3589,-73,-3462,-4512,-3066,-618,1113,1244,61,-1042,-196,3455,8421,11471,10263,5594,837,-986,392,2739,3573,2102,-605,-2853,-3662,-3279,-2739,-2952,-3997,-5120,-5405,-4545,-3072,-1892,-1586,-2034,-2586,-2546,-1639,-207,1007,1406,1029,519,543,1203,2019,2421,2210,1590,913,452,305,376,441,311,-14,-359,-542,-510,-361,-271,-389,-726,-1106,-1295,-1223,-1055,-1006,-1107,-1199,-1130,-904,-624,-363,-136,41,145,194,256,369,490,539,494,423,415,499,613,651,535,273,-51,-326,-485,-532,-523,-521,-554,-606,-639,-626,-569,-497,-453,-466,-523,-562,-517,-376,-194,-47,30,51,48,42,39,44,56,68,73,70,72,91,129,168,179,140,58,-38,-121,-184,-240,-302,-370,-426,-442,-398,-306,-215,-176,-209,-285,-350,-363,-315,-232,-152,-103,-83,-62,-16,46,91,90,48,-6,-48,-69,-74,-68,-58,-49,-40,-26,-3,23,39,32,1,-46,-96,-143,-187,-226,-255,-267,-261,-242,-215,-192,-188,-214,-264,-318,-351,-348,-305,-229,-142,-69,-23,-6,-9,-19,-30,-41,-54,-65,-66,-57,-43,-31,-26,-34,-59,-93,-121,-136,-143,-147,-146,-138,-125,-106,-75,-35,-5,-4,-25,-38,-25},
            {6,-3,-8,6,14,-3,-15,7,28,0,-37,-13,36,14,-50,-31,56,45,-70,-67,85,81,-72,447,2401,4981,5919,3755,-318,-3461,-3944,-2435,-718,111,7,-561,-752,630,4207,8792,11701,10959,7207,3191,1327,1847,3100,3297,1896,-377,-2434,-3664,-4149,-4338,-4609,-5034,-5428,-5560,-5331,-4783,-4029,-3246,-2676,-2459,-2382,-1940,-853,504,1413,1573,1386,1424,1795,2167,2264,2111,1839,1502,1128,773,446,87,-293,-567,-660,-662,-684,-687,-592,-483,-559,-868,-1228,-1452,-1540,-1587,-1603,-1530,-1375,-1221,-1106,-963,-718,-388,-69,155,270,330,404,527,673,789,848,868,871,843,751,591,405,249,144,69,-15,-121,-226,-296,-316,-307,-298,-310,-355,-443,-568,-688,-740,-693,-575,-450,-368,-343,-361,-392,-400,-359,-275,-186,-126,-95,-64,-7,78,171,241,262,230,170,116,81,43,-28,-136,-244,-302,-287,-220,-149,-115,-127,-173,-238,-300,-330,-316,-281,-257,-244,-210,-137,-50,12,37,35,14,-27,-73,-93,-77,-46,-21,1,34,75,107,121,121,106,68,8,-59,-117,-162,-198,-229,-253,-266,-268,-268,-278,-303,-341,-384,-419,-431,-404,-337,-247,-159,-90,-46,-27,-30,-47,-67,-79,-82,-77,-64,-45,-24,-7,-2,-11,-31,-57,-83,-102,-112,-111,-103,-90,-73,-50,-26,-10,-11,-29,-59,-93,-120,-129,-117,-99,-88,-80,-61,-28}
        },
        {    // H0e175a.wav
            {-1,-1,-2,-5,-5,1,5,0,-4,2,6,-2,-8,5,17,0,-24,-11,20,11,-27,-21,30,28,-38,-39,55,64,9,484,2095,4326,5397,3826,132,-3376,-4604,-3319,-925,889,1185,137,-946,-162,3481,8610,11949,10949,6224,1171,-961,315,2780,3781,2349,-488,-2958,-3975,-3703,-3131,-3188,-4071,-5175,-5627,-4991,-3600,-2281,-1724,-2001,-2552,-2617,-1793,-343,977,1502,1197,664,592,1162,1976,2480,2404,1847,1107,499,223,262,380,319,29,-309,-501,-526,-509,-559,-690,-857,-1014,-1127,-1188,-1226,-1275,-1316,-1276,-1106,-848,-597,-404,-247,-98,24,86,100,121,186,292,430,605,796,929,927,789,590,406,250,102,-36,-147,-242,-359,-505,-626,-662,-617,-558,-546,-596,-684,-772,-809,-749,-592,-391,-216,-102,-44,-25,-32,-42,-30,8,51,75,80,89,125,190,263,305,281,190,69,-35,-109,-175,-258,-350,-417,-430,-381,-290,-200,-162,-198,-280,-348,-361,-321,-261,-213,-188,-178,-159,-109,-32,37,64,42,-7,-47,-63,-56,-37,-18,-3,11,31,59,86,101,95,64,7,-64,-129,-179,-216,-246,-266,-271,-262,-249,-242,-249,-275,-319,-365,-392,-384,-336,-257,-167,-90,-39,-16,-13,-22,-38,-51,-56,-54,-51,-44,-26,-3,9,1,-20,-45,-75,-110,-139,-151,-148,-139,-125,-101,-74,-53,-38,-26,-30,-61,-99,-100,-54},
            {-7,0,4,-2,-4,7,11,-4,-12,7,21,-3,-30,-9,27,6,-42,-21,46,30,-59,-46,75,59,-40,506,2331,4710,5659,3814,42,-3223,-4203,-3055,-1157,239,572,-35,-641,324,3805,8667,11972,11341,7198,2503,193,873,2770,3595,2361,-228,-2719,-4089,-4295,-4020,-4007,-4520,-5256,-5670,-5408,-4519,-3395,-2537,-2264,-2459,-2563,-1977,-639,809,1578,1489,1099,1064,1505,2036,2279,2162,1820,1386,965,662,495,338,41,-384,-753,-892,-784,-557,-388,-407,-636,-970,-1254,-1407,-1471,-1521,-1557,-1504,-1319,-1051,-799,-618,-491,-375,-247,-97,92,316,524,636,623,559,558,662,801,876,845,727,554,360,192,87,28,-49,-183,-332,-421,-423,-385,-376,-434,-555,-705,-826,-860,-787,-652,-523,-439,-391,-354,-317,-276,-227,-168,-113,-71,-32,34,138,257,345,363,306,202,97,24,-17,-55,-119,-208,-291,-328,-299,-217,-132,-88,-100,-153,-221,-278,-309,-316,-314,-318,-316,-280,-198,-97,-17,22,26,6,-27,-59,-71,-59,-37,-17,8,48,98,140,163,162,134,78,5,-71,-139,-195,-238,-264,-271,-265,-257,-259,-278,-317,-368,-412,-434,-425,-384,-313,-225,-143,-84,-50,-33,-30,-42,-62,-75,-76,-67,-53,-32,-8,12,21,15,-5,-36,-71,-101,-120,-129,-127,-112,-88,-64,-47,-35,-30,-44,-77,-111,-126,-123,-118,-112,-87,-42}
        },
        {    // H0e180a.wav
            {-2,-6,-5,2,4,-2,-5,3,7,-4,-10,5,17,-2,-26,-11,20,7,-32,-19,35,25,-47,-40,61,57,-9,504,2201,4488,5529,3893,193,-3265,-4502,-3360,-1158,583,993,150,-790,1,3571,8674,12126,11351,6810,1745,-603,414,2757,3808,2478,-350,-2947,-4164,-4063,-3551,-3531,-4246,-5219,-5706,-5274,-4094,-2799,-2046,-2071,-2508,-2630,-1900,-455,950,1571,1333,846,783,1285,1966,2370,2318,1898,1305,744,388,291,323,266,1,-401,-747,-869,-743,-519,-430,-607,-959,-1259,-1370,-1358,-1368,-1433,-1447,-1302,-1006,-662,-368,-168,-75,-84,-150,-173,-51,223,530,718,735,668,644,709,802,834,760,593,373,149,-33,-154,-232,-298,-368,-432,-482,-521,-563,-623,-710,-815,-891,-876,-748,-560,-397,-307,-276,-258,-219,-149,-63,9,43,40,34,62,135,235,329,376,340,223,73,-47,-109,-141,-184,-249,-310,-333,-308,-247,-179,-136,-146,-208,-289,-341,-338,-301,-270,-266,-276,-265,-213,-124,-23,53,77,48,-8,-53,-71,-68,-55,-32,8,61,114,155,176,167,118,37,-52,-124,-174,-209,-236,-253,-262,-267,-271,-275,-286,-309,-346,-388,-415,-408,-362,-288,-202,-121,-61,-32,-29,-36,-43,-50,-60,-67,-60,-40,-18,2,19,27,16,-15,-53,-86,-113,-135,-146,-142,-128,-109,-82,-49,-25,-26,-48,-75,-101,-125,-135,-109,-52},
            {-2,-6,-5,2,4,-2,-5,3,7,-4,-10,5,17,-2,-26,-11,20,7,-32,-19,35,25,-47,-40,61,57,-9,504,2201,4488,5529,3893,193,-3265,-4502,-3360,-1158,583,993,150,-790,1,3571,8674,12126,11351,6810,1745,-603,414,2757,3808,2478,-350,-2947,-4164,-4063,-3551,-3531,-4246,-5219,-5706,-5274,-4094,-2799,-2046,-2071,-2508,-2630,-1900,-455,950,1571,1333,846,783,1285,1966,2370,2318,1898,1305,744,388,291,323,266,1,-401,-747,-869,-743,-519,-430,-607,-959,-1259,-1370,-1358,-1368,-1433,-1447,-1302,-1006,-662,-368,-168,-75,-84,-150,-173,-51,223,530,718,735,668,644,709,802,834,760,593,373,149,-33,-154,-232,-298,-368,-432,-482,-521,-563,-623,-710,-815,-891,-876,-748,-560,-397,-307,-276,-258,-219,-149,-63,9,43,40,34,62,135,235,329,376,340,223,73,-47,-109,-141,-184,-249,-310,-333,-308,-247,-179,-136,-146,-208,-289,-341,-338,-301,-270,-266,-276,-265,-213,-124,-23,53,77,48,-8,-53,-71,-68,-55,-32,8,61,114,155,176,167,118,37,-52,-124,-174,-209,-236,-253,-262,-267,-271,-275,-286,-309,-346,-388,-415,-408,-362,-288,-202,-121,-61,-32,-29,-36,-43,-50,-60,-67,-60,-40,-18,2,19,27,16,-15,-53,-86,-113,-135,-146,-142,-128,-109,-82,-49,-25,-26,-48,-75,-101,-125,-135,-109,-52}
        }
    },
    {    // elev10
        {    // H10e000a.wav
            {6,6,-8,-6,18,20,-15,-23,23,40,-24,-61,15,79,-5,-104,-14,125,31,-152,-45,184,43,77,1893,5611,8093,5748,-533,-5217,-4298,-321,771,-2674,-5849,-3690,2702,7529,7244,4179,3216,6361,11164,13419,10649,3779,-3425,-6737,-4565,517,3608,1486,-4779,-10953,-13159,-10597,-5600,-1638,-943,-3155,-5739,-6023,-3421,143,2119,1694,274,-208,863,2571,3644,3522,2536,1482,1100,1590,2447,2863,2429,1417,420,-135,-141,249,653,613,-14,-840,-1278,-1125,-689,-423,-577,-1152,-1967,-2667,-2862,-2424,-1619,-874,-428,-265,-253,-284,-305,-324,-386,-483,-505,-358,-82,174,301,286,164,-7,-131,-118,19,176,257,238,133,-36,-200,-252,-164,-53,-70,-242,-453,-580,-599,-575,-580,-626,-652,-573,-369,-125,25,14,-105,-213,-224,-136,-20,39,6,-74,-117,-71,37,131,145,63,-73,-198,-268,-282,-266,-240,-210,-181,-168,-175,-184,-174,-147,-132,-149,-189,-223,-226,-189,-125,-59,-15,-3,-9,-13,-6,2,-9,-47,-98,-137,-141,-99,-29,28,34,-12,-66,-88,-81,-84,-127,-197,-263,-296,-289,-261,-237,-227,-219,-193,-151,-117,-115,-139,-161,-151,-100,-19,65,127,162,176,171,137,70,-10,-73,-106,-119,-123,-129,-139,-146,-142,-125,-115,-135,-186,-234,-242,-206,-151,-106,-80,-61,-40,-20,-18,-45,-93,-139,-160,-147,-113,-81,-67,-64,-52,-26},
            {6,6,-8,-6,18,20,-15,-23,23,40,-24,-61,15,79,-5,-104,-14,125,31,-152,-45,184,43,77,1893,5611,8093,5748,-533,-5217,-4298,-321,771,-2674,-5849,-3690,2702,7529,7244,4179,3216,6361,11164,13419,10649,3779,-3425,-6737,-4565,517,3608,1486,-4779,-10953,-13159,-10597,-5600,-1638,-943,-3155,-5739,-6023,-3421,143,2119,1694,274,-208,863,2571,3644,3522,2536,1482,1100,1590,2447,2863,2429,1417,420,-135,-141,249,653,613,-14,-840,-1278,-1125,-689,-423,-577,-1152,-1967,-2667,-2862,-2424,-1619,-874,-428,-265,-253,-284,-305,-324,-386,-483,-505,-358,-82,174,301,286,164,-7,-131,-118,19,176,257,238,133,-36,-200,-252,-164,-53,-70,-242,-453,-580,-599,-575,-580,-626,-652,-573,-369,-125,25,14,-105,-213,-224,-136,-20,39,6,-74,-117,-71,37,131,145,63,-73,-198,-268,-282,-266,-240,-210,-181,-168,-175,-184,-174,-147,-132,-149,-189,-223,-226,-189,-125,-59,-15,-3,-9,-13,-6,2,-9,-47,-98,-137,-141,-99,-29,28,34,-12,-66,-88,-81,-84,-127,-197,-263,-296,-289,-261,-237,-227,-219,-193,-151,-117,-115,-139,-161,-151,-100,-19,65,127,162,176,171,137,70,-10,-73,-106,-119,-123,-129,-139,-146,-142,-125,-115,-135,-186,-234,-242,-206,-151,-106,-80,-61,-40,-20,-18,-45,-93,-139,-160,-147,-113,-81,-67,-64,-52,-26}
        },
        {    // H10e005a.wav
            {-4,-4,6,5,-8,-6,15,17,-12,-18,20,30,-23,-48,17,63,-13,-89,-8,102,18,-125,-25,149,26,156,1886,5152,7153,4926,-522,-4374,-3410,-63,591,-2589,-5271,-3201,2419,6507,6189,3690,3196,6183,10330,12064,9502,3618,-2411,-5163,-3422,610,2861,755,-4651,-9737,-11375,-9125,-5067,-2002,-1565,-3314,-5190,-5146,-2850,63,1564,1134,41,-153,903,2317,3058,2829,2055,1397,1309,1788,2372,2492,1948,1048,282,-49,72,457,769,676,126,-539,-895,-839,-615,-508,-641,-1023,-1595,-2160,-2416,-2183,-1593,-991,-650,-608,-689,-671,-465,-189,-46,-98,-203,-189,-39,142,277,349,339,232,70,-65,-147,-208,-259,-264,-225,-211,-256,-302,-285,-242,-270,-389,-509,-539,-485,-432,-442,-498,-520,-438,-264,-79,22,4,-90,-181,-200,-129,-16,58,48,-15,-62,-54,-5,47,73,53,-19,-117,-193,-224,-230,-244,-264,-266,-242,-212,-195,-185,-170,-155,-160,-187,-210,-200,-152,-89,-35,-3,8,8,10,20,30,18,-34,-111,-169,-170,-113,-36,12,6,-41,-91,-115,-114,-115,-140,-189,-238,-261,-247,-212,-191,-204,-233,-242,-219,-184,-163,-157,-149,-129,-90,-33,35,100,151,181,186,159,99,23,-42,-81,-98,-105,-110,-120,-132,-136,-127,-123,-144,-186,-217,-213,-181,-145,-118,-100,-85,-67,-43,-26,-41,-90,-142,-162,-148,-125,-104,-75,-35},
            {2,-11,6,27,0,-35,-1,51,13,-69,-35,76,50,-99,-89,108,129,-118,-171,133,187,-90,885,4445,8470,8282,2310,-4645,-6235,-2297,865,-1327,-5705,-5554,629,7275,8695,5526,3180,5384,10658,14403,13047,6482,-1949,-7417,-6863,-1621,3256,3085,-2543,-9723,-13764,-12700,-8048,-3153,-890,-2030,-4850,-6398,-4896,-1306,1639,2124,840,-113,511,2185,3596,3933,3244,2104,1259,1259,2028,2828,2905,2165,1123,325,-2,113,457,614,221,-619,-1329,-1431,-1039,-688,-797,-1372,-2127,-2713,-2879,-2579,-1973,-1290,-686,-224,60,154,93,-99,-415,-772,-961,-814,-408,-12,163,99,-106,-318,-366,-128,308,668,748,593,380,203,64,-8,27,118,124,-34,-283,-489,-590,-618,-645,-708,-769,-739,-559,-289,-75,-22,-105,-210,-243,-187,-98,-55,-93,-168,-196,-132,-8,104,150,112,-1,-146,-253,-282,-254,-217,-190,-158,-120,-98,-101,-108,-102,-95,-116,-170,-234,-272,-261,-204,-128,-67,-42,-43,-44,-27,-3,3,-30,-102,-180,-214,-171,-68,33,75,51,0,-33,-45,-68,-123,-206,-284,-322,-302,-241,-182,-160,-170,-173,-146,-108,-95,-115,-142,-145,-109,-43,35,107,158,180,171,132,65,-17,-91,-138,-154,-150,-144,-149,-159,-156,-137,-123,-141,-193,-247,-266,-239,-186,-136,-99,-70,-34,9,41,32,-28,-110,-167,-171,-135,-94,-72,-63,-46,-16,9,12}
        },
        {    // H10e010a.wav
            {-3,0,-2,0,6,1,-9,-2,17,12,-14,-11,21,20,-25,-32,28,47,-30,-73,17,88,-10,-103,19,130,0,300,2130,5021,6298,3799,-937,-3705,-2466,104,32,-2783,-4443,-2082,2569,5463,5026,3486,3833,6580,9630,10425,7871,2962,-1763,-3742,-2309,561,1755,-363,-4671,-8432,-9525,-7779,-4726,-2387,-1980,-3178,-4402,-4133,-2245,-68,969,684,96,205,1063,1984,2375,2193,1788,1534,1593,1849,2004,1826,1348,807,417,261,342,589,783,658,173,-390,-699,-695,-582,-575,-749,-1080,-1485,-1814,-1902,-1713,-1381,-1090,-927,-854,-768,-578,-278,11,131,50,-99,-162,-101,20,139,231,271,229,108,-63,-255,-434,-538,-525,-438,-371,-361,-364,-343,-331,-379,-467,-512,-466,-367,-294,-300,-368,-426,-397,-267,-101,6,10,-58,-124,-133,-85,-19,19,12,-19,-36,-19,24,70,90,66,1,-77,-141,-190,-237,-280,-301,-290,-264,-244,-231,-210,-178,-155,-159,-183,-200,-186,-139,-75,-17,15,19,9,5,12,18,7,-31,-90,-148,-173,-147,-87,-38,-32,-58,-84,-93,-98,-117,-156,-204,-241,-247,-219,-182,-170,-194,-232,-248,-232,-202,-177,-163,-147,-116,-66,-5,54,101,135,155,156,132,86,32,-17,-56,-84,-106,-126,-145,-152,-140,-117,-107,-126,-161,-190,-195,-173,-141,-115,-101,-86,-62,-38,-34,-60,-103,-145,-170,-165,-122,-55},
            {-4,32,21,-33,-26,47,46,-54,-72,53,95,-61,-141,51,192,-30,-236,24,276,-37,269,3256,8096,9984,5253,-3000,-7280,-4529,-20,-457,-5086,-6732,-1362,6593,9827,6912,3325,4576,10358,15525,15223,8625,-839,-7799,-8421,-3306,2585,3752,-1276,-8931,-13957,-13648,-9242,-4168,-1441,-2029,-4563,-6331,-5315,-1952,1209,2001,736,-384,237,2146,3770,4143,3447,2380,1565,1402,1921,2640,2885,2412,1576,873,514,464,585,625,293,-419,-1129,-1445,-1389,-1301,-1411,-1700,-2073,-2470,-2765,-2753,-2338,-1639,-896,-297,80,250,276,170,-121,-583,-1012,-1147,-945,-621,-398,-310,-274,-227,-116,123,460,733,802,711,602,517,402,275,239,309,338,182,-119,-395,-535,-571,-602,-685,-788,-815,-688,-434,-188,-81,-132,-248,-312,-275,-180,-114,-134,-218,-284,-266,-160,-15,103,138,68,-65,-176,-211,-190,-169,-162,-140,-86,-26,7,14,7,-14,-69,-160,-256,-317,-326,-294,-239,-176,-115,-64,-29,-4,14,8,-43,-134,-223,-259,-218,-115,3,84,96,47,-18,-64,-94,-132,-191,-251,-278,-255,-191,-125,-94,-105,-121,-108,-75,-60,-85,-131,-155,-132,-67,17,90,134,151,153,134,80,-7,-96,-155,-178,-177,-170,-168,-171,-169,-150,-126,-132,-185,-258,-300,-286,-234,-177,-132,-92,-43,19,76,92,48,-33,-104,-132,-121,-96,-79,-73,-66,-44,-5,30,38,19}
        },
        {    // H10e015a.wav
            {-1,-4,-2,-1,-3,0,5,0,-8,1,16,7,-13,-7,20,15,-23,-22,26,31,-34,-54,28,70,-22,-77,39,101,-11,381,2145,4657,5541,3162,-909,-3134,-2047,-12,-176,-2436,-3641,-1644,2119,4560,4531,3677,4137,6250,8498,9011,6940,2983,-927,-2779,-1975,67,1003,-518,-3847,-7013,-8265,-7171,-4708,-2522,-1835,-2618,-3660,-3626,-2241,-450,596,630,298,312,785,1367,1757,1910,1892,1754,1563,1425,1389,1391,1316,1100,776,476,371,510,710,676,304,-202,-542,-617,-575,-620,-838,-1173,-1471,-1572,-1432,-1184,-1033,-1049,-1104,-1015,-720,-316,14,124,-2,-232,-383,-365,-230,-81,23,78,84,43,-31,-125,-244,-378,-479,-505,-473,-441,-430,-413,-379,-361,-385,-425,-427,-375,-306,-272,-298,-360,-400,-359,-232,-82,7,2,-60,-110,-102,-43,12,20,-16,-52,-47,0,57,93,93,55,-12,-83,-140,-185,-229,-268,-282,-267,-239,-219,-207,-190,-168,-156,-164,-183,-193,-179,-141,-91,-45,-16,-7,-12,-18,-13,-2,-7,-44,-101,-149,-161,-137,-95,-58,-42,-47,-61,-75,-91,-117,-158,-205,-237,-241,-223,-198,-185,-187,-192,-183,-163,-148,-149,-153,-144,-115,-71,-15,43,89,112,117,111,92,54,6,-34,-58,-74,-93,-115,-133,-137,-124,-103,-96,-118,-156,-180,-175,-153,-129,-109,-94,-89,-88,-75,-55,-55,-96,-143,-137,-70},
            {38,-20,-50,22,73,-16,-101,-3,122,15,-164,-55,200,106,-230,-149,273,155,-136,1713,6628,10835,8823,554,-6907,-7194,-2431,-258,-3607,-6914,-3810,4267,9867,8781,4665,4089,9067,15445,17335,12097,2058,-7135,-10209,-6117,818,4163,692,-7129,-13703,-15054,-11330,-5714,-1748,-1285,-3691,-6328,-6395,-3290,700,2528,1421,-509,-703,1238,3593,4615,4025,2699,1621,1339,1859,2658,2995,2551,1708,1076,877,923,1003,987,696,-21,-1007,-1817,-2114,-1931,-1577,-1402,-1640,-2264,-2919,-3146,-2761,-1982,-1168,-531,-117,111,235,308,238,-145,-808,-1424,-1661,-1483,-1075,-584,-86,293,441,424,433,538,634,650,655,697,692,573,434,400,420,325,63,-229,-402,-455,-498,-613,-773,-862,-777,-525,-244,-102,-154,-308,-421,-410,-297,-181,-161,-257,-381,-413,-309,-127,36,118,104,15,-95,-164,-170,-145,-125,-103,-53,24,90,115,106,76,17,-88,-229,-360,-428,-415,-339,-236,-143,-78,-41,-22,-13,-24,-73,-156,-246,-303,-291,-203,-72,37,67,23,-37,-61,-59,-76,-132,-202,-242,-225,-159,-79,-29,-31,-60,-74,-60,-47,-64,-107,-145,-150,-110,-35,46,107,139,149,134,79,-15,-116,-187,-217,-217,-202,-184,-175,-174,-163,-139,-132,-173,-251,-315,-326,-287,-227,-169,-117,-64,-1,67,108,90,20,-56,-102,-110,-92,-70,-59,-61,-54,-23,15,22,-8,-36,-28}
        },
        {    // H10e020a.wav
            {0,2,-1,-3,-1,-1,-2,1,4,0,-5,3,14,5,-11,-4,18,11,-20,-18,22,26,-27,-41,25,55,-20,-58,39,79,-6,390,1985,4189,4943,2855,-720,-2729,-1855,-61,-86,-1989,-3157,-1619,1633,4018,4339,3731,3973,5558,7424,8032,6508,3226,-300,-2282,-1952,-255,832,-124,-2920,-5960,-7489,-6771,-4499,-2268,-1445,-2175,-3326,-3518,-2344,-619,521,658,259,23,272,888,1562,1982,1959,1565,1140,1023,1244,1521,1549,1250,782,409,344,587,868,838,399,-189,-573,-652,-606,-646,-815,-1011,-1123,-1113,-1029,-968,-992,-1058,-1047,-877,-583,-289,-128,-165,-360,-577,-672,-597,-421,-241,-112,-48,-49,-91,-127,-125,-109,-128,-197,-293,-388,-466,-498,-456,-363,-293,-303,-371,-422,-414,-368,-333,-330,-338,-315,-243,-143,-62,-33,-51,-83,-93,-66,-24,2,-10,-52,-90,-93,-54,6,60,82,63,11,-50,-101,-140,-175,-201,-208,-196,-183,-184,-193,-192,-178,-165,-167,-182,-198,-201,-186,-152,-109,-70,-47,-36,-29,-20,-16,-25,-51,-92,-134,-156,-141,-95,-50,-33,-45,-67,-83,-92,-106,-133,-171,-209,-229,-221,-194,-167,-151,-139,-125,-112,-109,-119,-133,-141,-133,-103,-53,4,53,84,94,82,51,12,-24,-53,-69,-73,-75,-88,-110,-124,-119,-104,-99,-111,-133,-153,-159,-145,-120,-105,-109,-113,-93,-62,-54,-72,-77,-45},
            {-39,-4,66,28,-88,-68,91,95,-112,-157,109,220,-98,-284,99,331,-120,421,4251,9862,11484,5519,-3825,-8403,-5760,-1787,-2464,-5845,-5192,1395,8182,9261,5850,4291,8243,14877,18250,14814,5788,-4085,-9548,-8167,-2285,2450,1564,-4598,-11587,-14925,-13346,-8737,-4055,-1582,-2085,-4431,-6058,-4892,-1391,1708,2175,590,-532,385,2544,4112,4193,3235,2124,1490,1609,2319,2966,2893,2111,1276,947,1105,1398,1524,1239,353,-990,-2176,-2556,-2069,-1303,-953,-1293,-2089,-2863,-3228,-3090,-2591,-1905,-1142,-432,53,255,287,223,-69,-726,-1561,-2127,-2096,-1482,-537,402,972,971,576,246,271,526,724,786,808,802,681,460,300,289,317,234,32,-179,-319,-406,-501,-637,-778,-815,-659,-351,-79,-27,-203,-440,-550,-481,-334,-251,-292,-395,-454,-409,-270,-85,87,176,135,-3,-141,-201,-184,-135,-78,-8,71,135,171,181,158,82,-50,-209,-338,-397,-379,-312,-235,-173,-134,-109,-84,-54,-31,-48,-133,-267,-381,-413,-347,-222,-97,-12,20,16,6,2,-11,-55,-123,-180,-187,-132,-44,25,36,-2,-44,-55,-43,-44,-73,-116,-147,-144,-97,-14,72,128,149,140,95,3,-112,-199,-232,-230,-224,-221,-213,-201,-184,-158,-130,-134,-192,-276,-328,-320,-271,-213,-156,-90,-11,70,126,129,69,-26,-104,-134,-123,-95,-64,-38,-20,-7,10,24,11,-32,-76,-79,-41}
        },
        {    // H10e025a.wav
            {-5,-5,0,2,-1,-3,-1,-1,-2,1,4,1,-3,2,11,5,-9,-4,14,9,-17,-16,19,23,-22,-36,21,50,-12,-48,35,76,2,327,1708,3691,4478,2733,-472,-2406,-1713,-21,107,-1616,-2886,-1704,1268,3657,4124,3526,3552,4850,6588,7356,6239,3408,119,-1948,-1864,-279,973,336,-2211,-5183,-6776,-6186,-4077,-2007,-1278,-2007,-3133,-3366,-2301,-675,404,464,-54,-357,-13,808,1594,1917,1702,1237,926,974,1263,1509,1512,1261,889,597,544,705,832,665,210,-250,-458,-435,-388,-452,-587,-696,-749,-792,-883,-1040,-1200,-1241,-1082,-785,-519,-413,-472,-625,-802,-934,-940,-786,-532,-297,-154,-98,-82,-67,-31,22,65,65,11,-89,-218,-356,-461,-485,-423,-335,-293,-322,-385,-427,-416,-363,-304,-265,-238,-194,-130,-79,-72,-101,-131,-138,-124,-105,-96,-99,-115,-132,-127,-87,-16,62,118,131,96,31,-36,-85,-115,-136,-152,-164,-171,-173,-170,-165,-165,-176,-201,-233,-258,-263,-241,-197,-144,-100,-75,-61,-46,-29,-20,-30,-63,-106,-140,-150,-132,-95,-57,-36,-41,-60,-74,-78,-83,-105,-141,-172,-181,-170,-154,-144,-141,-136,-126,-114,-106,-106,-115,-129,-133,-112,-65,-12,23,38,42,39,18,-22,-62,-82,-84,-86,-92,-95,-91,-89,-93,-94,-89,-91,-110,-134,-142,-132,-120,-117,-117,-109,-96,-79,-56,-26},
            {19,60,-25,-100,6,126,2,-182,-51,220,102,-259,-153,307,158,-180,1817,7203,12034,10406,1889,-6655,-8646,-5353,-3221,-4713,-5412,-1073,5783,8971,6855,4429,6977,13789,19061,17755,9761,-566,-7717,-8564,-4323,335,901,-3416,-9480,-13383,-13523,-10877,-7293,-4254,-2753,-3082,-4265,-4435,-2607,66,1449,881,-91,362,2239,3941,4216,3284,2182,1638,1750,2261,2755,2816,2328,1627,1191,1214,1505,1663,1276,184,-1227,-2152,-2078,-1345,-790,-877,-1380,-1889,-2307,-2731,-3109,-3207,-2845,-2043,-1006,-67,440,392,-72,-722,-1406,-1980,-2199,-1863,-1049,-107,609,932,895,664,465,457,613,779,854,849,783,629,407,232,196,242,241,143,3,-130,-268,-436,-617,-752,-775,-643,-390,-147,-69,-193,-398,-528,-530,-471,-434,-441,-462,-462,-413,-286,-86,125,250,229,93,-67,-175,-200,-157,-76,10,76,114,129,120,82,18,-63,-149,-225,-275,-291,-282,-267,-246,-204,-138,-67,-18,-6,-42,-136,-274,-411,-491,-483,-389,-240,-87,18,59,57,42,19,-21,-74,-116,-124,-94,-40,9,25,8,-11,-5,10,-5,-62,-131,-173,-172,-130,-52,40,109,133,118,81,21,-65,-158,-225,-254,-258,-256,-250,-236,-211,-176,-145,-139,-174,-240,-302,-324,-300,-246,-181,-107,-22,66,132,145,94,6,-79,-129,-139,-124,-104,-85,-62,-29,5,23,17,-10,-52,-101,-133,-119,-60}
        },
        {    // H10e030a.wav
            {-4,-3,-2,-2,-1,0,-1,-3,-2,-1,-1,1,3,0,-4,1,9,4,-9,-6,12,11,-13,-18,11,22,-12,-30,10,38,-6,-36,29,63,-12,227,1390,3178,4042,2674,-156,-2035,-1558,-13,228,-1312,-2631,-1753,920,3232,3787,3231,3140,4240,5874,6756,5965,3526,498,-1550,-1621,-183,1086,658,-1590,-4333,-5911,-5545,-3772,-1944,-1239,-1841,-2870,-3156,-2261,-820,130,147,-305,-443,53,859,1441,1542,1291,992,877,1003,1280,1543,1622,1425,1014,609,437,529,680,656,418,122,-86,-195,-257,-292,-312,-384,-591,-929,-1277,-1485,-1469,-1249,-947,-729,-698,-820,-971,-1062,-1088,-1060,-956,-756,-503,-275,-119,-27,25,58,93,143,194,210,167,64,-89,-265,-407,-457,-406,-316,-268,-288,-340,-371,-363,-331,-300,-279,-260,-235,-203,-174,-160,-170,-203,-243,-261,-238,-186,-141,-122,-110,-78,-19,50,112,154,161,125,64,9,-24,-47,-76,-108,-130,-144,-163,-186,-200,-201,-208,-236,-274,-293,-283,-255,-224,-190,-149,-107,-76,-60,-50,-40,-39,-57,-96,-138,-158,-141,-97,-53,-30,-30,-39,-47,-54,-66,-87,-112,-131,-137,-129,-121,-124,-138,-147,-137,-115,-98,-99,-113,-125,-125,-110,-87,-64,-46,-35,-28,-24,-26,-38,-61,-90,-111,-110,-94,-79,-72,-65,-53,-46,-55,-79,-106,-129,-145,-148,-136,-124,-125,-127,-103,-50},
            {42,-85,-78,83,104,-100,-163,93,224,-78,-284,79,344,-114,216,3807,9785,12757,8302,-1081,-8061,-8710,-6166,-5087,-5108,-2461,3276,7621,7198,4678,5682,11781,18405,19591,13560,3720,-4490,-7390,-5104,-1149,224,-2687,-7906,-11954,-12997,-11691,-9495,-7138,-4927,-3536,-3439,-3828,-3143,-1022,1003,1317,307,-87,1251,3379,4558,4134,2838,1744,1417,1829,2544,2940,2658,1968,1474,1404,1407,1083,448,-218,-733,-1051,-1132,-989,-797,-774,-968,-1307,-1775,-2398,-3058,-3466,-3352,-2667,-1610,-558,74,36,-601,-1490,-2200,-2393,-1947,-1044,-126,415,531,484,515,654,828,996,1115,1094,903,659,505,442,373,274,211,206,188,106,0,-88,-194,-376,-598,-743,-726,-573,-376,-214,-126,-131,-226,-370,-489,-537,-540,-558,-591,-568,-429,-204,20,183,270,268,168,14,-100,-116,-66,-23,-13,-13,-3,10,16,22,29,12,-52,-149,-233,-265,-250,-221,-199,-177,-139,-88,-46,-34,-62,-134,-246,-375,-476,-504,-439,-304,-150,-29,38,67,83,85,55,-7,-73,-113,-116,-85,-29,30,67,70,57,45,22,-32,-108,-167,-180,-148,-88,-17,54,109,131,115,64,-14,-103,-186,-249,-283,-287,-266,-233,-199,-162,-126,-111,-137,-201,-268,-307,-308,-276,-215,-131,-37,53,127,168,153,82,-13,-89,-130,-143,-137,-115,-83,-47,-11,17,21,-7,-54,-95,-117,-122,-109,-76,-32}
        },
        {    // H10e035a.wav
            {-4,-4,-1,1,-2,-4,-1,2,0,-3,-2,-1,-1,0,2,0,-4,-1,6,3,-8,-7,9,10,-11,-17,10,25,-5,-34,-4,36,10,-30,10,52,-4,142,1054,2627,3599,2675,254,-1610,-1434,-83,303,-980,-2311,-1774,531,2730,3402,2953,2792,3692,5177,6127,5653,3647,943,-1054,-1318,-107,1129,933,-950,-3436,-5041,-4975,-3579,-1972,-1239,-1670,-2583,-2930,-2238,-1000,-114,8,-276,-360,-22,510,931,1137,1177,1120,1043,1052,1207,1423,1513,1358,1022,707,590,689,855,898,734,423,94,-154,-292,-350,-404,-550,-839,-1218,-1541,-1671,-1573,-1333,-1099,-981,-996,-1075,-1140,-1159,-1130,-1035,-855,-610,-367,-179,-47,51,121,166,201,242,278,285,253,181,53,-123,-292,-374,-345,-266,-221,-240,-297,-353,-389,-401,-393,-376,-360,-344,-318,-285,-262,-264,-290,-317,-318,-276,-200,-121,-66,-36,-13,24,81,144,187,189,154,102,55,19,-15,-48,-75,-102,-142,-197,-243,-258,-246,-230,-232,-255,-285,-303,-293,-255,-206,-163,-130,-103,-78,-57,-44,-46,-67,-104,-140,-152,-129,-83,-43,-28,-35,-47,-48,-40,-34,-40,-58,-81,-98,-105,-102,-98,-101,-113,-125,-131,-132,-137,-147,-155,-153,-140,-123,-108,-95,-79,-60,-44,-39,-48,-65,-82,-93,-95,-84,-61,-38,-32,-40,-48,-53,-73,-113,-146,-148,-133,-130,-136,-115,-57},
            {-91,14,119,6,-172,-72,187,118,-222,-181,260,201,-284,1030,5840,11550,12503,6229,-3070,-8933,-9458,-7724,-6164,-3575,1326,6106,7080,4792,4291,9158,16785,20714,17035,7767,-1380,-5718,-4599,-1171,365,-2000,-6755,-10653,-11879,-11260,-10460,-9742,-8192,-5692,-3576,-2927,-3057,-2441,-812,589,866,704,1310,2729,3890,4017,3368,2617,2144,2042,2294,2655,2714,2356,1896,1517,931,-52,-898,-856,-30,570,224,-664,-1168,-977,-598,-625,-1163,-1966,-2780,-3388,-3526,-3023,-2047,-1095,-671,-937,-1646,-2335,-2591,-2228,-1365,-388,271,437,315,258,428,732,1035,1304,1500,1484,1162,669,277,135,165,228,270,282,227,80,-110,-257,-342,-417,-526,-644,-709,-679,-555,-367,-173,-52,-67,-211,-395,-528,-592,-630,-650,-594,-422,-186,15,139,214,261,256,188,100,37,-4,-52,-101,-127,-122,-103,-77,-36,10,23,-25,-120,-220,-283,-293,-266,-228,-190,-153,-120,-102,-103,-112,-128,-174,-262,-365,-434,-440,-381,-268,-120,21,111,140,124,78,3,-89,-159,-177,-146,-91,-30,29,73,92,81,42,-23,-103,-171,-204,-197,-161,-104,-30,50,116,145,122,46,-62,-173,-259,-308,-322,-303,-259,-205,-158,-129,-120,-135,-174,-225,-269,-296,-301,-280,-227,-140,-30,81,160,177,129,44,-41,-107,-152,-175,-170,-139,-94,-46,-9,0,-27,-76,-121,-147,-158,-149,-109,-48,0,11}
        },
        {    // H10e040a.wav
            {-1,0,-2,-3,-2,-1,-2,-3,-1,1,0,-2,-2,0,1,1,1,0,-2,-1,4,3,-6,-7,5,10,-5,-14,6,23,0,-29,-10,29,16,-22,3,46,0,62,736,2084,3142,2669,700,-1133,-1309,-221,319,-622,-1912,-1768,77,2148,3011,2735,2499,3160,4484,5509,5348,3774,1427,-477,-945,-36,1097,1130,-345,-2548,-4191,-4446,-3438,-2055,-1276,-1472,-2177,-2536,-2091,-1151,-406,-224,-392,-464,-218,257,756,1110,1210,1054,817,769,1037,1462,1736,1677,1357,1009,836,877,995,975,695,227,-217,-460,-493,-453,-511,-756,-1148,-1543,-1784,-1801,-1641,-1416,-1222,-1101,-1056,-1061,-1086,-1097,-1055,-925,-710,-458,-233,-66,52,140,198,232,266,323,387,412,368,261,114,-42,-170,-236,-243,-234,-256,-319,-395,-451,-473,-469,-461,-465,-479,-478,-442,-377,-317,-292,-301,-317,-306,-256,-178,-94,-23,28,62,87,116,157,197,210,182,123,61,11,-27,-60,-91,-125,-170,-222,-260,-265,-244,-224,-228,-253,-278,-288,-278,-253,-218,-181,-150,-125,-104,-85,-72,-72,-86,-109,-127,-127,-107,-76,-49,-36,-33,-31,-21,-5,9,10,-7,-37,-67,-85,-91,-100,-118,-138,-154,-165,-173,-176,-175,-174,-173,-167,-153,-133,-110,-86,-64,-48,-41,-44,-54,-67,-73,-67,-54,-49,-57,-65,-62,-54,-57,-71,-89,-109,-132,-143,-117,-56},
            {20,84,-38,-145,15,198,15,-259,-50,326,31,-240,1977,7491,12627,12028,4695,-4474,-9942,-10691,-9004,-6011,-1145,4441,7189,5548,3238,5701,13408,20468,20448,12667,2423,-4096,-4588,-1404,1086,-70,-4461,-9074,-11191,-10795,-9997,-10185,-10417,-9007,-6076,-3538,-2656,-2630,-2044,-864,-91,99,739,2424,4220,4785,3991,2860,2248,2243,2638,3247,3661,3321,2126,645,-496,-1124,-1256,-782,179,940,804,-62,-745,-686,-294,-321,-960,-1797,-2431,-2804,-2969,-2863,-2459,-1986,-1817,-2106,-2598,-2823,-2491,-1704,-833,-210,69,127,165,323,612,940,1218,1441,1618,1657,1415,907,376,85,70,157,199,193,176,111,-58,-296,-482,-552,-567,-627,-740,-802,-708,-471,-220,-85,-102,-212,-330,-414,-468,-510,-538,-517,-416,-246,-61,91,208,304,362,352,272,163,70,2,-58,-122,-182,-210,-184,-111,-28,19,6,-65,-177,-291,-359,-356,-311,-278,-270,-249,-186,-99,-28,-3,-35,-127,-254,-359,-394,-355,-270,-159,-35,82,165,194,167,87,-34,-155,-226,-226,-173,-100,-29,25,55,65,59,28,-40,-131,-208,-243,-233,-189,-113,-10,100,176,189,133,25,-103,-212,-282,-316,-321,-292,-232,-163,-113,-90,-93,-121,-171,-229,-273,-295,-299,-280,-220,-113,15,122,177,172,114,24,-66,-134,-171,-177,-156,-116,-72,-37,-18,-22,-51,-95,-131,-151,-163,-165,-133,-55,33,71,46}
        },
        {    // H10e045a.wav
            {0,0,0,-1,-3,-3,-1,2,1,-1,-1,2,2,0,0,1,1,-1,0,1,0,0,3,4,-3,-6,3,11,3,-8,2,17,4,-22,-12,24,24,-12,-8,33,12,23,468,1547,2629,2597,1142,-594,-1129,-369,287,-281,-1472,-1705,-358,1540,2582,2507,2232,2668,3811,4879,5022,3910,1960,160,-544,12,1001,1247,190,-1696,-3337,-3881,-3239,-2047,-1182,-1152,-1756,-2295,-2195,-1488,-697,-293,-305,-416,-337,-19,402,756,939,959,947,1073,1398,1796,2041,1974,1611,1122,723,550,561,565,381,3,-401,-651,-716,-716,-807,-1052,-1385,-1666,-1780,-1711,-1535,-1339,-1169,-1046,-982,-980,-1009,-1012,-936,-764,-523,-274,-74,53,128,188,250,311,371,431,473,467,398,284,152,14,-120,-228,-291,-315,-335,-380,-453,-526,-570,-576,-562,-551,-541,-510,-448,-374,-321,-301,-298,-287,-252,-190,-109,-24,47,92,109,114,123,141,161,166,143,94,35,-17,-55,-79,-97,-122,-160,-202,-230,-238,-234,-227,-220,-221,-236,-261,-277,-267,-237,-206,-183,-162,-137,-112,-95,-87,-86,-90,-96,-95,-79,-48,-15,5,6,0,4,19,30,23,-1,-30,-61,-91,-116,-130,-137,-147,-161,-168,-166,-164,-171,-181,-186,-182,-169,-147,-115,-80,-50,-30,-21,-25,-38,-50,-58,-65,-73,-76,-70,-62,-58,-50,-36,-37,-68,-105,-104,-55},
            {76,-100,-143,81,204,-53,-265,34,329,-81,-121,2663,8504,13272,11875,3914,-5562,-11252,-12008,-9543,-4985,1060,6160,7079,4256,2998,7950,16938,22269,18556,8160,-1459,-4802,-2337,1320,1887,-1556,-6603,-9947,-10260,-9159,-9148,-10601,-11328,-9420,-5792,-3111,-2597,-2940,-2503,-1387,-625,-205,889,2859,4511,4792,4044,3287,2948,2923,3291,4070,4473,3406,931,-1439,-2279,-1639,-581,154,529,624,382,-40,-238,-117,-117,-637,-1486,-2144,-2411,-2500,-2604,-2673,-2681,-2803,-3150,-3447,-3222,-2328,-1166,-327,-83,-238,-388,-256,196,808,1345,1631,1663,1581,1496,1373,1113,735,384,185,128,123,108,62,-28,-167,-318,-426,-486,-557,-698,-876,-974,-892,-642,-349,-153,-113,-199,-331,-434,-465,-427,-367,-322,-283,-216,-116,-3,126,285,438,501,434,298,184,113,36,-73,-184,-252,-255,-192,-85,11,31,-45,-174,-300,-390,-436,-441,-424,-400,-356,-267,-139,-17,57,68,20,-80,-201,-290,-310,-270,-198,-100,23,141,218,237,201,109,-33,-182,-270,-269,-211,-139,-70,-6,40,49,21,-32,-104,-186,-256,-285,-263,-194,-89,35,153,223,216,132,0,-134,-233,-285,-303,-297,-262,-194,-117,-64,-57,-84,-127,-177,-230,-277,-306,-311,-282,-207,-85,52,154,184,148,76,-1,-74,-135,-175,-184,-155,-101,-48,-19,-19,-36,-59,-87,-120,-152,-171,-170,-140,-77,7,75,89,50}
        },
        {    // H10e050a.wav
            {0,0,0,0,0,0,0,-2,-2,0,0,-2,-2,0,1,0,0,1,-1,-3,-2,2,1,-3,-2,1,-1,-5,0,11,9,-6,-8,7,10,-8,-15,6,18,-2,-7,25,24,6,254,1047,2074,2426,1527,-9,-866,-512,166,-11,-989,-1522,-714,908,2073,2227,1987,2256,3228,4291,4656,3951,2424,813,-64,115,870,1256,636,-817,-2318,-3100,-2922,-2132,-1377,-1159,-1499,-1945,-1981,-1495,-857,-527,-604,-782,-693,-230,418,970,1256,1312,1319,1444,1692,1896,1868,1559,1089,649,380,302,310,235,-27,-416,-752,-899,-883,-856,-945,-1150,-1369,-1499,-1508,-1433,-1331,-1225,-1108,-986,-895,-861,-862,-835,-736,-567,-362,-156,22,150,220,252,280,331,402,465,482,430,319,185,60,-45,-138,-228,-314,-392,-459,-516,-561,-589,-596,-582,-558,-538,-521,-493,-442,-375,-317,-279,-247,-201,-138,-77,-32,1,33,62,76,72,66,71,84,90,81,59,30,-4,-42,-77,-102,-120,-141,-169,-196,-210,-213,-218,-231,-248,-260,-267,-271,-268,-253,-229,-205,-184,-163,-137,-108,-82,-63,-51,-47,-46,-40,-26,-10,-1,-2,-5,-3,5,9,2,-20,-53,-87,-109,-114,-115,-123,-137,-150,-159,-165,-174,-188,-203,-209,-200,-174,-138,-100,-66,-43,-32,-30,-32,-40,-57,-74,-78,-69,-60,-62,-63,-51,-36,-39,-55,-58,-33},
            {-57,-100,59,157,-53,-229,36,288,-98,-59,2818,8796,13744,12369,3984,-6326,-12691,-13264,-9671,-3839,2562,6799,6525,3514,3516,10074,19252,22695,16321,4696,-3696,-4496,-326,3045,2059,-2580,-7530,-9874,-9354,-8244,-8830,-10793,-11539,-9355,-5591,-3052,-2741,-3198,-2902,-2065,-1510,-917,680,3056,4698,4668,3692,3104,3417,4313,5255,5521,4248,1405,-1472,-2475,-1398,71,429,-77,-323,8,327,300,209,168,-222,-1136,-2027,-2287,-2094,-2142,-2724,-3486,-4000,-4152,-3926,-3210,-2061,-928,-313,-275,-446,-472,-274,95,617,1234,1745,1947,1844,1622,1421,1213,914,550,259,150,186,227,150,-59,-316,-507,-562,-507,-468,-575,-838,-1097,-1145,-930,-599,-344,-237,-238,-301,-395,-463,-440,-338,-242,-203,-175,-97,23,141,257,397,529,579,518,392,255,118,-24,-156,-249,-282,-240,-131,-17,21,-52,-195,-341,-450,-508,-512,-485,-467,-461,-404,-257,-68,67,105,79,26,-51,-140,-204,-221,-207,-174,-99,33,190,306,330,252,93,-91,-229,-280,-263,-222,-176,-121,-61,-17,-2,-22,-83,-180,-282,-340,-332,-271,-178,-56,81,195,242,208,114,-9,-128,-221,-278,-302,-294,-247,-164,-76,-24,-28,-74,-136,-197,-251,-295,-325,-331,-295,-203,-66,70,153,162,116,47,-23,-89,-144,-176,-173,-139,-90,-46,-20,-17,-32,-57,-86,-122,-164,-194,-190,-145,-78,-13,35,54,45,20}
        },
        {    // H10e055a.wav
            {1,1,1,1,2,2,1,0,0,1,1,1,0,-1,0,1,2,2,0,0,0,-1,0,3,3,-1,-2,1,2,-1,1,10,11,-1,-7,6,15,1,-16,-7,14,14,7,24,31,-1,102,632,1536,2152,1772,545,-496,-543,29,155,-538,-1228,-931,297,1476,1887,1794,1955,2708,3681,4223,3924,2841,1465,488,363,913,1394,1091,-88,-1564,-2572,-2702,-2103,-1317,-911,-1112,-1660,-2041,-1931,-1442,-939,-645,-469,-187,287,833,1256,1435,1379,1209,1086,1103,1214,1272,1154,850,456,97,-143,-260,-329,-439,-609,-769,-839,-826,-812,-868,-985,-1106,-1191,-1236,-1241,-1188,-1063,-893,-749,-695,-728,-771,-734,-590,-379,-169,-8,89,140,180,234,292,324,321,306,299,288,243,154,33,-102,-237,-353,-432,-471,-489,-505,-523,-534,-533,-524,-513,-501,-482,-447,-390,-315,-239,-179,-139,-116,-102,-92,-79,-55,-24,3,14,9,1,6,28,57,72,61,30,-4,-30,-51,-75,-104,-134,-163,-191,-214,-225,-224,-226,-240,-259,-268,-262,-249,-238,-226,-208,-185,-161,-133,-96,-55,-24,-16,-28,-43,-46,-36,-20,-6,-2,-10,-24,-33,-28,-17,-16,-33,-59,-81,-94,-105,-120,-141,-163,-179,-186,-184,-179,-177,-179,-179,-168,-140,-104,-73,-53,-40,-30,-30,-43,-58,-62,-57,-52,-51,-49,-50,-59,-69,-60,-30},
            {-113,66,177,-30,-243,-16,285,-31,-133,2416,8378,13994,13466,5071,-6372,-13959,-14619,-9966,-3062,3472,7033,6114,3160,3915,11273,20430,22694,14741,2504,-4914,-4015,1095,4083,2170,-2860,-7420,-9187,-8508,-7720,-8755,-10964,-11667,-9277,-5354,-2865,-2821,-3592,-3453,-2578,-1970,-1481,-72,2288,4183,4485,3733,3352,4018,5206,5903,5318,3274,555,-1342,-1453,-382,388,246,-83,121,512,400,-78,-245,-58,-217,-1041,-1943,-2300,-2338,-2749,-3725,-4745,-5181,-4768,-3600,-2060,-758,-212,-388,-720,-693,-285,219,662,1103,1559,1890,1970,1847,1667,1484,1222,826,385,88,37,142,207,111,-120,-375,-559,-633,-635,-665,-807,-1024,-1164,-1110,-900,-663,-488,-395,-385,-439,-482,-426,-284,-172,-171,-221,-204,-79,102,289,479,652,747,713,571,386,208,59,-57,-143,-211,-253,-241,-163,-71,-46,-128,-281,-431,-528,-562,-557,-543,-527,-481,-371,-200,-20,107,152,122,40,-66,-157,-203,-200,-166,-108,-15,114,248,337,342,252,88,-95,-230,-283,-274,-241,-198,-144,-84,-39,-32,-73,-158,-263,-352,-388,-363,-289,-179,-41,104,213,253,217,126,6,-112,-203,-259,-288,-290,-247,-156,-55,3,-2,-51,-114,-181,-252,-318,-363,-367,-317,-209,-64,73,156,163,111,33,-44,-111,-163,-190,-179,-130,-63,-9,11,1,-25,-55,-91,-135,-181,-211,-208,-166,-94,-20,29,40,26,8,0}
        },
        {    // H10e060a.wav
            {0,0,0,0,0,0,1,1,0,0,0,0,0,-1,-1,-1,-1,-1,0,0,0,-1,-1,-1,0,1,0,-2,-2,1,2,1,2,8,9,-1,-8,2,15,5,-19,-17,13,31,19,12,17,-2,26,335,1037,1756,1826,1028,-11,-431,-127,159,-188,-844,-952,-196,846,1447,1552,1697,2285,3156,3812,3865,3258,2243,1271,770,835,1108,1048,394,-640,-1574,-2035,-1968,-1617,-1344,-1381,-1649,-1819,-1620,-1089,-508,-101,139,328,498,587,574,538,567,661,762,821,821,743,565,296,-6,-267,-436,-508,-520,-518,-524,-532,-537,-565,-643,-762,-870,-922,-913,-874,-835,-805,-776,-737,-695,-665,-649,-621,-547,-423,-276,-138,-27,52,89,87,70,76,119,180,226,230,186,103,-2,-107,-200,-281,-353,-408,-434,-431,-416,-413,-428,-451,-465,-459,-433,-390,-336,-281,-235,-203,-182,-164,-151,-148,-152,-145,-113,-69,-41,-39,-47,-42,-20,7,30,44,44,29,5,-20,-49,-86,-126,-157,-173,-181,-190,-201,-211,-220,-229,-240,-244,-240,-232,-221,-209,-195,-177,-152,-119,-87,-63,-47,-35,-28,-29,-35,-39,-37,-35,-36,-35,-27,-12,2,4,-11,-37,-66,-90,-109,-126,-141,-154,-161,-162,-158,-154,-157,-171,-185,-183,-162,-132,-103,-76,-53,-41,-41,-43,-37,-32,-39,-51,-55,-58,-75,-97,-92,-49},
            {-43,164,90,-198,-143,230,126,-219,1519,7066,13668,14996,7499,-5035,-14633,-16319,-11129,-3169,3850,7314,6231,3186,3791,11052,20360,22812,14670,1956,-5620,-4241,1573,4911,2939,-2207,-6779,-8584,-8014,-7244,-8189,-10464,-11565,-9658,-5891,-3180,-2878,-3638,-3667,-2939,-2430,-2076,-806,1530,3515,3940,3409,3485,4632,5734,5529,3927,1882,457,127,569,931,604,-86,-234,455,1180,1041,188,-481,-570,-574,-997,-1671,-2232,-2821,-3850,-5212,-6130,-5892,-4509,-2648,-1103,-353,-379,-728,-849,-510,105,685,1119,1475,1781,1959,1967,1879,1777,1626,1314,818,296,-27,-73,25,64,-34,-190,-309,-394,-508,-676,-871,-1051,-1182,-1224,-1150,-976,-771,-614,-545,-544,-549,-492,-364,-229,-167,-192,-230,-192,-38,202,464,687,833,887,838,685,457,224,49,-60,-143,-229,-290,-281,-208,-132,-114,-168,-273,-396,-511,-596,-634,-621,-563,-468,-334,-160,27,169,212,147,20,-110,-200,-233,-208,-139,-46,61,179,293,367,356,248,77,-92,-210,-267,-280,-266,-229,-165,-88,-29,-20,-75,-181,-306,-406,-442,-405,-314,-194,-58,86,211,275,255,165,43,-77,-176,-250,-296,-298,-241,-135,-25,36,27,-30,-102,-178,-257,-330,-376,-375,-319,-211,-70,63,143,150,102,31,-41,-110,-171,-205,-192,-132,-52,13,43,41,16,-25,-77,-135,-192,-234,-241,-196,-110,-21,33,46,37,27,18,8}
        },
        {    // H10e065a.wav
            {0,0,0,0,0,0,0,0,0,1,1,0,0,0,-1,-2,-2,-2,-1,0,0,-1,-2,-2,-1,0,0,-2,-2,-1,0,0,0,1,4,6,4,-2,-3,5,10,-1,-17,-10,20,36,19,0,1,-5,-7,155,652,1338,1700,1336,476,-173,-192,89,43,-437,-805,-548,204,902,1261,1526,2080,2939,3712,3948,3477,2513,1527,973,992,1295,1371,877,-121,-1225,-1985,-2143,-1751,-1133,-682,-585,-708,-769,-639,-441,-357,-406,-451,-381,-212,-31,104,177,189,162,142,158,183,153,42,-120,-281,-399,-444,-398,-290,-205,-226,-355,-504,-573,-542,-469,-430,-453,-520,-594,-645,-655,-624,-581,-564,-579,-580,-515,-390,-267,-199,-183,-179,-162,-132,-90,-36,20,57,64,53,38,14,-34,-104,-176,-230,-266,-291,-308,-312,-309,-314,-339,-371,-381,-357,-316,-288,-280,-276,-263,-246,-235,-229,-218,-200,-183,-167,-144,-113,-87,-78,-80,-74,-51,-23,-2,12,24,26,8,-29,-68,-97,-116,-132,-147,-159,-166,-177,-196,-215,-221,-217,-212,-211,-207,-198,-187,-178,-171,-158,-136,-107,-76,-50,-34,-30,-35,-44,-47,-40,-29,-21,-19,-18,-16,-19,-29,-41,-53,-69,-90,-109,-118,-121,-130,-145,-153,-152,-151,-157,-164,-163,-154,-142,-124,-101,-81,-69,-59,-43,-32,-38,-55,-68,-79,-99,-118,-105,-53},
            {83,123,-107,-206,122,258,-190,492,4893,12109,16165,11239,-1464,-13826,-18229,-13668,-4655,3579,7725,6906,3599,3246,9525,18992,22854,16004,3170,-5643,-5192,913,5402,4486,-359,-5446,-8159,-8182,-7187,-7343,-9182,-10820,-10004,-6884,-3956,-3118,-3728,-4021,-3490,-2900,-2457,-1331,796,2823,3581,3413,3581,4401,4856,4134,2729,1703,1406,1405,1298,1079,867,754,887,1271,1489,1060,162,-430,-330,-99,-523,-1633,-2857,-3914,-5029,-6195,-6756,-6054,-4266,-2319,-1045,-610,-669,-799,-723,-334,291,953,1476,1813,1992,2033,1959,1855,1812,1787,1597,1114,454,-90,-313,-267,-153,-103,-115,-161,-271,-474,-716,-909,-1036,-1155,-1286,-1347,-1249,-1015,-777,-644,-608,-584,-519,-423,-330,-258,-213,-185,-126,25,278,563,791,931,991,953,786,531,293,138,27,-114,-281,-392,-390,-294,-170,-83,-84,-189,-366,-542,-650,-673,-635,-561,-460,-324,-150,40,187,237,174,36,-116,-227,-264,-225,-141,-47,51,169,295,380,379,287,133,-47,-204,-296,-308,-271,-226,-177,-107,-31,1,-48,-162,-294,-401,-456,-447,-376,-258,-109,54,200,288,288,207,81,-48,-158,-241,-293,-299,-244,-135,-15,60,60,-2,-93,-186,-270,-336,-373,-369,-315,-211,-77,45,116,124,86,26,-41,-108,-168,-207,-207,-158,-73,13,63,67,43,10,-33,-96,-174,-242,-265,-227,-139,-39,35,66,59,37,17,6,1}
        },
        {    // H10e070a.wav
            {0,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,0,0,-1,-2,-2,0,0,-2,-3,-1,1,0,-3,-1,4,5,1,-2,0,5,6,2,-5,-6,3,18,21,6,-10,-7,1,1,74,374,921,1425,1458,912,197,-139,-8,146,-86,-557,-731,-305,484,1190,1653,2060,2598,3181,3537,3467,2986,2279,1582,1087,854,768,608,226,-310,-743,-824,-528,-98,111,-116,-701,-1334,-1686,-1624,-1268,-883,-688,-722,-855,-912,-811,-601,-382,-212,-96,-24,11,29,51,65,25,-81,-193,-227,-172,-95,-64,-80,-100,-105,-115,-156,-223,-293,-349,-394,-438,-489,-545,-598,-637,-649,-630,-585,-528,-473,-429,-394,-365,-336,-302,-255,-191,-117,-50,0,34,53,50,21,-26,-70,-100,-125,-158,-195,-223,-236,-242,-251,-264,-275,-281,-287,-298,-312,-324,-328,-322,-306,-277,-241,-212,-200,-198,-186,-159,-131,-117,-111,-98,-74,-45,-19,4,20,23,7,-23,-56,-84,-105,-120,-133,-145,-159,-175,-187,-191,-188,-180,-173,-174,-182,-188,-186,-180,-174,-162,-140,-112,-87,-67,-47,-28,-18,-20,-29,-38,-44,-47,-48,-45,-39,-33,-30,-34,-46,-61,-76,-91,-108,-125,-136,-139,-138,-139,-141,-142,-144,-145,-140,-128,-116,-108,-101,-93,-89,-91,-91,-85,-83,-97,-112,-97,-48},
            {178,-29,-273,-44,350,46,-256,2267,8946,15689,15217,4722,-9922,-19030,-17637,-8499,1858,8101,8305,4597,2505,6904,16297,22500,18453,6215,-4623,-6616,-1045,5058,6343,2647,-2928,-7215,-8665,-7848,-6919,-7639,-9407,-9904,-7966,-5069,-3463,-3588,-4136,-4129,-3799,-3387,-2298,-94,2383,3791,3910,3693,3723,3510,2602,1624,1520,2158,2476,1933,1136,885,1214,1653,1936,2005,1686,915,121,-144,11,-166,-1180,-2787,-4481,-6002,-7125,-7324,-6200,-4159,-2267,-1302,-1176,-1281,-1166,-753,-144,531,1140,1584,1865,2033,2103,2063,1968,1908,1884,1765,1414,841,217,-258,-473,-445,-279,-107,-47,-157,-398,-662,-851,-967,-1092,-1271,-1436,-1467,-1317,-1065,-837,-693,-608,-539,-482,-446,-410,-332,-199,-36,135,319,529,752,954,1086,1091,932,644,345,145,51,-29,-167,-334,-433,-399,-255,-93,-19,-89,-276,-497,-663,-722,-674,-561,-437,-322,-190,-14,167,263,221,81,-81,-209,-277,-267,-186,-77,17,105,217,333,385,332,195,28,-131,-255,-319,-313,-260,-189,-110,-30,17,-8,-113,-261,-388,-453,-450,-396,-307,-180,-14,160,282,307,239,118,-16,-136,-225,-274,-282,-246,-163,-51,44,72,26,-61,-150,-230,-302,-358,-378,-344,-254,-122,13,104,124,86,22,-44,-108,-171,-219,-229,-188,-105,-12,57,86,77,43,-7,-64,-130,-201,-252,-244,-166,-58,25,63,69,59,32,-6,-29,-21}
        },
        {    // H10e075a.wav
            {1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,1,2,2,1,-1,-2,-1,2,3,1,-1,1,5,4,-1,-2,5,13,12,3,-3,0,7,11,10,4,-4,-2,9,18,50,212,597,1095,1369,1148,567,96,54,258,268,-67,-428,-419,3,575,1123,1734,2516,3308,3734,3530,2781,1853,1154,921,1141,1588,1951,1991,1643,1002,247,-446,-955,-1257,-1426,-1572,-1741,-1884,-1928,-1864,-1765,-1701,-1667,-1588,-1400,-1111,-788,-498,-265,-80,71,189,272,314,302,224,100,-6,-14,101,275,392,376,243,78,-41,-89,-96,-104,-142,-224,-351,-511,-672,-793,-846,-835,-787,-730,-685,-658,-643,-621,-575,-500,-404,-296,-182,-71,18,75,104,119,123,114,91,62,29,-14,-68,-121,-153,-161,-160,-174,-210,-260,-309,-347,-371,-381,-378,-363,-339,-309,-282,-267,-264,-261,-243,-210,-173,-143,-121,-104,-86,-66,-43,-16,9,24,22,3,-26,-57,-84,-106,-120,-127,-129,-129,-129,-131,-137,-147,-158,-164,-165,-164,-165,-167,-168,-166,-160,-148,-124,-91,-57,-35,-25,-22,-25,-37,-52,-57,-48,-36,-30,-30,-30,-28,-27,-32,-46,-66,-85,-99,-110,-122,-130,-131,-127,-126,-129,-128,-124,-128,-142,-155,-155,-148,-142,-131,-108,-86,-84,-93,-83,-43},
            {192,-189,-315,169,407,-235,111,4527,12357,17157,12192,-1774,-15884,-20949,-14950,-3195,6833,10247,7111,2576,3445,11630,20719,21413,11411,-1597,-7721,-4346,3000,7415,6267,1183,-4667,-8476,-9002,-7446,-6528,-7623,-9211,-8903,-6508,-4105,-3341,-3828,-4354,-4512,-4420,-3689,-1724,1083,3409,4391,4324,3778,2779,1383,457,936,2391,3202,2486,1178,771,1481,2280,2414,2099,1780,1462,1074,849,861,562,-680,-2742,-4851,-6404,-7246,-7257,-6253,-4498,-2845,-2003,-1862,-1794,-1444,-926,-389,232,964,1604,1936,1999,2001,2051,2099,2086,2023,1913,1684,1253,650,44,-360,-462,-325,-127,-45,-154,-395,-625,-744,-791,-909,-1178,-1495,-1658,-1567,-1312,-1050,-853,-703,-584,-523,-528,-542,-482,-322,-108,111,320,528,732,913,1048,1104,1029,804,496,234,88,13,-80,-214,-329,-356,-282,-147,-31,-24,-172,-418,-633,-719,-677,-575,-467,-363,-243,-90,86,228,270,188,19,-161,-286,-318,-259,-147,-36,53,140,240,324,339,266,122,-52,-206,-297,-309,-269,-209,-135,-42,35,36,-59,-204,-336,-421,-454,-432,-351,-222,-68,91,227,300,279,172,28,-102,-194,-251,-283,-278,-217,-105,13,81,74,7,-89,-188,-272,-329,-356,-356,-314,-212,-66,65,124,105,46,-24,-98,-173,-232,-251,-221,-147,-50,37,87,93,70,33,-12,-71,-144,-214,-242,-199,-97,9,71,85,75,51,7,-43,-62,-37}
        },
        {    // H10e080a.wav
            {1,1,1,1,1,0,-1,-1,-1,0,0,0,0,0,0,1,2,2,1,0,0,0,0,0,0,0,-1,-1,1,2,0,-3,-4,-1,3,3,0,-2,1,6,4,-3,-3,9,20,15,-2,-9,1,10,3,-9,-6,12,31,41,37,29,82,307,731,1157,1283,1035,715,663,796,652,-23,-849,-1137,-600,391,1265,1803,2166,2519,2803,2884,2780,2670,2722,2949,3209,3277,2966,2228,1197,111,-803,-1411,-1693,-1758,-1818,-2059,-2481,-2868,-2973,-2742,-2353,-2033,-1852,-1708,-1467,-1100,-681,-303,-13,191,326,409,454,475,475,453,418,401,435,515,581,556,418,229,86,36,48,49,-11,-143,-328,-538,-738,-893,-986,-1021,-1015,-985,-947,-909,-866,-802,-702,-572,-430,-294,-170,-61,29,94,137,169,199,220,221,197,155,106,52,-6,-63,-109,-144,-180,-227,-287,-346,-387,-403,-396,-379,-367,-367,-374,-377,-364,-333,-292,-251,-214,-180,-150,-127,-111,-97,-80,-60,-43,-30,-18,-8,-9,-29,-60,-84,-89,-78,-67,-65,-73,-87,-105,-127,-147,-155,-150,-139,-134,-139,-151,-164,-176,-183,-179,-158,-126,-95,-72,-55,-39,-25,-21,-27,-35,-38,-38,-40,-44,-46,-41,-29,-22,-27,-42,-60,-80,-104,-124,-132,-131,-132,-138,-142,-141,-145,-159,-173,-177,-174,-171,-164,-147,-130,-123,-118,-93,-44},
            {156,-291,-276,321,344,-430,663,6422,14486,17202,9033,-6556,-19288,-21068,-12062,913,9974,10914,5698,1554,5125,15184,22347,18342,5247,-6358,-8230,-1626,6050,8985,6279,200,-6039,-9475,-9028,-6718,-5878,-7473,-9154,-8429,-5718,-3462,-3072,-3893,-4748,-5180,-4970,-3597,-921,2107,4118,4567,3865,2565,1083,113,466,1998,3278,3004,1582,675,1180,2306,2800,2451,1921,1620,1425,1304,1431,1533,768,-1343,-4192,-6572,-7689,-7465,-6211,-4475,-3028,-2455,-2587,-2666,-2185,-1347,-604,-56,491,1083,1543,1772,1889,2024,2153,2191,2139,2046,1901,1624,1159,557,-16,-348,-334,-88,108,32,-296,-643,-805,-787,-780,-959,-1305,-1635,-1761,-1634,-1346,-1027,-775,-626,-579,-601,-637,-622,-509,-302,-51,193,419,645,862,1022,1079,1022,866,639,399,217,115,39,-74,-217,-312,-294,-175,-32,34,-51,-280,-549,-722,-734,-627,-491,-382,-294,-188,-38,133,252,249,124,-61,-230,-332,-341,-258,-131,-21,58,143,252,334,321,200,22,-151,-276,-326,-298,-221,-135,-54,17,52,9,-113,-263,-378,-434,-438,-399,-312,-177,-7,162,281,308,237,103,-47,-174,-258,-298,-302,-267,-181,-51,73,126,80,-30,-147,-241,-308,-349,-361,-338,-273,-163,-33,67,98,64,-4,-79,-152,-217,-263,-269,-220,-121,-8,75,108,101,72,24,-40,-112,-177,-220,-218,-152,-38,61,94,77,54,31,-21,-89,-112,-65}
        },
        {    // H10e085a.wav
            {1,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,1,0,1,2,1,-1,-1,0,0,-1,-2,-2,-1,-1,-1,-1,-2,-3,-3,-1,2,3,1,-2,-1,3,3,-1,-1,12,27,22,-5,-25,-19,0,8,12,30,50,43,9,-20,-29,4,182,646,1329,1852,1828,1306,750,490,350,-46,-701,-1185,-1152,-683,-40,751,1851,3218,4462,5153,5164,4670,3931,3152,2477,1969,1574,1166,645,-23,-836,-1742,-2586,-3148,-3318,-3203,-3031,-2932,-2862,-2717,-2470,-2172,-1856,-1502,-1098,-688,-334,-54,181,392,561,667,722,756,777,775,746,702,655,604,546,475,380,256,128,36,-12,-56,-146,-301,-506,-741,-973,-1159,-1262,-1274,-1219,-1127,-1016,-903,-799,-696,-570,-416,-262,-141,-54,25,107,176,221,251,279,299,293,256,201,138,62,-28,-121,-197,-246,-280,-313,-346,-369,-378,-385,-398,-416,-428,-430,-420,-391,-340,-279,-228,-196,-177,-158,-136,-118,-106,-97,-87,-80,-80,-80,-72,-58,-44,-33,-24,-13,-5,-9,-30,-61,-89,-108,-122,-131,-133,-127,-121,-123,-131,-143,-157,-174,-189,-193,-182,-160,-131,-99,-68,-42,-21,-8,-5,-15,-32,-47,-56,-60,-59,-51,-38,-26,-24,-34,-56,-84,-110,-125,-132,-140,-153,-163,-165,-166,-169,-168,-161,-161,-175,-187,-181,-166,-162,-161,-129,-62},
            {136,-332,-249,389,301,-518,945,7299,15357,16966,7256,-8989,-20854,-20833,-10240,3279,11649,11187,4998,1253,6148,16690,22300,15731,1420,-8914,-8214,266,8286,10524,6789,-263,-7046,-10222,-8884,-5838,-5017,-7168,-9271,-8505,-5498,-3039,-2705,-3839,-5128,-5823,-5435,-3477,-188,3053,4690,4266,2547,685,-379,-54,1559,3320,3723,2423,812,563,1755,2928,2943,2142,1527,1442,1562,1710,1912,1737,365,-2363,-5400,-7327,-7533,-6418,-4794,-3405,-2738,-2789,-2984,-2694,-1903,-1133,-694,-333,281,1017,1494,1622,1677,1868,2104,2213,2192,2133,2010,1680,1090,404,-94,-216,-12,258,307,31,-416,-758,-844,-775,-798,-1058,-1462,-1773,-1822,-1613,-1273,-937,-696,-594,-615,-692,-730,-664,-493,-271,-50,168,420,703,943,1057,1034,922,755,550,356,237,187,119,-28,-197,-276,-222,-85,42,69,-64,-334,-611,-747,-704,-566,-433,-337,-248,-132,18,166,245,201,45,-146,-293,-355,-323,-221,-103,-19,41,132,264,358,325,163,-50,-228,-327,-335,-270,-172,-80,0,63,81,17,-119,-271,-384,-441,-442,-383,-269,-117,49,205,307,309,204,41,-111,-215,-272,-295,-282,-224,-120,5,103,125,60,-58,-178,-267,-318,-343,-349,-326,-253,-131,0,82,87,35,-40,-118,-192,-249,-274,-257,-192,-84,37,122,144,118,69,8,-64,-135,-187,-207,-180,-100,8,89,103,71,38,8,-44,-106,-120,-67}
        },
        {    // H10e090a.wav
            {1,2,2,2,1,0,0,1,2,2,0,-1,-1,0,1,2,2,2,1,2,4,4,2,1,2,3,1,-1,-1,1,1,1,0,1,1,0,1,4,5,2,0,2,4,3,3,8,16,24,22,4,-23,-30,0,42,53,32,14,8,-7,-16,59,262,526,755,951,1174,1401,1533,1548,1479,1198,392,-1031,-2546,-3248,-2572,-712,1661,3913,5615,6433,6182,5058,3650,2564,2042,1944,1986,1914,1546,804,-228,-1340,-2333,-3090,-3542,-3631,-3389,-3006,-2733,-2678,-2712,-2615,-2295,-1840,-1391,-1007,-671,-366,-90,181,478,770,958,986,918,867,869,872,832,764,694,610,484,324,170,53,-20,-55,-74,-133,-297,-576,-899,-1164,-1310,-1339,-1291,-1203,-1095,-978,-860,-747,-637,-516,-378,-234,-110,-17,58,128,192,241,278,312,338,334,289,215,129,38,-59,-152,-224,-266,-290,-311,-336,-362,-383,-400,-414,-423,-423,-409,-379,-339,-297,-257,-223,-195,-174,-157,-139,-123,-120,-132,-147,-147,-127,-97,-68,-40,-11,16,32,34,24,6,-21,-57,-89,-107,-112,-112,-115,-120,-120,-114,-109,-115,-133,-153,-169,-180,-184,-171,-136,-91,-56,-34,-19,-7,-5,-14,-28,-40,-50,-58,-61,-57,-53,-55,-59,-63,-68,-78,-92,-107,-126,-148,-167,-177,-179,-177,-168,-154,-147,-155,-167,-170,-173,-186,-191,-153,-73},
            {152,-336,-278,386,344,-532,747,6980,15160,17016,7370,-9074,-21107,-20929,-9946,3844,12183,11522,5164,1303,6036,16303,21539,14584,67,-10042,-8594,911,9743,12167,7930,20,-7448,-10731,-8911,-5204,-4074,-6504,-9229,-8921,-5889,-3059,-2438,-3665,-5317,-6293,-5865,-3573,154,3672,5114,3894,1180,-1040,-1347,298,2638,4001,3534,1919,778,1110,2336,3059,2646,1746,1273,1380,1668,1931,2103,1669,-134,-3219,-6220,-7557,-6844,-5040,-3442,-2743,-2856,-3202,-3141,-2452,-1529,-949,-806,-655,-129,611,1170,1432,1585,1764,1919,2013,2118,2242,2203,1794,1052,288,-133,-71,289,561,461,19,-468,-728,-746,-724,-855,-1173,-1560,-1846,-1890,-1648,-1220,-809,-589,-586,-697,-795,-802,-695,-492,-262,-67,108,342,653,929,1042,986,846,683,506,350,273,258,195,23,-170,-245,-162,-6,99,72,-109,-383,-618,-703,-638,-513,-406,-323,-238,-128,13,155,223,154,-28,-226,-354,-383,-320,-195,-71,-6,26,105,245,350,314,143,-70,-243,-342,-353,-277,-158,-53,19,72,94,42,-90,-254,-385,-454,-457,-391,-261,-94,74,212,287,270,164,15,-122,-214,-258,-267,-247,-197,-111,1,94,110,35,-87,-198,-275,-324,-355,-360,-322,-236,-116,3,77,80,20,-72,-165,-236,-274,-276,-242,-166,-54,56,119,125,101,68,18,-57,-137,-194,-214,-190,-111,0,86,100,61,23,-4,-52,-114,-129,-72}
        },
        {    // H10e095a.wav
            {1,1,1,0,0,0,0,0,0,0,0,0,-1,-2,-1,0,1,1,0,0,1,1,1,0,0,1,2,1,-2,-3,-1,0,-1,-3,-1,2,2,-1,-3,0,4,3,-1,0,6,10,7,2,4,12,14,5,-3,3,20,27,15,0,34,178,445,717,779,519,130,31,484,1305,2019,2256,1902,938,-605,-2346,-3392,-2835,-599,2316,4569,5456,5197,4442,3698,3152,2791,2524,2258,1974,1706,1405,887,31,-1003,-1871,-2376,-2628,-2838,-3049,-3141,-3043,-2830,-2612,-2411,-2187,-1929,-1663,-1392,-1086,-727,-335,48,389,656,820,880,877,872,893,922,923,879,790,664,509,343,191,70,-14,-68,-107,-166,-292,-506,-775,-1017,-1163,-1198,-1161,-1102,-1046,-989,-914,-809,-679,-543,-421,-312,-205,-98,-3,68,121,171,224,268,291,287,257,202,127,48,-22,-81,-140,-207,-272,-319,-342,-351,-361,-376,-387,-386,-372,-350,-327,-309,-298,-286,-261,-225,-191,-173,-173,-182,-192,-193,-179,-149,-113,-82,-60,-46,-35,-21,-2,18,30,22,-5,-38,-66,-90,-110,-123,-124,-118,-109,-98,-85,-79,-90,-116,-143,-158,-160,-151,-136,-117,-96,-76,-60,-50,-44,-35,-23,-20,-37,-66,-87,-94,-95,-95,-90,-77,-65,-66,-79,-98,-121,-148,-174,-189,-191,-182,-167,-153,-151,-161,-171,-168,-163,-167,-166,-131,-62},
            {201,-288,-348,298,453,-434,166,5516,13819,17233,9366,-6711,-20019,-21505,-11360,2615,11761,12060,6167,1646,4898,14277,20262,14928,1111,-9849,-9553,-14,10063,13765,9910,1484,-6901,-10986,-9399,-5182,-3232,-5359,-8678,-9323,-6744,-3608,-2431,-3426,-5250,-6513,-6252,-3958,-67,3706,5247,3732,485,-1964,-1872,426,3007,4061,3268,1781,1052,1592,2683,3177,2617,1587,989,1134,1657,2097,2162,1446,-521,-3543,-6338,-7390,-6337,-4283,-2722,-2312,-2678,-3043,-2899,-2263,-1534,-1093,-935,-737,-281,296,739,1020,1282,1569,1781,1895,2027,2207,2234,1867,1129,356,-55,43,431,697,568,118,-338,-570,-619,-684,-887,-1210,-1565,-1842,-1911,-1683,-1230,-785,-562,-583,-715,-819,-830,-731,-532,-296,-101,58,267,558,832,964,940,832,683,502,343,286,307,271,102,-105,-195,-124,20,121,95,-85,-360,-591,-661,-585,-470,-385,-318,-240,-145,-30,96,177,134,-41,-253,-390,-410,-334,-203,-76,1,40,108,228,325,302,153,-43,-210,-315,-335,-268,-153,-49,20,69,93,54,-62,-214,-349,-438,-463,-411,-285,-120,44,183,274,281,190,41,-98,-189,-232,-246,-234,-189,-108,-6,78,97,32,-86,-204,-288,-335,-354,-348,-308,-224,-108,5,72,71,13,-71,-156,-226,-270,-279,-248,-176,-69,45,123,146,126,84,24,-54,-135,-198,-230,-217,-143,-24,80,113,83,38,-4,-61,-120,-129,-70}
        },
        {    // H10e100a.wav
            {1,1,1,0,0,0,0,0,0,0,0,0,0,-1,-1,0,1,1,1,0,-1,0,1,0,0,1,2,0,-1,0,1,-1,-3,-2,2,4,3,0,-2,-3,-1,2,4,4,7,11,9,-2,-9,3,25,35,25,9,-4,-15,8,136,407,733,909,765,353,-49,-143,145,615,990,1153,1158,1031,657,-12,-674,-766,34,1426,2687,3276,3207,2869,2609,2524,2545,2574,2507,2246,1770,1184,641,215,-147,-532,-963,-1383,-1727,-1984,-2196,-2407,-2600,-2690,-2586,-2295,-1946,-1696,-1584,-1497,-1294,-944,-538,-176,109,331,492,594,667,755,856,918,895,800,680,573,485,401,296,149,-25,-173,-256,-301,-371,-496,-640,-756,-836,-898,-941,-947,-914,-866,-819,-759,-667,-550,-436,-344,-265,-182,-94,-15,47,94,131,155,163,158,146,126,92,44,-11,-66,-121,-174,-218,-250,-277,-308,-338,-351,-338,-312,-293,-287,-282,-270,-258,-252,-249,-242,-234,-233,-239,-237,-215,-175,-130,-95,-75,-69,-70,-72,-71,-64,-49,-30,-14,-7,-13,-32,-59,-86,-108,-117,-112,-98,-83,-68,-56,-53,-65,-84,-99,-103,-102,-103,-106,-110,-113,-114,-110,-99,-82,-65,-55,-57,-68,-80,-87,-91,-93,-91,-83,-76,-78,-88,-101,-115,-137,-163,-177,-173,-163,-164,-170,-170,-164,-161,-158,-142,-120,-110,-111,-94,-48},
            {235,-165,-392,106,521,-165,-413,3287,11144,16809,12502,-1913,-16989,-21999,-14346,-551,10192,12600,7900,2531,3308,10963,18123,16030,4246,-7897,-10497,-2501,8620,14653,12541,4431,-4938,-10678,-10386,-6129,-2916,-3902,-7420,-9358,-7841,-4698,-2806,-3222,-4966,-6465,-6532,-4573,-890,3002,4975,3873,702,-1967,-2104,112,2689,3774,3143,1949,1393,1790,2612,3076,2751,1861,1078,923,1351,1903,2067,1388,-471,-3300,-5994,-7137,-6229,-4211,-2578,-2076,-2350,-2641,-2526,-2077,-1581,-1240,-1041,-807,-418,57,461,751,1006,1267,1497,1688,1902,2124,2181,1878,1229,511,73,88,420,710,666,295,-139,-408,-522,-646,-872,-1171,-1484,-1755,-1878,-1728,-1317,-864,-614,-619,-733,-809,-806,-731,-575,-357,-149,12,188,440,711,878,895,818,694,521,342,257,290,315,205,1,-137,-121,-6,99,110,-15,-257,-510,-640,-609,-498,-400,-331,-266,-189,-94,21,117,115,-24,-231,-392,-438,-374,-245,-111,-20,30,97,211,313,314,194,13,-157,-277,-315,-259,-150,-53,4,43,71,49,-50,-194,-331,-429,-476,-447,-331,-160,11,154,254,284,219,80,-68,-169,-217,-235,-230,-193,-118,-20,61,82,27,-78,-191,-279,-334,-357,-351,-314,-241,-134,-14,73,88,33,-57,-150,-232,-295,-319,-286,-198,-78,41,127,161,142,80,-6,-95,-170,-220,-242,-221,-145,-30,66,95,67,25,-18,-69,-115,-114,-60}
        },
        {    // H10e105a.wav
            {1,0,0,1,2,2,0,-1,0,1,0,-1,0,1,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,0,-2,-2,1,3,2,-1,-2,-1,1,2,0,-1,0,1,-1,-2,3,11,10,0,-6,0,9,12,18,30,26,5,49,280,689,1045,1049,631,61,-262,-150,246,613,727,564,240,-66,-141,207,1001,1986,2721,2877,2490,1911,1511,1419,1517,1631,1678,1659,1581,1422,1172,862,544,246,-27,-263,-429,-518,-594,-762,-1061,-1408,-1659,-1750,-1746,-1760,-1821,-1850,-1749,-1510,-1223,-988,-832,-703,-544,-346,-138,63,259,444,584,655,665,640,589,516,440,385,341,265,127,-51,-220,-348,-428,-463,-463,-459,-486,-550,-621,-668,-688,-694,-689,-657,-594,-522,-468,-433,-390,-321,-237,-166,-117,-79,-43,-17,-9,-7,6,26,29,0,-47,-86,-104,-112,-124,-145,-171,-202,-236,-265,-278,-275,-267,-263,-255,-235,-210,-200,-217,-250,-277,-285,-271,-238,-190,-140,-105,-93,-96,-95,-89,-89,-101,-113,-110,-96,-85,-84,-86,-82,-76,-81,-95,-100,-85,-61,-51,-56,-60,-52,-41,-40,-45,-48,-50,-60,-78,-92,-99,-106,-121,-140,-153,-154,-143,-126,-106,-87,-73,-66,-69,-77,-81,-81,-87,-106,-132,-149,-156,-163,-173,-178,-174,-169,-170,-171,-160,-141,-126,-115,-103,-91,-90,-92,-77,-39},
            {195,41,-302,-161,393,231,-548,938,7059,14523,15331,5097,-10668,-20661,-18121,-6112,6471,12356,10186,4444,2043,6623,14343,16618,8977,-3318,-10002,-5904,4800,13590,14900,8769,-857,-8782,-11198,-8183,-3832,-2627,-5225,-8350,-8741,-6405,-3861,-3181,-4368,-6012,-6623,-5359,-2289,1458,4032,4008,1651,-1051,-1947,-540,1766,3194,3160,2368,1770,1778,2249,2765,2850,2296,1439,925,1073,1582,1853,1406,-33,-2405,-5013,-6635,-6424,-4757,-2939,-2012,-2002,-2269,-2297,-2020,-1621,-1267,-1010,-804,-557,-222,164,533,849,1095,1272,1423,1630,1892,2051,1902,1402,750,257,125,329,630,742,537,132,-245,-468,-597,-763,-1020,-1326,-1606,-1771,-1729,-1449,-1045,-732,-643,-719,-803,-804,-731,-605,-423,-211,-22,136,318,549,762,861,830,711,541,361,246,249,308,293,155,-11,-85,-38,62,122,69,-120,-375,-572,-630,-572,-474,-382,-302,-236,-167,-69,47,101,20,-168,-350,-438,-417,-316,-177,-53,21,76,168,290,353,287,119,-69,-214,-282,-260,-165,-54,18,45,49,24,-53,-181,-321,-431,-480,-453,-346,-184,-16,123,216,248,207,104,-19,-121,-186,-218,-219,-189,-128,-46,33,74,51,-34,-146,-247,-314,-350,-356,-329,-259,-147,-20,76,102,49,-56,-169,-254,-295,-292,-254,-186,-95,6,90,131,116,53,-32,-111,-167,-199,-213,-203,-153,-65,21,63,58,34,-1,-50,-96,-100,-54}
        },
        {    // H10e110a.wav
            {0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,0,-1,-1,1,1,-2,-2,3,6,2,-3,-1,5,6,3,5,8,4,0,12,25,15,29,206,622,1106,1291,948,263,-290,-364,-20,395,578,454,128,-214,-335,-2,852,1979,2902,3235,2959,2399,1929,1692,1573,1394,1105,796,570,427,280,66,-174,-330,-328,-204,-67,-18,-88,-244,-411,-513,-519,-476,-484,-609,-826,-1047,-1191,-1227,-1170,-1061,-956,-894,-864,-818,-719,-578,-426,-274,-114,48,183,270,317,341,340,299,224,149,99,57,-16,-128,-246,-328,-364,-367,-353,-332,-321,-337,-375,-408,-417,-412,-412,-415,-404,-376,-350,-340,-334,-314,-287,-270,-264,-249,-216,-179,-156,-146,-141,-143,-153,-157,-138,-104,-85,-95,-116,-123,-116,-120,-148,-186,-211,-216,-211,-204,-199,-199,-211,-233,-250,-246,-217,-179,-149,-130,-117,-105,-97,-98,-106,-116,-122,-126,-133,-142,-147,-146,-144,-149,-157,-154,-136,-110,-86,-66,-46,-31,-26,-33,-37,-28,-13,-6,-9,-13,-17,-31,-57,-86,-108,-126,-147,-169,-183,-180,-163,-140,-118,-98,-79,-65,-61,-68,-80,-95,-115,-142,-165,-175,-177,-182,-192,-196,-186,-169,-153,-135,-112,-94,-90,-92,-85,-71,-64,-65,-56,-29},
            {37,215,-37,-327,5,432,-81,-400,2707,9801,15299,11825,-1182,-15152,-19963,-12973,-218,9705,11943,7654,2549,2603,8652,14657,13200,3661,-6271,-8114,-730,9498,15127,13064,5113,-4227,-10211,-10401,-6444,-2846,-2914,-5889,-8362,-8092,-5859,-3971,-3819,-5010,-6147,-5953,-3960,-755,2227,3508,2613,526,-1014,-905,537,2109,2892,2821,2348,1928,1853,2185,2624,2638,2022,1220,876,1130,1518,1452,575,-1187,-3513,-5556,-6329,-5524,-3860,-2447,-1861,-1906,-2087,-2080,-1817,-1394,-989,-739,-608,-426,-92,323,687,942,1113,1246,1398,1599,1790,1815,1550,1050,536,235,237,456,682,703,436,-1,-388,-599,-691,-819,-1065,-1375,-1623,-1696,-1551,-1244,-914,-714,-691,-763,-811,-775,-665,-499,-293,-82,97,248,412,594,744,799,742,596,409,257,211,264,319,281,156,32,-17,15,78,97,1,-216,-465,-622,-637,-560,-461,-378,-312,-252,-173,-62,38,45,-75,-256,-396,-438,-382,-260,-116,0,71,137,235,330,342,237,64,-104,-216,-247,-193,-88,3,40,33,2,-60,-165,-294,-399,-448,-434,-362,-239,-90,48,145,190,180,116,17,-82,-153,-189,-194,-176,-134,-68,6,61,67,10,-91,-197,-276,-318,-328,-310,-261,-182,-87,-7,33,23,-30,-106,-179,-229,-251,-247,-216,-157,-77,2,52,61,35,-11,-64,-114,-160,-202,-227,-207,-131,-27,55,87,71,21,-49,-107,-112,-61}
        },
        {    // H10e115a.wav
            {1,1,1,1,2,3,2,1,2,3,3,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,4,5,3,1,3,5,3,1,3,7,6,0,0,6,7,2,3,13,16,4,0,17,25,21,126,502,1092,1511,1345,596,-235,-588,-336,174,502,453,112,-290,-452,-75,936,2270,3293,3484,2861,1966,1409,1396,1665,1805,1619,1198,735,317,-107,-589,-1047,-1304,-1254,-980,-683,-493,-386,-280,-166,-102,-101,-85,17,163,228,139,-50,-216,-289,-305,-349,-467,-636,-788,-868,-857,-774,-660,-554,-478,-429,-383,-310,-201,-81,3,12,-45,-121,-173,-198,-221,-251,-265,-243,-199,-172,-181,-207,-216,-200,-174,-155,-144,-138,-140,-157,-182,-202,-210,-215,-226,-248,-280,-323,-371,-404,-402,-373,-348,-346,-351,-331,-278,-219,-181,-165,-152,-135,-121,-113,-106,-97,-93,-102,-119,-132,-141,-157,-186,-218,-237,-231,-201,-155,-106,-69,-51,-51,-59,-72,-90,-110,-126,-134,-140,-152,-170,-186,-193,-193,-194,-197,-196,-184,-162,-135,-109,-87,-69,-53,-39,-26,-14,-1,15,26,25,11,-8,-25,-45,-76,-116,-149,-163,-158,-144,-131,-125,-126,-132,-136,-130,-112,-91,-78,-81,-97,-120,-146,-171,-189,-196,-193,-192,-191,-180,-156,-133,-120,-112,-99,-84,-74,-68,-56,-42,-38,-43,-42,-24},
            {-131,170,217,-177,-333,162,404,-288,-53,4036,11026,14527,8631,-4735,-16291,-17804,-9107,2947,10752,10985,5889,1389,2590,8868,13611,10675,1403,-6159,-5366,2785,11552,14865,11158,2840,-5783,-10538,-9715,-5515,-2367,-2937,-5977,-8239,-7941,-5977,-4336,-4113,-4946,-5662,-5175,-3171,-353,1957,2722,1926,524,-340,-141,836,1951,2699,2867,2498,1929,1684,2004,2492,2479,1815,1057,793,998,1181,899,-61,-1726,-3766,-5382,-5776,-4883,-3454,-2346,-1874,-1848,-1960,-1965,-1714,-1247,-803,-581,-493,-294,98,526,824,986,1101,1225,1373,1532,1641,1590,1319,895,488,258,271,462,644,618,319,-124,-500,-697,-772,-864,-1063,-1339,-1563,-1603,-1419,-1104,-826,-703,-723,-786,-800,-734,-597,-403,-181,20,174,302,442,590,694,713,644,509,351,239,229,298,346,296,174,65,18,23,42,24,-89,-306,-540,-669,-652,-556,-462,-396,-339,-274,-190,-91,-15,-25,-140,-297,-399,-400,-311,-176,-43,53,113,174,254,315,298,197,53,-84,-179,-205,-156,-70,-9,6,-8,-38,-105,-214,-326,-394,-410,-384,-319,-210,-79,33,104,134,121,59,-33,-117,-159,-163,-149,-124,-85,-30,27,61,49,-14,-107,-197,-260,-297,-313,-305,-267,-197,-104,-11,48,43,-22,-115,-197,-252,-279,-277,-239,-166,-81,-7,39,45,11,-47,-103,-147,-183,-210,-208,-161,-82,-2,53,67,31,-43,-109,-118,-65}
        },
        {    // H10e120a.wav
            {0,0,0,1,1,1,1,1,1,1,1,1,0,-1,-1,-1,-1,-1,-1,-1,-1,0,1,1,-1,-2,-1,2,2,0,0,1,1,-1,0,5,6,0,-4,-1,1,-2,-1,12,21,9,-6,5,21,14,77,405,1038,1633,1669,965,-54,-701,-639,-111,365,443,122,-334,-533,-108,1036,2531,3664,3852,3102,2016,1298,1211,1455,1541,1255,783,435,303,191,-143,-720,-1313,-1659,-1669,-1453,-1185,-971,-829,-737,-649,-490,-200,186,518,645,563,429,414,544,687,687,498,200,-90,-301,-434,-525,-605,-681,-742,-770,-757,-707,-638,-575,-536,-522,-517,-506,-489,-481,-490,-502,-487,-425,-320,-204,-114,-70,-64,-69,-61,-31,14,59,89,94,72,33,-6,-33,-54,-87,-145,-220,-291,-349,-407,-480,-556,-599,-581,-508,-415,-334,-280,-251,-241,-239,-233,-213,-182,-148,-114,-82,-62,-66,-96,-139,-176,-196,-194,-169,-129,-88,-60,-41,-21,0,9,-3,-32,-63,-92,-120,-150,-176,-195,-208,-219,-227,-229,-225,-218,-210,-196,-173,-144,-121,-109,-104,-96,-82,-62,-35,-2,31,51,46,18,-22,-63,-97,-121,-132,-130,-119,-108,-102,-101,-102,-107,-120,-138,-151,-149,-134,-121,-121,-135,-156,-174,-184,-187,-185,-181,-177,-170,-159,-144,-129,-121,-118,-112,-96,-74,-56,-46,-44,-45,-47,-44,-32,-14},
            {-102,-63,148,136,-194,-252,208,316,-336,213,4477,10957,13418,6940,-5718,-15635,-15836,-7039,4118,10815,10255,4766,201,1527,7905,12674,10020,1605,-4813,-3413,4293,11910,14187,10073,1928,-6241,-10521,-9364,-5050,-1960,-2653,-5835,-8285,-8188,-6304,-4517,-3971,-4495,-5108,-4801,-3164,-688,1492,2379,1866,763,79,244,1013,1924,2640,2902,2563,1878,1497,1810,2387,2421,1715,888,568,693,764,428,-421,-1791,-3461,-4798,-5140,-4446,-3339,-2477,-2053,-1922,-1906,-1853,-1612,-1171,-736,-509,-413,-201,214,664,952,1064,1115,1198,1324,1453,1524,1467,1240,876,495,254,244,411,563,507,205,-210,-558,-753,-837,-914,-1065,-1277,-1448,-1456,-1267,-988,-778,-715,-746,-773,-747,-666,-529,-329,-105,73,178,267,400,555,655,664,604,503,380,283,273,340,385,324,181,51,-7,-11,-10,-55,-183,-387,-590,-694,-669,-569,-467,-398,-355,-313,-245,-148,-73,-79,-170,-278,-332,-308,-220,-94,27,105,139,172,231,282,269,182,60,-58,-142,-171,-139,-76,-27,-9,-11,-35,-100,-205,-313,-386,-412,-391,-324,-218,-102,-5,64,100,90,33,-46,-107,-132,-129,-111,-82,-43,5,51,76,56,-16,-120,-224,-301,-333,-314,-256,-183,-113,-51,-1,15,-22,-100,-185,-251,-290,-297,-263,-195,-119,-57,-15,3,-4,-32,-66,-93,-119,-151,-178,-182,-156,-104,-39,16,27,-17,-75,-90,-51}
        },
        {    // H10e125a.wav
            {0,2,3,3,2,2,2,2,2,2,1,0,-1,0,1,1,0,0,1,2,1,0,0,0,1,1,1,0,0,2,3,1,1,4,6,2,-1,3,6,-2,-9,3,21,18,0,6,28,19,39,310,966,1728,1986,1369,191,-768,-950,-447,191,453,193,-340,-641,-202,1118,2853,4129,4272,3334,2044,1226,1177,1538,1699,1338,629,-10,-330,-434,-589,-925,-1317,-1539,-1486,-1261,-1064,-1031,-1148,-1280,-1275,-1052,-650,-203,143,321,390,480,675,936,1140,1184,1069,876,690,541,409,258,72,-142,-361,-557,-710,-809,-856,-864,-858,-861,-883,-915,-935,-929,-904,-870,-820,-732,-595,-435,-296,-203,-143,-88,-20,61,144,212,246,243,222,211,218,220,188,118,32,-51,-133,-228,-342,-456,-542,-582,-581,-555,-515,-466,-413,-368,-341,-335,-337,-330,-299,-246,-185,-135,-111,-115,-139,-164,-166,-134,-82,-42,-31,-39,-40,-20,12,39,51,48,31,1,-40,-84,-122,-154,-184,-212,-229,-230,-220,-210,-206,-206,-206,-200,-184,-158,-130,-114,-112,-111,-97,-66,-27,6,24,22,-1,-38,-76,-105,-122,-126,-115,-94,-70,-53,-47,-56,-78,-105,-125,-133,-132,-131,-134,-143,-160,-181,-197,-198,-183,-162,-147,-142,-142,-142,-138,-129,-118,-108,-100,-92,-83,-72,-59,-46,-41,-45,-46,-31,-5,13,11},
            {65,-127,-115,137,170,-158,-251,173,304,-282,197,4079,10055,12452,6713,-4797,-14019,-14454,-6478,3961,10373,9738,4002,-1072,-178,6366,12116,10834,3351,-3115,-2534,4259,11377,13626,9763,1942,-6007,-10268,-9205,-4884,-1630,-2215,-5566,-8387,-8551,-6599,-4477,-3582,-3989,-4818,-4934,-3628,-1154,1289,2405,1898,713,100,494,1393,2166,2608,2728,2443,1842,1437,1680,2268,2375,1672,732,268,309,362,80,-574,-1586,-2871,-4013,-4456,-4071,-3317,-2712,-2368,-2128,-1909,-1717,-1483,-1136,-765,-531,-409,-190,233,720,1050,1160,1157,1173,1263,1390,1469,1414,1195,862,518,285,244,364,478,403,99,-300,-618,-793,-873,-936,-1033,-1168,-1290,-1306,-1164,-932,-750,-694,-715,-722,-676,-591,-466,-288,-91,55,127,186,305,476,623,685,657,558,426,323,308,365,401,334,179,20,-73,-94,-89,-123,-243,-435,-622,-717,-691,-584,-466,-391,-370,-363,-310,-199,-95,-74,-141,-229,-271,-247,-163,-38,85,152,156,153,190,236,228,153,48,-44,-107,-129,-104,-51,-8,4,-9,-41,-106,-207,-316,-396,-424,-396,-322,-220,-118,-35,24,56,53,14,-38,-72,-79,-68,-51,-32,-13,4,13,7,-22,-69,-124,-172,-204,-220,-219,-203,-180,-155,-126,-97,-85,-105,-151,-201,-237,-254,-254,-233,-191,-132,-68,-13,18,17,-10,-53,-102,-147,-180,-197,-197,-173,-120,-52,-6,-7,-37,-50,-29}
        },
        {    // H10e130a.wav
            {0,0,0,0,2,1,-1,-1,0,-1,-2,-2,-1,-1,-2,-1,0,-1,-2,-1,-1,-2,-2,-1,0,-2,-3,-1,1,-1,-4,0,5,1,-7,-5,5,3,-10,-8,13,19,-1,-5,22,29,31,242,880,1766,2254,1784,506,-759,-1235,-825,-68,390,253,-294,-688,-288,1153,3134,4612,4754,3615,2084,1148,1149,1649,1914,1527,645,-235,-725,-839,-901,-1199,-1703,-2104,-2106,-1693,-1137,-773,-752,-968,-1180,-1185,-931,-521,-138,73,103,88,197,501,914,1262,1403,1311,1085,873,771,759,737,616,384,98,-169,-373,-514,-630,-767,-936,-1101,-1214,-1256,-1248,-1223,-1198,-1164,-1097,-977,-810,-629,-476,-367,-282,-184,-59,78,199,282,321,327,319,316,328,344,342,292,176,3,-183,-324,-395,-420,-439,-462,-467,-439,-399,-386,-414,-466,-508,-511,-463,-380,-296,-246,-240,-259,-276,-267,-220,-143,-63,-12,-3,-14,-16,1,23,37,48,61,68,53,15,-28,-61,-91,-129,-173,-205,-212,-200,-184,-177,-180,-188,-197,-201,-198,-188,-178,-169,-156,-129,-89,-48,-21,-13,-17,-29,-52,-85,-119,-142,-147,-138,-122,-100,-74,-50,-36,-38,-52,-70,-94,-120,-141,-150,-148,-146,-153,-169,-185,-191,-185,-171,-155,-141,-132,-132,-138,-137,-121,-99,-85,-83,-82,-74,-64,-60,-58,-53,-44,-35,-20,4,29,37,22},
            {53,47,-76,-93,88,149,-97,-228,93,285,-172,14,3066,8481,11555,7567,-2484,-11719,-13472,-6968,2788,9392,9268,3648,-2064,-2108,4315,11464,12348,6083,-1067,-2288,3160,10162,13106,10005,2666,-5151,-9656,-9058,-5007,-1560,-1763,-5067,-8292,-8879,-6916,-4394,-3147,-3591,-4802,-5331,-4178,-1536,1202,2461,1838,466,-113,594,1804,2566,2687,2504,2200,1783,1499,1692,2177,2251,1554,569,19,9,73,-140,-625,-1332,-2264,-3204,-3722,-3636,-3241,-2915,-2688,-2378,-1971,-1624,-1384,-1145,-868,-646,-492,-246,207,744,1114,1211,1149,1114,1196,1347,1447,1395,1173,851,541,343,306,384,430,299,-25,-402,-674,-799,-843,-881,-945,-1044,-1155,-1204,-1118,-915,-716,-628,-637,-651,-614,-531,-417,-270,-107,20,81,125,223,389,562,670,677,595,469,366,338,366,376,304,153,-14,-130,-168,-156,-168,-271,-454,-633,-721,-696,-599,-486,-401,-367,-365,-334,-234,-110,-54,-97,-186,-237,-215,-130,-10,103,164,163,145,154,178,172,116,35,-34,-72,-71,-39,-2,9,-11,-45,-84,-139,-215,-295,-355,-380,-367,-316,-238,-155,-82,-22,27,53,46,14,-18,-36,-46,-57,-70,-73,-57,-22,17,35,16,-37,-104,-167,-217,-251,-265,-260,-238,-203,-160,-127,-122,-148,-188,-220,-230,-218,-189,-142,-83,-28,3,3,-20,-57,-101,-145,-178,-195,-197,-186,-156,-103,-44,-8,-5,-15,-13}
        },
        {    // H10e135a.wav
            {1,1,2,2,1,0,0,0,-1,-2,-1,-1,-1,-1,0,1,0,-1,-1,-2,-2,-1,1,0,-2,0,3,1,-3,-1,4,2,-5,-4,5,3,-11,-10,12,21,1,-7,24,36,17,180,808,1803,2502,2191,860,-675,-1466,-1212,-380,285,312,-225,-722,-378,1187,3435,5129,5262,3897,2097,1032,1101,1787,2212,1837,788,-355,-1062,-1249,-1256,-1465,-1933,-2369,-2441,-2085,-1545,-1147,-1047,-1156,-1250,-1135,-759,-240,188,326,173,-51,-81,173,574,901,1033,998,915,891,958,1050,1057,922,693,473,323,220,108,-49,-254,-498,-761,-1012,-1214,-1351,-1432,-1467,-1444,-1349,-1193,-1023,-887,-793,-707,-591,-440,-271,-106,41,157,227,256,273,311,376,436,445,373,229,61,-78,-163,-216,-268,-320,-346,-329,-293,-278,-304,-363,-436,-503,-542,-534,-483,-418,-375,-363,-363,-345,-292,-213,-136,-83,-56,-42,-29,-18,-6,15,49,79,80,49,12,-8,-17,-39,-83,-134,-174,-195,-197,-180,-149,-123,-123,-148,-176,-189,-190,-190,-192,-188,-174,-152,-119,-73,-24,5,-5,-48,-99,-136,-154,-158,-154,-144,-131,-121,-113,-99,-77,-56,-52,-69,-98,-123,-139,-150,-158,-159,-155,-151,-152,-154,-148,-137,-132,-140,-152,-158,-155,-146,-130,-108,-85,-71,-69,-71,-68,-59,-50,-44,-40,-36,-30,-21,-10,-1,1,0,-1},
            {-59,41,84,-36,-122,13,149,-5,-209,-28,251,-16,-179,1783,6400,10332,8734,718,-8579,-12307,-7997,756,7722,8619,3708,-2373,-3727,1829,10021,13546,9300,1698,-1887,1508,8221,12245,10433,3937,-3613,-8489,-8742,-5382,-1861,-1409,-4302,-7827,-9025,-7301,-4494,-2882,-3309,-4837,-5705,-4674,-1939,968,2348,1734,281,-353,448,1890,2826,2899,2520,2098,1726,1510,1664,2076,2164,1510,461,-236,-300,-117,-149,-497,-1065,-1799,-2577,-3110,-3213,-3050,-2898,-2788,-2544,-2124,-1702,-1404,-1181,-965,-781,-625,-358,125,705,1115,1209,1088,978,1032,1229,1417,1433,1228,893,583,404,367,402,389,226,-88,-436,-677,-769,-776,-786,-844,-948,-1061,-1117,-1056,-894,-724,-629,-603,-580,-522,-443,-356,-248,-115,6,77,111,165,274,419,544,603,577,487,384,324,319,319,259,125,-39,-165,-215,-207,-205,-273,-417,-578,-677,-681,-613,-516,-431,-383,-367,-339,-254,-133,-52,-63,-133,-188,-182,-121,-27,71,135,144,119,108,124,133,103,39,-22,-51,-44,-14,12,10,-24,-71,-115,-158,-208,-260,-302,-328,-332,-302,-241,-167,-99,-44,2,28,19,-17,-50,-60,-51,-37,-21,-3,15,26,27,12,-26,-88,-160,-223,-267,-293,-302,-294,-273,-244,-211,-177,-149,-134,-132,-137,-142,-144,-139,-125,-105,-84,-71,-70,-81,-103,-128,-149,-162,-167,-165,-151,-123,-83,-41,-11,2,2}
        },
        {    // H10e140a.wav
            {1,2,1,0,0,0,-1,-2,-1,0,-1,-1,0,1,0,-1,-1,-1,-2,-1,1,1,-2,-2,1,1,-2,-1,5,3,-7,-7,6,9,-9,-18,3,20,3,-11,21,47,20,129,721,1808,2733,2616,1252,-561,-1687,-1608,-721,138,346,-136,-710,-454,1177,3689,5673,5877,4279,2119,836,953,1861,2496,2187,1030,-336,-1274,-1595,-1607,-1758,-2207,-2697,-2830,-2454,-1794,-1251,-1084,-1260,-1520,-1563,-1214,-534,197,646,674,445,270,330,557,766,836,772,651,564,581,704,848,901,823,670,520,406,326,262,179,25,-221,-514,-783,-995,-1168,-1313,-1413,-1434,-1367,-1236,-1078,-926,-802,-710,-631,-529,-385,-217,-63,48,121,181,244,293,300,261,203,154,111,51,-32,-114,-166,-183,-179,-169,-164,-176,-215,-277,-349,-417,-470,-501,-509,-498,-472,-429,-364,-287,-220,-179,-157,-134,-104,-80,-70,-65,-46,-11,22,35,28,15,3,-13,-39,-70,-100,-131,-165,-190,-191,-164,-127,-100,-93,-108,-137,-169,-188,-183,-164,-153,-154,-148,-119,-75,-39,-24,-32,-59,-99,-138,-158,-158,-149,-144,-142,-136,-124,-108,-96,-95,-104,-117,-129,-141,-156,-170,-174,-167,-154,-139,-123,-108,-101,-102,-108,-118,-137,-161,-174,-166,-140,-106,-74,-52,-46,-54,-62,-61,-56,-53,-47,-31,-15,-13,-19,-22,-31,-63,-102,-104,-56},
            {1,-54,-20,62,31,-83,-60,92,81,-124,-131,142,137,-186,646,4037,8419,9402,4199,-4494,-10267,-8865,-1857,5217,7490,4029,-1798,-4555,-816,7366,13445,12282,5407,-401,48,5566,10555,10585,5560,-1384,-6621,-8012,-5817,-2563,-1362,-3400,-6889,-8795,-7700,-4911,-2936,-3133,-4748,-5853,-5033,-2436,445,1963,1589,264,-475,153,1622,2802,3090,2728,2225,1814,1545,1538,1806,1982,1593,661,-232,-574,-426,-220,-276,-657,-1311,-2092,-2714,-2938,-2827,-2663,-2591,-2501,-2267,-1939,-1624,-1322,-1003,-737,-590,-454,-128,413,931,1163,1083,905,863,1023,1258,1378,1285,1028,743,533,417,360,303,178,-52,-344,-593,-715,-719,-685,-700,-794,-940,-1059,-1064,-933,-739,-591,-533,-519,-478,-387,-270,-152,-47,28,58,57,75,156,291,422,495,483,407,318,264,256,256,211,102,-37,-154,-214,-218,-203,-225,-318,-462,-584,-625,-584,-511,-453,-425,-410,-373,-284,-153,-41,-12,-67,-136,-152,-102,-21,47,76,66,41,36,66,107,119,85,27,-19,-31,-13,8,2,-38,-91,-131,-153,-171,-195,-220,-240,-252,-250,-227,-191,-158,-128,-94,-48,-2,29,42,48,51,46,32,11,-11,-31,-51,-78,-119,-172,-225,-265,-289,-300,-301,-289,-265,-232,-191,-145,-104,-80,-80,-97,-117,-131,-138,-142,-142,-135,-124,-115,-112,-110,-104,-96,-91,-92,-95,-95,-92,-83,-65,-39,-14}
        },
        {    // H10e145a.wav
            {1,0,0,0,-1,-2,-2,-1,-2,-2,0,2,1,-1,-1,-1,-2,-1,1,1,-2,-1,2,0,-6,-5,5,7,-6,-12,1,11,-4,-17,0,20,2,-20,13,55,30,97,653,1812,2945,3029,1660,-413,-1890,-2023,-1103,-40,373,-33,-664,-480,1214,3957,6198,6468,4668,2175,665,792,1890,2728,2491,1240,-314,-1425,-1834,-1854,-1992,-2466,-3032,-3245,-2875,-2110,-1401,-1113,-1279,-1612,-1732,-1423,-756,-26,454,571,481,457,641,938,1140,1121,913,647,455,413,499,602,598,464,296,215,257,359,422,375,205,-38,-276,-457,-594,-731,-887,-1033,-1126,-1147,-1103,-1015,-914,-828,-763,-699,-609,-489,-357,-233,-127,-40,22,51,55,58,78,96,72,-7,-96,-139,-123,-86,-66,-72,-88,-103,-117,-135,-167,-230,-328,-433,-499,-497,-433,-339,-253,-205,-203,-220,-219,-182,-129,-90,-76,-76,-77,-76,-74,-65,-45,-24,-19,-35,-59,-75,-87,-112,-154,-197,-220,-211,-173,-120,-74,-60,-83,-123,-150,-156,-153,-152,-149,-137,-115,-81,-39,-3,2,-32,-85,-127,-144,-142,-135,-131,-134,-140,-142,-134,-121,-111,-108,-112,-125,-149,-178,-196,-201,-198,-188,-168,-138,-107,-78,-56,-51,-73,-114,-154,-174,-172,-149,-109,-65,-34,-22,-20,-24,-38,-58,-67,-58,-47,-43,-38,-24,-20,-42,-72,-88,-102,-142,-187,-175,-92},
            {19,19,-30,-45,23,61,-23,-89,9,110,-7,-155,-12,185,-21,-5,1868,5802,8801,6986,183,-6861,-8731,-4455,1990,5584,4160,-534,-4220,-2923,3736,11323,13860,9523,2745,-157,2772,7799,9829,7016,1317,-3994,-6589,-5962,-3507,-1781,-2654,-5585,-8024,-7892,-5588,-3405,-3143,-4504,-5680,-5172,-2986,-385,1229,1303,385,-372,-105,1122,2462,3104,2931,2401,1943,1662,1539,1588,1689,1513,873,44,-472,-492,-298,-260,-507,-982,-1592,-2188,-2562,-2622,-2513,-2435,-2405,-2299,-2066,-1772,-1455,-1100,-751,-517,-410,-269,55,501,855,977,920,846,874,1009,1157,1206,1111,919,713,538,392,260,123,-46,-252,-449,-568,-589,-567,-581,-670,-818,-965,-1027,-947,-758,-570,-471,-445,-411,-325,-213,-117,-40,20,44,21,-7,25,137,278,374,387,325,227,145,117,136,150,110,17,-89,-169,-204,-203,-202,-241,-334,-442,-507,-505,-463,-425,-415,-424,-424,-374,-257,-109,-5,10,-39,-84,-86,-54,-17,1,-7,-32,-43,-13,53,115,133,101,44,-6,-32,-36,-39,-58,-88,-108,-108,-106,-123,-159,-200,-236,-260,-260,-228,-173,-110,-53,-2,45,82,100,99,84,59,21,-31,-92,-149,-190,-211,-221,-230,-239,-242,-238,-233,-232,-232,-226,-213,-191,-159,-121,-93,-86,-98,-114,-126,-137,-151,-164,-160,-140,-115,-93,-71,-47,-31,-31,-42,-57,-74,-94,-104,-85,-41}
        },
        {    // H10e150a.wav
            {0,0,-1,-2,-1,0,-1,-2,0,2,1,-1,-1,-2,-3,-2,1,1,-1,-1,3,4,-2,-5,3,7,-3,-11,0,12,-2,-18,-1,25,6,-28,1,58,37,70,594,1825,3157,3439,2074,-247,-2073,-2432,-1501,-251,371,63,-607,-487,1276,4267,6778,7103,5057,2185,436,606,1944,3006,2819,1431,-342,-1623,-2085,-2067,-2160,-2652,-3310,-3637,-3317,-2480,-1599,-1145,-1260,-1671,-1905,-1641,-924,-107,438,585,505,475,639,926,1163,1234,1134,935,734,617,607,624,549,337,70,-115,-144,-52,65,120,78,-44,-202,-358,-497,-615,-707,-763,-780,-762,-713,-640,-564,-519,-523,-560,-582,-534,-400,-230,-119,-124,-204,-250,-194,-75,12,10,-63,-157,-236,-280,-279,-239,-184,-142,-117,-97,-80,-88,-144,-249,-367,-442,-429,-330,-199,-107,-88,-117,-146,-149,-128,-94,-62,-49,-68,-113,-151,-154,-118,-67,-31,-30,-62,-103,-129,-132,-129,-145,-187,-234,-258,-243,-199,-148,-111,-96,-99,-113,-128,-134,-130,-123,-121,-121,-106,-66,-16,17,16,-14,-58,-98,-121,-125,-120,-121,-133,-148,-156,-151,-134,-112,-99,-104,-126,-156,-186,-214,-237,-246,-234,-199,-144,-84,-38,-29,-57,-103,-147,-176,-179,-149,-98,-49,-16,0,4,-5,-21,-35,-43,-52,-61,-60,-49,-47,-63,-82,-89,-95,-115,-137,-144,-155,-197,-239,-214,-109},
            {-17,6,33,3,-50,-26,51,38,-65,-67,66,89,-83,-133,87,147,-109,425,3047,6760,8044,4398,-2242,-6807,-6035,-1411,2796,3492,737,-2836,-3715,203,7390,12948,12624,7159,1816,1089,4468,7727,7507,3875,-831,-4292,-5356,-4279,-2645,-2432,-4285,-6719,-7558,-6221,-4243,-3494,-4264,-5238,-5037,-3455,-1357,219,767,450,-90,-130,636,1842,2763,2967,2614,2134,1775,1564,1501,1533,1423,933,209,-271,-254,-34,-78,-482,-985,-1391,-1731,-2046,-2253,-2306,-2305,-2339,-2341,-2189,-1878,-1502,-1132,-803,-565,-430,-304,-68,263,540,658,663,671,747,876,1012,1100,1094,984,808,613,433,285,167,44,-122,-312,-454,-492,-462,-454,-523,-654,-794,-885,-877,-762,-594,-453,-375,-333,-285,-222,-162,-106,-51,-15,-20,-51,-58,-6,90,185,245,257,217,140,69,47,68,81,38,-55,-152,-207,-206,-172,-150,-182,-272,-374,-428,-417,-378,-357,-369,-393,-392,-338,-236,-125,-49,-24,-32,-43,-46,-43,-43,-55,-78,-92,-68,-1,74,115,111,80,44,11,-17,-42,-71,-105,-131,-134,-117,-102,-108,-133,-164,-189,-197,-179,-137,-83,-27,27,74,105,109,89,51,0,-63,-133,-197,-244,-267,-264,-238,-202,-172,-157,-156,-169,-194,-222,-239,-238,-223,-197,-161,-126,-105,-104,-112,-121,-130,-138,-135,-118,-95,-76,-60,-44,-32,-30,-30,-26,-26,-42,-63,-63,-34}
        },
        {    // H10e155a.wav
            {-1,-2,-1,0,-1,-1,0,1,0,0,1,0,-2,-3,0,3,0,-2,2,4,-2,-4,5,9,-5,-17,-2,16,3,-21,-6,28,14,-29,-9,57,42,45,537,1833,3366,3857,2506,-65,-2253,-2848,-1912,-479,351,147,-551,-495,1334,4585,7398,7804,5504,2218,193,384,1951,3246,3138,1645,-339,-1810,-2350,-2302,-2340,-2835,-3565,-3988,-3731,-2874,-1867,-1225,-1204,-1627,-1992,-1836,-1102,-181,431,565,468,502,786,1145,1338,1279,1050,793,635,650,801,929,856,543,129,-193,-320,-274,-162,-119,-232,-461,-659,-711,-653,-617,-669,-744,-743,-642,-481,-305,-149,-63,-83,-174,-241,-226,-170,-158,-216,-279,-269,-180,-82,-45,-83,-173,-277,-364,-406,-395,-353,-320,-314,-316,-300,-269,-248,-251,-274,-301,-316,-305,-257,-184,-112,-64,-39,-22,-2,18,30,30,17,-10,-49,-92,-119,-118,-95,-71,-64,-76,-98,-120,-139,-154,-169,-188,-216,-255,-289,-296,-262,-200,-141,-115,-125,-147,-158,-152,-137,-118,-98,-80,-65,-44,-14,16,26,9,-24,-57,-82,-96,-100,-104,-117,-138,-150,-142,-118,-95,-85,-93,-116,-150,-189,-224,-251,-262,-249,-211,-161,-114,-79,-60,-63,-93,-135,-162,-154,-112,-52,7,47,54,33,3,-18,-33,-49,-62,-71,-78,-86,-89,-90,-97,-113,-124,-126,-132,-155,-183,-199,-211,-230,-235,-186,-88},
            {16,-8,-18,14,33,-12,-51,-2,58,6,-80,-26,94,40,-124,-69,149,69,-97,949,3903,6946,6834,2547,-2977,-5585,-3985,-504,1685,1212,-1083,-2982,-1993,2864,9360,13043,11219,5893,1869,1932,4577,6346,5356,2251,-1226,-3619,-4275,-3581,-2889,-3469,-5182,-6547,-6395,-5151,-4206,-4282,-4788,-4702,-3680,-2179,-845,-34,217,107,29,381,1213,2117,2613,2606,2357,2086,1797,1483,1259,1152,964,547,102,-45,89,120,-210,-741,-1185,-1487,-1756,-1988,-2086,-2081,-2119,-2230,-2258,-2072,-1716,-1311,-922,-583,-345,-215,-98,98,329,452,423,358,404,594,840,1033,1109,1053,882,637,392,224,161,142,68,-99,-285,-391,-390,-350,-356,-442,-579,-706,-760,-711,-590,-470,-399,-359,-311,-251,-210,-194,-177,-143,-116,-120,-133,-112,-43,40,104,145,169,168,132,83,53,40,12,-54,-138,-197,-206,-172,-129,-114,-151,-228,-304,-342,-341,-331,-336,-354,-366,-348,-288,-203,-126,-83,-70,-68,-64,-63,-71,-85,-101,-108,-91,-38,36,91,100,69,26,-11,-37,-56,-75,-98,-118,-123,-107,-84,-72,-73,-80,-90,-101,-108,-103,-84,-56,-24,12,44,58,42,-1,-58,-115,-166,-208,-238,-249,-239,-213,-185,-164,-154,-156,-168,-187,-209,-230,-250,-264,-261,-233,-187,-142,-111,-96,-89,-84,-82,-83,-85,-84,-79,-70,-57,-41,-22,-2,10,7,-6,-15,-10}
        },
        {    // H10e160a.wav
            {-3,-2,-1,-3,-2,1,1,-1,-1,-1,-3,-4,-1,2,-1,-3,2,5,-3,-8,2,10,-4,-20,-7,15,3,-26,-13,28,19,-33,-19,59,51,21,478,1840,3577,4278,2937,113,-2431,-3259,-2325,-723,307,212,-504,-505,1388,4901,8032,8538,5989,2271,-50,157,1963,3485,3426,1799,-395,-2023,-2594,-2479,-2457,-2986,-3839,-4384,-4170,-3265,-2153,-1382,-1243,-1611,-2013,-1932,-1212,-213,484,603,407,389,758,1281,1583,1512,1192,834,588,527,643,812,849,661,329,18,-161,-205,-186,-211,-371,-663,-961,-1121,-1122,-1065,-1027,-985,-867,-666,-439,-233,-47,123,246,275,205,89,5,-2,47,87,71,12,-41,-67,-94,-165,-292,-445,-568,-614,-573,-485,-414,-402,-444,-499,-518,-477,-389,-300,-261,-277,-299,-263,-159,-35,55,97,108,102,81,53,37,36,30,5,-30,-51,-49,-35,-27,-37,-72,-126,-177,-202,-203,-207,-241,-298,-343,-343,-296,-231,-181,-163,-174,-196,-209,-200,-167,-126,-97,-86,-81,-62,-26,11,28,18,-10,-41,-67,-84,-93,-98,-106,-115,-117,-102,-76,-56,-58,-82,-121,-165,-209,-244,-263,-262,-243,-218,-191,-164,-142,-131,-132,-137,-139,-129,-101,-56,-5,40,70,84,80,55,16,-27,-68,-107,-140,-160,-164,-156,-143,-129,-121,-126,-145,-165,-178,-190,-209,-224,-219,-201,-185,-168,-127,-59},
            {-4,13,12,-12,-11,22,23,-26,-40,20,48,-24,-71,17,92,-12,-125,2,156,-12,6,1429,4360,6669,5776,1661,-2748,-4483,-3236,-973,321,-26,-1409,-2207,-431,4479,10153,12675,10298,5358,1918,1855,3720,4941,4223,1924,-856,-3003,-3860,-3667,-3445,-4011,-5108,-5801,-5636,-5068,-4728,-4637,-4347,-3606,-2611,-1686,-958,-407,-34,177,381,789,1418,2024,2356,2395,2286,2086,1741,1277,877,684,640,585,459,294,94,-174,-479,-759,-1023,-1335,-1672,-1913,-2010,-2060,-2149,-2208,-2105,-1825,-1468,-1117,-779,-461,-200,-6,151,272,314,261,185,185,308,530,786,986,1045,934,709,464,265,129,58,43,42,0,-91,-185,-237,-257,-289,-365,-476,-585,-652,-648,-577,-474,-388,-341,-324,-315,-300,-276,-245,-212,-189,-179,-170,-144,-89,-8,85,163,194,165,106,68,68,72,35,-49,-144,-211,-229,-194,-132,-96,-126,-205,-279,-309,-308,-307,-318,-328,-322,-292,-232,-149,-75,-45,-67,-114,-151,-162,-146,-115,-83,-61,-44,-21,10,39,56,57,36,-4,-49,-81,-94,-95,-92,-80,-56,-33,-22,-23,-29,-41,-64,-93,-112,-112,-97,-71,-37,-1,23,20,-10,-57,-108,-158,-202,-231,-235,-214,-184,-163,-160,-169,-181,-195,-214,-238,-261,-276,-276,-256,-216,-166,-119,-84,-63,-50,-42,-40,-47,-59,-68,-64,-48,-26,-3,20,40,49,39,17}
        },
        {    // H10e165a.wav
            {-2,-3,-1,2,0,-3,-2,0,-3,-6,-2,2,-1,-4,2,7,-1,-8,1,11,-2,-21,-9,17,7,-26,-17,29,25,-36,-33,57,65,10,421,1824,3758,4698,3409,345,-2585,-3679,-2750,-964,268,268,-475,-533,1419,5183,8645,9304,6555,2399,-274,-97,1945,3719,3725,1961,-452,-2247,-2864,-2682,-2557,-3051,-3991,-4703,-4621,-3724,-2494,-1558,-1297,-1632,-2077,-2056,-1335,-238,601,790,521,350,637,1232,1696,1736,1400,934,587,499,650,852,867,605,207,-99,-194,-126,-26,-35,-248,-651,-1085,-1360,-1421,-1376,-1341,-1307,-1190,-956,-653,-343,-67,135,224,218,208,279,417,522,514,413,306,255,249,228,143,-26,-252,-474,-620,-656,-618,-591,-628,-699,-721,-642,-491,-351,-297,-350,-461,-544,-523,-384,-182,1,108,134,109,72,48,51,75,99,96,60,17,1,23,59,74,48,-13,-82,-135,-163,-181,-210,-259,-317,-362,-370,-336,-277,-225,-206,-219,-236,-231,-206,-176,-153,-137,-125,-116,-97,-56,-3,31,24,-12,-50,-70,-75,-72,-68,-67,-70,-71,-63,-45,-27,-24,-45,-87,-137,-182,-221,-259,-288,-289,-254,-200,-153,-129,-125,-134,-152,-166,-162,-131,-79,-12,63,131,172,170,129,64,-9,-79,-138,-180,-206,-215,-209,-193,-176,-165,-161,-164,-177,-197,-211,-214,-211,-206,-190,-156,-120,-102,-97,-80,-40},
            {2,-6,-1,13,7,-12,-5,21,10,-31,-27,26,29,-38,-51,36,67,-43,-97,44,119,-59,153,1747,4462,6259,5151,1459,-2353,-4057,-3419,-1730,-414,-251,-1064,-1450,522,5274,10405,12343,9768,4968,1544,1166,2748,4143,3983,2172,-483,-2815,-3959,-3959,-3670,-3882,-4617,-5326,-5584,-5389,-4915,-4255,-3472,-2716,-2130,-1687,-1220,-635,-31,418,689,946,1344,1828,2204,2337,2229,1924,1469,982,658,597,683,699,542,264,-52,-346,-566,-693,-805,-1037,-1421,-1830,-2115,-2236,-2230,-2111,-1874,-1559,-1241,-956,-684,-399,-124,98,239,292,275,227,196,211,289,440,641,815,865,759,556,350,201,114,79,73,62,27,-19,-52,-74,-117,-204,-329,-474,-612,-706,-716,-639,-521,-424,-374,-357,-350,-345,-337,-314,-270,-220,-184,-161,-130,-72,15,112,185,204,168,110,74,70,68,33,-43,-132,-200,-224,-205,-169,-151,-171,-219,-266,-291,-295,-291,-290,-295,-296,-271,-207,-119,-51,-35,-70,-126,-177,-204,-204,-180,-139,-90,-36,18,64,87,80,47,0,-48,-83,-100,-102,-97,-84,-59,-27,-4,-2,-19,-46,-77,-107,-130,-139,-134,-116,-87,-47,-6,18,16,-9,-44,-84,-126,-165,-196,-214,-221,-221,-217,-212,-209,-210,-219,-239,-265,-285,-289,-275,-246,-203,-148,-92,-49,-25,-13,-12,-26,-52,-73,-72,-54,-32,-7,27,60,66,37}
        },
        {    // H10e170a.wav
            {-4,0,1,-1,-2,-2,-4,-6,-2,2,-1,-4,2,7,-1,-9,0,12,-1,-24,-14,17,11,-28,-24,27,30,-37,-44,50,72,7,389,1827,3923,5077,3858,596,-2700,-4079,-3181,-1211,234,322,-469,-585,1448,5475,9250,10047,7130,2592,-415,-310,1917,3924,3996,2081,-568,-2516,-3136,-2862,-2649,-3124,-4127,-4958,-5000,-4164,-2884,-1798,-1368,-1616,-2097,-2181,-1525,-375,616,955,739,514,704,1241,1724,1833,1545,1057,627,457,591,849,940,712,278,-117,-311,-303,-190,-113,-215,-546,-990,-1347,-1517,-1563,-1571,-1527,-1359,-1072,-770,-552,-417,-288,-106,117,324,472,559,608,635,642,632,616,593,531,398,194,-48,-288,-488,-617,-667,-670,-668,-671,-652,-596,-530,-495,-497,-516,-536,-547,-527,-450,-319,-182,-86,-35,3,48,86,96,79,53,34,31,46,77,114,145,156,133,72,-12,-84,-121,-132,-152,-202,-277,-349,-388,-378,-323,-254,-208,-204,-228,-252,-254,-235,-207,-183,-168,-157,-140,-107,-61,-18,1,-8,-31,-49,-52,-47,-44,-46,-50,-49,-40,-25,-10,-5,-21,-61,-119,-177,-221,-245,-252,-242,-214,-175,-140,-125,-132,-153,-177,-191,-185,-153,-95,-21,55,121,166,180,156,100,28,-45,-113,-171,-215,-244,-258,-256,-238,-213,-194,-188,-192,-203,-221,-237,-238,-219,-191,-162,-126,-81,-45,-39,-54,-58,-33},
            {-3,3,2,-3,3,11,3,-9,2,19,3,-28,-17,24,17,-35,-34,38,47,-46,-68,54,84,-52,278,1877,4378,5951,4901,1485,-2217,-4163,-3830,-2129,-497,-27,-700,-1018,997,5640,10460,12076,9349,4484,922,409,2106,3908,4158,2460,-379,-2944,-4147,-3989,-3444,-3500,-4319,-5293,-5739,-5436,-4606,-3613,-2759,-2215,-1975,-1817,-1431,-703,130,688,848,883,1140,1659,2161,2357,2167,1691,1120,700,611,778,892,722,349,16,-175,-311,-460,-580,-667,-845,-1218,-1696,-2070,-2219,-2177,-2026,-1794,-1487,-1139,-802,-509,-262,-63,82,169,216,247,278,313,352,396,447,498,543,583,609,578,449,248,80,29,70,104,74,6,-52,-100,-165,-259,-372,-501,-644,-762,-797,-727,-594,-470,-392,-360,-358,-361,-336,-268,-183,-130,-128,-145,-126,-48,69,180,242,234,172,100,61,56,48,2,-77,-158,-207,-210,-174,-133,-129,-179,-256,-310,-319,-302,-288,-287,-293,-289,-261,-203,-130,-72,-50,-63,-95,-128,-149,-147,-128,-108,-92,-67,-23,30,68,76,54,10,-46,-94,-120,-123,-111,-88,-58,-30,-12,-11,-26,-56,-96,-138,-167,-176,-163,-129,-77,-18,30,55,57,41,7,-45,-107,-165,-209,-238,-249,-244,-231,-223,-225,-235,-250,-265,-276,-280,-274,-257,-223,-171,-112,-60,-20,5,6,-16,-46,-62,-61,-53,-36,-4,34,48,28}
        },
        {    // H10e175a.wav
            {1,-1,-1,-1,-3,-7,-3,3,1,-4,1,8,2,-8,0,13,1,-24,-15,18,15,-25,-26,27,35,-32,-47,45,72,3,370,1830,4043,5377,4263,900,-2686,-4365,-3587,-1508,150,369,-449,-654,1408,5662,9751,10734,7741,2915,-403,-442,1863,4061,4242,2231,-659,-2808,-3453,-3059,-2719,-3156,-4211,-5143,-5307,-4581,-3338,-2161,-1535,-1593,-2003,-2161,-1639,-568,460,924,846,705,904,1395,1819,1907,1652,1204,742,458,487,751,950,823,394,-76,-355,-395,-297,-213,-292,-598,-1040,-1422,-1617,-1659,-1640,-1577,-1425,-1189,-946,-748,-574,-380,-173,9,154,286,429,571,675,720,725,729,744,735,645,450,185,-85,-305,-443,-487,-460,-423,-435,-501,-573,-600,-579,-551,-557,-599,-643,-648,-589,-473,-334,-210,-124,-76,-53,-41,-29,-11,10,24,28,33,57,109,176,227,228,164,64,-20,-55,-56,-69,-127,-223,-320,-379,-378,-322,-246,-199,-206,-244,-270,-264,-241,-226,-229,-242,-247,-222,-160,-80,-18,1,-17,-47,-64,-59,-39,-21,-19,-31,-39,-29,-5,16,17,-13,-72,-142,-193,-209,-197,-177,-159,-143,-127,-116,-112,-117,-134,-164,-196,-210,-187,-128,-46,38,104,141,147,129,93,43,-17,-83,-150,-210,-253,-271,-268,-257,-245,-231,-218,-215,-225,-237,-242,-239,-226,-198,-153,-105,-68,-44,-28,-23,-35,-54,-55,-30},
            {-2,-6,-3,3,1,-3,3,10,2,-9,1,15,1,-26,-16,18,13,-29,-26,32,36,-40,-53,48,68,-26,345,1888,4255,5758,4767,1414,-2349,-4398,-4015,-2095,-274,217,-509,-812,1237,5777,10353,11738,8882,3935,306,-143,1829,3970,4361,2533,-504,-3090,-4105,-3724,-3103,-3266,-4264,-5333,-5712,-5215,-4173,-3063,-2256,-1920,-1944,-1947,-1525,-637,299,793,794,731,1023,1641,2183,2302,1970,1405,880,610,648,835,902,709,341,-27,-297,-441,-451,-385,-420,-708,-1184,-1613,-1849,-1951,-2023,-2029,-1856,-1493,-1052,-651,-339,-132,-40,-30,-10,89,243,374,443,472,498,532,564,585,581,535,438,312,198,123,80,38,-24,-99,-167,-214,-242,-269,-330,-450,-614,-760,-819,-775,-669,-565,-487,-424,-362,-299,-239,-178,-122,-87,-87,-110,-119,-79,14,132,227,262,228,150,73,31,23,18,-19,-93,-178,-236,-240,-197,-145,-129,-170,-249,-323,-358,-353,-333,-320,-316,-300,-250,-167,-79,-23,-13,-38,-75,-104,-110,-93,-69,-62,-70,-76,-63,-31,5,29,32,10,-30,-73,-106,-125,-132,-126,-106,-76,-51,-42,-52,-78,-117,-159,-190,-195,-170,-118,-46,31,92,117,104,62,5,-58,-121,-176,-216,-240,-249,-247,-241,-235,-233,-238,-251,-268,-282,-286,-275,-246,-200,-141,-82,-38,-14,-9,-15,-25,-37,-46,-47,-38,-22,-8,-1}
        },
        {    // H10e180a.wav
            {-3,-1,-3,-6,-3,3,1,-4,1,8,1,-9,-1,13,2,-23,-17,14,12,-27,-27,25,33,-34,-50,41,66,-7,361,1849,4141,5595,4580,1203,-2554,-4495,-3913,-1840,-28,346,-448,-720,1341,5760,10117,11312,8359,3395,-164,-430,1782,4064,4400,2427,-637,-3050,-3831,-3360,-2846,-3185,-4267,-5286,-5542,-4917,-3771,-2614,-1869,-1708,-1932,-2036,-1583,-617,346,809,784,731,1031,1601,2043,2077,1743,1261,827,578,571,733,859,759,417,-13,-347,-480,-418,-290,-304,-599,-1098,-1553,-1779,-1802,-1770,-1749,-1668,-1435,-1064,-668,-362,-188,-111,-74,-23,76,232,419,582,674,692,682,685,693,658,538,336,106,-70,-134,-106,-80,-142,-284,-421,-481,-470,-446,-453,-507,-607,-729,-812,-786,-639,-445,-303,-247,-238,-223,-176,-107,-38,3,-3,-43,-70,-37,57,165,235,246,208,141,70,19,-5,-24,-73,-162,-257,-309,-297,-244,-198,-193,-229,-277,-307,-313,-305,-295,-289,-283,-269,-231,-164,-85,-26,-8,-24,-54,-80,-89,-80,-62,-50,-47,-43,-24,4,22,15,-15,-56,-96,-128,-149,-158,-159,-150,-130,-101,-79,-76,-94,-123,-154,-180,-192,-180,-139,-77,-8,54,97,113,103,73,27,-30,-95,-159,-212,-247,-262,-263,-256,-247,-240,-239,-245,-257,-269,-273,-263,-237,-196,-144,-90,-43,-15,-11,-24,-40,-52,-59,-57,-43,-19},
            {-3,-1,-3,-6,-3,3,1,-4,1,8,1,-9,-1,13,2,-23,-17,14,12,-27,-27,25,33,-34,-50,41,66,-7,361,1849,4141,5595,4580,1203,-2554,-4495,-3913,-1840,-28,346,-448,-720,1341,5760,10117,11312,8359,3395,-164,-430,1782,4064,4400,2427,-637,-3050,-3831,-3360,-2846,-3185,-4267,-5286,-5542,-4917,-3771,-2614,-1869,-1708,-1932,-2036,-1583,-617,346,809,784,731,1031,1601,2043,2077,1743,1261,827,578,571,733,859,759,417,-13,-347,-480,-418,-290,-304,-599,-1098,-1553,-1779,-1802,-1770,-1749,-1668,-1435,-1064,-668,-362,-188,-111,-74,-23,76,232,419,582,674,692,682,685,693,658,538,336,106,-70,-134,-106,-80,-142,-284,-421,-481,-470,-446,-453,-507,-607,-729,-812,-786,-639,-445,-303,-247,-238,-223,-176,-107,-38,3,-3,-43,-70,-37,57,165,235,246,208,141,70,19,-5,-24,-73,-162,-257,-309,-297,-244,-198,-193,-229,-277,-307,-313,-305,-295,-289,-283,-269,-231,-164,-85,-26,-8,-24,-54,-80,-89,-80,-62,-50,-47,-43,-24,4,22,15,-15,-56,-96,-128,-149,-158,-159,-150,-130,-101,-79,-76,-94,-123,-154,-180,-192,-180,-139,-77,-8,54,97,113,103,73,27,-30,-95,-159,-212,-247,-262,-263,-256,-247,-240,-239,-245,-257,-269,-273,-263,-237,-196,-144,-90,-43,-15,-11,-24,-40,-52,-59,-57,-43,-19}
        }
    },
    {    // elev20
        {    // H20e000a.wav
            {2,-8,-5,6,1,-11,2,25,9,-24,-5,41,19,-50,-34,57,50,-70,-80,75,115,-78,-148,91,176,-62,534,3194,6680,7579,4267,-512,-2683,-1917,-1656,-3846,-5863,-4120,783,4635,4997,3967,5026,8602,11782,11603,7678,2094,-2226,-3271,-1227,1489,1997,-693,-5043,-8609,-9984,-9217,-7094,-4624,-2917,-2687,-3523,-4020,-3115,-1228,216,416,23,237,1357,2551,2943,2551,2058,1974,2247,2510,2435,1903,1084,363,32,22,58,67,198,468,617,463,186,65,68,-99,-592,-1266,-1893,-2349,-2559,-2431,-1975,-1401,-999,-898,-966,-909,-510,170,801,1070,977,810,808,942,1009,875,556,154,-210,-438,-531,-588,-709,-883,-1034,-1134,-1192,-1170,-1000,-713,-458,-369,-427,-520,-573,-592,-593,-556,-452,-284,-89,78,171,164,85,0,-30,7,72,114,115,94,81,94,136,194,236,219,122,-27,-167,-257,-300,-326,-359,-397,-423,-424,-401,-361,-312,-265,-239,-246,-273,-286,-263,-213,-157,-93,-11,82,156,191,182,130,37,-71,-147,-165,-141,-104,-69,-36,-13,-6,-10,-24,-61,-128,-205,-258,-268,-240,-196,-157,-135,-128,-119,-104,-100,-127,-174,-208,-209,-178,-122,-50,22,70,85,72,31,-38,-118,-174,-189,-177,-158,-135,-106,-74,-47,-33,-43,-82,-128,-148,-136,-115,-97,-67,-8,61,108,121,103,46,-41,-111,-125,-114,-137,-185,-182,-97},
            {2,-8,-5,6,1,-11,2,25,9,-24,-5,41,19,-50,-34,57,50,-70,-80,75,115,-78,-148,91,176,-62,534,3194,6680,7579,4267,-512,-2683,-1917,-1656,-3846,-5863,-4120,783,4635,4997,3967,5026,8602,11782,11603,7678,2094,-2226,-3271,-1227,1489,1997,-693,-5043,-8609,-9984,-9217,-7094,-4624,-2917,-2687,-3523,-4020,-3115,-1228,216,416,23,237,1357,2551,2943,2551,2058,1974,2247,2510,2435,1903,1084,363,32,22,58,67,198,468,617,463,186,65,68,-99,-592,-1266,-1893,-2349,-2559,-2431,-1975,-1401,-999,-898,-966,-909,-510,170,801,1070,977,810,808,942,1009,875,556,154,-210,-438,-531,-588,-709,-883,-1034,-1134,-1192,-1170,-1000,-713,-458,-369,-427,-520,-573,-592,-593,-556,-452,-284,-89,78,171,164,85,0,-30,7,72,114,115,94,81,94,136,194,236,219,122,-27,-167,-257,-300,-326,-359,-397,-423,-424,-401,-361,-312,-265,-239,-246,-273,-286,-263,-213,-157,-93,-11,82,156,191,182,130,37,-71,-147,-165,-141,-104,-69,-36,-13,-6,-10,-24,-61,-128,-205,-258,-268,-240,-196,-157,-135,-128,-119,-104,-100,-127,-174,-208,-209,-178,-122,-50,22,70,85,72,31,-38,-118,-174,-189,-177,-158,-135,-106,-74,-47,-33,-43,-82,-128,-148,-136,-115,-97,-67,-8,61,108,121,103,46,-41,-111,-125,-114,-137,-185,-182,-97}
        },
        {    // H20e005a.wav
            {-8,1,1,-5,-2,5,-2,-8,8,21,1,-20,4,35,3,-46,-13,55,23,-73,-47,83,74,-88,-89,114,105,-44,807,3423,6274,6456,3186,-745,-2160,-1390,-1450,-3531,-5130,-3454,718,3995,4593,4140,5159,7931,10340,10140,6866,2076,-1684,-2527,-649,1672,1884,-755,-4813,-8142,-9416,-8530,-6229,-3755,-2405,-2711,-3844,-4212,-2976,-901,471,476,-79,36,1098,2295,2765,2464,1987,1832,1998,2159,2009,1497,862,428,297,275,178,110,264,549,636,402,110,37,86,-57,-526,-1160,-1739,-2148,-2319,-2198,-1836,-1413,-1098,-903,-714,-420,-9,424,728,809,724,629,633,702,721,610,372,68,-218,-431,-569,-672,-755,-799,-809,-839,-921,-997,-976,-842,-675,-560,-516,-520,-553,-597,-620,-588,-484,-313,-104,87,190,168,67,-18,-22,41,108,131,109,71,48,60,107,169,202,166,57,-83,-201,-273,-309,-327,-337,-341,-342,-338,-322,-289,-246,-213,-207,-226,-248,-249,-220,-174,-126,-79,-25,39,100,145,153,111,25,-74,-149,-180,-174,-142,-91,-31,16,34,24,-4,-50,-119,-200,-264,-284,-256,-204,-157,-129,-119,-118,-119,-126,-143,-166,-180,-170,-134,-78,-15,42,77,79,46,-10,-75,-134,-175,-187,-175,-154,-140,-131,-113,-83,-60,-65,-89,-111,-114,-99,-74,-47,-19,17,64,109,124,94,37,-20,-73,-129,-169,-153,-79},
            {-12,1,10,-6,-10,18,24,-16,-28,25,47,-25,-69,17,86,-14,-119,-3,155,32,-186,-52,222,51,20,1866,5762,8594,6924,1608,-2628,-2967,-1908,-3246,-6193,-6183,-1364,4419,6384,4741,3994,7062,11879,13928,10851,4238,-2031,-4619,-2866,807,2681,679,-4073,-8573,-10597,-9994,-7907,-5545,-3791,-3186,-3591,-3998,-3308,-1550,21,309,-293,-352,890,2618,3443,2972,2067,1728,2121,2704,2914,2544,1723,791,115,-170,-210,-147,67,447,737,656,311,97,146,137,-286,-1087,-1935,-2551,-2814,-2679,-2208,-1643,-1285,-1227,-1272,-1126,-651,33,643,954,982,945,1011,1120,1103,909,627,336,46,-224,-433,-595,-788,-1036,-1258,-1362,-1330,-1170,-874,-496,-206,-161,-325,-504,-560,-529,-510,-514,-468,-320,-102,99,200,168,43,-81,-125,-83,-12,36,55,67,90,126,172,220,248,225,144,30,-76,-157,-226,-301,-378,-437,-463,-457,-427,-375,-311,-249,-218,-233,-278,-312,-300,-241,-166,-99,-34,36,104,150,156,118,42,-52,-130,-162,-149,-114,-77,-48,-31,-29,-36,-42,-54,-91,-154,-218,-253,-249,-216,-171,-128,-100,-90,-90,-97,-120,-163,-210,-233,-219,-169,-92,-1,81,129,128,82,3,-88,-164,-199,-194,-172,-154,-136,-106,-63,-23,-8,-32,-87,-144,-170,-157,-125,-92,-51,10,79,117,102,44,-29,-93,-135,-148,-143,-145,-165,-175,-140,-66}
        },
        {    // H20e010a.wav
            {2,-6,-5,0,-2,-4,1,3,-5,-4,12,15,-5,-13,13,25,-11,-35,9,47,-6,-66,-6,85,28,-91,-29,116,32,62,1251,3794,5876,5231,2019,-966,-1593,-962,-1611,-3727,-4669,-2484,1423,4002,4210,3882,5127,7785,9700,8937,5480,1191,-1547,-1520,408,1961,1277,-1680,-5342,-7903,-8442,-7135,-4930,-3089,-2552,-3248,-4041,-3696,-2080,-314,405,42,-346,152,1357,2352,2535,2127,1729,1660,1790,1826,1604,1186,778,542,447,350,232,247,445,601,477,170,10,107,187,-60,-623,-1246,-1723,-1998,-2058,-1905,-1623,-1342,-1101,-805,-358,182,618,770,623,354,203,269,439,530,471,319,135,-82,-327,-538,-660,-706,-719,-718,-710,-713,-742,-771,-765,-736,-717,-698,-640,-550,-496,-525,-594,-604,-497,-298,-81,84,151,118,30,-41,-40,24,91,104,63,11,-1,39,102,144,133,66,-34,-132,-207,-256,-287,-301,-299,-285,-265,-237,-201,-164,-140,-146,-178,-217,-239,-226,-185,-138,-105,-82,-51,-5,44,73,66,23,-41,-102,-143,-160,-154,-122,-71,-24,-1,3,1,-11,-54,-127,-201,-246,-258,-245,-212,-167,-127,-109,-107,-109,-115,-130,-149,-155,-138,-103,-54,3,53,78,68,28,-33,-104,-165,-197,-202,-196,-189,-175,-149,-117,-86,-61,-50,-63,-88,-98,-81,-52,-28,-1,41,84,106,104,82,35,-42,-114,-126,-68},
            {10,0,-14,8,35,6,-37,-4,57,18,-72,-39,83,60,-103,-96,118,148,-121,-190,143,225,-118,673,4097,8401,9255,4882,-1069,-3695,-2942,-3003,-5718,-7478,-4275,2322,6762,6446,4620,5873,10541,14569,13887,8026,203,-5122,-5286,-1384,2433,2313,-2105,-7780,-11303,-11489,-9322,-6413,-4045,-3052,-3525,-4425,-4191,-2282,48,981,173,-816,-286,1700,3492,3746,2730,1742,1667,2343,3036,3134,2493,1431,477,-50,-251,-346,-279,130,705,949,665,245,142,260,101,-599,-1621,-2552,-3087,-3105,-2694,-2163,-1833,-1722,-1556,-1126,-523,37,462,779,999,1110,1145,1152,1109,969,740,481,216,-68,-374,-688,-1013,-1331,-1546,-1537,-1291,-922,-560,-276,-106,-84,-198,-355,-450,-460,-436,-419,-391,-311,-159,39,212,268,162,-47,-220,-255,-170,-66,-13,-1,21,71,139,210,268,281,220,98,-36,-146,-233,-314,-386,-433,-453,-446,-410,-345,-268,-210,-191,-211,-252,-280,-262,-196,-119,-69,-43,-11,38,83,103,86,31,-55,-142,-191,-195,-177,-155,-121,-72,-32,-17,-19,-28,-55,-115,-188,-233,-233,-202,-155,-105,-69,-63,-82,-105,-130,-170,-221,-251,-233,-169,-81,14,100,157,172,144,79,-16,-120,-200,-231,-220,-192,-161,-124,-79,-37,-17,-28,-67,-118,-157,-168,-153,-120,-71,-3,71,120,120,71,-8,-91,-150,-176,-179,-178,-181,-172,-136,-80,-30,-4}
        },
        {    // H20e015a.wav
            {-3,2,0,-4,-3,-1,-3,-4,1,2,-4,-1,11,9,-8,-8,15,16,-18,-26,16,34,-20,-53,14,72,-1,-80,5,98,3,186,1512,3811,5290,4276,1424,-805,-1127,-912,-1994,-3812,-3958,-1422,1929,3630,3525,3599,5291,7773,8938,7537,4198,806,-886,-426,1055,1714,428,-2402,-5326,-7020,-7056,-5858,-4276,-3161,-2950,-3361,-3556,-2876,-1514,-350,-33,-294,-289,438,1492,2139,2108,1748,1520,1535,1598,1522,1299,1036,836,723,634,507,378,332,362,353,254,174,212,270,134,-264,-777,-1220,-1521,-1681,-1695,-1584,-1417,-1229,-956,-525,9,465,665,559,256,-34,-130,-5,198,310,275,138,-55,-284,-499,-624,-641,-613,-609,-626,-624,-598,-576,-570,-572,-579,-595,-608,-598,-570,-550,-550,-552,-523,-442,-312,-158,-28,31,14,-28,-42,-22,-2,-13,-46,-69,-57,-13,44,90,108,89,34,-45,-125,-187,-219,-225,-216,-202,-186,-164,-139,-115,-99,-94,-107,-140,-183,-212,-213,-192,-163,-133,-100,-69,-47,-36,-31,-36,-56,-88,-117,-132,-131,-121,-104,-83,-62,-44,-32,-27,-35,-64,-114,-172,-217,-230,-209,-172,-141,-121,-104,-86,-76,-85,-108,-128,-135,-127,-103,-62,-11,30,47,38,9,-40,-105,-172,-219,-229,-209,-185,-171,-158,-127,-85,-58,-60,-77,-86,-81,-68,-46,-12,27,57,80,102,107,70,3,-43,-35},
            {-9,-7,27,28,-24,-32,36,56,-38,-83,30,105,-29,-147,12,193,19,-236,-38,292,40,-26,2205,6877,10267,8382,2200,-3002,-4128,-3698,-5299,-7717,-6469,-562,5429,7052,5502,5650,9690,14608,15705,11207,3392,-3481,-6008,-3744,410,2268,-281,-5678,-10458,-12303,-11245,-8578,-5570,-3268,-2517,-3300,-4265,-3745,-1551,652,1160,194,-412,577,2436,3525,3203,2277,1815,2094,2697,3100,2965,2217,1154,279,-165,-350,-426,-218,382,969,1001,540,205,315,437,-22,-1080,-2226,-3016,-3379,-3425,-3219,-2778,-2149,-1451,-843,-434,-172,134,584,1039,1275,1246,1103,992,933,882,783,560,141,-444,-1053,-1540,-1805,-1771,-1416,-883,-446,-270,-267,-240,-146,-98,-165,-266,-305,-295,-304,-338,-329,-223,-35,167,293,275,111,-103,-245,-269,-227,-189,-163,-112,-25,72,155,227,285,288,199,27,-166,-313,-387,-405,-405,-404,-392,-352,-293,-240,-209,-188,-172,-175,-193,-193,-149,-87,-54,-52,-36,15,70,92,76,27,-61,-178,-278,-316,-296,-249,-195,-132,-70,-33,-24,-26,-35,-71,-133,-190,-211,-195,-159,-115,-76,-59,-70,-95,-124,-165,-213,-245,-236,-184,-101,1,109,198,242,228,159,46,-90,-207,-269,-271,-240,-199,-150,-95,-47,-24,-37,-81,-137,-175,-183,-167,-142,-106,-45,39,112,139,108,33,-59,-140,-187,-203,-209,-216,-208,-165,-94,-29,3,6,2}
        },
        {    // H20e020a.wav
            {-5,-5,0,3,-1,-4,-1,1,-2,-3,2,1,-4,1,12,8,-8,-6,14,12,-15,-17,18,24,-22,-36,25,56,-16,-62,27,80,-4,275,1602,3622,4713,3652,1226,-572,-969,-1153,-2260,-3478,-3027,-653,1884,2981,3037,3658,5485,7420,7863,6262,3464,969,-100,312,1177,1175,-262,-2575,-4670,-5798,-5871,-5198,-4205,-3341,-2940,-2952,-2908,-2372,-1434,-639,-355,-351,-98,583,1335,1726,1708,1551,1454,1400,1323,1246,1205,1170,1087,941,732,471,234,142,220,337,353,284,234,200,58,-258,-650,-968,-1157,-1257,-1317,-1348,-1323,-1184,-877,-425,39,338,370,175,-104,-310,-348,-220,-5,183,230,71,-248,-563,-700,-629,-486,-418,-443,-490,-508,-502,-473,-407,-331,-314,-388,-497,-565,-577,-567,-559,-543,-508,-452,-370,-264,-161,-102,-102,-123,-117,-84,-66,-93,-144,-166,-127,-41,50,115,145,135,79,-12,-100,-148,-152,-136,-122,-114,-105,-89,-71,-58,-59,-74,-103,-136,-165,-184,-192,-191,-184,-173,-158,-138,-118,-102,-90,-83,-85,-105,-137,-162,-165,-147,-118,-89,-62,-39,-26,-28,-48,-82,-121,-152,-166,-160,-138,-114,-100,-97,-95,-85,-72,-72,-90,-115,-131,-130,-113,-79,-36,3,22,17,-11,-57,-114,-165,-199,-213,-213,-207,-193,-168,-132,-94,-69,-63,-72,-79,-69,-40,-8,15,30,50,76,94,88,59,23},
            {4,37,7,-41,-4,64,18,-84,-42,94,60,-121,-100,142,155,-155,-210,183,257,-177,644,4425,9356,10787,6554,5,-3994,-4845,-5697,-7682,-7742,-3351,3009,6476,5968,5379,8408,13925,17191,14703,7248,-987,-5592,-4943,-1225,1380,123,-4288,-8923,-11500,-11735,-10425,-8199,-5528,-3280,-2369,-2724,-3114,-2404,-835,323,395,152,747,2154,3182,3006,2134,1664,2003,2688,3132,3096,2575,1705,809,196,-144,-393,-452,-37,716,1161,917,410,304,583,570,-205,-1526,-2853,-3828,-4293,-4140,-3386,-2325,-1385,-812,-543,-351,-50,382,818,1093,1153,1087,1023,1010,1018,969,753,265,-485,-1310,-1920,-2087,-1762,-1109,-459,-129,-186,-392,-446,-278,-62,36,16,-44,-130,-270,-421,-466,-335,-77,190,366,394,274,70,-118,-232,-288,-324,-322,-244,-113,-8,37,81,177,269,247,83,-139,-315,-411,-444,-431,-384,-327,-280,-238,-193,-156,-137,-131,-127,-129,-135,-121,-76,-29,-15,-23,-9,42,95,106,57,-48,-187,-316,-386,-390,-357,-305,-230,-140,-73,-50,-50,-44,-45,-79,-136,-180,-194,-187,-166,-129,-84,-58,-62,-84,-112,-146,-183,-201,-182,-123,-33,79,197,285,307,247,119,-45,-196,-289,-306,-271,-223,-181,-136,-85,-45,-36,-63,-113,-162,-197,-209,-195,-154,-87,1,90,147,143,80,-16,-109,-178,-219,-235,-233,-215,-179,-115,-34,24,27,-13,-44,-34}
        },
        {    // H20e025a.wav
            {-3,-2,-4,-4,-1,1,-2,-3,-1,-1,-4,-2,2,0,-3,2,10,4,-9,-4,13,8,-16,-15,16,18,-20,-27,23,41,-19,-42,34,58,-8,309,1549,3321,4226,3285,1187,-459,-1021,-1337,-2168,-2886,-2302,-398,1526,2471,2859,3752,5359,6741,6824,5403,3215,1335,487,621,987,723,-472,-2193,-3783,-4823,-5197,-4924,-4146,-3226,-2613,-2465,-2476,-2206,-1562,-871,-464,-295,-46,456,1047,1445,1547,1454,1310,1204,1184,1246,1313,1286,1138,907,619,301,63,42,228,428,471,390,325,299,201,-33,-328,-586,-811,-1066,-1342,-1530,-1506,-1226,-767,-307,-34,-29,-211,-405,-482,-420,-273,-102,38,91,7,-210,-471,-639,-626,-471,-304,-232,-262,-332,-384,-393,-351,-268,-182,-145,-192,-313,-464,-596,-668,-669,-617,-546,-473,-399,-331,-289,-276,-267,-237,-189,-151,-143,-161,-179,-167,-111,-18,82,154,178,154,96,28,-26,-55,-64,-63,-59,-52,-48,-50,-54,-54,-56,-70,-97,-131,-162,-188,-208,-222,-228,-221,-204,-178,-151,-131,-123,-127,-142,-165,-186,-191,-177,-150,-115,-76,-42,-26,-28,-39,-50,-66,-90,-112,-118,-106,-91,-84,-83,-82,-77,-71,-70,-78,-95,-114,-126,-125,-110,-86,-59,-36,-24,-27,-48,-85,-129,-164,-183,-191,-201,-211,-207,-180,-135,-89,-52,-33,-34,-46,-51,-39,-21,-8,7,35,65,68,37},
            {36,-25,-41,36,64,-36,-92,26,113,-28,-159,7,209,27,-258,-56,324,62,-171,1865,6713,10971,10350,4809,-1351,-4815,-6461,-8186,-8813,-5730,303,4967,5677,4934,6987,12362,17132,17084,11524,3404,-3060,-5063,-2938,66,362,-2921,-7522,-10651,-11512,-11040,-9980,-8168,-5623,-3338,-2350,-2405,-2208,-1088,153,405,-110,-10,1423,3195,3767,2872,1675,1317,1871,2696,3224,3170,2465,1365,407,-81,-258,-346,-189,390,1026,1113,665,381,685,1078,691,-748,-2692,-4310,-5005,-4624,-3496,-2277,-1490,-1140,-868,-462,-42,233,408,617,852,1010,1062,1078,1090,1009,700,108,-663,-1361,-1720,-1637,-1239,-766,-411,-259,-302,-438,-504,-380,-107,147,244,164,-39,-299,-531,-625,-504,-205,146,421,545,491,283,15,-192,-281,-294,-292,-279,-231,-157,-87,-24,51,121,134,63,-68,-223,-370,-466,-470,-392,-301,-245,-203,-143,-84,-63,-66,-60,-52,-70,-99,-93,-55,-35,-48,-43,19,98,132,99,11,-124,-281,-403,-444,-421,-383,-337,-261,-163,-80,-34,-19,-32,-86,-168,-231,-244,-221,-186,-147,-103,-63,-41,-36,-46,-78,-126,-161,-156,-112,-37,65,181,276,310,272,173,32,-125,-252,-311,-308,-280,-248,-201,-130,-56,-16,-27,-79,-144,-198,-229,-234,-211,-153,-61,45,132,165,132,44,-67,-163,-224,-252,-259,-243,-196,-124,-48,12,46,41,-2,-53,-68,-37}
        },
        {    // H20e030a.wav
            {-4,-5,-1,0,-3,-4,0,2,-1,-2,0,0,-2,-1,2,1,-1,3,8,2,-7,-1,14,8,-13,-10,18,19,-17,-25,20,40,-9,-34,23,43,1,301,1404,2984,3832,3054,1172,-422,-1054,-1310,-1867,-2366,-1920,-431,1195,2188,2774,3657,4965,6023,6062,4932,3170,1588,765,706,870,610,-327,-1696,-3074,-4148,-4718,-4629,-3910,-2937,-2258,-2128,-2268,-2177,-1664,-997,-539,-333,-113,330,909,1356,1499,1375,1156,1020,1060,1228,1361,1312,1061,703,352,108,61,231,492,652,652,612,633,633,455,88,-322,-660,-951,-1247,-1500,-1595,-1470,-1169,-807,-527,-433,-519,-651,-672,-534,-310,-106,15,26,-77,-260,-447,-543,-500,-349,-176,-71,-75,-165,-271,-326,-301,-206,-87,-5,-15,-129,-308,-492,-634,-711,-719,-666,-581,-499,-445,-419,-408,-397,-373,-329,-268,-208,-171,-157,-144,-107,-47,21,87,144,181,182,145,94,56,39,31,20,2,-21,-51,-80,-95,-89,-72,-65,-83,-122,-168,-207,-231,-243,-246,-241,-228,-209,-189,-173,-164,-165,-176,-188,-189,-175,-152,-127,-99,-70,-46,-31,-19,-8,-3,-16,-45,-76,-94,-94,-82,-65,-51,-42,-40,-44,-55,-74,-99,-125,-145,-151,-141,-116,-84,-56,-40,-43,-64,-96,-129,-156,-173,-180,-179,-170,-153,-128,-94,-58,-36,-36,-52,-64,-61,-47,-30,-13,3,11,8},
            {-35,-1,59,19,-83,-56,83,73,-109,-126,113,180,-117,-247,123,307,-161,162,3340,8584,11755,9633,3618,-2282,-6139,-8751,-10124,-8274,-2713,3117,5269,4346,4929,9756,16140,18788,15141,7366,46,-3354,-2554,-244,197,-2488,-6582,-9481,-10385,-10477,-10750,-10562,-8764,-5629,-2915,-1939,-2164,-2016,-842,481,910,673,870,1908,2975,3181,2648,2136,2021,2131,2310,2568,2701,2330,1429,438,-260,-610,-558,52,974,1451,1065,440,517,1204,1301,-78,-2424,-4372,-5024,-4516,-3519,-2578,-1880,-1366,-920,-513,-219,-77,22,233,566,874,1022,1003,872,635,241,-302,-835,-1101,-964,-592,-342,-414,-656,-763,-628,-394,-216,-96,23,113,106,2,-148,-318,-503,-642,-625,-408,-62,287,532,602,473,215,-22,-131,-152,-195,-291,-349,-296,-172,-68,-16,17,38,5,-106,-255,-372,-417,-393,-332,-279,-262,-256,-205,-93,26,91,88,46,-11,-72,-119,-134,-127,-112,-83,-21,61,119,125,78,-25,-177,-340,-447,-468,-436,-390,-326,-229,-121,-45,-17,-36,-97,-193,-289,-336,-318,-257,-180,-101,-36,-1,5,-4,-24,-62,-108,-132,-110,-49,34,133,233,298,296,226,106,-43,-191,-298,-340,-331,-303,-263,-196,-106,-28,2,-26,-94,-174,-237,-263,-252,-209,-131,-21,93,163,163,102,6,-101,-198,-265,-290,-278,-239,-172,-83,1,51,61,45,9,-42,-85,-87,-47}
        },
        {    // H20e035a.wav
            {-2,-2,-4,-4,-2,-2,-3,-4,-2,0,-2,-3,-2,-2,-3,-2,1,0,-3,-1,3,-1,-9,-4,10,7,-11,-10,12,13,-17,-23,17,35,-12,-40,13,44,11,248,1196,2627,3480,2875,1175,-358,-991,-1164,-1565,-2021,-1753,-530,959,1986,2611,3394,4507,5435,5520,4598,3105,1726,950,799,866,644,-102,-1249,-2507,-3597,-4257,-4262,-3610,-2676,-2018,-1923,-2145,-2170,-1747,-1095,-590,-323,-63,392,931,1266,1258,1047,881,893,1047,1208,1244,1102,836,563,376,311,382,580,833,1009,1017,872,647,383,92,-196,-447,-692,-1005,-1388,-1710,-1804,-1608,-1225,-861,-689,-732,-850,-860,-688,-411,-157,-8,15,-81,-252,-405,-442,-347,-190,-57,10,6,-60,-154,-220,-219,-163,-98,-55,-41,-68,-159,-313,-490,-633,-707,-714,-677,-620,-567,-531,-514,-499,-469,-418,-358,-300,-248,-198,-147,-94,-42,3,45,89,137,179,202,198,173,138,101,62,17,-33,-82,-119,-133,-123,-98,-76,-69,-84,-121,-176,-233,-274,-290,-288,-278,-265,-246,-220,-194,-176,-171,-176,-182,-182,-172,-152,-124,-94,-66,-43,-23,-5,6,5,-9,-28,-47,-62,-69,-65,-53,-45,-48,-57,-65,-75,-100,-139,-174,-188,-180,-158,-130,-100,-73,-59,-61,-77,-98,-119,-138,-151,-155,-148,-135,-125,-119,-107,-86,-67,-63,-70,-71,-63,-59,-61,-54,-28},
            {9,55,-8,-85,-14,98,20,-138,-57,170,104,-203,-159,245,195,-278,713,4702,9893,12089,9101,2882,-3272,-7974,-10989,-10954,-6547,235,4703,4677,3469,6009,12694,18592,18607,12341,3931,-1764,-2630,-275,1529,-96,-4720,-9169,-10812,-10093,-9468,-10168,-10812,-9418,-6075,-2915,-1634,-1786,-1778,-942,71,687,1283,2310,3260,3251,2388,1756,2009,2653,2914,2717,2420,2089,1563,935,432,7,-433,-543,89,1103,1572,1219,806,921,944,-121,-2121,-3760,-4145,-3691,-3287,-3125,-2734,-1882,-933,-350,-213,-285,-319,-171,206,702,1038,967,504,-106,-621,-926,-953,-636,-53,461,509,24,-629,-987,-895,-531,-135,184,382,383,158,-181,-457,-592,-640,-662,-639,-514,-281,11,289,473,505,393,238,135,69,-52,-251,-404,-384,-217,-57,-2,-15,-28,-54,-137,-256,-336,-346,-327,-318,-316,-308,-290,-237,-112,66,208,240,173,69,-36,-138,-219,-246,-210,-136,-46,47,121,141,94,-5,-130,-257,-360,-414,-421,-398,-348,-264,-159,-73,-36,-46,-94,-180,-284,-362,-381,-346,-279,-188,-78,24,84,95,73,21,-58,-132,-150,-96,-3,92,180,261,308,288,193,47,-116,-265,-364,-392,-358,-292,-218,-137,-53,6,8,-47,-130,-208,-260,-276,-251,-181,-76,37,127,168,148,78,-20,-124,-215,-279,-304,-287,-233,-151,-56,32,85,89,59,19,-27,-82,-126,-120,-63}
        },
        {    // H20e040a.wav
            {1,0,0,0,-2,-2,0,0,-3,-5,-1,2,1,-2,-1,0,-1,0,4,4,-1,-1,5,4,-3,-1,11,11,-4,-7,10,14,-9,-17,13,31,-5,-29,18,49,8,178,984,2289,3157,2717,1205,-233,-841,-970,-1309,-1783,-1659,-621,764,1779,2395,3095,4078,4930,5076,4348,3088,1860,1096,878,914,768,170,-839,-2023,-3105,-3803,-3877,-3309,-2447,-1837,-1780,-2046,-2111,-1692,-1003,-458,-205,-26,308,726,960,898,715,664,819,1050,1190,1169,1027,867,778,784,839,891,922,921,857,709,514,331,170,-18,-270,-590,-965,-1365,-1706,-1857,-1742,-1429,-1096,-905,-890,-954,-954,-804,-535,-255,-63,10,-16,-112,-235,-314,-288,-162,-8,91,101,35,-67,-157,-198,-184,-141,-95,-54,-34,-66,-171,-329,-486,-601,-664,-688,-686,-666,-640,-611,-571,-515,-453,-398,-351,-299,-235,-164,-98,-42,8,53,92,125,158,195,224,225,190,133,72,17,-31,-71,-100,-114,-117,-112,-103,-92,-85,-97,-135,-195,-260,-309,-328,-316,-284,-246,-216,-200,-191,-178,-160,-146,-143,-147,-144,-131,-111,-85,-54,-23,-3,6,15,27,30,14,-16,-44,-62,-72,-78,-77,-72,-70,-79,-100,-127,-152,-169,-176,-175,-164,-140,-104,-66,-40,-31,-38,-57,-88,-121,-143,-147,-140,-132,-122,-106,-89,-76,-68,-62,-64,-76,-85,-71,-35},
            {49,-48,-86,29,104,-27,-146,3,186,29,-232,-62,293,63,-292,1256,5703,10714,12334,8949,2436,-4429,-9977,-12742,-10877,-4502,2457,5329,4009,3420,7696,15044,19481,17047,9393,1704,-1872,-972,1453,1774,-1428,-6347,-9829,-10466,-9683,-9653,-10622,-10821,-8891,-5670,-3213,-2438,-2387,-1792,-663,151,500,1181,2572,3821,3901,2978,2136,1996,2272,2565,2857,3035,2647,1541,314,-338,-390,-224,85,673,1284,1405,1012,595,303,-343,-1602,-2866,-3350,-3110,-2876,-2971,-2957,-2383,-1453,-713,-397,-326,-276,-157,78,422,691,592,30,-741,-1309,-1406,-1017,-300,477,991,998,507,-186,-696,-808,-571,-175,209,470,523,330,-36,-397,-618,-716,-794,-873,-855,-652,-313,23,256,380,422,393,305,184,43,-114,-251,-296,-220,-95,-21,-15,-27,-36,-79,-166,-245,-273,-276,-307,-364,-400,-378,-284,-115,101,285,349,277,125,-42,-186,-280,-299,-254,-184,-107,-16,77,126,99,18,-78,-179,-282,-360,-392,-386,-360,-306,-211,-103,-33,-19,-43,-104,-211,-338,-424,-428,-367,-274,-160,-31,83,143,140,88,3,-88,-145,-138,-73,19,114,206,281,308,264,147,-23,-205,-349,-418,-414,-363,-285,-189,-83,4,43,23,-45,-140,-231,-287,-290,-240,-151,-39,71,149,171,136,60,-34,-133,-226,-299,-328,-299,-217,-110,-11,61,98,100,72,23,-38,-101,-146,-150,-106,-42}
        },
        {    // H20e045a.wav
            {1,2,0,-2,-1,0,-2,-4,-2,0,-2,-3,-1,2,0,-3,-2,-1,-1,0,2,1,-3,-3,2,2,-3,0,11,11,-5,-12,4,13,-6,-19,6,29,2,-25,10,41,-1,113,785,1956,2821,2543,1248,-55,-633,-769,-1115,-1632,-1617,-709,592,1574,2144,2755,3652,4501,4754,4191,3073,1913,1158,945,1026,958,435,-523,-1662,-2687,-3344,-3443,-2976,-2231,-1675,-1587,-1803,-1879,-1549,-970,-499,-286,-167,50,334,524,585,644,796,986,1117,1188,1266,1356,1378,1260,1013,730,530,493,588,671,599,355,52,-195,-377,-575,-856,-1205,-1522,-1686,-1639,-1436,-1213,-1080,-1048,-1048,-995,-840,-589,-310,-98,-5,-11,-60,-121,-180,-203,-151,-41,51,64,9,-59,-104,-126,-139,-139,-116,-78,-47,-48,-103,-216,-362,-496,-586,-637,-674,-708,-725,-701,-629,-532,-445,-389,-359,-327,-271,-192,-110,-45,-2,29,58,88,119,149,175,186,171,132,81,32,-9,-43,-73,-97,-115,-127,-134,-134,-126,-122,-139,-183,-241,-286,-304,-299,-284,-265,-242,-217,-191,-163,-135,-112,-105,-113,-125,-128,-116,-94,-69,-45,-23,-4,13,25,29,21,0,-31,-62,-82,-87,-86,-89,-99,-108,-111,-116,-130,-149,-162,-167,-165,-154,-128,-88,-50,-25,-18,-27,-48,-76,-108,-138,-153,-147,-126,-108,-97,-82,-59,-48,-65,-92,-90,-48},
            {-38,-56,33,72,-48,-121,32,163,-17,-221,-10,280,-16,-253,1561,6183,11177,12719,9198,2196,-5561,-11702,-13895,-10454,-2848,3897,5593,3692,3865,9257,16487,19232,14896,6818,539,-1038,836,2652,1580,-2547,-7324,-9968,-9895,-9058,-9515,-10952,-11125,-8737,-5166,-2915,-2781,-3262,-2720,-1251,4,694,1488,2664,3510,3464,3034,2993,3196,2975,2389,2212,2644,2864,2160,864,-184,-616,-513,101,1093,1787,1433,185,-949,-1297,-1222,-1438,-2059,-2658,-2953,-3003,-2854,-2414,-1731,-1097,-737,-581,-420,-162,144,408,487,191,-542,-1442,-1991,-1808,-960,96,871,1153,1023,664,222,-177,-387,-321,-51,238,405,430,341,147,-124,-391,-590,-743,-904,-1045,-1055,-868,-535,-168,147,361,435,359,193,38,-52,-90,-107,-107,-83,-55,-42,-29,11,64,69,-13,-154,-289,-370,-393,-377,-342,-286,-182,-11,196,348,367,244,38,-170,-317,-368,-327,-239,-153,-81,-15,38,60,45,3,-68,-179,-311,-410,-439,-405,-334,-237,-126,-34,12,16,-16,-97,-230,-369,-444,-429,-349,-236,-101,36,130,146,96,19,-55,-111,-134,-113,-51,32,120,206,275,295,234,90,-104,-290,-415,-454,-419,-343,-251,-153,-58,14,45,27,-35,-125,-215,-276,-286,-238,-141,-20,90,154,161,120,47,-44,-147,-248,-318,-328,-274,-177,-71,16,70,91,85,62,24,-35,-111,-174,-185,-134,-61,-12}
        },
        {    // H20e050a.wav
            {1,1,2,3,1,-1,0,1,-1,-3,-2,-2,-3,-3,1,3,1,-1,0,2,1,0,1,0,-3,-2,3,3,-1,0,10,11,-4,-13,2,14,-2,-16,5,29,6,-26,0,36,4,73,609,1630,2476,2368,1319,171,-399,-592,-977,-1524,-1578,-776,426,1340,1860,2427,3305,4186,4522,4064,3035,1932,1210,1030,1155,1128,635,-283,-1338,-2239,-2792,-2878,-2505,-1914,-1492,-1470,-1700,-1807,-1572,-1123,-733,-507,-330,-84,202,441,635,854,1106,1319,1439,1477,1441,1299,1049,771,559,437,380,375,395,358,183,-94,-330,-442,-507,-661,-932,-1211,-1374,-1387,-1306,-1213,-1156,-1125,-1071,-949,-762,-551,-359,-209,-107,-52,-35,-49,-95,-160,-206,-191,-119,-40,2,4,-14,-42,-75,-101,-105,-90,-81,-96,-133,-187,-263,-365,-482,-587,-658,-688,-683,-651,-597,-526,-450,-389,-349,-316,-268,-202,-137,-89,-58,-30,5,43,74,93,102,110,119,123,109,70,14,-40,-76,-95,-113,-136,-159,-169,-165,-159,-165,-182,-203,-224,-247,-268,-275,-262,-236,-208,-179,-146,-114,-92,-85,-87,-90,-91,-93,-97,-98,-89,-67,-40,-17,-1,11,16,7,-18,-48,-71,-86,-98,-111,-120,-123,-123,-123,-123,-126,-134,-145,-153,-151,-138,-112,-76,-40,-16,-11,-21,-41,-71,-104,-125,-128,-121,-114,-105,-87,-72,-75,-86,-77,-40},
            {-62,43,79,-47,-122,26,154,-14,-209,-15,259,-18,-246,1505,6099,11310,13273,9922,2418,-6275,-12973,-14773,-10312,-1953,4740,5921,3808,4376,10211,17094,18584,13029,4928,-37,-82,2288,3407,1398,-2973,-7279,-9422,-9361,-8962,-9788,-11152,-10916,-8246,-4865,-3125,-3337,-3767,-3052,-1667,-694,-71,1051,2651,3635,3430,2850,2894,3390,3508,3141,2911,2978,2731,1823,789,289,302,465,709,1006,891,-53,-1323,-1853,-1360,-788,-1105,-2125,-2903,-2955,-2618,-2329,-2081,-1678,-1155,-716,-417,-149,140,340,279,-158,-950,-1851,-2402,-2181,-1185,89,1010,1295,1124,819,521,216,-46,-109,86,374,524,473,333,206,74,-113,-345,-578,-799,-1009,-1165,-1192,-1041,-736,-352,3,220,247,139,18,-34,-33,-36,-56,-57,-24,7,13,31,110,219,256,151,-59,-272,-402,-426,-367,-270,-166,-57,73,209,291,263,129,-50,-212,-324,-372,-356,-297,-222,-142,-52,35,85,75,7,-109,-259,-404,-481,-461,-374,-269,-166,-62,26,65,45,-17,-108,-224,-337,-399,-380,-297,-185,-69,33,101,114,69,-11,-93,-148,-162,-139,-86,-6,102,215,289,285,194,31,-168,-349,-457,-470,-413,-331,-243,-144,-37,45,70,32,-47,-139,-220,-272,-276,-222,-117,6,104,149,141,94,18,-79,-181,-264,-305,-293,-229,-134,-41,24,58,70,66,44,0,-65,-140,-198,-204,-144,-53,10,19}
        },
        {    // H20e055a.wav
            {0,1,0,0,1,2,0,-1,0,1,-1,-3,-2,-1,-2,-2,0,1,0,-2,-1,1,0,-2,-1,0,-2,-4,0,4,2,2,8,8,-5,-13,0,13,2,-13,2,23,4,-28,-7,34,11,40,446,1314,2131,2190,1398,413,-152,-414,-845,-1421,-1550,-876,213,1077,1589,2147,3020,3934,4347,3969,2986,1902,1212,1093,1285,1307,865,52,-835,-1580,-2099,-2324,-2213,-1887,-1633,-1654,-1842,-1878,-1573,-1055,-616,-401,-297,-88,316,811,1203,1351,1254,1045,904,912,985,964,778,498,245,80,10,21,66,55,-71,-253,-371,-400,-450,-621,-872,-1062,-1110,-1058,-1003,-995,-1018,-1015,-938,-780,-587,-416,-291,-199,-132,-99,-115,-173,-241,-283,-276,-216,-124,-36,25,55,53,14,-58,-129,-161,-152,-135,-143,-184,-250,-329,-406,-465,-499,-523,-551,-576,-572,-524,-448,-373,-322,-296,-279,-253,-207,-150,-101,-74,-61,-43,-11,25,51,66,77,84,77,51,12,-30,-69,-105,-137,-160,-173,-178,-177,-173,-170,-174,-185,-198,-206,-209,-211,-213,-210,-197,-175,-148,-119,-89,-65,-55,-62,-77,-91,-103,-116,-124,-115,-86,-50,-24,-9,-1,-1,-16,-46,-77,-96,-104,-110,-119,-128,-136,-138,-134,-128,-122,-118,-120,-126,-129,-119,-96,-70,-46,-26,-13,-13,-27,-50,-73,-95,-113,-121,-116,-110,-114,-116,-93,-45},
            {-1,63,-4,-98,-11,133,35,-179,-77,221,70,-262,1027,5287,10917,13918,11325,3615,-6018,-13617,-15767,-11088,-2156,5146,6596,4263,4434,10114,17019,18292,12258,3987,-441,343,3088,3997,1724,-2566,-6630,-8719,-8799,-8554,-9546,-11203,-11273,-8626,-4944,-2938,-3274,-4126,-3714,-2278,-1099,-472,382,1745,2861,3157,3093,3300,3554,3328,2905,3058,3709,3783,2654,1074,276,591,1349,1732,1273,-94,-1835,-2819,-2261,-800,-69,-912,-2463,-3286,-3009,-2397,-2108,-2009,-1698,-1165,-667,-273,119,441,398,-217,-1269,-2321,-2850,-2515,-1393,-13,969,1259,1085,867,780,697,485,239,158,283,457,527,497,439,345,142,-162,-455,-652,-797,-981,-1197,-1324,-1236,-919,-490,-128,32,-6,-112,-153,-113,-74,-87,-103,-61,20,71,85,138,275,423,447,292,36,-192,-315,-334,-290,-219,-133,-24,107,221,252,176,29,-123,-246,-339,-394,-395,-345,-270,-184,-78,36,108,91,-17,-180,-349,-473,-508,-445,-326,-207,-108,-20,53,87,72,21,-55,-157,-267,-339,-336,-265,-164,-64,22,84,107,80,4,-100,-192,-234,-214,-147,-52,64,185,272,280,192,26,-174,-351,-454,-464,-409,-331,-247,-146,-32,63,102,71,-17,-134,-239,-297,-287,-214,-102,19,116,161,150,96,14,-89,-199,-283,-309,-270,-189,-96,-14,41,67,71,60,29,-26,-97,-166,-212,-211,-150,-47,44,73,42}
        },
        {    // H20e060a.wav
            {0,-1,0,1,0,0,1,2,1,0,0,0,0,-2,-2,0,0,-2,-1,1,2,0,0,1,0,-1,0,1,-1,-3,2,7,5,0,3,7,1,-7,-1,10,6,-5,2,16,2,-23,-5,37,24,25,315,1028,1799,2006,1460,642,92,-226,-700,-1325,-1558,-1014,-7,845,1368,1930,2816,3764,4209,3842,2874,1848,1262,1260,1562,1685,1322,538,-385,-1218,-1869,-2271,-2346,-2114,-1769,-1544,-1497,-1468,-1260,-845,-371,0,239,419,580,677,663,584,543,586,661,675,582,405,196,6,-130,-191,-166,-68,44,84,7,-144,-282,-370,-447,-548,-639,-669,-652,-668,-764,-895,-971,-937,-808,-645,-504,-409,-346,-296,-257,-246,-269,-310,-343,-340,-283,-175,-47,49,79,45,-25,-96,-141,-151,-144,-156,-198,-238,-240,-216,-214,-262,-338,-405,-449,-475,-480,-457,-412,-370,-346,-332,-309,-273,-238,-212,-187,-153,-115,-83,-58,-32,-5,11,12,7,12,21,11,-30,-83,-123,-140,-146,-152,-158,-163,-169,-177,-182,-175,-155,-136,-135,-154,-174,-179,-171,-160,-146,-120,-87,-65,-62,-68,-72,-77,-94,-117,-128,-120,-101,-83,-66,-46,-28,-21,-28,-45,-64,-83,-102,-120,-133,-138,-136,-131,-125,-114,-99,-90,-94,-106,-111,-108,-104,-97,-75,-37,-4,8,4,-4,-23,-57,-91,-107,-114,-134,-153,-133,-66},
            {50,10,-85,-46,111,98,-126,-154,142,185,-211,378,3849,9690,14148,13167,5966,-4436,-13372,-16756,-12775,-3592,4913,7549,5168,4109,8806,16046,18386,12844,4184,-720,108,3209,4440,2509,-1402,-5415,-7974,-8555,-8221,-8712,-10283,-11077,-9394,-6092,-3723,-3465,-4009,-3670,-2524,-1685,-1306,-475,1079,2387,2685,2545,2892,3552,3653,3156,2983,3526,3928,3319,2134,1531,1831,2171,1635,215,-1375,-2354,-2296,-1383,-466,-495,-1557,-2711,-3043,-2657,-2341,-2434,-2488,-2028,-1185,-415,84,377,399,-100,-1171,-2392,-3114,-2924,-1907,-547,589,1170,1229,1051,908,881,875,784,614,456,381,383,428,499,556,501,257,-118,-457,-662,-808,-1017,-1275,-1423,-1324,-1004,-622,-342,-225,-215,-223,-210,-207,-243,-284,-264,-166,-40,73,187,338,507,614,583,404,157,-51,-156,-172,-154,-133,-93,-12,96,184,204,135,-1,-158,-294,-388,-439,-445,-398,-305,-186,-63,35,78,39,-78,-231,-365,-447,-465,-420,-326,-212,-102,-6,72,126,140,105,23,-93,-211,-289,-298,-245,-162,-72,18,95,135,113,24,-104,-228,-303,-303,-233,-121,8,134,232,262,200,56,-126,-295,-408,-446,-416,-344,-250,-143,-29,71,121,98,6,-121,-237,-302,-297,-228,-117,6,107,161,162,120,48,-51,-167,-270,-318,-294,-213,-108,-8,63,95,94,77,46,-11,-97,-182,-229,-220,-161,-66,38,108,110,57}
        },
        {    // H20e065a.wav
            {-1,0,-1,-2,-2,0,1,0,-1,0,1,0,-1,0,-1,-2,-2,0,-1,-3,-3,0,1,-1,-2,-1,-1,-3,-2,0,-1,-2,1,5,3,-2,1,8,3,-10,-8,9,15,0,-10,-2,-1,-12,2,37,30,10,202,780,1503,1827,1492,833,329,-14,-539,-1250,-1613,-1194,-242,628,1199,1799,2702,3640,4062,3719,2880,2059,1634,1661,1876,1863,1351,419,-586,-1346,-1769,-1921,-1877,-1693,-1459,-1258,-1070,-788,-387,-33,48,-161,-406,-403,-132,166,265,172,53,21,49,65,36,-41,-150,-234,-212,-59,138,251,224,101,-32,-119,-147,-140,-144,-195,-281,-363,-430,-521,-664,-824,-925,-919,-826,-698,-576,-480,-418,-391,-392,-404,-404,-380,-332,-269,-199,-131,-77,-52,-56,-73,-89,-103,-124,-150,-168,-165,-144,-120,-109,-120,-157,-211,-266,-309,-339,-366,-391,-407,-404,-384,-357,-332,-316,-305,-289,-254,-202,-150,-118,-107,-102,-92,-77,-63,-52,-44,-42,-47,-57,-71,-87,-104,-120,-134,-147,-160,-169,-169,-158,-140,-121,-108,-104,-111,-124,-136,-143,-145,-140,-127,-110,-93,-79,-71,-71,-77,-88,-101,-113,-121,-119,-108,-94,-83,-74,-63,-54,-55,-67,-85,-104,-121,-129,-125,-115,-109,-108,-105,-96,-90,-92,-95,-95,-98,-105,-99,-71,-35,-10,5,16,14,-10,-43,-66,-85,-120,-155,-144,-76},
            {64,-57,-108,45,159,-16,-205,-8,252,-29,-133,2065,7455,13331,14888,9448,-1117,-11791,-17436,-15229,-6399,3563,8369,6733,4115,6700,13770,18102,14477,5809,-475,-630,2656,4703,3570,218,-3720,-6916,-8399,-8266,-8000,-8861,-10063,-9661,-7285,-4832,-4033,-4366,-4158,-2997,-1918,-1510,-1064,104,1489,2216,2358,2634,3134,3267,2959,2967,3655,4197,3689,2581,2189,2825,3229,2121,-200,-2197,-2712,-1858,-596,107,-225,-1394,-2649,-3239,-3067,-2686,-2576,-2609,-2326,-1563,-603,168,505,240,-718,-2121,-3287,-3502,-2613,-1167,86,767,991,1041,1067,1088,1115,1167,1189,1070,781,444,237,253,435,619,633,404,22,-344,-607,-829,-1097,-1372,-1501,-1380,-1065,-729,-510,-421,-383,-332,-284,-303,-396,-488,-495,-401,-238,-25,234,500,695,763,697,530,315,125,18,-6,2,5,14,45,86,114,116,80,-11,-150,-298,-412,-481,-508,-478,-377,-228,-85,14,48,8,-98,-232,-344,-411,-441,-430,-363,-247,-119,-9,80,156,201,188,108,-19,-156,-257,-282,-231,-145,-63,13,89,146,139,47,-99,-246,-347,-376,-326,-212,-69,68,173,226,203,96,-68,-238,-363,-417,-404,-343,-254,-149,-36,65,123,113,30,-100,-230,-311,-318,-251,-139,-20,80,146,169,146,81,-15,-129,-240,-314,-321,-257,-150,-41,44,95,117,115,86,24,-68,-167,-234,-239,-184,-92,6,82,115,97,47}
        },
        {    // H20e070a.wav
            {0,0,0,0,0,-1,0,1,2,1,0,2,3,2,1,1,1,0,0,1,1,-1,-1,1,3,3,2,2,0,-1,1,4,3,0,1,5,5,2,5,10,3,-9,-3,19,24,-1,-21,-10,7,5,11,38,36,7,132,600,1261,1651,1484,990,565,213,-382,-1218,-1737,-1436,-492,477,1173,1858,2798,3762,4224,3931,3110,2207,1566,1309,1332,1367,1152,630,-38,-660,-1140,-1414,-1379,-1010,-512,-221,-307,-617,-858,-895,-819,-762,-743,-706,-646,-609,-600,-561,-463,-365,-327,-321,-266,-145,-7,112,214,292,315,285,264,287,304,243,117,15,-15,-12,-41,-130,-286,-511,-770,-975,-1041,-968,-831,-703,-610,-550,-519,-504,-480,-433,-380,-351,-351,-350,-312,-234,-149,-96,-83,-86,-84,-72,-55,-38,-28,-33,-53,-69,-64,-50,-58,-107,-183,-253,-305,-348,-384,-404,-404,-397,-392,-385,-361,-317,-268,-229,-203,-183,-166,-155,-150,-145,-134,-120,-107,-89,-63,-40,-38,-57,-83,-102,-114,-125,-132,-133,-130,-128,-124,-112,-93,-75,-69,-77,-94,-114,-130,-138,-135,-122,-105,-91,-85,-84,-80,-74,-75,-86,-100,-110,-117,-124,-127,-119,-103,-89,-79,-69,-61,-65,-82,-98,-103,-103,-104,-104,-99,-94,-93,-90,-80,-70,-67,-67,-61,-49,-39,-28,-12,-2,-6,-17,-22,-33,-68,-110,-112,-60},
            {37,-102,-71,120,116,-138,-171,159,197,-237,485,4435,10867,15372,13328,4154,-7956,-16858,-17952,-10706,410,8244,8739,5143,4736,10334,16584,16216,8754,887,-1383,1408,4520,4741,2249,-1504,-5326,-8005,-8629,-7855,-7562,-8494,-9222,-8207,-6049,-4627,-4533,-4593,-3859,-2817,-2207,-1699,-571,924,1842,1994,2149,2718,3136,2936,2684,3134,3942,4086,3438,2982,3233,3271,1974,-275,-1884,-1908,-944,-134,56,-211,-822,-1755,-2705,-3216,-3231,-3109,-3021,-2687,-1853,-776,-4,135,-370,-1405,-2696,-3630,-3536,-2353,-809,248,621,721,912,1151,1270,1318,1449,1611,1566,1198,675,272,139,255,487,655,601,298,-121,-508,-832,-1144,-1419,-1535,-1413,-1131,-850,-668,-561,-466,-382,-362,-440,-578,-688,-713,-637,-461,-186,157,486,716,813,793,680,508,338,229,186,170,155,146,143,122,80,46,32,-6,-110,-259,-395,-491,-550,-559,-486,-334,-157,-24,30,2,-84,-190,-284,-360,-425,-460,-428,-316,-162,-15,104,191,238,230,165,56,-76,-191,-245,-220,-146,-66,13,98,162,157,59,-97,-252,-364,-411,-379,-274,-134,-4,98,169,193,140,7,-165,-312,-389,-393,-339,-249,-143,-39,49,108,119,66,-47,-186,-298,-338,-294,-185,-50,73,157,188,169,107,14,-98,-211,-297,-326,-282,-181,-65,26,80,107,119,112,74,0,-97,-186,-228,-202,-124,-32,40,81,93,76,37}
        },
        {    // H20e075a.wav
            {0,0,1,0,-1,0,0,-2,-2,1,3,1,0,1,2,0,-1,0,0,-1,-2,0,1,-1,-1,2,5,3,-1,-2,-1,1,2,2,-1,-2,1,6,6,2,3,6,2,-4,4,21,16,-15,-32,-9,20,21,20,41,39,-3,72,462,1078,1516,1484,1136,782,391,-328,-1314,-1948,-1667,-605,618,1626,2528,3429,4039,3953,3173,2155,1404,1148,1333,1714,1940,1734,1129,471,89,-20,-117,-384,-744,-1005,-1087,-1072,-1075,-1145,-1270,-1418,-1537,-1564,-1472,-1314,-1170,-1062,-934,-739,-499,-276,-102,29,128,210,311,462,629,722,686,564,438,348,282,230,193,158,90,-35,-219,-454,-716,-944,-1065,-1055,-958,-838,-726,-631,-568,-550,-555,-550,-527,-509,-500,-471,-396,-290,-194,-130,-90,-52,-9,32,62,74,66,43,21,15,24,31,13,-39,-115,-195,-266,-328,-381,-421,-441,-444,-440,-426,-393,-343,-295,-268,-255,-241,-223,-213,-214,-210,-189,-156,-124,-98,-73,-54,-49,-59,-73,-79,-80,-85,-96,-107,-110,-106,-102,-97,-88,-74,-65,-69,-83,-96,-105,-116,-132,-143,-137,-114,-90,-77,-71,-67,-67,-79,-101,-124,-140,-152,-157,-150,-131,-103,-75,-54,-44,-47,-62,-84,-103,-111,-108,-103,-101,-96,-82,-64,-52,-46,-41,-39,-46,-59,-64,-54,-40,-33,-27,-16,-13,-36,-70,-77,-43},
            {-10,-107,-2,149,23,-207,-64,259,40,-284,1475,6768,13306,15826,10594,-1008,-13166,-19328,-16058,-5397,5729,10326,7641,4119,6312,13080,16800,12577,4011,-1351,-435,3401,5536,4513,1362,-2744,-6679,-8873,-8581,-7204,-6891,-7870,-8381,-7305,-5603,-4717,-4640,-4400,-3719,-3113,-2651,-1728,-197,1176,1780,1994,2437,2921,2887,2540,2697,3496,4091,3915,3502,3480,3330,2043,-171,-1749,-1604,-373,556,663,368,-81,-940,-2186,-3167,-3380,-3119,-2955,-2885,-2442,-1515,-620,-344,-848,-1918,-3141,-3907,-3631,-2313,-734,209,362,307,561,1056,1443,1628,1774,1921,1884,1534,1005,551,312,276,376,525,589,460,139,-276,-698,-1085,-1388,-1520,-1444,-1228,-994,-811,-669,-545,-460,-458,-549,-694,-832,-913,-896,-737,-425,-21,355,607,731,771,749,664,540,435,382,354,315,265,219,172,113,57,27,1,-69,-196,-344,-476,-575,-628,-600,-472,-283,-109,-13,-11,-74,-159,-237,-314,-398,-468,-477,-399,-261,-108,38,168,257,274,216,113,-7,-124,-205,-216,-158,-73,1,64,124,151,96,-51,-237,-386,-451,-430,-342,-214,-80,28,99,136,132,64,-74,-244,-374,-416,-371,-279,-174,-71,21,87,111,80,-6,-131,-261,-346,-347,-258,-113,33,136,179,167,114,31,-73,-185,-280,-331,-318,-242,-127,-16,57,87,95,95,76,25,-55,-140,-198,-210,-172,-101,-24,32,57,56,39,17}
        },
        {    // H20e080a.wav
            {0,0,1,1,0,-1,0,1,0,-1,-1,0,1,1,1,1,2,0,-1,0,1,0,-1,0,1,0,-1,1,2,0,-2,-2,-1,0,0,0,-2,-2,2,6,4,0,3,10,7,-1,2,11,0,-27,-26,15,48,36,14,19,12,-24,51,418,999,1443,1502,1282,968,459,-444,-1489,-1948,-1332,28,1326,2092,2461,2718,2885,2836,2598,2328,2114,1960,1932,2127,2470,2658,2397,1643,604,-413,-1133,-1407,-1306,-1120,-1166,-1524,-1985,-2256,-2230,-2040,-1888,-1853,-1857,-1764,-1500,-1090,-642,-292,-118,-80,-39,125,416,730,953,1028,959,802,646,561,530,472,340,188,97,63,-1,-163,-410,-678,-905,-1046,-1072,-995,-876,-779,-726,-706,-703,-708,-705,-678,-625,-555,-471,-376,-281,-197,-126,-59,4,59,103,137,156,154,137,121,109,89,55,13,-34,-95,-179,-273,-349,-396,-426,-451,-468,-465,-441,-406,-367,-330,-304,-293,-290,-286,-275,-256,-228,-194,-158,-128,-106,-90,-76,-64,-55,-53,-56,-59,-61,-61,-61,-63,-72,-91,-113,-125,-118,-97,-73,-57,-58,-78,-111,-138,-145,-132,-109,-90,-81,-84,-92,-99,-103,-109,-124,-143,-155,-152,-134,-110,-89,-77,-74,-72,-69,-69,-77,-88,-95,-97,-95,-85,-67,-49,-43,-48,-52,-51,-51,-56,-61,-60,-59,-61,-58,-46,-36,-43,-58,-56,-30},
            {-47,-86,61,145,-60,-223,41,289,-108,-197,2421,8501,14685,15430,7929,-4988,-16476,-19987,-13405,-946,9107,10872,6441,3771,7718,14303,15556,9185,1062,-1957,806,4835,6266,4598,911,-3730,-7777,-9348,-8193,-6442,-6258,-7364,-7853,-6897,-5488,-4707,-4454,-4177,-3843,-3559,-2932,-1577,47,1082,1440,1836,2599,3146,2976,2571,2762,3549,4170,4198,3850,3218,1953,111,-1303,-1313,-239,683,826,665,664,414,-662,-2238,-3352,-3548,-3214,-2818,-2351,-1702,-1136,-1079,-1630,-2535,-3442,-3967,-3709,-2582,-1125,-145,70,-10,210,790,1369,1724,1955,2154,2186,1892,1363,869,583,482,486,550,616,573,333,-69,-513,-897,-1179,-1344,-1383,-1316,-1186,-1015,-808,-597,-464,-478,-619,-798,-939,-1022,-1038,-945,-704,-336,61,385,597,714,761,744,675,594,542,519,488,426,344,263,191,133,96,70,17,-93,-247,-406,-539,-630,-650,-572,-409,-229,-102,-55,-70,-117,-177,-252,-343,-433,-483,-452,-340,-190,-44,85,194,266,276,220,114,-15,-132,-197,-183,-106,-14,61,114,143,123,28,-130,-302,-427,-466,-415,-303,-173,-56,42,120,161,131,17,-152,-312,-405,-409,-336,-220,-99,0,68,106,111,65,-41,-181,-300,-343,-294,-176,-32,91,160,166,128,71,1,-94,-209,-307,-340,-292,-188,-72,24,84,109,109,90,50,-16,-99,-171,-204,-185,-124,-45,23,57,57,37,16,3}
        },
        {    // H20e085a.wav
            {0,0,0,0,1,1,0,0,0,0,-1,-2,-1,0,0,0,1,2,1,0,1,2,1,0,0,0,-1,-2,-1,1,2,0,-2,-2,1,2,1,0,-1,0,2,4,4,6,12,13,1,-12,-10,2,5,1,11,34,36,11,-5,2,-4,-12,111,487,1021,1449,1607,1538,1278,699,-267,-1305,-1846,-1566,-648,497,1606,2572,3241,3432,3194,2843,2695,2825,3095,3308,3270,2845,2072,1200,479,-80,-660,-1337,-1928,-2203,-2182,-2127,-2247,-2484,-2613,-2512,-2266,-2035,-1875,-1709,-1451,-1098,-719,-381,-110,108,304,508,721,914,1054,1124,1117,1018,835,625,460,362,291,211,126,45,-64,-236,-452,-648,-790,-892,-973,-1022,-1021,-976,-911,-850,-807,-786,-767,-714,-610,-481,-374,-305,-252,-188,-106,-18,64,128,167,186,199,214,225,215,174,104,24,-47,-101,-146,-199,-264,-334,-395,-439,-461,-458,-437,-415,-403,-397,-383,-357,-331,-314,-302,-284,-257,-221,-181,-142,-114,-103,-101,-96,-81,-61,-43,-29,-16,-6,-6,-23,-57,-103,-145,-166,-155,-118,-74,-44,-37,-48,-66,-84,-100,-113,-121,-122,-119,-116,-115,-114,-112,-109,-107,-106,-107,-108,-109,-110,-110,-111,-113,-111,-98,-75,-53,-44,-44,-48,-53,-59,-62,-63,-64,-67,-68,-62,-52,-45,-44,-49,-59,-70,-74,-70,-65,-67,-70,-58,-29},
            {-58,-76,80,135,-95,-221,88,290,-181,-146,2859,9252,15182,14982,6329,-7142,-17996,-19801,-11404,1712,10797,10935,5749,3604,8174,14223,14102,7024,-349,-1948,1690,5784,6984,5054,920,-4263,-8438,-9505,-7691,-5700,-5706,-7066,-7705,-6868,-5524,-4635,-4219,-4022,-4029,-3974,-3200,-1545,152,992,1165,1560,2428,3093,3054,2764,2973,3717,4362,4393,3710,2360,562,-969,-1338,-457,666,1030,752,639,857,663,-466,-2018,-3067,-3309,-3082,-2655,-2017,-1336,-1114,-1681,-2790,-3850,-4376,-4137,-3148,-1772,-653,-235,-308,-250,277,1032,1616,1944,2169,2312,2204,1776,1230,840,690,680,705,733,723,583,253,-205,-653,-979,-1157,-1229,-1258,-1273,-1233,-1068,-785,-519,-433,-565,-799,-1001,-1122,-1166,-1115,-936,-639,-292,32,300,510,660,744,755,704,634,592,584,568,502,394,291,224,188,164,126,43,-99,-277,-445,-570,-638,-631,-532,-372,-226,-148,-132,-139,-157,-203,-284,-383,-465,-492,-436,-304,-142,2,112,195,250,257,206,108,-13,-125,-187,-170,-88,13,95,145,157,110,-8,-175,-338,-446,-470,-411,-297,-167,-54,42,124,167,125,-17,-210,-370,-439,-408,-308,-181,-61,30,86,110,100,45,-63,-199,-307,-334,-266,-136,4,112,163,157,115,58,-15,-116,-234,-327,-348,-284,-166,-41,53,99,103,84,54,9,-58,-137,-197,-210,-172,-97,-9,61,83,55,7,-20,-16}
        },
        {    // H20e090a.wav
            {0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,0,1,2,2,2,1,1,1,1,0,-1,-2,-2,-1,1,3,2,-1,-2,0,2,2,-1,-2,1,5,5,4,7,14,12,-3,-18,-14,7,24,27,22,14,3,-6,-2,4,-9,-17,68,323,755,1337,2018,2587,2574,1517,-492,-2583,-3634,-3105,-1365,733,2468,3503,3823,3675,3484,3578,3870,3937,3502,2767,2181,1947,1844,1514,800,-204,-1282,-2186,-2697,-2744,-2507,-2313,-2366,-2579,-2693,-2538,-2174,-1806,-1591,-1518,-1437,-1189,-739,-206,233,478,566,618,736,929,1122,1219,1167,986,749,539,401,326,268,184,66,-60,-169,-269,-391,-553,-743,-929,-1076,-1156,-1156,-1086,-983,-889,-819,-756,-677,-575,-469,-384,-330,-291,-234,-143,-32,63,121,148,169,198,234,259,255,209,124,22,-66,-122,-151,-174,-214,-275,-343,-394,-417,-419,-418,-425,-437,-442,-433,-411,-378,-340,-302,-273,-252,-232,-203,-165,-130,-111,-110,-118,-117,-93,-49,-3,25,23,-6,-50,-97,-134,-153,-152,-138,-116,-90,-65,-45,-35,-36,-46,-65,-91,-118,-140,-152,-153,-144,-130,-115,-101,-89,-77,-71,-80,-104,-129,-139,-136,-130,-122,-106,-80,-52,-26,-5,3,-11,-45,-78,-95,-96,-90,-81,-67,-53,-47,-49,-54,-60,-69,-78,-84,-92,-104,-108,-86,-41},
            {-49,-83,70,145,-76,-231,63,305,-147,-223,2589,8916,14991,14970,6318,-7254,-18053,-19572,-10881,2307,11267,11230,5837,3356,7491,13219,13091,6307,-654,-1890,2016,6325,7694,5805,1479,-4072,-8538,-9572,-7417,-5086,-5056,-6723,-7780,-7192,-5804,-4677,-4053,-3861,-4074,-4246,-3544,-1783,69,976,1084,1355,2164,2887,2962,2752,3028,3902,4647,4488,3266,1441,-232,-1043,-740,180,821,789,564,752,1145,903,-329,-1889,-2845,-2944,-2590,-2153,-1713,-1406,-1574,-2384,-3503,-4326,-4449,-3857,-2811,-1702,-915,-582,-459,-167,411,1074,1604,1990,2283,2387,2149,1623,1096,819,796,873,934,950,884,660,259,-226,-648,-921,-1061,-1140,-1221,-1295,-1269,-1067,-749,-508,-497,-685,-920,-1097,-1210,-1250,-1164,-925,-601,-293,-38,186,394,571,696,749,726,659,608,605,608,552,439,331,275,259,244,202,107,-54,-257,-445,-575,-629,-600,-493,-351,-243,-201,-193,-185,-191,-244,-335,-424,-477,-481,-418,-287,-125,12,109,187,249,262,205,95,-27,-124,-172,-151,-69,33,113,160,169,120,-3,-178,-348,-458,-477,-408,-283,-152,-46,36,105,139,93,-46,-227,-373,-433,-401,-300,-166,-42,42,85,103,96,43,-67,-204,-309,-329,-254,-116,31,139,182,166,118,56,-22,-129,-249,-334,-340,-264,-144,-28,51,82,74,48,20,-18,-77,-148,-201,-205,-159,-82,3,69,87,50,-9,-40,-28}
        },
        {    // H20e095a.wav
            {0,0,0,1,0,-1,0,1,0,-1,-1,0,0,-1,-1,1,2,2,2,1,0,0,1,1,-1,-2,-1,-1,-2,-3,-1,2,2,1,0,-1,-2,-2,-1,-1,-1,2,7,6,0,1,10,10,-5,-17,-7,16,30,31,26,7,-24,-36,-8,17,-7,3,244,816,1579,2260,2616,2420,1401,-477,-2604,-3853,-3421,-1563,649,2303,3268,3893,4360,4512,4192,3538,2887,2518,2502,2679,2709,2256,1263,57,-909,-1440,-1703,-1969,-2320,-2628,-2746,-2650,-2424,-2179,-2006,-1936,-1911,-1817,-1590,-1273,-953,-662,-367,-57,223,433,592,739,867,941,953,936,905,840,720,561,393,236,107,28,0,-25,-111,-287,-524,-769,-972,-1102,-1151,-1136,-1087,-1016,-919,-802,-683,-577,-486,-412,-365,-338,-302,-231,-134,-39,36,93,134,159,176,190,197,181,133,66,0,-56,-104,-143,-176,-208,-247,-291,-331,-361,-383,-403,-427,-452,-465,-453,-416,-369,-328,-292,-257,-226,-208,-197,-179,-153,-131,-125,-124,-111,-78,-39,-10,-4,-22,-60,-104,-134,-138,-122,-106,-100,-99,-91,-72,-49,-35,-34,-43,-61,-89,-121,-144,-152,-150,-142,-126,-100,-73,-60,-64,-79,-99,-122,-143,-149,-135,-110,-90,-76,-61,-38,-12,3,1,-18,-46,-74,-96,-106,-103,-89,-73,-61,-55,-52,-53,-65,-86,-105,-111,-110,-112,-110,-86,-41},
            {-18,-107,16,157,-5,-232,-34,299,-14,-358,1712,7508,14030,15310,7876,-5360,-16766,-19417,-11819,970,10597,11723,6688,3161,5887,11416,12482,6908,24,-1903,1650,6335,8331,6848,2653,-3048,-8003,-9613,-7589,-4799,-4282,-6055,-7745,-7712,-6406,-5016,-4102,-3746,-3959,-4316,-3897,-2285,-293,896,1135,1299,1952,2651,2786,2585,2837,3769,4622,4431,3010,1101,-299,-664,-199,429,653,477,402,781,1271,1103,-47,-1600,-2631,-2747,-2285,-1767,-1454,-1443,-1876,-2779,-3808,-4404,-4261,-3546,-2659,-1898,-1355,-972,-616,-155,429,1021,1511,1896,2191,2294,2072,1576,1068,795,787,914,1068,1184,1161,883,367,-197,-598,-794,-893,-1016,-1182,-1311,-1292,-1083,-778,-565,-573,-755,-969,-1130,-1237,-1277,-1187,-944,-631,-354,-136,62,265,456,605,691,701,654,610,608,617,576,481,389,339,318,299,271,203,52,-176,-407,-558,-604,-570,-482,-371,-280,-239,-231,-227,-237,-289,-379,-466,-513,-502,-426,-288,-126,7,97,168,229,249,202,100,-18,-121,-177,-155,-59,60,144,177,172,122,6,-163,-329,-433,-453,-400,-299,-179,-68,19,80,102,56,-66,-225,-355,-412,-387,-297,-172,-51,35,78,92,81,29,-76,-207,-305,-319,-240,-103,46,157,200,177,118,51,-23,-117,-226,-311,-328,-267,-160,-52,22,48,35,8,-12,-32,-72,-133,-189,-207,-174,-100,-13,54,72,41,-4,-27,-18}
        },
        {    // H20e100a.wav
            {1,1,0,0,0,0,0,-1,-1,-1,-1,-1,0,0,0,0,-1,0,2,1,0,0,1,0,-2,-2,-1,-1,0,1,1,0,0,2,2,0,-2,-1,-1,-2,-1,4,7,3,0,3,5,1,-1,6,11,5,3,22,41,24,-17,-31,-11,2,48,310,908,1649,2102,1993,1439,715,-106,-1104,-2129,-2659,-2188,-712,1235,2991,4128,4518,4245,3565,2854,2434,2394,2586,2772,2739,2340,1540,483,-543,-1279,-1652,-1770,-1788,-1820,-1927,-2106,-2270,-2291,-2117,-1833,-1585,-1443,-1364,-1268,-1106,-867,-574,-283,-69,57,163,315,498,638,702,721,734,735,700,630,544,442,319,191,93,28,-46,-175,-364,-583,-799,-980,-1096,-1124,-1072,-974,-867,-769,-680,-595,-512,-429,-352,-287,-240,-208,-179,-139,-76,9,92,144,149,120,82,50,24,-1,-26,-50,-74,-102,-133,-164,-192,-221,-259,-303,-343,-371,-391,-412,-431,-435,-414,-374,-329,-288,-253,-226,-208,-196,-184,-170,-156,-144,-128,-106,-84,-72,-72,-77,-83,-92,-106,-119,-123,-115,-101,-89,-81,-75,-69,-63,-56,-50,-50,-61,-85,-115,-137,-144,-136,-118,-98,-79,-66,-63,-71,-88,-108,-125,-138,-142,-133,-108,-76,-49,-31,-21,-16,-18,-26,-37,-47,-57,-69,-82,-95,-101,-94,-79,-66,-62,-66,-79,-102,-127,-137,-124,-100,-83,-74,-58,-28},
            {31,-113,-59,141,99,-180,-159,222,178,-356,613,5218,11986,15385,10559,-1484,-13862,-18947,-13823,-2112,8558,11969,8217,3530,3926,8735,11644,8415,1917,-1536,638,5435,8528,8088,4505,-1080,-6651,-9452,-8248,-5125,-3601,-4924,-7207,-8117,-7265,-5739,-4472,-3786,-3774,-4170,-4126,-2927,-965,598,1200,1395,1860,2444,2599,2394,2535,3362,4237,4185,2964,1302,148,-130,142,423,438,309,354,734,1185,1145,275,-1106,-2227,-2556,-2225,-1747,-1488,-1536,-1919,-2653,-3534,-4115,-4072,-3508,-2789,-2163,-1638,-1151,-694,-249,242,791,1317,1729,1997,2095,1960,1590,1132,804,723,854,1098,1338,1411,1165,612,-23,-475,-672,-743,-851,-1038,-1218,-1272,-1141,-889,-678,-645,-780,-966,-1113,-1209,-1250,-1182,-976,-697,-446,-248,-60,147,347,500,594,631,623,603,604,614,590,520,444,399,381,370,351,297,162,-64,-313,-491,-562,-551,-490,-399,-311,-259,-245,-247,-264,-316,-404,-488,-531,-519,-450,-321,-158,-13,80,139,192,227,211,135,26,-80,-150,-148,-65,58,154,192,184,135,34,-117,-274,-380,-413,-386,-318,-219,-109,-14,50,74,44,-49,-188,-319,-388,-372,-287,-170,-61,17,60,73,60,14,-69,-175,-262,-287,-229,-102,46,158,199,178,129,78,20,-63,-168,-262,-307,-286,-209,-106,-16,30,27,1,-20,-36,-69,-124,-179,-203,-182,-121,-38,39,79,71,36,7,-2}
        },
        {    // H20e105a.wav
            {1,1,1,1,0,0,0,0,0,0,0,0,1,2,2,2,2,2,1,1,0,-1,-1,-1,0,0,0,0,1,2,2,3,3,2,1,0,0,0,1,2,4,4,3,4,6,6,2,-1,1,7,14,19,17,8,2,14,28,19,29,207,679,1336,1813,1777,1250,580,67,-335,-861,-1526,-1943,-1607,-352,1472,3222,4316,4479,3816,2767,1923,1705,2093,2644,2840,2463,1687,849,171,-335,-770,-1197,-1575,-1808,-1834,-1690,-1500,-1396,-1436,-1574,-1685,-1641,-1393,-1024,-704,-561,-581,-621,-544,-331,-83,79,112,74,69,162,334,499,576,550,468,392,356,353,353,315,208,24,-205,-426,-595,-708,-792,-875,-953,-989,-951,-845,-709,-588,-503,-449,-407,-354,-276,-184,-111,-79,-81,-83,-56,2,66,101,86,26,-50,-106,-128,-128,-130,-141,-151,-151,-145,-149,-173,-214,-261,-307,-349,-380,-389,-374,-346,-322,-307,-294,-272,-240,-209,-190,-186,-185,-176,-155,-128,-105,-94,-99,-118,-141,-153,-145,-121,-99,-93,-103,-114,-114,-102,-86,-72,-61,-56,-58,-64,-71,-79,-95,-117,-133,-131,-113,-89,-69,-55,-50,-56,-74,-96,-112,-119,-121,-120,-114,-97,-72,-46,-26,-11,-3,-6,-22,-45,-63,-72,-76,-78,-78,-78,-79,-81,-84,-90,-100,-113,-125,-132,-132,-121,-99,-74,-57,-49,-38,-18},
            {71,-74,-116,67,168,-55,-234,39,292,-122,-183,2570,8666,14166,13236,3988,-8796,-17134,-15968,-6555,4787,11145,9943,4886,2451,5328,9685,9835,5015,83,-318,3481,7604,8930,6779,1884,-4128,-8564,-9112,-6324,-3535,-3521,-5837,-7942,-8179,-6890,-5235,-4024,-3610,-3915,-4228,-3609,-1908,-31,1107,1543,1880,2285,2406,2185,2178,2820,3690,3881,3024,1684,716,418,457,429,278,195,323,652,1022,1122,620,-488,-1694,-2356,-2295,-1907,-1674,-1737,-2001,-2417,-2963,-3460,-3649,-3466,-3071,-2595,-2011,-1318,-672,-220,99,467,931,1372,1679,1833,1824,1617,1245,879,702,772,1015,1300,1468,1360,925,313,-214,-501,-611,-702,-861,-1050,-1175,-1165,-1025,-843,-741,-779,-912,-1055,-1159,-1208,-1170,-1019,-789,-557,-364,-183,16,215,376,484,542,555,545,550,581,601,570,501,440,413,411,410,377,266,60,-188,-390,-496,-522,-500,-442,-365,-302,-275,-270,-278,-315,-395,-486,-540,-539,-487,-383,-234,-82,27,88,136,184,203,163,76,-20,-93,-118,-77,17,116,174,180,146,72,-48,-193,-320,-389,-394,-347,-264,-163,-68,5,45,41,-20,-131,-256,-345,-365,-313,-211,-99,-15,27,39,36,14,-43,-132,-220,-262,-232,-137,-7,114,184,187,150,108,65,-2,-106,-218,-292,-299,-247,-161,-71,-7,10,-10,-37,-57,-84,-133,-188,-213,-190,-128,-47,33,88,94,59,18,0}
        },
        {    // H20e110a.wav
            {0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,-1,-1,-1,-1,-2,-2,-1,0,0,0,0,0,0,0,0,0,-2,-2,1,4,3,1,1,3,1,-2,2,9,7,-2,-2,12,21,12,3,6,10,35,202,639,1270,1751,1720,1147,390,-139,-342,-458,-754,-1199,-1423,-975,326,2168,3830,4576,4147,2974,1890,1526,1871,2380,2488,2057,1368,764,346,-25,-493,-1030,-1458,-1615,-1502,-1287,-1176,-1246,-1395,-1447,-1305,-1020,-730,-552,-517,-559,-553,-409,-159,43,60,-91,-252,-275,-159,-21,39,20,-6,18,92,181,252,289,287,246,176,90,-10,-143,-325,-537,-724,-831,-843,-794,-733,-695,-681,-664,-615,-523,-411,-313,-242,-184,-120,-55,-9,10,16,25,33,25,-4,-41,-75,-111,-155,-202,-237,-254,-260,-261,-253,-232,-206,-196,-218,-269,-326,-362,-360,-327,-288,-263,-251,-238,-215,-191,-182,-188,-195,-191,-178,-159,-136,-112,-99,-108,-137,-168,-181,-174,-156,-140,-129,-122,-116,-113,-112,-111,-107,-100,-92,-85,-80,-82,-93,-111,-126,-131,-124,-108,-86,-65,-51,-50,-61,-77,-89,-93,-95,-101,-108,-107,-95,-76,-58,-47,-42,-37,-30,-25,-26,-33,-45,-64,-87,-102,-98,-82,-71,-78,-97,-118,-134,-144,-145,-137,-124,-109,-91,-72,-60,-60,-64,-54,-27},
            {64,9,-98,-45,129,97,-157,-162,186,190,-299,484,4618,10893,14128,9646,-1522,-12646,-16648,-11423,-857,8256,10875,7230,2527,2124,6171,9670,8342,3488,135,1258,5232,8443,8613,5403,-257,-6140,-9254,-8158,-4759,-2709,-3805,-6601,-8486,-8267,-6572,-4671,-3534,-3500,-4084,-4192,-3071,-1094,673,1628,2014,2222,2238,1987,1828,2239,3083,3587,3170,2109,1185,830,798,653,327,94,158,470,850,1093,935,186,-977,-1992,-2387,-2220,-1943,-1889,-2047,-2283,-2552,-2836,-3053,-3134,-3092,-2911,-2470,-1718,-860,-212,124,330,601,935,1228,1438,1572,1581,1398,1078,802,726,862,1112,1336,1387,1165,704,184,-209,-424,-549,-686,-861,-1030,-1124,-1098,-973,-839,-793,-855,-972,-1080,-1148,-1150,-1056,-871,-655,-464,-294,-113,78,247,371,453,486,477,467,505,579,619,581,499,435,413,415,408,350,204,-17,-244,-402,-473,-486,-466,-419,-363,-323,-302,-289,-292,-338,-424,-507,-546,-526,-450,-324,-175,-52,21,69,124,173,181,135,59,-19,-71,-72,-14,74,141,164,152,110,28,-100,-243,-353,-400,-381,-307,-204,-105,-32,14,32,10,-63,-169,-268,-325,-326,-272,-176,-71,2,28,25,14,-12,-70,-155,-225,-240,-187,-82,43,150,205,197,149,91,31,-47,-145,-234,-273,-251,-187,-115,-59,-36,-46,-73,-94,-106,-123,-149,-170,-165,-122,-50,27,79,86,57,20,1}
        },
        {    // H20e115a.wav
            {0,0,0,0,0,0,0,0,1,2,2,2,2,1,0,0,1,1,0,-1,-1,0,0,-1,-2,-2,0,1,1,0,-1,-1,0,0,0,1,2,0,0,3,5,1,-4,0,8,7,-1,-1,11,13,-1,-4,15,25,25,148,569,1252,1831,1861,1241,335,-342,-560,-505,-529,-789,-1065,-886,95,1740,3378,4218,3931,2908,1936,1593,1874,2319,2440,2064,1360,624,52,-344,-667,-1006,-1357,-1622,-1687,-1524,-1237,-1004,-950,-1052,-1163,-1124,-881,-508,-147,88,169,150,110,104,143,198,214,140,-19,-182,-250,-200,-113,-97,-182,-291,-315,-208,-26,118,137,25,-151,-307,-404,-461,-522,-605,-692,-745,-736,-665,-564,-476,-434,-438,-452,-431,-353,-232,-105,-4,63,103,125,134,128,103,55,-11,-83,-145,-193,-230,-263,-293,-319,-342,-359,-360,-342,-319,-321,-357,-398,-402,-358,-295,-244,-209,-178,-154,-146,-150,-148,-135,-127,-135,-149,-148,-131,-114,-111,-123,-142,-161,-171,-163,-142,-125,-127,-146,-161,-158,-142,-121,-104,-97,-104,-121,-138,-145,-140,-132,-129,-133,-132,-113,-80,-52,-40,-42,-48,-57,-72,-89,-98,-96,-89,-82,-74,-64,-55,-47,-41,-41,-48,-55,-56,-50,-47,-52,-60,-68,-78,-91,-101,-107,-112,-119,-126,-132,-138,-142,-135,-115,-93,-80,-74,-65,-62,-76,-95,-87,-45},
            {-1,76,7,-106,-26,137,48,-189,-92,237,76,-298,1176,5952,11673,12959,6564,-4656,-13600,-14638,-7640,2473,9354,9487,4710,717,1820,6653,9806,7932,3252,600,2146,5952,8684,8277,4414,-1671,-7229,-9284,-7205,-3683,-2293,-4129,-7230,-8963,-8331,-6184,-4067,-3124,-3497,-4264,-4154,-2668,-498,1267,2144,2346,2180,1800,1475,1643,2414,3235,3345,2587,1582,1035,1015,1037,737,258,-9,120,520,943,1120,795,-110,-1287,-2188,-2488,-2342,-2131,-2075,-2162,-2318,-2501,-2656,-2738,-2776,-2794,-2667,-2198,-1398,-557,24,310,473,641,821,1002,1199,1373,1415,1262,999,788,740,861,1078,1255,1247,993,576,161,-145,-349,-511,-676,-852,-1009,-1089,-1047,-920,-820,-828,-921,-1019,-1077,-1095,-1059,-939,-749,-558,-404,-260,-86,102,254,350,403,424,422,429,482,562,603,564,472,394,368,378,375,309,157,-52,-255,-399,-471,-481,-449,-402,-368,-350,-328,-299,-296,-345,-427,-497,-526,-509,-436,-308,-163,-57,-3,37,93,148,161,121,51,-15,-51,-37,23,96,142,147,120,61,-36,-164,-288,-372,-394,-351,-258,-150,-66,-20,3,9,-17,-88,-187,-273,-313,-301,-243,-153,-60,0,15,6,-6,-29,-84,-166,-232,-237,-167,-47,78,167,198,173,116,55,-3,-67,-141,-207,-239,-226,-180,-132,-108,-110,-120,-119,-106,-94,-94,-107,-124,-127,-96,-34,28,52,31,-2,-12}
        },
        {    // H20e120a.wav
            {-1,-1,0,0,0,0,1,2,2,2,2,2,1,0,0,-1,-1,-1,-1,-1,-2,-2,-1,-1,-2,-1,0,-1,-2,-2,0,0,-2,-1,2,1,-2,-1,4,3,-5,-7,2,9,6,3,9,9,-5,-8,14,24,12,110,523,1250,1918,2021,1387,367,-456,-750,-637,-503,-616,-866,-801,21,1587,3277,4242,4042,2984,1859,1340,1554,2104,2424,2171,1419,548,-75,-379,-591,-970,-1529,-2010,-2123,-1810,-1306,-953,-934,-1145,-1297,-1161,-740,-249,71,144,97,134,351,659,866,836,587,270,58,37,145,225,145,-88,-344,-484,-474,-383,-303,-278,-301,-353,-420,-488,-553,-622,-690,-739,-746,-703,-630,-553,-487,-431,-384,-348,-323,-301,-271,-229,-175,-108,-23,81,188,266,289,251,171,77,-11,-81,-134,-181,-235,-298,-357,-395,-407,-401,-400,-427,-488,-550,-567,-518,-433,-353,-290,-226,-156,-100,-79,-88,-101,-101,-92,-83,-79,-77,-80,-95,-121,-145,-152,-137,-114,-99,-99,-112,-128,-147,-167,-180,-176,-156,-130,-111,-110,-129,-160,-189,-203,-202,-188,-167,-142,-116,-90,-63,-43,-36,-42,-50,-56,-63,-74,-82,-78,-69,-65,-64,-57,-43,-34,-37,-46,-52,-56,-63,-70,-73,-76,-81,-84,-87,-96,-110,-121,-128,-136,-143,-140,-126,-114,-110,-102,-84,-73,-79,-86,-77,-73,-104,-149,-147,-79},
            {-59,37,87,-25,-120,3,149,12,-202,-45,248,7,-241,1570,6418,11492,11714,4798,-5718,-13049,-12612,-5204,4022,9215,7810,2516,-792,1524,7186,10448,8321,3469,803,2362,6140,8771,8098,3847,-2413,-7628,-8998,-6450,-3027,-2133,-4435,-7701,-9267,-8256,-5750,-3549,-2853,-3549,-4410,-4117,-2371,-29,1780,2532,2392,1797,1212,1091,1677,2679,3351,3114,2137,1203,927,1175,1307,928,274,-126,-1,497,1000,1146,690,-332,-1524,-2357,-2591,-2419,-2194,-2116,-2192,-2358,-2513,-2546,-2450,-2365,-2373,-2318,-1941,-1217,-428,126,392,508,603,721,883,1084,1251,1278,1136,910,736,706,830,1038,1186,1138,867,481,132,-110,-277,-440,-630,-822,-964,-1011,-965,-882,-838,-867,-939,-1002,-1028,-1010,-936,-802,-640,-499,-385,-257,-83,110,268,361,399,401,392,405,460,528,549,496,405,336,319,337,345,286,135,-77,-277,-406,-451,-439,-404,-375,-363,-356,-333,-298,-288,-330,-402,-466,-496,-481,-409,-285,-155,-72,-37,-1,64,128,148,114,51,-8,-35,-12,53,116,138,114,66,1,-86,-189,-281,-337,-345,-302,-221,-127,-53,-13,3,3,-25,-92,-183,-259,-288,-262,-194,-110,-38,3,12,-1,-25,-59,-107,-165,-210,-205,-133,-15,97,156,156,124,90,56,13,-46,-118,-192,-244,-251,-211,-153,-113,-102,-103,-95,-73,-56,-66,-98,-129,-132,-98,-47,-11,-4,-10,-10}
        },
        {    // H20e125a.wav
            {-1,-1,-1,1,2,2,1,1,2,2,1,0,0,0,-1,-1,-1,-1,-2,-2,0,1,-1,-2,-1,-1,-2,-3,-1,0,0,0,2,2,0,0,3,3,-2,-4,1,3,-2,-1,14,21,4,-13,2,20,13,89,475,1229,2002,2224,1611,470,-543,-964,-835,-565,-524,-705,-687,34,1542,3269,4324,4177,3088,1878,1293,1500,2081,2407,2092,1228,271,-337,-518,-570,-851,-1427,-2029,-2306,-2125,-1658,-1219,-1033,-1104,-1250,-1250,-993,-543,-79,235,365,404,471,610,775,886,892,796,644,501,414,379,350,274,129,-66,-260,-392,-427,-395,-386,-478,-665,-863,-984,-1009,-978,-941,-911,-869,-791,-672,-534,-411,-327,-283,-260,-236,-196,-141,-84,-37,1,48,121,213,293,326,297,215,108,10,-57,-94,-128,-188,-272,-346,-383,-400,-442,-528,-620,-666,-652,-605,-547,-475,-381,-284,-212,-170,-138,-104,-74,-59,-52,-42,-32,-37,-58,-79,-87,-87,-85,-79,-64,-49,-48,-65,-93,-125,-159,-190,-201,-181,-145,-123,-130,-154,-178,-200,-223,-239,-236,-213,-181,-147,-113,-81,-58,-46,-43,-47,-54,-59,-57,-53,-52,-55,-54,-47,-39,-35,-34,-34,-38,-46,-55,-63,-70,-79,-87,-93,-101,-112,-123,-129,-132,-133,-132,-130,-131,-130,-119,-96,-80,-76,-74,-67,-69,-87,-105,-110,-120,-157,-193,-172,-87},
            {-22,-51,16,67,-18,-101,4,131,5,-186,-38,227,0,-195,1567,6121,10767,10808,4290,-5337,-11780,-10977,-3943,4319,8368,6139,718,-1998,1261,7718,11320,9073,3840,799,2191,6017,8724,7996,3645,-2534,-7446,-8532,-5966,-2775,-2154,-4613,-7882,-9311,-8077,-5402,-3229,-2729,-3610,-4494,-4073,-2145,333,2121,2614,2062,1193,714,991,1906,2908,3322,2834,1787,956,868,1311,1567,1170,362,-209,-146,407,973,1094,556,-510,-1660,-2407,-2573,-2371,-2153,-2124,-2281,-2495,-2584,-2434,-2129,-1915,-1923,-1973,-1748,-1159,-444,98,372,479,558,679,853,1040,1157,1129,965,763,639,661,815,1012,1115,1019,728,365,72,-97,-206,-345,-538,-739,-882,-941,-932,-890,-858,-861,-899,-943,-956,-916,-824,-700,-578,-478,-384,-259,-86,109,275,375,403,380,353,367,422,467,451,376,295,253,258,290,304,245,89,-121,-296,-380,-391,-375,-360,-350,-346,-343,-326,-298,-289,-323,-384,-435,-452,-425,-358,-266,-182,-134,-104,-52,32,106,128,96,36,-17,-35,-5,55,99,98,61,13,-40,-105,-179,-244,-285,-295,-268,-208,-134,-73,-34,-13,-13,-39,-94,-162,-215,-231,-202,-140,-73,-30,-20,-31,-46,-63,-86,-117,-151,-173,-163,-109,-24,56,99,103,86,65,41,3,-55,-127,-193,-232,-231,-192,-137,-95,-80,-86,-92,-87,-82,-93,-123,-152,-160,-141,-105,-63,-28,-7}
        },
        {    // H20e130a.wav
            {0,0,1,1,1,1,1,1,1,1,1,0,-1,-1,0,0,-1,-2,-1,0,-1,-1,-1,-1,-2,-2,0,0,-1,0,4,4,-1,-2,3,4,-3,-7,0,6,0,-6,6,20,11,-5,4,21,10,67,431,1209,2082,2427,1853,613,-581,-1142,-1036,-687,-542,-659,-636,65,1587,3388,4531,4404,3231,1891,1224,1440,2084,2465,2161,1255,203,-537,-830,-898,-1081,-1523,-2062,-2390,-2311,-1890,-1395,-1096,-1087,-1243,-1320,-1137,-700,-193,163,284,285,363,607,917,1103,1058,833,585,462,518,686,816,777,549,240,-3,-99,-78,-52,-133,-360,-672,-961,-1155,-1257,-1305,-1314,-1274,-1182,-1046,-883,-711,-555,-441,-372,-322,-262,-187,-108,-32,41,108,163,209,254,295,310,279,206,121,54,17,-4,-34,-86,-148,-205,-266,-351,-464,-575,-647,-673,-673,-656,-612,-531,-431,-348,-300,-275,-249,-210,-159,-105,-61,-40,-46,-67,-81,-73,-41,2,39,53,37,6,-19,-34,-56,-99,-150,-182,-181,-161,-145,-146,-165,-194,-222,-239,-243,-237,-231,-224,-211,-187,-154,-115,-76,-50,-45,-58,-74,-79,-70,-54,-42,-39,-43,-45,-39,-26,-13,-6,-9,-23,-43,-62,-77,-88,-100,-113,-124,-131,-134,-134,-135,-142,-154,-160,-152,-131,-108,-90,-73,-57,-48,-50,-59,-72,-94,-125,-154,-168,-171,-170,-156,-114,-51},
            {35,-27,-62,11,74,-3,-99,-16,120,31,-161,-64,197,46,-191,1190,5189,9661,10302,4900,-3808,-10067,-9830,-3756,3583,7074,4756,-444,-2848,799,7839,12098,10141,4554,808,1715,5524,8470,8001,3931,-1937,-6705,-8001,-5851,-2924,-2257,-4526,-7680,-9111,-7918,-5284,-3156,-2695,-3592,-4472,-4022,-2023,511,2197,2377,1505,620,482,1151,2160,2942,3111,2583,1658,927,860,1332,1683,1382,571,-115,-203,237,763,916,462,-508,-1593,-2314,-2475,-2287,-2112,-2150,-2362,-2581,-2622,-2377,-1937,-1571,-1485,-1576,-1525,-1142,-552,-24,293,443,546,678,849,1008,1076,1005,828,643,551,603,768,945,1004,873,593,287,67,-51,-134,-257,-440,-646,-812,-893,-890,-842,-803,-806,-843,-879,-879,-826,-731,-615,-512,-438,-371,-267,-104,89,260,368,399,372,333,330,369,398,360,262,170,141,177,234,256,195,46,-138,-274,-321,-310,-297,-306,-325,-335,-327,-298,-263,-255,-292,-354,-399,-404,-372,-316,-254,-206,-184,-164,-109,-18,66,101,81,30,-19,-41,-20,29,64,57,18,-23,-55,-90,-135,-183,-224,-246,-240,-205,-154,-108,-75,-47,-23,-14,-32,-72,-116,-146,-146,-118,-80,-59,-61,-72,-76,-72,-74,-90,-119,-149,-160,-134,-70,5,55,62,41,21,12,2,-27,-79,-138,-180,-188,-164,-129,-109,-110,-122,-127,-121,-114,-119,-144,-175,-187,-158,-97,-37,-4}
        },
        {    // H20e135a.wav
            {0,1,1,1,2,2,1,0,0,0,-1,-2,-1,0,-1,-1,0,1,0,-1,0,0,-2,-2,0,1,0,0,2,3,0,0,4,5,-2,-6,0,6,-1,-8,4,19,10,-7,6,30,14,44,383,1192,2171,2640,2110,782,-585,-1302,-1247,-833,-571,-615,-608,37,1567,3484,4780,4724,3485,2000,1214,1399,2085,2525,2240,1280,112,-736,-1044,-1024,-1103,-1540,-2213,-2733,-2773,-2319,-1660,-1167,-1033,-1167,-1288,-1151,-728,-212,155,279,269,307,484,744,961,1039,955,760,561,473,534,667,747,717,607,476,364,280,213,129,-27,-281,-603,-923,-1188,-1378,-1488,-1512,-1450,-1321,-1154,-972,-801,-665,-572,-501,-417,-308,-194,-95,-7,89,201,317,410,455,433,341,205,76,-4,-30,-26,-18,-16,-34,-97,-215,-355,-461,-512,-538,-577,-619,-622,-572,-501,-446,-412,-381,-345,-308,-271,-230,-191,-169,-172,-183,-175,-133,-59,28,102,136,125,95,75,69,50,-1,-71,-130,-164,-177,-176,-164,-149,-151,-183,-233,-272,-282,-266,-242,-225,-214,-201,-175,-134,-89,-56,-47,-58,-74,-83,-82,-79,-78,-78,-72,-55,-30,-3,15,19,8,-12,-31,-46,-60,-77,-99,-122,-139,-147,-146,-143,-144,-152,-162,-168,-168,-159,-139,-109,-78,-53,-36,-27,-30,-50,-82,-116,-145,-167,-176,-166,-142,-113,-85,-55,-23},
            {1,34,2,-52,-18,58,27,-75,-48,89,71,-115,-112,135,119,-171,610,3783,8131,9876,6199,-1387,-7854,-8900,-4357,1999,5437,3759,-857,-3310,-47,7147,12394,11454,5912,1215,1092,4552,7834,8014,4652,-674,-5423,-7348,-6033,-3469,-2488,-4202,-7098,-8692,-7842,-5449,-3343,-2733,-3464,-4306,-3953,-2067,397,1981,1979,991,239,439,1351,2293,2822,2859,2453,1736,1067,881,1226,1611,1486,829,126,-165,23,425,667,431,-361,-1399,-2158,-2351,-2173,-2037,-2152,-2421,-2638,-2644,-2366,-1869,-1391,-1180,-1228,-1265,-1048,-604,-143,182,375,516,668,844,1002,1058,954,735,530,453,525,673,794,803,678,471,270,127,32,-66,-206,-391,-591,-751,-822,-802,-745,-719,-748,-797,-819,-791,-720,-623,-522,-442,-393,-354,-281,-146,31,208,338,393,376,325,294,302,310,267,173,86,56,84,134,162,131,27,-116,-235,-281,-267,-249,-262,-295,-316,-305,-266,-222,-206,-237,-300,-354,-368,-337,-283,-234,-212,-213,-209,-167,-87,-2,55,67,38,-13,-54,-55,-21,9,6,-18,-36,-45,-60,-93,-138,-182,-216,-230,-218,-184,-141,-96,-48,1,37,43,14,-37,-89,-119,-116,-95,-80,-84,-94,-95,-84,-72,-75,-102,-145,-178,-174,-123,-47,14,36,27,14,14,20,11,-28,-90,-150,-184,-188,-175,-162,-160,-169,-177,-168,-142,-118,-112,-120,-121,-99,-59,-21}
        },
        {    // H20e140a.wav
            {0,0,1,1,0,-1,-1,-1,-2,-3,-2,-2,-3,-4,-2,0,-1,-2,-2,-2,-4,-4,-2,-2,-4,-4,0,2,-2,-4,1,4,-4,-12,-5,5,-2,-14,-6,14,12,-8,-1,29,21,33,336,1154,2240,2868,2418,997,-584,-1491,-1491,-1002,-623,-593,-579,44,1585,3588,5013,5029,3733,2105,1211,1405,2179,2683,2373,1313,17,-947,-1323,-1283,-1246,-1542,-2160,-2765,-2981,-2689,-2112,-1604,-1365,-1328,-1280,-1060,-664,-206,175,392,456,457,500,631,809,937,927,766,542,399,421,558,670,660,549,436,399,442,506,503,362,77,-285,-631,-904,-1104,-1251,-1357,-1414,-1401,-1308,-1153,-983,-853,-783,-745,-684,-571,-417,-253,-102,31,151,264,370,456,498,473,373,220,60,-52,-88,-70,-56,-96,-189,-288,-350,-377,-409,-467,-524,-538,-502,-450,-420,-414,-410,-390,-356,-316,-280,-259,-264,-296,-334,-345,-298,-191,-57,58,123,143,142,133,117,93,67,42,7,-49,-118,-173,-192,-180,-167,-178,-209,-240,-258,-264,-266,-266,-261,-249,-223,-184,-136,-91,-65,-58,-60,-62,-69,-85,-103,-113,-115,-111,-98,-69,-28,11,33,32,11,-21,-54,-79,-96,-109,-119,-126,-131,-135,-140,-149,-162,-178,-189,-188,-176,-158,-134,-101,-65,-39,-31,-36,-51,-76,-109,-136,-148,-149,-146,-138,-118,-93,-76,-69,-56,-28},
            {-16,-4,29,15,-41,-39,35,48,-43,-72,41,95,-50,-141,44,164,-86,130,2290,6231,9044,7451,1455,-5057,-7651,-5087,2,3481,2861,-777,-3341,-1072,5607,11783,12520,7772,2291,681,3250,6707,7773,5494,1002,-3620,-6307,-6130,-4182,-2878,-3796,-6209,-7969,-7664,-5731,-3727,-2892,-3311,-4026,-3829,-2250,-32,1452,1461,560,-20,381,1396,2267,2644,2634,2368,1860,1270,962,1113,1437,1464,1041,434,3,-77,148,439,419,-170,-1135,-1917,-2133,-1957,-1862,-2078,-2443,-2691,-2690,-2415,-1912,-1362,-1024,-990,-1064,-967,-633,-221,102,304,448,600,788,978,1066,963,702,443,332,391,522,614,609,515,376,246,155,92,21,-95,-275,-495,-687,-778,-751,-664,-603,-617,-680,-731,-721,-647,-540,-444,-384,-361,-352,-320,-230,-74,110,265,343,339,287,238,222,223,198,126,39,-5,15,63,88,61,-11,-103,-181,-220,-218,-204,-210,-242,-278,-289,-263,-213,-173,-175,-217,-272,-304,-303,-281,-258,-244,-240,-233,-202,-138,-61,-3,15,-3,-39,-70,-78,-63,-43,-39,-50,-56,-49,-41,-50,-84,-134,-184,-216,-216,-184,-136,-84,-30,26,71,85,61,12,-41,-81,-102,-105,-101,-104,-117,-125,-113,-89,-76,-94,-137,-176,-183,-149,-88,-26,15,30,28,23,20,9,-29,-96,-168,-213,-225,-221,-217,-212,-197,-171,-137,-97,-58,-39,-49,-68,-64,-33}
        },
        {    // H20e145a.wav
            {3,3,0,-1,0,1,-1,-3,-2,0,0,-1,0,1,0,-1,0,0,-2,-4,-2,0,-1,-1,2,4,0,-3,2,6,-1,-9,-3,8,2,-12,-7,14,14,-8,-2,35,31,24,301,1143,2340,3112,2723,1208,-580,-1672,-1730,-1174,-685,-586,-566,48,1638,3769,5332,5388,3987,2175,1153,1358,2257,2885,2595,1425,-45,-1156,-1596,-1536,-1431,-1650,-2213,-2814,-3085,-2879,-2364,-1861,-1589,-1530,-1492,-1282,-842,-274,241,554,653,650,674,766,879,938,895,751,556,397,345,394,463,474,420,362,357,411,479,498,416,224,-39,-313,-560,-776,-967,-1114,-1184,-1164,-1080,-978,-897,-855,-852,-868,-869,-814,-681,-488,-280,-94,60,192,307,392,430,414,350,257,169,110,66,-6,-128,-263,-347,-359,-340,-344,-380,-416,-433,-438,-439,-428,-393,-346,-307,-283,-264,-250,-256,-294,-347,-382,-375,-323,-244,-160,-87,-24,35,92,132,142,126,100,76,49,7,-46,-94,-121,-129,-133,-146,-170,-198,-225,-247,-264,-275,-278,-272,-254,-224,-182,-134,-86,-46,-26,-31,-56,-84,-103,-111,-114,-115,-109,-93,-68,-39,-10,11,16,2,-25,-54,-79,-101,-118,-126,-125,-118,-110,-110,-122,-140,-158,-172,-179,-175,-156,-128,-98,-69,-41,-26,-35,-64,-93,-109,-116,-122,-125,-120,-114,-112,-102,-73,-41,-35,-53,-60,-36},
            {16,-9,-20,14,33,-12,-49,0,56,4,-73,-16,92,30,-121,-55,148,50,-103,995,4096,7541,8103,4286,-1686,-5717,-5482,-2105,1217,1836,-402,-2846,-1944,3399,10005,12847,9921,4306,947,1880,5036,7045,6183,2859,-1388,-4751,-5896,-4920,-3513,-3521,-5167,-6953,-7306,-6049,-4281,-3202,-3181,-3640,-3598,-2488,-705,670,891,289,-115,308,1273,2092,2440,2461,2321,1993,1498,1096,1040,1244,1357,1146,688,223,-41,-14,214,331,1,-765,-1523,-1845,-1771,-1712,-1936,-2323,-2611,-2675,-2507,-2102,-1530,-1023,-806,-845,-877,-694,-331,43,320,493,603,697,813,930,959,830,582,348,233,242,308,366,380,339,253,159,98,68,12,-130,-353,-575,-701,-697,-607,-515,-488,-536,-605,-624,-567,-469,-387,-350,-347,-356,-351,-301,-181,-9,154,251,270,240,202,179,172,157,111,38,-23,-37,-11,17,16,-21,-80,-135,-167,-173,-172,-189,-227,-265,-276,-249,-196,-145,-124,-143,-183,-218,-239,-252,-261,-265,-262,-252,-228,-179,-112,-52,-26,-37,-69,-98,-110,-105,-93,-86,-83,-71,-43,-11,2,-19,-73,-142,-200,-219,-191,-130,-60,6,62,101,110,83,30,-28,-72,-94,-97,-94,-97,-112,-130,-135,-117,-88,-78,-101,-140,-162,-150,-112,-64,-20,8,10,-7,-24,-34,-55,-103,-168,-221,-244,-239,-216,-184,-152,-124,-95,-59,-25,-14,-25,-33,-21}
        },
        {    // H20e150a.wav
            {1,0,0,0,-2,-3,-2,0,-1,-2,-1,0,0,0,1,1,-2,-4,-2,1,0,-2,1,4,1,-2,1,6,0,-10,-5,10,6,-13,-12,13,17,-10,-10,34,40,17,259,1117,2437,3388,3082,1447,-602,-1915,-2020,-1352,-721,-559,-562,26,1676,3961,5688,5799,4288,2262,1069,1266,2308,3097,2839,1541,-122,-1371,-1850,-1765,-1610,-1772,-2290,-2889,-3207,-3064,-2586,-2089,-1809,-1725,-1637,-1371,-914,-380,95,432,636,770,895,1009,1063,1027,922,787,646,510,402,340,311,282,240,204,207,264,352,409,363,183,-85,-347,-540,-666,-761,-842,-892,-888,-829,-741,-654,-600,-608,-685,-791,-853,-809,-657,-450,-250,-83,57,180,280,338,344,302,226,132,33,-59,-127,-161,-171,-196,-265,-363,-438,-454,-424,-396,-399,-423,-435,-408,-342,-258,-191,-169,-198,-259,-318,-343,-319,-264,-210,-179,-157,-115,-41,42,94,96,68,41,31,25,7,-27,-69,-108,-133,-137,-124,-107,-107,-135,-180,-225,-258,-279,-286,-278,-261,-237,-200,-143,-75,-22,-3,-15,-42,-75,-106,-125,-129,-122,-111,-94,-63,-24,7,17,4,-26,-63,-98,-123,-136,-141,-140,-131,-119,-108,-101,-100,-110,-132,-158,-174,-173,-155,-123,-81,-39,-15,-18,-40,-69,-99,-123,-135,-132,-125,-120,-113,-99,-82,-70,-58,-40,-28,-38,-62,-66,-37},
            {-2,16,9,-15,-6,26,14,-35,-29,35,41,-40,-58,44,80,-51,-114,55,139,-78,177,2101,5406,7656,6393,1873,-2904,-4960,-3769,-1179,405,-192,-1984,-2280,1089,7153,11849,11628,7086,2388,1081,3069,5610,6280,4492,1053,-2622,-5023,-5355,-4308,-3586,-4260,-5760,-6658,-6204,-4882,-3691,-3211,-3275,-3263,-2651,-1467,-301,233,119,-62,231,978,1744,2201,2351,2315,2101,1696,1257,1034,1098,1232,1158,811,373,76,13,108,165,-6,-444,-973,-1356,-1532,-1654,-1878,-2178,-2419,-2516,-2458,-2222,-1798,-1297,-916,-754,-704,-590,-344,-34,252,468,601,661,698,765,853,886,793,573,298,58,-72,-55,81,239,315,276,173,77,3,-91,-236,-402,-526,-566,-534,-482,-456,-468,-497,-507,-480,-428,-377,-345,-338,-353,-379,-377,-303,-149,36,178,235,215,161,120,116,133,132,86,10,-56,-85,-78,-52,-33,-40,-78,-129,-168,-188,-201,-222,-247,-259,-244,-200,-141,-94,-81,-104,-144,-181,-212,-243,-268,-279,-275,-256,-220,-162,-97,-51,-43,-70,-114,-152,-167,-153,-121,-90,-64,-37,-9,7,-5,-47,-104,-153,-176,-164,-122,-64,-7,42,80,98,88,53,5,-41,-75,-91,-92,-91,-102,-124,-139,-131,-100,-70,-66,-91,-125,-146,-145,-124,-97,-78,-70,-68,-62,-53,-55,-81,-129,-180,-210,-210,-189,-163,-140,-119,-93,-63,-35,-18,-11,-7}
        },
        {    // H20e155a.wav
            {0,1,-1,-3,-3,-1,0,-2,-2,0,1,0,0,1,-2,-5,-2,2,1,-3,0,6,3,-4,-1,7,3,-11,-9,8,9,-10,-13,12,18,-13,-18,33,50,10,207,1067,2518,3685,3506,1764,-586,-2192,-2393,-1604,-774,-498,-523,0,1680,4138,6076,6269,4639,2376,990,1155,2328,3303,3135,1742,-161,-1642,-2210,-2057,-1781,-1867,-2374,-2986,-3312,-3180,-2734,-2284,-2042,-1965,-1841,-1506,-977,-395,95,427,619,750,898,1072,1200,1201,1068,872,698,582,510,446,361,246,124,44,47,132,242,291,213,7,-260,-499,-657,-740,-788,-826,-840,-794,-674,-512,-374,-315,-348,-441,-539,-591,-571,-489,-384,-286,-194,-88,37,163,262,305,267,140,-40,-194,-256,-232,-192,-196,-240,-278,-288,-288,-313,-378,-466,-538,-554,-496,-385,-272,-203,-193,-226,-265,-273,-232,-160,-105,-108,-158,-200,-180,-93,17,103,138,122,69,2,-53,-81,-90,-101,-128,-164,-186,-174,-134,-93,-84,-114,-164,-204,-224,-234,-248,-264,-268,-246,-197,-132,-66,-18,-1,-15,-47,-79,-102,-116,-123,-121,-110,-89,-60,-25,5,16,2,-32,-72,-110,-145,-177,-197,-197,-176,-143,-109,-85,-78,-90,-117,-147,-167,-167,-146,-108,-64,-25,2,10,-5,-40,-83,-120,-143,-150,-143,-127,-108,-91,-74,-57,-46,-44,-47,-47,-48,-57,-67,-59,-29},
            {-1,-7,5,14,-3,-15,7,23,-9,-39,-4,44,7,-58,-20,70,30,-95,-56,112,56,-96,658,3046,6009,7111,4920,611,-3099,-4340,-3280,-1486,-594,-1138,-1901,-611,3774,9226,11906,9861,5109,1603,1452,3557,5422,5405,3321,-23,-3263,-5045,-4982,-4078,-3790,-4586,-5656,-5980,-5351,-4323,-3504,-3090,-2905,-2640,-2086,-1298,-569,-153,-3,178,621,1274,1884,2240,2307,2152,1843,1455,1130,1007,1063,1089,895,526,208,92,107,82,-66,-299,-556,-820,-1103,-1423,-1770,-2099,-2337,-2427,-2357,-2147,-1835,-1482,-1170,-940,-756,-545,-284,-13,219,385,485,540,595,694,823,910,881,713,434,110,-160,-279,-218,-48,115,207,235,218,147,10,-172,-345,-460,-494,-463,-406,-376,-402,-457,-488,-465,-411,-366,-348,-349,-362,-386,-400,-360,-243,-79,71,163,192,171,128,98,105,131,126,56,-51,-135,-159,-131,-86,-54,-54,-86,-137,-185,-218,-236,-246,-248,-235,-198,-142,-87,-59,-67,-99,-139,-184,-229,-262,-272,-266,-257,-242,-205,-144,-84,-51,-51,-75,-112,-150,-174,-175,-156,-126,-88,-44,-6,7,-15,-62,-111,-143,-146,-123,-85,-44,-5,34,68,88,85,59,15,-35,-76,-98,-106,-114,-127,-137,-125,-87,-45,-28,-50,-102,-160,-201,-211,-192,-155,-117,-88,-69,-54,-42,-46,-73,-115,-150,-166,-168,-165,-159,-146,-127,-104,-76,-44,-16}
        },
        {    // H20e160a.wav
            {-2,-4,-3,0,0,-3,-3,-1,0,-1,-1,0,-2,-5,-3,1,-1,-4,-1,5,3,-5,-3,6,2,-13,-12,8,11,-12,-20,9,23,-12,-31,22,58,12,156,993,2558,3967,3977,2171,-501,-2469,-2825,-1925,-868,-451,-495,-49,1662,4318,6507,6810,5051,2512,895,1014,2320,3491,3439,1988,-129,-1860,-2574,-2412,-2033,-2022,-2486,-3101,-3439,-3299,-2827,-2370,-2173,-2178,-2106,-1742,-1116,-435,115,470,663,775,900,1091,1291,1359,1212,927,684,595,612,599,471,259,61,-37,-11,100,210,224,91,-163,-455,-705,-874,-958,-973,-943,-889,-809,-687,-525,-365,-255,-208,-200,-209,-223,-235,-226,-185,-119,-45,34,122,203,236,182,46,-118,-235,-268,-243,-226,-261,-334,-389,-386,-338,-295,-299,-358,-442,-513,-542,-523,-467,-400,-344,-299,-244,-163,-75,-24,-36,-91,-147,-168,-143,-78,8,87,133,135,102,52,2,-36,-67,-105,-162,-227,-270,-262,-209,-146,-113,-123,-159,-192,-209,-213,-215,-219,-224,-225,-213,-182,-131,-71,-23,-3,-11,-35,-65,-95,-119,-133,-137,-127,-99,-55,-11,16,15,-10,-49,-92,-129,-161,-193,-223,-235,-218,-174,-121,-83,-72,-90,-127,-167,-188,-178,-141,-92,-42,2,33,40,17,-29,-81,-123,-144,-142,-125,-104,-89,-82,-78,-73,-62,-50,-46,-56,-69,-72,-66,-60,-56,-44,-21},
            {1,3,-4,-2,11,10,-8,-7,15,14,-21,-29,15,35,-17,-49,14,63,-14,-89,8,113,-18,9,1159,3677,6155,6501,3974,-38,-3272,-4347,-3436,-1822,-926,-1138,-1166,965,5557,10104,11296,8343,3842,1188,1572,3598,5110,4804,2574,-734,-3681,-5036,-4735,-3917,-3780,-4482,-5268,-5433,-4904,-4044,-3226,-2675,-2444,-2358,-2090,-1467,-688,-113,149,358,809,1472,2034,2257,2173,1942,1642,1295,1001,888,929,931,753,458,200,42,-45,-89,-116,-207,-440,-780,-1122,-1439,-1797,-2188,-2456,-2440,-2156,-1764,-1414,-1170,-1024,-921,-763,-474,-91,246,416,427,393,429,572,774,932,949,791,509,201,-45,-186,-225,-194,-123,-24,90,186,217,150,-5,-202,-380,-492,-516,-473,-413,-381,-386,-409,-429,-437,-426,-396,-357,-334,-339,-358,-349,-286,-174,-38,93,190,228,201,142,99,91,87,45,-38,-125,-177,-183,-156,-115,-79,-70,-94,-138,-180,-211,-235,-255,-260,-235,-178,-109,-58,-43,-60,-98,-151,-210,-257,-271,-256,-231,-209,-184,-147,-103,-65,-41,-34,-49,-89,-141,-182,-196,-185,-158,-121,-77,-41,-30,-48,-79,-101,-106,-96,-77,-53,-29,-7,16,44,70,81,66,28,-19,-65,-105,-136,-152,-146,-118,-76,-34,-11,-25,-79,-152,-215,-245,-236,-196,-145,-103,-75,-51,-26,-11,-17,-44,-82,-125,-164,-186,-186,-176,-173,-166,-128,-60}
        },
        {    // H20e165a.wav
            {-4,-1,1,-1,-2,0,0,-2,-1,1,-1,-6,-5,1,2,-2,-1,5,6,-3,-4,7,7,-11,-17,5,17,-6,-23,5,29,-4,-37,11,64,17,105,888,2536,4207,4489,2706,-277,-2688,-3308,-2342,-1018,-396,-449,-136,1547,4414,6940,7446,5589,2730,809,829,2260,3655,3762,2294,-19,-2018,-2919,-2782,-2307,-2191,-2618,-3253,-3617,-3465,-2939,-2424,-2218,-2283,-2299,-1980,-1324,-565,68,499,759,893,962,1058,1233,1409,1419,1185,831,582,543,607,580,380,98,-105,-130,10,205,304,187,-154,-591,-953,-1142,-1178,-1142,-1101,-1060,-984,-838,-631,-420,-273,-210,-188,-146,-63,35,105,130,135,172,269,383,422,329,138,-56,-181,-237,-261,-282,-311,-352,-404,-446,-453,-424,-391,-393,-439,-506,-560,-583,-576,-546,-493,-408,-285,-137,-11,44,16,-53,-107,-118,-96,-59,-10,50,109,147,149,118,70,20,-26,-68,-109,-152,-198,-246,-283,-289,-255,-197,-154,-153,-187,-225,-241,-237,-230,-228,-220,-195,-150,-91,-30,17,35,17,-27,-77,-114,-131,-131,-121,-108,-91,-65,-29,5,17,-4,-49,-100,-145,-180,-206,-221,-221,-205,-175,-138,-103,-86,-94,-121,-156,-185,-192,-170,-123,-62,1,55,85,77,31,-34,-94,-134,-146,-132,-103,-77,-62,-52,-41,-36,-43,-60,-77,-91,-99,-92,-63,-31,-23,-39,-49,-31},
            {-10,-5,5,3,-6,-1,11,6,-9,-2,16,6,-24,-19,20,21,-28,-36,26,43,-36,-66,39,80,-51,172,1564,4047,6133,6027,3307,-635,-3718,-4625,-3503,-1707,-733,-822,-467,2114,6655,10398,10541,7084,2850,774,1523,3586,4956,4435,1998,-1334,-4015,-4971,-4427,-3609,-3544,-4241,-4987,-5156,-4622,-3661,-2732,-2257,-2315,-2498,-2252,-1448,-529,18,209,462,1028,1694,2093,2128,1975,1772,1485,1105,793,723,847,931,798,464,74,-208,-262,-105,61,-12,-378,-852,-1247,-1566,-1895,-2191,-2302,-2169,-1892,-1589,-1291,-1007,-789,-667,-565,-366,-61,228,380,393,369,420,585,802,946,904,665,331,48,-95,-106,-59,-28,-37,-63,-69,-41,2,20,-32,-173,-372,-552,-640,-621,-537,-451,-401,-388,-392,-388,-368,-340,-321,-315,-312,-298,-261,-187,-72,60,166,216,211,174,132,95,58,10,-59,-140,-205,-225,-196,-138,-85,-63,-80,-121,-165,-200,-231,-259,-280,-281,-253,-196,-122,-55,-24,-45,-101,-161,-202,-221,-221,-211,-198,-185,-164,-126,-73,-22,6,-3,-44,-104,-160,-196,-209,-210,-200,-173,-134,-97,-72,-57,-50,-58,-79,-95,-92,-72,-47,-19,18,57,79,75,49,10,-36,-83,-120,-141,-147,-139,-116,-82,-47,-26,-31,-72,-141,-208,-238,-225,-189,-146,-97,-45,-7,6,5,-5,-40,-108,-176,-210,-219,-236,-248,-205,-100}
        },
        {    // H20e170a.wav
            {1,-2,-3,-1,1,-1,-2,0,-1,-5,-5,1,3,-2,-2,6,7,-3,-6,6,9,-9,-20,-1,16,-4,-25,0,32,3,-42,-4,63,24,64,774,2466,4387,4994,3328,84,-2821,-3817,-2866,-1265,-370,-387,-234,1362,4423,7348,8155,6259,3058,758,612,2147,3784,4077,2613,119,-2136,-3229,-3147,-2616,-2410,-2778,-3405,-3793,-3658,-3104,-2518,-2257,-2340,-2435,-2181,-1522,-712,-24,457,794,1031,1155,1185,1210,1291,1367,1311,1085,807,638,611,596,443,143,-153,-264,-130,140,334,276,-59,-542,-992,-1292,-1425,-1428,-1348,-1231,-1104,-968,-805,-612,-424,-278,-176,-90,-6,66,124,198,318,461,559,563,488,394,318,241,120,-50,-225,-348,-398,-404,-416,-460,-513,-532,-504,-471,-490,-577,-693,-781,-793,-699,-505,-269,-76,11,0,-47,-72,-65,-46,-35,-36,-38,-24,19,84,148,182,169,113,38,-26,-62,-83,-116,-176,-249,-302,-308,-268,-211,-179,-194,-236,-267,-267,-251,-242,-245,-244,-224,-175,-99,-11,59,84,58,-2,-67,-112,-132,-136,-136,-132,-113,-75,-32,-3,4,-13,-51,-104,-155,-191,-212,-224,-224,-204,-167,-127,-99,-90,-100,-129,-168,-198,-204,-182,-137,-79,-19,29,59,68,54,18,-31,-75,-103,-116,-115,-101,-76,-51,-31,-17,-14,-31,-70,-111,-136,-140,-126,-94,-49,-17,-24,-55,-67,-39},
            {1,-3,-8,-4,3,1,-4,1,9,2,-8,0,14,2,-22,-12,17,8,-31,-23,32,30,-42,-47,49,56,-40,328,1850,4271,6082,5633,2666,-1336,-4236,-4741,-3209,-1270,-429,-581,37,2950,7358,10373,9699,5939,2006,448,1548,3683,4897,4093,1429,-1853,-4176,-4710,-3963,-3211,-3318,-4127,-4868,-4915,-4193,-3125,-2329,-2188,-2512,-2666,-2183,-1231,-382,45,269,665,1269,1783,1991,1963,1845,1632,1258,829,603,709,968,1055,792,286,-188,-388,-265,5,152,14,-365,-837,-1302,-1711,-1991,-2066,-1966,-1826,-1721,-1573,-1275,-865,-506,-312,-249,-207,-117,22,173,304,407,507,633,768,840,781,596,356,144,8,-40,-13,44,64,-2,-133,-250,-287,-255,-237,-304,-452,-612,-714,-729,-670,-566,-448,-346,-280,-249,-240,-234,-225,-215,-212,-210,-188,-122,-9,120,219,250,208,127,57,26,14,-22,-99,-185,-236,-231,-183,-119,-68,-58,-97,-164,-223,-257,-278,-299,-317,-312,-270,-194,-104,-28,13,9,-32,-92,-147,-183,-199,-205,-202,-182,-139,-81,-23,20,33,4,-61,-135,-189,-212,-217,-214,-203,-177,-141,-106,-83,-75,-81,-93,-103,-106,-100,-82,-52,-10,37,80,104,94,47,-21,-85,-132,-159,-165,-149,-115,-80,-46,-12,7,-12,-71,-137,-181,-198,-193,-164,-115,-66,-35,-13,5,0,-47,-114,-166,-203,-248,-278,-235,-116}
        },
        {    // H20e175a.wav
            {-5,-1,2,0,-3,-1,-1,-6,-7,-1,3,-1,-3,4,8,-1,-7,3,9,-7,-20,-3,16,-2,-27,-5,32,8,-44,-14,62,30,30,668,2369,4490,5426,3964,572,-2794,-4248,-3431,-1601,-391,-316,-325,1120,4320,7659,8848,7005,3506,797,408,1981,3853,4382,2970,294,-2252,-3549,-3487,-2868,-2599,-2975,-3632,-4013,-3832,-3222,-2589,-2300,-2392,-2536,-2336,-1697,-869,-157,349,740,1085,1339,1436,1398,1310,1233,1166,1083,982,885,800,689,499,212,-105,-313,-295,-59,224,321,96,-394,-953,-1382,-1594,-1623,-1556,-1458,-1335,-1158,-922,-674,-479,-359,-281,-198,-83,63,213,322,364,363,390,493,639,729,689,522,294,81,-69,-154,-215,-299,-415,-516,-551,-521,-483,-503,-608,-768,-912,-957,-853,-628,-379,-206,-139,-128,-105,-54,-3,18,8,-19,-56,-89,-90,-34,66,159,197,176,126,76,37,6,-34,-97,-182,-268,-317,-306,-248,-184,-154,-171,-220,-273,-309,-320,-314,-297,-270,-227,-163,-80,6,67,79,41,-19,-71,-101,-113,-117,-120,-121,-116,-101,-73,-41,-23,-28,-52,-86,-126,-169,-205,-227,-233,-220,-186,-136,-89,-65,-75,-111,-157,-196,-212,-196,-152,-91,-25,35,75,81,54,8,-42,-88,-118,-120,-99,-69,-42,-17,3,7,-10,-38,-72,-114,-159,-180,-162,-121,-86,-59,-33,-24,-55,-107,-120,-69},
            {-2,0,1,-3,-7,-2,4,1,-3,3,9,1,-7,3,13,-2,-22,-9,17,5,-28,-15,33,23,-41,-33,54,45,-15,458,2068,4429,5981,5171,1936,-2036,-4547,-4508,-2653,-818,-274,-475,448,3611,7754,10053,8760,4923,1392,319,1678,3786,4770,3691,920,-2165,-4081,-4284,-3497,-2942,-3245,-4070,-4646,-4489,-3693,-2770,-2261,-2336,-2638,-2601,-1980,-1070,-335,86,421,881,1393,1746,1865,1827,1673,1366,952,651,665,930,1131,998,546,19,-327,-384,-211,33,161,49,-308,-813,-1331,-1735,-1938,-1928,-1796,-1658,-1541,-1366,-1070,-708,-400,-211,-116,-68,-44,-21,43,174,352,528,666,755,782,734,618,454,267,90,-28,-53,-9,22,-33,-178,-348,-475,-543,-582,-629,-685,-725,-727,-685,-606,-506,-403,-312,-236,-170,-111,-67,-50,-64,-101,-140,-154,-117,-21,107,211,243,199,118,47,9,-10,-44,-110,-190,-247,-255,-210,-139,-83,-77,-129,-213,-286,-325,-336,-337,-330,-299,-234,-139,-38,36,60,34,-20,-75,-118,-149,-168,-174,-169,-156,-128,-76,-14,27,25,-13,-68,-124,-176,-216,-235,-229,-208,-177,-139,-101,-75,-73,-94,-127,-150,-150,-127,-91,-45,13,74,112,105,59,-3,-67,-126,-166,-168,-137,-99,-67,-30,13,37,22,-23,-73,-117,-152,-167,-156,-131,-108,-86,-62,-45,-46,-56,-68,-105,-181,-250,-233,-120}
        },
        {    // H20e180a.wav
            {2,0,-2,-1,-2,-6,-7,0,4,-2,-5,3,8,-1,-9,1,10,-5,-22,-7,17,2,-28,-12,30,14,-44,-26,56,36,7,566,2236,4504,5763,4597,1205,-2542,-4530,-4020,-2079,-526,-260,-404,811,4062,7824,9505,7844,4127,1015,317,1812,3824,4590,3328,570,-2261,-3842,-3875,-3166,-2781,-3141,-3866,-4304,-4104,-3402,-2654,-2292,-2396,-2613,-2473,-1835,-980,-272,202,598,1028,1420,1649,1688,1584,1376,1103,871,810,927,1052,983,678,264,-95,-300,-318,-166,66,207,96,-294,-837,-1348,-1689,-1819,-1783,-1662,-1514,-1335,-1097,-817,-565,-394,-284,-180,-58,55,125,157,196,289,445,623,752,785,721,594,438,270,107,-24,-108,-160,-212,-280,-354,-425,-507,-625,-769,-882,-903,-823,-692,-570,-478,-403,-331,-256,-173,-82,4,55,52,0,-76,-138,-151,-98,5,117,195,216,186,130,72,22,-29,-91,-161,-224,-264,-271,-242,-185,-133,-125,-171,-245,-307,-340,-350,-346,-321,-265,-179,-81,2,54,69,48,-4,-70,-123,-143,-138,-131,-131,-126,-102,-64,-33,-17,-17,-37,-79,-129,-169,-196,-220,-237,-232,-195,-140,-90,-62,-64,-93,-137,-177,-195,-182,-135,-63,12,66,88,79,43,-14,-74,-116,-133,-131,-116,-85,-43,-5,22,37,34,-1,-63,-124,-163,-182,-185,-160,-108,-62,-48,-50,-42,-47,-101,-175,-185,-102},
            {2,0,-2,-1,-2,-6,-7,0,4,-2,-5,3,8,-1,-9,1,10,-5,-22,-7,17,2,-28,-12,30,14,-44,-26,56,36,7,566,2236,4504,5763,4597,1205,-2542,-4530,-4020,-2079,-526,-260,-404,811,4062,7824,9505,7844,4127,1015,317,1812,3824,4590,3328,570,-2261,-3842,-3875,-3166,-2781,-3141,-3866,-4304,-4104,-3402,-2654,-2292,-2396,-2613,-2473,-1835,-980,-272,202,598,1028,1420,1649,1688,1584,1376,1103,871,810,927,1052,983,678,264,-95,-300,-318,-166,66,207,96,-294,-837,-1348,-1689,-1819,-1783,-1662,-1514,-1335,-1097,-817,-565,-394,-284,-180,-58,55,125,157,196,289,445,623,752,785,721,594,438,270,107,-24,-108,-160,-212,-280,-354,-425,-507,-625,-769,-882,-903,-823,-692,-570,-478,-403,-331,-256,-173,-82,4,55,52,0,-76,-138,-151,-98,5,117,195,216,186,130,72,22,-29,-91,-161,-224,-264,-271,-242,-185,-133,-125,-171,-245,-307,-340,-350,-346,-321,-265,-179,-81,2,54,69,48,-4,-70,-123,-143,-138,-131,-131,-126,-102,-64,-33,-17,-17,-37,-79,-129,-169,-196,-220,-237,-232,-195,-140,-90,-62,-64,-93,-137,-177,-195,-182,-135,-63,12,66,88,79,43,-14,-74,-116,-133,-131,-116,-85,-43,-5,22,37,34,-1,-63,-124,-163,-182,-185,-160,-108,-62,-48,-50,-42,-47,-101,-175,-185,-102}
        }
    },
    {    // elev30
        {    // H30e000a.wav
            {-4,18,16,-18,-17,30,30,-37,-49,37,65,-45,-96,44,137,-31,-173,27,217,-21,83,1918,5134,7064,5674,2261,-316,-1584,-3566,-6668,-7824,-4385,1634,5453,5336,4390,6132,9988,12252,10400,5360,197,-2334,-1377,1535,3353,1871,-2277,-6298,-8070,-7845,-7110,-6569,-5858,-4751,-3741,-3270,-3029,-2420,-1462,-788,-723,-728,-14,1414,2635,2830,2180,1583,1622,2091,2445,2398,2027,1558,1215,1072,928,486,-189,-604,-440,-32,34,-311,-585,-476,-238,-275,-617,-1016,-1332,-1579,-1727,-1682,-1474,-1243,-1044,-802,-485,-210,-94,-105,-103,26,305,681,1042,1271,1315,1230,1122,1062,1025,904,580,40,-581,-1101,-1435,-1608,-1655,-1566,-1369,-1188,-1151,-1256,-1389,-1441,-1381,-1209,-928,-570,-222,28,151,178,155,116,95,116,165,193,169,124,120,183,283,369,411,396,315,172,3,-144,-248,-315,-363,-405,-451,-496,-516,-486,-413,-339,-301,-302,-322,-343,-346,-314,-245,-155,-58,45,145,214,223,174,93,0,-89,-148,-161,-139,-110,-83,-46,3,44,58,38,-22,-125,-243,-326,-341,-303,-249,-199,-151,-111,-94,-105,-139,-186,-235,-265,-258,-210,-137,-55,28,101,147,151,112,41,-43,-118,-165,-180,-172,-152,-123,-91,-65,-55,-65,-94,-137,-179,-204,-202,-179,-145,-101,-43,21,69,89,80,49,1,-51,-88,-100,-89,-64,-31,5,30,32,12,-8,-11},
            {-4,18,16,-18,-17,30,30,-37,-49,37,65,-45,-96,44,137,-31,-173,27,217,-21,83,1918,5134,7064,5674,2261,-316,-1584,-3566,-6668,-7824,-4385,1634,5453,5336,4390,6132,9988,12252,10400,5360,197,-2334,-1377,1535,3353,1871,-2277,-6298,-8070,-7845,-7110,-6569,-5858,-4751,-3741,-3270,-3029,-2420,-1462,-788,-723,-728,-14,1414,2635,2830,2180,1583,1622,2091,2445,2398,2027,1558,1215,1072,928,486,-189,-604,-440,-32,34,-311,-585,-476,-238,-275,-617,-1016,-1332,-1579,-1727,-1682,-1474,-1243,-1044,-802,-485,-210,-94,-105,-103,26,305,681,1042,1271,1315,1230,1122,1062,1025,904,580,40,-581,-1101,-1435,-1608,-1655,-1566,-1369,-1188,-1151,-1256,-1389,-1441,-1381,-1209,-928,-570,-222,28,151,178,155,116,95,116,165,193,169,124,120,183,283,369,411,396,315,172,3,-144,-248,-315,-363,-405,-451,-496,-516,-486,-413,-339,-301,-302,-322,-343,-346,-314,-245,-155,-58,45,145,214,223,174,93,0,-89,-148,-161,-139,-110,-83,-46,3,44,58,38,-22,-125,-243,-326,-341,-303,-249,-199,-151,-111,-94,-105,-139,-186,-235,-265,-258,-210,-137,-55,28,101,147,151,112,41,-43,-118,-165,-180,-172,-152,-123,-91,-65,-55,-65,-94,-137,-179,-204,-202,-179,-145,-101,-43,21,69,89,80,49,1,-51,-88,-100,-89,-64,-31,5,30,32,12,-8,-11}
        },
        {    // H30e006a.wav
            {3,-4,9,20,1,-16,10,35,-1,-43,-3,59,14,-72,-22,102,58,-107,-66,150,101,-67,767,3173,5649,5869,3556,840,-718,-2067,-4468,-6533,-5470,-1149,3067,4361,3848,4694,7754,10558,10380,7050,2656,-445,-1015,576,2476,2512,39,-3449,-5917,-6771,-6844,-6801,-6350,-5137,-3676,-2862,-2844,-2896,-2396,-1533,-885,-582,-184,646,1620,2154,2077,1785,1726,1929,2123,2121,1950,1707,1467,1254,980,504,-111,-491,-333,133,330,32,-373,-431,-199,-95,-327,-739,-1118,-1413,-1620,-1673,-1546,-1320,-1080,-816,-511,-248,-128,-125,-83,137,526,924,1125,1041,801,644,692,839,882,722,399,-11,-449,-853,-1155,-1324,-1373,-1317,-1177,-1019,-939,-975,-1067,-1131,-1144,-1117,-1019,-796,-470,-163,1,9,-49,-79,-52,17,97,153,152,99,47,55,133,237,320,359,341,257,122,-24,-149,-252,-341,-407,-440,-445,-434,-411,-371,-321,-277,-250,-241,-244,-242,-217,-168,-111,-58,-1,68,131,156,131,74,5,-67,-126,-150,-133,-101,-78,-63,-40,-8,19,30,15,-38,-123,-205,-254,-265,-254,-230,-188,-134,-92,-78,-91,-124,-173,-219,-235,-209,-158,-101,-39,30,93,126,116,74,17,-43,-96,-133,-148,-143,-122,-93,-65,-48,-50,-73,-114,-160,-196,-211,-205,-177,-130,-66,6,64,92,88,60,20,-22,-54,-70,-69,-57,-36,-7,25,48,47,25},
            {28,-14,-32,21,46,-26,-73,15,90,-14,-126,-4,164,31,-204,-59,251,74,-99,1426,4972,7884,7188,3437,-42,-1791,-3765,-7201,-9268,-6337,465,5818,6615,5437,6563,10354,13177,11898,6850,908,-2860,-2831,200,3116,2700,-1406,-6370,-9153,-9252,-8171,-7059,-5879,-4538,-3618,-3535,-3676,-3037,-1556,-283,-93,-576,-491,759,2415,3240,2870,2051,1658,1859,2248,2440,2302,1883,1383,1065,952,727,179,-395,-538,-299,-182,-412,-640,-525,-268,-309,-723,-1208,-1533,-1706,-1752,-1616,-1336,-1091,-978,-879,-633,-268,18,43,-202,-514,-559,-110,713,1485,1824,1703,1417,1250,1237,1185,892,334,-320,-870,-1253,-1528,-1730,-1806,-1732,-1605,-1547,-1555,-1519,-1377,-1188,-1029,-890,-704,-438,-120,179,381,425,323,181,121,163,216,198,137,119,183,287,379,446,469,407,242,30,-143,-245,-308,-370,-430,-474,-500,-497,-454,-382,-324,-316,-353,-401,-433,-435,-392,-308,-203,-93,20,135,229,278,275,220,106,-46,-176,-226,-199,-144,-93,-41,16,56,63,40,-19,-123,-258,-366,-396,-354,-285,-222,-170,-128,-103,-100,-122,-171,-232,-276,-277,-231,-150,-42,75,173,219,204,144,57,-44,-138,-197,-214,-206,-192,-165,-116,-55,-13,-12,-50,-108,-163,-202,-217,-205,-165,-105,-39,22,72,102,96,53,-3,-48,-79,-100,-105,-81,-37,4,30,42,34,-4,-53,-71,-42}
        },
        {    // H30e012a.wav
            {-3,3,-1,-2,9,15,-2,-12,11,25,-8,-35,2,42,0,-58,-8,77,26,-88,-29,122,44,-30,821,2910,4910,5018,3134,919,-515,-1864,-3885,-5411,-4481,-1186,2046,3378,3653,4857,7293,9203,8877,6314,2932,398,-255,821,2204,2167,182,-2664,-4919,-6101,-6565,-6512,-5748,-4385,-3164,-2753,-2977,-3040,-2450,-1491,-760,-447,-197,370,1172,1783,1937,1787,1662,1702,1812,1866,1828,1709,1505,1190,742,214,-195,-236,100,450,407,-17,-398,-418,-209,-125,-325,-689,-1053,-1339,-1503,-1506,-1367,-1150,-882,-559,-250,-100,-163,-294,-260,51,542,971,1113,908,519,219,181,351,530,538,309,-98,-549,-895,-1064,-1097,-1078,-1042,-980,-904,-849,-822,-796,-768,-782,-853,-910,-850,-653,-400,-197,-95,-83,-121,-155,-134,-54,28,48,5,-38,-23,48,136,209,251,245,177,65,-50,-145,-228,-306,-369,-404,-410,-393,-353,-290,-223,-177,-163,-167,-172,-166,-142,-106,-74,-54,-31,12,63,91,76,25,-41,-107,-155,-171,-161,-143,-127,-104,-68,-31,-6,3,-7,-45,-110,-178,-221,-238,-242,-234,-208,-165,-120,-91,-85,-101,-136,-175,-199,-195,-166,-115,-47,26,82,104,89,48,-7,-64,-112,-145,-164,-166,-147,-112,-76,-55,-57,-81,-122,-165,-193,-197,-182,-156,-120,-75,-26,18,46,53,34,-5,-47,-74,-85,-85,-69,-33,9,30,20},
            {-30,17,55,-10,-85,-17,93,27,-124,-58,154,102,-181,-153,211,183,-176,814,4250,8092,8725,5375,1055,-1712,-4027,-7610,-10394,-8288,-1264,5387,7252,6054,6784,10893,14638,13850,8371,1552,-2967,-3457,-699,2394,2578,-1024,-6047,-9324,-9911,-9155,-8281,-7081,-5142,-3216,-2525,-3070,-3476,-2640,-1013,95,186,77,711,1923,2743,2686,2249,2105,2279,2379,2259,2070,1870,1595,1317,1156,960,477,-147,-450,-332,-249,-514,-797,-652,-252,-198,-698,-1361,-1780,-1935,-1949,-1798,-1442,-1032,-766,-625,-453,-231,-123,-256,-553,-779,-705,-257,433,1116,1593,1807,1798,1633,1393,1149,895,547,75,-438,-908,-1353,-1792,-2126,-2213,-2063,-1833,-1621,-1389,-1124,-941,-927,-970,-864,-541,-132,208,426,525,493,355,211,159,186,200,162,126,148,215,289,369,455,490,398,176,-84,-289,-409,-466,-484,-480,-469,-454,-423,-372,-327,-321,-359,-417,-465,-474,-428,-336,-228,-122,-4,136,270,351,355,289,162,-6,-160,-240,-233,-183,-129,-73,-12,34,48,29,-21,-120,-261,-390,-449,-435,-385,-320,-240,-157,-102,-89,-106,-144,-205,-265,-278,-220,-117,-6,99,191,249,248,190,96,-15,-126,-218,-271,-281,-254,-196,-111,-25,29,36,3,-61,-142,-214,-252,-253,-227,-170,-76,30,107,130,108,61,0,-62,-103,-112,-104,-89,-57,-4,41,49,33,18,-4,-59,-125,-139,-79}
        },
        {    // H30e018a.wav
            {-1,-5,-2,2,-1,-3,7,12,-1,-9,7,17,-7,-27,0,30,-1,-44,-9,55,22,-59,-19,82,20,-1,737,2474,4169,4378,2941,1104,-213,-1471,-3253,-4677,-4127,-1478,1443,2985,3498,4469,6359,7993,7956,6010,3172,891,180,995,2158,2174,490,-2087,-4291,-5504,-5872,-5652,-4929,-3918,-3119,-2893,-3018,-2909,-2268,-1396,-799,-598,-424,99,893,1525,1706,1572,1452,1500,1634,1734,1762,1696,1486,1113,651,241,28,82,296,403,214,-150,-362,-262,-49,-34,-295,-655,-931,-1082,-1142,-1132,-1050,-906,-715,-514,-380,-386,-490,-521,-325,83,512,742,678,413,149,47,120,262,360,355,218,-64,-435,-760,-927,-940,-880,-809,-732,-662,-634,-652,-666,-648,-635,-677,-748,-769,-694,-551,-399,-273,-188,-152,-160,-181,-186,-176,-165,-151,-113,-47,17,51,58,64,79,89,70,15,-69,-161,-236,-276,-286,-286,-282,-261,-210,-140,-79,-51,-60,-92,-124,-138,-131,-110,-84,-52,-15,16,28,15,-16,-60,-111,-160,-195,-209,-203,-176,-131,-75,-27,-1,-2,-29,-77,-132,-179,-208,-222,-222,-206,-172,-131,-96,-76,-74,-91,-120,-145,-150,-138,-118,-89,-47,4,48,67,56,19,-36,-98,-150,-177,-177,-161,-139,-115,-91,-72,-62,-65,-81,-107,-134,-153,-160,-155,-139,-111,-74,-36,-7,5,-2,-22,-46,-67,-76,-69,-47,-21,-5},
            {43,8,-71,-42,76,63,-95,-102,111,163,-107,-216,118,270,-134,212,3006,7337,9677,7820,3453,-544,-3922,-7967,-11353,-10278,-3739,3821,7248,6717,6870,10446,14938,15828,11461,4147,-2132,-4365,-2210,1553,2830,-280,-5679,-9590,-10426,-9616,-8949,-8365,-6831,-4417,-2480,-1966,-2327,-2363,-1667,-819,-326,123,1086,2362,3040,2653,1837,1581,2074,2659,2749,2365,1829,1385,1182,1245,1298,949,245,-279,-320,-243,-486,-839,-765,-291,-68,-514,-1324,-1948,-2196,-2175,-1946,-1529,-1077,-771,-596,-435,-325,-403,-617,-717,-575,-329,-137,88,543,1219,1819,2030,1811,1393,1027,782,568,305,-22,-448,-1057,-1836,-2539,-2816,-2524,-1854,-1168,-738,-648,-827,-1093,-1225,-1077,-682,-193,253,581,727,649,408,182,112,169,211,169,115,134,214,286,329,372,411,391,266,52,-196,-416,-551,-573,-517,-459,-440,-431,-392,-339,-313,-328,-361,-392,-417,-420,-380,-292,-168,-9,172,331,415,411,344,231,68,-114,-245,-281,-245,-186,-116,-32,41,68,40,-28,-132,-268,-404,-490,-507,-474,-414,-328,-224,-134,-88,-91,-125,-171,-212,-229,-206,-142,-46,74,203,308,349,305,186,25,-135,-255,-312,-308,-260,-183,-90,1,67,82,39,-46,-143,-225,-274,-286,-263,-206,-119,-13,85,143,145,97,27,-45,-107,-146,-148,-116,-69,-19,33,79,91,59,12,-19,-53,-125,-200,-201,-108}
        },
        {    // H30e024a.wav
            {-2,1,-1,-6,-4,1,0,-1,5,9,0,-8,4,15,-3,-22,-3,25,5,-34,-12,44,28,-41,-26,54,23,6,570,1981,3478,3858,2857,1383,186,-1069,-2822,-4263,-3909,-1567,1136,2601,3032,3819,5527,7151,7318,5714,3246,1237,584,1247,2218,2196,663,-1680,-3646,-4634,-4861,-4732,-4373,-3801,-3227,-2916,-2825,-2618,-2090,-1435,-1001,-839,-630,-89,666,1240,1413,1341,1303,1394,1534,1660,1762,1766,1541,1068,528,154,54,170,338,380,221,-34,-176,-110,33,53,-106,-340,-546,-715,-871,-1003,-1066,-1022,-876,-693,-582,-609,-702,-684,-446,-64,260,373,278,114,36,96,215,288,283,242,179,33,-235,-548,-762,-804,-722,-609,-528,-502,-527,-573,-600,-595,-588,-608,-645,-659,-636,-586,-516,-424,-324,-249,-221,-234,-268,-308,-336,-322,-250,-146,-62,-27,-20,-5,31,68,80,58,8,-56,-112,-145,-158,-167,-174,-164,-127,-76,-39,-33,-49,-73,-99,-125,-148,-159,-150,-117,-68,-22,1,-5,-35,-80,-132,-182,-218,-231,-219,-185,-137,-90,-60,-48,-48,-59,-84,-122,-161,-188,-195,-184,-157,-118,-80,-57,-55,-66,-82,-98,-114,-124,-123,-111,-90,-61,-29,-3,7,-1,-24,-59,-97,-130,-150,-158,-157,-148,-130,-101,-70,-50,-48,-62,-88,-118,-142,-155,-155,-146,-128,-99,-65,-38,-25,-22,-24,-33,-51,-67,-62,-32},
            {-38,-61,33,79,-49,-134,34,186,-7,-238,-16,302,12,-207,1568,5696,9458,9745,6528,2104,-2446,-7633,-12231,-12483,-6629,1559,6346,6649,6708,10027,14874,16720,13459,6960,684,-2766,-2568,-73,1649,75,-4319,-8566,-10426,-10346,-9965,-9640,-8398,-5897,-3326,-2061,-2058,-2102,-1414,-464,-70,-128,286,1586,2981,3397,2768,1973,1702,1870,2113,2292,2324,2020,1430,989,963,1019,729,233,-42,-132,-434,-894,-936,-369,136,-154,-1116,-2007,-2385,-2376,-2165,-1714,-1070,-576,-558,-918,-1221,-1117,-629,-87,146,-21,-310,-293,221,1016,1674,1916,1752,1392,1056,836,662,405,1,-540,-1202,-1943,-2575,-2788,-2406,-1614,-839,-424,-426,-701,-1047,-1264,-1202,-836,-307,192,538,701,678,503,281,140,124,159,167,154,171,219,255,274,311,372,392,302,99,-159,-398,-563,-626,-603,-547,-495,-445,-386,-330,-298,-287,-285,-303,-345,-382,-370,-300,-193,-52,130,316,437,464,424,331,167,-57,-253,-335,-309,-239,-161,-70,18,61,44,-13,-105,-244,-410,-540,-587,-563,-502,-412,-295,-174,-87,-53,-70,-130,-212,-275,-279,-220,-113,29,190,333,407,386,280,117,-62,-207,-282,-286,-246,-180,-94,-4,61,78,45,-30,-131,-231,-299,-321,-304,-256,-171,-54,60,132,146,113,50,-25,-95,-147,-173,-166,-122,-49,27,84,110,106,72,15,-46,-100,-152,-200,-215,-166,-74}
        },
        {    // H30e030a.wav
            {2,-3,-3,1,0,-4,-4,1,1,-1,3,7,0,-7,2,11,-1,-18,-5,21,7,-29,-17,35,32,-31,-34,36,29,-7,376,1490,2831,3403,2823,1677,557,-725,-2444,-3857,-3657,-1647,753,2095,2515,3254,4846,6401,6679,5393,3332,1616,983,1429,2169,2127,827,-1167,-2832,-3666,-3927,-4025,-4004,-3715,-3226,-2807,-2575,-2367,-2011,-1571,-1234,-1026,-750,-240,407,928,1178,1242,1282,1368,1488,1623,1711,1619,1264,768,394,283,343,404,397,342,257,167,140,210,291,239,19,-266,-511,-717,-924,-1106,-1184,-1121,-977,-865,-866,-955,-999,-854,-501,-85,188,219,80,-55,-53,87,265,378,399,354,255,76,-180,-440,-606,-641,-582,-495,-433,-426,-474,-545,-592,-595,-572,-554,-553,-566,-581,-589,-575,-532,-470,-407,-361,-341,-351,-378,-393,-370,-306,-221,-138,-68,-11,34,67,89,99,96,77,38,-13,-63,-98,-112,-106,-84,-55,-36,-38,-57,-81,-102,-120,-139,-157,-172,-179,-166,-128,-81,-53,-56,-77,-100,-125,-158,-194,-217,-220,-210,-189,-154,-108,-66,-43,-41,-56,-85,-120,-148,-157,-143,-115,-85,-61,-46,-40,-46,-67,-100,-131,-148,-151,-142,-120,-83,-43,-16,-9,-17,-32,-55,-83,-110,-130,-145,-155,-156,-141,-114,-84,-62,-55,-65,-85,-106,-121,-130,-135,-131,-116,-95,-75,-56,-38,-30,-43,-63,-61,-32},
            {-30,85,33,-123,-68,156,119,-185,-179,224,240,-269,308,3475,7952,10451,9287,5608,737,-5426,-11902,-14710,-10503,-1694,5078,6420,5791,8312,13922,17706,15945,9727,2943,-1234,-1767,245,1967,614,-3856,-8408,-10206,-9690,-9422,-10392,-10819,-8834,-5143,-2231,-1502,-2043,-2138,-1240,-98,602,1041,1671,2371,2652,2495,2410,2619,2696,2261,1632,1384,1558,1728,1662,1454,1117,584,93,33,264,126,-576,-1110,-770,40,248,-547,-1684,-2382,-2509,-2310,-1882,-1295,-890,-1017,-1501,-1714,-1253,-381,293,416,124,-199,-254,38,582,1195,1650,1774,1571,1231,947,714,362,-219,-957,-1672,-2188,-2349,-2081,-1520,-1003,-785,-797,-795,-699,-667,-798,-938,-852,-516,-105,224,437,541,519,394,268,219,221,202,155,133,157,194,238,321,434,481,369,121,-151,-368,-531,-652,-709,-685,-610,-521,-428,-322,-218,-158,-162,-215,-284,-337,-345,-297,-200,-66,103,288,440,504,469,358,191,-9,-191,-297,-315,-277,-214,-130,-35,37,57,28,-48,-186,-378,-560,-657,-648,-567,-450,-310,-167,-61,-19,-42,-114,-217,-311,-350,-308,-197,-48,119,279,389,409,339,213,72,-53,-148,-201,-213,-189,-132,-49,39,94,87,15,-99,-218,-310,-358,-356,-309,-224,-112,5,98,146,140,90,14,-67,-136,-178,-184,-149,-81,0,73,117,127,107,62,-2,-76,-142,-182,-189,-171,-137,-91,-41}
        },
        {    // H30e036a.wav
            {-5,-1,2,0,-2,0,-1,-4,-3,1,1,-3,0,6,2,-6,-2,10,5,-10,-6,14,8,-22,-18,25,33,-19,-36,20,32,-13,218,1059,2238,2956,2742,1901,892,-359,-2011,-3420,-3433,-1790,334,1616,2070,2751,4188,5660,6079,5144,3473,1965,1256,1455,2040,2113,1135,-541,-2033,-2831,-3149,-3399,-3614,-3547,-3149,-2685,-2389,-2211,-1973,-1647,-1354,-1140,-865,-377,271,834,1110,1122,1052,1065,1215,1442,1598,1526,1195,777,510,470,537,584,603,622,588,440,242,129,120,89,-69,-324,-581,-807,-1018,-1194,-1279,-1255,-1180,-1131,-1132,-1126,-1012,-728,-335,-8,105,20,-102,-110,18,202,361,460,490,432,274,42,-196,-378,-475,-499,-479,-443,-417,-424,-470,-532,-568,-560,-526,-505,-521,-570,-627,-659,-651,-609,-555,-502,-449,-395,-354,-337,-334,-318,-271,-203,-137,-83,-28,39,104,136,121,83,59,56,47,9,-47,-89,-95,-71,-39,-17,-18,-46,-94,-146,-180,-189,-181,-176,-182,-186,-174,-148,-121,-100,-87,-85,-103,-144,-191,-220,-223,-210,-187,-150,-98,-47,-15,-7,-14,-35,-70,-112,-140,-140,-117,-87,-66,-58,-60,-69,-84,-105,-128,-146,-151,-143,-125,-100,-68,-33,-8,-6,-28,-61,-90,-113,-131,-143,-148,-146,-136,-115,-87,-64,-54,-58,-71,-89,-106,-116,-117,-113,-105,-90,-70,-58,-63,-73,-64,-33},
            {74,-81,-133,68,198,-33,-253,6,326,-5,-305,1316,5340,9468,10872,8963,4719,-1522,-9269,-15208,-14544,-6694,2478,6555,5790,6032,10747,16662,18089,13466,6241,746,-1104,26,1922,1911,-1343,-6354,-9965,-10602,-9750,-9717,-10632,-10560,-8279,-4915,-2543,-1882,-1936,-1589,-802,-93,537,1521,2775,3496,3193,2421,2096,2363,2614,2444,2044,1671,1308,1003,998,1252,1265,751,129,-81,-49,-286,-708,-689,-104,296,-176,-1265,-2140,-2351,-2094,-1775,-1676,-1910,-2304,-2352,-1641,-438,444,496,34,-266,-150,107,229,312,594,1075,1505,1679,1590,1311,830,94,-816,-1643,-2098,-2062,-1640,-1090,-701,-651,-879,-1116,-1101,-822,-510,-387,-456,-560,-567,-458,-264,-14,239,410,446,395,345,319,258,134,21,20,142,305,430,492,480,374,183,-41,-252,-449,-631,-761,-798,-755,-668,-540,-355,-161,-47,-57,-146,-238,-293,-301,-253,-156,-36,91,233,373,459,447,350,210,51,-112,-245,-311,-316,-283,-218,-113,7,87,88,4,-153,-357,-542,-640,-631,-556,-456,-338,-208,-101,-49,-54,-104,-187,-284,-350,-344,-271,-162,-31,123,275,375,391,331,224,95,-38,-149,-215,-223,-175,-85,19,97,118,72,-30,-158,-275,-354,-387,-376,-320,-218,-87,38,124,154,130,66,-22,-113,-183,-209,-180,-107,-18,60,112,131,116,73,14,-48,-111,-166,-193,-178,-138,-104,-86,-65,-30}
        },
        {    // H30e042a.wav
            {-1,-3,-4,0,2,-1,-3,-2,-1,-3,-3,1,2,-2,-2,2,1,-4,0,11,8,-8,-10,8,10,-15,-20,16,34,-7,-39,2,37,-1,102,684,1681,2501,2611,2062,1184,18,-1511,-2906,-3191,-1995,-167,1116,1670,2305,3572,4976,5566,4956,3581,2206,1437,1473,1963,2143,1446,57,-1290,-2090,-2481,-2837,-3205,-3321,-3056,-2606,-2241,-2021,-1836,-1608,-1356,-1098,-795,-409,13,363,577,705,857,1092,1362,1548,1548,1345,1050,845,843,957,990,843,610,436,340,240,105,-6,-65,-130,-267,-465,-678,-894,-1111,-1280,-1337,-1289,-1214,-1174,-1146,-1055,-849,-549,-245,-42,15,-26,-63,-28,77,213,344,447,484,419,248,13,-217,-375,-433,-417,-388,-388,-413,-438,-461,-497,-545,-578,-582,-577,-595,-636,-667,-665,-635,-590,-532,-456,-375,-318,-295,-291,-279,-249,-206,-159,-117,-85,-59,-22,33,88,113,101,74,55,40,13,-32,-76,-96,-87,-63,-45,-46,-67,-99,-137,-176,-210,-229,-230,-221,-208,-191,-168,-143,-121,-107,-102,-111,-131,-154,-168,-171,-161,-137,-100,-61,-31,-12,-5,-14,-43,-82,-114,-129,-131,-125,-113,-97,-83,-76,-75,-79,-91,-111,-131,-147,-151,-143,-125,-97,-64,-34,-19,-25,-49,-78,-101,-116,-127,-137,-137,-123,-100,-79,-63,-52,-52,-67,-87,-100,-105,-109,-111,-104,-91,-84,-82,-67,-32},
            {-93,-43,129,106,-150,-183,164,252,-231,-68,2372,6716,10414,11246,8847,3520,-4472,-12939,-16876,-12572,-2731,5175,6834,5538,7257,12868,17417,16420,10590,4149,448,79,1593,2594,952,-3436,-8108,-10313,-9946,-9380,-10227,-11297,-10370,-7270,-4150,-2861,-2981,-2822,-1679,-333,434,904,1712,2741,3348,3392,3322,3304,2952,2156,1526,1597,2011,2018,1504,963,655,404,182,220,395,152,-603,-1086,-613,309,489,-464,-1712,-2274,-2101,-1881,-2144,-2781,-3232,-2934,-1757,-217,828,898,319,-185,-244,-56,70,137,356,795,1274,1566,1577,1312,758,-92,-1095,-1900,-2150,-1780,-1099,-541,-337,-440,-677,-897,-990,-889,-635,-382,-285,-360,-496,-565,-502,-316,-62,166,290,310,299,299,269,161,24,-14,106,300,436,469,447,412,336,174,-75,-352,-585,-734,-800,-804,-750,-622,-425,-216,-78,-51,-105,-182,-237,-242,-188,-98,-6,81,185,300,375,373,314,231,114,-51,-219,-316,-327,-302,-272,-208,-95,19,67,28,-79,-232,-404,-539,-587,-552,-474,-380,-271,-157,-70,-44,-82,-163,-259,-338,-371,-349,-275,-153,9,181,319,391,386,306,171,20,-106,-188,-228,-223,-160,-50,63,127,120,48,-68,-198,-306,-370,-389,-373,-315,-206,-63,69,146,158,115,35,-62,-152,-207,-212,-165,-80,16,91,129,129,100,48,-19,-89,-150,-193,-202,-170,-114,-68,-52,-56,-51,-26}
        },
        {    // H30e048a.wav
            {-2,-2,-1,-1,-2,-1,1,1,-1,-1,-1,-2,-2,0,1,-1,-2,1,2,0,2,10,10,-3,-9,5,12,-6,-18,6,30,3,-33,-7,38,11,27,397,1209,2055,2398,2110,1419,421,-945,-2355,-2971,-2257,-711,625,1341,1973,3076,4378,5076,4733,3633,2413,1618,1495,1865,2139,1731,620,-623,-1464,-1917,-2320,-2781,-3046,-2888,-2418,-1943,-1654,-1533,-1491,-1471,-1413,-1223,-832,-294,228,590,789,940,1136,1357,1515,1550,1470,1314,1131,968,839,712,552,377,232,119,-9,-162,-284,-332,-343,-393,-514,-681,-858,-1019,-1129,-1164,-1152,-1151,-1162,-1106,-912,-604,-296,-95,-36,-73,-120,-108,-23,97,210,302,367,380,305,142,-56,-224,-324,-359,-358,-353,-365,-400,-457,-527,-595,-635,-635,-610,-591,-592,-598,-587,-555,-508,-451,-392,-343,-313,-291,-260,-218,-184,-174,-178,-178,-168,-153,-125,-70,4,66,91,84,64,37,-2,-49,-85,-99,-99,-94,-84,-64,-46,-54,-96,-155,-207,-242,-260,-261,-243,-213,-184,-165,-151,-131,-106,-85,-78,-80,-83,-84,-91,-104,-110,-98,-72,-50,-41,-38,-38,-48,-74,-106,-128,-135,-133,-129,-122,-105,-86,-77,-82,-97,-118,-138,-151,-152,-145,-133,-113,-80,-43,-19,-16,-30,-54,-83,-111,-127,-127,-116,-101,-85,-68,-57,-58,-69,-82,-91,-97,-101,-104,-105,-105,-96,-70,-32},
            {-38,148,80,-182,-135,222,181,-319,158,3011,7481,11058,11759,8947,2435,-7007,-15590,-17503,-10521,261,6894,7017,5714,8361,13903,16805,14094,8194,3324,1368,1603,2461,2363,93,-4132,-8260,-10223,-10146,-9896,-10452,-10712,-9290,-6622,-4481,-3759,-3635,-2990,-1824,-817,-81,881,2129,3005,3136,3073,3439,3908,3669,2698,1864,1713,1856,1761,1520,1403,1189,553,-191,-414,-155,-72,-387,-534,-143,243,-96,-997,-1678,-1880,-2151,-2916,-3758,-3885,-3028,-1643,-377,411,697,630,408,186,15,-111,-151,13,444,1016,1451,1512,1157,499,-315,-1128,-1696,-1773,-1349,-761,-409,-381,-459,-462,-444,-507,-589,-560,-447,-409,-510,-638,-658,-547,-363,-154,30,127,118,69,55,67,52,21,53,179,319,380,367,369,430,482,414,188,-130,-438,-657,-760,-759,-687,-584,-475,-362,-241,-130,-62,-58,-105,-159,-177,-143,-69,26,136,244,324,349,319,251,151,12,-153,-293,-363,-366,-334,-276,-185,-77,6,28,-11,-94,-208,-337,-448,-507,-501,-440,-337,-210,-89,-14,-11,-82,-201,-327,-412,-427,-367,-244,-77,108,276,383,403,337,212,64,-71,-169,-224,-233,-197,-119,-16,76,121,101,20,-97,-217,-315,-376,-393,-355,-259,-123,15,115,157,145,90,6,-86,-162,-201,-194,-143,-61,26,93,123,116,86,42,-20,-95,-162,-196,-189,-150,-95,-43,-15,-26,-57,-69,-42}
        },
        {    // H30e054a.wav
            {1,0,-2,-2,-1,-2,-3,-1,1,0,-3,-2,1,0,-3,-2,0,-1,-4,-2,1,2,3,7,8,-1,-8,-1,10,2,-13,-4,18,11,-18,-13,22,13,0,218,826,1607,2106,2080,1615,799,-414,-1820,-2722,-2473,-1237,130,1038,1722,2686,3866,4632,4507,3630,2543,1760,1546,1817,2125,1927,1072,-42,-905,-1407,-1793,-2207,-2485,-2437,-2147,-1890,-1819,-1848,-1804,-1615,-1325,-999,-654,-279,115,497,850,1177,1446,1571,1492,1270,1047,917,857,784,646,444,215,16,-109,-183,-270,-387,-461,-419,-306,-254,-336,-501,-664,-798,-919,-1022,-1081,-1075,-995,-834,-604,-367,-209,-172,-211,-243,-213,-127,-20,74,144,193,221,215,158,49,-87,-208,-287,-324,-345,-379,-436,-502,-555,-589,-611,-619,-596,-537,-469,-432,-431,-435,-418,-384,-353,-327,-296,-255,-215,-188,-177,-184,-206,-232,-241,-217,-167,-113,-70,-41,-19,0,9,0,-27,-59,-82,-89,-87,-84,-83,-83,-86,-96,-115,-139,-167,-198,-229,-247,-246,-231,-210,-186,-156,-121,-89,-64,-46,-32,-25,-31,-50,-76,-100,-113,-112,-100,-82,-64,-52,-50,-61,-82,-104,-125,-144,-156,-153,-134,-110,-97,-96,-100,-107,-120,-136,-142,-134,-123,-115,-108,-93,-68,-43,-31,-35,-48,-62,-78,-96,-107,-104,-93,-85,-82,-77,-70,-70,-81,-89,-85,-80,-89,-102,-89,-45},
            {123,11,-181,-77,240,144,-335,188,3045,7585,11430,12408,9409,2059,-8335,-17088,-18047,-9654,1919,8288,7659,5918,8535,13837,15934,12419,6640,2943,2265,2848,3077,2228,-179,-3979,-7678,-9622,-9921,-10141,-10898,-10891,-8914,-5931,-4102,-4108,-4493,-3769,-2203,-982,-382,337,1504,2525,2955,3230,3796,4176,3658,2565,2010,2373,2820,2533,1744,1148,872,584,236,45,-76,-410,-779,-628,61,494,15,-1086,-2087,-2784,-3460,-4079,-4116,-3285,-2014,-957,-301,201,682,939,777,315,-116,-281,-147,222,713,1126,1208,847,199,-448,-909,-1148,-1161,-947,-630,-440,-468,-533,-419,-181,-71,-179,-324,-339,-313,-440,-717,-918,-862,-585,-257,-17,86,66,-25,-129,-202,-226,-196,-105,38,194,314,382,427,481,530,514,377,129,-159,-407,-574,-650,-644,-576,-482,-392,-310,-223,-126,-41,0,-25,-95,-154,-155,-95,-7,85,182,279,336,321,239,116,-36,-210,-373,-468,-467,-395,-292,-183,-75,15,60,41,-44,-179,-326,-439,-487,-459,-364,-231,-102,-14,12,-24,-117,-249,-377,-445,-425,-331,-196,-38,133,288,385,390,301,151,-9,-142,-230,-272,-265,-208,-110,-2,80,112,81,-11,-139,-259,-337,-367,-354,-297,-193,-60,64,146,173,146,75,-16,-104,-174,-210,-196,-133,-45,36,90,113,102,63,10,-45,-103,-159,-187,-167,-115,-70,-45,-28,-21,-44,-88,-102,-59}
        },
        {    // H30e060a.wav
            {3,1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,0,0,1,1,-2,-3,-1,0,-1,0,4,6,5,5,6,1,-5,0,10,6,-10,-9,12,17,-7,-17,9,19,3,118,549,1222,1792,1972,1732,1113,57,-1328,-2464,-2628,-1702,-340,759,1560,2461,3522,4268,4244,3520,2577,1878,1644,1830,2120,2070,1471,574,-183,-679,-1177,-1871,-2538,-2765,-2437,-1865,-1457,-1357,-1419,-1425,-1262,-936,-501,-24,414,735,911,978,987,956,883,790,712,638,517,337,156,29,-58,-148,-240,-297,-317,-323,-303,-221,-100,-40,-117,-292,-469,-601,-709,-814,-891,-895,-802,-633,-452,-342,-341,-401,-422,-351,-223,-110,-45,-13,14,45,70,68,25,-53,-148,-232,-296,-350,-405,-461,-506,-528,-525,-506,-480,-448,-403,-346,-301,-292,-317,-345,-350,-326,-287,-246,-215,-203,-210,-224,-232,-235,-240,-247,-244,-223,-191,-165,-148,-132,-106,-75,-51,-42,-49,-65,-81,-88,-88,-93,-110,-130,-139,-134,-127,-128,-143,-164,-185,-202,-212,-209,-190,-158,-117,-73,-37,-17,-13,-17,-25,-39,-60,-83,-104,-120,-127,-119,-97,-75,-66,-72,-86,-101,-115,-128,-138,-144,-146,-141,-128,-111,-97,-90,-92,-101,-114,-124,-127,-127,-127,-121,-100,-68,-41,-28,-26,-33,-48,-68,-81,-83,-85,-94,-100,-93,-79,-71,-68,-61,-56,-64,-78,-72,-38},
            {93,-160,-161,176,228,-252,-80,2330,6859,11308,13102,10594,3190,-7761,-17422,-19205,-10839,1759,9374,8958,6174,7606,12651,15250,12137,6390,2793,2470,3295,3457,2607,552,-2912,-6783,-9220,-9702,-9645,-10210,-10570,-9313,-6808,-4895,-4422,-4349,-3553,-2392,-1762,-1456,-523,1070,2265,2533,2663,3420,4227,3997,2854,2072,2355,3011,3095,2592,2028,1509,800,58,-239,-56,103,-37,-170,-33,65,-369,-1375,-2585,-3681,-4451,-4604,-3938,-2735,-1623,-942,-461,139,752,994,732,256,-59,-77,120,416,706,835,631,84,-555,-931,-882,-565,-281,-211,-333,-514,-612,-523,-252,45,170,77,-91,-203,-296,-478,-735,-915,-900,-710,-444,-187,3,72,-4,-179,-352,-438,-416,-317,-181,-19,175,386,564,659,648,540,350,102,-150,-343,-449,-483,-475,-443,-391,-330,-259,-167,-58,29,52,5,-70,-127,-149,-142,-106,-28,90,214,297,310,252,128,-57,-274,-457,-547,-531,-445,-326,-194,-62,47,107,98,10,-146,-323,-446,-465,-390,-270,-147,-41,34,53,0,-115,-253,-366,-416,-398,-323,-203,-51,110,250,338,353,286,148,-23,-172,-267,-308,-305,-255,-158,-41,54,101,88,10,-122,-259,-349,-368,-331,-254,-144,-15,98,167,185,156,84,-18,-120,-192,-219,-196,-126,-29,56,102,113,101,67,8,-63,-124,-166,-182,-163,-113,-61,-35,-31,-29,-34,-64,-103,-105,-57}
        },
        {    // H30e066a.wav
            {1,2,1,0,0,0,-1,-2,-2,-1,-2,-2,-1,0,-1,-1,0,0,-2,-4,-3,-1,-1,0,3,3,1,0,2,0,-4,-2,6,3,-11,-13,7,18,0,-17,0,19,9,70,371,924,1492,1806,1770,1353,443,-930,-2253,-2740,-2068,-727,535,1478,2366,3317,3984,3974,3348,2551,1995,1852,2085,2442,2481,1870,751,-335,-989,-1296,-1569,-1886,-2035,-1869,-1529,-1267,-1164,-1106,-976,-777,-579,-411,-244,-49,159,338,450,476,426,335,247,180,108,13,-60,-35,77,153,80,-110,-269,-289,-184,-23,129,213,182,41,-133,-269,-380,-524,-700,-826,-830,-730,-608,-528,-504,-513,-512,-463,-363,-254,-187,-172,-170,-146,-103,-70,-71,-106,-163,-229,-294,-353,-394,-406,-389,-362,-347,-346,-341,-315,-273,-231,-206,-210,-243,-285,-303,-278,-234,-213,-234,-271,-287,-274,-250,-239,-248,-271,-295,-304,-286,-246,-206,-182,-173,-161,-134,-100,-73,-65,-74,-91,-109,-123,-133,-137,-133,-124,-116,-114,-115,-118,-124,-136,-151,-159,-155,-140,-116,-86,-56,-36,-32,-39,-48,-54,-63,-77,-94,-110,-125,-135,-135,-124,-108,-98,-94,-93,-94,-102,-118,-134,-141,-135,-124,-114,-106,-100,-99,-106,-119,-130,-132,-125,-117,-111,-102,-88,-70,-54,-43,-36,-36,-38,-46,-62,-82,-97,-100,-95,-84,-69,-54,-50,-62,-74,-64,-32},
            {-36,-157,36,233,-75,-302,1200,5220,10258,13427,12290,5757,-5178,-16157,-20345,-13779,-597,9485,10713,6951,6110,10305,14212,12792,7448,3225,2411,3230,3538,3006,1679,-1087,-5137,-8583,-9757,-9310,-9080,-9443,-9160,-7673,-6084,-5402,-5058,-4015,-2533,-1728,-1720,-1400,-137,1324,2108,2480,3146,3866,3744,2770,2083,2463,3300,3519,2974,2333,1941,1520,897,373,192,168,98,139,411,490,-258,-1875,-3634,-4716,-4854,-4308,-3487,-2690,-2033,-1438,-741,63,712,891,575,102,-118,59,440,710,683,361,-144,-657,-942,-809,-319,180,330,83,-299,-542,-558,-387,-90,225,385,287,22,-214,-332,-414,-562,-767,-913,-892,-687,-388,-138,-42,-103,-240,-375,-470,-515,-508,-437,-286,-43,261,542,709,725,611,399,131,-118,-269,-305,-291,-291,-307,-301,-259,-187,-95,10,94,116,67,-23,-120,-199,-234,-205,-111,20,148,240,268,213,79,-108,-309,-478,-574,-574,-489,-358,-216,-79,44,126,132,47,-105,-270,-388,-419,-361,-243,-111,-4,59,75,39,-47,-168,-293,-381,-403,-352,-242,-96,58,194,285,309,254,129,-27,-169,-270,-331,-351,-319,-229,-105,11,84,96,37,-81,-215,-311,-344,-322,-258,-153,-19,103,176,192,163,95,-6,-116,-200,-233,-208,-135,-34,62,123,139,120,77,15,-59,-128,-177,-200,-191,-149,-92,-48,-31,-26,-23,-33,-63,-91,-84,-42}
        },
        {    // H30e072a.wav
            {1,1,2,2,1,0,1,1,0,-1,-1,0,0,0,1,1,0,1,3,3,0,-2,-1,0,0,1,4,4,1,1,5,5,1,1,6,3,-11,-12,9,24,9,-12,-3,17,16,65,301,752,1258,1628,1764,1541,732,-696,-2207,-2911,-2355,-961,471,1571,2495,3350,3872,3800,3295,2770,2434,2210,2009,1850,1690,1379,868,316,-124,-512,-981,-1445,-1633,-1418,-1005,-733,-753,-950,-1120,-1145,-1031,-852,-682,-549,-426,-283,-153,-117,-203,-321,-331,-186,27,194,282,324,322,243,98,-18,-22,70,174,252,324,386,372,234,6,-232,-442,-630,-779,-841,-800,-708,-631,-591,-573,-559,-541,-509,-461,-415,-384,-351,-289,-210,-161,-173,-223,-266,-281,-274,-255,-228,-198,-182,-189,-210,-222,-211,-180,-150,-139,-150,-172,-193,-209,-225,-243,-261,-277,-290,-300,-304,-298,-286,-280,-291,-314,-332,-329,-305,-275,-254,-244,-235,-214,-178,-138,-107,-93,-96,-109,-120,-120,-112,-106,-107,-108,-102,-91,-82,-77,-72,-66,-67,-80,-99,-115,-124,-123,-112,-92,-72,-61,-61,-66,-71,-74,-84,-101,-120,-135,-142,-139,-127,-113,-101,-91,-81,-74,-75,-85,-100,-117,-132,-138,-133,-123,-116,-113,-109,-104,-103,-104,-102,-98,-97,-98,-90,-71,-51,-39,-35,-34,-35,-40,-49,-57,-66,-75,-82,-81,-76,-71,-65,-50,-24},
            {-127,-54,188,112,-318,120,2923,7894,12613,13899,9561,-397,-12607,-20424,-17873,-5757,7279,12337,9140,5391,7074,11851,13343,9617,4678,2537,2952,3544,3363,2645,837,-2794,-7092,-9595,-9467,-8392,-8104,-8341,-7968,-6996,-6274,-5829,-4858,-3314,-2238,-2149,-2109,-1069,578,1666,2001,2445,3306,3728,3068,2078,1985,2861,3636,3572,2964,2359,1796,1157,704,740,1029,1052,733,432,217,-377,-1687,-3317,-4491,-4817,-4498,-3900,-3193,-2416,-1649,-972,-387,107,403,383,138,-33,100,432,624,443,-46,-589,-945,-949,-549,101,636,729,383,-101,-432,-519,-374,-19,426,692,576,174,-214,-398,-444,-510,-652,-803,-868,-797,-608,-391,-254,-238,-301,-388,-483,-575,-625,-588,-450,-223,58,331,525,607,585,466,260,24,-142,-186,-162,-158,-185,-191,-150,-82,-5,87,174,204,141,12,-128,-237,-292,-276,-189,-59,73,166,196,148,28,-138,-318,-477,-577,-586,-515,-402,-281,-148,-3,118,158,100,-25,-174,-307,-385,-372,-267,-122,4,82,117,107,41,-81,-223,-333,-382,-365,-288,-163,-13,126,222,258,228,129,-23,-183,-302,-362,-375,-351,-285,-173,-41,66,107,70,-31,-158,-263,-315,-311,-259,-169,-55,56,136,174,170,122,30,-84,-181,-231,-224,-165,-66,42,122,153,143,109,52,-29,-119,-190,-225,-225,-194,-138,-75,-29,-11,-11,-21,-42,-71,-87,-73,-35}
        },
        {    // H30e078a.wav
            {0,1,1,0,0,1,2,2,1,-1,-2,-1,0,1,0,-1,0,1,2,2,1,-1,-3,-3,-1,-1,-1,0,1,1,0,2,5,3,0,2,4,-5,-15,-6,18,24,3,-9,6,12,0,63,311,721,1155,1524,1770,1658,808,-813,-2496,-3196,-2464,-832,823,2104,3128,3921,4162,3622,2605,1749,1472,1726,2192,2528,2470,1944,1164,511,181,11,-282,-744,-1152,-1312,-1262,-1181,-1186,-1282,-1427,-1561,-1598,-1471,-1223,-1002,-923,-946,-919,-729,-404,-71,155,243,248,267,369,535,654,613,408,169,62,155,377,582,641,508,237,-57,-275,-407,-518,-659,-798,-853,-792,-675,-596,-597,-652,-707,-726,-696,-623,-527,-437,-370,-327,-300,-285,-276,-258,-218,-160,-106,-72,-56,-46,-42,-53,-79,-99,-98,-84,-83,-106,-139,-169,-203,-248,-293,-312,-304,-297,-313,-343,-357,-348,-331,-323,-323,-324,-327,-332,-331,-312,-278,-242,-215,-195,-178,-165,-158,-149,-129,-100,-79,-75,-81,-81,-74,-69,-70,-68,-52,-29,-16,-22,-45,-79,-119,-156,-175,-164,-132,-100,-84,-81,-81,-81,-88,-101,-113,-119,-122,-129,-136,-135,-121,-101,-83,-70,-63,-63,-74,-95,-119,-137,-146,-148,-144,-132,-110,-87,-76,-82,-95,-104,-106,-105,-103,-97,-85,-69,-53,-37,-24,-18,-21,-31,-45,-60,-73,-79,-82,-85,-81,-61,-27},
            {-154,49,241,-41,-384,730,4437,9789,13817,13203,6191,-5782,-17264,-20893,-13149,1057,11505,12216,7089,4584,7770,11920,11646,7427,3697,2810,3409,3703,3491,2634,43,-4430,-8568,-9900,-8645,-7196,-7032,-7480,-7463,-7017,-6534,-5730,-4303,-2930,-2523,-2763,-2374,-898,740,1655,2140,2819,3403,3140,2217,1775,2415,3417,3759,3323,2680,2124,1552,1050,963,1290,1539,1374,999,642,39,-1191,-2811,-4053,-4437,-4193,-3804,-3438,-2976,-2374,-1734,-1110,-492,8,175,-12,-230,-130,244,472,229,-372,-919,-1097,-852,-299,369,882,988,663,161,-215,-347,-254,43,487,857,869,479,-43,-387,-495,-524,-604,-725,-813,-816,-730,-589,-459,-392,-388,-421,-484,-576,-662,-680,-596,-416,-175,82,294,415,442,398,295,149,17,-44,-45,-55,-96,-114,-64,29,116,193,270,308,246,83,-108,-250,-316,-310,-244,-136,-20,68,104,77,-10,-143,-294,-435,-542,-589,-563,-480,-371,-248,-107,40,146,165,88,-51,-206,-327,-369,-312,-181,-33,81,142,153,113,17,-120,-259,-351,-367,-308,-202,-79,38,133,193,198,130,-3,-164,-305,-394,-427,-406,-331,-213,-81,29,95,100,37,-79,-204,-287,-307,-275,-207,-111,0,95,147,155,129,69,-23,-126,-202,-225,-190,-110,-8,86,145,158,130,73,0,-78,-151,-207,-233,-222,-176,-110,-51,-17,-6,-16,-40,-70,-91,-89,-63,-27}
        },
        {    // H30e084a.wav
            {0,1,1,1,0,1,2,2,2,3,2,0,-1,1,2,0,-1,1,3,3,1,1,1,0,-1,-1,-2,-2,1,5,5,0,-1,5,8,5,3,5,1,-11,-10,14,33,22,-1,-4,-5,-28,-11,161,497,868,1195,1526,1785,1543,356,-1542,-3081,-3165,-1663,508,2243,3062,3140,2860,2519,2317,2338,2487,2586,2586,2600,2671,2627,2265,1604,868,233,-294,-749,-1099,-1307,-1443,-1615,-1825,-1958,-1934,-1828,-1787,-1863,-1965,-1941,-1695,-1242,-709,-270,-39,10,16,114,340,630,873,963,859,626,415,344,396,458,448,384,324,274,195,60,-120,-324,-532,-704,-792,-782,-722,-680,-694,-754,-823,-862,-843,-772,-685,-617,-564,-495,-398,-295,-218,-175,-149,-123,-88,-45,6,59,98,107,79,28,-20,-47,-60,-79,-119,-171,-219,-256,-283,-303,-314,-321,-334,-355,-373,-376,-365,-350,-338,-332,-333,-338,-338,-322,-290,-257,-241,-242,-248,-242,-219,-182,-140,-100,-68,-47,-39,-38,-40,-44,-51,-57,-51,-30,-8,-6,-30,-70,-110,-140,-155,-153,-139,-123,-117,-118,-116,-107,-98,-98,-102,-104,-105,-108,-109,-106,-102,-102,-105,-103,-93,-79,-70,-71,-83,-101,-120,-135,-140,-130,-110,-91,-81,-80,-83,-90,-98,-103,-98,-88,-81,-76,-66,-47,-31,-26,-29,-32,-33,-38,-44,-48,-56,-74,-91,-81,-41},
            {-147,95,238,-118,-362,1103,5218,10686,14210,12340,3742,-8976,-19178,-19764,-9338,5002,13127,11400,5683,3999,7630,11194,10340,6498,3659,3203,3684,3942,3914,2906,-385,-5456,-9390,-9872,-7853,-6153,-6147,-6961,-7401,-7258,-6639,-5389,-3771,-2783,-2945,-3328,-2620,-857,740,1515,2027,2787,3272,2828,1935,1771,2655,3676,3896,3310,2461,1680,1106,985,1405,1899,1841,1225,633,348,-70,-1119,-2587,-3757,-4195,-4036,-3595,-3038,-2478,-2066,-1821,-1530,-1017,-437,-127,-174,-302,-235,-62,-100,-470,-927,-1115,-900,-390,232,800,1128,1070,670,181,-131,-161,67,476,908,1108,893,358,-178,-473,-549,-573,-646,-753,-830,-828,-733,-582,-457,-414,-443,-505,-576,-651,-700,-687,-597,-436,-215,27,215,296,286,243,190,118,43,3,4,9,6,30,102,193,270,333,385,380,265,56,-159,-296,-333,-294,-213,-116,-30,21,23,-26,-119,-238,-366,-485,-570,-593,-546,-455,-348,-226,-82,62,155,157,70,-66,-205,-299,-309,-229,-99,27,116,164,165,110,-3,-141,-258,-320,-315,-250,-147,-37,57,124,157,139,50,-100,-262,-381,-438,-442,-396,-297,-158,-19,80,120,100,20,-103,-224,-293,-294,-245,-168,-72,29,112,155,152,112,41,-51,-141,-196,-195,-142,-58,30,96,130,132,105,51,-22,-96,-154,-190,-202,-185,-139,-80,-36,-21,-27,-41,-57,-76,-90,-86,-60,-26}
        },
        {    // H30e090a.wav
            {-1,-2,-1,0,0,0,1,2,2,2,2,2,1,0,0,0,-1,-2,-1,0,0,-1,0,1,1,-1,-2,-3,-3,0,4,5,1,-1,3,6,3,1,2,1,-4,2,23,34,13,-15,-18,-14,-34,-20,143,472,835,1134,1424,1692,1603,723,-859,-2328,-2770,-1983,-537,896,2057,2944,3458,3449,3026,2576,2433,2624,2967,3261,3333,3032,2326,1405,560,-52,-492,-889,-1277,-1606,-1847,-2023,-2150,-2224,-2269,-2325,-2378,-2331,-2095,-1692,-1239,-845,-538,-296,-89,112,335,578,781,881,882,854,843,820,724,540,320,136,50,88,206,298,265,93,-145,-368,-547,-683,-774,-814,-818,-815,-820,-827,-834,-846,-856,-841,-778,-669,-536,-402,-285,-198,-142,-106,-76,-45,-9,35,90,145,181,183,145,76,-8,-83,-134,-162,-181,-207,-245,-289,-326,-344,-345,-342,-350,-369,-388,-395,-385,-361,-333,-313,-304,-300,-293,-286,-287,-295,-299,-291,-268,-234,-192,-145,-99,-62,-37,-24,-22,-30,-42,-50,-48,-44,-45,-53,-63,-72,-79,-83,-86,-93,-106,-125,-143,-152,-148,-138,-128,-119,-107,-93,-86,-89,-96,-97,-95,-97,-107,-119,-124,-119,-105,-87,-73,-69,-73,-82,-94,-108,-120,-124,-118,-107,-92,-76,-66,-67,-77,-85,-85,-80,-76,-73,-67,-58,-48,-37,-26,-23,-30,-39,-43,-49,-65,-80,-72,-37},
            {-142,74,228,-92,-367,970,4989,10507,14107,12120,3272,-9423,-19060,-18848,-8034,5978,13381,11052,5021,3140,6608,10223,9778,6515,4042,3577,3905,4180,4359,3474,8,-5413,-9538,-9859,-7455,-5457,-5477,-6631,-7491,-7548,-6786,-5226,-3463,-2652,-3159,-3772,-3055,-1135,622,1469,1917,2490,2802,2395,1791,1961,2985,3915,3952,3208,2242,1426,975,1085,1623,1962,1610,866,438,430,171,-851,-2276,-3318,-3649,-3523,-3244,-2862,-2405,-2033,-1827,-1630,-1274,-855,-613,-594,-604,-509,-432,-569,-891,-1139,-1082,-709,-156,437,939,1189,1079,703,319,137,188,401,714,1029,1152,921,402,-129,-450,-566,-619,-705,-809,-871,-837,-697,-510,-386,-389,-485,-588,-658,-706,-734,-713,-624,-475,-285,-86,75,161,176,154,118,72,30,20,42,70,97,148,232,316,372,408,429,401,281,86,-111,-247,-304,-293,-233,-151,-80,-41,-37,-71,-152,-277,-418,-536,-597,-594,-536,-443,-332,-211,-81,43,125,130,53,-74,-198,-265,-246,-156,-39,62,128,156,147,92,-6,-125,-230,-290,-288,-225,-126,-24,55,104,120,88,-8,-157,-307,-410,-450,-436,-374,-265,-128,-2,79,107,85,11,-106,-221,-284,-278,-225,-147,-54,41,112,143,137,103,42,-44,-130,-180,-177,-128,-54,25,88,120,117,88,40,-22,-89,-144,-176,-180,-157,-113,-64,-34,-32,-50,-70,-84,-94,-96,-84,-56,-23}
        },
        {    // H30e096a.wav
            {0,-1,-1,-1,0,1,2,2,2,2,2,2,1,0,0,0,-1,-2,-1,0,1,2,2,1,0,-1,0,-1,-3,-3,0,3,3,2,5,6,0,-6,0,11,11,5,14,28,16,-19,-28,-1,3,-33,11,260,660,1050,1410,1835,2151,1757,188,-2112,-3832,-3805,-1989,587,2714,3772,3833,3358,2872,2713,2873,3080,3112,3011,2928,2837,2525,1859,945,13,-768,-1318,-1595,-1636,-1616,-1748,-2096,-2512,-2778,-2772,-2505,-2075,-1628,-1305,-1143,-1029,-796,-389,78,440,624,671,672,707,819,980,1076,978,671,292,17,-81,-49,38,138,219,230,140,-30,-228,-423,-613,-787,-906,-937,-889,-815,-770,-776,-815,-845,-830,-758,-645,-517,-395,-290,-205,-134,-70,-15,25,51,79,121,166,189,176,129,57,-29,-109,-163,-183,-189,-211,-260,-319,-358,-366,-358,-357,-368,-381,-385,-381,-368,-340,-297,-256,-242,-263,-299,-323,-323,-309,-294,-280,-261,-230,-186,-131,-75,-37,-29,-46,-65,-68,-60,-56,-67,-88,-106,-112,-102,-76,-40,-16,-25,-66,-113,-141,-146,-141,-132,-121,-110,-105,-105,-103,-95,-88,-90,-102,-115,-123,-124,-123,-122,-118,-107,-88,-70,-60,-61,-70,-85,-104,-120,-124,-114,-95,-74,-55,-44,-48,-64,-81,-89,-89,-85,-78,-70,-61,-51,-38,-26,-25,-35,-43,-42,-43,-59,-78,-72,-37},
            {-125,-7,190,27,-346,422,3781,9202,13502,12664,4890,-7276,-17354,-18579,-9326,4284,12704,11496,5263,2095,4781,9026,9847,7238,4594,3805,4066,4401,4717,4224,1249,-4148,-8918,-9947,-7610,-5139,-4842,-6215,-7544,-7895,-7161,-5472,-3489,-2468,-2996,-3954,-3632,-1777,261,1373,1809,2207,2435,2071,1525,1763,2964,4134,4242,3286,2036,1181,966,1300,1775,1804,1173,423,284,682,710,-279,-1860,-3047,-3359,-3100,-2749,-2464,-2217,-2045,-1969,-1845,-1526,-1113,-869,-893,-1005,-1004,-904,-866,-958,-1068,-1033,-768,-283,337,915,1220,1131,780,458,358,455,637,854,1067,1140,927,462,-21,-321,-450,-553,-708,-868,-935,-852,-641,-410,-295,-349,-498,-630,-711,-770,-803,-765,-653,-518,-390,-248,-83,53,108,91,47,6,-16,1,64,139,189,220,266,335,402,447,461,422,307,132,-48,-179,-245,-259,-236,-191,-144,-107,-84,-90,-154,-282,-434,-552,-605,-597,-541,-449,-338,-222,-112,-10,69,94,43,-66,-182,-248,-232,-143,-23,79,139,157,138,83,-9,-118,-212,-268,-273,-227,-142,-47,30,76,88,58,-29,-166,-308,-405,-436,-416,-356,-258,-133,-21,49,69,47,-14,-109,-206,-263,-260,-212,-141,-58,25,89,119,119,97,48,-31,-118,-176,-182,-141,-71,10,80,117,114,80,30,-28,-87,-138,-167,-169,-146,-106,-66,-43,-48,-71,-93,-105,-108,-106,-92,-63,-27}
        },
        {    // H30e102a.wav
            {-1,-1,0,0,0,1,2,3,2,2,2,2,0,-1,-1,0,-1,-2,-1,0,1,1,2,1,0,0,0,-1,-3,-1,4,4,-2,-3,4,7,-1,-8,-1,10,10,8,16,23,8,-15,-14,1,-8,-23,58,321,773,1394,2128,2676,2399,767,-1886,-4184,-4623,-2827,119,2609,3748,3730,3288,2987,2963,3061,3061,2860,2573,2444,2560,2662,2333,1420,226,-752,-1238,-1326,-1292,-1368,-1648,-2091,-2521,-2704,-2530,-2136,-1784,-1612,-1535,-1385,-1087,-679,-239,149,395,463,440,485,672,919,1074,1049,852,550,235,0,-105,-110,-82,-50,9,101,162,107,-82,-335,-557,-699,-769,-799,-815,-828,-835,-828,-799,-745,-674,-605,-553,-517,-477,-412,-318,-208,-100,-5,67,112,137,154,166,160,123,60,-9,-66,-105,-130,-150,-177,-219,-270,-318,-352,-373,-389,-403,-411,-402,-374,-338,-309,-288,-266,-242,-233,-252,-287,-309,-305,-284,-265,-253,-243,-228,-199,-154,-99,-55,-42,-61,-93,-114,-119,-123,-137,-158,-167,-147,-97,-36,8,17,-11,-63,-112,-135,-131,-116,-104,-96,-87,-79,-77,-83,-92,-104,-118,-131,-137,-134,-129,-128,-128,-123,-107,-83,-64,-59,-69,-85,-100,-112,-120,-115,-92,-62,-42,-38,-42,-48,-61,-80,-93,-92,-84,-78,-72,-61,-49,-44,-42,-34,-26,-29,-37,-41,-53,-87,-125,-120,-63},
            {-57,-107,71,160,-165,-136,1950,6705,11886,13314,8063,-2740,-13708,-18052,-12350,-31,10348,12148,6730,1631,2341,7031,10013,8751,5658,3879,3861,4456,5043,5070,3062,-1754,-7260,-9834,-8328,-5364,-4200,-5419,-7282,-8198,-7776,-6216,-4067,-2492,-2519,-3654,-4092,-2757,-509,1120,1733,1967,2134,1929,1436,1482,2553,3921,4363,3513,2118,1140,963,1356,1776,1697,1020,280,170,689,998,336,-1111,-2446,-3032,-2959,-2636,-2286,-1962,-1773,-1810,-1936,-1881,-1562,-1203,-1056,-1123,-1211,-1190,-1108,-1067,-1068,-1016,-817,-439,84,642,1050,1149,958,682,531,552,675,853,1051,1156,1006,584,100,-208,-311,-378,-544,-772,-916,-873,-658,-397,-246,-276,-425,-583,-704,-801,-864,-843,-731,-591,-474,-356,-206,-59,23,31,6,-22,-41,-23,58,171,248,268,276,311,366,412,439,434,364,214,28,-122,-201,-224,-215,-189,-155,-126,-109,-116,-163,-257,-379,-488,-558,-582,-556,-478,-368,-258,-163,-75,6,50,30,-45,-137,-205,-221,-172,-68,52,139,167,147,93,10,-94,-192,-253,-262,-227,-165,-90,-18,39,67,55,-9,-118,-242,-339,-386,-387,-349,-275,-172,-69,4,37,32,-12,-94,-187,-246,-245,-200,-140,-74,-1,68,112,120,97,48,-26,-109,-167,-173,-130,-64,5,64,100,104,77,32,-21,-75,-121,-146,-146,-130,-105,-78,-60,-63,-81,-96,-99,-100,-109,-112,-87,-40}
        },
        {    // H30e108a.wav
            {-1,-1,0,1,2,2,2,1,1,1,1,1,0,-1,-1,-1,-1,-1,0,1,2,3,2,0,-1,-1,-1,-1,0,3,5,4,0,-2,-1,-1,-2,2,8,10,6,6,11,12,2,-4,2,1,-14,39,329,973,1860,2597,2651,1644,-320,-2524,-3911,-3717,-2014,323,2272,3341,3690,3709,3591,3307,2852,2388,2145,2232,2529,2729,2499,1718,611,-377,-916,-1020,-967,-1031,-1302,-1708,-2109,-2357,-2357,-2138,-1847,-1624,-1479,-1318,-1070,-754,-429,-124,152,375,512,571,607,679,796,903,910,756,467,153,-77,-189,-220,-206,-153,-70,-3,-9,-101,-250,-415,-565,-672,-716,-707,-683,-686,-723,-770,-786,-741,-632,-494,-385,-341,-350,-365,-346,-283,-188,-74,49,161,236,252,211,133,46,-30,-89,-131,-156,-166,-170,-187,-228,-287,-347,-390,-414,-426,-434,-437,-423,-383,-320,-255,-212,-201,-217,-248,-279,-291,-272,-235,-209,-207,-214,-206,-180,-151,-129,-113,-102,-98,-102,-115,-140,-180,-228,-261,-255,-206,-131,-57,-6,13,2,-31,-72,-106,-123,-116,-95,-77,-70,-67,-61,-57,-62,-75,-91,-110,-136,-160,-170,-160,-141,-122,-107,-95,-84,-74,-70,-79,-102,-127,-137,-125,-100,-73,-47,-27,-20,-30,-48,-64,-78,-90,-95,-89,-77,-66,-57,-46,-36,-31,-27,-22,-22,-37,-62,-87,-113,-145,-163,-136,-66},
            {43,-127,-90,154,108,-259,341,3484,8693,12619,11255,3411,-7600,-15503,-15042,-6097,5328,11332,8933,2798,276,3750,8913,10484,7904,4599,3284,3842,4997,5784,5024,1466,-4211,-8746,-9243,-6458,-3960,-4173,-6319,-8159,-8438,-7234,-5148,-3106,-2266,-2983,-4028,-3702,-1766,402,1576,1853,1887,1800,1468,1330,2046,3393,4214,3693,2294,1172,963,1384,1761,1649,1061,404,192,560,1012,821,-220,-1571,-2509,-2777,-2610,-2301,-1970,-1699,-1630,-1792,-1975,-1914,-1600,-1286,-1186,-1247,-1275,-1195,-1100,-1071,-1042,-891,-579,-168,273,686,977,1052,926,735,618,623,729,901,1052,1034,758,331,-18,-174,-230,-345,-551,-744,-802,-692,-476,-277,-206,-291,-464,-640,-782,-875,-889,-810,-678,-555,-451,-332,-193,-78,-18,-1,-7,-27,-29,34,157,263,292,271,265,294,331,365,393,388,299,132,-39,-147,-192,-203,-190,-152,-108,-88,-103,-143,-205,-288,-383,-469,-527,-541,-499,-409,-304,-217,-148,-83,-25,1,-18,-70,-132,-179,-184,-127,-20,85,141,141,103,41,-44,-137,-210,-243,-237,-202,-145,-75,-10,34,50,34,-21,-113,-217,-299,-339,-338,-301,-231,-139,-50,10,31,11,-48,-135,-214,-245,-218,-156,-86,-16,49,95,108,91,53,0,-64,-119,-141,-120,-70,-10,43,75,78,58,30,1,-30,-65,-96,-116,-123,-117,-97,-71,-59,-70,-90,-99,-101,-109,-114,-92,-43}
        },
        {    // H30e114a.wav
            {1,2,2,2,2,2,2,2,1,0,0,1,1,0,-1,-1,1,2,2,3,3,1,-1,-1,2,3,1,0,2,5,4,2,3,3,-1,-5,0,8,9,4,8,16,10,-7,-6,16,16,16,195,773,1704,2530,2634,1707,-3,-1828,-3043,-3183,-2226,-581,1138,2464,3277,3689,3783,3543,3017,2445,2131,2197,2477,2638,2394,1670,657,-289,-871,-1055,-1062,-1140,-1359,-1618,-1808,-1907,-1937,-1903,-1800,-1657,-1507,-1334,-1077,-705,-279,91,329,435,468,495,568,705,874,995,977,788,487,187,-23,-124,-156,-169,-185,-198,-199,-201,-242,-356,-529,-695,-786,-783,-725,-666,-632,-622,-626,-633,-625,-585,-511,-422,-340,-278,-238,-213,-194,-171,-134,-72,24,143,246,281,232,130,27,-54,-117,-170,-206,-222,-230,-245,-275,-319,-376,-441,-496,-517,-497,-448,-388,-330,-283,-253,-239,-229,-214,-201,-202,-215,-219,-200,-167,-137,-119,-106,-94,-86,-87,-97,-112,-132,-160,-197,-238,-276,-299,-294,-253,-185,-109,-50,-20,-20,-41,-71,-97,-108,-100,-80,-63,-56,-52,-49,-47,-50,-59,-68,-76,-86,-106,-132,-152,-158,-152,-136,-111,-82,-62,-61,-78,-102,-123,-136,-136,-121,-95,-65,-40,-26,-26,-36,-48,-59,-69,-80,-87,-83,-71,-58,-45,-29,-12,-3,-9,-24,-43,-70,-103,-130,-137,-130,-123,-113,-86,-40},
            {80,-17,-133,-22,180,24,-253,784,4374,9385,12147,9206,597,-9382,-14684,-11677,-2213,7082,9849,5643,366,222,5381,10450,10839,7241,3646,2650,3863,5633,6414,4784,183,-5593,-9032,-8241,-5118,-3325,-4466,-7037,-8679,-8386,-6590,-4292,-2637,-2465,-3463,-4114,-3162,-985,942,1756,1802,1678,1500,1332,1637,2666,3738,3792,2660,1334,840,1209,1702,1725,1268,674,300,359,757,1030,662,-402,-1642,-2447,-2614,-2363,-1999,-1720,-1644,-1807,-2059,-2120,-1851,-1429,-1172,-1200,-1339,-1353,-1198,-1004,-875,-782,-644,-426,-133,228,621,928,1027,915,727,605,598,684,814,901,828,559,223,-5,-87,-146,-295,-504,-652,-661,-540,-359,-216,-198,-326,-530,-713,-821,-851,-814,-733,-644,-567,-480,-351,-194,-63,7,24,10,-4,20,105,214,273,256,211,196,221,261,303,332,312,212,60,-78,-160,-192,-192,-165,-118,-77,-64,-78,-112,-171,-256,-353,-436,-483,-484,-440,-369,-296,-235,-181,-122,-61,-22,-24,-66,-126,-165,-153,-88,-6,51,70,63,41,-2,-69,-148,-214,-249,-245,-204,-136,-60,0,35,51,46,6,-74,-172,-252,-295,-301,-274,-213,-129,-49,0,8,-20,-78,-151,-207,-216,-178,-118,-61,-11,31,60,73,71,54,15,-42,-96,-120,-107,-67,-16,29,53,52,38,23,7,-17,-51,-84,-109,-119,-110,-86,-65,-66,-85,-103,-109,-108,-101,-76,-35}
        },
        {    // H30e120a.wav
            {3,3,2,2,2,2,1,0,0,0,1,1,0,0,1,2,2,2,2,2,1,0,0,1,1,2,4,5,2,0,2,4,0,-4,1,9,7,-2,0,12,12,-2,-1,18,16,14,199,796,1742,2542,2565,1566,-91,-1694,-2641,-2696,-1964,-738,658,1972,3052,3775,4000,3656,2905,2152,1815,2028,2536,2867,2636,1783,602,-448,-1048,-1206,-1184,-1252,-1486,-1780,-1984,-2028,-1935,-1778,-1626,-1513,-1421,-1288,-1046,-676,-238,155,413,538,612,712,838,927,943,913,882,843,737,523,231,-53,-245,-307,-252,-140,-55,-78,-241,-506,-777,-958,-1011,-970,-904,-850,-800,-737,-664,-599,-540,-471,-389,-317,-276,-256,-231,-188,-136,-86,-35,25,93,156,198,209,185,131,64,5,-40,-86,-145,-214,-272,-308,-329,-354,-395,-451,-511,-559,-576,-545,-468,-379,-318,-301,-302,-288,-250,-207,-174,-148,-126,-114,-115,-116,-96,-56,-17,-1,-11,-37,-75,-124,-181,-241,-296,-334,-344,-317,-258,-188,-131,-98,-86,-88,-96,-105,-111,-113,-112,-109,-98,-75,-45,-21,-15,-29,-53,-72,-81,-83,-84,-91,-105,-121,-129,-124,-113,-101,-91,-82,-80,-89,-106,-122,-132,-134,-123,-100,-73,-54,-46,-46,-51,-63,-77,-84,-83,-78,-71,-57,-35,-15,-4,0,-4,-21,-55,-93,-122,-137,-141,-130,-103,-75,-67,-73,-67,-36},
            {-1,85,13,-121,-36,158,19,-212,858,4341,9010,11324,8190,5,-8914,-13016,-9511,-862,6587,7684,3190,-877,622,6669,11550,11175,6848,2894,2035,3792,6086,6874,4747,-252,-5819,-8648,-7476,-4510,-3158,-4636,-7289,-8789,-8204,-6134,-3835,-2518,-2724,-3763,-4098,-2807,-565,1181,1767,1652,1461,1366,1454,1999,2940,3526,3054,1830,921,936,1451,1710,1481,1033,628,377,397,710,984,703,-269,-1471,-2272,-2430,-2158,-1813,-1662,-1811,-2158,-2394,-2228,-1700,-1175,-996,-1165,-1392,-1411,-1191,-876,-610,-448,-368,-306,-170,113,510,864,1002,892,671,511,487,565,670,719,645,444,204,38,-38,-102,-222,-376,-493,-521,-457,-334,-229,-229,-361,-553,-700,-759,-754,-722,-680,-636,-585,-502,-364,-188,-33,54,72,50,27,42,111,197,233,194,124,88,108,163,222,260,243,152,16,-103,-164,-176,-167,-146,-114,-77,-47,-31,-39,-86,-179,-296,-395,-446,-446,-412,-364,-312,-260,-206,-142,-75,-30,-30,-71,-126,-157,-144,-97,-46,-14,-6,-11,-24,-53,-104,-168,-224,-250,-236,-187,-117,-47,8,45,66,63,25,-47,-130,-195,-231,-245,-237,-201,-145,-90,-52,-32,-35,-67,-121,-166,-176,-156,-126,-94,-54,-6,37,67,82,76,38,-30,-99,-134,-124,-83,-35,7,35,47,44,31,11,-16,-48,-80,-104,-110,-97,-76,-67,-75,-89,-98,-99,-91,-67,-31}
        },
        {    // H30e126a.wav
            {3,2,0,-1,0,1,-1,-3,-2,0,0,-1,-1,0,1,1,0,-1,-2,-1,0,0,-2,-2,2,4,1,-2,0,2,-3,-9,-4,7,7,-1,0,11,8,-10,-11,11,15,28,253,912,1897,2647,2519,1357,-343,-1810,-2526,-2418,-1698,-626,610,1880,3044,3883,4140,3713,2836,2019,1717,2003,2530,2790,2452,1546,414,-518,-1002,-1113,-1147,-1357,-1749,-2103,-2204,-2043,-1818,-1736,-1814,-1880,-1747,-1377,-888,-422,-52,217,406,547,684,842,990,1071,1073,1040,1016,981,874,660,373,92,-102,-169,-131,-63,-41,-98,-226,-410,-639,-881,-1076,-1178,-1192,-1154,-1086,-986,-859,-732,-633,-554,-464,-347,-222,-125,-81,-87,-109,-101,-37,72,189,274,305,282,216,131,50,-10,-50,-79,-109,-148,-199,-260,-326,-393,-458,-516,-562,-586,-580,-548,-510,-484,-465,-432,-375,-314,-268,-233,-192,-146,-115,-106,-96,-61,-10,29,44,44,37,13,-39,-109,-179,-236,-278,-306,-316,-304,-272,-226,-175,-137,-127,-139,-153,-152,-143,-142,-151,-154,-141,-110,-76,-48,-29,-22,-30,-48,-66,-78,-87,-96,-101,-100,-98,-97,-91,-79,-70,-75,-91,-106,-116,-125,-133,-134,-124,-108,-93,-81,-70,-66,-73,-89,-105,-114,-111,-97,-74,-48,-23,-3,8,2,-22,-54,-86,-115,-137,-140,-124,-105,-96,-88,-69,-54,-67,-96,-97,-53},
            {-52,10,79,10,-113,-46,137,42,-198,600,3570,7881,10440,8196,1114,-7060,-11177,-8545,-1320,4858,5549,1650,-1383,897,7251,12149,11624,6944,2543,1476,3437,6113,7141,5115,285,-5076,-7932,-7116,-4532,-3255,-4539,-7017,-8513,-8010,-6016,-3808,-2602,-2851,-3818,-4051,-2739,-549,1139,1668,1489,1312,1383,1668,2182,2779,2971,2411,1468,926,1086,1494,1596,1330,964,646,408,372,620,890,716,-54,-1056,-1798,-2088,-2048,-1902,-1857,-2050,-2400,-2570,-2272,-1610,-1032,-884,-1105,-1357,-1375,-1131,-765,-432,-225,-154,-153,-110,72,394,733,907,835,608,405,340,398,498,561,527,382,185,30,-45,-82,-143,-236,-333,-405,-426,-377,-293,-268,-361,-520,-637,-663,-635,-601,-579,-571,-568,-529,-404,-205,-13,95,113,84,48,36,67,125,153,111,27,-29,-16,54,141,201,195,112,-10,-105,-145,-150,-149,-144,-124,-91,-49,-4,25,3,-91,-228,-349,-413,-419,-389,-346,-304,-268,-226,-163,-88,-35,-32,-78,-138,-175,-174,-146,-113,-93,-89,-93,-96,-101,-119,-154,-200,-235,-237,-195,-123,-47,14,55,75,70,35,-22,-82,-128,-162,-190,-206,-202,-176,-137,-94,-53,-27,-34,-78,-135,-173,-179,-163,-131,-82,-22,29,56,64,57,27,-32,-99,-136,-127,-89,-48,-15,9,22,21,11,1,-8,-26,-55,-81,-92,-89,-81,-74,-70,-73,-84,-90,-73,-35}
        },
        {    // H30e132a.wav
            {3,1,0,0,0,-1,-1,0,1,0,0,0,1,1,1,0,-1,-1,1,2,1,0,3,5,3,0,2,3,-1,-6,-2,4,2,-2,8,20,11,-10,-6,17,13,37,332,1103,2152,2823,2484,1103,-674,-2029,-2527,-2244,-1486,-480,702,2019,3294,4184,4348,3726,2686,1841,1638,2055,2647,2866,2403,1347,107,-855,-1304,-1346,-1301,-1438,-1780,-2120,-2226,-2052,-1793,-1703,-1846,-2022,-1968,-1607,-1087,-587,-157,232,562,764,835,877,979,1116,1192,1170,1098,1025,932,773,544,296,91,-26,-46,2,58,52,-60,-279,-558,-826,-1014,-1097,-1108,-1114,-1150,-1188,-1168,-1062,-896,-720,-566,-444,-347,-263,-180,-93,-13,52,101,147,203,270,330,356,330,259,165,75,-1,-69,-135,-195,-233,-246,-255,-297,-392,-519,-621,-657,-632,-589,-557,-528,-486,-439,-407,-383,-339,-265,-191,-151,-144,-139,-110,-57,4,61,104,119,93,33,-38,-97,-138,-167,-190,-210,-230,-245,-244,-223,-196,-181,-181,-182,-175,-172,-184,-205,-214,-198,-166,-130,-92,-52,-22,-17,-36,-62,-82,-90,-87,-79,-74,-77,-81,-76,-62,-48,-43,-49,-64,-85,-108,-125,-130,-126,-120,-114,-104,-89,-73,-65,-73,-95,-121,-137,-136,-118,-85,-45,-9,12,14,1,-27,-70,-115,-142,-142,-127,-110,-90,-64,-44,-45,-59,-69,-78,-100,-123,-111,-57},
            {16,-49,-33,57,54,-67,-82,79,97,-137,205,2349,6173,9312,8669,3297,-4157,-9043,-8260,-2900,2448,3636,851,-1492,729,6886,12097,12206,7745,2849,1051,2665,5541,7132,5846,1697,-3465,-6879,-7022,-5023,-3550,-4208,-6285,-7887,-7798,-6194,-4149,-2836,-2824,-3624,-3965,-2934,-917,820,1476,1365,1256,1461,1801,2101,2332,2376,2062,1502,1106,1124,1365,1474,1329,1035,703,414,312,479,718,672,198,-501,-1141,-1614,-1937,-2119,-2196,-2292,-2462,-2531,-2247,-1634,-1052,-855,-1037,-1286,-1303,-1035,-641,-308,-122,-60,-45,5,145,378,630,775,730,540,340,240,261,348,422,411,295,131,13,-28,-46,-97,-178,-261,-335,-391,-398,-349,-306,-339,-438,-518,-526,-489,-456,-449,-473,-514,-525,-443,-261,-54,88,140,130,87,34,2,10,29,12,-47,-100,-96,-30,62,135,151,98,4,-76,-113,-120,-126,-138,-142,-125,-82,-20,34,42,-16,-124,-239,-323,-358,-348,-316,-288,-271,-241,-176,-89,-26,-23,-72,-139,-196,-230,-235,-211,-173,-141,-122,-108,-98,-104,-138,-189,-227,-231,-200,-145,-76,-4,56,91,94,67,22,-29,-75,-112,-142,-164,-171,-158,-127,-86,-49,-30,-43,-87,-138,-169,-171,-153,-126,-89,-45,-8,12,22,28,21,-13,-62,-94,-97,-83,-68,-51,-31,-13,-1,14,33,40,20,-18,-54,-79,-91,-87,-67,-53,-63,-84,-81,-43}
        },
        {    // H30e138a.wav
            {-1,-1,-2,-3,-2,-1,-1,-2,-2,-1,0,0,-1,-2,-3,-2,-1,-1,-2,0,3,3,-1,-2,2,2,-5,-10,-3,4,-2,-8,2,16,8,-9,0,19,6,58,453,1361,2466,3016,2409,773,-1086,-2311,-2575,-2105,-1287,-310,866,2267,3666,4586,4602,3722,2491,1648,1610,2200,2828,2920,2257,1054,-218,-1121,-1499,-1524,-1527,-1732,-2106,-2413,-2419,-2095,-1672,-1467,-1614,-1931,-2073,-1833,-1293,-688,-186,189,468,666,801,927,1084,1233,1286,1210,1075,978,936,871,694,402,102,-67,-40,118,256,246,57,-239,-538,-760,-880,-922,-938,-978,-1053,-1127,-1146,-1089,-983,-872,-779,-690,-581,-451,-323,-222,-146,-70,34,168,306,406,437,400,325,252,200,163,120,54,-40,-150,-249,-312,-340,-357,-388,-442,-520,-622,-721,-762,-702,-565,-431,-362,-349,-344,-324,-300,-279,-249,-201,-149,-104,-60,-7,45,68,53,17,-12,-23,-22,-23,-39,-79,-135,-180,-195,-188,-182,-190,-200,-202,-204,-219,-241,-256,-258,-254,-246,-222,-172,-106,-50,-21,-18,-33,-57,-83,-103,-111,-113,-110,-100,-78,-50,-25,-15,-22,-42,-65,-86,-103,-115,-120,-120,-119,-116,-106,-91,-84,-94,-114,-131,-138,-138,-132,-116,-88,-55,-23,-1,2,-23,-69,-113,-138,-143,-136,-122,-102,-84,-71,-60,-48,-44,-56,-74,-85,-94,-113,-129,-111,-55},
            {4,22,-12,-38,11,55,-10,-83,0,106,-29,-66,1086,4053,7565,8805,5790,-438,-6154,-7789,-4875,-450,1655,423,-1320,194,5535,11111,12619,9226,4086,1084,1625,4289,6579,6551,3626,-1084,-5213,-6753,-5741,-4150,-3928,-5278,-6884,-7396,-6480,-4766,-3277,-2792,-3271,-3764,-3219,-1564,209,1142,1255,1236,1473,1757,1841,1833,1901,1923,1692,1303,1083,1176,1382,1426,1218,841,444,203,241,479,640,488,36,-546,-1134,-1690,-2157,-2448,-2552,-2530,-2394,-2081,-1609,-1173,-992,-1073,-1200,-1152,-898,-568,-302,-145,-57,24,134,274,424,552,622,611,523,396,281,215,206,225,224,171,86,18,-12,-31,-74,-148,-241,-341,-426,-451,-394,-299,-244,-261,-315,-361,-386,-395,-388,-386,-412,-453,-444,-335,-153,22,128,156,120,43,-36,-74,-69,-63,-91,-134,-143,-93,-4,79,116,95,34,-30,-71,-94,-117,-148,-172,-170,-130,-60,14,55,40,-29,-124,-212,-270,-291,-283,-264,-247,-226,-182,-113,-49,-27,-57,-122,-195,-254,-283,-275,-239,-194,-155,-123,-97,-87,-105,-147,-192,-216,-212,-180,-125,-53,19,75,106,110,89,50,3,-42,-80,-110,-127,-124,-105,-82,-65,-58,-64,-85,-112,-131,-135,-130,-122,-109,-88,-61,-34,-5,24,39,26,-7,-43,-71,-85,-83,-66,-41,-15,11,39,60,64,49,20,-18,-57,-82,-83,-75,-81,-96,-88,-46}
        },
        {    // H30e144a.wav
            {-1,-1,-1,-1,-1,-1,1,2,1,0,0,0,-2,-2,-1,0,0,1,4,3,-1,-1,4,3,-5,-7,2,6,-4,-10,5,19,5,-10,9,29,9,94,610,1683,2852,3246,2308,366,-1581,-2645,-2634,-1951,-1064,-101,1096,2603,4118,5032,4864,3716,2302,1475,1614,2392,3066,3013,2099,693,-622,-1425,-1682,-1680,-1752,-2028,-2399,-2643,-2594,-2248,-1791,-1502,-1545,-1806,-1966,-1771,-1247,-637,-158,155,387,602,797,955,1084,1187,1237,1207,1119,1023,941,837,666,430,190,26,-17,46,144,182,93,-125,-403,-649,-806,-870,-874,-855,-849,-878,-930,-954,-908,-804,-701,-644,-621,-593,-540,-468,-377,-255,-100,68,223,349,432,458,424,348,261,184,119,59,1,-58,-123,-196,-272,-346,-430,-545,-684,-790,-795,-691,-547,-445,-401,-375,-336,-298,-286,-288,-273,-234,-194,-169,-142,-95,-41,-12,-19,-39,-39,-11,28,54,52,22,-23,-69,-105,-128,-136,-132,-129,-146,-186,-234,-270,-289,-299,-304,-300,-279,-236,-175,-108,-54,-30,-33,-47,-57,-64,-79,-99,-110,-106,-91,-73,-53,-33,-18,-16,-31,-56,-78,-91,-98,-106,-111,-106,-92,-81,-85,-99,-113,-123,-134,-147,-153,-142,-112,-70,-28,-1,2,-20,-58,-98,-130,-145,-143,-128,-109,-88,-66,-46,-38,-43,-50,-54,-61,-75,-86,-87,-90,-109,-127,-110,-55},
            {-23,-9,22,11,-33,-27,33,37,-45,-61,50,68,-90,220,1988,5156,7837,7526,3466,-2253,-6160,-6216,-3420,-731,-214,-1026,-322,3584,9011,12184,10820,6270,2091,881,2587,5246,6636,5427,1765,-2694,-5727,-6219,-5032,-4046,-4370,-5602,-6592,-6551,-5480,-4009,-2992,-2911,-3375,-3378,-2322,-674,588,1069,1178,1365,1562,1536,1418,1522,1798,1847,1502,1096,1032,1292,1515,1429,1049,540,105,-46,183,601,803,531,-108,-821,-1441,-1976,-2413,-2644,-2590,-2316,-1953,-1596,-1302,-1133,-1109,-1143,-1083,-860,-559,-318,-185,-101,12,169,332,456,525,545,537,522,496,424,282,109,-10,-29,10,34,22,5,-12,-71,-191,-326,-412,-436,-423,-387,-322,-239,-176,-160,-188,-245,-314,-374,-408,-418,-420,-409,-352,-229,-72,62,131,126,60,-31,-100,-120,-109,-110,-137,-162,-152,-97,-15,59,88,54,-20,-87,-123,-138,-156,-181,-192,-173,-123,-55,7,36,14,-49,-126,-193,-237,-253,-248,-238,-228,-206,-156,-91,-44,-41,-80,-146,-222,-290,-329,-325,-286,-230,-173,-121,-81,-71,-98,-150,-206,-244,-248,-211,-140,-55,25,86,123,134,120,84,31,-31,-87,-126,-143,-142,-128,-105,-82,-68,-67,-79,-99,-122,-143,-156,-157,-146,-122,-87,-44,-2,30,43,32,-2,-45,-80,-94,-89,-71,-44,-10,24,50,65,61,29,-29,-89,-126,-139,-141,-133,-101,-47}
        },
        {    // H30e150a.wav
            {-3,-3,-2,-2,-1,0,0,-1,-2,-3,-4,-3,-1,-1,-1,1,4,2,-3,-2,4,2,-7,-8,3,6,-7,-12,5,17,-1,-13,14,31,8,144,806,2060,3285,3488,2172,-114,-2158,-3039,-2714,-1785,-807,156,1388,3012,4634,5501,5097,3654,2085,1330,1682,2632,3302,3059,1876,273,-1071,-1751,-1852,-1792,-1941,-2348,-2776,-2949,-2764,-2326,-1858,-1571,-1556,-1728,-1866,-1751,-1316,-686,-80,343,569,690,801,930,1057,1156,1213,1210,1128,983,831,718,619,469,251,42,-54,-12,86,120,19,-211,-502,-755,-882,-861,-752,-660,-655,-728,-809,-825,-749,-617,-497,-438,-443,-480,-511,-515,-485,-417,-303,-138,64,252,366,380,326,260,213,180,150,115,63,-13,-96,-159,-211,-306,-476,-677,-817,-844,-783,-683,-565,-433,-308,-233,-229,-271,-308,-306,-264,-204,-153,-127,-130,-151,-167,-155,-103,-29,33,55,45,30,26,19,-12,-63,-105,-113,-92,-72,-82,-128,-194,-253,-290,-306,-312,-314,-310,-292,-254,-198,-134,-77,-42,-34,-49,-75,-99,-109,-104,-91,-78,-66,-50,-32,-19,-18,-30,-51,-77,-104,-124,-131,-127,-116,-102,-89,-83,-87,-101,-120,-139,-154,-163,-161,-144,-109,-64,-22,-1,-10,-45,-91,-128,-145,-142,-129,-115,-103,-90,-74,-56,-38,-27,-29,-45,-64,-76,-84,-96,-113,-125,-125,-114,-93,-62,-26},
            {13,-9,-26,-4,24,5,-31,-11,40,19,-53,-32,65,23,-68,547,2618,5631,7563,6416,2176,-2857,-5838,-5627,-3478,-1616,-1025,-542,1747,6112,10327,11508,8852,4425,1300,1108,3209,5604,6316,4414,513,-3513,-5782,-5801,-4685,-3983,-4366,-5378,-6109,-5935,-4869,-3550,-2802,-2899,-3228,-2893,-1688,-258,688,1069,1212,1270,1187,1079,1232,1648,1907,1678,1191,969,1199,1556,1619,1267,669,89,-202,-19,525,979,899,260,-566,-1240,-1729,-2140,-2443,-2494,-2271,-1931,-1632,-1406,-1229,-1115,-1073,-1032,-894,-649,-389,-195,-69,31,126,221,333,477,615,678,643,546,426,282,113,-36,-105,-93,-60,-49,-44,-25,-32,-121,-283,-437,-510,-494,-420,-320,-224,-164,-150,-159,-173,-208,-281,-370,-432,-449,-431,-377,-267,-106,55,151,154,86,-6,-75,-95,-79,-69,-97,-149,-183,-169,-109,-35,17,23,-10,-58,-100,-136,-173,-205,-218,-208,-174,-115,-38,27,43,1,-73,-145,-194,-218,-223,-215,-203,-188,-160,-108,-46,-8,-20,-82,-170,-257,-320,-343,-322,-271,-211,-156,-112,-84,-82,-112,-166,-218,-243,-229,-179,-106,-28,43,97,128,135,119,83,34,-23,-84,-139,-176,-183,-159,-115,-67,-28,-10,-21,-58,-109,-159,-196,-209,-188,-134,-62,10,67,95,84,39,-19,-66,-95,-101,-81,-44,-8,15,30,40,32,-2,-50,-90,-119,-144,-154,-124,-59}
        },
        {    // H30e156a.wav
            {-2,-1,1,0,-1,0,1,-2,-5,-2,2,1,-2,2,7,4,-3,-2,5,2,-8,-5,9,8,-10,-13,10,18,-7,-16,22,36,8,207,1046,2506,3778,3741,1986,-678,-2809,-3469,-2793,-1595,-515,464,1756,3516,5227,5988,5279,3516,1827,1213,1833,2964,3588,3085,1569,-263,-1620,-2131,-2027,-1872,-2077,-2613,-3124,-3268,-2972,-2431,-1933,-1663,-1623,-1680,-1686,-1547,-1231,-749,-178,345,695,857,930,1017,1137,1232,1249,1187,1078,952,828,702,552,364,164,14,-42,-21,12,-9,-119,-323,-585,-831,-980,-997,-915,-789,-662,-560,-508,-513,-538,-528,-459,-358,-271,-233,-256,-324,-390,-385,-273,-88,89,192,213,185,143,104,79,71,76,78,64,29,-36,-144,-297,-465,-603,-687,-728,-737,-702,-612,-492,-395,-348,-329,-297,-239,-180,-144,-138,-153,-184,-218,-232,-201,-124,-29,40,57,30,-6,-17,0,16,4,-36,-78,-104,-113,-112,-108,-111,-133,-178,-230,-270,-293,-306,-310,-298,-268,-225,-176,-126,-82,-58,-59,-74,-89,-96,-100,-104,-104,-91,-63,-24,12,33,29,3,-38,-82,-121,-149,-160,-156,-144,-132,-121,-111,-104,-107,-121,-142,-160,-170,-165,-142,-101,-53,-15,-1,-13,-43,-80,-111,-131,-138,-134,-120,-98,-74,-52,-36,-27,-26,-32,-42,-56,-73,-91,-105,-113,-114,-102,-77,-50,-36,-35,-31,-16},
            {-4,9,11,-11,-24,-1,20,-3,-30,-3,37,5,-53,-17,61,1,-15,759,2889,5684,7203,5772,1617,-3082,-5847,-5759,-3876,-1964,-760,587,3301,7197,10297,10473,7512,3463,966,1241,3473,5652,5932,3676,-203,-3828,-5643,-5458,-4378,-3741,-4106,-5058,-5722,-5472,-4390,-3207,-2673,-2841,-3023,-2520,-1334,-64,753,1032,970,796,736,980,1469,1830,1734,1308,1025,1170,1535,1690,1415,833,229,-119,-46,393,867,970,553,-173,-890,-1460,-1901,-2197,-2263,-2105,-1872,-1696,-1556,-1370,-1158,-1019,-970,-905,-736,-501,-287,-119,27,141,190,204,283,481,715,832,748,512,246,47,-51,-71,-68,-82,-105,-96,-41,9,-22,-161,-356,-526,-613,-600,-500,-351,-217,-152,-163,-213,-264,-310,-355,-391,-400,-378,-332,-259,-149,-13,113,185,182,116,24,-47,-71,-64,-68,-108,-165,-199,-188,-142,-86,-48,-40,-58,-91,-132,-178,-225,-257,-261,-234,-183,-115,-43,10,21,-14,-74,-135,-186,-220,-230,-215,-183,-142,-93,-40,0,6,-30,-100,-185,-263,-311,-319,-292,-251,-211,-171,-130,-99,-92,-113,-151,-190,-211,-200,-159,-102,-44,11,60,95,108,95,59,3,-67,-136,-185,-200,-178,-128,-64,-6,25,20,-19,-80,-144,-193,-210,-192,-148,-85,-11,57,95,95,65,17,-38,-83,-100,-89,-72,-64,-55,-33,-10,-3,-10,-21,-45,-91,-135,-131,-69}
        },
        {    // H30e162a.wav
            {0,0,-1,0,-1,-4,-6,-2,1,-1,-2,3,7,2,-5,-1,6,0,-12,-7,9,7,-12,-12,12,15,-15,-17,30,37,7,282,1315,2991,4300,3997,1771,-1291,-3512,-3929,-2870,-1383,-200,786,2143,4055,5862,6489,5429,3323,1543,1129,2049,3343,3879,3086,1224,-842,-2220,-2561,-2242,-1981,-2230,-2872,-3437,-3537,-3145,-2532,-2024,-1781,-1736,-1705,-1561,-1314,-1024,-684,-243,278,739,1004,1075,1081,1137,1240,1304,1266,1141,988,841,687,504,306,139,30,-35,-89,-150,-223,-326,-483,-688,-893,-1040,-1101,-1075,-972,-814,-640,-496,-402,-349,-316,-284,-242,-197,-178,-205,-248,-236,-127,45,199,277,272,207,114,26,-31,-51,-44,-27,-17,-43,-123,-241,-353,-435,-504,-584,-660,-689,-650,-568,-490,-443,-420,-395,-348,-277,-202,-150,-135,-157,-201,-240,-238,-172,-55,61,122,116,72,27,-1,-19,-35,-51,-69,-94,-128,-159,-167,-150,-131,-136,-170,-213,-247,-269,-284,-295,-295,-279,-246,-198,-141,-89,-60,-60,-76,-93,-103,-111,-118,-119,-110,-92,-66,-32,9,45,60,43,-1,-59,-117,-162,-190,-195,-177,-151,-132,-125,-129,-143,-166,-193,-211,-212,-191,-150,-95,-41,-7,0,-16,-44,-74,-98,-110,-114,-112,-103,-84,-62,-45,-36,-29,-26,-33,-52,-72,-88,-103,-118,-123,-109,-82,-53,-22,8,19,-6,-48,-64,-38},
            {11,0,-5,6,10,-9,-20,0,19,-1,-26,-3,31,4,-44,-11,52,0,32,843,2918,5552,6900,5405,1309,-3301,-6037,-5951,-3965,-1747,-126,1468,4010,7341,9805,9628,6707,2947,770,1258,3520,5534,5572,3211,-513,-3829,-5388,-5101,-4020,-3407,-3793,-4737,-5343,-5041,-4019,-3006,-2605,-2751,-2817,-2250,-1101,66,706,727,473,394,695,1218,1608,1633,1385,1183,1251,1500,1636,1450,991,491,175,135,320,581,733,633,247,-346,-1005,-1585,-1967,-2084,-1971,-1765,-1614,-1545,-1475,-1330,-1135,-962,-834,-704,-535,-344,-174,-49,30,71,110,205,390,623,798,817,660,388,112,-66,-105,-45,22,33,-4,-36,-38,-46,-114,-252,-414,-549,-641,-687,-667,-565,-409,-274,-220,-248,-313,-363,-379,-365,-326,-265,-183,-82,24,114,166,176,154,115,76,45,19,-22,-90,-171,-233,-249,-219,-160,-99,-62,-65,-103,-155,-206,-251,-284,-294,-275,-233,-179,-118,-55,-8,7,-16,-67,-130,-184,-211,-207,-185,-154,-113,-56,2,36,29,-18,-90,-169,-234,-270,-277,-264,-242,-210,-166,-117,-80,-71,-96,-143,-187,-208,-199,-167,-120,-68,-18,23,53,65,49,2,-64,-127,-168,-178,-157,-110,-52,-1,28,31,6,-40,-92,-134,-155,-155,-131,-85,-28,22,55,71,68,39,-12,-62,-93,-108,-116,-113,-92,-63,-38,-16,9,20,-5,-50,-70,-43}
        },
        {    // H30e168a.wav
            {-1,-1,-2,-6,-7,-2,1,-1,-2,4,7,0,-6,0,7,-2,-15,-7,11,5,-17,-13,17,15,-23,-21,34,35,10,374,1612,3505,4839,4254,1549,-1915,-4230,-4413,-2977,-1197,104,1124,2576,4655,6539,6992,5548,3097,1252,1072,2314,3765,4181,3059,836,-1454,-2836,-3005,-2479,-2115,-2404,-3147,-3756,-3803,-3309,-2626,-2112,-1889,-1827,-1713,-1450,-1110,-804,-541,-227,205,693,1087,1272,1266,1195,1183,1245,1288,1215,1037,842,685,535,354,176,62,6,-69,-213,-406,-604,-790,-957,-1075,-1118,-1110,-1091,-1057,-962,-788,-584,-415,-304,-240,-211,-211,-218,-206,-169,-113,-30,99,261,400,463,438,353,240,128,41,-10,-42,-95,-190,-304,-392,-432,-452,-494,-571,-651,-696,-693,-652,-586,-503,-419,-352,-305,-265,-225,-200,-206,-234,-252,-233,-177,-96,-4,81,136,151,136,112,87,57,19,-23,-70,-128,-191,-237,-245,-218,-182,-159,-160,-182,-219,-261,-298,-323,-330,-313,-273,-217,-157,-101,-55,-29,-29,-54,-90,-122,-139,-139,-126,-106,-82,-51,-15,19,42,48,35,2,-52,-115,-168,-191,-188,-174,-157,-136,-120,-123,-154,-202,-249,-276,-272,-235,-174,-106,-47,-10,-1,-16,-45,-73,-91,-97,-92,-78,-62,-50,-42,-33,-23,-17,-20,-29,-43,-65,-96,-128,-147,-147,-129,-92,-41,5,29,30,19,-3,-40,-75,-78,-43},
            {1,9,10,-1,-6,4,8,-9,-19,0,19,1,-24,-4,29,6,-40,-12,50,10,44,807,2779,5311,6623,5165,1134,-3423,-6110,-5933,-3787,-1375,362,1869,4096,7027,9218,9008,6238,2676,648,1196,3418,5326,5291,2992,-538,-3634,-5051,-4717,-3645,-3058,-3459,-4389,-4976,-4711,-3804,-2914,-2547,-2626,-2601,-2008,-944,21,409,281,124,323,821,1270,1437,1385,1327,1381,1490,1519,1380,1098,785,551,426,371,361,408,481,439,127,-450,-1094,-1579,-1816,-1852,-1772,-1646,-1525,-1437,-1360,-1245,-1070,-862,-656,-469,-311,-200,-145,-126,-112,-71,37,246,532,780,858,724,467,227,84,30,23,37,64,87,74,10,-86,-188,-287,-391,-499,-603,-696,-770,-804,-769,-657,-503,-362,-272,-237,-248,-284,-308,-278,-187,-67,43,130,200,244,243,196,129,73,36,1,-51,-119,-187,-237,-259,-248,-204,-142,-96,-99,-151,-222,-275,-299,-302,-296,-282,-257,-215,-155,-88,-32,-7,-20,-63,-115,-157,-179,-181,-166,-139,-102,-55,-3,40,55,27,-38,-122,-198,-248,-266,-256,-226,-184,-138,-97,-73,-77,-110,-162,-213,-241,-237,-205,-156,-100,-46,-3,21,19,-10,-59,-115,-160,-179,-166,-125,-69,-13,32,57,55,24,-26,-80,-120,-135,-123,-88,-45,-8,12,17,10,-6,-30,-58,-82,-100,-110,-111,-104,-87,-59,-24,7,19,11,-1,-4}
        },
        {    // H30e174a.wav
            {0,-5,-6,-1,3,0,-2,4,8,1,-5,1,7,-3,-15,-4,13,3,-20,-10,23,15,-29,-20,42,34,15,479,1933,4034,5373,4498,1330,-2511,-4916,-4889,-3106,-1047,379,1454,3026,5288,7246,7500,5648,2857,981,1065,2629,4207,4464,2993,417,-2069,-3433,-3442,-2744,-2299,-2609,-3414,-4045,-4039,-3454,-2717,-2225,-2048,-1957,-1704,-1272,-846,-567,-384,-147,214,641,1039,1331,1460,1412,1269,1173,1188,1225,1148,928,659,442,308,239,212,175,51,-193,-510,-821,-1077,-1259,-1341,-1315,-1229,-1157,-1110,-1025,-848,-612,-406,-289,-258,-276,-301,-299,-249,-153,-30,111,267,422,537,583,560,494,410,315,202,70,-67,-179,-251,-295,-337,-394,-468,-562,-671,-769,-819,-803,-734,-636,-527,-421,-339,-295,-280,-275,-266,-243,-190,-107,-26,12,3,-7,30,113,195,229,204,139,65,0,-53,-103,-158,-212,-248,-255,-234,-198,-170,-169,-201,-252,-298,-323,-329,-326,-315,-289,-238,-164,-81,-14,17,6,-33,-78,-115,-136,-140,-129,-106,-77,-43,-1,43,76,78,41,-29,-108,-170,-197,-188,-159,-128,-105,-97,-109,-142,-191,-240,-275,-287,-272,-232,-174,-111,-59,-29,-25,-41,-66,-87,-91,-79,-62,-51,-45,-38,-24,-6,12,27,32,16,-20,-63,-99,-125,-142,-148,-138,-111,-71,-21,26,52,45,15,-18,-47,-73,-88,-74,-35},
            {2,-2,-1,9,11,0,-6,4,10,-6,-19,-2,17,1,-23,-5,30,11,-38,-16,49,20,36,711,2544,4971,6291,4954,1085,-3337,-5937,-5706,-3522,-1100,577,1908,3859,6525,8607,8499,5955,2591,634,1124,3224,5041,5033,2908,-368,-3250,-4576,-4273,-3282,-2752,-3156,-4062,-4655,-4462,-3665,-2848,-2463,-2452,-2356,-1809,-938,-231,0,-61,6,373,836,1138,1262,1352,1468,1531,1468,1312,1143,1001,878,744,567,359,214,229,347,343,38,-497,-1031,-1406,-1626,-1734,-1721,-1589,-1420,-1303,-1225,-1099,-888,-644,-440,-308,-247,-239,-244,-220,-157,-72,45,237,502,745,845,757,544,311,137,53,46,73,88,67,17,-54,-151,-281,-435,-586,-706,-782,-814,-807,-764,-700,-637,-582,-516,-415,-289,-184,-132,-118,-105,-71,-20,43,120,206,276,300,264,179,72,-20,-72,-90,-111,-161,-228,-270,-264,-220,-167,-132,-131,-168,-229,-286,-318,-330,-334,-330,-303,-243,-160,-76,-13,12,-7,-58,-111,-140,-143,-136,-130,-121,-95,-47,12,59,76,53,-8,-91,-169,-216,-225,-209,-184,-157,-127,-99,-86,-100,-139,-191,-238,-265,-263,-231,-179,-122,-69,-26,2,4,-25,-76,-131,-169,-177,-153,-101,-35,26,69,87,81,51,2,-52,-95,-114,-109,-88,-62,-41,-32,-32,-34,-36,-40,-50,-67,-84,-91,-83,-63,-40,-21,-7,2,5,3}
        },
        {    // H30e180a.wav
            {-7,-1,4,0,-2,5,9,0,-7,2,9,-4,-18,-5,15,3,-22,-8,26,12,-35,-19,47,28,23,593,2251,4535,5867,4729,1157,-3013,-5510,-5333,-3288,-1003,556,1737,3470,5921,7941,8004,5774,2667,754,1080,2950,4649,4743,2914,-17,-2683,-4006,-3847,-3005,-2523,-2879,-3727,-4335,-4243,-3567,-2800,-2354,-2236,-2121,-1725,-1107,-575,-319,-217,-29,313,691,1000,1251,1455,1544,1462,1281,1146,1113,1104,1006,779,479,227,141,228,334,252,-84,-541,-947,-1250,-1477,-1608,-1587,-1435,-1270,-1174,-1101,-956,-723,-480,-310,-240,-255,-313,-351,-313,-190,-23,150,317,472,594,663,678,635,520,333,122,-31,-79,-50,-22,-62,-176,-322,-456,-569,-675,-775,-845,-863,-820,-730,-617,-512,-442,-414,-404,-371,-288,-165,-38,47,63,22,-18,2,94,211,287,287,214,101,-9,-81,-110,-124,-155,-204,-246,-255,-228,-182,-150,-160,-209,-270,-314,-333,-340,-345,-339,-308,-247,-166,-80,-11,17,-2,-48,-91,-116,-126,-129,-123,-108,-86,-55,-9,46,85,79,24,-58,-136,-192,-216,-209,-177,-137,-105,-90,-94,-120,-169,-231,-284,-305,-285,-236,-174,-113,-63,-31,-24,-40,-68,-96,-115,-123,-118,-99,-67,-28,9,41,64,70,53,14,-34,-74,-100,-112,-115,-115,-112,-101,-76,-41,-12,-1,-11,-33,-52,-57,-49,-42,-43,-47,-40,-21},
            {-7,-1,4,0,-2,5,9,0,-7,2,9,-4,-18,-5,15,3,-22,-8,26,12,-35,-19,47,28,23,593,2251,4535,5867,4729,1157,-3013,-5510,-5333,-3288,-1003,556,1737,3470,5921,7941,8004,5774,2667,754,1080,2950,4649,4743,2914,-17,-2683,-4006,-3847,-3005,-2523,-2879,-3727,-4335,-4243,-3567,-2800,-2354,-2236,-2121,-1725,-1107,-575,-319,-217,-29,313,691,1000,1251,1455,1544,1462,1281,1146,1113,1104,1006,779,479,227,141,228,334,252,-84,-541,-947,-1250,-1477,-1608,-1587,-1435,-1270,-1174,-1101,-956,-723,-480,-310,-240,-255,-313,-351,-313,-190,-23,150,317,472,594,663,678,635,520,333,122,-31,-79,-50,-22,-62,-176,-322,-456,-569,-675,-775,-845,-863,-820,-730,-617,-512,-442,-414,-404,-371,-288,-165,-38,47,63,22,-18,2,94,211,287,287,214,101,-9,-81,-110,-124,-155,-204,-246,-255,-228,-182,-150,-160,-209,-270,-314,-333,-340,-345,-339,-308,-247,-166,-80,-11,17,-2,-48,-91,-116,-126,-129,-123,-108,-86,-55,-9,46,85,79,24,-58,-136,-192,-216,-209,-177,-137,-105,-90,-94,-120,-169,-231,-284,-305,-285,-236,-174,-113,-63,-31,-24,-40,-68,-96,-115,-123,-118,-99,-67,-28,9,41,64,70,53,14,-34,-74,-100,-112,-115,-115,-112,-101,-76,-41,-12,-1,-11,-33,-52,-57,-49,-42,-43,-47,-40,-21}
        }
    },
    {    // elev40
        {    // H40e000a.wav
            {12,-4,-14,-1,6,-6,-5,18,17,-14,-14,26,23,-40,-49,32,54,-51,-95,41,125,-37,-166,35,222,-25,-53,1364,4000,5757,5083,2802,330,-2890,-8043,-13211,-13656,-7240,2190,8748,10884,11792,13919,15563,13651,8014,1529,-2869,-4025,-2294,840,3008,2386,-541,-3457,-4810,-5196,-5825,-6541,-6242,-4780,-3385,-3089,-3494,-3491,-2740,-1938,-1729,-1837,-1473,-362,923,1674,1833,1888,2165,2488,2573,2443,2323,2293,2221,1969,1510,953,524,404,432,128,-718,-1599,-1746,-1088,-437,-575,-1390,-2112,-2204,-1790,-1290,-948,-761,-642,-521,-356,-147,65,247,389,466,453,371,303,315,415,593,835,1085,1228,1179,963,692,458,272,93,-118,-363,-604,-803,-968,-1139,-1328,-1483,-1540,-1503,-1434,-1384,-1347,-1302,-1247,-1176,-1041,-785,-418,-41,224,326,303,238,210,258,354,414,372,251,143,111,129,127,73,-11,-93,-158,-198,-220,-251,-317,-396,-431,-389,-305,-235,-215,-250,-320,-388,-415,-394,-357,-334,-312,-262,-180,-86,9,94,142,132,85,51,53,63,56,40,37,46,54,55,49,19,-49,-142,-225,-269,-275,-262,-242,-222,-203,-186,-175,-172,-173,-170,-163,-160,-164,-161,-135,-93,-56,-39,-42,-53,-62,-63,-59,-59,-72,-90,-97,-86,-68,-59,-61,-66,-71,-76,-78,-75,-69,-65,-68,-81,-100,-120,-133,-135,-123,-100,-72,-51,-43,-40,-30,-12},
            {12,-4,-14,-1,6,-6,-5,18,17,-14,-14,26,23,-40,-49,32,54,-51,-95,41,125,-37,-166,35,222,-25,-53,1364,4000,5757,5083,2802,330,-2890,-8043,-13211,-13656,-7240,2190,8748,10884,11792,13919,15563,13651,8014,1529,-2869,-4025,-2294,840,3008,2386,-541,-3457,-4810,-5196,-5825,-6541,-6242,-4780,-3385,-3089,-3494,-3491,-2740,-1938,-1729,-1837,-1473,-362,923,1674,1833,1888,2165,2488,2573,2443,2323,2293,2221,1969,1510,953,524,404,432,128,-718,-1599,-1746,-1088,-437,-575,-1390,-2112,-2204,-1790,-1290,-948,-761,-642,-521,-356,-147,65,247,389,466,453,371,303,315,415,593,835,1085,1228,1179,963,692,458,272,93,-118,-363,-604,-803,-968,-1139,-1328,-1483,-1540,-1503,-1434,-1384,-1347,-1302,-1247,-1176,-1041,-785,-418,-41,224,326,303,238,210,258,354,414,372,251,143,111,129,127,73,-11,-93,-158,-198,-220,-251,-317,-396,-431,-389,-305,-235,-215,-250,-320,-388,-415,-394,-357,-334,-312,-262,-180,-86,9,94,142,132,85,51,53,63,56,40,37,46,54,55,49,19,-49,-142,-225,-269,-275,-262,-242,-222,-203,-186,-175,-172,-173,-170,-163,-160,-164,-161,-135,-93,-56,-39,-42,-53,-62,-63,-59,-59,-72,-90,-97,-86,-68,-59,-61,-66,-71,-76,-78,-75,-69,-65,-68,-81,-100,-120,-133,-135,-123,-100,-72,-51,-43,-40,-30,-12}
        },
        {    // H40e006a.wav
            {-6,2,9,0,-10,-2,5,-4,-6,12,17,-6,-14,17,26,-20,-44,10,44,-25,-80,8,100,6,-121,-10,162,23,-74,861,2946,4704,4641,3012,955,-1679,-5935,-10843,-12724,-8919,-1357,5233,8452,9998,12204,14493,14289,10442,4580,-526,-2964,-2404,-42,1961,1906,-20,-2109,-3134,-3527,-4300,-5413,-5866,-5172,-4018,-3329,-3194,-3046,-2590,-2158,-2112,-2224,-1885,-854,393,1168,1316,1282,1517,1993,2363,2421,2260,2091,2039,2060,1979,1654,1189,849,666,277,-573,-1501,-1776,-1232,-575,-594,-1275,-1923,-2011,-1642,-1215,-938,-763,-605,-439,-268,-107,11,77,137,235,335,358,287,220,292,568,975,1322,1410,1166,712,284,65,60,112,41,-212,-549,-826,-991,-1103,-1225,-1336,-1369,-1304,-1191,-1088,-1010,-948,-912,-921,-949,-913,-734,-411,-49,212,296,237,139,96,130,195,218,168,74,-3,-24,0,28,19,-39,-121,-183,-204,-210,-245,-317,-384,-403,-376,-323,-261,-206,-187,-224,-298,-361,-381,-361,-315,-250,-178,-116,-62,-4,60,109,126,117,98,72,43,25,29,43,46,35,19,-4,-42,-96,-150,-191,-221,-239,-236,-211,-183,-171,-178,-190,-193,-184,-170,-157,-150,-145,-135,-119,-101,-89,-84,-80,-73,-64,-54,-41,-30,-27,-33,-45,-64,-86,-102,-101,-86,-72,-69,-71,-66,-54,-45,-49,-69,-101,-133,-151,-149,-136,-123,-108,-79,-37},
            {-13,-10,4,-1,-11,7,25,-1,-27,7,42,-10,-73,-17,75,17,-112,-53,130,83,-161,-134,190,179,-178,429,2895,5767,6495,4569,1697,-1429,-6255,-12707,-16399,-12512,-2201,7693,12142,12842,14262,16921,17040,12078,4112,-2581,-5401,-4376,-1082,2135,2977,847,-2478,-4715,-5485,-6057,-7012,-7311,-6000,-3863,-2620,-2886,-3633,-3628,-2803,-1979,-1639,-1398,-686,432,1365,1791,2003,2373,2787,2877,2610,2349,2335,2411,2294,1885,1269,634,230,172,176,-240,-1099,-1765,-1662,-1043,-722,-1109,-1807,-2184,-2046,-1634,-1217,-892,-666,-515,-387,-242,-80,101,320,529,593,455,268,248,410,572,614,645,842,1199,1489,1465,1080,519,46,-206,-299,-383,-541,-761,-1011,-1278,-1527,-1687,-1725,-1704,-1710,-1744,-1720,-1569,-1309,-1013,-733,-482,-251,-23,207,407,522,528,477,448,457,450,389,306,257,240,205,129,34,-55,-136,-212,-277,-332,-389,-435,-432,-374,-309,-285,-297,-310,-322,-354,-401,-432,-431,-406,-361,-285,-183,-81,9,97,172,197,163,112,86,77,52,18,8,31,60,73,69,43,-23,-130,-243,-320,-348,-339,-311,-274,-233,-199,-177,-170,-178,-189,-188,-172,-154,-139,-119,-86,-52,-33,-30,-32,-34,-36,-40,-48,-62,-80,-91,-87,-78,-82,-98,-109,-103,-89,-78,-76,-82,-93,-104,-115,-123,-125,-120,-109,-93,-76,-62,-49,-36,-23,-13,-8,-5,-3}
        },
        {    // H40e013a.wav
            {5,-1,-2,6,7,-3,-8,-1,1,-5,0,13,8,-10,-4,21,12,-28,-26,24,24,-43,-51,41,73,-36,-89,47,117,-47,93,1258,3106,4237,3794,2333,516,-2219,-6406,-10317,-10668,-6276,144,4857,7069,8843,11495,13549,12668,8578,3366,-491,-1785,-855,891,1795,1068,-627,-2001,-2600,-3102,-4116,-5213,-5470,-4679,-3569,-2911,-2762,-2697,-2488,-2286,-2208,-2029,-1427,-457,423,843,926,1079,1481,1932,2163,2144,2035,1975,1985,1991,1875,1595,1255,964,606,-59,-957,-1555,-1415,-796,-440,-749,-1381,-1741,-1638,-1312,-1013,-775,-561,-388,-284,-219,-162,-121,-84,0,136,236,216,122,108,298,666,1055,1277,1216,896,461,87,-115,-143,-88,-74,-184,-414,-694,-944,-1119,-1202,-1191,-1104,-1000,-937,-918,-892,-830,-765,-749,-773,-761,-645,-433,-188,24,160,196,140,50,-7,-13,-7,-22,-45,-47,-35,-36,-58,-81,-95,-109,-132,-167,-214,-269,-310,-315,-288,-261,-255,-257,-249,-232,-225,-239,-273,-318,-349,-337,-271,-176,-85,-11,48,89,104,99,88,71,45,18,8,18,32,38,35,19,-15,-64,-113,-152,-180,-197,-199,-186,-174,-174,-183,-190,-195,-202,-206,-199,-183,-167,-152,-132,-109,-95,-95,-99,-92,-67,-35,-11,-2,-3,-9,-22,-48,-81,-108,-119,-116,-101,-73,-46,-38,-48,-56,-51,-51,-73,-100,-109,-113,-135,-161,-143,-72},
            {-4,3,-9,-3,24,20,-21,-18,37,31,-55,-69,40,74,-59,-119,55,165,-45,-221,28,280,-26,-116,1562,4822,7123,6475,3701,373,-4163,-11040,-17434,-17283,-8246,4262,12462,14511,14888,17075,18929,16268,8680,3,-5641,-6656,-3846,425,3067,2136,-1366,-4520,-5713,-6010,-6934,-8013,-7558,-5284,-2926,-2163,-2816,-3477,-3323,-2714,-2230,-1785,-919,348,1399,1790,1817,2093,2714,3176,3097,2689,2406,2372,2357,2131,1643,990,398,107,69,-123,-748,-1480,-1716,-1375,-1041,-1226,-1773,-2151,-2106,-1795,-1441,-1123,-853,-627,-406,-165,31,126,215,420,650,672,447,221,196,263,234,203,482,1146,1817,2001,1567,827,202,-132,-264,-346,-446,-573,-751,-1006,-1310,-1589,-1805,-1991,-2169,-2272,-2172,-1813,-1302,-847,-605,-556,-539,-381,-38,378,697,819,778,687,619,560,462,338,257,252,271,242,148,28,-89,-204,-310,-391,-442,-470,-471,-435,-375,-325,-297,-276,-269,-305,-394,-487,-529,-507,-438,-328,-189,-58,31,92,157,220,241,214,174,144,106,46,-7,-16,18,61,84,75,24,-77,-210,-335,-416,-441,-418,-367,-304,-243,-194,-170,-178,-205,-217,-194,-153,-123,-109,-93,-65,-37,-20,-10,-1,3,0,-6,-16,-32,-58,-85,-103,-113,-122,-128,-123,-108,-96,-98,-113,-130,-137,-132,-119,-105,-92,-82,-78,-76,-71,-57,-36,-15,0,10,13,9,2,-2}
        },
        {    // H40e019a.wav
            {-8,0,5,0,-3,3,6,-1,-6,-1,1,-2,1,9,4,-10,-4,15,8,-23,-22,15,18,-32,-39,31,55,-29,-69,34,87,-38,84,1026,2539,3545,3350,2309,844,-1522,-5149,-8574,-9153,-5925,-967,2905,5155,7315,10130,12155,11512,8177,3978,837,-447,-154,819,1389,929,-251,-1321,-1948,-2581,-3621,-4665,-4920,-4199,-3168,-2584,-2559,-2664,-2562,-2303,-2059,-1796,-1338,-676,-40,367,609,892,1283,1654,1873,1944,1946,1933,1921,1898,1806,1588,1274,920,482,-128,-792,-1146,-965,-517,-331,-622,-1093,-1340,-1267,-1052,-851,-695,-586,-536,-507,-432,-316,-235,-216,-189,-101,0,34,15,65,281,631,958,1090,960,651,322,85,-43,-91,-80,-50,-85,-260,-555,-850,-1030,-1064,-999,-902,-822,-787,-792,-800,-771,-714,-665,-641,-621,-571,-480,-356,-210,-64,46,85,52,-18,-93,-163,-217,-228,-178,-91,-25,-24,-85,-159,-196,-184,-157,-160,-200,-240,-244,-215,-190,-192,-214,-237,-255,-265,-263,-252,-245,-250,-248,-216,-155,-84,-24,20,50,67,73,71,62,43,18,-3,-12,-11,-6,-2,-3,-17,-45,-78,-111,-142,-168,-183,-185,-185,-196,-214,-221,-214,-204,-200,-196,-187,-175,-162,-140,-107,-77,-67,-71,-67,-44,-16,-1,-1,-8,-20,-39,-59,-80,-104,-125,-131,-115,-88,-62,-39,-21,-17,-34,-59,-77,-95,-125,-151,-134,-69},
            {-7,-12,18,29,-11,-28,22,44,-33,-82,7,83,-22,-132,0,176,36,-217,-72,270,94,-255,846,3981,7112,7683,5569,2198,-2622,-10165,-18288,-20574,-12805,1019,12104,16177,16662,18226,20196,18350,11265,2256,-4383,-6797,-5416,-1776,1663,2327,-309,-4000,-6202,-6781,-7330,-8339,-8432,-6571,-3823,-2188,-2275,-2940,-3005,-2548,-2273,-2217,-1678,-305,1282,2211,2371,2363,2601,2894,2946,2837,2793,2774,2576,2164,1650,1072,481,95,38,0,-455,-1223,-1688,-1558,-1282,-1428,-1928,-2257,-2159,-1843,-1555,-1307,-1044,-796,-556,-244,120,381,481,567,733,828,654,274,-56,-194,-181,-22,392,1065,1727,2002,1742,1117,436,-74,-346,-424,-408,-407,-504,-728,-1062,-1465,-1896,-2300,-2580,-2611,-2310,-1742,-1133,-736,-649,-740,-768,-567,-141,372,801,1030,1045,926,772,626,484,353,278,278,301,277,187,64,-66,-201,-324,-407,-454,-494,-531,-524,-453,-349,-263,-220,-226,-289,-400,-508,-561,-549,-488,-383,-240,-90,28,118,206,281,305,272,224,192,159,106,53,30,36,50,62,66,35,-57,-193,-326,-421,-471,-481,-453,-396,-330,-276,-242,-227,-224,-218,-198,-171,-155,-146,-124,-78,-23,20,41,47,46,43,41,33,8,-32,-70,-93,-105,-115,-124,-129,-136,-151,-170,-177,-161,-130,-98,-75,-63,-66,-80,-95,-98,-85,-62,-39,-18,2,16,18,10,6,11,17,13}
        },
        {    // H40e026a.wav
            {-1,-6,-5,1,2,-2,-2,4,5,-2,-5,-1,1,-1,3,7,0,-8,2,14,0,-22,-10,19,6,-33,-19,38,34,-39,-43,48,50,-48,189,1134,2403,3114,2882,2037,698,-1649,-4997,-7749,-7811,-4894,-915,2213,4491,6979,9654,11052,10016,7046,3709,1283,206,295,932,1270,806,-191,-1085,-1700,-2413,-3407,-4212,-4232,-3511,-2722,-2419,-2531,-2620,-2442,-2121,-1851,-1621,-1278,-778,-250,174,509,852,1232,1575,1795,1862,1804,1692,1620,1627,1644,1560,1330,960,450,-153,-643,-762,-497,-186,-194,-543,-940,-1133,-1119,-1023,-925,-842,-775,-703,-589,-451,-382,-424,-469,-374,-152,25,33,-43,-2,266,662,960,989,751,410,161,89,133,174,137,12,-175,-395,-614,-796,-906,-931,-885,-810,-752,-730,-731,-724,-706,-692,-683,-652,-576,-472,-379,-313,-250,-170,-89,-39,-31,-58,-116,-203,-286,-304,-232,-115,-35,-39,-109,-189,-230,-212,-159,-119,-127,-170,-206,-207,-186,-176,-193,-227,-255,-261,-246,-222,-197,-169,-141,-125,-124,-117,-80,-12,52,80,79,68,51,20,-19,-44,-46,-33,-15,2,11,0,-34,-82,-132,-171,-187,-185,-179,-182,-196,-213,-223,-224,-213,-191,-168,-156,-151,-134,-99,-65,-52,-54,-54,-45,-35,-30,-27,-23,-20,-22,-31,-51,-79,-105,-120,-121,-111,-89,-61,-43,-40,-36,-27,-37,-86,-141,-140,-73},
            {-4,29,17,-27,-12,44,19,-72,-57,62,59,-95,-107,104,161,-104,-220,115,295,-141,-117,1933,5502,7976,7669,5263,1324,-5466,-15061,-22300,-20178,-7972,6623,15375,17652,18585,20779,21184,16266,7237,-1263,-5837,-6139,-3557,-132,1741,606,-2576,-5362,-6607,-7357,-8649,-9591,-8555,-5665,-2956,-2050,-2540,-2946,-2609,-2068,-1876,-1748,-1080,132,1311,2089,2631,3124,3347,3066,2563,2390,2652,2903,2738,2183,1459,707,99,-150,-102,-183,-656,-1221,-1441,-1409,-1588,-2074,-2415,-2272,-1861,-1590,-1512,-1394,-1120,-768,-404,-32,287,489,662,932,1163,1008,366,-347,-584,-243,282,598,729,950,1347,1653,1539,967,216,-374,-636,-593,-385,-217,-296,-716,-1369,-2014,-2454,-2615,-2500,-2140,-1624,-1132,-848,-827,-947,-995,-809,-359,245,810,1153,1196,1014,772,591,488,418,361,338,352,355,293,158,-18,-198,-350,-449,-492,-508,-520,-513,-461,-376,-303,-265,-255,-275,-342,-440,-521,-545,-509,-429,-314,-180,-54,51,153,259,334,340,293,241,199,146,80,32,35,74,109,111,69,-19,-146,-284,-396,-461,-482,-473,-449,-411,-361,-309,-276,-271,-280,-277,-253,-221,-189,-150,-99,-43,8,49,75,85,80,68,54,32,-5,-44,-69,-77,-83,-101,-131,-162,-183,-191,-186,-169,-139,-100,-67,-58,-71,-91,-102,-100,-92,-78,-59,-41,-30,-19,-3,10,8,1,6,23,30,17}
        },
        {    // H40e032a.wav
            {-3,0,0,-4,-5,-1,1,-1,-1,3,3,-2,-3,1,1,-3,-1,4,2,-5,-2,8,3,-13,-8,13,8,-22,-19,24,28,-26,-39,27,42,-31,112,804,1846,2583,2625,2119,1127,-758,-3628,-6327,-7080,-5279,-2115,851,3272,5721,8195,9673,9237,7115,4409,2153,861,580,936,1235,942,145,-657,-1242,-1861,-2703,-3453,-3608,-3129,-2530,-2304,-2432,-2529,-2345,-1993,-1718,-1577,-1409,-1059,-546,-9,448,804,1063,1226,1312,1367,1427,1503,1607,1733,1820,1771,1531,1123,620,127,-218,-307,-191,-95,-228,-577,-941,-1147,-1178,-1116,-1037,-984,-959,-918,-808,-648,-527,-485,-446,-322,-160,-93,-155,-197,-43,320,715,927,867,617,355,232,269,359,366,231,-4,-252,-457,-608,-718,-796,-840,-842,-807,-759,-722,-709,-716,-731,-730,-683,-583,-459,-363,-322,-317,-313,-289,-241,-175,-109,-80,-112,-184,-240,-241,-200,-159,-141,-142,-153,-166,-172,-159,-134,-123,-144,-184,-217,-230,-228,-218,-197,-174,-162,-168,-184,-197,-197,-181,-149,-106,-65,-37,-22,-10,6,20,22,11,-3,-12,-17,-23,-31,-35,-30,-23,-25,-44,-75,-108,-139,-163,-175,-173,-168,-171,-187,-207,-218,-215,-201,-179,-149,-118,-96,-83,-71,-59,-55,-62,-70,-66,-52,-41,-36,-30,-22,-20,-32,-52,-73,-95,-115,-122,-111,-95,-90,-88,-73,-55,-58,-79,-81,-46},
            {35,-14,-32,27,48,-39,-87,17,93,-32,-146,9,193,25,-244,-63,316,100,-352,662,3818,7228,8503,7356,4442,-1330,-11169,-21541,-24445,-15393,428,12986,17842,18925,20960,22730,19808,11480,2007,-4172,-5960,-4540,-1465,1326,1638,-1086,-4792,-7034,-7714,-8486,-9813,-10104,-8087,-4847,-2638,-2285,-2675,-2587,-2078,-1793,-1683,-1095,103,1234,1781,2082,2695,3458,3695,3229,2638,2456,2561,2550,2304,1902,1310,537,-113,-357,-378,-585,-972,-1169,-1141,-1361,-2066,-2753,-2765,-2136,-1513,-1335,-1440,-1438,-1161,-675,-121,338,600,751,962,1172,1045,432,-266,-449,-6,549,707,547,545,926,1385,1459,1011,288,-376,-771,-821,-569,-238,-171,-587,-1367,-2129,-2526,-2454,-2049,-1557,-1203,-1079,-1105,-1116,-1019,-838,-612,-310,104,566,923,1069,1018,866,693,525,374,277,275,357,442,431,285,53,-178,-344,-435,-487,-542,-597,-603,-522,-389,-280,-231,-222,-239,-306,-419,-515,-526,-461,-376,-299,-211,-105,3,111,228,332,373,333,259,199,151,93,41,29,63,109,132,120,62,-49,-196,-337,-437,-487,-494,-470,-424,-370,-323,-297,-302,-331,-357,-351,-310,-254,-194,-126,-49,21,63,74,71,73,82,86,71,31,-19,-56,-73,-85,-105,-130,-144,-142,-130,-116,-105,-101,-105,-111,-112,-106,-98,-93,-90,-86,-80,-74,-67,-59,-47,-30,-11,4,10,13,23,41,54,48,25}
        },
        {    // H40e039a.wav
            {4,0,-2,0,0,-3,-3,1,2,0,1,4,3,-1,-1,2,1,-2,1,5,3,-3,0,8,4,-8,-3,12,5,-16,-10,19,15,-24,-20,31,25,-26,157,806,1697,2302,2356,1964,1066,-731,-3392,-5792,-6417,-4840,-2082,626,3012,5408,7630,8805,8305,6444,4148,2234,1117,836,1062,1210,878,182,-489,-1010,-1600,-2358,-2973,-3064,-2682,-2284,-2213,-2362,-2384,-2131,-1784,-1577,-1503,-1355,-997,-516,-93,202,441,705,990,1245,1435,1557,1637,1725,1849,1951,1902,1609,1108,544,84,-171,-227,-202,-258,-468,-755,-980,-1092,-1157,-1242,-1318,-1297,-1128,-856,-599,-465,-470,-517,-481,-336,-182,-133,-174,-155,63,458,839,991,849,547,302,235,302,369,337,186,-52,-318,-540,-673,-736,-781,-833,-863,-842,-787,-735,-701,-674,-646,-619,-583,-513,-417,-342,-322,-337,-338,-301,-238,-170,-112,-83,-99,-150,-192,-188,-150,-128,-148,-186,-201,-181,-151,-141,-161,-198,-232,-248,-244,-229,-211,-190,-169,-152,-145,-144,-143,-143,-142,-131,-101,-57,-20,-7,-14,-26,-32,-28,-17,-5,1,-3,-16,-32,-48,-62,-71,-73,-70,-71,-82,-106,-135,-154,-155,-148,-151,-167,-184,-190,-190,-188,-177,-147,-106,-77,-66,-63,-59,-57,-63,-69,-68,-62,-55,-48,-38,-31,-32,-37,-42,-54,-76,-101,-117,-120,-117,-110,-99,-91,-94,-97,-79,-39},
            {-16,-6,42,21,-70,-71,51,76,-77,-133,68,185,-55,-249,37,329,-43,-339,1142,4564,7776,8791,7584,4213,-2976,-14266,-24239,-24464,-12506,4080,15268,18659,19494,21704,22771,18434,9319,434,-4373,-5046,-3293,-600,1440,1115,-1733,-5153,-7271,-8331,-9564,-10738,-10266,-7688,-4727,-3277,-3242,-3139,-2303,-1506,-1443,-1569,-933,444,1688,2325,2724,3244,3585,3360,2844,2652,2862,2960,2599,1977,1397,884,394,39,-157,-424,-873,-1211,-1175,-1078,-1484,-2357,-2966,-2766,-2042,-1489,-1401,-1504,-1424,-1062,-535,10,472,805,1003,1039,853,486,170,143,373,558,483,287,303,671,1178,1439,1221,585,-189,-786,-1020,-900,-612,-439,-613,-1153,-1812,-2225,-2173,-1744,-1263,-1032,-1112,-1300,-1324,-1071,-660,-291,-60,88,239,411,571,694,781,815,755,589,378,231,214,292,355,316,178,15,-113,-207,-315,-468,-635,-737,-710,-563,-376,-233,-161,-157,-215,-321,-424,-466,-438,-387,-342,-286,-194,-67,74,215,333,383,341,247,168,127,96,58,32,41,74,103,114,99,44,-61,-199,-329,-416,-454,-457,-438,-401,-350,-308,-303,-337,-378,-388,-359,-310,-253,-186,-109,-37,13,41,56,64,69,77,82,65,16,-45,-88,-107,-115,-122,-122,-105,-77,-53,-46,-57,-81,-108,-126,-130,-122,-105,-87,-79,-86,-100,-107,-100,-81,-56,-28,-2,18,28,31,32,37,46,51,43,21}
        },
        {    // H40e045a.wav
            {0,2,1,-1,-1,0,-1,-4,-3,0,0,-1,0,2,1,-2,-1,1,-1,-3,0,3,-1,-5,1,8,2,-8,-2,9,-1,-18,-9,16,10,-19,-11,25,8,-21,188,792,1554,2050,2120,1841,1055,-647,-3163,-5382,-5946,-4532,-2051,468,2794,5109,7127,8079,7529,5860,3891,2277,1320,1032,1139,1176,836,230,-336,-794,-1333,-2006,-2529,-2605,-2328,-2089,-2115,-2240,-2160,-1836,-1527,-1463,-1571,-1571,-1283,-776,-235,222,587,883,1125,1329,1510,1661,1775,1873,1959,1953,1730,1266,703,238,-40,-175,-244,-294,-371,-538,-820,-1148,-1395,-1474,-1393,-1224,-1035,-853,-689,-568,-515,-504,-460,-349,-231,-200,-251,-241,-20,396,811,998,879,575,294,182,233,329,348,245,48,-185,-406,-582,-708,-803,-883,-930,-910,-816,-693,-602,-572,-588,-615,-616,-570,-485,-396,-338,-313,-294,-265,-232,-203,-169,-121,-76,-66,-93,-124,-130,-120,-128,-171,-229,-265,-261,-233,-214,-225,-253,-273,-270,-251,-230,-209,-187,-166,-149,-130,-101,-70,-54,-60,-75,-83,-77,-61,-41,-22,-13,-19,-31,-35,-30,-27,-38,-58,-78,-92,-102,-106,-100,-86,-78,-86,-107,-128,-140,-145,-149,-155,-159,-159,-162,-163,-153,-130,-106,-91,-84,-77,-68,-61,-61,-63,-65,-66,-70,-75,-76,-69,-57,-49,-50,-57,-67,-79,-98,-120,-131,-129,-127,-135,-138,-110,-52},
            {1,48,-2,-85,-37,79,36,-122,-85,137,135,-154,-201,174,275,-240,-178,1924,5533,8428,9193,7736,3130,-6338,-18835,-26717,-22414,-7132,9166,17820,19359,19807,21540,21089,15361,6506,-669,-3782,-3684,-1883,529,1979,823,-2698,-6305,-8249,-9044,-9940,-10643,-9798,-7332,-4957,-4062,-4104,-3692,-2566,-1635,-1382,-1181,-359,854,1860,2623,3459,4182,4193,3436,2668,2538,2844,2959,2644,2066,1349,545,-88,-283,-225,-391,-860,-1205,-1215,-1316,-1936,-2768,-3064,-2587,-1876,-1534,-1585,-1626,-1371,-852,-238,318,694,808,699,544,541,731,945,936,623,206,1,170,605,1053,1282,1167,717,82,-520,-945,-1170,-1243,-1223,-1205,-1292,-1478,-1615,-1558,-1347,-1162,-1116,-1163,-1184,-1108,-918,-617,-246,104,334,406,358,268,224,286,447,620,693,616,435,246,124,86,102,128,131,93,4,-135,-307,-483,-628,-706,-691,-580,-409,-247,-155,-149,-200,-269,-329,-371,-391,-380,-325,-227,-99,39,175,293,365,361,284,174,78,17,-14,-23,-11,21,66,102,105,64,-17,-124,-238,-333,-390,-406,-397,-376,-347,-312,-292,-308,-350,-379,-367,-324,-274,-228,-180,-124,-63,-7,34,54,56,52,47,28,-15,-69,-109,-126,-127,-115,-92,-64,-47,-45,-50,-57,-71,-92,-106,-102,-87,-76,-77,-88,-106,-126,-139,-137,-120,-94,-62,-27,10,37,48,45,37,32,33,36,33,20,6}
        },
        {    // H40e051a.wav
            {2,1,1,3,2,-1,-2,0,1,-2,-3,-1,1,1,1,3,2,0,-1,0,-2,-4,-1,2,-2,-6,0,9,6,-5,-5,4,0,-14,-10,12,12,-14,-16,13,10,-15,121,574,1208,1700,1899,1847,1379,46,-2224,-4550,-5599,-4786,-2712,-339,1942,4195,6197,7296,7061,5764,4103,2652,1677,1229,1166,1159,918,453,-16,-400,-838,-1416,-1944,-2146,-2012,-1823,-1827,-1987,-2092,-2029,-1875,-1744,-1622,-1404,-1031,-556,-80,330,664,941,1185,1403,1561,1616,1585,1551,1559,1526,1311,901,456,157,28,-57,-217,-463,-723,-919,-1020,-1053,-1082,-1146,-1206,-1180,-1026,-789,-554,-392,-335,-370,-434,-443,-354,-202,-49,96,271,485,666,713,597,393,217,143,163,209,207,118,-48,-257,-470,-657,-794,-869,-880,-836,-755,-660,-580,-541,-556,-603,-634,-604,-509,-392,-302,-258,-246,-240,-225,-197,-160,-121,-84,-52,-33,-38,-70,-115,-159,-198,-241,-292,-338,-355,-336,-299,-270,-262,-267,-271,-268,-257,-236,-195,-136,-75,-32,-14,-15,-29,-53,-78,-88,-76,-52,-29,-14,-11,-23,-46,-65,-73,-76,-86,-103,-116,-119,-116,-112,-108,-106,-106,-107,-107,-107,-109,-113,-116,-119,-124,-128,-127,-122,-120,-120,-114,-101,-86,-74,-64,-56,-57,-67,-81,-91,-98,-100,-91,-74,-62,-62,-65,-65,-71,-93,-117,-127,-134,-154,-171,-144,-70},
            {45,-18,-87,-22,87,27,-127,-75,144,127,-161,-191,185,269,-257,-214,1827,5408,8474,9616,8405,3506,-6731,-19843,-27577,-22420,-6248,10375,18723,19625,19350,20409,19575,14098,6172,99,-2446,-2566,-1332,811,2479,1624,-2028,-6285,-8975,-10055,-10539,-10430,-9017,-6720,-5138,-5001,-5189,-4388,-2891,-1958,-1874,-1655,-593,848,1970,2848,3826,4576,4454,3611,2976,3050,3328,3134,2496,1838,1278,691,170,-93,-257,-642,-1135,-1292,-1116,-1231,-2006,-2925,-3181,-2677,-2042,-1773,-1753,-1618,-1241,-722,-172,290,504,436,331,507,972,1374,1359,931,415,127,151,387,706,989,1095,917,492,-18,-497,-967,-1445,-1803,-1875,-1676,-1407,-1226,-1128,-1068,-1069,-1142,-1199,-1133,-951,-747,-562,-349,-78,200,403,484,435,290,144,109,220,392,504,490,371,212,82,30,56,106,113,53,-48,-157,-261,-371,-484,-575,-608,-560,-443,-298,-173,-108,-124,-211,-316,-380,-377,-321,-240,-142,-30,87,194,283,339,336,260,136,21,-46,-68,-70,-59,-27,24,73,92,66,-6,-113,-236,-342,-398,-397,-363,-321,-282,-250,-239,-259,-298,-324,-319,-292,-263,-236,-200,-143,-70,3,50,58,38,15,-3,-29,-75,-123,-145,-137,-114,-88,-61,-40,-37,-52,-72,-85,-92,-96,-91,-73,-53,-47,-58,-78,-99,-115,-124,-126,-119,-100,-67,-27,8,34,51,57,51,41,39,40,30,5,-16,-14}
        },
        {    // H40e058a.wav
            {1,2,1,0,1,2,1,0,0,0,-2,-2,0,1,0,-1,0,2,1,-2,-2,-1,-2,-3,0,2,-2,-3,6,14,6,-7,-4,5,-1,-14,-6,14,8,-17,-12,16,8,-1,167,608,1155,1557,1757,1772,1318,-80,-2360,-4526,-5338,-4414,-2410,-153,2074,4259,6056,6853,6406,5126,3678,2495,1710,1314,1196,1121,889,510,130,-204,-590,-1073,-1519,-1772,-1859,-1942,-2089,-2180,-2064,-1758,-1433,-1232,-1131,-998,-731,-340,91,475,764,951,1063,1130,1169,1188,1204,1227,1219,1114,894,622,363,107,-179,-453,-607,-601,-532,-542,-681,-897,-1104,-1215,-1163,-939,-640,-418,-357,-405,-449,-424,-342,-239,-143,-64,11,124,294,467,539,461,294,154,101,111,123,97,19,-112,-274,-428,-543,-621,-683,-735,-757,-732,-671,-607,-564,-549,-549,-543,-510,-443,-361,-292,-252,-232,-214,-188,-158,-132,-107,-81,-56,-45,-55,-86,-130,-178,-227,-277,-326,-365,-381,-368,-333,-299,-287,-299,-316,-311,-272,-207,-136,-80,-48,-37,-36,-37,-36,-33,-31,-30,-32,-36,-41,-42,-38,-42,-58,-81,-97,-102,-103,-111,-128,-145,-152,-149,-141,-130,-112,-89,-72,-65,-66,-70,-81,-98,-113,-115,-109,-106,-109,-110,-104,-97,-94,-91,-84,-77,-73,-70,-68,-73,-86,-100,-105,-105,-103,-97,-85,-79,-85,-95,-99,-112,-149,-181,-159,-79},
            {12,-78,-49,69,49,-108,-101,115,153,-120,-220,124,302,-175,-359,1288,4730,8145,9918,9300,4835,-5286,-18966,-28004,-24075,-7954,9841,19305,20076,18699,18964,18372,13755,6602,1006,-1309,-1563,-822,963,2928,2779,-591,-5395,-8957,-10521,-10989,-10737,-9269,-6892,-5154,-4971,-5365,-4888,-3601,-2694,-2553,-2287,-1212,236,1441,2571,3932,4976,4860,3808,3050,3272,3841,3808,3070,2143,1321,600,123,45,67,-317,-1053,-1530,-1490,-1443,-1915,-2659,-3016,-2804,-2435,-2236,-2072,-1695,-1129,-586,-197,4,23,-2,212,808,1499,1756,1361,669,243,295,576,757,775,759,754,662,415,51,-418,-1041,-1751,-2254,-2267,-1843,-1321,-990,-881,-898,-977,-1063,-1066,-939,-744,-562,-384,-166,60,225,324,403,448,395,256,137,117,163,192,181,155,133,117,117,126,106,30,-75,-152,-184,-206,-259,-343,-432,-495,-502,-432,-297,-151,-65,-81,-181,-301,-375,-376,-314,-214,-98,15,116,206,288,338,317,212,69,-44,-97,-112,-116,-108,-76,-22,32,64,58,5,-98,-231,-346,-404,-400,-360,-303,-237,-178,-155,-181,-231,-264,-266,-257,-253,-243,-209,-151,-78,-3,52,62,26,-24,-59,-84,-117,-154,-169,-151,-117,-85,-59,-43,-48,-72,-97,-108,-108,-100,-88,-72,-61,-61,-67,-71,-74,-79,-82,-80,-79,-78,-67,-38,-4,19,33,45,53,51,43,38,26,-5,-43,-55,-31}
        },
        {    // H40e064a.wav
            {1,0,1,2,1,0,1,2,1,0,0,1,-1,-3,-2,0,0,0,2,3,1,-1,-1,-1,-3,-3,1,2,-2,-1,9,13,2,-8,-3,7,-1,-14,-4,16,8,-18,-10,22,16,2,145,532,1012,1374,1604,1724,1415,154,-2045,-4223,-5142,-4367,-2489,-308,1856,3950,5635,6349,5904,4736,3487,2515,1861,1475,1297,1198,1029,754,433,66,-429,-1043,-1571,-1791,-1708,-1547,-1497,-1523,-1470,-1280,-1053,-905,-841,-780,-659,-466,-205,99,380,564,645,691,755,827,876,900,887,770,506,179,-36,-62,-4,-21,-148,-292,-386,-467,-601,-776,-904,-920,-833,-699,-560,-429,-321,-265,-281,-340,-377,-341,-230,-79,75,202,268,254,183,113,82,81,69,21,-61,-154,-228,-262,-263,-271,-334,-459,-600,-697,-722,-686,-615,-532,-459,-415,-404,-408,-396,-351,-291,-246,-226,-208,-169,-117,-83,-88,-117,-140,-139,-122,-114,-134,-185,-251,-308,-336,-335,-326,-334,-360,-385,-389,-364,-318,-263,-206,-156,-123,-107,-96,-75,-45,-19,-3,7,13,13,2,-15,-34,-50,-63,-74,-84,-95,-105,-111,-118,-135,-160,-181,-184,-168,-140,-108,-78,-58,-51,-51,-50,-50,-57,-72,-85,-88,-84,-81,-84,-92,-103,-112,-112,-103,-89,-72,-55,-45,-51,-72,-94,-109,-121,-132,-131,-115,-101,-103,-106,-96,-90,-114,-148,-138,-71},
            {-58,-43,56,56,-86,-115,76,164,-69,-235,44,312,-58,-446,703,3846,7549,10026,10144,6310,-3408,-17432,-27921,-25785,-10266,8664,19680,20675,18091,17250,16864,13407,7242,1954,-484,-990,-511,1247,3665,4194,1052,-4260,-8568,-10467,-10842,-10562,-9408,-7469,-5955,-5676,-5745,-4863,-3337,-2620,-3075,-3393,-2465,-739,802,2082,3513,4720,4825,3912,3216,3555,4311,4395,3623,2618,1805,1140,614,346,164,-313,-1040,-1492,-1445,-1393,-1861,-2637,-3076,-2970,-2696,-2550,-2366,-1892,-1231,-720,-512,-476,-400,-139,368,1040,1593,1687,1254,637,317,463,814,999,918,737,600,469,251,-76,-526,-1145,-1852,-2335,-2301,-1830,-1312,-1024,-914,-826,-761,-788,-847,-793,-602,-378,-195,-42,83,156,204,299,427,469,358,181,63,15,-33,-104,-137,-84,32,148,207,166,26,-145,-255,-260,-210,-183,-217,-296,-376,-407,-360,-239,-100,-17,-32,-130,-251,-334,-353,-318,-246,-147,-20,119,239,314,331,285,177,32,-99,-178,-204,-205,-192,-147,-66,21,68,53,-18,-127,-254,-362,-410,-389,-330,-264,-197,-131,-92,-106,-161,-210,-224,-217,-213,-210,-189,-144,-84,-24,19,25,-7,-54,-89,-114,-145,-176,-185,-167,-140,-121,-105,-88,-80,-88,-104,-116,-124,-130,-128,-113,-94,-84,-79,-71,-63,-55,-45,-31,-20,-23,-32,-31,-16,1,11,21,31,33,24,12,0,-22,-57,-83,-74,-36}
        },
        {    // H40e071a.wav
            {0,0,0,0,1,2,1,0,1,1,0,-1,0,0,-1,-2,-1,0,-1,0,2,3,0,-2,-1,-1,-2,-1,1,0,-2,3,12,9,-4,-8,3,7,-6,-12,4,14,-3,-15,9,26,-1,25,257,678,1092,1384,1610,1669,1077,-580,-2900,-4684,-4908,-3585,-1512,634,2673,4495,5695,5867,5104,3956,2941,2236,1800,1561,1424,1231,876,427,42,-226,-461,-726,-962,-1076,-1084,-1089,-1144,-1188,-1144,-1032,-948,-950,-1004,-1025,-945,-737,-418,-68,203,335,380,438,538,611,577,447,316,275,342,450,487,379,151,-76,-188,-176,-143,-215,-437,-729,-928,-905,-675,-403,-266,-309,-433,-513,-502,-430,-337,-242,-143,-33,78,147,128,34,-60,-85,-50,-24,-52,-116,-170,-195,-199,-193,-194,-234,-338,-485,-608,-650,-608,-525,-445,-389,-363,-359,-359,-345,-314,-279,-252,-227,-191,-145,-112,-115,-147,-182,-196,-190,-178,-172,-178,-201,-241,-285,-312,-319,-325,-351,-388,-405,-382,-331,-280,-242,-212,-183,-156,-130,-98,-57,-18,5,12,14,18,17,5,-15,-35,-54,-76,-101,-119,-127,-130,-138,-151,-161,-165,-165,-163,-153,-130,-99,-74,-64,-62,-55,-44,-41,-50,-60,-64,-64,-68,-76,-88,-101,-109,-108,-97,-84,-75,-70,-67,-69,-75,-83,-94,-113,-136,-149,-147,-141,-140,-135,-117,-98,-97,-106,-93,-48},
            {-75,19,87,-20,-137,-21,165,61,-206,-126,244,185,-366,-122,2122,5829,9228,10767,8892,1454,-11734,-24987,-28516,-17358,2089,17238,21388,18542,16073,15773,14216,9538,4129,783,-500,-743,399,3167,5322,3776,-1490,-7071,-9996,-10414,-9985,-9293,-8067,-6796,-6391,-6514,-5806,-4011,-2603,-2705,-3463,-3291,-1957,-413,934,2497,4130,4765,3970,2928,3063,4215,4975,4524,3363,2306,1597,1154,971,877,408,-590,-1550,-1819,-1534,-1436,-1909,-2618,-3092,-3235,-3138,-2762,-2080,-1348,-933,-911,-993,-844,-366,312,978,1423,1497,1200,737,435,504,845,1123,1093,827,566,419,271,-22,-485,-1065,-1672,-2120,-2181,-1833,-1354,-1059,-984,-936,-808,-676,-613,-566,-463,-323,-196,-77,48,148,202,254,331,372,313,192,98,37,-60,-207,-314,-295,-159,22,172,225,140,-45,-216,-278,-240,-185,-179,-223,-283,-319,-295,-197,-63,29,27,-58,-170,-258,-298,-294,-255,-184,-86,32,153,251,306,300,220,76,-85,-204,-256,-261,-245,-208,-133,-38,33,49,8,-81,-210,-346,-426,-408,-316,-216,-143,-95,-70,-81,-125,-164,-168,-153,-155,-173,-175,-144,-91,-36,4,13,-19,-73,-113,-125,-128,-143,-162,-168,-163,-158,-153,-139,-120,-106,-104,-111,-126,-143,-151,-142,-122,-105,-93,-78,-58,-38,-18,2,17,17,4,-6,0,14,23,23,20,16,7,-7,-21,-34,-50,-68,-76,-60,-28}
        },
        {    // H40e077a.wav
            {0,1,2,1,0,1,2,2,1,1,2,2,1,1,1,-1,-2,-1,1,0,0,2,3,1,-1,1,2,-1,-4,-1,4,3,2,6,10,3,-6,-2,8,3,-10,-5,15,16,-1,0,19,4,-26,66,379,808,1171,1440,1644,1523,548,-1431,-3654,-4869,-4390,-2603,-408,1609,3323,4644,5308,5150,4375,3413,2582,1974,1574,1349,1229,1120,974,806,618,376,73,-223,-445,-612,-791,-992,-1147,-1214,-1241,-1295,-1374,-1414,-1380,-1283,-1125,-880,-563,-260,-57,46,98,114,88,84,216,500,785,893,797,610,438,315,254,263,280,179,-93,-424,-630,-648,-575,-539,-580,-652,-696,-682,-601,-479,-378,-342,-342,-300,-176,-19,73,37,-98,-237,-282,-205,-68,25,10,-88,-192,-237,-219,-180,-166,-201,-276,-368,-443,-475,-466,-434,-396,-357,-320,-295,-283,-274,-259,-240,-226,-216,-201,-182,-177,-196,-227,-245,-240,-224,-210,-202,-202,-217,-252,-297,-332,-345,-339,-324,-311,-308,-312,-312,-295,-257,-207,-155,-106,-63,-28,-2,13,18,16,7,-6,-20,-33,-44,-60,-84,-114,-141,-158,-162,-155,-142,-131,-127,-132,-138,-137,-126,-109,-90,-72,-58,-51,-48,-46,-42,-38,-40,-50,-62,-70,-74,-79,-85,-89,-89,-86,-84,-83,-80,-77,-78,-87,-105,-127,-146,-157,-160,-156,-144,-125,-106,-93,-80,-57,-25},
            {-55,57,65,-77,-114,67,159,-55,-221,28,294,-29,-451,476,3404,7287,10339,10799,6490,-4204,-18618,-28220,-24439,-7763,11005,20659,19809,15648,14057,14028,11867,7284,3048,706,-371,-346,1665,4848,5832,2247,-4042,-8858,-10213,-9462,-8518,-7788,-7105,-6876,-7205,-7023,-5425,-3345,-2585,-3351,-3956,-3124,-1398,152,1485,2972,4081,3920,2862,2437,3376,4670,4958,4124,3028,2256,1794,1551,1467,1197,355,-810,-1531,-1490,-1245,-1474,-2163,-2817,-3164,-3274,-3157,-2687,-1951,-1341,-1150,-1231,-1191,-798,-139,544,1045,1251,1136,792,456,406,719,1137,1276,1022,629,389,288,100,-299,-829,-1360,-1782,-1948,-1754,-1330,-1000,-942,-1005,-951,-753,-553,-424,-320,-219,-159,-127,-50,90,219,278,289,273,208,101,20,2,-23,-144,-330,-448,-406,-221,18,203,242,113,-97,-250,-272,-209,-152,-150,-191,-234,-238,-173,-52,61,92,28,-87,-188,-236,-233,-206,-175,-137,-69,39,159,244,263,208,90,-59,-189,-257,-268,-260,-250,-215,-133,-33,30,21,-54,-173,-302,-391,-396,-319,-217,-137,-83,-46,-37,-69,-118,-142,-130,-114,-117,-126,-119,-93,-57,-21,-3,-22,-71,-117,-132,-127,-129,-142,-152,-157,-168,-181,-178,-158,-142,-143,-151,-153,-151,-152,-152,-142,-123,-104,-88,-68,-43,-16,10,31,38,29,14,10,21,38,49,47,31,6,-20,-38,-48,-55,-61,-65,-61,-45,-21}
        },
        {    // H40e084a.wav
            {0,-1,0,1,0,-1,0,1,0,-1,1,3,1,-2,-2,-1,-1,-2,-2,-1,-1,-1,0,1,0,-2,-1,-1,-3,-5,-2,1,0,-1,4,8,3,-5,-3,3,-2,-10,-2,19,22,4,-1,7,-15,-46,42,342,761,1132,1423,1647,1540,591,-1351,-3553,-4778,-4299,-2462,-216,1730,3195,4202,4685,4581,4006,3210,2429,1845,1597,1686,1899,1939,1684,1259,850,519,230,-30,-253,-484,-798,-1166,-1441,-1517,-1471,-1470,-1566,-1654,-1628,-1500,-1331,-1113,-802,-456,-242,-250,-356,-316,-9,451,835,995,949,815,709,680,698,686,582,392,194,64,-7,-104,-301,-578,-838,-989,-999,-898,-743,-601,-520,-500,-489,-442,-361,-277,-201,-128,-76,-85,-154,-212,-191,-101,-19,-6,-66,-156,-226,-242,-200,-128,-79,-88,-154,-249,-348,-431,-474,-462,-405,-334,-279,-251,-247,-260,-274,-275,-259,-239,-229,-235,-250,-265,-273,-268,-248,-221,-203,-205,-225,-253,-280,-300,-308,-300,-284,-275,-285,-307,-321,-316,-293,-257,-208,-148,-89,-43,-15,-2,-1,-11,-27,-40,-45,-49,-59,-77,-96,-111,-122,-132,-141,-145,-142,-137,-132,-129,-125,-121,-118,-115,-112,-105,-91,-74,-61,-53,-48,-46,-47,-49,-51,-53,-59,-71,-85,-97,-103,-101,-93,-87,-88,-93,-99,-105,-114,-125,-135,-143,-152,-157,-150,-132,-110,-95,-82,-59,-26},
            {-38,62,40,-91,-82,97,125,-104,-190,97,264,-136,-408,822,3966,7896,10776,10490,4627,-7538,-21533,-28086,-20504,-2362,14436,20691,17768,13555,12629,12892,10876,6781,3098,900,-195,186,2701,5688,5558,863,-5518,-9432,-9727,-8382,-7338,-6857,-6695,-7012,-7503,-7029,-5160,-3264,-2946,-3876,-4243,-3136,-1325,311,1855,3376,4048,3280,2071,2088,3529,4871,4823,3699,2606,2075,1944,1978,1935,1399,217,-994,-1385,-957,-622,-1101,-2155,-3072,-3471,-3395,-2957,-2284,-1690,-1496,-1637,-1685,-1313,-616,78,557,797,830,680,448,345,534,925,1202,1126,789,490,378,302,46,-418,-953,-1416,-1685,-1645,-1315,-951,-834,-961,-1054,-920,-647,-419,-289,-209,-170,-175,-153,-29,148,260,272,245,203,110,-17,-92,-93,-116,-244,-417,-497,-418,-224,5,184,227,100,-116,-272,-280,-188,-107,-97,-141,-181,-169,-90,23,103,97,9,-105,-182,-200,-180,-160,-151,-130,-64,46,160,225,210,116,-29,-172,-258,-270,-246,-238,-243,-214,-127,-26,22,-12,-109,-234,-345,-393,-351,-250,-158,-109,-82,-49,-27,-44,-86,-114,-117,-113,-114,-107,-83,-54,-34,-27,-35,-64,-103,-124,-118,-110,-126,-156,-173,-175,-173,-175,-172,-165,-167,-182,-195,-192,-180,-168,-156,-139,-117,-96,-76,-56,-38,-19,1,19,25,22,17,21,32,43,48,47,37,16,-13,-40,-59,-70,-72,-66,-53,-36,-17}
        },
        {    // H40e090a.wav
            {1,0,1,2,1,0,0,1,3,1,0,1,2,0,-1,1,2,1,0,1,2,0,0,2,3,1,-1,0,1,-1,-1,2,2,-1,0,7,9,2,-3,2,4,-4,-4,18,35,19,-6,-4,1,-34,-49,102,460,884,1238,1535,1719,1390,61,-2130,-4153,-4794,-3683,-1518,671,2317,3390,3990,4134,3875,3403,2929,2559,2328,2261,2319,2342,2158,1749,1244,767,346,-13,-271,-438,-636,-981,-1413,-1721,-1772,-1657,-1572,-1617,-1741,-1831,-1780,-1512,-1064,-638,-469,-561,-628,-380,162,702,992,1029,959,901,902,959,997,897,627,338,233,328,403,225,-223,-752,-1144,-1288,-1193,-954,-717,-598,-603,-635,-603,-511,-420,-363,-319,-258,-177,-92,-17,31,34,-10,-71,-117,-144,-170,-193,-188,-142,-81,-42,-39,-67,-133,-242,-367,-453,-466,-419,-352,-292,-251,-241,-262,-287,-285,-256,-235,-248,-284,-311,-312,-293,-268,-239,-208,-187,-188,-211,-244,-268,-275,-269,-262,-260,-261,-261,-263,-269,-275,-274,-262,-234,-189,-131,-77,-43,-32,-36,-45,-52,-57,-63,-73,-87,-99,-100,-90,-76,-71,-82,-108,-136,-150,-145,-126,-105,-91,-85,-89,-99,-107,-104,-88,-69,-56,-52,-54,-55,-53,-48,-47,-53,-63,-74,-86,-98,-104,-100,-91,-87,-93,-100,-103,-103,-106,-112,-118,-126,-132,-129,-113,-92,-78,-69,-53,-26},
            {-31,57,34,-81,-68,90,108,-98,-167,94,237,-132,-378,776,3816,7786,10788,10375,4055,-8345,-21681,-26860,-18310,-562,14718,19464,15877,11790,11330,12180,10821,7242,3686,1329,174,751,3408,6123,5394,228,-6143,-9591,-9246,-7411,-6256,-6078,-6397,-7007,-7448,-6802,-4977,-3399,-3406,-4410,-4624,-3337,-1442,208,1742,3215,3807,2998,1843,1955,3429,4713,4590,3450,2408,1966,1938,2054,2032,1457,268,-825,-1003,-409,-70,-672,-1864,-2867,-3318,-3281,-2855,-2175,-1615,-1540,-1835,-1953,-1527,-731,-15,361,434,340,193,117,246,595,969,1097,896,570,393,403,382,129,-337,-851,-1263,-1456,-1344,-992,-679,-662,-880,-1015,-872,-565,-313,-185,-140,-156,-216,-225,-91,126,271,278,209,131,36,-74,-149,-173,-217,-334,-467,-503,-401,-214,-21,119,152,58,-102,-213,-214,-143,-84,-77,-101,-114,-87,-16,70,120,98,12,-89,-159,-184,-177,-158,-137,-104,-42,47,132,174,149,58,-77,-211,-295,-304,-264,-223,-200,-170,-108,-35,-1,-36,-124,-233,-327,-367,-332,-245,-157,-99,-63,-33,-19,-34,-64,-84,-91,-99,-108,-100,-70,-38,-20,-19,-35,-71,-112,-127,-111,-97,-115,-155,-183,-185,-174,-164,-157,-157,-171,-195,-212,-211,-200,-187,-168,-138,-105,-77,-57,-44,-36,-29,-16,0,10,9,9,22,45,62,65,59,49,33,11,-13,-33,-47,-57,-61,-56,-40,-18}
        },
        {    // H40e096a.wav
            {0,-1,-1,0,1,0,-1,0,1,0,-1,1,2,0,-2,-2,0,-1,-2,-2,-2,-3,-3,-1,1,0,-2,-2,-2,-4,-3,1,2,-2,-4,1,4,-2,-7,-1,6,-1,-7,8,31,25,-5,-17,-7,-22,-48,38,330,756,1168,1523,1787,1653,608,-1455,-3751,-4995,-4429,-2415,-1,1966,3244,3941,4184,4073,3760,3390,3022,2684,2460,2407,2410,2235,1774,1171,650,286,-11,-320,-622,-880,-1124,-1396,-1653,-1790,-1784,-1742,-1778,-1875,-1897,-1746,-1473,-1219,-1054,-895,-606,-171,266,540,636,691,838,1079,1299,1370,1242,962,658,475,470,555,553,339,-76,-575,-1012,-1266,-1285,-1119,-905,-770,-733,-726,-694,-644,-605,-572,-515,-417,-282,-121,44,172,219,174,70,-39,-116,-147,-144,-130,-123,-125,-120,-98,-69,-65,-114,-216,-339,-433,-464,-435,-377,-322,-288,-274,-270,-267,-261,-257,-264,-288,-322,-346,-341,-306,-261,-221,-197,-186,-182,-184,-197,-226,-266,-299,-304,-275,-228,-192,-187,-208,-233,-248,-249,-236,-209,-175,-149,-134,-121,-103,-87,-88,-106,-126,-131,-116,-87,-56,-38,-39,-57,-83,-109,-128,-134,-124,-107,-92,-83,-79,-79,-81,-83,-81,-80,-82,-86,-85,-80,-76,-75,-73,-70,-69,-74,-82,-91,-102,-112,-115,-109,-101,-94,-89,-87,-92,-100,-104,-100,-97,-97,-93,-78,-67,-73,-86,-77,-39},
            {-41,41,43,-60,-79,55,113,-49,-164,26,219,-34,-368,387,3000,6906,10312,10641,5269,-6255,-19420,-25663,-19010,-2715,12455,17989,14972,10875,10476,11987,11491,8263,4483,1825,547,985,3420,6133,5769,952,-5519,-9369,-9204,-7147,-5725,-5562,-6074,-6801,-7273,-6710,-5005,-3462,-3468,-4600,-5048,-3865,-1851,-67,1421,2775,3400,2774,1746,1851,3304,4637,4552,3385,2337,1973,2001,2030,1852,1253,232,-631,-650,10,348,-312,-1571,-2562,-2917,-2835,-2541,-2118,-1756,-1711,-1916,-1954,-1540,-852,-293,-54,-43,-99,-124,-41,206,564,844,872,667,438,374,447,453,239,-161,-607,-984,-1201,-1168,-906,-627,-574,-744,-884,-792,-531,-290,-160,-125,-162,-241,-261,-133,85,229,227,153,88,23,-71,-157,-200,-245,-349,-469,-498,-399,-236,-86,23,73,40,-62,-155,-166,-113,-67,-66,-87,-87,-53,7,73,118,111,42,-59,-145,-187,-191,-176,-148,-103,-39,34,95,125,110,42,-68,-188,-272,-295,-271,-235,-203,-163,-102,-37,-9,-36,-107,-200,-289,-341,-331,-268,-192,-131,-80,-32,-7,-24,-66,-92,-90,-84,-91,-94,-73,-39,-15,-11,-26,-59,-98,-122,-119,-107,-114,-141,-166,-174,-172,-168,-161,-155,-162,-185,-205,-208,-199,-189,-179,-159,-128,-94,-66,-47,-35,-30,-26,-20,-12,-7,-1,14,41,68,83,80,65,43,20,-2,-19,-30,-37,-41,-41,-33,-17}
        },
        {    // H40e103a.wav
            {0,0,1,1,1,1,1,1,1,1,1,1,2,1,0,1,1,-1,-1,1,1,-1,-1,2,3,1,-1,0,0,-3,-3,2,4,1,0,3,2,-7,-10,-1,8,5,3,16,27,12,-9,-7,-2,-32,-44,94,435,879,1315,1725,1987,1646,197,-2221,-4542,-5440,-4387,-2006,569,2555,3790,4434,4655,4551,4192,3633,2964,2376,2082,2106,2187,1998,1464,809,296,-11,-226,-458,-735,-1048,-1382,-1667,-1798,-1756,-1679,-1719,-1850,-1890,-1740,-1520,-1403,-1357,-1162,-686,-73,396,584,590,604,740,993,1271,1443,1397,1141,833,657,657,686,558,221,-222,-633,-928,-1080,-1099,-1035,-966,-932,-904,-836,-744,-694,-707,-720,-658,-514,-336,-160,6,149,234,243,198,135,72,17,-17,-28,-41,-81,-141,-188,-199,-182,-159,-156,-196,-288,-407,-498,-515,-457,-363,-280,-236,-231,-250,-272,-288,-301,-317,-332,-332,-307,-262,-219,-193,-183,-175,-163,-161,-185,-234,-281,-295,-270,-223,-180,-155,-152,-167,-195,-221,-234,-232,-223,-213,-199,-178,-160,-156,-166,-179,-179,-154,-107,-54,-15,-7,-30,-67,-96,-106,-104,-96,-85,-72,-66,-70,-76,-76,-70,-66,-63,-60,-60,-71,-89,-103,-104,-98,-93,-91,-91,-92,-95,-100,-106,-110,-109,-104,-97,-92,-86,-79,-74,-77,-83,-82,-74,-67,-66,-64,-58,-58,-73,-87,-75,-37},
            {-45,14,47,-22,-80,0,101,22,-132,-64,160,100,-268,-72,1743,5252,9096,10789,7509,-2011,-14818,-23473,-20984,-7700,7657,15592,14459,10476,9668,11775,12572,9964,5755,2472,920,1067,3006,5705,6315,2703,-3596,-8436,-9302,-7439,-5642,-5221,-5728,-6469,-7009,-6738,-5325,-3662,-3255,-4298,-5217,-4573,-2664,-700,841,2160,2982,2702,1721,1489,2724,4335,4744,3771,2559,2003,1984,1989,1747,1155,242,-555,-605,87,624,178,-1033,-2098,-2494,-2433,-2255,-2013,-1735,-1641,-1822,-1972,-1709,-1082,-528,-358,-479,-592,-519,-257,116,489,714,687,467,272,280,447,547,413,82,-299,-644,-917,-1030,-911,-663,-532,-624,-766,-726,-501,-276,-173,-165,-198,-250,-268,-166,36,187,180,81,14,-10,-57,-132,-182,-211,-288,-417,-494,-438,-289,-146,-52,5,19,-28,-106,-145,-115,-62,-44,-63,-80,-67,-21,44,103,118,68,-27,-119,-174,-191,-187,-170,-137,-86,-19,50,98,101,48,-47,-149,-221,-246,-236,-222,-216,-196,-139,-59,-5,-11,-72,-159,-248,-314,-329,-287,-218,-162,-122,-78,-36,-28,-63,-102,-110,-96,-88,-87,-72,-38,-8,-4,-23,-55,-90,-115,-120,-111,-111,-129,-152,-164,-166,-165,-160,-154,-156,-168,-184,-190,-187,-185,-187,-180,-158,-125,-92,-65,-47,-40,-40,-40,-35,-26,-13,9,40,69,86,87,74,52,24,-1,-16,-18,-14,-12,-12,-12,-7}
        },
        {    // H40e109a.wav
            {0,0,1,2,1,0,1,2,1,0,1,2,1,0,0,0,-1,-2,0,2,1,0,0,1,1,1,1,1,-1,-1,2,2,-1,0,5,5,-4,-11,-5,2,-1,-2,14,30,19,-7,-10,3,-13,-38,46,338,817,1386,1941,2254,1847,266,-2308,-4792,-5817,-4768,-2236,553,2679,3956,4640,4960,4947,4562,3861,3043,2381,2058,2019,1987,1692,1123,517,98,-133,-338,-622,-949,-1242,-1480,-1668,-1773,-1784,-1760,-1758,-1731,-1602,-1428,-1387,-1515,-1558,-1202,-457,295,670,643,512,565,853,1220,1463,1458,1224,932,788,853,969,897,533,-20,-565,-948,-1106,-1066,-929,-833,-854,-949,-1005,-964,-875,-817,-802,-775,-681,-520,-327,-138,13,96,118,130,174,242,287,279,226,152,76,6,-54,-115,-192,-275,-329,-327,-291,-278,-323,-413,-503,-550,-529,-442,-325,-239,-221,-258,-304,-330,-336,-330,-306,-263,-214,-179,-161,-148,-139,-149,-186,-231,-252,-237,-206,-184,-172,-159,-145,-144,-161,-183,-199,-214,-235,-253,-253,-237,-223,-227,-245,-261,-257,-221,-158,-83,-26,-11,-33,-67,-93,-105,-102,-85,-61,-43,-39,-46,-55,-61,-62,-59,-53,-48,-48,-54,-64,-74,-86,-101,-115,-122,-120,-117,-120,-127,-129,-126,-124,-123,-115,-94,-72,-63,-68,-73,-69,-63,-60,-57,-51,-50,-58,-67,-64,-54,-51,-56,-51,-27},
            {-31,-25,21,21,-42,-53,36,76,-34,-118,12,157,-21,-277,362,2732,6491,9792,9787,4081,-6844,-17972,-21906,-14875,-1110,10177,13227,10565,8810,10820,13486,12732,8469,3817,1203,874,2278,4712,6417,4997,4,-5761,-8740,-8138,-6145,-5061,-5286,-6033,-6662,-6758,-5893,-4282,-3157,-3527,-4737,-5086,-3839,-1848,-136,1182,2228,2579,1985,1308,1760,3271,4448,4301,3284,2431,2086,1912,1624,1174,519,-237,-622,-265,417,525,-256,-1301,-1891,-2003,-2011,-1995,-1776,-1440,-1344,-1577,-1761,-1546,-1063,-731,-741,-898,-905,-646,-211,225,504,540,374,174,133,303,533,607,442,124,-230,-572,-843,-924,-769,-542,-480,-608,-703,-590,-353,-198,-192,-242,-259,-230,-155,-33,81,103,32,-42,-59,-59,-90,-131,-151,-188,-288,-406,-443,-366,-234,-116,-32,9,-10,-77,-137,-140,-104,-75,-69,-72,-73,-69,-40,25,93,101,28,-80,-158,-185,-184,-177,-164,-138,-96,-38,27,76,76,21,-69,-152,-194,-193,-178,-178,-190,-179,-124,-53,-17,-38,-101,-179,-252,-300,-299,-255,-204,-171,-144,-108,-80,-85,-114,-129,-116,-98,-92,-83,-56,-19,1,-7,-35,-71,-100,-111,-105,-104,-123,-152,-167,-162,-151,-145,-141,-138,-143,-155,-164,-167,-174,-189,-197,-185,-159,-132,-108,-87,-72,-68,-67,-58,-40,-21,1,30,62,83,86,72,46,18,-1,-4,9,22,22,10,0,-2}
        },
        {    // H40e116a.wav
            {0,0,0,0,1,2,1,0,1,3,3,2,1,1,0,-1,-1,0,0,0,1,2,2,0,0,1,0,-1,0,3,3,0,-1,2,3,-1,-6,-5,-3,-4,-2,8,18,12,1,3,6,-16,-31,67,378,924,1626,2268,2437,1612,-429,-3162,-5363,-5850,-4335,-1597,1175,3213,4427,5054,5238,4969,4285,3404,2640,2221,2157,2232,2136,1687,972,269,-206,-466,-672,-926,-1211,-1484,-1730,-1910,-1942,-1817,-1658,-1593,-1591,-1525,-1385,-1311,-1353,-1315,-941,-256,403,718,700,631,750,1054,1356,1480,1379,1147,944,884,938,950,763,357,-153,-619,-949,-1110,-1108,-1001,-889,-853,-888,-932,-950,-964,-985,-962,-835,-617,-393,-231,-132,-61,-4,39,81,144,228,310,364,371,319,217,105,28,-9,-54,-149,-282,-395,-447,-448,-437,-442,-465,-492,-508,-500,-466,-413,-361,-330,-324,-331,-328,-301,-256,-209,-172,-144,-123,-114,-127,-161,-197,-212,-202,-179,-155,-136,-126,-129,-141,-151,-156,-167,-193,-229,-255,-262,-260,-268,-288,-307,-306,-277,-227,-169,-117,-85,-79,-92,-109,-116,-111,-97,-78,-56,-37,-27,-29,-40,-52,-59,-59,-51,-38,-27,-26,-38,-59,-81,-98,-107,-110,-113,-119,-127,-131,-132,-135,-143,-148,-145,-133,-115,-91,-63,-43,-39,-45,-51,-57,-64,-69,-67,-59,-52,-46,-39,-35,-42,-54,-52,-28},
            {0,-33,-17,25,9,-45,-29,50,48,-60,-84,59,121,-106,-192,824,3546,7289,9848,8302,1020,-9972,-18699,-18985,-10014,2110,9622,10267,8478,9372,12880,14715,12071,6643,2125,467,1290,3476,5735,6198,3363,-1949,-6644,-8198,-7002,-5394,-4964,-5537,-6273,-6647,-6321,-5125,-3646,-3077,-3846,-4843,-4625,-3066,-1205,228,1311,2072,2123,1537,1286,2140,3542,4244,3829,2989,2413,2070,1671,1209,761,240,-297,-467,-84,372,231,-522,-1287,-1662,-1792,-1885,-1823,-1482,-1119,-1099,-1392,-1602,-1483,-1194,-1022,-1032,-1055,-913,-572,-137,223,375,311,156,83,186,419,628,664,489,165,-223,-591,-828,-828,-633,-454,-470,-615,-667,-533,-342,-246,-241,-235,-189,-133,-79,-23,5,-25,-77,-84,-50,-39,-74,-109,-124,-167,-267,-366,-379,-291,-166,-59,7,16,-38,-119,-168,-162,-133,-115,-108,-103,-99,-89,-46,32,93,74,-24,-132,-189,-191,-170,-153,-146,-139,-114,-59,14,67,66,8,-72,-134,-156,-145,-131,-137,-159,-165,-134,-81,-43,-47,-92,-161,-231,-274,-276,-249,-220,-197,-169,-134,-114,-121,-138,-140,-127,-116,-108,-85,-45,-8,7,0,-24,-59,-93,-110,-113,-122,-147,-167,-160,-134,-116,-114,-118,-121,-127,-136,-145,-157,-173,-189,-193,-179,-158,-139,-124,-110,-98,-87,-73,-51,-27,-5,20,50,74,76,57,35,22,21,27,36,42,38,23,7,0}
        },
        {    // H40e122a.wav
            {0,0,0,1,1,1,2,2,2,1,1,1,0,-1,-1,-1,0,0,1,2,2,1,0,0,0,0,0,2,3,3,2,2,2,-1,-4,-4,-2,-2,-3,2,11,12,2,-4,2,3,-11,20,236,761,1563,2360,2646,1896,-66,-2752,-5073,-5908,-4818,-2319,543,2909,4483,5356,5629,5305,4457,3375,2460,1987,1959,2141,2207,1927,1313,602,48,-297,-585,-963,-1418,-1828,-2104,-2224,-2189,-2032,-1852,-1746,-1685,-1541,-1287,-1091,-1111,-1221,-1074,-487,305,855,953,800,754,968,1295,1493,1458,1269,1079,986,983,972,830,493,6,-499,-881,-1063,-1060,-957,-862,-844,-895,-954,-981,-993,-1019,-1031,-960,-771,-518,-296,-159,-100,-80,-67,-32,43,153,266,348,378,353,285,209,164,157,149,93,-19,-156,-287,-404,-503,-570,-592,-571,-528,-488,-470,-480,-507,-530,-531,-501,-440,-351,-250,-159,-99,-79,-93,-129,-163,-170,-142,-98,-67,-66,-88,-115,-132,-133,-123,-117,-132,-167,-201,-216,-218,-233,-276,-329,-362,-358,-318,-257,-192,-144,-120,-119,-131,-146,-157,-161,-151,-126,-95,-68,-47,-27,-12,-14,-35,-58,-64,-53,-39,-27,-17,-13,-24,-49,-78,-102,-119,-128,-127,-116,-104,-101,-109,-126,-147,-161,-160,-142,-114,-85,-59,-41,-34,-37,-43,-51,-67,-84,-86,-66,-41,-27,-22,-16,-21,-51,-88,-92,-50},
            {15,-5,-29,-14,17,5,-34,-21,36,33,-46,-63,44,89,-85,-142,750,3225,6767,9278,7877,1074,-8984,-16712,-16899,-9370,448,6481,7597,7695,10328,14376,15694,12205,6138,1401,-12,1319,3814,5876,5913,3007,-1837,-5961,-7348,-6418,-5170,-4945,-5559,-6216,-6423,-5960,-4819,-3564,-3143,-3810,-4575,-4245,-2775,-1093,158,1057,1682,1763,1377,1292,2089,3293,3905,3601,2908,2336,1890,1451,1087,787,350,-202,-454,-156,282,223,-413,-1137,-1566,-1735,-1756,-1572,-1195,-907,-964,-1259,-1469,-1459,-1360,-1303,-1255,-1121,-873,-548,-205,65,173,126,49,84,267,518,709,742,587,275,-124,-502,-727,-724,-566,-449,-497,-631,-671,-562,-410,-319,-273,-216,-149,-107,-88,-76,-87,-131,-158,-112,-19,33,10,-39,-77,-131,-223,-302,-296,-204,-91,-11,23,6,-63,-152,-210,-219,-204,-192,-179,-154,-125,-92,-42,23,59,22,-70,-152,-179,-165,-146,-140,-144,-147,-132,-86,-17,37,45,11,-35,-68,-86,-99,-115,-139,-163,-165,-129,-74,-34,-30,-63,-124,-196,-252,-274,-267,-248,-224,-187,-146,-131,-154,-187,-194,-171,-141,-112,-76,-32,3,14,4,-21,-57,-94,-117,-125,-131,-140,-141,-127,-109,-100,-98,-93,-89,-96,-114,-134,-153,-172,-185,-183,-168,-154,-150,-150,-142,-124,-102,-77,-47,-16,6,19,26,31,36,44,54,62,62,56,49,42,31,19,7}
        },
        {    // H40e129a.wav
            {-1,-1,0,2,2,1,0,0,1,1,0,-1,-1,-1,-1,-1,0,1,1,1,0,-1,-1,-1,-2,-1,2,4,2,0,0,1,-1,-4,-4,-2,-3,-3,3,11,9,-1,-3,2,-5,-7,119,555,1362,2297,2811,2304,527,-2118,-4637,-5912,-5339,-3175,-312,2333,4280,5469,5951,5722,4848,3629,2528,1907,1824,2043,2198,2005,1425,687,99,-212,-388,-660,-1108,-1626,-2064,-2346,-2453,-2391,-2216,-2037,-1914,-1787,-1556,-1247,-1022,-974,-961,-714,-135,561,1037,1157,1092,1103,1260,1411,1396,1238,1095,1068,1105,1083,922,619,211,-243,-659,-952,-1083,-1072,-972,-844,-756,-758,-854,-995,-1111,-1143,-1057,-856,-593,-358,-224,-193,-200,-178,-108,-11,86,177,263,328,343,293,210,154,160,198,204,143,40,-61,-152,-260,-395,-525,-608,-630,-607,-566,-532,-525,-552,-597,-627,-613,-545,-429,-286,-157,-84,-81,-117,-141,-125,-80,-37,-11,-3,-10,-34,-67,-92,-102,-109,-131,-164,-190,-204,-225,-265,-312,-340,-337,-311,-275,-240,-209,-190,-183,-180,-173,-164,-158,-153,-146,-139,-134,-122,-98,-67,-42,-27,-21,-24,-35,-47,-48,-37,-26,-24,-31,-41,-55,-76,-100,-118,-124,-121,-115,-109,-106,-110,-124,-142,-152,-143,-116,-87,-67,-57,-50,-50,-62,-81,-89,-80,-68,-62,-56,-41,-27,-28,-38,-43,-52,-80,-112,-108,-57},
            {3,13,-2,-24,-15,9,3,-24,-16,23,21,-34,-46,29,63,-67,-107,657,2882,6224,8742,7628,1430,-7796,-14925,-15453,-9436,-1463,3777,5765,7591,11425,15515,16172,12069,5737,983,-313,1203,3799,5774,5701,2948,-1476,-5263,-6686,-6058,-5062,-4891,-5443,-6025,-6163,-5682,-4649,-3578,-3230,-3758,-4310,-3910,-2557,-1053,58,854,1420,1540,1270,1248,1974,3064,3663,3427,2743,2092,1627,1338,1187,969,441,-233,-499,-124,375,302,-393,-1160,-1575,-1673,-1606,-1384,-1060,-874,-981,-1227,-1366,-1379,-1415,-1485,-1423,-1141,-754,-429,-217,-87,-23,-11,14,132,355,605,776,792,634,334,-40,-388,-606,-645,-567,-510,-550,-627,-633,-557,-470,-413,-353,-261,-173,-130,-119,-119,-141,-184,-191,-112,7,71,54,10,-26,-81,-170,-238,-226,-147,-58,4,34,12,-77,-196,-276,-285,-256,-229,-207,-177,-141,-102,-55,-7,10,-28,-96,-146,-155,-143,-137,-145,-160,-172,-162,-115,-43,16,34,19,-6,-33,-65,-97,-123,-144,-159,-152,-114,-60,-21,-19,-53,-113,-183,-243,-271,-266,-248,-229,-206,-181,-172,-191,-218,-219,-190,-151,-116,-79,-40,-14,-12,-28,-49,-72,-94,-108,-112,-114,-119,-121,-113,-101,-91,-82,-74,-73,-88,-114,-138,-153,-164,-171,-169,-158,-152,-158,-166,-162,-142,-113,-82,-52,-28,-18,-16,-9,12,40,64,78,81,77,68,55,40,23,8}
        },
        {    // H40e135a.wav
            {1,1,1,1,1,1,1,0,-1,-2,-2,-2,-2,-2,-1,0,2,2,0,-2,-2,-1,-2,-2,0,3,3,0,-1,-1,-2,-5,-6,-3,-3,-6,-5,4,10,3,-5,1,3,-8,64,432,1235,2275,2959,2597,880,-1804,-4464,-5975,-5676,-3702,-841,1993,4223,5675,6327,6145,5194,3818,2559,1841,1735,1984,2204,2088,1542,742,19,-395,-553,-709,-1045,-1514,-1943,-2218,-2338,-2348,-2285,-2200,-2138,-2078,-1920,-1599,-1203,-924,-841,-790,-499,118,833,1313,1451,1426,1449,1514,1470,1274,1076,1022,1072,1062,905,648,358,26,-370,-780,-1088,-1208,-1136,-943,-735,-619,-654,-816,-1016,-1150,-1143,-969,-675,-379,-201,-174,-223,-246,-202,-118,-23,80,188,272,295,252,182,137,139,170,191,174,117,39,-41,-120,-207,-308,-410,-493,-546,-574,-593,-612,-632,-656,-681,-687,-643,-542,-417,-320,-268,-232,-177,-106,-47,-15,4,22,32,23,5,-2,-1,-13,-49,-97,-140,-179,-226,-280,-323,-338,-323,-289,-248,-212,-194,-200,-223,-243,-244,-225,-198,-176,-164,-158,-153,-146,-134,-116,-94,-74,-61,-53,-45,-37,-32,-32,-33,-29,-25,-29,-43,-63,-84,-103,-116,-117,-109,-102,-103,-114,-131,-146,-151,-142,-125,-104,-81,-55,-35,-32,-47,-72,-97,-118,-125,-111,-80,-50,-32,-24,-21,-29,-52,-80,-97,-104,-111,-114,-92,-45},
            {3,5,9,4,-10,-14,-4,-1,-11,-13,6,17,-5,-28,-1,41,-5,-95,221,1669,4490,7500,8150,4292,-3452,-11204,-14463,-11784,-5791,-309,3298,6588,11049,15460,16801,13543,7434,1968,-459,232,2626,4995,5814,4179,490,-3467,-5783,-5986,-5178,-4699,-4954,-5513,-5834,-5620,-4842,-3849,-3290,-3499,-3971,-3821,-2781,-1420,-337,426,1026,1329,1218,1094,1547,2540,3333,3321,2648,1904,1491,1416,1444,1252,660,-89,-425,-94,433,442,-201,-979,-1409,-1502,-1480,-1381,-1160,-951,-956,-1146,-1308,-1359,-1412,-1512,-1501,-1225,-767,-369,-185,-179,-221,-205,-79,154,441,689,819,805,671,460,201,-84,-351,-533,-602,-602,-597,-594,-564,-519,-508,-531,-511,-403,-265,-186,-172,-165,-144,-137,-145,-127,-66,-3,30,49,68,52,-30,-138,-188,-153,-76,-10,25,18,-47,-157,-256,-295,-280,-251,-226,-197,-160,-123,-88,-54,-32,-37,-68,-101,-121,-133,-147,-165,-180,-191,-187,-154,-89,-20,22,29,15,-9,-42,-77,-104,-124,-139,-140,-111,-60,-17,-3,-18,-58,-120,-190,-242,-260,-251,-232,-209,-186,-175,-188,-212,-219,-201,-173,-149,-125,-93,-62,-44,-41,-47,-60,-78,-90,-87,-75,-67,-68,-73,-78,-82,-83,-77,-69,-70,-86,-109,-129,-141,-145,-143,-141,-146,-156,-162,-157,-141,-119,-96,-79,-70,-61,-41,-7,32,65,87,97,97,92,89,83,62,28}
        },
        {    // H40e141a.wav
            {1,1,1,1,1,0,-1,-1,-2,-2,-2,-1,0,0,1,1,0,-1,-1,0,-1,-2,0,2,2,0,0,2,0,-6,-7,-2,-1,-7,-7,4,11,1,-8,2,9,0,99,567,1532,2675,3240,2493,297,-2674,-5248,-6361,-5578,-3243,-195,2722,5001,6441,6939,6435,5102,3460,2163,1605,1719,2104,2312,2065,1364,467,-271,-660,-804,-967,-1311,-1773,-2169,-2374,-2390,-2296,-2178,-2097,-2068,-2051,-1953,-1695,-1302,-935,-763,-766,-684,-260,470,1185,1608,1757,1810,1817,1671,1357,1068,987,1053,1042,841,543,263,-8,-340,-720,-1048,-1233,-1250,-1113,-873,-634,-525,-602,-802,-995,-1067,-966,-710,-387,-132,-39,-90,-174,-196,-144,-62,20,99,163,184,155,108,87,104,138,160,158,129,72,-12,-115,-220,-306,-356,-368,-363,-376,-434,-535,-645,-725,-755,-742,-699,-633,-542,-432,-320,-229,-172,-141,-116,-81,-41,-5,27,61,91,97,71,31,-5,-41,-97,-178,-259,-308,-315,-289,-248,-212,-194,-201,-223,-245,-253,-243,-221,-198,-187,-197,-219,-229,-215,-181,-142,-108,-83,-65,-52,-44,-42,-46,-51,-50,-40,-26,-15,-12,-20,-39,-66,-95,-118,-130,-129,-123,-121,-128,-138,-145,-147,-143,-130,-104,-72,-45,-28,-21,-24,-42,-70,-94,-106,-108,-103,-87,-60,-37,-30,-35,-45,-62,-90,-112,-112,-100,-103,-116,-104,-54},
            {10,6,2,3,3,-4,-11,-10,-2,-1,-5,-3,5,2,-12,-12,16,16,-51,47,941,3176,6204,7936,5944,-225,-7887,-12874,-12809,-8753,-3580,998,5417,10435,15056,16867,14420,8880,3190,-143,-417,1506,4069,5621,4941,1962,-1939,-4836,-5746,-5235,-4573,-4522,-4981,-5447,-5489,-4945,-4047,-3376,-3356,-3712,-3684,-2884,-1688,-665,68,671,1076,1105,996,1315,2195,3014,3080,2431,1722,1455,1561,1633,1359,736,78,-198,38,419,417,-89,-737,-1165,-1356,-1450,-1438,-1252,-1016,-971,-1156,-1366,-1438,-1422,-1412,-1361,-1158,-817,-478,-259,-180,-195,-221,-154,77,422,728,862,805,647,476,316,139,-79,-316,-524,-661,-710,-668,-559,-456,-439,-510,-574,-539,-416,-290,-213,-171,-142,-136,-152,-157,-128,-83,-44,-2,51,80,43,-48,-123,-136,-100,-53,-14,4,-19,-91,-179,-236,-250,-243,-230,-208,-179,-150,-121,-86,-48,-29,-42,-79,-121,-155,-182,-202,-213,-219,-214,-184,-124,-55,-8,5,-7,-30,-55,-73,-83,-92,-109,-124,-116,-79,-34,-8,-9,-34,-78,-134,-187,-223,-238,-236,-222,-199,-179,-175,-188,-202,-205,-200,-193,-181,-155,-119,-85,-64,-57,-61,-70,-73,-63,-49,-44,-52,-61,-65,-67,-71,-75,-77,-80,-90,-106,-122,-130,-134,-138,-142,-143,-144,-146,-145,-138,-131,-129,-125,-107,-74,-35,3,41,77,97,96,89,91,95,79,39}
        },
        {    // H40e148a.wav
            {3,2,0,-1,-1,-1,-2,-3,-2,0,1,1,1,0,-1,-2,-2,-2,-2,-2,0,3,3,0,-1,1,0,-5,-7,-2,0,-6,-11,-2,9,4,-7,2,12,-2,67,504,1504,2779,3506,2823,521,-2680,-5486,-6741,-5985,-3581,-390,2727,5236,6892,7518,6984,5453,3535,2032,1435,1651,2177,2474,2232,1460,444,-420,-889,-1040,-1161,-1460,-1901,-2298,-2508,-2518,-2408,-2271,-2164,-2095,-2027,-1905,-1676,-1321,-913,-611,-535,-593,-510,-87,591,1258,1731,1999,2073,1907,1535,1168,1024,1075,1077,867,530,247,54,-170,-520,-950,-1318,-1494,-1413,-1114,-746,-506,-499,-670,-862,-943,-869,-665,-403,-177,-57,-36,-43,-21,18,32,12,-1,24,71,97,83,54,44,65,101,125,118,74,-5,-110,-227,-330,-387,-382,-338,-311,-348,-441,-544,-623,-688,-751,-787,-741,-598,-410,-258,-183,-170,-182,-195,-194,-161,-87,6,79,106,97,75,51,19,-31,-99,-166,-209,-213,-192,-175,-184,-213,-244,-262,-262,-252,-235,-218,-209,-213,-224,-237,-247,-248,-235,-209,-177,-144,-110,-76,-51,-40,-40,-42,-42,-40,-36,-30,-24,-21,-21,-26,-41,-65,-90,-108,-124,-142,-158,-166,-168,-171,-171,-159,-135,-107,-82,-59,-42,-39,-49,-58,-60,-61,-66,-68,-60,-54,-58,-66,-70,-75,-85,-90,-83,-78,-84,-91,-89,-97,-137,-180,-166,-86},
            {0,7,10,5,0,-1,-1,-6,-12,-11,-3,0,-4,-5,1,1,-10,-7,14,-6,-28,369,1863,4556,7099,7096,3033,-3915,-10292,-12932,-11228,-6896,-1827,3397,8858,13794,16388,15234,10780,5197,915,-708,269,2728,4992,5461,3481,-111,-3493,-5220,-5218,-4505,-4117,-4372,-4939,-5287,-5058,-4304,-3515,-3221,-3420,-3530,-3036,-2054,-1077,-346,243,718,926,940,1183,1876,2597,2714,2186,1612,1494,1702,1761,1427,855,349,118,177,345,353,62,-419,-881,-1215,-1415,-1455,-1320,-1122,-1058,-1196,-1402,-1505,-1469,-1355,-1201,-1008,-797,-599,-422,-270,-170,-130,-82,70,331,596,751,761,670,542,420,306,155,-72,-354,-603,-736,-732,-627,-491,-398,-393,-453,-504,-496,-441,-373,-302,-228,-172,-157,-172,-179,-164,-137,-107,-61,-5,21,-6,-54,-74,-55,-23,-4,-2,-19,-57,-106,-144,-160,-163,-170,-183,-192,-187,-162,-118,-67,-35,-41,-82,-137,-184,-214,-229,-237,-244,-247,-233,-187,-120,-64,-40,-42,-48,-46,-43,-50,-70,-101,-128,-131,-100,-49,-3,16,5,-31,-82,-138,-186,-218,-231,-226,-203,-172,-153,-159,-184,-208,-223,-231,-228,-205,-161,-115,-83,-69,-65,-68,-71,-67,-53,-40,-37,-40,-40,-38,-45,-62,-84,-105,-123,-134,-132,-123,-118,-123,-132,-136,-134,-131,-131,-137,-148,-153,-137,-101,-62,-29,5,43,72,79,75,79,87,76,39}
        },
        {    // H40e154a.wav
            {1,-1,-2,-2,-2,-2,-2,0,2,3,2,1,-1,-2,-2,-1,0,0,2,4,2,-1,-1,2,1,-6,-7,0,3,-5,-10,1,10,0,-9,8,19,2,121,720,1952,3342,3861,2626,-329,-3916,-6612,-7317,-5848,-2858,653,3865,6346,7878,8228,7244,5214,2972,1471,1152,1717,2454,2725,2267,1231,50,-824,-1224,-1343,-1505,-1851,-2274,-2588,-2698,-2628,-2471,-2331,-2262,-2219,-2104,-1869,-1540,-1152,-734,-380,-227,-286,-337,-110,433,1075,1590,1913,2050,1958,1638,1255,1030,995,964,781,498,263,99,-113,-467,-915,-1325,-1578,-1608,-1411,-1073,-760,-611,-636,-726,-765,-704,-558,-362,-158,7,104,145,165,180,178,149,104,62,29,2,-11,8,60,117,138,104,29,-64,-158,-245,-313,-352,-359,-346,-331,-337,-385,-482,-613,-742,-820,-805,-685,-495,-306,-183,-148,-174,-219,-253,-256,-215,-133,-40,28,58,56,34,-3,-47,-79,-86,-68,-43,-33,-52,-99,-158,-209,-239,-249,-248,-240,-231,-227,-233,-246,-259,-269,-275,-275,-262,-235,-201,-171,-144,-118,-91,-65,-44,-30,-25,-26,-28,-25,-14,1,11,8,-9,-34,-62,-91,-118,-134,-137,-138,-149,-170,-191,-200,-194,-173,-139,-102,-76,-67,-68,-69,-69,-68,-66,-60,-48,-31,-14,-8,-22,-51,-77,-91,-98,-104,-103,-94,-86,-91,-103,-114,-128,-152,-165,-135,-64},
            {-3,-3,2,9,10,4,-1,0,1,-5,-13,-10,1,3,-8,-11,4,9,-9,-14,9,-1,8,491,2095,4751,6953,6430,2088,-4608,-10421,-12697,-10992,-6611,-1041,4861,10393,14405,15614,13555,9105,4093,404,-806,467,3055,5111,5100,2759,-727,-3612,-4837,-4608,-3931,-3691,-4094,-4738,-5041,-4699,-3917,-3249,-3085,-3253,-3214,-2665,-1811,-1022,-412,110,551,845,1090,1479,1952,2159,1929,1570,1505,1737,1871,1640,1185,789,545,388,293,265,216,-4,-423,-894,-1241,-1396,-1392,-1301,-1215,-1221,-1341,-1499,-1570,-1475,-1230,-928,-680,-544,-490,-444,-352,-205,-19,177,340,437,481,523,587,639,624,525,355,129,-131,-374,-538,-601,-584,-521,-434,-354,-319,-345,-408,-476,-527,-540,-494,-396,-299,-250,-243,-240,-227,-222,-226,-207,-145,-63,-2,28,42,52,55,46,27,-4,-42,-70,-69,-45,-30,-51,-103,-161,-198,-200,-166,-114,-75,-74,-111,-165,-212,-244,-268,-299,-334,-350,-317,-233,-132,-59,-31,-37,-54,-68,-75,-78,-83,-93,-98,-80,-37,9,34,26,-8,-57,-110,-151,-171,-175,-174,-172,-167,-162,-165,-179,-197,-210,-216,-218,-210,-187,-154,-125,-112,-112,-116,-111,-90,-57,-23,-3,-1,-11,-27,-45,-65,-86,-110,-136,-156,-161,-151,-135,-120,-109,-100,-95,-98,-110,-127,-142,-142,-123,-91,-58,-27,2,24,33,33,39,49,47,25}
        },
        {    // H40e161a.wav
            {-3,-3,-2,-2,-1,0,0,1,2,2,0,-3,-3,-1,0,-1,1,4,4,-1,-2,2,2,-6,-10,-2,4,-4,-12,-2,11,1,-13,4,25,5,92,669,1970,3544,4252,3039,-142,-4112,-7147,-7983,-6401,-3134,693,4167,6834,8498,8915,7870,5605,3024,1252,872,1581,2535,2953,2501,1341,-23,-1043,-1485,-1565,-1694,-2066,-2534,-2842,-2886,-2748,-2565,-2434,-2376,-2332,-2206,-1946,-1579,-1152,-693,-269,-19,-19,-132,-81,284,860,1432,1861,2087,2049,1738,1304,987,888,871,740,474,217,74,-22,-227,-618,-1118,-1549,-1742,-1639,-1333,-1013,-830,-799,-824,-798,-682,-502,-306,-135,-12,74,161,271,374,406,337,208,95,39,35,65,116,162,162,102,18,-47,-99,-176,-283,-377,-417,-408,-380,-352,-348,-412,-571,-779,-927,-931,-795,-587,-374,-201,-102,-92,-142,-191,-194,-152,-95,-45,-8,13,10,-19,-61,-98,-111,-87,-29,33,55,17,-62,-141,-187,-195,-180,-166,-173,-205,-251,-292,-313,-311,-294,-277,-268,-268,-267,-252,-218,-177,-141,-115,-95,-77,-59,-38,-18,-6,-3,-2,2,11,21,27,19,-9,-51,-88,-108,-117,-126,-140,-154,-166,-176,-183,-182,-174,-165,-158,-146,-127,-104,-83,-69,-64,-67,-71,-66,-48,-26,-9,1,0,-16,-43,-69,-86,-99,-111,-113,-104,-100,-113,-127,-119,-102,-106,-125,-116,-61},
            {-5,-2,0,0,2,6,7,2,-1,1,1,-8,-16,-8,4,0,-13,-9,9,5,-18,-11,17,-2,80,826,2757,5386,6878,5214,70,-6476,-11304,-12393,-9765,-4744,1242,7099,11834,14452,14307,11519,7082,2593,-300,-641,1244,3806,5157,4249,1485,-1677,-3801,-4372,-3921,-3411,-3475,-4068,-4663,-4739,-4205,-3451,-2994,-2994,-3122,-2934,-2328,-1566,-909,-372,141,625,1014,1308,1531,1625,1542,1418,1480,1736,1913,1784,1436,1104,861,622,385,261,253,172,-140,-603,-1007,-1250,-1371,-1408,-1361,-1285,-1299,-1443,-1589,-1559,-1311,-963,-668,-496,-432,-421,-393,-288,-91,137,305,372,384,418,506,609,661,616,459,215,-41,-219,-282,-284,-307,-370,-418,-409,-368,-351,-375,-425,-490,-567,-630,-639,-584,-501,-423,-356,-297,-264,-265,-273,-244,-169,-77,8,83,140,157,127,73,29,8,7,23,50,65,40,-27,-107,-166,-193,-192,-171,-142,-123,-131,-166,-216,-267,-313,-354,-384,-391,-365,-303,-219,-140,-87,-62,-54,-51,-51,-55,-61,-67,-69,-64,-45,-14,17,31,20,-15,-63,-110,-143,-157,-158,-156,-155,-155,-156,-160,-166,-171,-178,-190,-201,-200,-184,-162,-147,-140,-136,-129,-114,-86,-48,-12,6,2,-17,-42,-69,-98,-125,-145,-154,-154,-148,-137,-121,-102,-83,-70,-68,-78,-95,-108,-110,-103,-88,-66,-39,-14,1,8,13,17,16,8}
        },
        {    // H40e167a.wav
            {-4,-5,-3,-1,1,2,2,0,-3,-5,-3,-1,-2,-3,1,5,3,-3,-4,0,-2,-11,-12,-1,3,-9,-15,0,11,-6,-20,6,26,5,165,962,2558,4248,4642,2697,-1283,-5664,-8488,-8611,-6153,-2169,2069,5665,8241,9631,9580,7922,5090,2246,636,706,1847,2964,3226,2431,937,-601,-1596,-1897,-1862,-1992,-2450,-2976,-3228,-3119,-2830,-2589,-2501,-2516,-2492,-2304,-1936,-1468,-978,-490,-54,209,226,111,111,383,874,1414,1854,2092,2067,1798,1414,1067,813,610,418,250,123,13,-126,-332,-625,-994,-1364,-1608,-1641,-1491,-1272,-1087,-970,-901,-834,-726,-559,-357,-164,-7,120,231,324,394,434,431,365,250,154,147,230,318,321,222,79,-44,-128,-190,-249,-308,-357,-388,-402,-416,-461,-566,-724,-880,-961,-927,-795,-619,-456,-342,-289,-274,-251,-181,-72,33,97,118,109,74,11,-66,-127,-145,-110,-33,52,100,79,-3,-104,-179,-207,-190,-149,-117,-120,-163,-227,-289,-336,-361,-365,-353,-338,-324,-304,-270,-226,-185,-152,-122,-98,-87,-87,-83,-67,-43,-19,1,19,35,46,45,31,5,-28,-61,-90,-111,-122,-126,-131,-142,-158,-172,-180,-184,-184,-182,-180,-180,-175,-159,-134,-113,-104,-104,-101,-89,-69,-45,-24,-14,-15,-19,-24,-37,-60,-81,-92,-97,-104,-110,-113,-119,-131,-133,-115,-97,-110,-138,-129,-67},
            {1,-2,-4,-2,-1,-1,2,7,8,1,-3,1,3,-7,-17,-10,4,0,-15,-10,12,9,-19,-15,19,7,70,744,2546,5039,6497,4998,190,-6042,-10773,-11975,-9477,-4486,1431,6959,11142,13336,13213,10843,6879,2656,-176,-548,1234,3601,4771,3890,1425,-1343,-3218,-3763,-3412,-3007,-3138,-3758,-4345,-4414,-3924,-3263,-2873,-2863,-2951,-2782,-2269,-1614,-1023,-498,55,614,1025,1187,1160,1094,1119,1289,1566,1813,1884,1747,1499,1237,969,691,463,339,253,74,-237,-599,-927,-1196,-1379,-1426,-1360,-1312,-1387,-1520,-1547,-1387,-1112,-840,-633,-499,-422,-359,-252,-93,56,132,153,199,317,479,619,684,647,508,303,106,-12,-32,4,19,-44,-183,-338,-436,-455,-435,-437,-491,-584,-679,-746,-772,-759,-711,-632,-528,-413,-310,-234,-188,-165,-151,-119,-39,83,196,239,199,115,45,26,62,132,188,181,100,-19,-126,-193,-220,-212,-180,-151,-157,-201,-257,-302,-335,-367,-395,-405,-393,-363,-319,-261,-192,-125,-70,-31,-10,-9,-28,-55,-78,-87,-74,-38,9,45,52,31,-7,-51,-94,-128,-148,-153,-150,-142,-129,-118,-117,-129,-148,-168,-186,-199,-201,-188,-167,-151,-145,-144,-139,-126,-105,-80,-56,-40,-36,-40,-51,-67,-89,-114,-137,-152,-155,-140,-109,-74,-49,-43,-54,-72,-87,-93,-91,-86,-83,-79,-68,-51,-33,-20,-12,-6,-2}
        },
        {    // H40e174a.wav
            {-3,-1,2,3,3,2,-1,-4,-3,0,0,-1,1,6,6,0,-2,2,1,-9,-13,-3,5,-6,-16,-2,15,0,-22,-1,30,9,121,859,2510,4445,5156,3343,-866,-5757,-9103,-9508,-6999,-2691,1997,6008,8861,10389,10380,8656,5587,2352,383,349,1690,3126,3586,2761,1064,-725,-1907,-2258,-2143,-2160,-2593,-3206,-3555,-3439,-3030,-2657,-2524,-2587,-2633,-2469,-2074,-1563,-1030,-480,48,406,470,335,262,431,810,1270,1707,2021,2088,1874,1521,1212,975,710,391,132,10,-60,-208,-446,-693,-925,-1176,-1420,-1548,-1501,-1360,-1242,-1169,-1080,-940,-774,-605,-426,-240,-80,35,134,247,354,403,385,352,355,394,436,452,426,344,211,69,-23,-52,-69,-129,-228,-318,-375,-425,-505,-622,-756,-874,-939,-920,-821,-699,-612,-565,-518,-442,-350,-261,-166,-49,73,158,184,160,104,30,-37,-53,0,87,143,131,64,-20,-92,-139,-159,-160,-154,-153,-160,-175,-201,-235,-272,-307,-340,-370,-389,-390,-372,-340,-295,-239,-180,-129,-93,-73,-64,-62,-62,-62,-60,-49,-24,10,42,59,59,43,17,-17,-52,-78,-95,-111,-127,-135,-132,-130,-138,-152,-162,-170,-181,-191,-191,-179,-165,-158,-156,-155,-148,-131,-101,-68,-45,-35,-32,-31,-32,-37,-41,-45,-54,-66,-72,-68,-67,-80,-102,-119,-128,-130,-124,-109,-99,-106,-117,-100,-50},
            {5,4,0,-4,-3,0,1,1,5,10,8,1,-1,3,2,-9,-14,-2,9,-1,-15,-3,17,4,-23,-6,28,9,129,958,2871,5183,6101,4004,-1002,-6827,-10756,-11158,-8144,-3029,2596,7483,10899,12486,12064,9659,5858,2015,-257,-142,1730,3725,4366,3208,888,-1462,-2918,-3238,-2901,-2671,-2983,-3657,-4156,-4107,-3591,-3009,-2710,-2725,-2786,-2606,-2136,-1550,-999,-458,136,682,975,954,809,795,997,1315,1618,1826,1893,1790,1542,1238,962,732,514,290,79,-110,-315,-589,-919,-1207,-1356,-1376,-1369,-1405,-1452,-1434,-1332,-1181,-1008,-822,-646,-511,-398,-248,-52,114,168,123,79,126,283,504,699,771,671,450,222,77,28,43,82,100,51,-80,-255,-413,-524,-591,-631,-659,-698,-759,-821,-843,-810,-743,-665,-574,-460,-335,-224,-140,-76,-30,-2,18,50,102,156,185,179,154,137,143,163,169,134,58,-37,-127,-200,-243,-245,-213,-183,-188,-232,-288,-335,-370,-396,-410,-406,-385,-354,-312,-254,-184,-114,-59,-27,-18,-27,-47,-68,-78,-69,-42,-5,29,49,48,27,-10,-53,-90,-114,-125,-129,-126,-118,-110,-113,-128,-147,-159,-164,-169,-175,-179,-176,-170,-167,-167,-168,-164,-151,-126,-94,-68,-54,-50,-50,-55,-66,-82,-97,-111,-122,-122,-101,-66,-39,-36,-57,-85,-103,-105,-96,-85,-80,-81,-82,-78,-71,-60,-41,-18}
        },
        {    // H40e180a.wav
            {0,1,3,3,-1,-5,-5,-2,-1,-2,1,7,7,0,-4,1,2,-8,-16,-7,5,-3,-17,-8,13,5,-22,-10,26,10,78,729,2374,4526,5631,4112,-187,-5576,-9569,-10449,-8062,-3523,1632,6170,9440,11199,11266,9501,6237,2632,243,-17,1428,3188,3934,3169,1297,-786,-2229,-2690,-2499,-2345,-2674,-3344,-3848,-3830,-3366,-2833,-2563,-2599,-2706,-2604,-2214,-1672,-1122,-563,31,532,735,631,475,529,820,1204,1567,1865,2017,1924,1618,1276,1021,798,509,199,-5,-95,-219,-486,-822,-1080,-1220,-1315,-1407,-1454,-1415,-1323,-1237,-1157,-1041,-877,-695,-514,-326,-136,21,117,166,192,203,213,273,420,606,709,651,472,277,136,57,27,33,46,17,-77,-213,-355,-491,-622,-736,-814,-851,-861,-849,-812,-756,-700,-653,-594,-504,-390,-276,-171,-66,39,116,137,107,60,36,54,106,166,201,192,143,78,20,-27,-73,-126,-181,-225,-243,-235,-212,-194,-199,-237,-302,-372,-420,-434,-418,-387,-347,-300,-245,-190,-142,-103,-74,-55,-48,-51,-56,-58,-52,-36,-8,22,41,38,20,-2,-23,-45,-70,-95,-114,-126,-133,-136,-137,-139,-142,-148,-156,-166,-175,-181,-185,-187,-189,-189,-185,-174,-151,-121,-89,-63,-52,-55,-61,-60,-55,-53,-58,-65,-73,-79,-78,-68,-61,-70,-93,-112,-114,-106,-103,-106,-108,-107,-105,-97,-72,-33},
            {0,1,3,3,-1,-5,-5,-2,-1,-2,1,7,7,0,-4,1,2,-8,-16,-7,5,-3,-17,-8,13,5,-22,-10,26,10,78,729,2374,4526,5631,4112,-187,-5576,-9569,-10449,-8062,-3523,1632,6170,9440,11199,11266,9501,6237,2632,243,-17,1428,3188,3934,3169,1297,-786,-2229,-2690,-2499,-2345,-2674,-3344,-3848,-3830,-3366,-2833,-2563,-2599,-2706,-2604,-2214,-1672,-1122,-563,31,532,735,631,475,529,820,1204,1567,1865,2017,1924,1618,1276,1021,798,509,199,-5,-95,-219,-486,-822,-1080,-1220,-1315,-1407,-1454,-1415,-1323,-1237,-1157,-1041,-877,-695,-514,-326,-136,21,117,166,192,203,213,273,420,606,709,651,472,277,136,57,27,33,46,17,-77,-213,-355,-491,-622,-736,-814,-851,-861,-849,-812,-756,-700,-653,-594,-504,-390,-276,-171,-66,39,116,137,107,60,36,54,106,166,201,192,143,78,20,-27,-73,-126,-181,-225,-243,-235,-212,-194,-199,-237,-302,-372,-420,-434,-418,-387,-347,-300,-245,-190,-142,-103,-74,-55,-48,-51,-56,-58,-52,-36,-8,22,41,38,20,-2,-23,-45,-70,-95,-114,-126,-133,-136,-137,-139,-142,-148,-156,-166,-175,-181,-185,-187,-189,-189,-185,-174,-151,-121,-89,-63,-52,-55,-61,-60,-55,-53,-58,-65,-73,-79,-78,-68,-61,-70,-93,-112,-114,-106,-103,-106,-108,-107,-105,-97,-72,-33}
        }
    },
    {    // elev50
        {    // H50e000a.wav
            {-2,33,11,-50,-36,48,44,-68,-80,69,114,-72,-161,72,215,-71,-63,1289,3569,4997,4733,3734,2378,-1208,-8244,-15314,-16165,-8616,2334,9891,12517,13616,15329,15577,11792,5122,-659,-3132,-2607,-500,1842,2963,1816,-944,-3291,-4113,-4366,-5329,-6532,-6412,-4659,-2792,-2280,-2911,-3447,-3266,-2745,-2308,-1815,-1021,-137,433,719,1157,1928,2625,2748,2340,1920,1872,2101,2270,2155,1726,1090,477,117,9,-78,-265,-371,-261,-229,-718,-1668,-2431,-2487,-2009,-1567,-1442,-1429,-1229,-791,-263,169,361,278,86,65,324,673,849,811,709,622,462,169,-117,-178,41,378,612,628,444,157,-88,-161,-52,87,74,-132,-400,-579,-646,-688,-775,-909,-1068,-1241,-1403,-1499,-1473,-1323,-1098,-862,-660,-513,-414,-321,-190,-23,116,160,121,86,121,201,250,235,196,181,195,206,183,105,-29,-182,-286,-300,-251,-207,-201,-221,-247,-279,-310,-324,-328,-355,-411,-453,-437,-373,-303,-249,-206,-177,-174,-188,-187,-157,-115,-78,-33,34,110,172,210,223,202,142,58,-13,-51,-65,-76,-90,-101,-107,-116,-141,-187,-240,-276,-280,-259,-229,-200,-171,-146,-131,-130,-134,-132,-122,-113,-111,-117,-123,-119,-100,-75,-63,-70,-86,-92,-83,-70,-64,-64,-59,-44,-26,-16,-23,-41,-58,-64,-64,-66,-74,-81,-83,-89,-104,-122,-131,-126,-111,-90,-62,-38,-32,-41,-44,-26},
            {-2,33,11,-50,-36,48,44,-68,-80,69,114,-72,-161,72,215,-71,-63,1289,3569,4997,4733,3734,2378,-1208,-8244,-15314,-16165,-8616,2334,9891,12517,13616,15329,15577,11792,5122,-659,-3132,-2607,-500,1842,2963,1816,-944,-3291,-4113,-4366,-5329,-6532,-6412,-4659,-2792,-2280,-2911,-3447,-3266,-2745,-2308,-1815,-1021,-137,433,719,1157,1928,2625,2748,2340,1920,1872,2101,2270,2155,1726,1090,477,117,9,-78,-265,-371,-261,-229,-718,-1668,-2431,-2487,-2009,-1567,-1442,-1429,-1229,-791,-263,169,361,278,86,65,324,673,849,811,709,622,462,169,-117,-178,41,378,612,628,444,157,-88,-161,-52,87,74,-132,-400,-579,-646,-688,-775,-909,-1068,-1241,-1403,-1499,-1473,-1323,-1098,-862,-660,-513,-414,-321,-190,-23,116,160,121,86,121,201,250,235,196,181,195,206,183,105,-29,-182,-286,-300,-251,-207,-201,-221,-247,-279,-310,-324,-328,-355,-411,-453,-437,-373,-303,-249,-206,-177,-174,-188,-187,-157,-115,-78,-33,34,110,172,210,223,202,142,58,-13,-51,-65,-76,-90,-101,-107,-116,-141,-187,-240,-276,-280,-259,-229,-200,-171,-146,-131,-130,-134,-132,-122,-113,-111,-117,-123,-119,-100,-75,-63,-70,-86,-92,-83,-70,-64,-64,-59,-44,-26,-16,-23,-41,-58,-64,-64,-66,-74,-81,-83,-89,-104,-122,-131,-126,-111,-90,-62,-38,-32,-41,-44,-26}
        },
        {    // H50e008a.wav
            {20,6,-11,7,30,1,-42,-14,44,13,-70,-42,76,61,-90,-88,117,133,-111,155,1577,3440,4326,3942,3100,1597,-2293,-8828,-14386,-14188,-7619,898,6915,10258,13230,16050,16225,12242,5951,654,-1932,-2139,-961,609,1455,895,-532,-1641,-2126,-2815,-4188,-5394,-5303,-4087,-3054,-3029,-3499,-3515,-2927,-2346,-2167,-2096,-1675,-887,-54,643,1246,1730,1939,1867,1755,1791,1891,1929,1996,2190,2298,1991,1313,681,340,111,-213,-523,-672,-837,-1297,-1924,-2252,-2072,-1685,-1453,-1362,-1166,-789,-380,-73,106,145,47,-65,-3,259,524,611,554,503,480,366,104,-154,-185,77,482,806,902,750,426,74,-148,-180,-124,-162,-358,-589,-689,-644,-594,-667,-861,-1089,-1276,-1383,-1379,-1245,-1013,-768,-592,-511,-492,-468,-371,-177,58,223,231,100,-64,-159,-153,-81,6,72,108,125,140,150,119,17,-130,-247,-279,-243,-195,-180,-206,-260,-319,-357,-359,-341,-337,-356,-381,-394,-392,-374,-329,-259,-193,-156,-138,-113,-70,-25,7,32,66,108,145,167,176,173,151,104,39,-22,-60,-77,-92,-121,-158,-189,-210,-223,-227,-219,-204,-194,-188,-173,-145,-126,-136,-171,-202,-206,-182,-142,-100,-64,-35,-14,-5,-14,-43,-85,-127,-154,-158,-141,-110,-66,-13,35,58,46,5,-45,-90,-121,-132,-121,-98,-74,-56,-45,-46,-67,-102,-136,-154,-152,-131,-90,-38},
            {31,-48,-66,33,78,-41,-118,27,155,-13,-208,-18,260,34,-222,844,3363,5479,5659,4611,3276,-6,-7432,-16458,-19744,-12715,463,11032,14976,15521,16575,17137,13888,6884,-21,-3586,-3698,-1791,875,2846,2452,-433,-3662,-5117,-5150,-5593,-6826,-7231,-5694,-3330,-2087,-2411,-3135,-3254,-2905,-2582,-2186,-1331,-159,715,1029,1221,1777,2546,2959,2778,2350,2117,2158,2258,2207,1893,1289,552,-9,-236,-302,-416,-473,-284,-75,-393,-1382,-2443,-2849,-2518,-1972,-1645,-1509,-1311,-923,-395,124,436,413,187,93,322,696,913,913,874,877,759,382,-95,-337,-189,175,454,506,400,268,172,106,51,-2,-62,-142,-245,-365,-497,-644,-808,-977,-1137,-1290,-1445,-1598,-1715,-1728,-1567,-1216,-758,-353,-144,-150,-254,-286,-163,63,274,397,436,426,393,360,345,341,320,270,207,142,47,-98,-254,-355,-389,-390,-374,-324,-249,-206,-241,-329,-409,-451,-456,-425,-362,-301,-274,-266,-242,-196,-159,-147,-139,-115,-87,-66,-36,23,99,163,201,213,198,151,80,5,-59,-106,-131,-135,-128,-125,-135,-163,-209,-263,-300,-298,-264,-225,-199,-182,-160,-132,-111,-105,-107,-107,-100,-93,-97,-110,-119,-114,-105,-102,-102,-90,-63,-39,-37,-57,-79,-85,-70,-44,-23,-19,-33,-54,-72,-83,-89,-94,-100,-110,-121,-125,-118,-99,-74,-51,-37,-33,-33,-29,-26,-29,-36,-32,-15}
        },
        {    // H50e016a.wav
            {-6,6,16,3,-10,8,24,-2,-33,-6,34,1,-59,-25,62,36,-76,-49,104,77,-96,239,1497,3001,3676,3409,2784,1417,-2103,-7698,-12220,-11948,-6644,178,5241,8485,11429,13917,14011,10785,5813,1572,-669,-1052,-228,975,1548,929,-372,-1371,-1844,-2450,-3560,-4550,-4611,-3859,-3180,-3095,-3252,-3077,-2572,-2191,-2140,-2108,-1708,-938,-106,552,1016,1321,1467,1507,1557,1653,1721,1756,1884,2129,2237,1930,1293,703,377,195,-14,-231,-419,-707,-1199,-1702,-1888,-1702,-1422,-1285,-1226,-1064,-780,-496,-292,-162,-102,-107,-103,2,189,330,349,309,297,298,227,72,-54,-11,233,571,834,895,737,442,129,-109,-243,-305,-342,-384,-438,-505,-590,-701,-831,-961,-1069,-1142,-1167,-1129,-1020,-848,-646,-465,-359,-347,-387,-398,-319,-158,12,106,95,10,-95,-178,-219,-204,-132,-30,56,96,91,56,-5,-86,-164,-214,-233,-240,-248,-255,-259,-275,-314,-368,-413,-429,-408,-360,-311,-286,-281,-270,-240,-198,-156,-112,-63,-22,-2,10,35,72,101,113,120,129,131,115,85,50,10,-38,-83,-111,-119,-129,-154,-192,-225,-241,-237,-225,-214,-205,-189,-168,-151,-146,-150,-156,-161,-156,-134,-97,-65,-49,-41,-31,-27,-46,-82,-111,-120,-120,-119,-107,-73,-25,13,27,15,-16,-53,-81,-94,-103,-112,-113,-101,-85,-77,-70,-60,-66,-104,-147,-140,-73},
            {-72,11,86,-9,-137,-35,163,78,-199,-138,229,181,-269,261,2639,5425,6451,5691,4467,1833,-5168,-15782,-22644,-18275,-4114,10174,17049,17850,17974,18544,16116,9199,1246,-3448,-4076,-2457,-106,2042,2545,405,-3143,-5612,-6216,-6433,-7356,-7924,-6657,-4101,-2303,-2240,-2917,-3055,-2639,-2362,-2274,-1769,-657,480,1128,1496,2043,2695,2955,2687,2338,2324,2528,2574,2328,1897,1344,691,102,-235,-386,-542,-643,-453,-103,-185,-1052,-2250,-2950,-2847,-2350,-1949,-1710,-1437,-1029,-534,-42,328,439,316,221,383,711,923,928,911,1006,1049,789,247,-261,-455,-337,-88,171,418,602,605,382,65,-146,-188,-168,-204,-300,-401,-502,-651,-855,-1064,-1255,-1480,-1783,-2089,-2216,-2003,-1450,-744,-166,66,-60,-332,-460,-305,29,331,490,557,613,652,621,516,396,310,263,238,214,146,-10,-227,-415,-498,-479,-409,-327,-266,-270,-350,-443,-473,-432,-381,-362,-358,-343,-318,-290,-246,-182,-123,-95,-86,-72,-49,-30,-10,28,84,142,194,235,252,216,124,8,-90,-151,-181,-192,-190,-180,-172,-182,-219,-272,-311,-316,-295,-273,-256,-229,-181,-123,-84,-73,-80,-91,-97,-98,-97,-99,-104,-106,-104,-100,-93,-77,-55,-40,-46,-68,-88,-91,-74,-45,-19,-11,-24,-49,-81,-113,-140,-156,-157,-146,-129,-109,-83,-55,-35,-31,-38,-41,-30,-8,10,11,-3,-19,-23,-16,-6}
        },
        {    // H50e024a.wav
            {0,-4,-5,5,11,-1,-9,7,18,-6,-28,-5,24,-5,-48,-16,50,24,-60,-33,79,45,-74,248,1303,2531,3116,2996,2571,1423,-1607,-6384,-10301,-10338,-6237,-702,3687,6768,9579,11922,12279,9906,5974,2421,368,-151,379,1223,1526,881,-246,-1068,-1450,-1964,-2935,-3877,-4105,-3624,-3073,-2895,-2907,-2733,-2377,-2140,-2126,-2063,-1660,-957,-236,310,691,968,1147,1260,1380,1515,1587,1589,1651,1844,1993,1849,1415,950,649,459,257,31,-204,-526,-987,-1436,-1634,-1542,-1360,-1266,-1228,-1123,-922,-698,-504,-338,-205,-135,-127,-133,-106,-31,90,238,354,363,252,102,35,128,362,636,820,827,665,420,185,-4,-163,-313,-437,-509,-537,-564,-630,-739,-861,-954,-994,-985,-949,-902,-840,-748,-621,-483,-370,-308,-295,-303,-292,-234,-132,-26,32,18,-50,-130,-191,-222,-218,-176,-103,-24,24,14,-48,-125,-181,-213,-245,-292,-337,-352,-334,-306,-291,-302,-333,-364,-372,-346,-292,-231,-180,-146,-127,-119,-111,-91,-59,-28,-7,7,25,46,64,78,92,105,109,99,74,36,-13,-64,-100,-117,-125,-142,-171,-204,-232,-251,-257,-247,-223,-193,-167,-147,-129,-114,-109,-118,-130,-130,-115,-95,-80,-67,-51,-37,-35,-50,-78,-106,-123,-121,-103,-79,-55,-31,-9,1,-12,-44,-78,-102,-114,-116,-112,-109,-108,-101,-83,-66,-67,-79,-72,-38},
            {51,26,-100,-89,118,164,-110,-233,107,315,-124,-224,1523,4646,6772,6763,5787,3974,-1657,-12639,-23326,-24026,-11611,5842,17406,20285,19727,19760,18365,12474,3843,-2640,-4540,-3238,-850,1537,2762,1428,-2160,-5572,-6973,-7181,-7903,-8857,-8207,-5537,-2821,-1992,-2692,-3186,-2727,-2048,-1809,-1636,-947,60,804,1286,1993,2943,3465,3117,2364,2021,2281,2662,2695,2313,1637,805,72,-297,-368,-477,-683,-638,-223,1,-619,-1913,-2980,-3201,-2790,-2297,-1925,-1539,-1062,-576,-157,153,279,226,211,463,885,1125,1034,874,954,1197,1206,727,-66,-741,-949,-620,40,664,920,711,241,-156,-275,-173,-53,-62,-196,-356,-464,-533,-644,-873,-1227,-1632,-1995,-2235,-2275,-2041,-1525,-865,-315,-70,-130,-312,-396,-274,15,344,594,721,746,708,632,536,451,397,368,342,292,188,11,-214,-411,-511,-511,-450,-371,-305,-290,-343,-426,-473,-465,-439,-423,-399,-354,-306,-271,-225,-149,-72,-43,-57,-67,-46,-15,8,34,84,155,229,286,304,267,172,47,-68,-150,-197,-218,-227,-233,-234,-227,-225,-249,-298,-339,-347,-327,-300,-267,-213,-141,-82,-60,-67,-78,-81,-83,-97,-116,-123,-109,-80,-50,-25,-12,-18,-47,-86,-112,-111,-90,-65,-42,-18,0,-2,-32,-84,-141,-182,-194,-174,-135,-94,-67,-56,-54,-54,-55,-53,-40,-9,29,50,38,8,-14,-19,-24,-36,-40,-24}
        },
        {    // H50e032a.wav
            {-3,-2,0,-1,-1,6,8,-1,-6,7,14,-5,-22,-3,19,-4,-38,-13,39,20,-45,-26,56,28,-49,236,1103,2114,2646,2655,2411,1496,-1076,-5199,-8729,-9117,-6004,-1462,2402,5323,8018,10286,10885,9156,5995,3003,1179,599,852,1339,1427,842,-66,-730,-1073,-1540,-2395,-3268,-3588,-3285,-2827,-2616,-2593,-2487,-2251,-2071,-2027,-1937,-1588,-1006,-400,83,445,717,888,978,1068,1197,1321,1419,1569,1811,2004,1941,1607,1200,895,685,491,279,13,-397,-956,-1464,-1670,-1554,-1351,-1264,-1263,-1197,-1010,-780,-593,-469,-401,-381,-371,-306,-155,35,192,288,338,356,332,261,186,189,328,571,795,863,722,432,114,-136,-290,-375,-430,-480,-538,-621,-730,-839,-901,-887,-818,-755,-747,-787,-816,-776,-653,-487,-336,-243,-215,-227,-241,-227,-171,-89,-17,11,-12,-64,-121,-175,-231,-276,-278,-218,-124,-62,-81,-165,-255,-308,-329,-344,-355,-352,-329,-297,-271,-259,-259,-265,-267,-250,-213,-167,-127,-96,-72,-58,-57,-64,-66,-54,-32,-9,14,38,63,84,91,82,62,39,11,-26,-69,-103,-119,-125,-137,-165,-200,-226,-238,-238,-226,-202,-172,-146,-125,-105,-87,-80,-88,-102,-109,-104,-94,-89,-89,-84,-69,-52,-44,-51,-68,-88,-106,-115,-108,-85,-59,-42,-33,-29,-36,-63,-103,-134,-140,-127,-111,-100,-90,-81,-76,-70,-54,-26},
            {-13,-140,-17,189,65,-237,-122,295,180,-356,299,3018,6131,7414,6984,5919,2440,-6799,-19889,-27411,-20987,-3364,13603,21344,21701,20869,20197,16329,8309,165,-3942,-3938,-2123,155,2289,2767,289,-3944,-7123,-8157,-8480,-9250,-9437,-7657,-4698,-2764,-2669,-3128,-2850,-2093,-1699,-1575,-1003,41,839,1146,1591,2595,3559,3631,2904,2273,2258,2523,2568,2326,1920,1305,491,-201,-492,-547,-664,-733,-452,-39,-205,-1247,-2561,-3308,-3290,-2899,-2436,-1875,-1194,-570,-152,86,194,163,103,270,746,1223,1330,1121,1009,1206,1397,1089,203,-783,-1248,-939,-117,683,1022,797,237,-291,-534,-476,-278,-119,-78,-133,-220,-318,-483,-805,-1307,-1857,-2230,-2272,-2015,-1623,-1236,-900,-624,-437,-368,-379,-362,-217,67,404,669,786,760,660,560,501,476,457,422,376,333,267,128,-101,-356,-541,-609,-580,-489,-362,-249,-216,-285,-403,-498,-542,-541,-497,-415,-317,-235,-167,-96,-30,-5,-27,-59,-67,-51,-22,26,94,165,220,263,293,290,230,118,-5,-104,-172,-222,-259,-275,-265,-242,-231,-252,-299,-345,-369,-369,-348,-306,-243,-176,-122,-85,-70,-80,-107,-128,-126,-108,-94,-88,-73,-42,-14,-7,-19,-40,-63,-84,-94,-89,-77,-68,-61,-48,-35,-43,-85,-142,-177,-170,-132,-94,-77,-76,-76,-70,-64,-58,-47,-28,-6,9,14,6,-7,-18,-20,-14,-7,-5,-4,-1,2}
        },
        {    // H50e040a.wav
            {3,0,-4,-3,0,-1,-2,4,6,-2,-5,6,12,-5,-19,-2,17,-3,-32,-11,31,14,-40,-24,45,25,-34,204,922,1774,2266,2366,2269,1572,-613,-4242,-7510,-8189,-5819,-2016,1444,4218,6793,8959,9678,8399,5856,3380,1796,1162,1163,1381,1365,879,141,-433,-766,-1198,-1950,-2737,-3073,-2869,-2510,-2358,-2372,-2301,-2088,-1909,-1858,-1784,-1497,-1026,-566,-227,45,318,577,794,994,1192,1345,1443,1571,1792,1996,1993,1735,1362,1024,753,514,276,-25,-479,-1059,-1543,-1698,-1539,-1311,-1211,-1223,-1231,-1175,-1056,-862,-604,-372,-273,-292,-293,-171,46,262,421,513,517,407,224,99,152,381,653,801,732,479,164,-80,-196,-226,-263,-365,-517,-663,-761,-803,-800,-766,-724,-704,-720,-756,-778,-758,-687,-577,-452,-339,-256,-204,-176,-160,-141,-106,-55,-8,6,-24,-87,-161,-226,-274,-302,-312,-303,-284,-268,-266,-277,-291,-300,-306,-317,-335,-350,-345,-313,-259,-202,-160,-141,-137,-137,-138,-139,-135,-116,-82,-45,-23,-18,-21,-22,-19,-13,-3,12,31,44,40,18,-15,-48,-76,-102,-126,-146,-159,-165,-167,-167,-168,-174,-185,-194,-190,-171,-141,-108,-78,-56,-48,-58,-81,-104,-116,-114,-107,-100,-90,-75,-56,-43,-44,-59,-86,-119,-145,-152,-136,-108,-81,-61,-49,-48,-62,-87,-114,-136,-148,-146,-128,-101,-76,-58,-40,-18},
            {-122,118,203,-87,-278,52,358,-47,-379,1041,4223,6995,7824,7390,5748,-94,-12131,-25008,-27986,-15945,3801,18599,23117,21967,20754,19016,13590,5289,-1349,-3629,-2845,-1124,919,2692,2404,-862,-5251,-8066,-8915,-9364,-9943,-9367,-7003,-4416,-3443,-3785,-3721,-2638,-1581,-1351,-1322,-601,571,1368,1754,2405,3395,3900,3409,2553,2273,2621,2888,2632,2041,1394,725,92,-302,-445,-592,-805,-752,-301,3,-528,-1809,-3012,-3493,-3340,-2944,-2429,-1721,-927,-309,16,137,156,139,226,557,1036,1359,1374,1282,1327,1391,1094,318,-531,-906,-663,-131,308,538,600,458,53,-475,-817,-788,-509,-231,-78,-36,-103,-336,-758,-1297,-1827,-2198,-2251,-1919,-1350,-848,-628,-652,-718,-678,-525,-308,-54,210,423,528,531,502,512,570,621,605,515,404,334,322,317,236,32,-257,-520,-648,-620,-500,-374,-286,-247,-262,-323,-408,-486,-533,-537,-492,-399,-275,-148,-40,28,36,-10,-68,-83,-44,15,55,73,95,136,189,238,267,258,196,86,-43,-148,-212,-245,-260,-256,-232,-210,-222,-274,-335,-370,-376,-362,-333,-283,-215,-150,-107,-93,-108,-140,-160,-144,-99,-63,-59,-73,-76,-58,-36,-30,-41,-59,-68,-62,-49,-48,-67,-90,-99,-95,-96,-107,-120,-122,-112,-95,-77,-66,-67,-74,-74,-60,-39,-22,-13,-9,-10,-21,-40,-53,-49,-30,-10,3,11,16,16,8,-2,-5}
        },
        {    // H50e048a.wav
            {-3,0,4,3,-1,-1,0,-1,-1,4,6,-1,-3,7,11,-3,-13,3,16,-3,-25,-6,27,9,-35,-16,43,22,-26,188,809,1540,1984,2140,2149,1594,-347,-3637,-6677,-7477,-5560,-2252,914,3552,5968,7941,8631,7628,5567,3534,2177,1532,1374,1418,1331,911,293,-216,-548,-952,-1588,-2235,-2526,-2410,-2193,-2133,-2159,-2063,-1836,-1676,-1694,-1749,-1629,-1286,-839,-395,17,380,654,844,1011,1184,1321,1411,1527,1718,1882,1854,1596,1233,901,642,430,214,-98,-576,-1139,-1545,-1615,-1446,-1306,-1337,-1426,-1387,-1170,-864,-585,-409,-367,-408,-394,-210,106,383,497,484,455,446,393,255,103,63,191,414,587,596,419,134,-135,-290,-320,-304,-341,-466,-629,-746,-776,-742,-698,-678,-682,-693,-700,-697,-672,-612,-520,-416,-321,-237,-159,-90,-46,-32,-35,-41,-50,-66,-91,-128,-185,-257,-324,-366,-380,-379,-374,-361,-336,-310,-301,-310,-322,-323,-312,-292,-262,-221,-174,-136,-117,-113,-110,-100,-89,-87,-90,-82,-58,-26,0,18,26,21,1,-26,-45,-48,-41,-35,-40,-58,-87,-119,-144,-159,-163,-159,-149,-134,-119,-109,-110,-126,-148,-162,-154,-125,-87,-54,-33,-25,-29,-47,-76,-103,-113,-107,-91,-75,-65,-62,-63,-67,-77,-97,-123,-147,-161,-163,-150,-125,-97,-74,-59,-53,-59,-78,-102,-117,-118,-114,-110,-99,-70,-31},
            {111,102,-139,-186,167,301,-197,-273,1548,4835,7444,8284,7906,5443,-2353,-15860,-27629,-27083,-11858,8313,21210,23714,21558,19709,17168,11469,4115,-1030,-2555,-2009,-662,1437,3294,2592,-1416,-6322,-9211,-9812,-9762,-9658,-8602,-6455,-4712,-4477,-4844,-4273,-2793,-1704,-1495,-1275,-340,829,1574,2186,3220,4267,4331,3344,2418,2425,2987,3184,2714,1927,1125,377,-182,-407,-464,-650,-871,-736,-273,-134,-838,-2105,-3188,-3661,-3587,-3122,-2324,-1369,-609,-253,-173,-115,31,240,515,876,1252,1515,1616,1587,1411,993,346,-269,-512,-305,69,271,263,251,315,253,-123,-668,-1017,-981,-687,-364,-136,-66,-237,-679,-1266,-1781,-2059,-2028,-1693,-1174,-715,-524,-586,-691,-664,-501,-284,-45,213,433,516,434,280,194,251,416,586,666,624,503,370,258,150,13,-159,-336,-474,-546,-547,-479,-367,-262,-221,-264,-352,-429,-474,-495,-486,-428,-318,-189,-80,-2,45,52,17,-30,-44,-12,35,59,62,77,120,173,211,221,197,127,11,-119,-210,-243,-244,-238,-222,-190,-166,-190,-259,-326,-353,-347,-331,-306,-259,-194,-137,-109,-113,-136,-153,-142,-104,-69,-63,-79,-90,-85,-74,-70,-73,-76,-75,-68,-55,-49,-64,-95,-121,-126,-114,-101,-93,-90,-88,-85,-79,-71,-65,-60,-51,-37,-23,-11,1,9,-1,-26,-52,-66,-68,-62,-48,-27,-7,4,9,16,18,9,-4,-7}
        },
        {    // H50e056a.wav
            {-1,-2,-2,1,3,0,-2,1,2,-2,-3,3,5,-1,-3,5,7,-5,-10,6,15,-6,-25,-4,24,3,-31,-7,40,13,-16,210,779,1408,1795,1981,2041,1493,-409,-3514,-6272,-6918,-5109,-2057,897,3381,5566,7218,7694,6782,5080,3446,2330,1725,1475,1401,1274,927,425,-28,-380,-781,-1314,-1804,-2012,-1948,-1858,-1910,-2005,-1961,-1779,-1635,-1622,-1627,-1475,-1137,-707,-270,138,473,685,795,895,1031,1155,1223,1284,1401,1529,1540,1374,1095,804,546,317,88,-205,-627,-1140,-1563,-1707,-1559,-1300,-1125,-1074,-1047,-945,-775,-615,-511,-424,-281,-63,171,342,425,452,457,427,322,138,-56,-146,-57,181,437,555,460,204,-79,-263,-303,-253,-220,-286,-450,-628,-726,-718,-659,-624,-643,-686,-704,-678,-621,-553,-484,-416,-348,-278,-201,-120,-48,-5,2,-22,-67,-114,-145,-160,-186,-247,-331,-392,-403,-380,-361,-366,-385,-402,-402,-377,-326,-264,-214,-192,-195,-204,-200,-176,-142,-114,-95,-79,-60,-42,-31,-25,-19,-16,-14,-9,2,6,-9,-39,-70,-94,-111,-124,-129,-130,-134,-144,-154,-155,-147,-132,-114,-98,-88,-86,-90,-96,-104,-113,-116,-108,-87,-57,-26,-5,0,-11,-36,-69,-100,-115,-110,-95,-87,-88,-91,-93,-98,-111,-127,-143,-160,-175,-176,-160,-137,-117,-94,-64,-42,-40,-51,-59,-70,-98,-126,-116,-60},
            {130,-190,-221,196,326,-225,-311,1527,4820,7540,8666,8464,5626,-3012,-17063,-28417,-26740,-10575,9731,22095,23834,20910,18400,15613,10417,4157,-12,-1326,-1271,-450,1637,3902,3470,-812,-6425,-9976,-10762,-10320,-9539,-8027,-5996,-4812,-5071,-5503,-4728,-3184,-2278,-2208,-1854,-639,715,1559,2338,3593,4733,4713,3623,2705,2770,3339,3495,2970,2081,1120,261,-271,-398,-427,-665,-925,-800,-398,-365,-1085,-2222,-3181,-3697,-3769,-3339,-2396,-1275,-501,-275,-334,-316,-110,209,587,1016,1445,1769,1878,1693,1211,567,14,-234,-164,54,228,295,315,337,287,31,-433,-897,-1104,-990,-712,-462,-343,-398,-661,-1098,-1559,-1860,-1889,-1651,-1242,-820,-541,-443,-431,-390,-313,-243,-152,35,302,505,518,356,147,17,34,204,451,640,664,533,341,170,34,-87,-207,-323,-430,-511,-528,-462,-342,-238,-207,-254,-339,-414,-456,-464,-435,-363,-258,-146,-49,28,81,96,62,2,-39,-33,5,40,56,71,107,158,195,195,147,52,-78,-205,-285,-302,-278,-240,-196,-147,-119,-141,-207,-275,-309,-310,-292,-261,-221,-184,-156,-133,-114,-105,-106,-100,-82,-69,-79,-98,-103,-95,-98,-116,-124,-109,-86,-76,-84,-104,-130,-149,-148,-122,-85,-60,-54,-62,-76,-88,-87,-71,-52,-39,-32,-25,-17,-6,9,22,18,-7,-36,-54,-65,-75,-76,-58,-30,-10,1,14,21,2,-34,-51,-31}
        },
        {    // H50e064a.wav
            {-5,-3,0,0,-1,0,0,-1,0,1,0,-4,-3,3,3,-3,-2,5,3,-8,-6,11,11,-14,-23,3,18,-9,-25,14,41,-8,4,300,860,1388,1706,1917,1947,1170,-998,-4042,-6305,-6354,-4250,-1261,1495,3754,5592,6751,6822,5846,4404,3108,2212,1694,1464,1385,1258,954,531,119,-264,-688,-1139,-1479,-1626,-1675,-1767,-1883,-1867,-1655,-1391,-1264,-1296,-1337,-1247,-1002,-645,-223,187,465,549,525,547,671,824,940,1046,1183,1300,1296,1143,920,705,493,221,-140,-545,-901,-1132,-1213,-1178,-1098,-1044,-1040,-1045,-988,-837,-642,-488,-396,-292,-95,174,390,446,343,176,43,-8,7,35,29,0,11,107,243,312,243,69,-105,-199,-206,-184,-203,-297,-445,-583,-657,-662,-643,-646,-670,-677,-638,-559,-471,-403,-365,-342,-313,-261,-187,-108,-46,-19,-31,-71,-127,-181,-219,-243,-266,-300,-340,-374,-394,-401,-401,-399,-394,-381,-355,-315,-265,-217,-184,-171,-171,-174,-170,-156,-131,-99,-66,-35,-8,11,18,10,-9,-32,-50,-59,-61,-63,-75,-98,-127,-154,-176,-188,-185,-168,-145,-129,-121,-116,-105,-92,-82,-76,-72,-71,-77,-86,-91,-89,-81,-67,-45,-19,2,10,4,-17,-50,-87,-119,-137,-140,-131,-117,-107,-104,-107,-112,-124,-146,-172,-187,-185,-174,-161,-139,-105,-72,-52,-38,-24,-23,-51,-91,-96,-53},
            {-77,-177,93,284,-125,-396,945,4000,7089,8845,9100,6698,-1282,-15032,-27396,-27868,-13342,7207,21123,23923,20744,17590,14973,10717,5232,1154,-496,-850,-401,1563,4282,4716,918,-5156,-9697,-11112,-10649,-9681,-8242,-6406,-5239,-5368,-5722,-4927,-3345,-2507,-2784,-2882,-1813,-161,1116,2129,3437,4657,4799,3852,3020,3183,3867,4064,3455,2437,1405,546,25,-138,-266,-642,-1022,-947,-527,-450,-1133,-2244,-3202,-3757,-3886,-3475,-2503,-1377,-680,-571,-665,-546,-169,267,644,999,1376,1711,1855,1673,1179,582,143,-25,7,115,246,380,471,448,250,-135,-615,-987,-1072,-894,-667,-581,-658,-835,-1086,-1388,-1636,-1707,-1585,-1358,-1098,-823,-556,-344,-205,-107,-32,6,27,99,253,408,443,325,130,-21,-46,78,300,500,560,456,273,114,10,-82,-198,-331,-446,-507,-493,-404,-277,-177,-161,-230,-337,-424,-461,-447,-393,-315,-227,-136,-42,47,114,135,101,32,-34,-61,-42,-3,28,52,89,141,180,174,113,5,-131,-264,-352,-373,-344,-291,-224,-150,-99,-107,-164,-221,-244,-241,-234,-226,-209,-185,-155,-117,-81,-68,-79,-90,-78,-61,-68,-96,-119,-130,-146,-164,-160,-129,-103,-111,-146,-179,-195,-192,-168,-125,-79,-53,-52,-66,-83,-90,-80,-54,-31,-25,-33,-37,-28,-10,10,25,24,5,-19,-37,-49,-61,-71,-67,-49,-31,-21,-14,-10,-23,-55,-82,-75,-37}
        },
        {    // H50e072a.wav
            {-3,-4,-2,0,-1,-2,-1,2,1,-1,-1,0,-2,-3,1,3,-2,-5,1,5,-2,-8,3,12,-3,-23,-13,12,7,-16,-1,36,13,-34,96,515,1052,1464,1748,1958,1708,290,-2393,-5194,-6434,-5358,-2685,272,2732,4591,5837,6271,5811,4749,3559,2569,1900,1566,1486,1456,1281,940,544,144,-314,-815,-1198,-1325,-1281,-1285,-1421,-1544,-1489,-1286,-1113,-1082,-1148,-1202,-1174,-1026,-723,-302,86,274,249,175,221,415,657,849,960,1019,1066,1102,1053,828,440,49,-167,-194,-189,-313,-578,-877,-1097,-1187,-1145,-1001,-825,-692,-627,-578,-470,-278,-54,107,141,61,-49,-98,-60,20,75,74,34,-7,-18,10,61,108,122,89,25,-28,-43,-47,-102,-240,-421,-569,-637,-640,-619,-603,-599,-598,-579,-520,-429,-345,-306,-306,-313,-300,-266,-215,-150,-88,-59,-80,-137,-196,-235,-259,-283,-316,-354,-388,-404,-392,-351,-304,-284,-305,-343,-358,-328,-267,-202,-158,-138,-133,-134,-129,-111,-82,-53,-32,-15,0,8,1,-22,-54,-88,-116,-134,-141,-142,-145,-152,-161,-169,-174,-173,-162,-143,-121,-101,-87,-79,-73,-66,-61,-62,-68,-74,-77,-76,-71,-60,-43,-26,-13,-5,-2,-9,-30,-61,-93,-122,-146,-157,-151,-135,-123,-120,-122,-125,-131,-142,-156,-167,-175,-176,-167,-147,-123,-99,-70,-38,-18,-22,-39,-43,-25},
            {-186,17,290,60,-438,91,2446,5701,8300,9516,8463,2637,-9480,-23376,-29047,-19883,-558,16581,23288,21546,17980,15459,12344,7619,3064,391,-750,-918,615,3805,5891,3746,-2161,-7971,-10666,-10603,-9641,-8534,-7176,-6085,-5963,-6236,-5538,-3793,-2524,-2694,-3318,-2914,-1463,4,1153,2510,4017,4685,4051,3093,3048,3882,4542,4332,3425,2259,1135,365,158,220,-27,-652,-1080,-962,-739,-1052,-1923,-2884,-3615,-4016,-3874,-2992,-1710,-805,-690,-975,-995,-544,93,619,997,1300,1528,1609,1489,1185,794,440,203,99,137,312,535,646,548,268,-125,-577,-960,-1078,-880,-607,-578,-849,-1202,-1436,-1545,-1591,-1563,-1437,-1253,-1060,-844,-578,-309,-114,-3,69,124,161,204,290,393,427,335,152,-26,-110,-56,123,338,465,432,275,98,-26,-103,-189,-318,-456,-532,-496,-364,-208,-104,-92,-168,-293,-409,-466,-448,-381,-303,-229,-149,-58,34,107,146,143,94,18,-45,-62,-39,-11,11,47,113,172,172,101,-14,-143,-271,-373,-416,-393,-338,-278,-219,-161,-127,-134,-162,-176,-168,-163,-172,-180,-171,-142,-103,-67,-45,-42,-45,-42,-40,-57,-91,-121,-142,-167,-190,-189,-159,-133,-146,-189,-225,-235,-222,-191,-142,-92,-65,-69,-88,-102,-102,-84,-50,-16,-2,-13,-28,-28,-10,12,24,18,-2,-24,-34,-33,-31,-34,-35,-32,-31,-37,-42,-42,-47,-69,-94,-96,-66,-26}
        },
        {    // H50e080a.wav
            {1,0,-2,-2,0,0,-1,0,2,1,0,1,1,-1,-2,2,5,0,-4,1,7,1,-6,2,13,1,-20,-14,13,18,-2,2,30,10,-43,43,403,915,1349,1672,1938,1825,635,-1871,-4739,-6298,-5565,-3030,-17,2495,4273,5376,5765,5427,4589,3598,2689,1982,1588,1531,1607,1507,1127,651,280,-8,-338,-688,-906,-959,-1007,-1177,-1372,-1401,-1247,-1087,-1068,-1160,-1251,-1293,-1269,-1110,-757,-304,32,119,46,5,107,337,631,913,1074,1030,825,628,578,642,669,551,310,43,-198,-421,-646,-861,-1030,-1114,-1082,-929,-698,-483,-379,-408,-497,-536,-465,-305,-123,15,70,47,-4,-24,1,38,55,56,56,47,20,-1,27,102,165,154,51,-121,-319,-493,-595,-613,-579,-542,-524,-519,-515,-502,-466,-400,-327,-288,-294,-318,-328,-316,-288,-243,-179,-115,-87,-112,-171,-238,-299,-352,-384,-378,-336,-288,-257,-244,-243,-261,-302,-350,-370,-341,-277,-207,-151,-112,-86,-74,-74,-75,-68,-58,-53,-53,-47,-36,-34,-56,-99,-143,-174,-188,-187,-173,-150,-131,-128,-138,-145,-140,-127,-114,-100,-82,-63,-54,-57,-61,-59,-53,-50,-53,-57,-58,-55,-49,-40,-30,-22,-19,-22,-30,-44,-63,-87,-116,-142,-158,-160,-152,-140,-128,-116,-106,-104,-113,-131,-152,-166,-168,-158,-142,-122,-98,-70,-43,-24,-15,-10,-5},
            {-175,141,292,-129,-446,629,3355,6564,8982,9744,7088,-1437,-14992,-26351,-26186,-12357,6634,19364,21885,18930,16135,14174,10953,6350,2361,50,-1007,-675,1805,5263,6180,2348,-4167,-9108,-10467,-9573,-8376,-7410,-6609,-6364,-6722,-6623,-5184,-3256,-2506,-3128,-3593,-2765,-1171,219,1406,2779,3896,3928,3104,2678,3320,4328,4665,4144,3223,2241,1347,777,619,505,42,-562,-801,-700,-858,-1599,-2576,-3323,-3749,-3856,-3438,-2452,-1423,-995,-1158,-1280,-918,-256,304,654,941,1224,1404,1395,1213,917,572,272,125,186,415,678,811,715,423,36,-365,-716,-908,-855,-660,-579,-776,-1152,-1482,-1644,-1649,-1549,-1393,-1243,-1117,-943,-655,-323,-96,-15,21,93,175,229,292,396,469,414,239,45,-84,-126,-68,95,298,416,372,213,41,-91,-197,-303,-404,-475,-483,-407,-259,-104,-23,-59,-181,-319,-411,-436,-407,-348,-277,-198,-109,-15,69,127,149,130,73,3,-44,-48,-25,0,25,70,124,145,105,16,-95,-214,-328,-407,-426,-392,-337,-277,-215,-163,-143,-150,-153,-139,-124,-126,-135,-133,-118,-96,-66,-31,-7,-4,-11,-14,-25,-60,-106,-140,-159,-178,-191,-181,-155,-153,-193,-243,-262,-247,-216,-178,-135,-100,-91,-105,-120,-119,-99,-66,-31,-6,-2,-12,-15,1,23,34,26,4,-22,-39,-40,-29,-19,-14,-11,-9,-12,-21,-29,-39,-61,-92,-111,-98,-59,-21}
        },
        {    // H50e088a.wav
            {0,1,-1,-2,-1,0,-1,-2,0,2,1,-1,-1,-1,-3,-2,3,4,-2,-4,2,4,-5,-9,3,11,-3,-17,-3,19,14,-2,10,24,-18,-55,98,512,1022,1435,1760,1974,1622,56,-2666,-5309,-6265,-4915,-2081,855,3058,4458,5223,5392,4995,4228,3356,2549,1907,1544,1493,1583,1532,1219,781,416,163,-80,-374,-673,-922,-1132,-1315,-1420,-1385,-1249,-1141,-1163,-1301,-1456,-1521,-1421,-1136,-731,-347,-117,-72,-115,-88,111,441,723,787,651,544,676,1005,1265,1238,941,557,235,14,-140,-290,-507,-806,-1079,-1161,-993,-706,-512,-534,-730,-946,-1019,-863,-527,-174,37,69,13,-22,-3,36,56,57,62,90,133,165,159,114,61,33,34,32,-15,-129,-295,-471,-605,-655,-612,-515,-425,-388,-402,-431,-437,-406,-353,-307,-296,-326,-369,-381,-336,-252,-176,-141,-148,-182,-231,-283,-319,-325,-307,-281,-255,-227,-204,-203,-235,-288,-335,-352,-332,-282,-217,-156,-113,-89,-78,-70,-66,-70,-82,-96,-104,-105,-103,-106,-118,-141,-169,-191,-197,-185,-160,-136,-122,-121,-125,-125,-114,-96,-78,-65,-60,-64,-72,-76,-68,-51,-35,-30,-35,-44,-53,-63,-71,-70,-57,-41,-33,-35,-42,-49,-60,-81,-110,-137,-154,-160,-158,-147,-126,-102,-87,-88,-96,-104,-113,-130,-148,-156,-150,-139,-125,-101,-66,-34,-18,-14,-8},
            {-144,156,244,-174,-383,758,3428,6629,9165,9771,6295,-3167,-16467,-25895,-23504,-9191,8084,18490,19877,17244,15268,13864,10912,6429,2370,-88,-1015,-217,2551,5651,5828,1591,-4656,-8974,-9804,-8622,-7359,-6604,-6278,-6486,-6963,-6702,-5182,-3432,-2897,-3497,-3762,-2811,-1229,181,1477,2858,3724,3406,2449,2208,3154,4337,4651,4003,2998,2100,1481,1234,1230,1026,360,-400,-711,-643,-799,-1515,-2516,-3373,-3858,-3810,-3117,-2063,-1333,-1315,-1608,-1514,-876,-142,311,545,770,994,1107,1086,969,747,426,141,75,277,611,871,914,716,360,-34,-376,-609,-689,-626,-550,-630,-912,-1264,-1524,-1633,-1613,-1491,-1320,-1177,-1070,-893,-576,-227,-27,-3,-13,56,168,258,338,427,465,379,196,18,-96,-142,-102,42,237,362,344,218,60,-97,-245,-363,-425,-437,-414,-345,-226,-100,-42,-81,-178,-278,-352,-393,-393,-350,-282,-206,-119,-17,76,127,125,88,41,-1,-24,-22,-4,17,40,74,106,106,56,-32,-135,-240,-335,-399,-418,-401,-363,-302,-223,-156,-133,-145,-157,-150,-138,-131,-121,-100,-77,-61,-42,-14,11,17,9,-5,-28,-64,-101,-125,-145,-168,-186,-185,-175,-185,-221,-253,-258,-240,-216,-188,-157,-135,-131,-137,-136,-123,-101,-71,-38,-14,-9,-15,-12,7,30,39,27,2,-25,-43,-46,-36,-22,-8,3,9,9,4,-4,-22,-56,-92,-107,-88,-50,-17}
        },
        {    // H50e096a.wav
            {0,1,-1,-2,-1,1,0,-1,0,2,1,0,1,1,-2,-2,3,5,0,-3,3,6,-3,-10,-1,9,0,-13,0,25,22,-3,-2,22,-1,-56,25,375,890,1362,1736,2003,1816,540,-1977,-4763,-6212,-5396,-2814,184,2553,4054,4891,5220,5080,4551,3782,2935,2187,1726,1613,1666,1597,1290,880,541,284,22,-267,-534,-776,-1056,-1366,-1576,-1579,-1439,-1326,-1333,-1414,-1493,-1534,-1488,-1261,-834,-373,-116,-124,-201,-116,134,345,378,337,454,815,1251,1499,1442,1177,884,669,512,326,47,-313,-654,-851,-855,-753,-695,-768,-936,-1106,-1200,-1174,-1012,-747,-475,-287,-189,-121,-45,19,52,76,116,158,173,175,203,259,300,271,161,6,-128,-180,-139,-80,-116,-292,-522,-669,-666,-562,-446,-370,-338,-339,-362,-385,-388,-375,-367,-375,-382,-363,-317,-265,-230,-218,-226,-245,-260,-256,-232,-207,-203,-218,-232,-231,-223,-227,-247,-270,-283,-278,-255,-215,-164,-119,-95,-97,-112,-122,-121,-115,-114,-123,-137,-152,-164,-176,-186,-191,-186,-170,-151,-137,-130,-128,-126,-122,-113,-98,-77,-58,-46,-42,-43,-50,-61,-70,-66,-49,-31,-25,-32,-45,-57,-68,-75,-75,-67,-56,-50,-52,-57,-62,-68,-81,-102,-126,-143,-148,-141,-127,-108,-89,-75,-67,-64,-65,-74,-96,-125,-149,-158,-151,-132,-102,-69,-44,-31,-22,-11},
            {-127,113,218,-108,-357,471,2770,5914,8778,9842,6830,-1995,-14570,-23886,-22652,-10365,5357,15648,18029,16493,15226,14333,11804,7383,2934,70,-878,75,2726,5500,5646,1835,-3969,-8227,-9217,-8047,-6674,-5985,-5925,-6313,-6778,-6563,-5324,-3883,-3398,-3833,-3988,-3084,-1575,-176,1122,2495,3425,3253,2374,2029,2796,3916,4339,3861,2985,2159,1575,1357,1433,1378,838,43,-466,-579,-739,-1299,-2132,-2911,-3423,-3506,-3035,-2212,-1583,-1482,-1620,-1482,-973,-430,-67,238,607,912,971,812,593,398,230,129,170,363,622,826,874,733,451,124,-178,-417,-535,-509,-442,-520,-811,-1175,-1435,-1545,-1555,-1481,-1323,-1150,-1030,-903,-660,-328,-82,-12,-16,39,148,238,303,390,463,425,252,35,-124,-185,-146,-10,178,323,349,265,126,-34,-203,-349,-431,-437,-387,-303,-197,-102,-64,-100,-181,-264,-327,-361,-360,-326,-278,-226,-159,-64,37,103,113,82,38,2,-11,-1,19,32,42,61,84,85,47,-21,-110,-215,-322,-394,-411,-390,-359,-314,-245,-172,-134,-136,-149,-151,-150,-151,-139,-102,-60,-34,-21,-5,12,18,14,7,-9,-38,-71,-95,-113,-137,-163,-177,-182,-197,-224,-244,-243,-233,-222,-204,-174,-149,-145,-152,-148,-129,-104,-78,-51,-30,-21,-23,-17,5,30,40,28,4,-19,-32,-32,-23,-12,0,14,26,31,26,16,0,-26,-55,-72,-65,-41,-16}
        },
        {    // H50e104a.wav
            {0,0,-1,-2,-1,0,-1,-2,0,1,0,-1,0,1,-1,-1,3,3,-1,-1,5,5,-6,-11,-2,4,-8,-14,7,31,19,-7,0,16,-19,-54,86,488,1021,1512,1921,2135,1670,-49,-2859,-5489,-6368,-4930,-2023,945,3102,4377,5022,5196,4966,4444,3765,3032,2370,1944,1812,1792,1594,1108,512,66,-145,-245,-385,-618,-919,-1233,-1491,-1624,-1627,-1578,-1568,-1611,-1649,-1622,-1494,-1244,-889,-519,-252,-116,-32,55,79,-22,-123,28,526,1148,1550,1579,1358,1104,940,859,780,594,241,-204,-550,-660,-592,-542,-649,-896,-1172,-1372,-1420,-1278,-991,-698,-530,-486,-457,-359,-224,-122,-59,24,151,277,344,342,302,256,225,220,227,202,112,-19,-128,-188,-233,-302,-392,-475,-536,-573,-569,-513,-422,-342,-309,-321,-356,-395,-427,-437,-415,-370,-327,-301,-286,-271,-257,-247,-239,-230,-222,-214,-201,-179,-164,-178,-225,-276,-293,-267,-222,-186,-165,-147,-126,-109,-105,-115,-132,-155,-180,-198,-200,-191,-188,-199,-216,-225,-218,-196,-165,-137,-125,-130,-142,-146,-138,-124,-108,-87,-63,-44,-38,-43,-49,-52,-51,-49,-44,-40,-41,-49,-57,-60,-59,-63,-73,-83,-86,-85,-82,-78,-70,-63,-64,-73,-87,-103,-121,-137,-144,-138,-120,-95,-68,-45,-31,-30,-43,-67,-99,-129,-149,-156,-151,-130,-94,-59,-42,-43,-40,-21},
            {-105,17,166,30,-273,-8,1523,4281,7463,9604,8457,1916,-9313,-19914,-22728,-14937,-1208,10387,15537,16050,15666,15354,13510,9356,4404,747,-708,-52,2249,4940,5800,3220,-1904,-6641,-8671,-8092,-6598,-5579,-5396,-5832,-6413,-6453,-5560,-4277,-3659,-3971,-4294,-3690,-2302,-868,389,1701,2842,3124,2506,1975,2403,3455,4081,3799,3004,2249,1740,1505,1505,1473,1058,313,-263,-384,-385,-776,-1588,-2412,-2899,-2981,-2720,-2256,-1843,-1680,-1668,-1520,-1152,-756,-469,-179,239,665,842,687,359,81,-20,46,193,338,478,647,803,826,654,364,66,-196,-386,-437,-357,-319,-506,-883,-1237,-1423,-1464,-1434,-1348,-1223,-1105,-988,-795,-506,-236,-103,-72,-19,91,196,269,350,441,455,329,111,-86,-194,-199,-105,64,239,338,328,237,90,-94,-281,-415,-455,-409,-310,-194,-99,-61,-93,-174,-267,-338,-372,-360,-314,-266,-235,-200,-131,-37,41,77,77,58,28,0,-7,11,33,38,38,51,70,65,20,-55,-153,-259,-348,-390,-385,-355,-317,-268,-213,-172,-156,-152,-147,-147,-157,-159,-137,-98,-62,-37,-15,2,8,6,8,10,-5,-35,-64,-85,-108,-135,-153,-162,-180,-214,-244,-251,-239,-226,-214,-191,-163,-149,-152,-156,-147,-127,-101,-73,-49,-40,-42,-39,-21,3,17,16,3,-13,-25,-24,-11,5,16,23,30,34,32,26,18,4,-21,-48,-60,-48,-22}
        },
        {    // H50e112a.wav
            {1,-2,-4,-3,-1,-1,-1,1,2,0,-2,0,1,-1,-1,3,5,0,-3,2,6,-1,-8,-2,5,-5,-17,-3,23,22,-2,-1,22,2,-49,23,358,898,1472,1981,2295,1975,425,-2358,-5266,-6655,-5639,-2785,475,2997,4477,5149,5297,5084,4614,3968,3224,2536,2121,2054,2105,1902,1308,554,-29,-347,-542,-750,-967,-1154,-1340,-1555,-1728,-1760,-1669,-1597,-1644,-1760,-1800,-1655,-1309,-832,-357,-13,155,195,145,-5,-198,-222,133,795,1405,1646,1526,1286,1109,1000,880,696,434,110,-192,-357,-369,-360,-487,-770,-1102,-1369,-1509,-1474,-1240,-883,-577,-452,-475,-513,-484,-410,-329,-217,-36,190,374,452,428,352,268,199,158,152,172,192,184,122,-3,-173,-337,-446,-495,-523,-553,-564,-521,-436,-364,-345,-374,-414,-440,-445,-431,-404,-371,-343,-322,-304,-282,-252,-215,-183,-173,-190,-217,-230,-223,-213,-214,-221,-217,-201,-183,-168,-145,-111,-81,-75,-91,-113,-131,-151,-177,-203,-225,-247,-269,-286,-286,-268,-239,-202,-159,-120,-104,-115,-136,-149,-150,-141,-121,-90,-59,-40,-36,-39,-44,-50,-55,-55,-49,-40,-34,-32,-37,-48,-61,-69,-73,-78,-89,-103,-111,-108,-92,-71,-56,-51,-54,-62,-76,-97,-117,-126,-122,-112,-94,-65,-32,-13,-17,-34,-55,-82,-115,-140,-143,-132,-118,-95,-57,-24,-30,-65,-80,-48},
            {-37,-69,42,119,-54,-219,330,2131,5049,8116,9422,6522,-1711,-12683,-20315,-19347,-10072,1804,10399,14267,15647,16326,15633,12361,7190,2385,-266,-443,1262,3826,5631,4919,1250,-3671,-7251,-8173,-7152,-5765,-5047,-5158,-5737,-6157,-5831,-4793,-3854,-3755,-4209,-4218,-3306,-1935,-650,585,1872,2736,2664,2047,1921,2694,3648,3889,3327,2518,1914,1615,1561,1558,1271,560,-200,-477,-283,-212,-705,-1563,-2262,-2524,-2425,-2141,-1829,-1631,-1597,-1602,-1475,-1199,-878,-540,-130,308,576,511,192,-117,-200,-59,133,227,254,365,612,850,889,691,368,37,-231,-352,-280,-133,-149,-444,-875,-1209,-1353,-1367,-1324,-1253,-1176,-1097,-969,-746,-480,-283,-186,-107,14,140,218,276,358,423,378,210,9,-133,-186,-154,-40,125,268,328,299,208,67,-118,-305,-427,-442,-361,-232,-111,-46,-64,-150,-256,-333,-361,-354,-328,-301,-276,-241,-179,-98,-26,15,31,38,39,27,11,5,8,7,4,18,51,76,66,17,-62,-159,-254,-321,-346,-340,-321,-292,-251,-209,-183,-172,-163,-156,-161,-170,-161,-131,-97,-73,-54,-35,-22,-14,-1,17,20,-4,-37,-56,-64,-79,-105,-131,-153,-182,-218,-245,-252,-243,-226,-202,-173,-147,-135,-137,-145,-147,-136,-111,-82,-62,-56,-54,-45,-27,-8,2,2,-7,-17,-20,-9,12,31,39,39,36,36,39,37,20,-11,-42,-52,-37,-14}
        },
        {    // H50e120a.wav
            {-3,-3,0,1,-1,-2,0,2,1,-1,-1,-2,-3,-2,3,4,-1,-2,3,4,-4,-7,1,5,-8,-17,0,20,11,-8,3,24,-3,-43,67,447,1044,1711,2299,2522,1822,-264,-3385,-6151,-6970,-5286,-1982,1409,3828,5103,5573,5569,5229,4588,3720,2815,2161,1961,2113,2220,1925,1240,492,-39,-354,-621,-939,-1281,-1606,-1896,-2097,-2115,-1951,-1756,-1691,-1760,-1825,-1753,-1506,-1119,-666,-238,96,322,436,377,116,-170,-129,426,1233,1774,1771,1418,1102,994,963,816,507,138,-148,-265,-242,-218,-340,-634,-996,-1302,-1489,-1524,-1373,-1063,-723,-501,-429,-427,-423,-428,-456,-446,-303,-20,288,481,502,399,266,170,126,115,119,135,164,187,163,70,-71,-209,-318,-412,-508,-577,-577,-507,-425,-394,-424,-472,-497,-493,-477,-462,-444,-418,-379,-326,-265,-209,-175,-165,-168,-174,-182,-199,-231,-269,-289,-270,-218,-158,-110,-77,-57,-55,-73,-98,-111,-114,-125,-151,-180,-202,-223,-261,-311,-347,-345,-306,-247,-192,-156,-144,-149,-159,-165,-160,-144,-121,-97,-78,-63,-53,-47,-45,-45,-46,-49,-55,-59,-59,-57,-56,-57,-58,-56,-55,-59,-74,-99,-122,-132,-124,-107,-90,-75,-60,-50,-52,-60,-65,-69,-81,-95,-96,-80,-61,-49,-42,-38,-43,-60,-82,-102,-123,-141,-139,-111,-78,-60,-49,-35,-35,-73,-125,-131,-72},
            {32,-51,-57,52,93,-65,-158,411,2147,5009,8001,9005,5637,-2607,-12617,-18857,-17422,-9263,884,8768,13444,16092,17191,15840,11608,5973,1410,-547,2,2054,4373,5551,4348,698,-3796,-6929,-7640,-6625,-5352,-4783,-4997,-5526,-5763,-5328,-4422,-3744,-3755,-4087,-3963,-3116,-1938,-768,465,1716,2465,2341,1834,1855,2623,3432,3566,3054,2403,1957,1739,1632,1432,908,107,-510,-541,-200,-132,-643,-1383,-1845,-1928,-1856,-1780,-1676,-1541,-1462,-1466,-1463,-1336,-1042,-606,-117,255,334,105,-227,-397,-300,-51,148,208,219,336,584,823,884,721,409,66,-191,-255,-117,55,18,-318,-797,-1179,-1338,-1316,-1215,-1117,-1061,-1030,-962,-818,-625,-437,-268,-101,50,153,213,277,354,378,289,115,-56,-155,-167,-103,13,141,238,279,262,188,57,-109,-257,-343,-352,-294,-194,-98,-59,-104,-202,-294,-340,-345,-334,-322,-309,-286,-245,-183,-113,-56,-21,-2,8,9,4,1,1,-6,-22,-26,2,52,88,85,40,-37,-134,-227,-285,-301,-294,-286,-272,-243,-207,-188,-189,-195,-191,-179,-165,-146,-121,-97,-84,-81,-79,-68,-44,-11,14,14,-9,-30,-35,-36,-54,-87,-121,-150,-180,-210,-230,-236,-230,-212,-184,-150,-125,-121,-134,-151,-157,-147,-121,-89,-67,-61,-61,-54,-37,-18,-7,-7,-15,-23,-21,-3,22,42,51,54,51,40,23,7,-2,-6,-8,-7,-4}
        },
        {    // H50e128a.wav
            {-3,-2,-2,-3,-1,1,0,-2,-2,-1,-2,-3,0,3,2,-1,1,4,-1,-7,-4,3,-2,-14,-11,7,13,-4,-8,14,16,-26,-11,228,766,1521,2303,2781,2413,668,-2365,-5577,-7308,-6502,-3507,249,3350,5197,5971,6082,5764,5065,4052,2958,2130,1819,1963,2179,2051,1472,707,104,-222,-421,-685,-1072,-1521,-1944,-2261,-2403,-2363,-2233,-2131,-2092,-2047,-1909,-1638,-1240,-757,-283,85,326,482,532,385,88,-40,338,1147,1861,2006,1628,1181,994,979,855,514,99,-193,-288,-247,-203,-285,-547,-925,-1284,-1515,-1575,-1454,-1167,-796,-481,-335,-348,-412,-446,-447,-428,-342,-131,174,436,529,446,291,167,101,64,41,45,81,113,98,34,-39,-87,-125,-195,-308,-417,-463,-435,-386,-385,-454,-551,-613,-612,-565,-513,-483,-475,-467,-432,-358,-255,-151,-75,-45,-73,-156,-262,-334,-328,-260,-187,-152,-141,-117,-72,-31,-18,-32,-61,-100,-144,-175,-179,-172,-189,-244,-315,-363,-363,-321,-258,-200,-169,-172,-194,-210,-207,-195,-185,-172,-145,-103,-64,-46,-45,-44,-40,-42,-54,-63,-58,-47,-48,-64,-83,-93,-94,-89,-83,-82,-91,-109,-126,-134,-131,-117,-96,-75,-64,-62,-64,-65,-68,-72,-72,-64,-51,-36,-23,-18,-26,-45,-65,-81,-101,-127,-149,-154,-145,-128,-100,-64,-38,-36,-48,-59,-79,-125,-169,-157,-80},
            {17,16,-21,-32,21,55,-28,-108,258,1645,4257,7285,8674,6074,-1124,-10341,-16852,-17048,-11042,-2122,6195,12342,16268,17797,16266,11757,5980,1392,-511,100,2082,4198,5305,4414,1310,-2855,-6109,-7173,-6399,-5168,-4573,-4758,-5228,-5422,-5062,-4319,-3707,-3606,-3812,-3747,-3116,-2131,-1052,125,1326,2104,2111,1706,1670,2274,2988,3199,2897,2489,2219,2018,1735,1259,556,-203,-627,-498,-140,-128,-607,-1139,-1316,-1251,-1304,-1537,-1686,-1593,-1417,-1365,-1413,-1363,-1089,-648,-224,-4,-63,-294,-478,-461,-276,-67,76,172,283,430,588,711,749,660,439,161,-38,-57,69,168,65,-272,-714,-1077,-1242,-1209,-1073,-958,-930,-960,-966,-899,-771,-603,-398,-165,34,144,185,226,282,286,186,24,-107,-155,-137,-82,6,119,218,263,245,177,70,-59,-175,-239,-243,-209,-162,-121,-108,-143,-219,-296,-333,-328,-309,-298,-295,-287,-265,-227,-177,-127,-86,-56,-34,-22,-23,-30,-33,-31,-32,-27,0,48,90,97,62,-5,-88,-171,-233,-261,-264,-259,-252,-238,-220,-210,-211,-209,-195,-174,-153,-131,-110,-101,-110,-127,-134,-121,-89,-45,-6,9,-1,-18,-24,-27,-46,-85,-125,-150,-162,-174,-190,-202,-204,-196,-177,-152,-132,-125,-131,-141,-146,-141,-124,-104,-90,-85,-79,-63,-41,-25,-18,-19,-24,-30,-28,-10,19,43,51,42,24,7,3,15,36,47,40,18}
        },
        {    // H50e136a.wav
            {-1,-2,0,1,0,-2,-1,0,-2,-4,-1,3,2,-1,1,4,2,-4,-4,1,0,-10,-12,2,10,-2,-9,9,20,-11,-21,157,661,1481,2415,3043,2747,983,-2163,-5603,-7649,-7108,-4151,-155,3332,5523,6496,6666,6293,5439,4212,2922,1989,1678,1887,2183,2102,1506,663,-22,-366,-510,-703,-1060,-1514,-1938,-2239,-2380,-2380,-2320,-2293,-2328,-2361,-2294,-2050,-1592,-964,-323,138,363,481,608,657,489,233,292,892,1730,2217,2074,1569,1141,928,748,443,81,-172,-269,-297,-355,-476,-653,-880,-1140,-1390,-1564,-1589,-1409,-1038,-595,-252,-118,-170,-304,-423,-470,-392,-154,192,492,595,492,310,178,122,90,46,3,-19,-23,-24,-37,-73,-135,-203,-249,-262,-258,-250,-249,-264,-317,-412,-518,-585,-600,-594,-599,-612,-607,-564,-487,-389,-282,-178,-98,-64,-86,-146,-208,-239,-234,-209,-182,-153,-113,-62,-14,9,-7,-53,-104,-137,-150,-156,-174,-212,-266,-315,-338,-326,-283,-234,-203,-199,-214,-228,-228,-212,-193,-180,-174,-167,-155,-138,-115,-88,-63,-47,-39,-28,-14,-8,-22,-48,-72,-86,-92,-93,-91,-89,-94,-110,-132,-151,-162,-160,-146,-124,-100,-77,-59,-50,-50,-59,-68,-76,-80,-72,-45,-11,10,13,8,-3,-26,-63,-102,-133,-156,-169,-164,-141,-116,-99,-84,-66,-55,-62,-76,-83,-98,-137,-175,-159,-82},
            {-12,4,15,1,-20,-9,25,12,-62,48,895,2966,5923,8107,7172,1865,-6411,-13908,-16839,-13841,-6493,2252,9977,15413,17885,16951,12901,7284,2383,-146,-144,1438,3445,4878,4795,2623,-1108,-4709,-6531,-6304,-5156,-4382,-4405,-4837,-5121,-4956,-4384,-3736,-3408,-3466,-3539,-3215,-2448,-1451,-352,767,1614,1849,1587,1427,1784,2411,2787,2768,2622,2530,2356,1901,1173,359,-297,-580,-457,-204,-198,-486,-735,-715,-647,-891,-1400,-1754,-1699,-1436,-1294,-1315,-1279,-1037,-683,-429,-404,-556,-696,-648,-402,-125,17,41,96,270,495,648,677,612,495,356,236,184,211,254,204,-8,-339,-661,-861,-922,-905,-878,-869,-880,-901,-910,-883,-814,-714,-575,-381,-154,35,134,160,159,137,69,-37,-124,-154,-140,-107,-41,76,211,295,289,212,104,-8,-97,-137,-128,-105,-103,-121,-146,-176,-217,-262,-291,-296,-292,-294,-301,-303,-298,-287,-266,-232,-188,-140,-93,-56,-39,-40,-47,-48,-45,-37,-14,29,76,99,84,41,-19,-90,-161,-218,-254,-269,-263,-236,-200,-179,-181,-192,-193,-183,-169,-152,-131,-119,-125,-143,-153,-145,-123,-91,-53,-20,-7,-14,-25,-35,-51,-80,-110,-128,-134,-140,-155,-175,-188,-186,-167,-140,-117,-106,-108,-120,-136,-147,-146,-135,-122,-112,-99,-76,-48,-28,-22,-26,-33,-35,-27,-11,8,18,15,7,5,15,37,63,76,63,29}
        },
        {    // H50e144a.wav
            {0,3,3,0,-2,-2,-2,-2,1,4,3,1,3,5,2,-5,-5,1,2,-9,-13,-1,9,0,-8,6,19,-6,-16,166,723,1676,2763,3414,2898,722,-2814,-6403,-8281,-7339,-3911,476,4187,6416,7282,7250,6610,5456,3971,2570,1714,1591,1957,2283,2118,1391,432,-328,-694,-806,-935,-1241,-1690,-2138,-2433,-2497,-2378,-2240,-2230,-2346,-2442,-2378,-2112,-1665,-1085,-486,-32,209,366,595,830,839,595,456,810,1582,2231,2296,1839,1285,933,726,477,153,-128,-292,-388,-499,-642,-798,-968,-1167,-1373,-1523,-1560,-1452,-1188,-800,-393,-116,-46,-136,-267,-341,-299,-113,187,484,631,577,413,265,179,115,38,-35,-77,-84,-73,-68,-94,-170,-273,-344,-343,-294,-249,-233,-239,-269,-337,-433,-510,-533,-526,-540,-594,-651,-660,-597,-470,-311,-169,-93,-100,-158,-207,-210,-176,-135,-103,-79,-55,-33,-17,-7,-7,-26,-65,-111,-145,-164,-187,-229,-281,-314,-310,-275,-231,-200,-192,-208,-239,-266,-271,-248,-206,-164,-139,-137,-149,-156,-147,-126,-106,-95,-86,-68,-39,-10,6,3,-18,-49,-76,-91,-93,-91,-91,-96,-106,-122,-143,-165,-178,-180,-169,-143,-106,-69,-44,-37,-48,-68,-80,-72,-48,-20,0,11,15,13,5,-9,-32,-64,-100,-129,-145,-149,-146,-136,-121,-105,-92,-82,-78,-84,-100,-114,-118,-118,-125,-127,-101,-48},
            {-7,-10,-7,4,11,0,-15,-5,20,-5,-44,264,1530,3992,6745,7751,5085,-1374,-9289,-15029,-15825,-11278,-3227,5572,12755,16881,17384,14555,9634,4541,1025,-192,498,2201,3994,4906,4016,1145,-2578,-5327,-6049,-5255,-4283,-3998,-4326,-4744,-4851,-4521,-3890,-3316,-3125,-3254,-3269,-2825,-1967,-936,99,979,1454,1431,1227,1312,1778,2289,2569,2679,2744,2631,2119,1260,393,-181,-405,-402,-332,-298,-286,-208,-89,-163,-629,-1321,-1786,-1763,-1453,-1228,-1197,-1171,-1002,-783,-701,-806,-963,-985,-781,-422,-84,102,156,200,311,453,551,572,526,433,333,279,295,345,345,226,-19,-325,-576,-675,-625,-533,-514,-594,-723,-845,-926,-938,-870,-752,-634,-530,-412,-269,-133,-40,7,14,-22,-88,-142,-153,-133,-107,-61,34,164,268,301,270,204,121,37,-22,-42,-43,-57,-89,-119,-139,-163,-200,-240,-272,-299,-324,-343,-352,-353,-348,-332,-301,-257,-208,-159,-118,-93,-79,-64,-43,-28,-26,-24,-1,43,83,100,89,51,-12,-92,-167,-216,-235,-232,-212,-182,-159,-156,-172,-190,-196,-191,-178,-159,-137,-122,-122,-132,-142,-142,-129,-101,-66,-38,-28,-32,-37,-43,-57,-82,-109,-129,-141,-149,-151,-145,-130,-112,-97,-91,-94,-105,-119,-134,-148,-158,-161,-152,-131,-101,-74,-52,-35,-26,-25,-25,-19,-9,-6,-13,-20,-15,0,20,41,62,72,59,29}
        },
        {    // H50e152a.wav
            {1,-2,-3,-3,-3,-3,0,3,2,0,1,3,1,-5,-5,0,-1,-9,-11,-1,5,-5,-12,3,18,-4,-13,184,817,1926,3168,3811,3008,344,-3635,-7368,-9013,-7580,-3613,1197,5145,7426,8181,7904,6927,5420,3675,2201,1470,1576,2125,2479,2177,1239,108,-721,-1073,-1141,-1234,-1512,-1935,-2356,-2616,-2626,-2442,-2259,-2253,-2400,-2500,-2388,-2054,-1573,-1000,-415,26,213,253,385,683,936,925,756,788,1219,1830,2201,2114,1694,1197,766,406,116,-70,-171,-296,-538,-852,-1093,-1184,-1199,-1268,-1426,-1585,-1615,-1432,-1037,-537,-122,52,-19,-187,-281,-223,-29,238,494,646,646,542,427,340,238,80,-97,-206,-201,-119,-43,-36,-113,-236,-341,-386,-378,-360,-364,-393,-430,-457,-462,-445,-427,-444,-514,-611,-680,-671,-579,-441,-310,-219,-164,-126,-100,-98,-127,-167,-180,-144,-67,23,94,121,95,25,-62,-137,-185,-211,-230,-252,-270,-272,-254,-230,-221,-236,-265,-288,-294,-284,-261,-228,-195,-177,-178,-187,-187,-170,-144,-120,-103,-94,-90,-83,-65,-39,-22,-25,-45,-65,-74,-72,-64,-58,-59,-70,-92,-120,-146,-165,-178,-187,-191,-185,-165,-136,-110,-95,-89,-87,-83,-76,-66,-53,-37,-18,0,14,19,12,-9,-39,-71,-97,-115,-125,-128,-126,-123,-118,-110,-101,-98,-105,-118,-129,-137,-143,-142,-126,-100,-77,-60,-42,-19},
            {-16,-5,3,-5,-12,-1,13,1,-21,-6,25,-7,-17,449,1969,4512,6870,7025,3517,-3197,-10556,-15188,-14794,-9341,-872,7710,13981,16706,15868,12372,7699,3442,748,-33,777,2496,4197,4748,3314,160,-3220,-5180,-5259,-4366,-3707,-3752,-4201,-4570,-4568,-4133,-3462,-2962,-2917,-3131,-3097,-2532,-1603,-626,228,862,1144,1091,1006,1212,1702,2210,2563,2762,2740,2326,1528,675,109,-146,-292,-415,-391,-120,267,471,251,-392,-1176,-1703,-1760,-1490,-1219,-1120,-1100,-1024,-926,-942,-1090,-1218,-1161,-896,-539,-215,33,236,420,546,552,443,315,266,303,368,416,437,417,327,162,-42,-233,-373,-429,-390,-292,-218,-240,-378,-598,-836,-1010,-1045,-934,-748,-592,-516,-491,-462,-400,-313,-226,-160,-124,-106,-94,-84,-73,-46,13,95,168,215,246,271,274,237,167,92,26,-30,-71,-88,-85,-91,-129,-193,-262,-321,-366,-394,-401,-394,-386,-379,-360,-323,-278,-236,-197,-157,-119,-87,-61,-40,-26,-21,-16,5,44,86,113,110,69,-3,-85,-151,-188,-200,-194,-178,-162,-157,-169,-187,-195,-192,-186,-177,-157,-130,-110,-107,-117,-129,-136,-133,-111,-75,-45,-37,-46,-59,-68,-79,-94,-112,-130,-142,-138,-115,-86,-67,-64,-73,-89,-109,-127,-138,-144,-153,-161,-157,-139,-111,-85,-64,-46,-33,-23,-11,4,9,-5,-29,-41,-34,-17,5,31,53,52,27}
        },
        {    // H50e160a.wav
            {-1,-1,-3,-3,1,5,4,1,2,4,1,-6,-7,-1,0,-7,-9,0,6,-4,-12,2,18,-4,-4,242,1007,2318,3705,4237,2970,-364,-4864,-8644,-9803,-7588,-2885,2386,6475,8655,9154,8511,7103,5193,3201,1725,1214,1626,2389,2748,2247,1028,-313,-1203,-1504,-1509,-1587,-1881,-2299,-2668,-2844,-2764,-2502,-2271,-2256,-2423,-2545,-2425,-2046,-1495,-857,-231,222,398,398,467,722,1018,1123,1003,870,963,1316,1731,1944,1817,1417,934,535,268,80,-110,-359,-671,-979,-1183,-1242,-1228,-1264,-1401,-1570,-1645,-1540,-1242,-811,-366,-44,72,18,-81,-98,15,221,436,588,656,661,624,536,375,158,-51,-184,-211,-154,-67,-17,-48,-150,-263,-339,-382,-428,-491,-549,-576,-569,-542,-513,-506,-543,-619,-689,-706,-658,-561,-429,-264,-89,35,54,-28,-144,-216,-207,-127,-16,86,150,162,129,73,12,-48,-114,-186,-247,-273,-256,-217,-189,-194,-232,-286,-332,-348,-333,-303,-277,-258,-238,-215,-197,-189,-184,-171,-152,-134,-120,-102,-78,-51,-30,-17,-14,-19,-33,-52,-72,-85,-87,-77,-62,-53,-55,-68,-89,-119,-155,-187,-202,-200,-184,-158,-131,-111,-102,-101,-103,-105,-104,-98,-85,-65,-38,-7,18,26,16,-6,-35,-66,-93,-111,-118,-118,-111,-97,-79,-68,-70,-81,-97,-116,-136,-146,-142,-135,-131,-118,-84,-47,-38,-55,-63,-37},
            {-1,-13,-14,-2,3,-7,-12,3,13,-4,-22,1,26,-16,6,565,2158,4604,6626,6344,2574,-4014,-10861,-14779,-13720,-7882,515,8510,13830,15619,14286,10929,6837,3179,796,66,872,2605,4200,4446,2722,-361,-3241,-4612,-4421,-3658,-3284,-3516,-4005,-4334,-4260,-3763,-3109,-2730,-2816,-3049,-2924,-2289,-1414,-591,101,627,874,855,845,1124,1663,2198,2536,2624,2409,1863,1140,522,131,-143,-360,-352,26,578,860,593,-105,-886,-1442,-1646,-1547,-1317,-1130,-1046,-1020,-1031,-1121,-1287,-1401,-1314,-1021,-662,-358,-105,159,436,641,684,550,316,114,52,155,355,530,575,458,231,-8,-177,-247,-235,-175,-105,-61,-71,-145,-292,-515,-783,-1012,-1109,-1054,-911,-761,-644,-567,-531,-527,-518,-458,-339,-198,-80,-9,21,29,39,69,112,143,157,183,245,320,354,316,218,95,-22,-107,-145,-144,-137,-156,-205,-268,-330,-383,-424,-452,-468,-470,-446,-390,-315,-252,-217,-202,-188,-167,-141,-111,-73,-31,7,38,65,86,96,89,65,27,-22,-74,-117,-145,-161,-170,-177,-183,-191,-200,-204,-198,-182,-162,-144,-131,-126,-126,-125,-122,-119,-119,-115,-99,-77,-63,-68,-85,-98,-98,-89,-84,-93,-113,-131,-133,-118,-96,-80,-75,-78,-85,-95,-109,-125,-139,-148,-151,-146,-131,-108,-82,-59,-40,-22,-3,7,-5,-35,-63,-70,-54,-26,1,18,20,11}
        },
        {    // H50e168a.wav
            {-4,-4,1,6,5,0,0,3,0,-7,-8,-2,-1,-8,-9,1,7,-5,-14,2,19,-5,4,321,1260,2807,4319,4652,2798,-1294,-6314,-10050,-10576,-7428,-1887,3860,8030,10006,10132,9018,7106,4776,2592,1218,1027,1791,2749,3047,2273,719,-847,-1772,-1975,-1877,-1927,-2253,-2691,-3022,-3107,-2923,-2590,-2337,-2328,-2483,-2551,-2355,-1922,-1366,-757,-160,304,541,617,713,931,1202,1379,1371,1192,955,841,985,1325,1592,1528,1128,635,299,154,37,-226,-655,-1098,-1362,-1374,-1246,-1175,-1278,-1499,-1670,-1645,-1388,-978,-551,-225,-49,5,12,47,147,289,422,514,583,650,686,623,436,190,-10,-96,-68,26,107,99,-21,-194,-328,-387,-405,-431,-473,-518,-565,-618,-665,-694,-715,-752,-806,-848,-833,-738,-561,-324,-86,74,107,37,-63,-124,-119,-58,30,113,165,181,170,145,104,36,-56,-147,-201,-200,-162,-131,-146,-212,-300,-366,-382,-356,-322,-309,-320,-335,-332,-305,-263,-221,-192,-179,-176,-167,-137,-86,-37,-17,-27,-43,-38,-15,7,9,-10,-40,-70,-92,-100,-92,-77,-73,-85,-108,-132,-154,-173,-183,-182,-174,-160,-140,-114,-92,-84,-93,-110,-127,-134,-126,-101,-65,-30,-6,0,-14,-40,-63,-76,-86,-101,-115,-116,-101,-81,-64,-51,-46,-55,-75,-94,-105,-116,-135,-152,-151,-131,-102,-72,-49,-48,-75,-105,-98,-50},
            {3,6,-2,-14,-12,0,2,-9,-10,6,12,-8,-22,4,25,-19,19,585,2108,4372,6177,5805,2195,-4004,-10382,-13935,-12748,-7082,841,8157,12813,14230,12992,10125,6620,3340,1030,201,902,2543,3988,4072,2367,-398,-2811,-3866,-3669,-3105,-2930,-3262,-3768,-4068,-3945,-3436,-2855,-2598,-2746,-2941,-2765,-2168,-1419,-724,-107,391,647,680,751,1094,1636,2103,2321,2286,2033,1583,1022,487,73,-162,-120,250,759,1018,780,171,-486,-990,-1316,-1469,-1428,-1248,-1070,-1005,-1065,-1214,-1407,-1541,-1481,-1187,-786,-439,-186,44,288,492,584,547,420,264,150,134,224,371,492,515,408,208,10,-102,-115,-80,-42,-12,-2,-49,-174,-352,-538,-712,-877,-1023,-1118,-1124,-1031,-861,-670,-532,-490,-510,-509,-435,-300,-150,-14,95,162,180,163,138,124,127,157,219,299,357,354,275,135,-23,-145,-197,-191,-172,-183,-231,-297,-361,-411,-442,-454,-455,-451,-435,-400,-349,-298,-257,-223,-192,-161,-128,-87,-42,-4,18,32,49,69,82,79,59,22,-28,-77,-113,-134,-149,-161,-169,-173,-180,-188,-190,-183,-174,-167,-159,-146,-130,-116,-102,-88,-82,-91,-109,-119,-113,-99,-91,-90,-89,-83,-76,-77,-91,-116,-141,-154,-148,-127,-101,-76,-55,-44,-48,-68,-95,-121,-141,-150,-143,-119,-89,-65,-50,-39,-30,-29,-43,-67,-86,-86,-66,-34,-7,6,5}
        },
        {    // H50e176a.wav
            {1,7,7,2,1,3,0,-7,-8,-1,0,-8,-9,3,9,-5,-15,5,22,-9,13,419,1563,3361,4976,5051,2549,-2327,-7845,-11477,-11309,-7187,-784,5460,9711,11436,11098,9422,6974,4266,1961,741,896,2027,3180,3389,2287,345,-1471,-2427,-2514,-2285,-2276,-2608,-3061,-3359,-3356,-3072,-2688,-2450,-2466,-2590,-2564,-2264,-1761,-1169,-558,-11,367,561,706,939,1241,1492,1630,1659,1546,1230,793,500,568,922,1233,1224,898,479,167,-36,-278,-658,-1090,-1370,-1386,-1231,-1118,-1187,-1410,-1632,-1692,-1514,-1143,-712,-351,-120,-1,54,98,171,281,392,471,532,605,664,621,431,168,-22,-45,79,243,322,249,54,-161,-315,-398,-442,-461,-451,-439,-482,-605,-759,-877,-945,-993,-1030,-1009,-881,-652,-391,-186,-86,-77,-98,-92,-46,22,91,152,194,209,200,184,170,146,101,45,2,-17,-24,-41,-85,-161,-253,-329,-364,-359,-341,-335,-346,-362,-376,-384,-381,-359,-318,-272,-236,-209,-179,-136,-85,-42,-22,-23,-30,-25,-7,15,28,29,19,-3,-35,-71,-99,-113,-113,-106,-104,-116,-143,-173,-192,-195,-185,-167,-140,-109,-84,-75,-80,-92,-109,-130,-145,-140,-111,-72,-43,-36,-46,-62,-74,-80,-87,-101,-119,-130,-124,-101,-73,-50,-38,-35,-38,-44,-54,-72,-99,-129,-151,-154,-135,-99,-62,-43,-51,-78,-105,-115,-100,-64,-25},
            {7,1,0,2,0,-9,-10,-2,0,-9,-10,4,10,-8,-20,3,22,-15,20,520,1872,3913,5606,5404,2271,-3329,-9279,-12791,-11978,-6961,248,6982,11338,12823,11998,9731,6762,3756,1430,413,881,2306,3603,3707,2264,-80,-2142,-3099,-3038,-2674,-2625,-2982,-3453,-3714,-3608,-3200,-2750,-2547,-2642,-2771,-2628,-2168,-1562,-947,-350,165,478,600,737,1060,1495,1831,1962,1932,1771,1433,926,414,135,216,571,941,1053,814,364,-80,-443,-794,-1154,-1399,-1403,-1222,-1051,-1045,-1214,-1463,-1650,-1635,-1365,-937,-528,-237,-38,123,252,330,365,375,362,349,383,466,519,456,300,163,124,160,195,186,133,51,-43,-128,-196,-262,-340,-428,-514,-603,-711,-843,-988,-1113,-1167,-1097,-902,-658,-466,-376,-357,-346,-296,-195,-58,80,178,216,209,185,164,156,168,197,225,233,214,171,104,13,-87,-170,-219,-242,-259,-285,-320,-357,-389,-410,-421,-425,-424,-414,-391,-356,-315,-268,-215,-164,-122,-90,-62,-38,-22,-11,6,34,61,71,60,33,-5,-48,-85,-106,-113,-118,-126,-134,-144,-160,-182,-200,-205,-198,-179,-150,-115,-87,-75,-77,-84,-95,-110,-126,-131,-120,-100,-83,-74,-71,-69,-70,-79,-97,-123,-148,-160,-150,-121,-84,-52,-32,-25,-30,-44,-65,-89,-115,-136,-144,-134,-108,-75,-48,-37,-47,-74,-101,-111,-98,-71,-42,-19,-6}
        }
    },
    {    // elev60
        {    // H60e000a.wav
            {15,40,-27,-73,23,108,-10,-151,-19,188,33,-171,547,2315,3880,4323,4377,4671,3368,-2085,-10243,-14935,-11242,-1277,7882,11611,11172,9916,8697,6430,3351,1346,1356,2312,2917,3031,2765,1513,-1086,-3981,-5613,-5749,-5503,-5568,-5375,-4306,-2922,-2326,-2685,-3070,-2731,-1922,-1301,-997,-651,-117,373,704,1086,1622,2013,1972,1691,1578,1667,1642,1408,1231,1224,1084,578,-1,-189,17,215,201,143,149,18,-428,-1035,-1531,-1843,-2034,-2068,-1859,-1495,-1183,-982,-757,-422,-62,217,422,582,643,545,363,265,342,527,684,728,663,546,419,268,58,-198,-421,-526,-495,-382,-264,-197,-193,-210,-198,-156,-142,-204,-314,-410,-479,-551,-627,-657,-612,-544,-551,-684,-914,-1159,-1322,-1319,-1110,-739,-331,-20,141,194,210,212,183,110,21,-46,-76,-78,-62,-32,2,26,38,51,72,81,51,-29,-141,-258,-359,-430,-452,-407,-304,-186,-105,-82,-101,-140,-199,-280,-367,-424,-432,-402,-360,-312,-242,-137,-15,80,114,89,30,-35,-93,-134,-145,-115,-49,34,102,125,89,12,-67,-115,-132,-134,-131,-117,-87,-54,-35,-34,-45,-67,-102,-148,-195,-234,-258,-262,-245,-209,-157,-100,-59,-52,-80,-120,-147,-155,-153,-146,-128,-98,-63,-34,-13,-1,1,-6,-19,-40,-68,-91,-92,-64,-22,12,28,26,11,-14,-46,-86,-132,-177,-202,-192,-146,-83,-30},
            {15,40,-27,-73,23,108,-10,-151,-19,188,33,-171,547,2315,3880,4323,4377,4671,3368,-2085,-10243,-14935,-11242,-1277,7882,11611,11172,9916,8697,6430,3351,1346,1356,2312,2917,3031,2765,1513,-1086,-3981,-5613,-5749,-5503,-5568,-5375,-4306,-2922,-2326,-2685,-3070,-2731,-1922,-1301,-997,-651,-117,373,704,1086,1622,2013,1972,1691,1578,1667,1642,1408,1231,1224,1084,578,-1,-189,17,215,201,143,149,18,-428,-1035,-1531,-1843,-2034,-2068,-1859,-1495,-1183,-982,-757,-422,-62,217,422,582,643,545,363,265,342,527,684,728,663,546,419,268,58,-198,-421,-526,-495,-382,-264,-197,-193,-210,-198,-156,-142,-204,-314,-410,-479,-551,-627,-657,-612,-544,-551,-684,-914,-1159,-1322,-1319,-1110,-739,-331,-20,141,194,210,212,183,110,21,-46,-76,-78,-62,-32,2,26,38,51,72,81,51,-29,-141,-258,-359,-430,-452,-407,-304,-186,-105,-82,-101,-140,-199,-280,-367,-424,-432,-402,-360,-312,-242,-137,-15,80,114,89,30,-35,-93,-134,-145,-115,-49,34,102,125,89,12,-67,-115,-132,-134,-131,-117,-87,-54,-35,-34,-45,-67,-102,-148,-195,-234,-258,-262,-245,-209,-157,-100,-59,-52,-80,-120,-147,-155,-153,-146,-128,-98,-63,-34,-13,-1,1,-6,-19,-40,-68,-91,-92,-64,-22,12,28,26,11,-14,-46,-86,-132,-177,-202,-192,-146,-83,-30}
        },
        {    // H60e010a.wav
            {-33,-13,36,23,-53,-52,53,76,-60,-116,54,149,-58,-43,919,2527,3622,3839,3985,4023,1891,-3894,-10713,-13029,-8088,801,7795,10328,10130,9385,8093,5593,2748,1209,1330,2088,2653,2922,2629,1167,-1329,-3612,-4632,-4702,-4779,-5007,-4697,-3617,-2542,-2290,-2694,-2935,-2601,-2000,-1519,-1137,-676,-191,158,457,931,1525,1884,1836,1642,1612,1678,1592,1370,1243,1211,989,475,-13,-137,32,187,221,235,214,-20,-506,-1036,-1415,-1655,-1817,-1837,-1644,-1327,-1051,-856,-664,-433,-195,36,277,481,536,410,227,147,221,380,532,623,636,571,437,250,31,-182,-345,-419,-392,-288,-168,-110,-146,-215,-217,-140,-93,-189,-408,-616,-698,-648,-546,-466,-446,-504,-638,-816,-978,-1066,-1056,-953,-779,-561,-332,-131,26,143,218,231,158,15,-135,-229,-243,-195,-122,-59,-26,-20,-20,-9,12,22,1,-53,-133,-222,-302,-357,-378,-363,-316,-246,-171,-114,-92,-116,-182,-267,-339,-377,-381,-359,-319,-268,-204,-124,-28,63,111,92,27,-38,-79,-102,-114,-106,-68,-12,38,60,43,-10,-73,-113,-118,-106,-97,-91,-74,-45,-18,-10,-25,-59,-102,-143,-178,-211,-238,-245,-225,-188,-148,-113,-86,-78,-95,-128,-156,-172,-176,-162,-124,-72,-30,-11,-10,-18,-29,-39,-40,-36,-41,-54,-56,-39,-18,-7,0,4,-7,-36,-62,-73,-87,-131,-177,-164,-83},
            {16,-95,-41,123,82,-145,-131,166,174,-195,92,1791,3900,4858,4881,5238,4924,563,-8428,-16269,-15503,-5425,6599,12983,12996,10879,9302,7399,4352,1706,1181,2231,3140,3302,3044,2045,-414,-3775,-6238,-6836,-6448,-6258,-6104,-5136,-3531,-2509,-2670,-3186,-2963,-1999,-1125,-760,-536,-75,468,847,1209,1767,2270,2265,1806,1445,1468,1575,1457,1273,1249,1161,660,-47,-351,-66,332,394,230,141,74,-254,-872,-1513,-1981,-2270,-2357,-2160,-1740,-1335,-1083,-872,-543,-110,289,571,727,739,612,435,350,424,601,770,842,795,677,544,386,136,-208,-528,-692,-683,-582,-454,-305,-150,-47,-40,-108,-197,-270,-323,-364,-410,-474,-539,-565,-536,-496,-532,-708,-1010,-1344,-1579,-1597,-1352,-894,-368,45,230,212,130,109,161,211,204,157,119,107,105,91,63,31,17,43,105,158,144,37,-141,-333,-482,-549,-524,-421,-280,-150,-79,-71,-95,-124,-167,-247,-353,-436,-460,-439,-400,-339,-237,-104,17,89,111,94,42,-43,-138,-205,-212,-150,-37,83,163,175,123,39,-48,-121,-175,-201,-191,-146,-82,-24,10,18,2,-39,-105,-180,-243,-279,-288,-280,-259,-220,-161,-93,-43,-34,-66,-109,-131,-132,-133,-145,-151,-130,-81,-24,18,35,28,10,-12,-39,-74,-104,-112,-86,-39,6,36,49,40,6,-48,-106,-155,-185,-188,-161,-114,-68,-37,-19,-6}
        },
        {    // H60e020a.wav
            {17,-10,-33,-4,36,8,-51,-24,60,40,-75,-66,88,94,-85,120,1153,2496,3249,3411,3617,3344,689,-4888,-10307,-11038,-5846,1753,7243,9260,9347,8800,7368,4862,2375,1198,1377,2041,2588,2829,2396,910,-1234,-2986,-3775,-4028,-4322,-4504,-4056,-3069,-2305,-2278,-2672,-2834,-2535,-2032,-1573,-1147,-701,-315,-25,329,888,1481,1779,1715,1568,1569,1624,1537,1342,1205,1101,842,414,70,3,118,215,250,263,188,-91,-534,-967,-1296,-1553,-1729,-1719,-1488,-1174,-947,-828,-717,-547,-318,-44,238,425,404,199,4,17,256,559,742,739,612,456,309,156,-16,-178,-290,-335,-316,-238,-125,-46,-71,-190,-315,-372,-374,-388,-446,-508,-520,-481,-439,-443,-506,-607,-713,-795,-837,-830,-771,-667,-541,-421,-323,-239,-144,-24,96,163,140,36,-103,-225,-297,-307,-266,-202,-143,-103,-75,-45,-15,-4,-31,-96,-179,-254,-304,-325,-320,-297,-262,-221,-180,-144,-122,-124,-154,-202,-249,-281,-294,-288,-262,-221,-169,-106,-32,38,77,63,8,-55,-97,-111,-106,-90,-65,-37,-15,-9,-23,-53,-85,-105,-103,-84,-61,-40,-21,-1,11,1,-33,-78,-119,-149,-172,-193,-207,-211,-206,-187,-154,-118,-95,-94,-108,-128,-151,-171,-175,-154,-113,-66,-26,-4,-4,-19,-34,-39,-37,-39,-45,-48,-47,-42,-30,-15,-10,-22,-37,-38,-39,-67,-108,-113,-62},
            {-95,102,163,-82,-231,50,287,-56,-269,952,3368,5122,5423,5620,6065,3600,-4678,-15222,-19121,-11418,2645,12994,15065,12373,9821,8089,5585,2696,1429,2138,3142,3362,3213,2739,833,-2800,-6355,-7843,-7472,-6929,-6816,-6178,-4535,-3006,-2780,-3380,-3352,-2245,-1012,-496,-391,-3,653,1095,1302,1713,2353,2642,2243,1604,1311,1337,1307,1201,1252,1300,884,41,-528,-348,210,488,387,256,197,-60,-643,-1328,-1893,-2330,-2614,-2571,-2153,-1622,-1254,-1017,-693,-231,222,553,759,835,747,552,420,476,681,889,985,943,816,672,516,291,-44,-428,-744,-918,-929,-771,-481,-181,-25,-50,-146,-200,-211,-240,-309,-394,-476,-544,-563,-502,-400,-378,-553,-934,-1405,-1782,-1892,-1645,-1091,-427,85,274,184,36,33,181,332,366,303,233,202,189,167,136,105,81,83,124,173,160,41,-156,-360,-505,-567,-547,-460,-335,-215,-136,-99,-82,-73,-98,-188,-325,-451,-514,-506,-438,-318,-165,-27,51,74,78,75,40,-47,-156,-231,-230,-153,-33,80,145,160,139,90,1,-122,-235,-285,-261,-192,-115,-48,7,49,60,25,-57,-162,-255,-315,-344,-349,-325,-264,-176,-87,-22,2,-17,-65,-116,-155,-183,-200,-190,-138,-56,18,57,64,52,28,-10,-57,-100,-125,-124,-99,-59,-16,20,38,28,-12,-70,-122,-152,-157,-145,-123,-93,-63,-42,-32,-27,-19,-9}
        },
        {    // H60e030a.wav
            {-3,12,12,-16,-27,7,31,-7,-45,-2,55,8,-73,-20,96,39,-72,295,1321,2400,2915,3094,3302,2653,-440,-5685,-9818,-9301,-4043,2495,6899,8564,8741,8136,6513,4094,2035,1245,1510,2080,2531,2671,2145,745,-1060,-2465,-3180,-3570,-3906,-3931,-3373,-2559,-2142,-2330,-2689,-2723,-2381,-1924,-1511,-1116,-732,-423,-139,296,916,1461,1647,1520,1392,1436,1519,1469,1320,1188,1039,763,408,169,131,191,229,244,240,123,-185,-609,-996,-1286,-1499,-1604,-1530,-1309,-1093,-979,-906,-761,-537,-314,-139,6,138,232,272,298,366,483,592,628,576,466,336,204,75,-36,-116,-168,-209,-241,-253,-249,-257,-297,-343,-348,-305,-268,-296,-389,-485,-521,-489,-439,-433,-487,-570,-635,-662,-657,-628,-582,-532,-492,-460,-411,-321,-191,-48,72,132,108,11,-119,-239,-328,-381,-386,-335,-246,-162,-113,-99,-94,-90,-102,-138,-189,-237,-274,-296,-292,-254,-197,-149,-130,-131,-129,-119,-115,-128,-151,-175,-200,-223,-233,-215,-169,-107,-47,-3,13,-1,-42,-89,-122,-131,-121,-101,-79,-60,-48,-46,-56,-73,-86,-84,-68,-46,-22,-1,13,14,2,-20,-47,-79,-112,-141,-164,-182,-194,-196,-186,-170,-152,-134,-119,-113,-118,-130,-143,-156,-163,-153,-116,-64,-21,-2,-1,-9,-25,-46,-62,-65,-61,-58,-51,-37,-24,-23,-30,-34,-39,-56,-77,-75,-40},
            {138,38,-195,-119,245,210,-289,18,2065,4653,5885,6017,6564,6223,790,-10369,-19902,-18470,-5460,9442,16472,14993,11026,8579,6765,4218,2200,2189,3226,3521,3090,2852,2186,-469,-4761,-8135,-8874,-7962,-7216,-6795,-5739,-4138,-3274,-3601,-3903,-2998,-1367,-346,-238,-137,555,1359,1698,1822,2237,2732,2674,2043,1483,1348,1325,1147,1042,1155,1072,419,-391,-597,-124,362,420,291,294,252,-171,-928,-1685,-2263,-2660,-2794,-2551,-2047,-1578,-1256,-921,-440,89,486,699,773,741,632,534,551,709,932,1094,1112,995,832,685,505,198,-244,-711,-1058,-1174,-1003,-607,-213,-70,-202,-375,-364,-205,-100,-159,-310,-439,-507,-515,-464,-386,-371,-513,-830,-1246,-1629,-1835,-1752,-1367,-794,-230,141,259,205,135,156,265,386,450,431,341,217,119,92,125,167,190,202,210,178,63,-122,-314,-456,-530,-547,-512,-427,-312,-199,-117,-72,-59,-83,-155,-271,-400,-498,-525,-461,-318,-149,-15,58,94,119,116,49,-75,-191,-239,-204,-118,-24,54,110,151,169,133,22,-134,-262,-308,-282,-224,-160,-92,-19,47,81,62,-12,-120,-222,-293,-335,-360,-361,-321,-240,-136,-33,42,61,12,-82,-175,-235,-253,-225,-152,-57,25,76,104,112,89,30,-43,-103,-137,-145,-127,-85,-32,11,28,15,-23,-72,-107,-117,-112,-108,-107,-98,-76,-47,-15,6,8,-7,-20,-15}
        },
        {    // H60e040a.wav
            {11,-1,-3,9,6,-17,-17,15,21,-20,-35,16,45,-15,-58,19,86,-7,-22,481,1457,2299,2667,2891,3009,1897,-1593,-6427,-9332,-7743,-2459,3242,6832,8168,8211,7350,5545,3351,1807,1392,1698,2135,2453,2477,1882,583,-947,-2103,-2765,-3198,-3469,-3340,-2773,-2204,-2093,-2385,-2621,-2503,-2138,-1760,-1425,-1080,-745,-468,-163,320,922,1355,1429,1292,1239,1356,1477,1457,1325,1156,940,660,402,265,230,204,163,145,116,-34,-332,-678,-966,-1191,-1380,-1482,-1428,-1248,-1065,-963,-927,-886,-767,-509,-113,297,532,511,354,265,329,458,523,490,413,345,287,223,149,56,-80,-270,-465,-574,-532,-362,-164,-49,-69,-195,-346,-446,-469,-442,-402,-365,-338,-343,-397,-477,-533,-540,-529,-541,-573,-586,-551,-482,-408,-343,-277,-194,-92,5,54,27,-64,-173,-259,-318,-366,-405,-416,-384,-318,-239,-164,-101,-65,-75,-129,-197,-244,-258,-249,-222,-178,-125,-84,-66,-64,-68,-77,-94,-112,-122,-128,-144,-171,-197,-207,-189,-146,-94,-53,-38,-53,-86,-122,-148,-159,-153,-129,-93,-57,-31,-22,-29,-44,-56,-57,-46,-30,-14,-1,9,13,7,-10,-36,-65,-94,-122,-150,-174,-187,-188,-180,-167,-151,-136,-127,-127,-130,-132,-135,-139,-135,-114,-82,-51,-30,-19,-17,-24,-36,-47,-55,-62,-64,-58,-48,-42,-38,-32,-29,-39,-54,-53,-28},
            {37,-233,-84,297,129,-364,339,2825,5410,6427,6688,7325,5869,-1824,-14228,-21989,-16732,-1095,13263,17797,14315,9755,7412,5838,3873,2727,3157,3791,3423,2796,2676,1788,-1474,-6108,-9201,-9428,-8232,-7323,-6596,-5330,-4076,-3942,-4570,-4328,-2611,-739,-94,-306,-58,960,1892,2217,2383,2787,3015,2589,1850,1475,1497,1437,1182,1055,1045,684,-110,-683,-499,96,390,267,168,258,195,-295,-1054,-1804,-2457,-2935,-3013,-2594,-1957,-1477,-1184,-825,-277,287,639,733,673,576,521,558,702,919,1132,1246,1199,1029,845,690,466,55,-503,-1005,-1247,-1154,-807,-410,-197,-263,-460,-543,-423,-239,-161,-209,-299,-377,-439,-466,-438,-403,-467,-697,-1048,-1395,-1613,-1627,-1432,-1078,-651,-245,56,211,259,285,348,425,456,417,331,233,157,128,151,186,187,163,162,188,176,60,-147,-363,-517,-588,-582,-513,-401,-278,-171,-98,-65,-77,-134,-230,-347,-454,-503,-453,-317,-164,-63,-15,35,112,165,121,-17,-163,-232,-213,-151,-79,-2,79,146,173,142,45,-96,-230,-304,-306,-267,-216,-150,-66,19,71,66,8,-81,-177,-261,-327,-369,-379,-349,-281,-188,-82,17,71,43,-59,-174,-242,-253,-231,-187,-120,-38,39,96,127,124,79,6,-62,-106,-133,-148,-140,-103,-55,-20,-6,-12,-32,-56,-72,-81,-99,-126,-140,-119,-70,-22,12,32,30,-3,-45,-59,-33}
        },
        {    // H60e050a.wav
            {2,9,5,-3,4,12,-2,-19,-4,21,6,-31,-18,32,26,-35,-30,55,55,-42,101,757,1644,2243,2525,2787,2610,739,-3240,-7413,-8689,-5756,-389,4412,7063,7857,7515,6279,4404,2642,1710,1614,1870,2153,2363,2268,1556,299,-996,-1923,-2513,-2925,-3066,-2773,-2240,-1938,-2081,-2387,-2454,-2208,-1863,-1571,-1299,-1005,-737,-489,-124,432,996,1278,1225,1085,1113,1299,1451,1440,1282,1039,760,508,344,255,172,78,28,35,11,-135,-393,-683,-950,-1169,-1300,-1316,-1280,-1288,-1331,-1270,-1002,-592,-203,66,231,329,366,345,304,288,302,328,360,411,465,463,353,133,-137,-376,-524,-559,-491,-348,-179,-48,-16,-102,-266,-422,-489,-441,-324,-218,-182,-223,-310,-404,-473,-499,-489,-470,-469,-490,-513,-518,-496,-452,-396,-337,-280,-220,-152,-82,-38,-46,-109,-198,-286,-367,-440,-489,-491,-438,-344,-235,-138,-72,-51,-76,-128,-177,-201,-199,-179,-144,-98,-55,-28,-22,-32,-49,-71,-95,-115,-127,-135,-148,-173,-200,-213,-202,-170,-131,-99,-88,-102,-133,-164,-179,-174,-153,-118,-73,-26,8,17,3,-22,-42,-49,-43,-30,-15,-1,10,13,5,-12,-34,-56,-81,-114,-150,-177,-190,-191,-185,-172,-154,-139,-133,-134,-132,-125,-118,-114,-107,-95,-77,-61,-52,-47,-41,-36,-38,-45,-52,-57,-64,-71,-68,-53,-39,-38,-46,-43,-23},
            {-215,57,330,1,-429,510,3131,5713,6836,7332,7868,5599,-3176,-15891,-22682,-15852,729,14833,18362,13910,8826,6446,5296,4067,3531,3974,4065,3178,2532,2729,1955,-1643,-6775,-10082,-10075,-8385,-7037,-6188,-5187,-4397,-4574,-5143,-4588,-2624,-740,-201,-443,-111,1023,2069,2531,2826,3242,3325,2709,1875,1521,1612,1626,1421,1247,1041,438,-445,-896,-542,96,326,166,89,188,89,-419,-1143,-1859,-2526,-3041,-3126,-2684,-2007,-1458,-1075,-655,-123,364,629,654,559,480,493,598,769,994,1235,1375,1310,1092,877,680,333,-244,-832,-1117,-1030,-780,-580,-489,-476,-518,-568,-551,-447,-326,-264,-269,-311,-372,-430,-452,-443,-472,-609,-854,-1134,-1351,-1424,-1326,-1096,-816,-545,-299,-73,131,311,458,540,518,405,275,191,151,131,133,164,191,179,150,153,180,160,38,-160,-364,-521,-607,-609,-531,-402,-263,-150,-84,-68,-95,-156,-253,-374,-465,-467,-368,-229,-120,-55,1,71,127,122,46,-61,-146,-185,-183,-149,-84,4,88,134,128,75,-17,-131,-237,-301,-310,-274,-206,-119,-37,17,35,24,-14,-91,-199,-302,-365,-384,-370,-325,-244,-137,-35,29,33,-25,-120,-205,-245,-243,-220,-181,-115,-26,58,112,124,101,50,-15,-72,-112,-140,-157,-152,-121,-79,-43,-16,3,5,-16,-52,-90,-125,-155,-162,-127,-62,-1,32,39,29,-1,-52,-96,-95,-50}
        },
        {    // H60e060a.wav
            {-6,-1,10,8,-2,-2,8,5,-14,-13,12,17,-15,-26,13,34,-11,-41,20,67,-9,-15,388,1167,1870,2250,2533,2669,1695,-1320,-5528,-8229,-7186,-2818,2290,5849,7346,7381,6466,4898,3229,2123,1762,1809,1959,2172,2316,2006,1044,-230,-1284,-1948,-2392,-2666,-2598,-2190,-1813,-1820,-2118,-2310,-2187,-1893,-1633,-1412,-1149,-869,-637,-378,52,613,1041,1138,1007,926,1042,1266,1412,1364,1112,748,426,265,234,201,100,6,-4,13,-59,-242,-458,-666,-910,-1204,-1455,-1537,-1421,-1181,-905,-643,-419,-241,-96,38,160,241,265,252,237,245,287,363,437,438,307,66,-181,-328,-350,-304,-263,-252,-250,-232,-203,-185,-197,-240,-296,-331,-313,-241,-162,-140,-202,-318,-429,-482,-461,-391,-331,-332,-396,-482,-537,-539,-501,-448,-397,-355,-315,-261,-188,-118,-91,-131,-221,-320,-393,-430,-441,-436,-417,-373,-296,-195,-96,-31,-18,-51,-102,-139,-148,-134,-108,-80,-53,-33,-22,-22,-33,-57,-93,-133,-164,-174,-169,-169,-183,-206,-223,-221,-197,-162,-132,-120,-128,-149,-168,-172,-156,-124,-83,-40,0,26,28,9,-14,-27,-28,-23,-17,-10,-3,1,-2,-13,-30,-49,-67,-88,-115,-147,-174,-189,-190,-182,-167,-149,-136,-130,-128,-124,-118,-115,-111,-99,-81,-66,-59,-54,-47,-44,-47,-52,-54,-56,-63,-68,-65,-58,-56,-58,-49,-25},
            {-72,303,122,-387,271,2760,5585,7102,7764,8246,6078,-2372,-15086,-22660,-16931,-703,14164,18708,14461,8780,5915,4976,4316,4098,4465,4318,3210,2459,2827,2491,-802,-6207,-10235,-10746,-8933,-7070,-5889,-5009,-4593,-5055,-5641,-4903,-2774,-930,-599,-982,-550,840,2073,2578,2872,3343,3521,2983,2191,1843,1893,1831,1584,1442,1289,663,-350,-968,-721,-99,171,58,14,133,39,-477,-1197,-1880,-2524,-3077,-3248,-2843,-2097,-1434,-996,-599,-101,368,594,552,428,411,527,680,820,995,1222,1390,1371,1186,950,651,162,-488,-988,-1048,-749,-453,-409,-549,-677,-704,-654,-560,-447,-358,-336,-373,-422,-450,-454,-451,-472,-554,-714,-923,-1115,-1220,-1197,-1053,-843,-632,-439,-244,-43,145,302,430,510,499,388,240,137,101,96,100,120,153,174,174,174,181,151,33,-161,-363,-510,-582,-588,-536,-431,-294,-167,-81,-46,-59,-125,-241,-371,-447,-421,-313,-192,-108,-53,6,71,108,88,24,-45,-100,-146,-178,-168,-101,-7,63,85,75,45,-16,-117,-228,-301,-309,-260,-181,-102,-45,-16,-1,11,0,-65,-177,-292,-366,-387,-361,-297,-207,-114,-43,-7,-8,-46,-112,-182,-229,-248,-241,-200,-123,-22,68,118,122,91,40,-19,-77,-128,-169,-188,-175,-129,-66,-6,36,47,26,-18,-69,-112,-142,-158,-150,-111,-49,9,39,37,15,-13,-46,-82,-105,-93,-47}
        },
        {    // H60e070a.wav
            {-1,-5,-2,8,10,0,-2,8,7,-10,-14,8,17,-9,-24,8,33,-2,-36,11,63,3,-35,270,962,1666,2096,2402,2599,1879,-735,-4745,-7766,-7418,-3611,1421,5253,7009,7135,6264,4822,3323,2324,1962,1921,1947,2088,2300,2176,1367,96,-1031,-1687,-2019,-2230,-2261,-2033,-1744,-1704,-1930,-2129,-2080,-1853,-1620,-1408,-1159,-900,-701,-508,-168,334,794,996,948,848,864,1012,1189,1257,1111,765,385,169,157,207,177,81,22,29,16,-113,-385,-751,-1099,-1296,-1269,-1084,-897,-802,-752,-656,-500,-343,-222,-112,10,125,204,247,274,283,254,178,83,11,-17,-17,-18,-37,-71,-113,-169,-242,-316,-355,-330,-245,-145,-92,-121,-209,-289,-305,-262,-218,-224,-277,-333,-349,-319,-274,-256,-293,-383,-489,-558,-562,-519,-468,-440,-433,-419,-371,-291,-213,-179,-205,-268,-326,-353,-352,-348,-356,-364,-345,-283,-187,-83,-5,26,9,-37,-83,-108,-109,-92,-68,-48,-40,-43,-52,-67,-92,-128,-164,-187,-193,-190,-189,-198,-220,-242,-244,-217,-171,-127,-101,-100,-120,-148,-164,-154,-122,-81,-37,3,30,34,19,0,-12,-15,-11,-4,1,-1,-11,-23,-35,-45,-53,-60,-71,-93,-123,-152,-171,-178,-173,-159,-144,-137,-137,-138,-133,-124,-113,-99,-84,-71,-61,-52,-46,-51,-66,-77,-74,-64,-57,-54,-51,-50,-59,-69,-61,-31},
            {155,147,-257,-89,1725,4593,6833,7960,8554,7303,822,-11012,-21026,-19899,-6426,9902,18173,16256,10313,6306,4986,4520,4283,4502,4504,3599,2678,2896,3167,946,-4152,-9172,-11023,-9712,-7532,-6058,-5239,-4845,-5118,-5718,-5398,-3593,-1509,-730,-1151,-1239,-154,1375,2377,2861,3267,3469,3093,2408,2100,2271,2363,2072,1697,1432,968,134,-584,-644,-246,-20,-124,-170,21,88,-317,-1073,-1853,-2533,-3091,-3335,-3053,-2344,-1580,-1014,-601,-198,190,438,482,416,394,483,631,785,972,1213,1405,1405,1212,947,635,167,-438,-897,-936,-645,-382,-365,-508,-636,-689,-681,-605,-472,-373,-388,-480,-553,-563,-533,-499,-498,-580,-760,-964,-1080,-1068,-981,-881,-769,-602,-361,-88,135,245,260,263,312,378,392,329,222,115,35,4,37,113,178,198,189,169,127,29,-126,-301,-453,-558,-598,-560,-450,-305,-177,-93,-49,-41,-85,-191,-322,-402,-388,-303,-207,-128,-56,15,64,69,43,16,1,-24,-83,-158,-196,-165,-84,-5,44,68,65,13,-92,-212,-289,-301,-261,-194,-121,-67,-40,-19,12,24,-27,-141,-257,-323,-338,-326,-291,-226,-145,-76,-30,-8,-21,-77,-157,-224,-258,-259,-225,-151,-52,39,95,113,100,59,-3,-73,-141,-196,-224,-208,-147,-61,19,71,79,43,-20,-79,-118,-138,-142,-124,-87,-42,-3,24,31,14,-17,-44,-63,-83,-99,-89,-45}
        },
        {    // H60e080a.wav
            {0,-2,-4,2,9,6,-1,2,10,2,-15,-10,13,12,-17,-20,18,30,-12,-29,29,59,-19,-19,350,1048,1699,2111,2438,2524,1462,-1488,-5418,-7839,-6764,-2605,2262,5650,6953,6726,5650,4229,2981,2301,2130,2108,2080,2172,2333,2142,1275,-21,-1152,-1768,-1964,-1959,-1851,-1710,-1680,-1826,-1993,-1981,-1804,-1645,-1572,-1460,-1211,-907,-667,-453,-143,255,588,756,801,814,832,874,962,1054,1018,775,430,180,108,138,179,210,202,75,-195,-494,-675,-731,-770,-843,-881,-821,-706,-631,-624,-636,-612,-529,-378,-173,31,167,210,183,113,4,-118,-182,-126,25,167,212,158,64,-21,-95,-172,-242,-287,-299,-276,-219,-145,-102,-140,-252,-365,-398,-331,-220,-140,-126,-164,-214,-247,-260,-276,-323,-402,-482,-526,-528,-515,-517,-538,-557,-549,-499,-411,-307,-223,-189,-206,-249,-289,-313,-325,-328,-314,-267,-185,-86,0,47,47,15,-28,-62,-78,-78,-69,-63,-67,-81,-99,-118,-137,-158,-179,-198,-210,-214,-214,-218,-231,-247,-248,-223,-175,-124,-89,-78,-90,-114,-139,-151,-141,-110,-65,-20,11,22,14,-2,-13,-14,-9,-3,-2,-5,-10,-15,-20,-31,-47,-63,-78,-94,-110,-123,-132,-139,-144,-145,-145,-148,-151,-148,-137,-125,-114,-101,-85,-72,-64,-59,-56,-61,-76,-89,-89,-80,-71,-61,-46,-37,-50,-74,-76,-42},
            {216,-49,-352,416,2717,5489,7462,8547,8524,5113,-3887,-15517,-21297,-14873,379,13777,17688,13697,8383,5637,4828,4421,4265,4368,4030,3181,2915,3471,2910,-671,-6154,-10117,-10528,-8539,-6488,-5411,-5070,-5248,-5789,-5894,-4685,-2587,-1151,-1149,-1594,-1134,236,1518,2238,2769,3284,3343,2756,2137,2111,2470,2591,2337,1985,1542,772,-136,-561,-296,116,125,-127,-195,-76,-180,-712,-1475,-2249,-2962,-3459,-3443,-2813,-1892,-1129,-685,-412,-146,117,311,419,477,515,544,594,738,1014,1326,1482,1369,1056,666,233,-235,-604,-702,-561,-425,-457,-562,-582,-521,-491,-508,-501,-462,-463,-526,-592,-619,-623,-612,-578,-570,-678,-891,-1062,-1066,-943,-817,-729,-602,-364,-53,212,333,304,212,166,212,303,361,342,247,103,-35,-91,-33,90,188,218,197,148,65,-65,-228,-389,-514,-580,-570,-483,-348,-211,-107,-50,-38,-72,-149,-250,-329,-348,-309,-246,-185,-117,-33,42,70,48,18,11,14,-17,-93,-172,-200,-166,-101,-37,19,62,63,-10,-137,-255,-308,-293,-240,-177,-118,-69,-25,18,46,19,-72,-188,-270,-299,-296,-277,-239,-183,-126,-75,-28,2,-17,-93,-187,-252,-275,-260,-207,-119,-25,43,77,89,79,38,-34,-117,-187,-228,-230,-188,-111,-24,46,81,70,18,-48,-96,-117,-119,-106,-78,-42,-12,7,17,13,-10,-41,-62,-71,-84,-98,-88,-45}
        },
        {    // H60e090a.wav
            {-1,-2,-5,-3,5,7,0,-1,8,8,-9,-16,2,14,-6,-24,2,32,9,-28,3,57,13,-60,131,715,1427,1955,2330,2570,2040,-186,-3911,-7145,-7496,-4372,461,4532,6556,6735,5836,4507,3269,2521,2302,2299,2275,2300,2430,2370,1733,555,-680,-1529,-1924,-2001,-1859,-1611,-1495,-1684,-2021,-2144,-1915,-1578,-1428,-1455,-1426,-1216,-901,-569,-216,146,403,481,475,553,747,942,1038,1033,951,782,552,362,292,298,259,121,-59,-188,-235,-241,-287,-430,-642,-804,-805,-663,-523,-507,-603,-700,-706,-608,-442,-256,-104,-28,-35,-95,-163,-203,-191,-120,-10,102,180,207,183,120,48,-8,-37,-57,-96,-161,-233,-283,-300,-299,-309,-344,-379,-370,-293,-174,-72,-37,-76,-156,-232,-271,-275,-274,-301,-361,-435,-498,-544,-583,-628,-680,-716,-695,-588,-410,-224,-104,-85,-149,-248,-330,-364,-339,-268,-175,-85,-13,33,49,41,22,2,-19,-43,-64,-77,-86,-100,-124,-152,-178,-201,-219,-230,-233,-232,-231,-232,-235,-238,-237,-226,-200,-162,-119,-83,-64,-67,-87,-113,-131,-132,-114,-83,-47,-18,-6,-8,-15,-21,-27,-31,-28,-19,-10,-4,-1,-3,-16,-43,-75,-98,-107,-105,-100,-99,-105,-115,-128,-141,-152,-155,-148,-135,-122,-111,-98,-86,-80,-79,-76,-70,-70,-82,-95,-97,-91,-86,-76,-58,-47,-64,-94,-95,-52},
            {193,-96,-317,552,2843,5585,7658,8753,8206,3877,-5451,-16038,-20020,-12644,1882,13715,16673,12833,8128,5725,4901,4348,4022,4004,3773,3286,3293,3676,2643,-1180,-6405,-9874,-9953,-7885,-5896,-4999,-4992,-5505,-6109,-5977,-4533,-2460,-1214,-1308,-1707,-1228,74,1324,2110,2660,3043,2964,2450,2073,2213,2548,2601,2377,2115,1724,979,111,-314,-152,141,179,91,111,83,-315,-1071,-1875,-2553,-3126,-3495,-3374,-2670,-1709,-953,-577,-425,-278,-59,186,388,511,553,544,555,671,923,1216,1370,1274,963,546,104,-274,-467,-437,-343,-397,-602,-731,-623,-386,-241,-273,-395,-511,-593,-636,-643,-637,-640,-636,-616,-635,-754,-931,-1044,-1025,-929,-822,-688,-468,-165,136,331,369,280,167,133,198,300,357,340,253,111,-42,-126,-90,27,134,183,185,155,73,-76,-262,-432,-543,-574,-526,-415,-283,-172,-100,-59,-46,-76,-154,-252,-319,-326,-289,-239,-186,-117,-35,29,49,41,38,48,37,-22,-113,-184,-200,-167,-114,-57,-1,41,39,-29,-140,-244,-301,-303,-263,-201,-135,-73,-13,40,60,17,-81,-181,-240,-263,-271,-262,-221,-158,-102,-63,-28,-3,-21,-93,-183,-248,-273,-263,-216,-134,-43,25,62,74,62,17,-56,-135,-197,-229,-222,-175,-103,-27,31,56,42,0,-44,-69,-78,-80,-76,-57,-26,3,17,17,2,-26,-59,-83,-93,-97,-94,-73,-34}
        },
        {    // H60e100a.wav
            {-3,-3,-4,-1,6,6,-2,-2,8,9,-7,-14,2,11,-10,-26,1,31,8,-26,7,57,8,-64,129,711,1432,1996,2407,2622,1982,-369,-4120,-7237,-7395,-4120,746,4731,6593,6596,5578,4246,3119,2525,2421,2462,2436,2456,2587,2513,1821,562,-730,-1574,-1926,-1995,-1920,-1765,-1671,-1782,-2023,-2140,-1997,-1722,-1513,-1408,-1313,-1171,-978,-696,-281,180,481,515,408,390,569,875,1162,1287,1156,806,449,317,406,453,237,-142,-367,-275,-32,60,-128,-467,-739,-819,-733,-593,-506,-510,-568,-611,-592,-507,-391,-293,-260,-307,-392,-430,-354,-176,14,123,130,94,82,104,127,138,147,155,137,73,-19,-108,-187,-276,-384,-482,-530,-510,-429,-308,-178,-76,-31,-45,-98,-167,-229,-259,-245,-211,-204,-257,-357,-466,-560,-646,-735,-812,-838,-775,-616,-396,-188,-65,-62,-152,-271,-353,-363,-301,-192,-77,9,52,63,64,63,54,29,-7,-45,-76,-99,-117,-136,-164,-203,-244,-273,-282,-274,-261,-250,-241,-235,-233,-231,-222,-201,-170,-134,-98,-67,-49,-54,-76,-100,-112,-113,-106,-92,-68,-40,-22,-20,-30,-43,-53,-59,-55,-39,-17,-1,-1,-14,-36,-59,-74,-78,-75,-70,-68,-76,-93,-113,-127,-135,-140,-141,-134,-122,-111,-104,-98,-91,-89,-90,-88,-82,-79,-87,-97,-98,-93,-91,-89,-83,-82,-97,-114,-100,-51},
            {154,-16,-264,270,2175,4895,7294,8656,8256,4444,-3864,-13874,-18855,-13733,-893,11225,15886,13468,9010,6184,5018,4294,3779,3698,3738,3597,3599,3748,2801,-487,-5288,-8932,-9548,-7797,-5738,-4704,-4726,-5349,-6051,-6098,-4938,-3021,-1605,-1373,-1662,-1398,-390,762,1663,2400,2922,2882,2298,1818,1966,2470,2701,2493,2132,1735,1167,507,125,153,275,219,140,249,339,-14,-877,-1901,-2752,-3325,-3539,-3242,-2460,-1565,-980,-789,-726,-526,-169,178,377,422,404,410,482,626,823,1013,1108,1053,863,588,274,-9,-171,-200,-235,-421,-694,-814,-643,-319,-96,-94,-254,-464,-634,-710,-687,-630,-605,-608,-608,-635,-747,-918,-1033,-1031,-959,-871,-732,-481,-150,148,320,353,297,221,184,208,266,312,315,265,159,20,-95,-125,-64,38,124,171,170,107,-26,-206,-382,-504,-545,-506,-412,-301,-200,-120,-63,-41,-68,-140,-231,-302,-327,-308,-263,-205,-136,-63,-3,28,36,46,65,66,17,-77,-167,-203,-177,-122,-68,-20,17,21,-30,-125,-224,-288,-307,-285,-230,-157,-84,-21,31,57,31,-46,-136,-198,-229,-248,-252,-222,-159,-93,-46,-15,2,-15,-78,-164,-236,-271,-267,-226,-155,-73,-1,45,65,56,13,-58,-134,-193,-222,-215,-173,-109,-44,6,32,31,9,-18,-34,-40,-47,-53,-44,-18,10,23,16,-5,-36,-69,-94,-104,-103,-91,-64,-27}
        },
        {    // H60e110a.wav
            {-3,-5,-5,3,9,4,-4,0,9,2,-13,-8,11,5,-22,-20,17,26,-12,-21,34,50,-35,-26,348,1052,1765,2300,2673,2552,1072,-2187,-6002,-7897,-6212,-1701,3134,6162,6911,6138,4777,3478,2650,2411,2507,2584,2578,2641,2703,2371,1386,12,-1184,-1860,-2072,-2030,-1896,-1817,-1938,-2228,-2424,-2291,-1912,-1595,-1504,-1503,-1375,-1076,-713,-360,-21,273,444,478,481,579,795,1048,1225,1242,1088,850,644,487,280,-17,-252,-227,25,218,110,-237,-564,-706,-712,-702,-710,-692,-628,-544,-476,-436,-421,-419,-419,-420,-440,-479,-495,-424,-254,-48,110,176,162,106,54,51,117,223,294,266,147,11,-73,-110,-167,-294,-466,-602,-626,-527,-360,-210,-137,-139,-162,-159,-131,-113,-129,-165,-194,-207,-217,-245,-312,-430,-592,-759,-870,-880,-786,-627,-452,-298,-196,-162,-188,-244,-294,-311,-279,-197,-89,5,61,84,96,103,97,68,24,-23,-65,-102,-133,-161,-190,-227,-268,-299,-306,-291,-268,-252,-246,-243,-240,-236,-227,-207,-172,-126,-83,-53,-40,-45,-64,-88,-106,-110,-101,-87,-71,-50,-30,-25,-39,-61,-78,-84,-78,-65,-51,-42,-38,-37,-37,-38,-35,-27,-19,-22,-37,-59,-80,-100,-115,-122,-119,-111,-104,-99,-96,-97,-100,-103,-104,-103,-99,-92,-85,-83,-86,-88,-89,-98,-114,-121,-111,-98,-101,-110,-94,-47},
            {64,101,-120,-101,1021,3384,6094,8071,8493,6190,-81,-9303,-16603,-16148,-6837,5698,13869,14697,11075,7369,5319,4281,3608,3418,3671,3900,3938,3910,3308,1029,-3059,-7174,-9046,-8160,-6058,-4568,-4309,-4876,-5652,-6039,-5490,-3992,-2381,-1598,-1641,-1648,-1014,31,1011,1826,2509,2809,2496,1903,1674,1993,2426,2538,2314,1909,1364,759,363,341,493,512,398,359,377,164,-470,-1394,-2349,-3134,-3533,-3324,-2533,-1588,-1005,-917,-1010,-902,-506,-21,311,400,328,249,276,424,622,779,842,818,745,641,499,330,189,93,-47,-333,-696,-894,-751,-367,-25,73,-72,-338,-593,-739,-739,-643,-553,-524,-538,-581,-682,-842,-991,-1050,-1020,-944,-824,-616,-323,-24,190,290,305,282,252,235,236,250,266,264,216,111,-21,-115,-123,-53,49,131,167,146,61,-83,-258,-411,-495,-495,-437,-357,-274,-186,-101,-48,-56,-122,-214,-292,-330,-328,-298,-250,-190,-121,-51,5,35,47,57,68,55,-8,-106,-183,-193,-144,-83,-39,-7,8,-16,-93,-199,-285,-323,-313,-266,-195,-114,-42,11,41,36,-11,-84,-152,-197,-223,-236,-224,-178,-113,-52,-9,9,-6,-61,-141,-217,-266,-276,-246,-183,-106,-37,12,38,38,10,-43,-107,-167,-208,-219,-198,-151,-90,-31,12,28,19,2,-10,-17,-26,-37,-38,-25,-8,3,4,-8,-33,-66,-94,-107,-107,-95,-68,-30}
        },
        {    // H60e120a.wav
            {-3,-5,2,10,6,-3,1,11,5,-11,-9,11,11,-16,-22,11,27,-6,-23,27,55,-19,-40,278,974,1764,2407,2844,2751,1307,-1952,-5914,-8110,-6676,-2130,3028,6408,7290,6411,4869,3450,2582,2345,2468,2591,2635,2745,2856,2558,1549,86,-1198,-1889,-2057,-2001,-1932,-1952,-2133,-2441,-2672,-2602,-2252,-1871,-1652,-1549,-1403,-1148,-804,-381,93,484,629,543,452,573,893,1216,1367,1315,1136,929,740,533,248,-68,-233,-115,161,291,109,-255,-563,-732,-835,-908,-892,-760,-600,-513,-498,-489,-457,-431,-435,-454,-463,-447,-389,-277,-130,-1,68,83,77,76,90,135,221,317,350,269,102,-55,-127,-129,-143,-233,-386,-527,-582,-522,-384,-248,-190,-224,-289,-308,-251,-151,-63,-24,-44,-112,-199,-273,-336,-422,-554,-701,-794,-783,-678,-530,-391,-297,-266,-288,-327,-340,-310,-251,-188,-129,-73,-16,39,90,130,145,127,80,24,-26,-66,-101,-137,-180,-230,-275,-300,-295,-270,-243,-230,-236,-249,-261,-264,-252,-225,-188,-148,-110,-75,-49,-38,-44,-65,-92,-112,-114,-98,-72,-45,-23,-15,-27,-54,-80,-94,-97,-95,-91,-87,-84,-81,-69,-46,-19,0,9,11,5,-14,-43,-70,-87,-94,-91,-80,-67,-63,-71,-83,-94,-103,-109,-109,-104,-101,-100,-94,-83,-80,-91,-106,-113,-114,-115,-113,-105,-97,-100,-104,-85,-42},
            {-54,114,82,-166,37,1429,3893,6470,8098,7802,4401,-2654,-11254,-16358,-13527,-3446,7874,14142,13837,10105,6616,4609,3570,3115,3303,3866,4240,4227,3867,2678,-89,-4096,-7491,-8469,-7080,-5041,-3950,-4108,-4904,-5636,-5769,-4992,-3545,-2236,-1712,-1762,-1637,-951,53,1024,1857,2456,2575,2183,1711,1644,1972,2282,2296,2057,1671,1172,678,413,448,598,668,656,603,399,-107,-885,-1745,-2512,-3038,-3133,-2692,-1928,-1292,-1066,-1118,-1110,-861,-446,-47,209,289,247,188,201,290,398,482,547,613,669,685,639,537,392,190,-107,-484,-795,-845,-577,-161,130,139,-93,-415,-680,-792,-732,-575,-441,-402,-450,-553,-701,-872,-1011,-1062,-1025,-934,-797,-592,-331,-78,104,205,253,269,261,240,225,230,245,240,189,90,-24,-102,-108,-48,43,129,179,166,73,-89,-270,-411,-474,-465,-411,-339,-260,-183,-120,-93,-115,-181,-262,-323,-345,-334,-304,-263,-210,-140,-56,22,69,80,69,51,18,-45,-124,-177,-169,-112,-50,-13,-3,-17,-64,-150,-251,-324,-344,-315,-249,-165,-82,-16,23,33,11,-40,-104,-160,-195,-212,-215,-197,-151,-87,-32,-6,-15,-50,-104,-167,-225,-259,-258,-222,-162,-96,-39,-2,13,6,-21,-64,-115,-166,-206,-220,-200,-149,-82,-22,15,25,16,2,-8,-17,-25,-33,-39,-37,-27,-15,-14,-28,-51,-73,-93,-108,-109,-84,-39}
        },
        {    // H60e130a.wav
            {-6,2,10,5,-3,2,9,0,-14,-6,14,7,-20,-16,19,20,-22,-25,38,52,-36,-15,398,1185,2045,2751,3154,2741,674,-3138,-7058,-8464,-5948,-700,4455,7321,7579,6251,4520,3141,2432,2328,2481,2589,2667,2845,2935,2459,1206,-404,-1660,-2196,-2182,-1996,-1898,-2005,-2339,-2758,-2965,-2763,-2302,-1936,-1828,-1805,-1616,-1205,-686,-163,302,623,730,694,705,878,1136,1319,1359,1298,1190,1032,781,416,12,-242,-174,161,447,383,-18,-469,-739,-849,-925,-989,-969,-847,-701,-607,-568,-557,-556,-547,-514,-462,-412,-353,-241,-70,91,162,135,71,28,33,96,223,367,434,359,171,-28,-150,-186,-195,-238,-327,-415,-448,-414,-356,-330,-351,-384,-379,-328,-268,-236,-223,-193,-129,-60,-38,-91,-212,-375,-546,-678,-726,-674,-556,-427,-330,-282,-289,-340,-398,-417,-379,-304,-225,-158,-102,-55,-14,27,74,118,138,121,73,9,-57,-118,-171,-215,-248,-269,-271,-254,-227,-208,-210,-231,-257,-275,-277,-262,-234,-202,-173,-145,-112,-78,-56,-55,-73,-98,-116,-119,-105,-83,-62,-45,-33,-29,-38,-60,-88,-110,-118,-118,-117,-114,-106,-93,-76,-55,-33,-16,-7,-6,-13,-28,-50,-69,-75,-64,-44,-25,-19,-33,-63,-96,-116,-122,-120,-114,-105,-95,-90,-92,-100,-112,-127,-140,-140,-125,-107,-97,-94,-93,-95,-101,-100,-77,-36},
            {-58,-31,82,59,-134,36,1268,3574,6103,7731,7410,4092,-2575,-10614,-15464,-13018,-3683,7182,13616,13770,10237,6526,4192,3064,2788,3232,3990,4455,4408,3911,2623,-46,-3788,-6963,-7914,-6621,-4660,-3597,-3789,-4635,-5394,-5548,-4850,-3523,-2285,-1757,-1815,-1776,-1195,-220,800,1688,2303,2417,2024,1565,1530,1896,2199,2135,1819,1472,1136,793,548,508,614,723,767,711,441,-155,-1001,-1845,-2442,-2666,-2504,-2070,-1607,-1346,-1304,-1297,-1152,-856,-500,-167,83,201,195,133,78,48,59,155,341,545,692,781,827,784,577,212,-206,-552,-727,-666,-384,-29,182,125,-142,-460,-685,-753,-666,-496,-356,-321,-383,-496,-636,-799,-955,-1049,-1050,-969,-826,-639,-433,-238,-74,60,164,225,243,237,232,234,234,225,197,136,43,-49,-94,-65,26,138,221,226,128,-53,-251,-396,-455,-443,-395,-337,-277,-224,-181,-156,-161,-201,-267,-331,-367,-365,-334,-287,-228,-153,-60,36,106,123,89,32,-22,-73,-127,-163,-150,-90,-25,4,-10,-47,-98,-168,-248,-311,-331,-303,-240,-158,-78,-18,15,22,4,-39,-95,-145,-177,-192,-196,-184,-147,-94,-48,-25,-29,-57,-103,-157,-204,-234,-242,-222,-173,-106,-45,-10,-4,-16,-40,-72,-111,-151,-183,-197,-182,-139,-83,-32,3,18,17,5,-9,-19,-27,-40,-52,-51,-36,-21,-20,-31,-45,-63,-86,-99,-83,-40}
        },
        {    // H60e140a.wav
            {6,7,-1,-2,7,7,-8,-14,3,13,-8,-25,1,30,4,-35,-4,54,15,-62,122,766,1713,2648,3338,3404,2059,-1264,-5687,-8721,-8006,-3460,2487,6871,8305,7358,5442,3699,2660,2342,2425,2551,2635,2814,3029,2834,1814,153,-1421,-2288,-2414,-2194,-2010,-2035,-2303,-2729,-3064,-3037,-2640,-2176,-1943,-1926,-1872,-1603,-1137,-568,27,538,819,844,796,899,1186,1480,1599,1507,1296,1073,868,620,267,-109,-269,-62,335,530,312,-156,-577,-844,-1029,-1152,-1127,-942,-748,-689,-741,-779,-743,-671,-601,-531,-456,-381,-280,-111,107,280,326,254,150,94,123,232,377,477,449,274,27,-174,-260,-263,-271,-336,-419,-444,-385,-302,-275,-327,-412,-464,-449,-383,-304,-240,-202,-180,-162,-151,-165,-224,-333,-474,-603,-661,-613,-478,-319,-205,-170,-208,-286,-361,-396,-377,-320,-252,-188,-133,-93,-67,-39,8,70,113,111,69,11,-52,-126,-210,-280,-310,-294,-246,-190,-149,-140,-168,-218,-265,-287,-279,-251,-220,-198,-185,-170,-145,-114,-87,-72,-73,-88,-111,-127,-124,-103,-77,-61,-55,-55,-59,-68,-81,-94,-104,-113,-121,-122,-114,-100,-85,-73,-65,-59,-53,-46,-43,-50,-63,-73,-69,-50,-23,0,8,-5,-33,-66,-94,-115,-128,-132,-123,-105,-86,-77,-87,-114,-144,-161,-162,-151,-133,-113,-99,-91,-83,-72,-66,-71,-76,-64,-32},
            {44,-59,-78,54,106,-74,-81,808,2803,5242,7063,7235,4734,-1001,-8631,-14243,-13561,-5831,4775,12341,13918,11015,7038,4176,2771,2482,2999,3849,4427,4479,4086,3032,750,-2694,-5947,-7326,-6462,-4626,-3403,-3376,-4119,-4943,-5311,-4884,-3725,-2453,-1791,-1825,-1941,-1558,-677,363,1319,2037,2278,1959,1465,1356,1722,2090,2047,1690,1353,1136,924,698,586,628,713,739,680,459,-62,-873,-1691,-2169,-2187,-1917,-1628,-1475,-1445,-1441,-1378,-1224,-976,-638,-261,38,156,108,-10,-124,-208,-207,-55,218,473,632,764,930,1010,813,330,-217,-578,-656,-490,-182,109,207,52,-239,-488,-611,-622,-553,-438,-338,-315,-367,-439,-512,-625,-795,-967,-1059,-1035,-919,-756,-585,-426,-275,-124,16,122,185,222,247,255,244,230,224,202,133,32,-45,-50,21,134,236,265,181,5,-191,-338,-416,-440,-426,-382,-321,-266,-228,-203,-193,-209,-256,-317,-361,-370,-346,-301,-244,-177,-92,11,107,156,132,55,-30,-93,-134,-157,-152,-111,-50,-4,5,-23,-77,-146,-216,-273,-303,-296,-248,-171,-91,-33,-3,9,7,-17,-64,-116,-154,-177,-188,-182,-151,-104,-59,-32,-26,-45,-86,-137,-181,-209,-221,-210,-172,-116,-65,-36,-32,-42,-56,-71,-87,-109,-136,-157,-155,-126,-83,-43,-14,5,10,1,-12,-21,-31,-47,-63,-63,-47,-28,-18,-17,-27,-49,-68,-62,-31}
        },
        {    // H60e150a.wav
            {4,-2,3,7,-5,-17,-4,14,2,-24,-12,25,17,-32,-28,41,45,-51,5,521,1490,2600,3523,3864,2879,-164,-4789,-8708,-9138,-5197,1118,6497,8822,8220,6176,4135,2839,2379,2441,2611,2715,2873,3114,3041,2125,380,-1462,-2574,-2752,-2424,-2117,-2082,-2342,-2810,-3249,-3327,-2918,-2306,-1925,-1901,-1966,-1804,-1354,-750,-125,412,737,809,783,898,1214,1553,1713,1656,1483,1288,1089,831,448,-24,-363,-311,122,556,575,128,-469,-904,-1111,-1165,-1109,-970,-842,-822,-885,-911,-839,-729,-664,-644,-613,-529,-384,-182,55,270,393,399,332,271,276,355,465,541,522,386,161,-83,-273,-381,-429,-445,-427,-365,-293,-271,-324,-407,-460,-464,-438,-407,-374,-338,-297,-247,-191,-157,-189,-305,-472,-624,-699,-660,-512,-311,-145,-73,-90,-147,-202,-241,-263,-263,-239,-202,-168,-144,-125,-101,-69,-27,19,56,66,37,-28,-118,-215,-294,-326,-303,-247,-193,-161,-155,-165,-180,-193,-202,-207,-214,-226,-237,-235,-217,-187,-152,-115,-82,-63,-66,-84,-104,-115,-116,-112,-107,-100,-89,-75,-65,-65,-76,-93,-109,-118,-114,-99,-84,-81,-88,-93,-88,-77,-67,-62,-64,-75,-91,-97,-82,-52,-23,-4,3,-2,-20,-46,-70,-90,-109,-122,-119,-101,-82,-78,-91,-111,-129,-138,-137,-134,-135,-137,-128,-106,-81,-61,-44,-26,-20,-37,-61,-62,-34},
            {6,51,0,-72,-13,94,13,-134,272,1720,3926,5994,6934,5752,1569,-5267,-11940,-14090,-9255,408,9446,13479,12199,8391,4893,2874,2261,2634,3459,4139,4373,4233,3625,1996,-941,-4311,-6447,-6419,-4917,-3462,-3006,-3472,-4293,-4922,-4921,-4107,-2856,-1938,-1775,-1994,-1911,-1267,-291,729,1607,2087,1963,1467,1198,1457,1887,1967,1664,1343,1191,1065,852,676,655,700,674,574,405,42,-593,-1287,-1683,-1674,-1502,-1442,-1508,-1538,-1456,-1339,-1249,-1112,-821,-411,-61,78,16,-133,-280,-384,-386,-226,55,325,518,708,947,1108,983,542,-7,-410,-541,-413,-121,161,240,56,-252,-483,-560,-533,-465,-385,-329,-339,-397,-438,-444,-474,-585,-757,-919,-1021,-1042,-968,-809,-612,-433,-288,-160,-41,62,147,219,269,282,264,241,224,197,143,75,30,34,88,166,220,201,92,-77,-249,-380,-456,-476,-450,-395,-332,-277,-234,-206,-199,-218,-260,-310,-351,-364,-337,-275,-198,-124,-49,36,116,150,114,24,-75,-147,-182,-178,-145,-92,-37,3,11,-20,-84,-162,-230,-273,-283,-258,-200,-127,-65,-29,-14,-9,-16,-43,-81,-117,-147,-168,-173,-155,-121,-84,-54,-34,-30,-51,-96,-149,-191,-209,-203,-178,-141,-104,-77,-61,-53,-51,-55,-68,-88,-110,-125,-125,-107,-78,-49,-25,-9,-3,-5,-13,-24,-38,-56,-71,-73,-61,-40,-21,-12,-16,-26,-27,-15}
        },
        {    // H60e160a.wav
            {-1,8,-2,-20,-12,14,9,-24,-24,18,26,-27,-46,21,57,-32,-48,378,1359,2625,3768,4318,3506,523,-4340,-8869,-10007,-6368,311,6454,9404,8970,6734,4419,2937,2398,2462,2684,2839,3009,3251,3206,2300,438,-1658,-3005,-3225,-2750,-2270,-2166,-2447,-2957,-3436,-3555,-3157,-2489,-2013,-1927,-1989,-1849,-1408,-793,-142,439,802,857,750,781,1086,1494,1742,1735,1561,1346,1163,1010,787,380,-139,-456,-301,196,561,423,-157,-819,-1256,-1378,-1247,-1000,-807,-787,-908,-1014,-980,-826,-672,-604,-618,-645,-607,-453,-184,136,398,516,489,405,374,440,555,635,627,519,321,68,-186,-388,-510,-545,-494,-379,-271,-246,-316,-415,-477,-500,-511,-505,-457,-375,-299,-256,-243,-261,-334,-470,-631,-747,-763,-669,-495,-296,-130,-30,6,-3,-40,-91,-137,-155,-138,-102,-73,-65,-80,-105,-118,-95,-37,24,42,-9,-116,-241,-340,-379,-354,-291,-230,-195,-184,-184,-184,-180,-175,-178,-193,-215,-229,-232,-231,-230,-217,-181,-125,-71,-40,-39,-63,-100,-133,-148,-145,-135,-126,-116,-99,-79,-70,-81,-104,-124,-132,-129,-119,-109,-100,-92,-86,-83,-81,-80,-82,-89,-99,-105,-105,-99,-88,-72,-54,-39,-32,-35,-50,-76,-105,-127,-133,-123,-105,-89,-87,-100,-118,-128,-127,-127,-132,-137,-134,-127,-120,-104,-74,-44,-32,-33,-32,-35,-58,-91,-94,-52},
            {-31,-16,38,34,-45,-62,42,81,-68,-64,689,2361,4428,6036,6272,4120,-1000,-7850,-12861,-12231,-5333,4176,11127,12824,10350,6593,3716,2363,2275,2900,3622,4037,4145,3997,3189,1134,-1973,-4818,-5992,-5303,-3855,-2894,-2864,-3483,-4261,-4717,-4458,-3485,-2373,-1812,-1896,-2075,-1810,-1052,-57,932,1671,1883,1557,1150,1156,1532,1799,1695,1439,1302,1223,1033,799,700,716,664,491,289,61,-296,-743,-1057,-1143,-1188,-1380,-1609,-1619,-1393,-1184,-1163,-1196,-1039,-660,-261,-45,-47,-179,-350,-498,-548,-429,-159,161,440,672,880,1010,960,705,345,16,-203,-274,-182,9,137,70,-155,-373,-469,-464,-428,-392,-366,-376,-426,-468,-460,-428,-438,-518,-651,-816,-985,-1090,-1054,-871,-629,-424,-282,-173,-73,19,106,192,264,299,295,270,240,202,153,107,86,95,117,136,134,92,-7,-152,-302,-414,-474,-489,-469,-416,-337,-256,-202,-183,-186,-200,-227,-271,-319,-344,-326,-268,-196,-126,-58,15,84,122,106,32,-73,-168,-217,-207,-154,-88,-32,4,13,-16,-82,-162,-225,-255,-253,-223,-171,-112,-65,-41,-33,-33,-40,-53,-72,-96,-122,-146,-155,-140,-109,-76,-50,-34,-35,-59,-104,-153,-190,-205,-194,-162,-123,-95,-81,-72,-62,-57,-65,-82,-98,-106,-104,-92,-70,-46,-26,-13,-7,-9,-18,-30,-43,-60,-79,-90,-83,-61,-38,-23,-15,-10,-5}
        },
        {    // H60e170a.wav
            {5,-18,-17,11,15,-18,-28,15,37,-14,-52,8,68,-11,-77,278,1279,2698,4060,4803,4115,1118,-4029,-9141,-10890,-7443,-329,6594,10136,9805,7298,4647,2963,2379,2502,2826,3057,3237,3444,3367,2408,391,-1964,-3537,-3790,-3153,-2467,-2258,-2558,-3147,-3702,-3850,-3396,-2595,-1996,-1899,-2054,-1987,-1495,-739,31,643,978,994,844,811,1041,1399,1655,1711,1599,1387,1159,1007,912,705,275,-201,-378,-136,247,358,19,-613,-1221,-1532,-1457,-1138,-857,-807,-936,-1040,-980,-789,-596,-502,-531,-628,-693,-635,-436,-143,173,442,602,632,587,558,582,622,627,576,456,248,-34,-307,-471,-493,-423,-338,-295,-313,-370,-421,-444,-461,-499,-537,-526,-450,-345,-264,-244,-306,-456,-656,-827,-892,-828,-665,-457,-259,-111,-26,18,52,79,82,61,38,31,37,37,20,-15,-54,-72,-51,-3,25,-11,-112,-237,-334,-376,-366,-326,-284,-259,-249,-237,-207,-164,-130,-124,-150,-192,-230,-251,-254,-247,-231,-198,-140,-67,-7,17,2,-37,-84,-126,-156,-167,-160,-138,-104,-68,-45,-49,-75,-103,-121,-131,-138,-139,-131,-116,-96,-74,-54,-44,-48,-59,-71,-84,-99,-106,-99,-84,-72,-64,-55,-47,-50,-65,-84,-100,-114,-125,-124,-110,-95,-87,-85,-84,-88,-97,-104,-103,-101,-102,-100,-88,-70,-51,-32,-13,-6,-18,-37,-48,-59,-85,-112,-104,-54},
            {18,-13,-38,-1,48,15,-59,-35,68,48,-99,54,979,2642,4478,5734,5527,2851,-2568,-8940,-12551,-10349,-2849,5852,11273,11797,9011,5572,3196,2264,2401,2995,3516,3786,3915,3794,2845,629,-2324,-4635,-5260,-4410,-3202,-2578,-2740,-3395,-4119,-4455,-4071,-3099,-2163,-1810,-1965,-2072,-1719,-925,65,983,1545,1562,1209,967,1130,1490,1661,1576,1445,1361,1213,975,805,772,716,490,185,-32,-157,-287,-438,-597,-851,-1260,-1640,-1692,-1388,-1060,-1005,-1139,-1154,-907,-535,-251,-152,-221,-395,-578,-659,-572,-334,-8,333,622,802,857,817,727,609,452,255,52,-95,-144,-120,-98,-132,-212,-296,-365,-418,-448,-449,-441,-456,-487,-491,-448,-393,-377,-427,-550,-736,-936,-1060,-1038,-880,-662,-454,-284,-157,-72,-8,71,171,256,287,270,243,223,199,162,123,93,71,54,46,38,4,-80,-202,-326,-419,-469,-477,-448,-393,-325,-253,-185,-133,-116,-140,-194,-258,-315,-347,-339,-286,-206,-126,-58,2,55,85,74,19,-66,-155,-215,-219,-167,-90,-28,-4,-16,-54,-103,-149,-183,-202,-201,-182,-151,-119,-94,-72,-52,-41,-46,-58,-65,-70,-86,-115,-136,-133,-109,-82,-59,-43,-40,-60,-100,-144,-178,-193,-184,-153,-115,-86,-74,-74,-77,-80,-83,-87,-90,-92,-88,-75,-56,-36,-19,-5,0,-8,-27,-48,-67,-85,-98,-97,-82,-64,-50,-35,-16}
        },
        {    // H60e180a.wav
            {-22,10,22,-14,-37,3,41,-3,-59,-12,71,13,-98,173,1164,2719,4309,5281,4780,1855,-3509,-9233,-11752,-8707,-1279,6473,10781,10720,8009,4985,3016,2321,2486,2941,3293,3507,3681,3571,2569,401,-2250,-4122,-4476,-3693,-2760,-2379,-2643,-3290,-3942,-4174,-3724,-2809,-2037,-1834,-2019,-2058,-1627,-814,104,866,1260,1224,976,882,1092,1411,1587,1593,1527,1403,1189,971,866,802,582,182,-164,-238,-86,50,-42,-429,-1015,-1537,-1697,-1433,-1033,-856,-964,-1110,-1056,-807,-526,-352,-331,-445,-612,-710,-648,-426,-106,238,528,694,731,704,684,672,623,520,378,206,7,-181,-298,-323,-292,-265,-279,-337,-415,-471,-483,-472,-477,-502,-507,-460,-379,-322,-337,-443,-622,-812,-937,-952,-867,-711,-507,-292,-118,-17,35,81,127,151,156,174,209,221,176,94,19,-23,-29,-2,41,54,-7,-137,-278,-377,-423,-429,-406,-362,-314,-273,-231,-178,-128,-113,-147,-206,-254,-276,-278,-271,-256,-225,-175,-108,-35,22,48,41,3,-58,-128,-184,-203,-179,-128,-76,-45,-44,-64,-91,-113,-129,-144,-159,-168,-163,-142,-111,-77,-49,-35,-37,-48,-60,-74,-92,-112,-123,-117,-97,-72,-50,-41,-50,-75,-107,-136,-154,-159,-148,-126,-100,-83,-81,-87,-91,-91,-90,-89,-89,-89,-87,-77,-57,-34,-17,-10,-10,-16,-31,-53,-72,-84,-94,-105,-106,-82,-38},
            {-22,10,22,-14,-37,3,41,-3,-59,-12,71,13,-98,173,1164,2719,4309,5281,4780,1855,-3509,-9233,-11752,-8707,-1279,6473,10781,10720,8009,4985,3016,2321,2486,2941,3293,3507,3681,3571,2569,401,-2250,-4122,-4476,-3693,-2760,-2379,-2643,-3290,-3942,-4174,-3724,-2809,-2037,-1834,-2019,-2058,-1627,-814,104,866,1260,1224,976,882,1092,1411,1587,1593,1527,1403,1189,971,866,802,582,182,-164,-238,-86,50,-42,-429,-1015,-1537,-1697,-1433,-1033,-856,-964,-1110,-1056,-807,-526,-352,-331,-445,-612,-710,-648,-426,-106,238,528,694,731,704,684,672,623,520,378,206,7,-181,-298,-323,-292,-265,-279,-337,-415,-471,-483,-472,-477,-502,-507,-460,-379,-322,-337,-443,-622,-812,-937,-952,-867,-711,-507,-292,-118,-17,35,81,127,151,156,174,209,221,176,94,19,-23,-29,-2,41,54,-7,-137,-278,-377,-423,-429,-406,-362,-314,-273,-231,-178,-128,-113,-147,-206,-254,-276,-278,-271,-256,-225,-175,-108,-35,22,48,41,3,-58,-128,-184,-203,-179,-128,-76,-45,-44,-64,-91,-113,-129,-144,-159,-168,-163,-142,-111,-77,-49,-35,-37,-48,-60,-74,-92,-112,-123,-117,-97,-72,-50,-41,-50,-75,-107,-136,-154,-159,-148,-126,-100,-83,-81,-87,-91,-91,-90,-89,-89,-89,-87,-77,-57,-34,-17,-10,-10,-16,-31,-53,-72,-84,-94,-105,-106,-82,-38}
        }
    },
    {    // elev70
        {    // H70e000a.wav
            {-1,-12,-8,1,-3,-3,15,21,-2,-16,11,27,-15,-45,7,56,-3,-77,-12,99,31,-127,-64,149,86,-160,250,1699,3273,3970,4217,4804,4436,376,-7303,-13568,-12649,-4327,5566,11130,11435,9309,7076,5107,3478,2832,3235,3660,3329,2643,2141,1289,-759,-3615,-5823,-6557,-6336,-5930,-5337,-4287,-3177,-2758,-3050,-3195,-2538,-1402,-542,-177,62,443,839,1144,1526,2061,2417,2239,1689,1278,1225,1292,1255,1183,1123,853,230,-446,-713,-519,-228,-111,-107,-113,-217,-509,-891,-1230,-1538,-1857,-2063,-1988,-1664,-1295,-992,-702,-363,-15,289,559,796,935,920,794,666,630,704,825,876,769,527,257,28,-168,-354,-506,-596,-636,-642,-602,-531,-508,-582,-687,-694,-571,-409,-294,-213,-118,-23,10,-42,-135,-211,-256,-292,-351,-460,-626,-825,-999,-1079,-1017,-817,-529,-230,5,125,125,46,-51,-110,-102,-38,47,109,113,55,-31,-100,-121,-101,-73,-76,-129,-217,-304,-358,-370,-342,-283,-206,-129,-64,-17,1,-26,-101,-197,-276,-320,-330,-313,-275,-226,-178,-128,-71,-25,-22,-73,-150,-216,-248,-237,-178,-85,6,68,91,78,31,-41,-107,-139,-133,-111,-85,-49,0,50,81,83,53,-4,-72,-134,-181,-215,-232,-225,-193,-149,-106,-77,-74,-105,-154,-198,-222,-231,-227,-197,-134,-57,3,33,36,16,-17,-41,-40,-29,-31,-46,-48,-26},
            {-1,-12,-8,1,-3,-3,15,21,-2,-16,11,27,-15,-45,7,56,-3,-77,-12,99,31,-127,-64,149,86,-160,250,1699,3273,3970,4217,4804,4436,376,-7303,-13568,-12649,-4327,5566,11130,11435,9309,7076,5107,3478,2832,3235,3660,3329,2643,2141,1289,-759,-3615,-5823,-6557,-6336,-5930,-5337,-4287,-3177,-2758,-3050,-3195,-2538,-1402,-542,-177,62,443,839,1144,1526,2061,2417,2239,1689,1278,1225,1292,1255,1183,1123,853,230,-446,-713,-519,-228,-111,-107,-113,-217,-509,-891,-1230,-1538,-1857,-2063,-1988,-1664,-1295,-992,-702,-363,-15,289,559,796,935,920,794,666,630,704,825,876,769,527,257,28,-168,-354,-506,-596,-636,-642,-602,-531,-508,-582,-687,-694,-571,-409,-294,-213,-118,-23,10,-42,-135,-211,-256,-292,-351,-460,-626,-825,-999,-1079,-1017,-817,-529,-230,5,125,125,46,-51,-110,-102,-38,47,109,113,55,-31,-100,-121,-101,-73,-76,-129,-217,-304,-358,-370,-342,-283,-206,-129,-64,-17,1,-26,-101,-197,-276,-320,-330,-313,-275,-226,-178,-128,-71,-25,-22,-73,-150,-216,-248,-237,-178,-85,6,68,91,78,31,-41,-107,-139,-133,-111,-85,-49,0,50,81,83,53,-4,-72,-134,-181,-215,-232,-225,-193,-149,-106,-77,-74,-105,-154,-198,-222,-231,-227,-197,-134,-57,3,33,36,16,-17,-41,-40,-29,-31,-46,-48,-26}
        },
        {    // H70e015a.wav
            {-1,3,-3,-9,-5,0,-4,-4,11,16,-2,-8,14,19,-18,-35,10,43,-11,-64,-1,80,13,-104,-36,124,48,-118,318,1584,2880,3453,3705,4163,3590,-206,-6861,-12010,-10989,-3823,4656,9695,10477,9055,7129,5096,3312,2521,2802,3233,3083,2599,2178,1413,-332,-2744,-4690,-5493,-5482,-5206,-4692,-3808,-2901,-2546,-2756,-2894,-2457,-1641,-966,-611,-350,1,383,752,1210,1746,2075,1966,1600,1374,1406,1464,1382,1259,1166,928,396,-219,-537,-470,-268,-151,-108,-99,-205,-487,-849,-1162,-1422,-1665,-1817,-1763,-1523,-1237,-980,-708,-392,-87,156,354,541,688,735,678,586,551,617,739,807,737,550,333,136,-59,-266,-446,-564,-635,-669,-632,-510,-387,-387,-523,-667,-677,-540,-353,-208,-130,-104,-110,-133,-159,-175,-186,-212,-275,-384,-526,-673,-791,-843,-807,-680,-486,-269,-80,36,52,-19,-127,-211,-241,-223,-178,-123,-76,-58,-74,-102,-111,-96,-83,-98,-141,-195,-246,-286,-299,-271,-210,-151,-124,-119,-107,-79,-63,-84,-137,-193,-235,-264,-282,-281,-251,-197,-133,-73,-33,-27,-63,-129,-198,-241,-241,-196,-122,-42,25,64,64,21,-45,-101,-123,-113,-87,-55,-17,26,64,88,95,80,37,-30,-101,-156,-191,-209,-212,-196,-164,-131,-115,-123,-148,-175,-197,-214,-224,-218,-190,-140,-79,-20,25,45,41,18,-15,-47,-63,-54,-27},
            {-8,2,-3,-8,12,28,3,-20,11,41,-4,-58,-11,67,18,-90,-40,113,78,-128,-115,152,156,-182,66,1593,3532,4526,4800,5477,5547,1726,-6803,-14850,-15156,-6262,5474,12440,12746,9819,7061,5148,3780,3325,3849,4242,3591,2507,1949,1383,-581,-3921,-6815,-7789,-7264,-6497,-5843,-4876,-3716,-3163,-3428,-3597,-2784,-1298,-167,215,380,819,1362,1687,1919,2318,2684,2563,1947,1340,1090,1062,1040,1051,1074,804,70,-720,-969,-625,-192,-37,-46,-31,-99,-415,-884,-1301,-1655,-2029,-2308,-2262,-1890,-1442,-1090,-755,-330,116,448,658,846,1030,1112,1014,808,677,747,955,1085,966,624,228,-94,-323,-476,-548,-561,-584,-649,-711,-719,-698,-696,-695,-648,-558,-463,-354,-193,-5,106,77,-35,-127,-165,-187,-237,-335,-501,-748,-1035,-1262,-1326,-1186,-872,-475,-119,84,100,4,-70,-36,83,208,284,309,291,223,110,-10,-87,-100,-71,-43,-56,-132,-257,-388,-476,-497,-449,-342,-201,-67,19,42,19,-31,-99,-179,-257,-314,-339,-334,-301,-244,-168,-80,1,40,10,-81,-187,-260,-278,-245,-170,-74,17,83,113,100,40,-53,-139,-179,-172,-141,-103,-52,14,75,110,107,64,-11,-98,-177,-232,-262,-268,-246,-197,-134,-76,-36,-29,-62,-124,-186,-223,-235,-227,-195,-134,-59,1,30,36,35,33,21,-2,-29,-52,-69,-75,-66,-45,-19}
        },
        {    // H70e030a.wav
            {1,-3,0,4,-1,-7,-4,-1,-4,-1,12,15,0,-5,11,14,-14,-26,10,34,-10,-49,3,64,8,-83,-25,100,38,-81,302,1363,2460,2990,3252,3619,3044,-270,-6013,-10567,-9963,-4003,3464,8371,9676,8774,7052,5048,3270,2427,2575,2916,2815,2470,2209,1669,252,-1845,-3669,-4562,-4703,-4535,-4135,-3427,-2687,-2375,-2529,-2668,-2388,-1807,-1288,-945,-621,-232,131,451,867,1400,1792,1799,1544,1374,1417,1490,1432,1310,1198,971,508,-34,-352,-361,-247,-180,-150,-137,-232,-497,-833,-1098,-1286,-1465,-1608,-1604,-1430,-1190,-964,-727,-445,-175,4,109,238,445,669,791,756,636,554,573,641,664,597,451,241,-26,-299,-497,-584,-603,-603,-578,-512,-449,-461,-550,-627,-605,-484,-332,-220,-181,-203,-231,-208,-124,-32,-4,-67,-197,-350,-484,-570,-594,-572,-535,-503,-465,-399,-303,-199,-123,-100,-133,-195,-252,-283,-291,-289,-281,-262,-223,-164,-98,-48,-39,-80,-150,-215,-250,-257,-246,-221,-181,-135,-100,-80,-67,-57,-60,-84,-120,-149,-167,-183,-200,-212,-210,-191,-159,-120,-86,-75,-95,-138,-187,-224,-237,-218,-167,-100,-39,1,12,-5,-38,-68,-78,-66,-39,-7,26,56,80,93,91,70,31,-15,-63,-113,-165,-206,-220,-207,-180,-154,-138,-139,-160,-186,-202,-203,-198,-193,-178,-142,-89,-36,6,36,48,35,7,-12,-11},
            {1,-13,5,34,17,-23,-8,41,17,-57,-37,64,53,-81,-88,90,136,-87,-182,94,247,-111,-191,1113,3361,4906,5359,5997,6615,3869,-4555,-14594,-17777,-10027,3302,12809,14245,10709,7067,5064,4110,3932,4536,4958,4112,2526,1634,1381,24,-3282,-6949,-8777,-8434,-7249,-6185,-5154,-4140,-3740,-4117,-4298,-3281,-1431,-40,350,448,994,1778,2219,2351,2613,2962,2874,2210,1503,1201,1143,1017,884,875,706,39,-841,-1220,-867,-304,-55,-62,-33,2,-198,-643,-1142,-1627,-2147,-2559,-2578,-2164,-1627,-1231,-905,-459,87,532,779,916,1034,1101,1041,884,780,862,1090,1243,1125,756,331,-6,-265,-480,-603,-594,-551,-625,-815,-958,-934,-800,-703,-700,-713,-626,-396,-97,129,178,65,-94,-178,-158,-95,-85,-201,-457,-802,-1143,-1382,-1443,-1285,-939,-522,-186,-14,29,42,90,167,242,304,355,385,369,294,180,67,-13,-45,-37,-20,-45,-151,-324,-493,-585,-573,-477,-334,-182,-60,3,13,1,-21,-70,-151,-243,-312,-346,-344,-304,-223,-117,-17,51,70,27,-72,-187,-269,-286,-242,-165,-78,2,64,96,89,34,-58,-153,-214,-228,-201,-149,-81,-6,61,108,126,101,27,-80,-185,-261,-307,-323,-302,-239,-146,-54,5,17,-20,-90,-165,-219,-242,-241,-219,-175,-107,-23,58,113,123,89,32,-24,-67,-99,-121,-124,-102,-58,-13,13,13}
        },
        {    // H70e045a.wav
            {-3,1,0,-2,0,1,-3,-5,-2,-2,-6,-2,9,9,-3,-3,12,9,-16,-21,11,22,-18,-39,12,50,-10,-71,-1,89,10,-52,371,1328,2235,2679,2968,3247,2413,-951,-6156,-9830,-8759,-3171,3473,7807,9019,8214,6539,4611,3040,2389,2532,2739,2591,2341,2197,1736,452,-1417,-3035,-3869,-4055,-3918,-3536,-2942,-2422,-2287,-2446,-2491,-2197,-1740,-1367,-1076,-735,-350,-29,264,680,1198,1552,1559,1373,1287,1369,1451,1420,1325,1196,938,510,66,-202,-283,-296,-295,-252,-212,-297,-540,-820,-1029,-1192,-1363,-1486,-1459,-1284,-1074,-911,-777,-612,-386,-96,231,522,692,705,617,521,479,498,555,606,602,514,346,125,-112,-323,-476,-569,-627,-659,-638,-551,-444,-393,-428,-503,-545,-511,-413,-289,-185,-131,-123,-123,-96,-43,2,-3,-78,-212,-360,-465,-498,-479,-459,-472,-504,-511,-460,-357,-243,-169,-165,-224,-307,-366,-379,-360,-335,-315,-291,-243,-167,-83,-30,-40,-107,-188,-239,-245,-216,-172,-127,-92,-66,-43,-21,-10,-23,-62,-108,-140,-152,-151,-151,-161,-185,-214,-223,-199,-157,-126,-125,-151,-191,-227,-245,-235,-197,-142,-83,-35,-6,1,-5,-14,-17,-13,-2,14,35,58,76,83,73,46,9,-29,-65,-104,-148,-188,-210,-209,-192,-170,-155,-154,-168,-187,-199,-198,-185,-166,-140,-106,-66,-28,-1,8,3,-4,-4},
            {-11,22,36,-5,-29,18,47,-20,-73,8,91,0,-124,-25,158,65,-187,-106,234,157,-286,143,2137,4487,5698,6233,7150,6649,904,-9896,-18470,-16598,-4345,9282,15457,13393,8490,5248,4194,4263,4958,5654,5155,3286,1624,1327,1105,-1197,-5415,-8909,-9675,-8355,-6770,-5662,-4752,-4144,-4316,-4869,-4507,-2720,-636,376,397,574,1419,2331,2753,2935,3234,3355,2845,1944,1347,1272,1324,1213,1036,783,168,-787,-1461,-1325,-662,-183,-135,-186,-107,-92,-358,-825,-1336,-1893,-2463,-2781,-2613,-2080,-1517,-1068,-623,-107,378,718,928,1065,1114,1031,869,774,860,1099,1317,1315,1036,602,182,-148,-385,-519,-544,-550,-665,-884,-1036,-991,-837,-772,-859,-954,-877,-594,-224,75,203,153,4,-128,-163,-111,-62,-122,-341,-681,-1033,-1281,-1342,-1209,-958,-699,-499,-330,-124,132,358,463,439,360,299,279,273,254,210,146,76,26,11,11,-25,-140,-326,-509,-610,-599,-500,-361,-222,-117,-60,-36,-14,2,-24,-113,-231,-318,-347,-328,-272,-183,-83,0,49,69,55,-7,-111,-216,-275,-272,-218,-134,-44,30,74,81,47,-32,-139,-232,-272,-256,-205,-136,-59,18,85,128,129,73,-37,-167,-271,-328,-341,-317,-258,-175,-87,-14,28,25,-28,-110,-186,-238,-271,-282,-245,-148,-20,87,142,148,116,53,-28,-101,-148,-167,-160,-124,-62,4,40,36,13,-2}
        },
        {    // H70e060a.wav
            {-8,-5,2,2,-3,-2,2,1,-4,-5,-2,-3,-4,3,10,4,-5,2,12,-1,-20,-8,19,8,-29,-19,33,30,-40,-47,45,66,-40,47,654,1563,2236,2579,2902,2861,1137,-2935,-7585,-9424,-6569,-570,5103,8105,8423,7208,5426,3716,2648,2429,2618,2626,2405,2267,2150,1520,112,-1605,-2905,-3508,-3595,-3366,-2900,-2394,-2165,-2288,-2443,-2288,-1862,-1466,-1237,-1036,-731,-381,-66,288,756,1192,1358,1243,1105,1157,1334,1446,1420,1297,1081,738,323,-27,-239,-353,-403,-356,-232,-173,-312,-609,-899,-1080,-1174,-1243,-1308,-1363,-1370,-1236,-883,-380,47,213,163,115,222,437,599,608,500,389,370,443,521,503,348,100,-160,-368,-495,-535,-503,-433,-373,-362,-414,-509,-597,-625,-568,-442,-294,-180,-137,-161,-204,-205,-134,-16,87,117,56,-71,-214,-325,-389,-418,-444,-493,-561,-617,-622,-552,-425,-300,-240,-262,-329,-381,-390,-366,-339,-327,-324,-304,-242,-139,-36,12,-17,-94,-165,-196,-186,-151,-106,-64,-37,-26,-17,-3,0,-27,-84,-144,-181,-187,-173,-161,-171,-206,-245,-259,-237,-194,-156,-141,-155,-191,-230,-246,-225,-174,-112,-57,-16,8,16,14,10,8,9,13,22,38,54,62,55,35,10,-15,-40,-70,-107,-146,-179,-198,-200,-188,-173,-165,-168,-175,-175,-165,-150,-138,-127,-111,-88,-62,-37,-17,-5,0},
            {22,30,-9,-24,25,44,-29,-72,17,90,-12,-124,-8,162,44,-195,-81,251,128,-308,217,2327,4780,6156,6895,7755,6655,17,-11225,-19275,-16251,-3112,10537,16028,13160,7795,4571,3919,4521,5537,6129,5226,3031,1377,1304,1205,-1250,-5789,-9524,-10266,-8636,-6614,-5243,-4495,-4389,-4965,-5428,-4584,-2442,-482,143,-9,362,1487,2492,2873,3073,3469,3633,3069,2122,1547,1506,1555,1432,1251,947,192,-927,-1687,-1545,-844,-333,-254,-283,-207,-206,-473,-943,-1493,-2100,-2657,-2876,-2597,-2015,-1451,-992,-510,39,533,859,1021,1062,1005,895,821,853,988,1168,1298,1266,1009,587,155,-165,-356,-473,-581,-711,-841,-898,-839,-751,-788,-987,-1183,-1158,-865,-458,-136,8,10,-42,-72,-53,-9,4,-62,-232,-496,-803,-1059,-1170,-1112,-943,-757,-609,-481,-319,-85,207,478,626,597,431,240,122,98,122,146,144,113,62,11,-29,-81,-188,-354,-516,-592,-560,-460,-342,-229,-130,-57,-15,-2,-17,-69,-154,-247,-315,-334,-295,-207,-98,-3,59,88,85,45,-30,-120,-199,-250,-262,-227,-148,-54,22,63,63,16,-79,-191,-271,-289,-257,-201,-132,-53,28,96,131,117,44,-76,-208,-308,-350,-335,-282,-209,-129,-50,18,52,31,-42,-142,-235,-294,-304,-258,-167,-57,42,109,135,121,71,-2,-82,-149,-183,-177,-147,-102,-38,34,69,28,-57,-103,-68}
        },
        {    // H70e075a.wav
            {-3,-7,-5,0,1,-2,-1,2,0,-5,-5,-2,-3,-4,2,8,4,-5,1,11,1,-19,-11,15,9,-25,-21,27,33,-27,-43,35,65,-30,10,510,1345,2042,2441,2770,2765,1276,-2412,-6883,-9042,-6849,-1354,4289,7580,8154,7026,5281,3667,2706,2514,2661,2634,2423,2339,2323,1837,563,-1104,-2450,-3141,-3308,-3139,-2717,-2232,-2018,-2190,-2435,-2347,-1897,-1410,-1127,-982,-808,-567,-281,104,618,1087,1246,1070,851,887,1166,1442,1515,1350,1008,583,200,-33,-127,-190,-278,-337,-316,-269,-294,-427,-649,-959,-1328,-1615,-1624,-1302,-825,-443,-265,-223,-195,-122,-10,114,235,339,401,405,365,329,340,381,374,250,22,-209,-337,-326,-225,-126,-106,-187,-331,-477,-570,-585,-535,-462,-412,-396,-381,-328,-242,-161,-115,-93,-64,-9,59,108,100,20,-107,-227,-304,-350,-408,-505,-623,-721,-760,-716,-593,-434,-313,-287,-339,-401,-415,-376,-319,-277,-254,-232,-185,-106,-15,44,38,-25,-100,-141,-136,-100,-58,-25,-14,-22,-36,-47,-60,-88,-132,-180,-212,-217,-199,-181,-187,-223,-267,-285,-258,-200,-143,-114,-121,-154,-194,-216,-205,-163,-105,-50,-11,8,11,7,7,11,16,18,20,25,31,33,30,21,5,-15,-37,-62,-93,-129,-161,-179,-182,-175,-161,-147,-138,-137,-140,-139,-135,-131,-125,-111,-86,-56,-31,-14,-4},
            {38,5,-30,2,45,0,-67,-19,80,36,-100,-66,118,110,-131,-162,150,230,-186,-147,1420,3981,5981,7044,7891,7502,2622,-7593,-17439,-18368,-7985,6502,15191,14718,9467,5176,3801,4258,5281,6037,5596,3749,1874,1422,1613,49,-4062,-8477,-10364,-9307,-7133,-5491,-4682,-4518,-4957,-5529,-5155,-3362,-1180,-52,-90,-115,665,1808,2588,3018,3437,3665,3266,2415,1837,1848,2025,1922,1592,1186,543,-427,-1281,-1459,-1030,-603,-522,-550,-402,-221,-340,-838,-1532,-2229,-2778,-2994,-2763,-2203,-1577,-1027,-520,-7,466,820,1010,1029,925,810,795,887,1017,1144,1253,1265,1060,645,197,-105,-258,-385,-564,-757,-869,-839,-697,-580,-655,-950,-1267,-1327,-1030,-549,-163,-28,-102,-227,-262,-165,-9,82,22,-189,-481,-763,-958,-1028,-980,-859,-708,-542,-360,-166,29,220,393,507,519,429,287,156,70,35,44,76,90,62,12,-28,-68,-158,-313,-472,-557,-546,-475,-381,-274,-163,-76,-26,-2,1,-33,-117,-226,-311,-335,-294,-207,-101,-4,66,107,120,92,18,-83,-181,-251,-278,-249,-170,-77,-8,27,32,2,-76,-186,-277,-309,-282,-222,-147,-65,12,72,104,99,45,-54,-171,-270,-328,-335,-293,-213,-119,-31,42,80,56,-38,-164,-266,-313,-305,-250,-157,-50,40,98,122,106,50,-27,-97,-147,-178,-187,-163,-111,-49,6,36,19,-51,-129,-143,-79}
        },
        {    // H70e090a.wav
            {1,-2,-4,-1,1,-1,-2,2,3,-2,-5,-2,-1,-4,-1,8,10,0,-3,9,11,-7,-15,6,18,-9,-30,2,40,10,-39,-2,68,23,-59,168,850,1659,2224,2604,2849,2216,-385,-4684,-8270,-8314,-4253,1604,6180,7988,7482,5860,4119,2924,2560,2741,2851,2632,2408,2442,2368,1564,-12,-1685,-2766,-3129,-3045,-2750,-2382,-2139,-2187,-2407,-2456,-2156,-1685,-1307,-1065,-843,-607,-409,-196,181,711,1133,1209,1008,823,847,1038,1251,1362,1271,923,422,16,-128,-95,-91,-182,-259,-240,-225,-387,-766,-1201,-1463,-1425,-1148,-819,-597,-499,-435,-341,-238,-159,-72,63,214,293,269,200,161,167,186,186,154,85,-7,-86,-116,-92,-50,-39,-88,-188,-293,-347,-331,-291,-302,-402,-554,-668,-666,-531,-319,-124,-16,0,-23,-26,13,67,96,75,7,-82,-159,-216,-275,-376,-536,-724,-874,-921,-839,-663,-472,-342,-303,-326,-361,-371,-351,-311,-260,-198,-116,-14,82,129,103,25,-52,-88,-82,-56,-30,-13,-15,-39,-77,-111,-135,-157,-184,-210,-224,-223,-216,-216,-228,-247,-262,-257,-226,-177,-129,-100,-97,-116,-144,-164,-164,-145,-112,-73,-33,-5,2,-7,-16,-13,-3,5,9,13,16,16,13,11,5,-12,-36,-59,-77,-95,-115,-132,-141,-140,-131,-117,-104,-101,-109,-121,-130,-131,-119,-94,-67,-51,-46,-38,-19},
            {35,-3,-26,14,41,-14,-62,1,74,6,-101,-29,127,67,-146,-105,179,150,-236,34,1782,4310,6272,7425,8032,6578,386,-9872,-17794,-16168,-4772,8492,15123,13521,8453,4827,3857,4373,5250,5725,5061,3355,1949,1771,1649,-505,-4804,-8768,-9978,-8521,-6337,-4934,-4520,-4792,-5426,-5732,-4852,-2841,-953,-278,-460,-303,629,1699,2353,2799,3309,3536,3059,2211,1764,1939,2242,2226,1911,1390,563,-482,-1221,-1221,-731,-383,-417,-533,-467,-373,-562,-1108,-1852,-2583,-3087,-3161,-2748,-2045,-1342,-775,-299,155,563,847,951,900,802,771,832,917,989,1090,1211,1204,926,449,21,-194,-266,-356,-523,-693,-769,-722,-613,-572,-706,-979,-1197,-1163,-862,-469,-197,-139,-235,-342,-337,-193,-11,63,-48,-302,-588,-805,-911,-916,-858,-758,-606,-389,-135,93,245,325,363,372,348,298,238,181,120,57,11,-6,-4,0,2,-7,-60,-184,-353,-494,-556,-541,-475,-372,-243,-117,-32,5,13,-2,-52,-140,-237,-304,-320,-280,-195,-87,11,81,124,134,100,22,-82,-182,-255,-278,-239,-152,-59,0,18,5,-42,-127,-227,-298,-314,-283,-220,-134,-41,34,76,88,71,15,-77,-181,-262,-302,-295,-247,-169,-80,7,75,95,41,-78,-207,-290,-310,-280,-217,-131,-37,45,99,114,83,14,-62,-120,-157,-179,-179,-146,-95,-51,-23,-9,-20,-71,-130,-137,-74}
        },
        {    // H70e105a.wav
            {0,-3,-3,1,2,0,0,3,2,-2,-3,-1,-2,-5,-1,9,9,-2,-3,10,9,-10,-14,10,18,-13,-30,8,39,1,-39,11,73,7,-61,222,953,1775,2356,2754,2888,1905,-1123,-5525,-8641,-7866,-3171,2764,6915,8113,7110,5258,3576,2630,2531,2858,3005,2799,2581,2556,2344,1416,-176,-1776,-2787,-3112,-2988,-2653,-2320,-2226,-2455,-2746,-2704,-2239,-1656,-1277,-1105,-941,-677,-353,15,454,891,1132,1089,919,863,982,1146,1218,1165,1008,769,498,265,83,-83,-213,-225,-134,-132,-405,-873,-1236,-1285,-1096,-894,-800,-771,-724,-639,-532,-399,-231,-48,104,195,225,214,177,120,44,-37,-93,-88,-9,116,223,246,158,-6,-173,-281,-303,-245,-133,-25,-2,-118,-348,-594,-754,-780,-687,-524,-349,-206,-108,-44,2,34,49,53,58,61,43,-7,-76,-149,-231,-350,-518,-711,-876,-957,-919,-768,-562,-386,-302,-309,-358,-401,-406,-359,-253,-104,42,135,158,132,88,43,5,-15,-18,-19,-30,-50,-71,-96,-133,-179,-218,-238,-240,-234,-231,-239,-261,-287,-300,-284,-237,-176,-125,-100,-98,-107,-119,-134,-146,-145,-128,-106,-86,-64,-37,-19,-23,-41,-52,-48,-39,-30,-19,-6,-2,-8,-17,-23,-31,-44,-59,-69,-77,-86,-92,-94,-97,-104,-106,-98,-88,-87,-91,-94,-97,-105,-108,-95,-75,-70,-79,-73,-39},
            {32,9,-21,1,36,6,-51,-24,55,34,-70,-60,80,97,-81,-134,91,188,-117,-162,1030,3344,5606,7086,7806,6882,2126,-6806,-15356,-16596,-8118,4662,13325,14102,9905,5743,3965,4004,4680,5248,5082,3948,2611,2051,1855,333,-3248,-7275,-9298,-8572,-6491,-4818,-4236,-4534,-5274,-5812,-5335,-3624,-1597,-484,-473,-613,-96,914,1843,2528,3071,3295,2922,2194,1768,1917,2246,2297,2057,1669,1051,143,-700,-995,-747,-426,-328,-304,-179,-139,-490,-1221,-2032,-2674,-3063,-3135,-2816,-2177,-1459,-868,-413,10,418,711,808,760,713,753,833,867,867,924,1038,1054,834,448,106,-75,-151,-228,-337,-458,-574,-655,-666,-633,-658,-801,-973,-1009,-847,-584,-366,-269,-283,-341,-354,-263,-102,8,-39,-246,-521,-757,-892,-916,-852,-731,-567,-360,-127,86,236,315,340,323,277,230,213,217,199,132,39,-35,-63,-55,-26,0,-17,-115,-278,-441,-542,-564,-523,-432,-299,-151,-31,31,36,0,-66,-146,-218,-266,-285,-276,-233,-156,-61,32,105,142,127,59,-39,-135,-210,-249,-239,-178,-96,-30,0,-3,-40,-114,-209,-287,-321,-306,-252,-171,-80,1,57,84,79,35,-45,-139,-222,-273,-279,-238,-165,-82,-7,52,80,52,-36,-152,-248,-294,-288,-239,-161,-73,6,64,91,78,26,-43,-104,-146,-170,-174,-153,-118,-86,-61,-39,-35,-65,-109,-115,-63}
        },
        {    // H70e120a.wav
            {-4,-7,-3,2,1,-2,0,2,-1,-4,-3,-3,-6,-4,6,9,-1,-5,5,7,-10,-18,3,18,-7,-32,-5,33,7,-41,-7,66,26,-67,124,795,1682,2399,2888,3084,2251,-579,-5010,-8570,-8424,-4040,2151,6859,8446,7463,5416,3553,2530,2442,2850,3113,2984,2767,2724,2542,1656,21,-1709,-2817,-3131,-2956,-2647,-2420,-2416,-2668,-2975,-3002,-2615,-2031,-1563,-1295,-1089,-826,-492,-65,499,1098,1457,1392,1060,823,887,1144,1360,1386,1193,825,399,89,0,70,126,42,-198,-525,-822,-966,-929,-838,-861,-1008,-1111,-1031,-823,-646,-560,-489,-351,-155,42,204,307,316,218,61,-75,-131,-96,11,146,251,283,241,153,43,-82,-204,-280,-268,-175,-68,-36,-133,-336,-564,-721,-752,-661,-510,-378,-305,-275,-237,-160,-59,29,86,114,117,92,46,-13,-89,-199,-348,-511,-653,-749,-785,-752,-657,-543,-463,-441,-460,-483,-481,-434,-328,-175,-26,63,87,89,107,129,127,91,43,3,-27,-53,-79,-107,-147,-198,-240,-250,-232,-213,-217,-245,-282,-312,-324,-309,-269,-212,-153,-105,-75,-67,-80,-107,-139,-163,-170,-154,-122,-86,-52,-24,-11,-23,-55,-85,-94,-80,-57,-40,-32,-32,-37,-43,-47,-51,-58,-66,-70,-73,-81,-91,-93,-84,-73,-67,-63,-58,-57,-62,-64,-60,-62,-81,-102,-105,-96,-95,-102,-89,-46},
            {16,27,3,-16,8,28,-8,-45,-3,55,11,-71,-28,87,55,-99,-82,127,125,-168,-4,1377,3645,5735,7053,7363,5485,-236,-8891,-15409,-14123,-4649,6925,13478,12956,8729,5069,3619,3749,4449,4994,4798,3803,2758,2270,1662,-406,-4012,-7370,-8556,-7428,-5481,-4172,-3929,-4468,-5289,-5692,-4998,-3263,-1484,-641,-668,-692,-156,736,1608,2388,3006,3121,2564,1811,1554,1888,2278,2286,1963,1485,836,66,-496,-582,-373,-244,-248,-157,36,-24,-600,-1519,-2388,-2965,-3180,-2982,-2393,-1652,-1080,-761,-492,-85,376,661,691,618,617,702,765,758,746,788,824,736,515,272,114,44,6,-40,-125,-283,-492,-648,-665,-597,-583,-677,-795,-831,-765,-638,-487,-353,-288,-298,-302,-220,-85,-20,-110,-320,-558,-757,-886,-920,-845,-682,-479,-279,-100,53,176,261,296,282,244,215,213,221,205,154,82,13,-34,-47,-29,-11,-41,-140,-284,-421,-512,-543,-512,-423,-292,-154,-49,4,5,-34,-99,-170,-225,-255,-263,-251,-215,-149,-62,26,93,122,106,49,-34,-124,-197,-233,-217,-159,-90,-39,-17,-26,-70,-143,-224,-282,-300,-278,-224,-150,-69,1,49,69,59,15,-56,-138,-207,-244,-241,-202,-140,-73,-12,38,61,38,-32,-127,-214,-268,-275,-234,-155,-64,10,52,64,51,13,-47,-114,-163,-178,-167,-147,-122,-85,-42,-21,-43,-84,-93,-52}
        },
        {    // H70e135a.wav
            {-6,-1,1,-1,-1,2,0,-5,-6,-2,-2,-6,-2,8,7,-4,-4,7,3,-16,-14,12,13,-22,-31,13,34,-16,-49,16,71,-13,-58,309,1157,2117,2862,3336,3203,1492,-2378,-7055,-9468,-7337,-1457,4838,8471,8704,6816,4510,2884,2317,2594,3082,3213,2986,2805,2759,2337,1044,-873,-2562,-3375,-3347,-2937,-2549,-2403,-2593,-3026,-3350,-3201,-2587,-1904,-1513,-1400,-1294,-1001,-497,173,916,1502,1678,1455,1159,1105,1287,1459,1452,1288,1037,722,384,130,24,2,-60,-218,-432,-632,-762,-809,-828,-904,-1046,-1152,-1126,-1001,-885,-807,-697,-507,-285,-100,41,159,235,228,147,48,-22,-34,43,220,431,548,490,286,42,-147,-235,-217,-131,-51,-50,-147,-304,-469,-607,-694,-705,-628,-495,-376,-323,-331,-352,-335,-261,-142,-8,100,143,111,36,-34,-80,-130,-228,-383,-554,-672,-688,-597,-451,-335,-317,-402,-522,-594,-575,-477,-341,-209,-110,-48,-1,57,119,151,130,76,24,-7,-26,-46,-76,-121,-177,-228,-248,-229,-192,-171,-186,-229,-277,-311,-319,-298,-254,-199,-148,-112,-91,-80,-78,-88,-113,-147,-172,-178,-166,-138,-96,-49,-16,-15,-41,-72,-87,-82,-71,-67,-69,-71,-69,-63,-56,-49,-47,-54,-69,-85,-95,-101,-105,-104,-90,-64,-39,-23,-14,-11,-20,-42,-67,-81,-87,-93,-94,-86,-80,-94,-115,-105,-54},
            {-9,11,28,10,-16,-1,26,3,-38,-15,43,24,-55,-44,61,69,-64,-97,75,138,-100,-109,890,2869,4946,6390,6875,5499,799,-6904,-13619,-13975,-6421,4528,12094,13077,9548,5559,3430,3153,3839,4642,4845,4183,3189,2545,1947,256,-2902,-6194,-7751,-7056,-5281,-3914,-3567,-4040,-4862,-5427,-5081,-3679,-1960,-936,-829,-944,-595,217,1123,1945,2620,2888,2531,1845,1466,1653,2042,2169,1949,1525,959,308,-194,-328,-198,-83,-61,3,98,-39,-589,-1407,-2199,-2771,-3006,-2790,-2163,-1448,-1003,-852,-693,-315,151,450,524,521,560,616,619,574,541,541,538,496,416,318,222,152,137,165,143,-30,-331,-592,-655,-539,-409,-410,-550,-737,-863,-854,-694,-457,-270,-205,-217,-209,-150,-99,-125,-244,-430,-640,-819,-906,-870,-735,-553,-368,-205,-75,21,97,163,211,230,225,217,221,230,219,177,114,48,-2,-27,-35,-52,-108,-215,-349,-466,-525,-514,-449,-355,-252,-161,-93,-58,-59,-91,-140,-189,-223,-235,-226,-198,-155,-100,-37,27,78,96,66,-5,-93,-172,-224,-232,-197,-135,-76,-42,-39,-61,-107,-170,-230,-264,-260,-223,-165,-98,-33,15,39,36,7,-43,-104,-161,-204,-225,-214,-167,-98,-30,18,40,32,-8,-75,-150,-209,-239,-233,-188,-113,-35,15,27,15,-7,-43,-94,-143,-170,-170,-153,-120,-75,-36,-27,-43,-50,-30}
        },
        {    // H70e150a.wav
            {1,-2,-2,2,2,-4,-6,-3,-3,-7,-2,10,10,-3,-6,7,9,-13,-21,6,20,-13,-37,1,39,-2,-56,-8,74,17,-85,170,996,2100,3058,3699,3719,2197,-1630,-6711,-9944,-8508,-2617,4397,8867,9477,7444,4806,2957,2327,2635,3191,3379,3142,2896,2815,2435,1173,-854,-2779,-3783,-3763,-3214,-2689,-2502,-2740,-3253,-3639,-3491,-2797,-1996,-1539,-1456,-1436,-1206,-709,2,816,1495,1760,1587,1302,1262,1483,1702,1725,1561,1264,845,383,64,-5,58,37,-158,-450,-725,-903,-943,-874,-827,-926,-1134,-1275,-1233,-1060,-867,-696,-532,-383,-263,-144,15,179,249,172,11,-107,-82,103,380,631,745,684,492,250,31,-117,-178,-172,-140,-119,-141,-243,-439,-682,-859,-874,-731,-534,-395,-349,-351,-341,-295,-225,-150,-83,-29,6,13,-9,-57,-137,-253,-388,-499,-546,-520,-440,-337,-249,-218,-266,-363,-439,-440,-375,-293,-232,-193,-159,-122,-80,-28,33,81,87,45,-16,-67,-104,-140,-179,-210,-220,-208,-180,-148,-129,-141,-182,-234,-274,-293,-286,-253,-205,-159,-128,-107,-87,-71,-71,-91,-125,-164,-196,-207,-187,-141,-90,-55,-43,-53,-74,-91,-93,-82,-68,-61,-64,-75,-86,-86,-73,-55,-47,-53,-65,-80,-101,-123,-132,-121,-98,-71,-41,-10,7,2,-18,-42,-66,-92,-108,-105,-89,-75,-68,-66,-74,-100,-124,-110,-55},
            {0,-8,-1,20,21,-4,-12,13,20,-17,-36,10,42,-9,-59,-1,75,15,-94,-32,123,52,-163,149,1468,3395,5114,6142,5991,3467,-2315,-9588,-13699,-10745,-1705,7861,12607,11558,7658,4268,2791,2931,3834,4603,4584,3828,3021,2501,1586,-615,-3780,-6311,-6886,-5730,-4175,-3315,-3372,-4037,-4830,-5133,-4451,-2963,-1559,-986,-1087,-1109,-604,264,1175,1985,2537,2568,2069,1510,1397,1707,1994,1955,1654,1244,763,275,-48,-119,-48,23,85,133,21,-407,-1096,-1815,-2360,-2606,-2473,-2004,-1457,-1129,-1038,-916,-574,-131,178,303,368,454,512,487,403,315,255,246,302,384,419,379,315,290,295,262,138,-66,-284,-429,-443,-358,-292,-362,-581,-837,-975,-909,-681,-416,-229,-159,-167,-187,-180,-156,-159,-237,-406,-619,-788,-844,-783,-654,-508,-375,-265,-173,-90,-7,66,116,146,182,240,297,308,254,160,74,31,31,49,45,-20,-153,-316,-445,-500,-492,-458,-414,-359,-295,-228,-163,-105,-67,-64,-96,-143,-183,-205,-205,-186,-150,-101,-42,21,67,72,25,-57,-148,-223,-261,-245,-182,-106,-54,-33,-33,-53,-97,-155,-204,-225,-220,-196,-150,-87,-25,14,21,4,-30,-76,-125,-167,-192,-192,-164,-114,-57,-9,20,25,1,-44,-91,-126,-149,-166,-170,-152,-117,-82,-61,-53,-50,-52,-60,-75,-94,-114,-130,-130,-108,-70,-33,-10,-1}
        },
        {    // H70e165a.wav
            {-2,3,3,-5,-8,-2,0,-5,-2,11,12,-4,-8,8,11,-13,-22,8,23,-14,-40,3,47,0,-64,-12,82,19,-102,171,1097,2370,3502,4240,4185,2335,-2017,-7539,-10768,-8770,-2078,5458,9876,10002,7442,4543,2753,2361,2895,3535,3651,3277,2928,2783,2278,767,-1532,-3561,-4421,-4129,-3372,-2794,-2671,-3010,-3612,-4023,-3778,-2880,-1884,-1364,-1353,-1428,-1210,-630,194,1074,1719,1858,1551,1229,1266,1585,1825,1803,1620,1376,1024,559,151,-35,-49,-63,-161,-319,-538,-836,-1135,-1287,-1251,-1157,-1141,-1202,-1226,-1131,-928,-687,-486,-363,-282,-168,4,161,206,119,-26,-125,-99,73,344,613,780,799,678,458,205,-2,-97,-84,-34,-34,-136,-342,-598,-802,-869,-797,-676,-596,-570,-544,-470,-348,-217,-121,-77,-72,-75,-71,-80,-131,-230,-351,-462,-543,-575,-539,-435,-300,-190,-142,-153,-192,-224,-229,-206,-164,-112,-61,-27,-24,-46,-68,-69,-48,-27,-32,-74,-144,-217,-274,-300,-290,-253,-204,-158,-126,-112,-115,-133,-163,-199,-231,-244,-233,-206,-177,-155,-135,-108,-74,-45,-39,-65,-119,-183,-231,-240,-206,-146,-89,-51,-41,-52,-75,-99,-113,-114,-107,-101,-96,-86,-68,-49,-37,-36,-47,-66,-89,-108,-121,-127,-126,-112,-82,-45,-13,4,3,-16,-49,-84,-108,-118,-117,-108,-89,-66,-58,-72,-88,-89,-85,-98,-117,-105,-54},
            {-12,-3,0,-6,0,17,14,-9,-11,12,12,-22,-28,15,30,-23,-53,11,64,-8,-89,-6,114,10,-148,257,1537,3249,4718,5556,5192,2439,-3247,-9760,-12709,-9041,-339,8154,11977,10686,7025,3897,2531,2713,3630,4356,4296,3621,2986,2560,1612,-556,-3454,-5608,-5993,-4959,-3676,-3019,-3144,-3793,-4531,-4777,-4110,-2768,-1577,-1141,-1252,-1242,-754,65,957,1770,2293,2276,1790,1333,1335,1680,1914,1812,1513,1189,836,438,117,-11,11,62,77,11,-226,-699,-1318,-1864,-2141,-2081,-1776,-1436,-1258,-1235,-1153,-842,-401,-67,72,135,233,329,338,264,164,76,34,90,250,421,509,515,499,460,351,186,51,-11,-56,-145,-260,-350,-421,-523,-676,-829,-907,-864,-710,-499,-307,-191,-153,-158,-169,-174,-180,-212,-296,-440,-609,-735,-763,-683,-538,-398,-308,-258,-202,-117,-29,28,63,116,195,258,258,200,125,68,41,47,71,70,-7,-163,-341,-470,-523,-515,-467,-397,-323,-264,-220,-176,-126,-82,-64,-74,-102,-141,-183,-213,-214,-183,-130,-70,-16,14,10,-28,-92,-169,-237,-266,-239,-171,-100,-52,-30,-29,-51,-93,-141,-176,-194,-198,-183,-143,-87,-40,-18,-18,-29,-50,-82,-118,-148,-164,-162,-140,-100,-54,-14,6,3,-16,-45,-77,-108,-132,-148,-152,-144,-131,-120,-114,-106,-92,-76,-68,-72,-83,-93,-98,-97,-85,-60,-27}
        },
        {    // H70e180a.wav
            {3,-6,-8,-1,0,-6,-1,14,13,-5,-8,11,12,-17,-24,13,27,-18,-44,10,55,-6,-74,-4,98,10,-122,233,1340,2823,4114,4893,4641,2248,-2848,-8824,-11731,-8685,-886,7071,11045,10323,7127,4088,2538,2494,3272,3968,3982,3451,2968,2682,1929,57,-2547,-4608,-5184,-4487,-3460,-2860,-2890,-3409,-4086,-4405,-3942,-2824,-1734,-1251,-1289,-1319,-986,-313,543,1418,2031,2083,1643,1222,1254,1624,1878,1796,1539,1278,977,584,219,35,6,-12,-88,-214,-430,-800,-1262,-1610,-1685,-1530,-1339,-1270,-1302,-1269,-1033,-641,-300,-160,-159,-116,40,209,261,176,28,-86,-90,47,282,514,662,711,669,531,318,113,3,-8,8,-22,-132,-323,-554,-745,-829,-816,-771,-726,-657,-540,-403,-290,-208,-147,-113,-112,-122,-124,-145,-237,-406,-586,-692,-685,-587,-451,-325,-239,-190,-157,-122,-87,-58,-26,23,85,130,129,87,33,0,-1,17,21,-20,-116,-242,-356,-427,-447,-420,-357,-276,-205,-158,-131,-108,-90,-89,-111,-143,-170,-187,-199,-205,-196,-164,-113,-59,-24,-18,-40,-84,-143,-204,-240,-229,-179,-120,-75,-46,-32,-41,-75,-117,-144,-154,-154,-143,-117,-82,-56,-43,-36,-32,-38,-59,-86,-112,-135,-150,-143,-109,-60,-15,15,22,5,-31,-70,-103,-131,-151,-152,-131,-98,-76,-71,-76,-86,-98,-105,-97,-84,-83,-90,-78,-39},
            {3,-6,-8,-1,0,-6,-1,14,13,-5,-8,11,12,-17,-24,13,27,-18,-44,10,55,-6,-74,-4,98,10,-122,233,1340,2823,4114,4893,4641,2248,-2848,-8824,-11731,-8685,-886,7071,11045,10323,7127,4088,2538,2494,3272,3968,3982,3451,2968,2682,1929,57,-2547,-4608,-5184,-4487,-3460,-2860,-2890,-3409,-4086,-4405,-3942,-2824,-1734,-1251,-1289,-1319,-986,-313,543,1418,2031,2083,1643,1222,1254,1624,1878,1796,1539,1278,977,584,219,35,6,-12,-88,-214,-430,-800,-1262,-1610,-1685,-1530,-1339,-1270,-1302,-1269,-1033,-641,-300,-160,-159,-116,40,209,261,176,28,-86,-90,47,282,514,662,711,669,531,318,113,3,-8,8,-22,-132,-323,-554,-745,-829,-816,-771,-726,-657,-540,-403,-290,-208,-147,-113,-112,-122,-124,-145,-237,-406,-586,-692,-685,-587,-451,-325,-239,-190,-157,-122,-87,-58,-26,23,85,130,129,87,33,0,-1,17,21,-20,-116,-242,-356,-427,-447,-420,-357,-276,-205,-158,-131,-108,-90,-89,-111,-143,-170,-187,-199,-205,-196,-164,-113,-59,-24,-18,-40,-84,-143,-204,-240,-229,-179,-120,-75,-46,-32,-41,-75,-117,-144,-154,-154,-143,-117,-82,-56,-43,-36,-32,-38,-59,-86,-112,-135,-150,-143,-109,-60,-15,15,22,5,-31,-70,-103,-131,-151,-152,-131,-98,-76,-71,-76,-86,-98,-105,-97,-84,-83,-90,-78,-39}
        }
    },
    {    // elev80
        {    // H80e000a.wav
            {16,18,-5,-12,16,22,-22,-39,18,52,-16,-72,8,100,15,-116,-26,155,48,-162,310,1714,3191,3989,4575,5391,4875,566,-6965,-12708,-11472,-3433,5786,10619,10106,7052,4316,2981,3022,3987,4897,4711,3470,2300,1854,1316,-466,-3279,-5651,-6510,-6092,-5208,-4309,-3578,-3340,-3738,-4199,-3834,-2507,-1069,-334,-183,56,642,1252,1638,1935,2240,2315,1970,1457,1180,1174,1173,1071,982,870,496,-143,-641,-657,-338,-77,-11,-4,-9,-156,-487,-854,-1155,-1460,-1808,-2035,-1961,-1640,-1290,-1030,-805,-548,-280,-41,195,470,752,944,983,919,880,949,1069,1083,898,557,170,-192,-500,-707,-766,-685,-528,-352,-197,-135,-244,-515,-815,-977,-931,-727,-479,-295,-226,-240,-251,-193,-78,27,75,74,50,15,-38,-128,-265,-445,-636,-789,-854,-801,-632,-398,-199,-132,-221,-398,-549,-583,-478,-277,-63,86,136,116,82,69,67,43,-14,-81,-125,-131,-108,-79,-67,-86,-124,-142,-122,-82,-66,-95,-155,-226,-298,-363,-395,-376,-314,-237,-163,-105,-82,-112,-188,-277,-345,-370,-336,-241,-113,1,70,90,71,21,-45,-100,-122,-113,-84,-41,14,70,116,144,145,103,18,-81,-156,-193,-205,-202,-183,-149,-107,-72,-56,-70,-116,-178,-228,-253,-258,-247,-210,-144,-66,-4,31,41,27,-13,-72,-138,-197,-230,-220,-163,-76,15,93,146,157,118,52},
            {16,18,-5,-12,16,22,-22,-39,18,52,-16,-72,8,100,15,-116,-26,155,48,-162,310,1714,3191,3989,4575,5391,4875,566,-6965,-12708,-11472,-3433,5786,10619,10106,7052,4316,2981,3022,3987,4897,4711,3470,2300,1854,1316,-466,-3279,-5651,-6510,-6092,-5208,-4309,-3578,-3340,-3738,-4199,-3834,-2507,-1069,-334,-183,56,642,1252,1638,1935,2240,2315,1970,1457,1180,1174,1173,1071,982,870,496,-143,-641,-657,-338,-77,-11,-4,-9,-156,-487,-854,-1155,-1460,-1808,-2035,-1961,-1640,-1290,-1030,-805,-548,-280,-41,195,470,752,944,983,919,880,949,1069,1083,898,557,170,-192,-500,-707,-766,-685,-528,-352,-197,-135,-244,-515,-815,-977,-931,-727,-479,-295,-226,-240,-251,-193,-78,27,75,74,50,15,-38,-128,-265,-445,-636,-789,-854,-801,-632,-398,-199,-132,-221,-398,-549,-583,-478,-277,-63,86,136,116,82,69,67,43,-14,-81,-125,-131,-108,-79,-67,-86,-124,-142,-122,-82,-66,-95,-155,-226,-298,-363,-395,-376,-314,-237,-163,-105,-82,-112,-188,-277,-345,-370,-336,-241,-113,1,70,90,71,21,-45,-100,-122,-113,-84,-41,14,70,116,144,145,103,18,-81,-156,-193,-205,-202,-183,-149,-107,-72,-56,-70,-116,-178,-228,-253,-258,-247,-210,-144,-66,-4,31,41,27,-13,-72,-138,-197,-230,-220,-163,-76,15,93,146,157,118,52}
        },
        {    // H80e030a.wav
            {-6,0,18,17,-6,-9,17,18,-20,-27,23,41,-23,-56,23,86,-4,-99,3,138,13,-119,421,1710,2931,3533,3993,4514,3508,-993,-7895,-12409,-10253,-2227,6374,10785,10373,7556,4728,2960,2538,3239,4128,4152,3283,2475,2211,1706,-7,-2639,-4857,-5737,-5477,-4741,-3920,-3230,-3004,-3365,-3805,-3565,-2508,-1300,-598,-372,-172,215,670,1120,1626,2078,2166,1808,1363,1206,1282,1290,1157,1043,946,643,91,-395,-513,-337,-148,-62,-19,-30,-204,-542,-910,-1226,-1525,-1794,-1903,-1770,-1485,-1194,-931,-649,-353,-101,90,267,456,624,722,740,717,727,829,979,1039,889,552,163,-167,-419,-604,-704,-696,-599,-468,-364,-334,-402,-544,-698,-788,-765,-623,-410,-219,-133,-148,-173,-124,-7,102,144,117,51,-18,-68,-98,-139,-238,-409,-613,-785,-862,-804,-619,-383,-219,-213,-351,-531,-643,-637,-522,-336,-131,42,148,182,160,100,18,-64,-120,-131,-101,-49,3,38,38,-2,-63,-113,-135,-145,-166,-202,-238,-263,-284,-310,-336,-337,-294,-216,-137,-93,-98,-142,-209,-279,-325,-320,-260,-166,-71,6,53,60,25,-34,-82,-98,-82,-44,6,57,97,122,135,134,107,48,-26,-91,-139,-173,-193,-193,-173,-142,-115,-107,-121,-152,-185,-208,-215,-210,-192,-157,-106,-50,-7,14,16,7,-5,-14,-22,-35,-55,-73,-77,-60,-27,4,18,12},
            {12,-13,1,27,0,-44,-11,57,24,-72,-46,86,80,-90,-108,112,156,-130,-30,1183,3023,4369,5161,6184,6688,3850,-3602,-11842,-14256,-8118,2218,9623,10811,7922,4764,3271,3389,4427,5451,5390,3974,2289,1509,1245,-28,-2835,-5806,-7220,-6822,-5670,-4695,-4084,-3821,-3998,-4357,-4158,-2992,-1424,-384,-54,188,789,1479,1854,2019,2294,2575,2442,1836,1214,981,1075,1209,1218,1012,475,-311,-913,-933,-490,-85,-5,-93,-116,-100,-205,-480,-877,-1360,-1848,-2154,-2135,-1875,-1586,-1353,-1094,-743,-355,-2,327,661,949,1095,1061,915,794,804,934,1037,947,631,213,-153,-393,-522,-568,-537,-425,-241,-45,31,-139,-541,-967,-1166,-1056,-779,-549,-470,-486,-467,-342,-153,-3,42,13,-15,-6,9,-23,-124,-285,-478,-668,-809,-852,-771,-579,-335,-132,-59,-149,-340,-502,-517,-365,-131,66,165,184,170,158,148,124,66,-35,-154,-236,-237,-174,-106,-76,-73,-64,-42,-31,-61,-137,-234,-315,-356,-363,-351,-321,-263,-183,-114,-82,-81,-87,-98,-139,-219,-310,-359,-335,-248,-138,-46,10,30,21,-15,-66,-108,-126,-117,-87,-44,10,71,131,173,175,125,33,-69,-151,-198,-215,-209,-185,-146,-103,-69,-60,-85,-137,-195,-238,-260,-263,-246,-217,-191,-176,-156,-117,-72,-42,-31,-17,14,50,79,105,127,122,73,3,-46,-64,-70,-74,-63,-31}
        },
        {    // H80e060a.wav
            {-5,-8,-6,9,16,0,-13,3,19,-4,-30,-4,35,8,-49,-22,59,42,-66,-60,81,87,-88,59,950,2180,3004,3411,3846,3647,923,-4857,-10652,-11739,-6354,2269,8935,10959,9321,6416,3917,2558,2525,3308,3830,3469,2737,2425,2331,1438,-661,-3098,-4679,-5045,-4640,-3951,-3233,-2783,-2891,-3382,-3586,-3036,-2007,-1152,-744,-534,-251,105,491,1000,1615,2014,1900,1449,1153,1227,1413,1411,1240,1046,802,406,-42,-307,-329,-267,-229,-166,-72,-102,-369,-767,-1110,-1362,-1593,-1776,-1792,-1612,-1342,-1063,-747,-367,-8,220,323,405,528,640,656,576,500,532,671,804,801,622,329,8,-284,-510,-632,-638,-558,-444,-343,-309,-389,-570,-760,-851,-806,-663,-476,-283,-127,-54,-58,-68,-14,89,166,164,105,45,16,10,-5,-66,-197,-401,-642,-847,-934,-858,-655,-436,-316,-345,-482,-637,-726,-709,-590,-404,-194,3,155,235,225,136,13,-83,-112,-84,-29,26,66,75,45,-14,-77,-124,-159,-193,-225,-242,-242,-241,-260,-304,-352,-374,-347,-273,-179,-106,-85,-119,-185,-249,-279,-264,-215,-151,-85,-26,12,15,-11,-43,-60,-60,-46,-21,14,48,72,87,95,89,60,10,-43,-90,-131,-169,-193,-193,-171,-141,-119,-114,-128,-152,-173,-182,-181,-175,-162,-136,-97,-56,-27,-17,-21,-28,-32,-29,-23,-19,-25,-44,-67,-76,-60,-27},
            {-17,16,32,-17,-56,0,65,7,-88,-32,105,63,-118,-93,145,133,-178,55,1497,3516,5008,6043,7258,7432,3572,-4954,-13360,-14812,-7443,3335,10187,10521,7242,4338,3411,3980,5092,5794,5245,3516,1844,1216,934,-581,-3608,-6536,-7655,-6910,-5536,-4539,-4108,-4115,-4418,-4584,-3994,-2585,-1108,-302,-35,349,1037,1590,1758,1901,2363,2818,2679,1942,1228,1019,1203,1406,1403,1083,378,-530,-1137,-1073,-561,-166,-145,-256,-208,-56,-63,-377,-950,-1624,-2184,-2421,-2295,-1983,-1681,-1395,-1011,-516,-29,356,655,895,1029,1001,842,671,613,712,889,980,861,555,199,-99,-319,-465,-503,-405,-211,-13,91,14,-289,-744,-1138,-1263,-1101,-831,-650,-605,-604,-540,-380,-173,1,83,78,41,18,2,-55,-187,-382,-585,-729,-767,-693,-547,-389,-274,-226,-242,-289,-320,-297,-220,-120,-27,53,125,176,183,140,80,39,20,-5,-58,-126,-180,-205,-208,-196,-171,-129,-78,-50,-78,-170,-290,-382,-412,-390,-332,-245,-132,-26,30,25,-13,-63,-137,-243,-354,-416,-402,-326,-215,-95,7,66,73,34,-40,-130,-206,-229,-185,-97,2,89,151,179,173,140,81,-8,-120,-222,-282,-300,-286,-241,-169,-90,-32,-5,-17,-82,-205,-347,-449,-483,-457,-377,-231,-29,171,313,371,335,205,15,-159,-254,-268,-223,-131,-7,99,148,151,126,42,-129,-302,-330,-182}
        },
        {    // H80e090a.wav
            {-5,-3,-7,-3,11,13,-4,-9,10,14,-14,-24,12,31,-15,-50,4,62,6,-76,-14,103,30,-99,256,1279,2399,3064,3465,3745,2762,-1081,-7131,-11548,-10355,-3512,4792,9978,10634,8387,5486,3290,2360,2665,3457,3722,3215,2641,2522,2310,1077,-1159,-3329,-4473,-4556,-4092,-3462,-2881,-2657,-2976,-3490,-3525,-2820,-1825,-1133,-849,-669,-376,13,499,1139,1775,2023,1718,1219,1040,1274,1562,1582,1337,974,553,121,-183,-260,-212,-207,-254,-237,-160,-190,-440,-830,-1214,-1530,-1766,-1860,-1735,-1406,-988,-605,-330,-171,-73,64,290,534,668,632,502,412,437,549,650,640,491,260,33,-150,-291,-387,-416,-387,-353,-358,-394,-439,-501,-596,-704,-772,-760,-661,-491,-293,-129,-47,-28,-4,67,153,200,191,152,106,59,14,-27,-83,-193,-381,-619,-832,-939,-895,-727,-529,-408,-418,-532,-667,-746,-725,-600,-394,-157,53,192,241,207,121,31,-19,-15,22,64,95,107,88,31,-51,-132,-194,-233,-254,-262,-265,-270,-285,-312,-344,-361,-338,-269,-181,-114,-93,-114,-162,-218,-258,-262,-227,-169,-110,-59,-21,-6,-18,-43,-55,-44,-23,-7,2,10,22,37,52,61,52,20,-28,-79,-122,-155,-176,-183,-177,-160,-135,-114,-102,-100,-104,-111,-117,-122,-124,-119,-98,-65,-35,-27,-39,-55,-60,-58,-55,-50,-45,-52,-79,-106,-97,-50},
            {-13,26,23,-36,-48,27,59,-30,-87,17,112,-4,-146,-19,185,31,-216,389,2152,4155,5572,6750,7787,6654,830,-8384,-14887,-13041,-3700,6326,10895,9545,6062,3818,3542,4400,5393,5628,4597,2832,1574,1214,597,-1523,-4683,-7040,-7393,-6271,-4987,-4259,-4059,-4219,-4550,-4559,-3718,-2178,-778,-132,19,296,834,1317,1640,2047,2572,2788,2386,1679,1266,1339,1589,1674,1465,927,112,-677,-1006,-783,-414,-313,-429,-413,-157,57,-91,-645,-1408,-2106,-2512,-2528,-2249,-1874,-1509,-1122,-673,-206,219,591,883,1004,907,687,523,514,634,795,902,866,657,344,42,-183,-335,-412,-378,-227,-25,127,136,-55,-433,-872,-1171,-1206,-1034,-830,-724,-709,-691,-585,-381,-145,36,115,116,93,65,5,-117,-294,-487,-640,-700,-639,-489,-338,-269,-297,-366,-399,-352,-233,-95,-5,6,-25,-35,2,60,110,155,195,194,112,-34,-173,-256,-293,-309,-290,-203,-69,37,42,-61,-218,-358,-434,-430,-361,-260,-162,-89,-46,-29,-27,-36,-64,-120,-203,-289,-349,-361,-321,-237,-132,-42,12,26,9,-37,-110,-188,-229,-209,-140,-52,33,105,156,176,154,93,3,-102,-201,-278,-321,-324,-278,-185,-72,19,53,12,-102,-259,-405,-481,-468,-387,-263,-99,95,267,349,311,176,-9,-188,-302,-309,-226,-110,-1,96,167,167,81,-36,-126,-200,-294,-365,-322,-161}
        },
        {    // H80e120a.wav
            {-3,-4,-5,6,17,8,-9,-2,17,7,-23,-14,27,22,-34,-39,34,55,-34,-74,39,108,-36,-67,539,1702,2748,3346,3763,3706,1672,-3318,-9278,-11831,-8161,-71,7514,10878,9937,6964,4128,2497,2289,3058,3820,3799,3180,2722,2577,1969,252,-2116,-3981,-4651,-4345,-3658,-3026,-2716,-2898,-3427,-3759,-3414,-2511,-1634,-1174,-1001,-790,-419,83,735,1502,2093,2150,1710,1246,1161,1386,1581,1554,1328,937,402,-117,-380,-344,-229,-223,-265,-219,-135,-220,-567,-1061,-1524,-1843,-1943,-1767,-1358,-895,-579,-469,-457,-373,-126,229,526,624,526,371,302,365,510,650,689,565,310,43,-118,-150,-125,-129,-204,-337,-468,-521,-467,-371,-353,-479,-693,-864,-880,-720,-463,-231,-106,-71,-49,8,76,113,120,128,147,156,135,84,0,-132,-317,-526,-709,-817,-822,-732,-590,-474,-446,-513,-627,-720,-736,-644,-449,-202,14,133,149,110,73,68,85,102,103,92,82,79,70,36,-28,-107,-176,-220,-239,-243,-251,-280,-333,-389,-414,-390,-322,-235,-156,-106,-93,-112,-150,-191,-219,-222,-199,-161,-119,-79,-46,-29,-37,-60,-76,-71,-52,-33,-18,-5,6,14,22,30,27,3,-38,-81,-113,-134,-150,-159,-156,-141,-119,-98,-82,-75,-77,-85,-94,-100,-101,-93,-77,-58,-44,-38,-41,-48,-54,-57,-60,-70,-85,-98,-105,-106,-97,-70,-31},
            {-13,9,29,-6,-48,-12,53,22,-69,-46,76,75,-83,-109,93,150,-118,-84,1009,2896,4592,5795,6859,6965,3731,-3714,-11715,-14125,-8305,1784,9303,10765,7970,4738,3244,3463,4497,5366,5228,3957,2447,1645,1240,-42,-2696,-5559,-7000,-6599,-5299,-4211,-3772,-3915,-4396,-4741,-4347,-3069,-1552,-617,-380,-275,126,694,1187,1683,2289,2714,2556,1921,1402,1386,1674,1854,1751,1371,710,-124,-755,-841,-509,-238,-286,-440,-391,-175,-116,-449,-1119,-1866,-2398,-2534,-2295,-1873,-1458,-1119,-820,-508,-142,295,719,954,899,676,521,542,660,757,789,739,575,309,41,-139,-235,-293,-301,-211,-38,125,181,78,-187,-555,-891,-1050,-1002,-866,-784,-789,-797,-714,-522,-277,-58,82,136,128,87,26,-61,-184,-341,-500,-609,-619,-526,-383,-271,-248,-310,-399,-436,-372,-228,-81,-3,-3,-27,-20,30,94,145,171,164,115,22,-94,-201,-271,-292,-262,-190,-99,-28,-6,-49,-146,-265,-358,-391,-364,-308,-245,-174,-93,-26,-1,-14,-43,-76,-128,-206,-288,-338,-338,-290,-206,-108,-28,11,10,-18,-65,-130,-192,-216,-185,-115,-35,37,95,131,139,119,70,-6,-100,-190,-254,-281,-267,-214,-137,-58,-2,22,11,-47,-149,-263,-345,-373,-347,-274,-166,-46,58,133,172,157,76,-46,-151,-202,-201,-162,-85,16,98,129,122,95,26,-100,-219,-232,-125}
        },
        {    // H80e150a.wav
            {-7,-8,10,21,3,-14,3,21,-3,-32,-5,38,13,-46,-24,57,42,-65,-61,83,95,-92,10,867,2176,3221,3845,4261,3743,636,-5257,-10788,-11416,-5644,3114,9573,11047,8712,5357,2948,2114,2640,3724,4311,3929,3124,2647,2341,1298,-852,-3286,-4802,-4979,-4303,-3461,-2884,-2813,-3300,-3961,-4091,-3329,-2114,-1246,-1045,-1131,-985,-452,331,1205,1979,2357,2176,1699,1410,1499,1705,1710,1472,1116,694,228,-154,-322,-337,-365,-414,-344,-146,-56,-295,-818,-1389,-1815,-2005,-1911,-1547,-1070,-717,-606,-628,-567,-305,84,408,515,415,265,227,340,525,678,735,674,514,315,145,29,-57,-140,-224,-310,-393,-435,-388,-273,-204,-299,-555,-832,-969,-899,-678,-430,-262,-203,-197,-168,-86,25,123,173,160,100,37,11,13,-18,-147,-373,-622,-788,-793,-645,-445,-325,-356,-499,-652,-723,-674,-515,-301,-111,-7,13,11,42,98,128,105,52,15,11,26,35,21,-21,-80,-128,-138,-113,-90,-114,-195,-302,-393,-438,-425,-362,-273,-191,-135,-107,-97,-102,-126,-169,-217,-248,-247,-215,-164,-109,-59,-21,-7,-23,-55,-80,-89,-87,-81,-65,-31,13,49,61,47,13,-32,-78,-114,-137,-152,-160,-160,-147,-123,-93,-67,-56,-62,-77,-90,-98,-103,-104,-92,-66,-38,-19,-13,-15,-21,-31,-45,-65,-92,-122,-143,-143,-118,-77,-35,-7,2},
            {18,-11,-11,20,17,-28,-31,29,41,-35,-63,32,87,-24,-114,17,153,-14,-164,461,1981,3614,4775,5670,6042,4114,-1583,-9051,-13027,-9681,-806,7621,10931,9207,5703,3251,2668,3440,4620,5191,4596,3290,2267,1766,889,-1188,-3957,-5970,-6324,-5392,-4183,-3435,-3386,-3931,-4601,-4659,-3697,-2170,-1026,-709,-782,-596,-20,673,1338,2005,2502,2499,2006,1513,1444,1699,1889,1822,1538,1042,324,-384,-710,-573,-302,-220,-287,-287,-209,-265,-598,-1140,-1714,-2153,-2319,-2138,-1692,-1204,-876,-743,-675,-494,-121,338,663,720,601,519,577,698,771,760,678,517,287,57,-99,-175,-209,-212,-175,-114,-49,15,60,2,-242,-613,-912,-985,-872,-742,-707,-732,-711,-594,-402,-189,0,131,179,144,58,-35,-117,-205,-322,-459,-571,-609,-552,-419,-277,-211,-270,-409,-514,-487,-335,-154,-36,-7,-28,-43,-10,78,187,251,213,75,-97,-225,-274,-267,-238,-198,-139,-65,-5,7,-45,-149,-270,-361,-385,-340,-256,-176,-128,-117,-129,-140,-132,-109,-100,-125,-185,-260,-313,-313,-252,-160,-79,-34,-18,-18,-34,-70,-119,-158,-172,-154,-105,-33,40,89,99,77,34,-18,-71,-121,-168,-208,-226,-204,-148,-81,-25,7,5,-37,-106,-171,-207,-211,-188,-145,-92,-50,-32,-32,-43,-71,-123,-187,-231,-225,-170,-87,-6,50,71,68,57,40,8,-28,-43,-26}
        },
        {    // H80e180a.wav
            {5,20,9,-12,-1,24,6,-33,-17,37,27,-44,-43,50,66,-49,-90,57,129,-63,-92,665,2092,3418,4284,4910,4782,2170,-3691,-10110,-12159,-7320,1612,8941,11102,8878,5360,2927,2259,2965,4154,4778,4318,3273,2512,2082,1098,-1024,-3623,-5381,-5628,-4789,-3735,-3084,-3077,-3645,-4325,-4403,-3526,-2153,-1146,-891,-1004,-905,-400,371,1246,2051,2481,2328,1821,1484,1566,1818,1879,1678,1320,829,224,-290,-477,-388,-304,-347,-356,-216,-105,-290,-791,-1390,-1867,-2114,-2074,-1740,-1244,-830,-658,-664,-638,-428,-58,297,469,441,352,360,494,662,765,767,668,492,294,136,34,-44,-127,-208,-279,-334,-333,-224,-51,13,-175,-559,-903,-1010,-888,-693,-561,-516,-497,-436,-312,-148,12,130,182,161,88,4,-65,-124,-209,-337,-483,-591,-612,-536,-406,-309,-318,-431,-559,-601,-519,-356,-190,-82,-45,-50,-46,1,83,151,157,92,-7,-86,-118,-113,-106,-118,-142,-153,-137,-106,-85,-95,-139,-207,-273,-309,-299,-259,-221,-205,-202,-189,-163,-140,-135,-148,-176,-221,-273,-298,-265,-181,-90,-31,-6,2,-6,-35,-76,-109,-123,-117,-97,-62,-12,39,69,62,24,-26,-74,-117,-157,-191,-206,-191,-152,-102,-54,-19,-10,-32,-75,-115,-139,-147,-141,-115,-72,-28,-5,-5,-16,-27,-41,-65,-100,-136,-163,-175,-172,-155,-128,-99,-77,-58,-37,-16},
            {5,20,9,-12,-1,24,6,-33,-17,37,27,-44,-43,50,66,-49,-90,57,129,-63,-92,665,2092,3418,4284,4910,4782,2170,-3691,-10110,-12159,-7320,1612,8941,11102,8878,5360,2927,2259,2965,4154,4778,4318,3273,2512,2082,1098,-1024,-3623,-5381,-5628,-4789,-3735,-3084,-3077,-3645,-4325,-4403,-3526,-2153,-1146,-891,-1004,-905,-400,371,1246,2051,2481,2328,1821,1484,1566,1818,1879,1678,1320,829,224,-290,-477,-388,-304,-347,-356,-216,-105,-290,-791,-1390,-1867,-2114,-2074,-1740,-1244,-830,-658,-664,-638,-428,-58,297,469,441,352,360,494,662,765,767,668,492,294,136,34,-44,-127,-208,-279,-334,-333,-224,-51,13,-175,-559,-903,-1010,-888,-693,-561,-516,-497,-436,-312,-148,12,130,182,161,88,4,-65,-124,-209,-337,-483,-591,-612,-536,-406,-309,-318,-431,-559,-601,-519,-356,-190,-82,-45,-50,-46,1,83,151,157,92,-7,-86,-118,-113,-106,-118,-142,-153,-137,-106,-85,-95,-139,-207,-273,-309,-299,-259,-221,-205,-202,-189,-163,-140,-135,-148,-176,-221,-273,-298,-265,-181,-90,-31,-6,2,-6,-35,-76,-109,-123,-117,-97,-62,-12,39,69,62,24,-26,-74,-117,-157,-191,-206,-191,-152,-102,-54,-19,-10,-32,-75,-115,-139,-147,-141,-115,-72,-28,-5,-5,-16,-27,-41,-65,-100,-136,-163,-175,-172,-155,-128,-99,-77,-58,-37,-16}
        }
    },
    {    // elev90
        {    // H90e000a.wav
            {9,-29,-20,32,30,-36,-45,39,68,-35,-86,42,124,-41,-78,629,2025,3387,4373,5310,5867,4248,-908,-7718,-11448,-8750,-1191,6097,9085,7740,4795,2795,2582,3620,4812,5159,4376,3091,2139,1560,580,-1326,-3639,-5262,-5588,-4910,-3949,-3285,-3186,-3602,-4106,-4084,-3267,-2060,-1136,-724,-477,-42,509,939,1274,1707,2168,2303,1960,1439,1143,1155,1260,1239,986,465,-218,-742,-784,-369,138,417,457,395,260,-27,-484,-1035,-1584,-2039,-2277,-2214,-1903,-1496,-1102,-745,-430,-184,-4,167,357,509,545,479,421,476,649,842,932,868,677,421,146,-107,-285,-362,-373,-372,-348,-250,-97,-20,-141,-452,-816,-1074,-1128,-969,-690,-453,-358,-347,-272,-85,105,161,75,-51,-125,-138,-121,-98,-95,-149,-276,-446,-591,-652,-608,-488,-360,-305,-365,-509,-646,-678,-564,-335,-76,116,189,159,93,51,41,33,1,-56,-124,-186,-221,-215,-171,-112,-54,4,58,85,54,-47,-196,-348,-452,-467,-388,-254,-119,-21,22,-4,-106,-268,-441,-566,-606,-554,-425,-251,-73,66,135,124,52,-32,-76,-61,-10,45,92,136,171,184,172,138,80,-9,-116,-209,-262,-277,-270,-250,-221,-185,-147,-115,-99,-108,-139,-173,-197,-207,-200,-170,-117,-53,5,49,71,63,28,-17,-58,-95,-128,-142,-123,-76,-21,31,70,75,37,-22,-68,-99,-133,-159,-140,-70},
            {9,-29,-20,32,30,-36,-45,39,68,-35,-86,42,124,-41,-78,629,2025,3387,4373,5310,5867,4248,-908,-7718,-11448,-8750,-1191,6097,9085,7740,4795,2795,2582,3620,4812,5159,4376,3091,2139,1560,580,-1326,-3639,-5262,-5588,-4910,-3949,-3285,-3186,-3602,-4106,-4084,-3267,-2060,-1136,-724,-477,-42,509,939,1274,1707,2168,2303,1960,1439,1143,1155,1260,1239,986,465,-218,-742,-784,-369,138,417,457,395,260,-27,-484,-1035,-1584,-2039,-2277,-2214,-1903,-1496,-1102,-745,-430,-184,-4,167,357,509,545,479,421,476,649,842,932,868,677,421,146,-107,-285,-362,-373,-372,-348,-250,-97,-20,-141,-452,-816,-1074,-1128,-969,-690,-453,-358,-347,-272,-85,105,161,75,-51,-125,-138,-121,-98,-95,-149,-276,-446,-591,-652,-608,-488,-360,-305,-365,-509,-646,-678,-564,-335,-76,116,189,159,93,51,41,33,1,-56,-124,-186,-221,-215,-171,-112,-54,4,58,85,54,-47,-196,-348,-452,-467,-388,-254,-119,-21,22,-4,-106,-268,-441,-566,-606,-554,-425,-251,-73,66,135,124,52,-32,-76,-61,-10,45,92,136,171,184,172,138,80,-9,-116,-209,-262,-277,-270,-250,-221,-185,-147,-115,-99,-108,-139,-173,-197,-207,-200,-170,-117,-53,5,49,71,63,28,-17,-58,-95,-128,-142,-123,-76,-21,31,70,75,37,-22,-68,-99,-133,-159,-140,-70}
        }
    }
};
