# Use these commands to generate the LAMMPS input script and data file


# Create LAMMPS input files this way:
cd moltemplate_files

  # Then create a "system.lt" with these coordinates
  # The "-helix 0.0" parameter represents the twist-per-monomer (Δφ) at the
  # start of the simulation.  It is proportional to the "supercoil-density" (σ)
  # The formula for the twist-per-monomer which is:
  #    Δφ = 360*σ*(B/10.5)     (in degrees)
  # where B is the number of base pairs per monomer, and 10.5 is the
  # natural period of DNA twist in the relaxed state in base-pairs.
  # Example:
  #   genpoly_lt.py -helix 102.857  (calculated using the formula above)

  genpoly_lt.py -helix 102.7797 \
                -bond Backbone a a \
                -bond Backbone b b \
                -dihedral MajorGroove b b a a 0 1 1 2 \
                -dihedral Torsion a a b b 1 0 0 1 \
                -polymer-name 'Polymer' \
                -inherits 'DNAForceField'  \
                -monomer-name 'DNAMonomer.scale(1,1,1)' \
                -header 'import "dnamonomer.lt"' \
		-box 20,20,20 \
                < init_crds_polymer_backbone.raw > polymer.lt

  # Run moltemplate

  moltemplate.sh system.lt

  # This will generate various files with names ending in *.in* and *.data. 
  # These files are the input files directly read by LAMMPS.  Move them to 
  # the parent directory (or wherever you plan to run the simulation).
  mv -f system.in* system.data ../

  # Optional:
  # The "./output_ttree/" directory is full of temporary files generated by 
  # moltemplate.  They can be useful for debugging, but are usually thrown away.
  rm -rf output_ttree/

cd ../

