# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.containerservicefleet import ContainerServiceFleetMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-containerservicefleet
# USAGE
    python update_runs_create_or_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ContainerServiceFleetMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.update_runs.begin_create_or_update(
        resource_group_name="rg1",
        fleet_name="fleet1",
        update_run_name="run1",
        resource={
            "properties": {
                "managedClusterUpdate": {
                    "nodeImageSelection": {"type": "Latest"},
                    "upgrade": {"kubernetesVersion": "1.26.1", "type": "Full"},
                },
                "strategy": {
                    "stages": [
                        {
                            "afterGates": [{"displayName": "gate after stage1", "type": "Approval"}],
                            "afterStageWaitInSeconds": 3600,
                            "beforeGates": [{"displayName": "gate before stage1", "type": "Approval"}],
                            "groups": [
                                {
                                    "afterGates": [{"displayName": "gate after group-a", "type": "Approval"}],
                                    "beforeGates": [{"displayName": "gate before group-a", "type": "Approval"}],
                                    "name": "group-a",
                                }
                            ],
                            "name": "stage1",
                        }
                    ]
                },
                "updateStrategyId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ContainerService/fleets/myFleet/updateStrategies/strategy1",
            }
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-08-01-preview/UpdateRuns_CreateOrUpdate.json
if __name__ == "__main__":
    main()
