# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterAssessmentsMetadataOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_assessments_metadata_list(self, resource_group):
        response = self.client.assessments_metadata.list(
            api_version="2025-05-04-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_assessments_metadata_get(self, resource_group):
        response = self.client.assessments_metadata.get(
            assessment_metadata_name="str",
            api_version="2025-05-04-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_assessments_metadata_list_by_subscription(self, resource_group):
        response = self.client.assessments_metadata.list_by_subscription(
            api_version="2025-05-04-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_assessments_metadata_get_in_subscription(self, resource_group):
        response = self.client.assessments_metadata.get_in_subscription(
            assessment_metadata_name="str",
            api_version="2025-05-04-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_assessments_metadata_create_in_subscription(self, resource_group):
        response = self.client.assessments_metadata.create_in_subscription(
            assessment_metadata_name="str",
            assessment_metadata={
                "assessmentType": "str",
                "categories": ["str"],
                "description": "str",
                "displayName": "str",
                "id": "str",
                "implementationEffort": "str",
                "name": "str",
                "partnerData": {"partnerName": "str", "secret": "str", "productName": "str"},
                "plannedDeprecationDate": "str",
                "policyDefinitionId": "str",
                "preview": bool,
                "publishDates": {"public": "str", "GA": "str"},
                "remediationDescription": "str",
                "severity": "str",
                "tactics": ["str"],
                "techniques": ["str"],
                "threats": ["str"],
                "type": "str",
                "userImpact": "str",
            },
            api_version="2025-05-04-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_assessments_metadata_delete_in_subscription(self, resource_group):
        response = self.client.assessments_metadata.delete_in_subscription(
            assessment_metadata_name="str",
            api_version="2025-05-04-preview",
        )

        # please add some check logic here by yourself
        # ...
