# 2025-10-06 Triage Log

Largely a positive week. Big win coming from avoiding unnecessary work for debug log in [#147293](https://github.com/rust-lang/rust/pull/147293), and another one for rustdoc from optimized span representation for highlighter [#147189](https://github.com/rust-lang/rust/pull/147189). Lots of noisy results otherwise.

Triage done by **@panstromek**.
Revision range: [8d72d3e1..1a3cdd34](https://perf.rust-lang.org/?start=8d72d3e1e96f58ca10059a6bb6e8aecba4a0e9cd&end=1a3cdd34629306fa67624eaa60d73687e7fcf855&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 2.0%]    | 10    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.0%, 0.8%]    | 50    |
| Improvements ✅ <br /> (primary)   | -1.3% | [-5.3%, -0.2%]  | 147   |
| Improvements ✅ <br /> (secondary) | -1.3% | [-12.7%, -0.1%] | 111   |
| All ❌✅ (primary)                 | -1.2% | [-5.3%, 2.0%]   | 157   |


6 Regressions, 3 Improvements, 6 Mixed; 8 of them in rollups
40 artifact comparisons made in total

#### Regressions

Rollup of 7 pull requests [#147140](https://github.com/rust-lang/rust/pull/147140) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=772f380092b30680313b70a622cafc17f03e6bff&end=7af913fc90968844286e5ff6675ab66afa98cdc6&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.1%, 0.3%] | 6     |
| Regressions ❌ <br /> (secondary)  | 0.2% | [0.0%, 0.4%] | 2     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.1%, 0.3%] | 6     |

Based on perf runs on respective PRs, this seems to be https://github.com/rust-lang/rust/pull/133477. https://github.com/rust-lang/rust/pull/147092 was tested but regressions on that are noise and don't match this PR. Other PR's don't touch benchmarked code.

This could also be noise, since the results somewhat fit a bimodal pattern and changes are tiny, but detailed results show increases in number of executed visibility related queries.

Rollup of 5 pull requests [#147186](https://github.com/rust-lang/rust/pull/147186) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a2db9280539229a3b8a084a09886670a57bc7e9c&end=42d009c0a9be0f7020a03f85dd47faa00d6d7bdf&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.0% | [3.0%, 3.0%] | 1     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 3.0% | [3.0%, 3.0%] | 1     |

`clap_derive` bimodal noise

Turn ProjectionElem::Subtype into CastKind::Subtype [#147055](https://github.com/rust-lang/rust/pull/147055) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3369e82c6bc03c5cdb66f730dba6f738b74c8e1d&end=42b384ec0dfcd528d99a4db0a337d9188a9eecaa&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.0% | [3.0%, 3.0%] | 1     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 3.0% | [3.0%, 3.0%] | 1     |

`clap_derive` bimodal noise

Rollup of 9 pull requests [#147261](https://github.com/rust-lang/rust/pull/147261) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4b9c62b4da3e17cee99d3d2052f1c576b188e2a8&end=94ecb52bbeeccc990545d4ebc9e9c35dcaf285e3&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.8% | [2.8%, 2.8%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.1% | [0.1%, 0.1%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 2.8% | [2.8%, 2.8%] | 1     |

`clap_derive` bimodal noise and something that looks like optimization shuffling in `coercions` (most of the changes are in the backend). This is a small change in secondary benchmark, so I don't think this is worth more investigation.

Extending `#[rustc_force_inline]` to be applicable to inherent methods [#147231](https://github.com/rust-lang/rust/pull/147231) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5c7ae0c7ed184c603e5224604a9f33ca0e8e0b36&end=8d603ef2879fd263f8e9aea340b4c035ed7973db&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.1% | [3.1%, 3.1%] | 1     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 3.1% | [3.1%, 3.1%] | 1     |

`clap_derive` bimodal noise

don't make empty ident when printing `'` ident from `extern "'"` [#147377](https://github.com/rust-lang/rust/pull/147377) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=828c2a9afccf3b3ff8133368cfbc8bfe526aaa4d&end=1a3cdd34629306fa67624eaa60d73687e7fcf855&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 0.9% | [0.8%, 1.0%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |

Perf results are noise. Looks like `wg-grammar` became bimodal recently.

#### Improvements

Rollup of 11 pull requests [#147220](https://github.com/rust-lang/rust/pull/147220) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1e1a39441bd11aba541a48ba714d939490fc7b85&end=d4ae855111df8c7ee255bea4c112e74b7d72cf45&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.1%]    | 1     |
| Improvements ✅ <br /> (primary)   | -1.3% | [-5.4%, -0.2%]  | 19    |
| Improvements ✅ <br /> (secondary) | -3.8% | [-12.6%, -0.2%] | 13    |
| All ❌✅ (primary)                 | -1.3% | [-5.4%, -0.2%]  | 19    |


Test: Ambigious bindings in same namespace with the same res [#147196](https://github.com/rust-lang/rust/pull/147196) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=94ecb52bbeeccc990545d4ebc9e9c35dcaf285e3&end=5c7ae0c7ed184c603e5224604a9f33ca0e8e0b36&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.9% | [-2.9%, -2.9%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -2.9% | [-2.9%, -2.9%] | 1     |


Rollup of 6 pull requests [#147282](https://github.com/rust-lang/rust/pull/147282) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8d603ef2879fd263f8e9aea340b4c035ed7973db&end=3b8665c5ab3aeced9b01672404c3764583e722ca&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.9% | [-2.9%, -2.9%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -2.9% | [-2.9%, -2.9%] | 1     |


#### Mixed

Rollup of 6 pull requests [#147197](https://github.com/rust-lang/rust/pull/147197) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=42d009c0a9be0f7020a03f85dd47faa00d6d7bdf&end=fa3155a644dd62e865825087b403646be01d4cef&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -1.5% | [-2.9%, -0.4%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.2%, -0.3%] | 5     |
| All ❌✅ (primary)                 | -1.5% | [-2.9%, -0.4%] | 3     |

Improvements outweigh regressions. `coercions` regression also looks like noise.

Split Bound index into Canonical and Bound [#147138](https://github.com/rust-lang/rust/pull/147138) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=42b384ec0dfcd528d99a4db0a337d9188a9eecaa&end=4b9c62b4da3e17cee99d3d2052f1c576b188e2a8&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.1%, 0.4%]   | 7     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.2%]   | 11    |
| Improvements ✅ <br /> (primary)   | -1.0% | [-2.8%, -0.1%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-1.1%, -0.0%] | 11    |
| All ❌✅ (primary)                 | -0.3% | [-2.8%, 0.4%]  | 11    |

Improvements outweigh regressions, but some of those improvements are noise (clap-derive and syn). Main regressions match pre-merge results, so I assume this was deemed acceptable as a part of work on new solver, but I don't see any explicit justification.

Introduce debuginfo to statements in MIR [#142771](https://github.com/rust-lang/rust/pull/142771) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=dd091003ace19d9556c647d87f7a9cd1e8dcc17e&end=8b6b15b877fbceb1ee5d9a5a4746e7515901574a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.1%, 2.0%]   | 9     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.1%, 0.9%]   | 43    |
| Improvements ✅ <br /> (primary)   | -0.3% | [-1.2%, -0.1%] | 101   |
| Improvements ✅ <br /> (secondary) | -0.3% | [-1.0%, -0.1%] | 102   |
| All ❌✅ (primary)                 | -0.3% | [-1.2%, 2.0%]  | 110   |

Improvements outweigh regressions. Some secondary regressions are just noise (`wg-grammar`), the biggest meaningful change seems to be `diesel` opt, as mentioned in https://github.com/rust-lang/rust/pull/142771#issuecomment-3367798805, due to more inlining, `syn` seems to be a similar case.

Rollup of 10 pull requests [#147340](https://github.com/rust-lang/rust/pull/147340) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=99ca0ae87ba5571acee116ea83d1f9e88a7bf8d8&end=2cb4e7dce84fdebc0279159f1082f92b99299d87&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.1%  | [0.1%, 0.1%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.1%, 0.3%]   | 12    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.0%, -0.8%] | 6     |
| All ❌✅ (primary)                 | 0.1%  | [0.1%, 0.1%]   | 2     |

Non-doc changes are mostly noise. Doc changes are not super clear to me. Even hello-world changed a tiny bit, so maybe this is just caused by the number of std changes? Some of those changes also mirror https://github.com/rust-lang/rust/pull/142771 dip, so it could also be noise.

Either way, all doc changes are small and mostly secondary, I think we don't need to look more deeply into it.

Avoid getting `dep_dep_node` unnecessarily. [#147293](https://github.com/rust-lang/rust/pull/147293) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2cb4e7dce84fdebc0279159f1082f92b99299d87&end=227ac7c3cd486872d5c2352b3df02b571500e53a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.8%, 1.0%]   | 6     |
| Improvements ✅ <br /> (primary)   | -1.3% | [-3.5%, -0.2%] | 115   |
| Improvements ✅ <br /> (secondary) | -1.1% | [-2.6%, -0.2%] | 61    |
| All ❌✅ (primary)                 | -1.3% | [-3.5%, -0.2%] | 115   |

`wg-grammar` regressions are noise, this is clearly a win otherwise.

Rollup of 7 pull requests [#147363](https://github.com/rust-lang/rust/pull/147363) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=227ac7c3cd486872d5c2352b3df02b571500e53a&end=e2c96cc06bdbdbc6f59c7551194d6a742260d6ff&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.6%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.6%, -0.0%] | 4     |
| All ❌✅ (primary)                 | -0.5% | [-1.6%, -0.2%] | 6     |


Improvements outweigh a small regression in secondary stress test.
