/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;

public class LabelMover
extends ObjectConstructor {
    ConstructionObject P;
    ObjectConstructor OC;
    int X;
    int Y;
    double OX;
    double OY;

    public LabelMover(ObjectConstructor objectConstructor, ZirkelCanvas zirkelCanvas, int n, int n2, ConstructionObject constructionObject, boolean bl) {
        this.OC = objectConstructor;
        this.P = constructionObject;
        if (bl || !this.P.canKeepClose()) {
            this.X = n;
            this.Y = n2;
            this.P.setKeepClose(false);
            this.OX = this.P.xcOffset();
            this.OY = this.P.ycOffset();
        } else {
            this.P.setKeepClose(zirkelCanvas.x(n), zirkelCanvas.y(n2));
        }
        if (this.P != null) {
            this.P.setLabelSelected(true);
            zirkelCanvas.repaint();
            this.showStatus(zirkelCanvas);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
    }

    public void mouseDragged(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (this.P == null) {
            return;
        }
        if (this.P.isKeepClose()) {
            this.P.setKeepClose(zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
        } else {
            this.P.setcOffset(this.OX + zirkelCanvas.dx(mouseEvent.getX() - this.X), this.OY + zirkelCanvas.dy(this.Y - mouseEvent.getY()));
        }
        zirkelCanvas.validate();
        zirkelCanvas.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (this.P == null) {
            return;
        }
        this.P.setLabelSelected(false);
        zirkelCanvas.repaint();
        this.P = null;
        this.showStatus(zirkelCanvas);
        zirkelCanvas.setTool(this.OC);
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.clearSelected();
        this.P.setLabelSelected(false);
        zirkelCanvas.repaint();
    }

    public void resetPoint() {
        if (this.P != null) {
            this.P.setKeepClose(false);
            this.P.setcOffset(0.0, 0.0);
        }
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.P == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.label.select", "Move Label: Select a label"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.label.move", "Move Label: Move the label"));
        }
    }

    public boolean useSmartBoard() {
        return false;
    }
}

